-- MySQL dump 10.13  Distrib 5.6.27, for Linux (x86_64)
--
-- Host: localhost    Database: sprucelo_moodle30
-- ------------------------------------------------------
-- Server version	5.6.27

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `mdl_assign`
--

DROP TABLE IF EXISTS `mdl_assign`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assign` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8_unicode_ci NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `alwaysshowdescription` tinyint(2) NOT NULL DEFAULT '0',
  `nosubmissions` tinyint(2) NOT NULL DEFAULT '0',
  `submissiondrafts` tinyint(2) NOT NULL DEFAULT '0',
  `sendnotifications` tinyint(2) NOT NULL DEFAULT '0',
  `sendlatenotifications` tinyint(2) NOT NULL DEFAULT '0',
  `duedate` bigint(10) NOT NULL DEFAULT '0',
  `allowsubmissionsfromdate` bigint(10) NOT NULL DEFAULT '0',
  `grade` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `requiresubmissionstatement` tinyint(2) NOT NULL DEFAULT '0',
  `completionsubmit` tinyint(2) NOT NULL DEFAULT '0',
  `cutoffdate` bigint(10) NOT NULL DEFAULT '0',
  `teamsubmission` tinyint(2) NOT NULL DEFAULT '0',
  `requireallteammemberssubmit` tinyint(2) NOT NULL DEFAULT '0',
  `teamsubmissiongroupingid` bigint(10) NOT NULL DEFAULT '0',
  `blindmarking` tinyint(2) NOT NULL DEFAULT '0',
  `revealidentities` tinyint(2) NOT NULL DEFAULT '0',
  `attemptreopenmethod` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'none',
  `maxattempts` mediumint(6) NOT NULL DEFAULT '-1',
  `markingworkflow` tinyint(2) NOT NULL DEFAULT '0',
  `markingallocation` tinyint(2) NOT NULL DEFAULT '0',
  `sendstudentnotifications` tinyint(2) NOT NULL DEFAULT '1',
  `preventsubmissionnotingroup` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assi_cou_ix` (`course`),
  KEY `mdl_assi_tea_ix` (`teamsubmissiongroupingid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='This table saves information about an instance of mod_assign';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assign`
--

LOCK TABLES `mdl_assign` WRITE;
/*!40000 ALTER TABLE `mdl_assign` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assign` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assign_grades`
--

DROP TABLE IF EXISTS `mdl_assign_grades`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assign_grades` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `grader` bigint(10) NOT NULL DEFAULT '0',
  `grade` decimal(10,5) DEFAULT '0.00000',
  `attemptnumber` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_assigrad_assuseatt_uix` (`assignment`,`userid`,`attemptnumber`),
  KEY `mdl_assigrad_use_ix` (`userid`),
  KEY `mdl_assigrad_att_ix` (`attemptnumber`),
  KEY `mdl_assigrad_ass_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Grading information about a single assignment submission.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assign_grades`
--

LOCK TABLES `mdl_assign_grades` WRITE;
/*!40000 ALTER TABLE `mdl_assign_grades` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assign_grades` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assign_plugin_config`
--

DROP TABLE IF EXISTS `mdl_assign_plugin_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assign_plugin_config` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `plugin` varchar(28) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `subtype` varchar(28) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(28) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_assiplugconf_plu_ix` (`plugin`),
  KEY `mdl_assiplugconf_sub_ix` (`subtype`),
  KEY `mdl_assiplugconf_nam_ix` (`name`),
  KEY `mdl_assiplugconf_ass_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Config data for an instance of a plugin in an assignment.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assign_plugin_config`
--

LOCK TABLES `mdl_assign_plugin_config` WRITE;
/*!40000 ALTER TABLE `mdl_assign_plugin_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assign_plugin_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assign_submission`
--

DROP TABLE IF EXISTS `mdl_assign_submission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assign_submission` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `status` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `attemptnumber` bigint(10) NOT NULL DEFAULT '0',
  `latest` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_assisubm_assusegroatt_uix` (`assignment`,`userid`,`groupid`,`attemptnumber`),
  KEY `mdl_assisubm_use_ix` (`userid`),
  KEY `mdl_assisubm_att_ix` (`attemptnumber`),
  KEY `mdl_assisubm_assusegrolat_ix` (`assignment`,`userid`,`groupid`,`latest`),
  KEY `mdl_assisubm_ass_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='This table keeps information about student interactions with';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assign_submission`
--

LOCK TABLES `mdl_assign_submission` WRITE;
/*!40000 ALTER TABLE `mdl_assign_submission` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assign_submission` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assign_user_flags`
--

DROP TABLE IF EXISTS `mdl_assign_user_flags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assign_user_flags` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `locked` bigint(10) NOT NULL DEFAULT '0',
  `mailed` smallint(4) NOT NULL DEFAULT '0',
  `extensionduedate` bigint(10) NOT NULL DEFAULT '0',
  `workflowstate` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `allocatedmarker` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assiuserflag_mai_ix` (`mailed`),
  KEY `mdl_assiuserflag_use_ix` (`userid`),
  KEY `mdl_assiuserflag_ass_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='List of flags that can be set for a single user in a single ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assign_user_flags`
--

LOCK TABLES `mdl_assign_user_flags` WRITE;
/*!40000 ALTER TABLE `mdl_assign_user_flags` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assign_user_flags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assign_user_mapping`
--

DROP TABLE IF EXISTS `mdl_assign_user_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assign_user_mapping` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assiusermapp_ass_ix` (`assignment`),
  KEY `mdl_assiusermapp_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Map an assignment specific id number to a user';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assign_user_mapping`
--

LOCK TABLES `mdl_assign_user_mapping` WRITE;
/*!40000 ALTER TABLE `mdl_assign_user_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assign_user_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignfeedback_comments`
--

DROP TABLE IF EXISTS `mdl_assignfeedback_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignfeedback_comments` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `grade` bigint(10) NOT NULL DEFAULT '0',
  `commenttext` longtext COLLATE utf8_unicode_ci,
  `commentformat` smallint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assicomm_ass_ix` (`assignment`),
  KEY `mdl_assicomm_gra_ix` (`grade`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Text feedback for submitted assignments';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignfeedback_comments`
--

LOCK TABLES `mdl_assignfeedback_comments` WRITE;
/*!40000 ALTER TABLE `mdl_assignfeedback_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignfeedback_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignfeedback_editpdf_annot`
--

DROP TABLE IF EXISTS `mdl_assignfeedback_editpdf_annot`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignfeedback_editpdf_annot` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `gradeid` bigint(10) NOT NULL DEFAULT '0',
  `pageno` bigint(10) NOT NULL DEFAULT '0',
  `x` bigint(10) DEFAULT '0',
  `y` bigint(10) DEFAULT '0',
  `endx` bigint(10) DEFAULT '0',
  `endy` bigint(10) DEFAULT '0',
  `path` longtext COLLATE utf8_unicode_ci,
  `type` varchar(10) COLLATE utf8_unicode_ci DEFAULT 'line',
  `colour` varchar(10) COLLATE utf8_unicode_ci DEFAULT 'black',
  `draft` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `mdl_assieditanno_grapag_ix` (`gradeid`,`pageno`),
  KEY `mdl_assieditanno_gra_ix` (`gradeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='stores annotations added to pdfs submitted by students';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignfeedback_editpdf_annot`
--

LOCK TABLES `mdl_assignfeedback_editpdf_annot` WRITE;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_annot` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_annot` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignfeedback_editpdf_cmnt`
--

DROP TABLE IF EXISTS `mdl_assignfeedback_editpdf_cmnt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignfeedback_editpdf_cmnt` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `gradeid` bigint(10) NOT NULL DEFAULT '0',
  `x` bigint(10) DEFAULT '0',
  `y` bigint(10) DEFAULT '0',
  `width` bigint(10) DEFAULT '120',
  `rawtext` longtext COLLATE utf8_unicode_ci,
  `pageno` bigint(10) NOT NULL DEFAULT '0',
  `colour` varchar(10) COLLATE utf8_unicode_ci DEFAULT 'black',
  `draft` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `mdl_assieditcmnt_grapag_ix` (`gradeid`,`pageno`),
  KEY `mdl_assieditcmnt_gra_ix` (`gradeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Stores comments added to pdfs';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignfeedback_editpdf_cmnt`
--

LOCK TABLES `mdl_assignfeedback_editpdf_cmnt` WRITE;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_cmnt` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_cmnt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignfeedback_editpdf_quick`
--

DROP TABLE IF EXISTS `mdl_assignfeedback_editpdf_quick`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignfeedback_editpdf_quick` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `rawtext` longtext COLLATE utf8_unicode_ci NOT NULL,
  `width` bigint(10) NOT NULL DEFAULT '120',
  `colour` varchar(10) COLLATE utf8_unicode_ci DEFAULT 'yellow',
  PRIMARY KEY (`id`),
  KEY `mdl_assieditquic_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Stores teacher specified quicklist comments';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignfeedback_editpdf_quick`
--

LOCK TABLES `mdl_assignfeedback_editpdf_quick` WRITE;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_quick` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_quick` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignfeedback_file`
--

DROP TABLE IF EXISTS `mdl_assignfeedback_file`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignfeedback_file` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `grade` bigint(10) NOT NULL DEFAULT '0',
  `numfiles` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assifile_ass2_ix` (`assignment`),
  KEY `mdl_assifile_gra_ix` (`grade`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Stores info about the number of files submitted by a student';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignfeedback_file`
--

LOCK TABLES `mdl_assignfeedback_file` WRITE;
/*!40000 ALTER TABLE `mdl_assignfeedback_file` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignfeedback_file` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignment`
--

DROP TABLE IF EXISTS `mdl_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignment` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8_unicode_ci NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `assignmenttype` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `resubmit` tinyint(2) NOT NULL DEFAULT '0',
  `preventlate` tinyint(2) NOT NULL DEFAULT '0',
  `emailteachers` tinyint(2) NOT NULL DEFAULT '0',
  `var1` bigint(10) DEFAULT '0',
  `var2` bigint(10) DEFAULT '0',
  `var3` bigint(10) DEFAULT '0',
  `var4` bigint(10) DEFAULT '0',
  `var5` bigint(10) DEFAULT '0',
  `maxbytes` bigint(10) NOT NULL DEFAULT '100000',
  `timedue` bigint(10) NOT NULL DEFAULT '0',
  `timeavailable` bigint(10) NOT NULL DEFAULT '0',
  `grade` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assi_cou2_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Defines assignments';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignment`
--

LOCK TABLES `mdl_assignment` WRITE;
/*!40000 ALTER TABLE `mdl_assignment` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignment_submissions`
--

DROP TABLE IF EXISTS `mdl_assignment_submissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignment_submissions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `numfiles` bigint(10) NOT NULL DEFAULT '0',
  `data1` longtext COLLATE utf8_unicode_ci,
  `data2` longtext COLLATE utf8_unicode_ci,
  `grade` bigint(11) NOT NULL DEFAULT '0',
  `submissioncomment` longtext COLLATE utf8_unicode_ci NOT NULL,
  `format` smallint(4) NOT NULL DEFAULT '0',
  `teacher` bigint(10) NOT NULL DEFAULT '0',
  `timemarked` bigint(10) NOT NULL DEFAULT '0',
  `mailed` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assisubm_use2_ix` (`userid`),
  KEY `mdl_assisubm_mai_ix` (`mailed`),
  KEY `mdl_assisubm_tim_ix` (`timemarked`),
  KEY `mdl_assisubm_ass2_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Info about submitted assignments';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignment_submissions`
--

LOCK TABLES `mdl_assignment_submissions` WRITE;
/*!40000 ALTER TABLE `mdl_assignment_submissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignment_submissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignment_upgrade`
--

DROP TABLE IF EXISTS `mdl_assignment_upgrade`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignment_upgrade` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `oldcmid` bigint(10) NOT NULL DEFAULT '0',
  `oldinstance` bigint(10) NOT NULL DEFAULT '0',
  `newcmid` bigint(10) NOT NULL DEFAULT '0',
  `newinstance` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assiupgr_old_ix` (`oldcmid`),
  KEY `mdl_assiupgr_old2_ix` (`oldinstance`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Info about upgraded assignments';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignment_upgrade`
--

LOCK TABLES `mdl_assignment_upgrade` WRITE;
/*!40000 ALTER TABLE `mdl_assignment_upgrade` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignment_upgrade` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignsubmission_file`
--

DROP TABLE IF EXISTS `mdl_assignsubmission_file`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignsubmission_file` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `submission` bigint(10) NOT NULL DEFAULT '0',
  `numfiles` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assifile_ass_ix` (`assignment`),
  KEY `mdl_assifile_sub_ix` (`submission`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Info about file submissions for assignments';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignsubmission_file`
--

LOCK TABLES `mdl_assignsubmission_file` WRITE;
/*!40000 ALTER TABLE `mdl_assignsubmission_file` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignsubmission_file` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignsubmission_onlinetext`
--

DROP TABLE IF EXISTS `mdl_assignsubmission_onlinetext`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignsubmission_onlinetext` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `submission` bigint(10) NOT NULL DEFAULT '0',
  `onlinetext` longtext COLLATE utf8_unicode_ci,
  `onlineformat` smallint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assionli_ass_ix` (`assignment`),
  KEY `mdl_assionli_sub_ix` (`submission`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Info about onlinetext submission';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignsubmission_onlinetext`
--

LOCK TABLES `mdl_assignsubmission_onlinetext` WRITE;
/*!40000 ALTER TABLE `mdl_assignsubmission_onlinetext` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignsubmission_onlinetext` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_backup_controllers`
--

DROP TABLE IF EXISTS `mdl_backup_controllers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_backup_controllers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `backupid` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `operation` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'backup',
  `type` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL,
  `format` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `interactive` smallint(4) NOT NULL,
  `purpose` smallint(4) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `status` smallint(4) NOT NULL,
  `execution` smallint(4) NOT NULL,
  `executiontime` bigint(10) NOT NULL,
  `checksum` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `controller` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_backcont_bac_uix` (`backupid`),
  KEY `mdl_backcont_typite_ix` (`type`,`itemid`),
  KEY `mdl_backcont_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='To store the backup_controllers as they are used';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_backup_controllers`
--

LOCK TABLES `mdl_backup_controllers` WRITE;
/*!40000 ALTER TABLE `mdl_backup_controllers` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_backup_controllers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_backup_courses`
--

DROP TABLE IF EXISTS `mdl_backup_courses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_backup_courses` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `laststarttime` bigint(10) NOT NULL DEFAULT '0',
  `lastendtime` bigint(10) NOT NULL DEFAULT '0',
  `laststatus` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '5',
  `nextstarttime` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_backcour_cou_uix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='To store every course backup status';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_backup_courses`
--

LOCK TABLES `mdl_backup_courses` WRITE;
/*!40000 ALTER TABLE `mdl_backup_courses` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_backup_courses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_backup_logs`
--

DROP TABLE IF EXISTS `mdl_backup_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_backup_logs` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `backupid` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `loglevel` smallint(4) NOT NULL,
  `message` longtext COLLATE utf8_unicode_ci NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_backlogs_bacid_uix` (`backupid`,`id`),
  KEY `mdl_backlogs_bac_ix` (`backupid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='To store all the logs from backup and restore operations (by';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_backup_logs`
--

LOCK TABLES `mdl_backup_logs` WRITE;
/*!40000 ALTER TABLE `mdl_backup_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_backup_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge`
--

DROP TABLE IF EXISTS `mdl_badge`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8_unicode_ci,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `usercreated` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `issuername` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `issuerurl` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `issuercontact` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `expiredate` bigint(10) DEFAULT NULL,
  `expireperiod` bigint(10) DEFAULT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `courseid` bigint(10) DEFAULT NULL,
  `message` longtext COLLATE utf8_unicode_ci NOT NULL,
  `messagesubject` longtext COLLATE utf8_unicode_ci NOT NULL,
  `attachment` tinyint(1) NOT NULL DEFAULT '1',
  `notification` tinyint(1) NOT NULL DEFAULT '1',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `nextcron` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_badg_typ_ix` (`type`),
  KEY `mdl_badg_cou_ix` (`courseid`),
  KEY `mdl_badg_use_ix` (`usermodified`),
  KEY `mdl_badg_use2_ix` (`usercreated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Defines badge';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge`
--

LOCK TABLES `mdl_badge` WRITE;
/*!40000 ALTER TABLE `mdl_badge` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_backpack`
--

DROP TABLE IF EXISTS `mdl_badge_backpack`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_backpack` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `email` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `backpackurl` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `backpackuid` bigint(10) NOT NULL,
  `autosync` tinyint(1) NOT NULL DEFAULT '0',
  `password` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_badgback_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Defines settings for connecting external backpack';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_backpack`
--

LOCK TABLES `mdl_badge_backpack` WRITE;
/*!40000 ALTER TABLE `mdl_badge_backpack` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_backpack` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_criteria`
--

DROP TABLE IF EXISTS `mdl_badge_criteria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_criteria` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `badgeid` bigint(10) NOT NULL DEFAULT '0',
  `criteriatype` bigint(10) DEFAULT NULL,
  `method` tinyint(1) NOT NULL DEFAULT '1',
  `description` longtext COLLATE utf8_unicode_ci,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_badgcrit_badcri_uix` (`badgeid`,`criteriatype`),
  KEY `mdl_badgcrit_cri_ix` (`criteriatype`),
  KEY `mdl_badgcrit_bad_ix` (`badgeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Defines criteria for issuing badges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_criteria`
--

LOCK TABLES `mdl_badge_criteria` WRITE;
/*!40000 ALTER TABLE `mdl_badge_criteria` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_criteria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_criteria_met`
--

DROP TABLE IF EXISTS `mdl_badge_criteria_met`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_criteria_met` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `issuedid` bigint(10) DEFAULT NULL,
  `critid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `datemet` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_badgcritmet_cri_ix` (`critid`),
  KEY `mdl_badgcritmet_use_ix` (`userid`),
  KEY `mdl_badgcritmet_iss_ix` (`issuedid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Defines criteria that were met for an issued badge';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_criteria_met`
--

LOCK TABLES `mdl_badge_criteria_met` WRITE;
/*!40000 ALTER TABLE `mdl_badge_criteria_met` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_criteria_met` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_criteria_param`
--

DROP TABLE IF EXISTS `mdl_badge_criteria_param`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_criteria_param` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `critid` bigint(10) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_badgcritpara_cri_ix` (`critid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Defines parameters for badges criteria';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_criteria_param`
--

LOCK TABLES `mdl_badge_criteria_param` WRITE;
/*!40000 ALTER TABLE `mdl_badge_criteria_param` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_criteria_param` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_external`
--

DROP TABLE IF EXISTS `mdl_badge_external`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_external` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `backpackid` bigint(10) NOT NULL,
  `collectionid` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_badgexte_bac_ix` (`backpackid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Setting for external badges display';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_external`
--

LOCK TABLES `mdl_badge_external` WRITE;
/*!40000 ALTER TABLE `mdl_badge_external` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_external` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_issued`
--

DROP TABLE IF EXISTS `mdl_badge_issued`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_issued` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `badgeid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `uniquehash` longtext COLLATE utf8_unicode_ci NOT NULL,
  `dateissued` bigint(10) NOT NULL DEFAULT '0',
  `dateexpire` bigint(10) DEFAULT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '0',
  `issuernotified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_badgissu_baduse_uix` (`badgeid`,`userid`),
  KEY `mdl_badgissu_bad_ix` (`badgeid`),
  KEY `mdl_badgissu_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Defines issued badges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_issued`
--

LOCK TABLES `mdl_badge_issued` WRITE;
/*!40000 ALTER TABLE `mdl_badge_issued` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_issued` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_manual_award`
--

DROP TABLE IF EXISTS `mdl_badge_manual_award`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_manual_award` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `badgeid` bigint(10) NOT NULL,
  `recipientid` bigint(10) NOT NULL,
  `issuerid` bigint(10) NOT NULL,
  `issuerrole` bigint(10) NOT NULL,
  `datemet` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_badgmanuawar_bad_ix` (`badgeid`),
  KEY `mdl_badgmanuawar_rec_ix` (`recipientid`),
  KEY `mdl_badgmanuawar_iss_ix` (`issuerid`),
  KEY `mdl_badgmanuawar_iss2_ix` (`issuerrole`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Track manual award criteria for badges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_manual_award`
--

LOCK TABLES `mdl_badge_manual_award` WRITE;
/*!40000 ALTER TABLE `mdl_badge_manual_award` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_manual_award` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block`
--

DROP TABLE IF EXISTS `mdl_block`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_block` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `cron` bigint(10) NOT NULL DEFAULT '0',
  `lastcron` bigint(10) NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_bloc_nam_uix` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='contains all installed blocks';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block`
--

LOCK TABLES `mdl_block` WRITE;
/*!40000 ALTER TABLE `mdl_block` DISABLE KEYS */;
INSERT INTO `mdl_block` VALUES (1,'activity_modules',0,0,1),(2,'activity_results',0,0,1),(3,'admin_bookmarks',0,0,1),(4,'badges',0,0,1),(5,'blog_menu',0,0,1),(6,'blog_recent',0,0,1),(7,'blog_tags',0,0,1),(8,'calendar_month',0,0,1),(9,'calendar_upcoming',0,0,1),(10,'comments',0,0,1),(11,'community',0,0,1),(12,'completionstatus',0,0,1),(13,'course_list',0,0,1),(14,'course_overview',0,0,1),(15,'course_summary',0,0,1),(16,'feedback',0,0,0),(17,'glossary_random',0,0,1),(18,'html',0,0,1),(19,'login',0,0,1),(20,'mentees',0,0,1),(21,'messages',0,0,1),(22,'mnet_hosts',0,0,1),(23,'myprofile',0,0,1),(24,'navigation',0,0,1),(25,'news_items',0,0,1),(26,'online_users',0,0,1),(27,'participants',0,0,1),(28,'private_files',0,0,1),(29,'quiz_results',0,0,0),(30,'recent_activity',86400,0,1),(31,'rss_client',300,0,1),(32,'search_forums',0,0,1),(33,'section_links',0,0,1),(34,'selfcompletion',0,0,1),(35,'settings',0,0,1),(36,'site_main_menu',0,0,1),(37,'social_activities',0,0,1),(38,'tag_flickr',0,0,1),(39,'tag_youtube',0,0,0),(40,'tags',0,0,1);
/*!40000 ALTER TABLE `mdl_block` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block_community`
--

DROP TABLE IF EXISTS `mdl_block_community`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_block_community` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `coursename` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `coursedescription` longtext COLLATE utf8_unicode_ci,
  `courseurl` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `imageurl` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Community block';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block_community`
--

LOCK TABLES `mdl_block_community` WRITE;
/*!40000 ALTER TABLE `mdl_block_community` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_block_community` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block_instances`
--

DROP TABLE IF EXISTS `mdl_block_instances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_block_instances` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `blockname` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `parentcontextid` bigint(10) NOT NULL,
  `showinsubcontexts` smallint(4) NOT NULL,
  `pagetypepattern` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `subpagepattern` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `defaultregion` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `defaultweight` bigint(10) NOT NULL,
  `configdata` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_blocinst_parshopagsub_ix` (`parentcontextid`,`showinsubcontexts`,`pagetypepattern`,`subpagepattern`),
  KEY `mdl_blocinst_par_ix` (`parentcontextid`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='This table stores block instances. The type of block this is';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block_instances`
--

LOCK TABLES `mdl_block_instances` WRITE;
/*!40000 ALTER TABLE `mdl_block_instances` DISABLE KEYS */;
INSERT INTO `mdl_block_instances` VALUES (1,'site_main_menu',2,0,'site-index',NULL,'side-pre',0,''),(2,'course_summary',2,0,'site-index',NULL,'side-post',-1,''),(3,'calendar_month',2,0,'site-index',NULL,'side-post',1,''),(4,'navigation',1,1,'*',NULL,'side-pre',0,''),(5,'settings',1,1,'*',NULL,'side-pre',1,''),(6,'admin_bookmarks',1,0,'admin-*',NULL,'side-pre',2,''),(7,'private_files',1,0,'my-index','2','side-post',4,''),(8,'online_users',1,0,'my-index','2','side-post',1,''),(9,'badges',1,0,'my-index','2','side-pre',-1,''),(10,'calendar_month',1,0,'my-index','2','side-post',2,''),(11,'calendar_upcoming',1,0,'my-index','2','side-post',3,''),(12,'course_overview',1,0,'my-index','2','content',0,''),(19,'search_forums',24,0,'course-view-*',NULL,'side-post',0,''),(20,'news_items',24,0,'course-view-*',NULL,'side-post',1,''),(21,'calendar_upcoming',24,0,'course-view-*',NULL,'side-post',2,''),(22,'recent_activity',24,0,'course-view-*',NULL,'side-post',3,''),(29,'badges',24,0,'course-view-*',NULL,'side-pre',2,'Tzo4OiJzdGRDbGFzcyI6MTp7czoxNDoibnVtYmVyb2ZiYWRnZXMiO3M6MjoiMTAiO30='),(43,'private_files',31,0,'my-index','8','side-post',4,''),(44,'online_users',31,0,'my-index','8','side-post',1,''),(45,'badges',31,0,'my-index','8','side-pre',-1,''),(46,'calendar_month',31,0,'my-index','8','side-post',2,''),(47,'calendar_upcoming',31,0,'my-index','8','side-post',3,''),(48,'course_overview',31,0,'my-index','8','content',0,''),(49,'private_files',5,0,'my-index','9','side-post',4,''),(50,'online_users',5,0,'my-index','9','side-post',1,''),(51,'badges',5,0,'my-index','9','side-pre',-1,''),(52,'calendar_month',5,0,'my-index','9','side-post',2,''),(53,'calendar_upcoming',5,0,'my-index','9','side-post',3,''),(54,'course_overview',5,0,'my-index','9','content',0,''),(55,'private_files',68,0,'my-index','10','side-post',4,''),(56,'online_users',68,0,'my-index','10','side-post',1,''),(57,'badges',68,0,'my-index','10','side-pre',-1,''),(58,'calendar_month',68,0,'my-index','10','side-post',2,''),(59,'calendar_upcoming',68,0,'my-index','10','side-post',3,''),(60,'course_overview',68,0,'my-index','10','content',0,'');
/*!40000 ALTER TABLE `mdl_block_instances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block_positions`
--

DROP TABLE IF EXISTS `mdl_block_positions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_block_positions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `blockinstanceid` bigint(10) NOT NULL,
  `contextid` bigint(10) NOT NULL,
  `pagetype` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `subpage` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `visible` smallint(4) NOT NULL,
  `region` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `weight` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_blocposi_bloconpagsub_uix` (`blockinstanceid`,`contextid`,`pagetype`,`subpage`),
  KEY `mdl_blocposi_blo_ix` (`blockinstanceid`),
  KEY `mdl_blocposi_con_ix` (`contextid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Stores the position of a sticky block_instance on a another ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block_positions`
--

LOCK TABLES `mdl_block_positions` WRITE;
/*!40000 ALTER TABLE `mdl_block_positions` DISABLE KEYS */;
INSERT INTO `mdl_block_positions` VALUES (1,19,24,'course-view-weeks','',1,'side-post',-1),(2,20,24,'course-view-weeks','',1,'side-post',0),(3,29,24,'course-view-weeks','',1,'side-post',-2);
/*!40000 ALTER TABLE `mdl_block_positions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block_recent_activity`
--

DROP TABLE IF EXISTS `mdl_block_recent_activity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_block_recent_activity` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `cmid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `action` tinyint(1) NOT NULL,
  `modname` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_blocreceacti_coutim_ix` (`courseid`,`timecreated`)
) ENGINE=InnoDB AUTO_INCREMENT=62 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Recent activity block';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block_recent_activity`
--

LOCK TABLES `mdl_block_recent_activity` WRITE;
/*!40000 ALTER TABLE `mdl_block_recent_activity` DISABLE KEYS */;
INSERT INTO `mdl_block_recent_activity` VALUES (1,2,2,1462458067,2,0,NULL),(2,2,2,1462458179,2,1,NULL),(3,2,2,1462458292,2,1,NULL),(4,2,2,1462458354,2,1,NULL),(5,2,2,1462458410,2,1,NULL),(6,2,2,1462542850,2,1,NULL),(7,2,2,1462543074,2,1,NULL),(8,2,3,1462543852,2,0,NULL),(9,2,4,1462553783,2,0,NULL),(10,1,6,1462587814,2,0,NULL),(11,2,7,1462652156,4,0,NULL),(12,2,8,1462657149,2,0,NULL),(13,2,8,1462657489,2,2,'scorm'),(14,2,9,1462657566,2,0,NULL),(15,2,9,1462657613,2,2,'scorm'),(16,2,10,1462657939,2,0,NULL),(17,2,10,1462659571,4,1,NULL),(18,2,2,1462659606,4,1,NULL),(19,2,11,1462701338,2,0,NULL),(20,2,12,1462701591,2,0,NULL),(21,2,11,1462701772,2,2,'scorm'),(22,2,12,1462707819,2,2,'scorm'),(23,2,13,1462716830,2,0,NULL),(24,2,14,1462717011,2,0,NULL),(25,2,15,1462725713,2,0,NULL),(26,2,3,1462726308,2,1,NULL),(27,2,2,1462726311,2,1,NULL),(28,2,10,1462726314,2,1,NULL),(29,2,13,1462726316,2,1,NULL),(30,2,14,1462726320,2,1,NULL),(31,2,16,1462731298,2,0,NULL),(32,2,15,1462731305,2,1,NULL),(33,2,15,1462731684,2,1,NULL),(34,2,15,1462732514,2,1,NULL),(35,2,15,1462733687,2,1,NULL),(36,2,16,1462733690,2,1,NULL),(37,2,3,1462733699,2,1,NULL),(38,2,3,1462734589,2,1,NULL),(39,2,2,1462734597,2,1,NULL),(40,2,16,1462734754,2,1,NULL),(41,2,16,1462734897,2,1,NULL),(42,2,10,1462734905,2,1,NULL),(43,2,13,1462734911,2,1,NULL),(44,2,14,1462734919,2,1,NULL),(45,2,16,1462735171,2,1,NULL),(46,2,15,1462735173,2,1,NULL),(47,2,3,1462735178,2,1,NULL),(48,2,3,1462735410,2,1,NULL),(49,2,10,1462735413,2,1,NULL),(50,2,13,1462735416,2,1,NULL),(51,2,14,1462735420,2,1,NULL),(52,2,15,1462735423,2,1,NULL),(53,2,16,1462735426,2,1,NULL),(54,2,15,1462737007,2,1,NULL),(55,2,2,1462737018,2,1,NULL),(56,2,15,1462737023,2,1,NULL),(57,2,15,1462738451,2,1,NULL),(58,2,17,1462749701,2,0,NULL),(59,2,18,1462749714,2,0,NULL),(60,2,18,1462749728,2,1,NULL),(61,2,15,1462750011,2,1,NULL);
/*!40000 ALTER TABLE `mdl_block_recent_activity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block_rss_client`
--

DROP TABLE IF EXISTS `mdl_block_rss_client`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_block_rss_client` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `title` longtext COLLATE utf8_unicode_ci NOT NULL,
  `preferredtitle` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8_unicode_ci NOT NULL,
  `shared` tinyint(2) NOT NULL DEFAULT '0',
  `url` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `skiptime` bigint(10) NOT NULL DEFAULT '0',
  `skipuntil` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Remote news feed information. Contains the news feed id, the';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block_rss_client`
--

LOCK TABLES `mdl_block_rss_client` WRITE;
/*!40000 ALTER TABLE `mdl_block_rss_client` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_block_rss_client` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_blog_association`
--

DROP TABLE IF EXISTS `mdl_blog_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_blog_association` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `blogid` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_blogasso_con_ix` (`contextid`),
  KEY `mdl_blogasso_blo_ix` (`blogid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Associations of blog entries with courses and module instanc';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_blog_association`
--

LOCK TABLES `mdl_blog_association` WRITE;
/*!40000 ALTER TABLE `mdl_blog_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_blog_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_blog_external`
--

DROP TABLE IF EXISTS `mdl_blog_external`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_blog_external` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8_unicode_ci,
  `url` longtext COLLATE utf8_unicode_ci NOT NULL,
  `filtertags` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `failedlastsync` tinyint(1) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) DEFAULT NULL,
  `timefetched` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_blogexte_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='External blog links used for RSS copying of blog entries to ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_blog_external`
--

LOCK TABLES `mdl_blog_external` WRITE;
/*!40000 ALTER TABLE `mdl_blog_external` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_blog_external` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_book`
--

DROP TABLE IF EXISTS `mdl_book`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_book` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8_unicode_ci,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `numbering` smallint(4) NOT NULL DEFAULT '0',
  `navstyle` smallint(4) NOT NULL DEFAULT '1',
  `customtitles` tinyint(2) NOT NULL DEFAULT '0',
  `revision` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Defines book';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_book`
--

LOCK TABLES `mdl_book` WRITE;
/*!40000 ALTER TABLE `mdl_book` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_book` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_book_chapters`
--

DROP TABLE IF EXISTS `mdl_book_chapters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_book_chapters` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `bookid` bigint(10) NOT NULL DEFAULT '0',
  `pagenum` bigint(10) NOT NULL DEFAULT '0',
  `subchapter` bigint(10) NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `content` longtext COLLATE utf8_unicode_ci NOT NULL,
  `contentformat` smallint(4) NOT NULL DEFAULT '0',
  `hidden` tinyint(2) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `importsrc` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Defines book_chapters';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_book_chapters`
--

LOCK TABLES `mdl_book_chapters` WRITE;
/*!40000 ALTER TABLE `mdl_book_chapters` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_book_chapters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_cache_filters`
--

DROP TABLE IF EXISTS `mdl_cache_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_cache_filters` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `filter` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `version` bigint(10) NOT NULL DEFAULT '0',
  `md5key` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `rawtext` longtext COLLATE utf8_unicode_ci NOT NULL,
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_cachfilt_filmd5_ix` (`filter`,`md5key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='For keeping information about cached data';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_cache_filters`
--

LOCK TABLES `mdl_cache_filters` WRITE;
/*!40000 ALTER TABLE `mdl_cache_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_cache_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_cache_flags`
--

DROP TABLE IF EXISTS `mdl_cache_flags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_cache_flags` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `flagtype` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  `expiry` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_cachflag_fla_ix` (`flagtype`),
  KEY `mdl_cachflag_nam_ix` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Cache of time-sensitive flags';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_cache_flags`
--

LOCK TABLES `mdl_cache_flags` WRITE;
/*!40000 ALTER TABLE `mdl_cache_flags` DISABLE KEYS */;
INSERT INTO `mdl_cache_flags` VALUES (1,'userpreferenceschanged','2',1462829914,'1',1462837114),(2,'accesslib/dirtycontexts','/1/3/24',1462542180,'1',1462549380),(3,'userpreferenceschanged','3',1462749741,'1',1462756941),(4,'accesslib/dirtycontexts','/1/2/41',1462588421,'1',1462595621),(5,'accesslib/dirtycontexts','/1/5/18',1462628229,'1',1462635429),(6,'accesslib/dirtycontexts','/1/5/19',1462628229,'1',1462635429),(7,'accesslib/dirtycontexts','/1/5/20',1462628229,'1',1462635429),(8,'accesslib/dirtycontexts','/1/5/21',1462628229,'1',1462635429),(9,'accesslib/dirtycontexts','/1/5/22',1462628229,'1',1462635429),(10,'accesslib/dirtycontexts','/1/5/23',1462628229,'1',1462635429),(11,'accesslib/dirtycontexts','/1/31/32',1462628229,'1',1462635429),(12,'accesslib/dirtycontexts','/1/31/33',1462628229,'1',1462635429),(13,'accesslib/dirtycontexts','/1/31/34',1462628229,'1',1462635429),(14,'accesslib/dirtycontexts','/1/31/35',1462628229,'1',1462635429),(15,'accesslib/dirtycontexts','/1/31/36',1462628229,'1',1462635429),(16,'accesslib/dirtycontexts','/1/31/37',1462628229,'1',1462635429),(17,'accesslib/dirtycontexts','/1/31/44',1462628520,'1',1462635720),(18,'accesslib/dirtycontexts','/1/31/45',1462628520,'1',1462635720),(19,'accesslib/dirtycontexts','/1/31/46',1462628520,'1',1462635720),(20,'accesslib/dirtycontexts','/1/31/47',1462628520,'1',1462635720),(21,'accesslib/dirtycontexts','/1/31/48',1462628520,'1',1462635720),(22,'accesslib/dirtycontexts','/1/31/49',1462628520,'1',1462635720),(23,'accesslib/dirtycontexts','/1/5/50',1462628520,'1',1462635720),(24,'accesslib/dirtycontexts','/1/5/51',1462628520,'1',1462635720),(25,'accesslib/dirtycontexts','/1/5/52',1462628520,'1',1462635720),(26,'accesslib/dirtycontexts','/1/5/53',1462628520,'1',1462635720),(27,'accesslib/dirtycontexts','/1/5/54',1462628520,'1',1462635720),(28,'accesslib/dirtycontexts','/1/5/55',1462628520,'1',1462635720),(29,'userpreferenceschanged','4',1462662427,'1',1462669627),(30,'accesslib/dirtycontexts','/1',1462651678,'1',1462658878),(31,'accesslib/dirtycontexts','/1/3/24/76',1462657489,'1',1462664689),(32,'accesslib/dirtycontexts','/1/3/24/77',1462657613,'1',1462664813),(33,'accesslib/dirtycontexts','/1/3/24/79',1462701772,'1',1462708972),(34,'accesslib/dirtycontexts','/1/3/24/80',1462707819,'1',1462715019);
/*!40000 ALTER TABLE `mdl_cache_flags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_capabilities`
--

DROP TABLE IF EXISTS `mdl_capabilities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_capabilities` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `captype` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contextlevel` bigint(10) NOT NULL DEFAULT '0',
  `component` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `riskbitmask` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_capa_nam_uix` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=529 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='this defines all capabilities';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_capabilities`
--

LOCK TABLES `mdl_capabilities` WRITE;
/*!40000 ALTER TABLE `mdl_capabilities` DISABLE KEYS */;
INSERT INTO `mdl_capabilities` VALUES (1,'moodle/site:config','write',10,'moodle',62),(2,'moodle/site:readallmessages','read',10,'moodle',8),(3,'moodle/site:deleteanymessage','write',10,'moodle',32),(4,'moodle/site:sendmessage','write',10,'moodle',16),(5,'moodle/site:deleteownmessage','write',10,'moodle',0),(6,'moodle/site:approvecourse','write',10,'moodle',4),(7,'moodle/backup:backupcourse','write',50,'moodle',28),(8,'moodle/backup:backupsection','write',50,'moodle',28),(9,'moodle/backup:backupactivity','write',70,'moodle',28),(10,'moodle/backup:backuptargethub','write',50,'moodle',28),(11,'moodle/backup:backuptargetimport','write',50,'moodle',28),(12,'moodle/backup:downloadfile','write',50,'moodle',28),(13,'moodle/backup:configure','write',50,'moodle',28),(14,'moodle/backup:userinfo','read',50,'moodle',8),(15,'moodle/backup:anonymise','read',50,'moodle',8),(16,'moodle/restore:restorecourse','write',50,'moodle',28),(17,'moodle/restore:restoresection','write',50,'moodle',28),(18,'moodle/restore:restoreactivity','write',50,'moodle',28),(19,'moodle/restore:viewautomatedfilearea','write',50,'moodle',28),(20,'moodle/restore:restoretargethub','write',50,'moodle',28),(21,'moodle/restore:restoretargetimport','write',50,'moodle',28),(22,'moodle/restore:uploadfile','write',50,'moodle',28),(23,'moodle/restore:configure','write',50,'moodle',28),(24,'moodle/restore:rolldates','write',50,'moodle',0),(25,'moodle/restore:userinfo','write',50,'moodle',30),(26,'moodle/restore:createuser','write',10,'moodle',24),(27,'moodle/site:manageblocks','write',80,'moodle',20),(28,'moodle/site:accessallgroups','read',50,'moodle',0),(29,'moodle/site:viewfullnames','read',50,'moodle',0),(30,'moodle/site:viewuseridentity','read',50,'moodle',0),(31,'moodle/site:viewreports','read',50,'moodle',8),(32,'moodle/site:trustcontent','write',50,'moodle',4),(33,'moodle/site:uploadusers','write',10,'moodle',24),(34,'moodle/filter:manage','write',50,'moodle',0),(35,'moodle/user:create','write',10,'moodle',24),(36,'moodle/user:delete','write',10,'moodle',8),(37,'moodle/user:update','write',10,'moodle',24),(38,'moodle/user:viewdetails','read',50,'moodle',0),(39,'moodle/user:viewalldetails','read',30,'moodle',8),(40,'moodle/user:viewlastip','read',30,'moodle',8),(41,'moodle/user:viewhiddendetails','read',50,'moodle',8),(42,'moodle/user:loginas','write',50,'moodle',30),(43,'moodle/user:managesyspages','write',10,'moodle',0),(44,'moodle/user:manageblocks','write',30,'moodle',0),(45,'moodle/user:manageownblocks','write',10,'moodle',0),(46,'moodle/user:manageownfiles','write',10,'moodle',0),(47,'moodle/user:ignoreuserquota','write',10,'moodle',0),(48,'moodle/my:configsyspages','write',10,'moodle',0),(49,'moodle/role:assign','write',50,'moodle',28),(50,'moodle/role:review','read',50,'moodle',8),(51,'moodle/role:override','write',50,'moodle',28),(52,'moodle/role:safeoverride','write',50,'moodle',16),(53,'moodle/role:manage','write',10,'moodle',28),(54,'moodle/role:switchroles','read',50,'moodle',12),(55,'moodle/category:manage','write',40,'moodle',4),(56,'moodle/category:viewhiddencategories','read',40,'moodle',0),(57,'moodle/cohort:manage','write',40,'moodle',0),(58,'moodle/cohort:assign','write',40,'moodle',0),(59,'moodle/cohort:view','read',50,'moodle',0),(60,'moodle/course:create','write',40,'moodle',4),(61,'moodle/course:request','write',10,'moodle',0),(62,'moodle/course:delete','write',50,'moodle',32),(63,'moodle/course:update','write',50,'moodle',4),(64,'moodle/course:view','read',50,'moodle',0),(65,'moodle/course:enrolreview','read',50,'moodle',8),(66,'moodle/course:enrolconfig','write',50,'moodle',8),(67,'moodle/course:reviewotherusers','read',50,'moodle',0),(68,'moodle/course:bulkmessaging','write',50,'moodle',16),(69,'moodle/course:viewhiddenuserfields','read',50,'moodle',8),(70,'moodle/course:viewhiddencourses','read',50,'moodle',0),(71,'moodle/course:visibility','write',50,'moodle',0),(72,'moodle/course:managefiles','write',50,'moodle',4),(73,'moodle/course:ignorefilesizelimits','write',50,'moodle',0),(74,'moodle/course:manageactivities','write',70,'moodle',4),(75,'moodle/course:activityvisibility','write',70,'moodle',0),(76,'moodle/course:viewhiddenactivities','write',70,'moodle',0),(77,'moodle/course:viewparticipants','read',50,'moodle',0),(78,'moodle/course:changefullname','write',50,'moodle',4),(79,'moodle/course:changeshortname','write',50,'moodle',4),(80,'moodle/course:changeidnumber','write',50,'moodle',4),(81,'moodle/course:changecategory','write',50,'moodle',4),(82,'moodle/course:changesummary','write',50,'moodle',4),(83,'moodle/site:viewparticipants','read',10,'moodle',0),(84,'moodle/course:isincompletionreports','read',50,'moodle',0),(85,'moodle/course:viewscales','read',50,'moodle',0),(86,'moodle/course:managescales','write',50,'moodle',0),(87,'moodle/course:managegroups','write',50,'moodle',0),(88,'moodle/course:reset','write',50,'moodle',32),(89,'moodle/course:viewsuspendedusers','read',10,'moodle',0),(90,'moodle/course:tag','write',50,'moodle',16),(91,'moodle/blog:view','read',10,'moodle',0),(92,'moodle/blog:search','read',10,'moodle',0),(93,'moodle/blog:viewdrafts','read',10,'moodle',8),(94,'moodle/blog:create','write',10,'moodle',16),(95,'moodle/blog:manageentries','write',10,'moodle',16),(96,'moodle/blog:manageexternal','write',10,'moodle',16),(97,'moodle/blog:associatecourse','write',50,'moodle',0),(98,'moodle/blog:associatemodule','write',70,'moodle',0),(99,'moodle/calendar:manageownentries','write',50,'moodle',16),(100,'moodle/calendar:managegroupentries','write',50,'moodle',16),(101,'moodle/calendar:manageentries','write',50,'moodle',16),(102,'moodle/user:editprofile','write',30,'moodle',24),(103,'moodle/user:editownprofile','write',10,'moodle',16),(104,'moodle/user:changeownpassword','write',10,'moodle',0),(105,'moodle/user:readuserposts','read',30,'moodle',0),(106,'moodle/user:readuserblogs','read',30,'moodle',0),(107,'moodle/user:viewuseractivitiesreport','read',30,'moodle',8),(108,'moodle/user:editmessageprofile','write',30,'moodle',16),(109,'moodle/user:editownmessageprofile','write',10,'moodle',0),(110,'moodle/question:managecategory','write',50,'moodle',20),(111,'moodle/question:add','write',50,'moodle',20),(112,'moodle/question:editmine','write',50,'moodle',20),(113,'moodle/question:editall','write',50,'moodle',20),(114,'moodle/question:viewmine','read',50,'moodle',0),(115,'moodle/question:viewall','read',50,'moodle',0),(116,'moodle/question:usemine','read',50,'moodle',0),(117,'moodle/question:useall','read',50,'moodle',0),(118,'moodle/question:movemine','write',50,'moodle',0),(119,'moodle/question:moveall','write',50,'moodle',0),(120,'moodle/question:config','write',10,'moodle',2),(121,'moodle/question:flag','write',50,'moodle',0),(122,'moodle/site:doclinks','read',10,'moodle',0),(123,'moodle/course:sectionvisibility','write',50,'moodle',0),(124,'moodle/course:useremail','write',50,'moodle',0),(125,'moodle/course:viewhiddensections','write',50,'moodle',0),(126,'moodle/course:setcurrentsection','write',50,'moodle',0),(127,'moodle/course:movesections','write',50,'moodle',0),(128,'moodle/site:mnetlogintoremote','read',10,'moodle',0),(129,'moodle/grade:viewall','read',50,'moodle',8),(130,'moodle/grade:view','read',50,'moodle',0),(131,'moodle/grade:viewhidden','read',50,'moodle',8),(132,'moodle/grade:import','write',50,'moodle',12),(133,'moodle/grade:export','read',50,'moodle',8),(134,'moodle/grade:manage','write',50,'moodle',12),(135,'moodle/grade:edit','write',50,'moodle',12),(136,'moodle/grade:managegradingforms','write',50,'moodle',12),(137,'moodle/grade:sharegradingforms','write',10,'moodle',4),(138,'moodle/grade:managesharedforms','write',10,'moodle',4),(139,'moodle/grade:manageoutcomes','write',50,'moodle',0),(140,'moodle/grade:manageletters','write',50,'moodle',0),(141,'moodle/grade:hide','write',50,'moodle',0),(142,'moodle/grade:lock','write',50,'moodle',0),(143,'moodle/grade:unlock','write',50,'moodle',0),(144,'moodle/my:manageblocks','write',10,'moodle',0),(145,'moodle/notes:view','read',50,'moodle',0),(146,'moodle/notes:manage','write',50,'moodle',16),(147,'moodle/tag:manage','write',10,'moodle',16),(148,'moodle/tag:edit','write',10,'moodle',16),(149,'moodle/tag:flag','write',10,'moodle',16),(150,'moodle/tag:editblocks','write',10,'moodle',0),(151,'moodle/block:view','read',80,'moodle',0),(152,'moodle/block:edit','write',80,'moodle',20),(153,'moodle/portfolio:export','read',10,'moodle',0),(154,'moodle/comment:view','read',50,'moodle',0),(155,'moodle/comment:post','write',50,'moodle',24),(156,'moodle/comment:delete','write',50,'moodle',32),(157,'moodle/webservice:createtoken','write',10,'moodle',62),(158,'moodle/webservice:createmobiletoken','write',10,'moodle',24),(159,'moodle/rating:view','read',50,'moodle',0),(160,'moodle/rating:viewany','read',50,'moodle',8),(161,'moodle/rating:viewall','read',50,'moodle',8),(162,'moodle/rating:rate','write',50,'moodle',0),(163,'moodle/course:publish','write',10,'moodle',24),(164,'moodle/course:markcomplete','write',50,'moodle',0),(165,'moodle/community:add','write',10,'moodle',0),(166,'moodle/community:download','write',10,'moodle',0),(167,'moodle/badges:manageglobalsettings','write',10,'moodle',34),(168,'moodle/badges:viewbadges','read',50,'moodle',0),(169,'moodle/badges:manageownbadges','write',30,'moodle',0),(170,'moodle/badges:viewotherbadges','read',30,'moodle',0),(171,'moodle/badges:earnbadge','write',50,'moodle',0),(172,'moodle/badges:createbadge','write',50,'moodle',16),(173,'moodle/badges:deletebadge','write',50,'moodle',32),(174,'moodle/badges:configuredetails','write',50,'moodle',16),(175,'moodle/badges:configurecriteria','write',50,'moodle',4),(176,'moodle/badges:configuremessages','write',50,'moodle',16),(177,'moodle/badges:awardbadge','write',50,'moodle',16),(178,'moodle/badges:viewawarded','read',50,'moodle',8),(179,'moodle/site:forcelanguage','read',10,'moodle',0),(180,'mod/assign:view','read',70,'mod_assign',0),(181,'mod/assign:submit','write',70,'mod_assign',0),(182,'mod/assign:grade','write',70,'mod_assign',4),(183,'mod/assign:exportownsubmission','read',70,'mod_assign',0),(184,'mod/assign:addinstance','write',50,'mod_assign',4),(185,'mod/assign:editothersubmission','write',70,'mod_assign',41),(186,'mod/assign:grantextension','write',70,'mod_assign',0),(187,'mod/assign:revealidentities','write',70,'mod_assign',0),(188,'mod/assign:reviewgrades','write',70,'mod_assign',0),(189,'mod/assign:releasegrades','write',70,'mod_assign',0),(190,'mod/assign:managegrades','write',70,'mod_assign',0),(191,'mod/assign:manageallocations','write',70,'mod_assign',0),(192,'mod/assign:viewgrades','read',70,'mod_assign',0),(193,'mod/assign:viewblinddetails','write',70,'mod_assign',8),(194,'mod/assign:receivegradernotifications','read',70,'mod_assign',0),(195,'mod/assignment:view','read',70,'mod_assignment',0),(196,'mod/assignment:addinstance','write',50,'mod_assignment',4),(197,'mod/assignment:submit','write',70,'mod_assignment',0),(198,'mod/assignment:grade','write',70,'mod_assignment',4),(199,'mod/assignment:exportownsubmission','read',70,'mod_assignment',0),(200,'mod/book:addinstance','write',50,'mod_book',4),(201,'mod/book:read','read',70,'mod_book',0),(202,'mod/book:viewhiddenchapters','read',70,'mod_book',0),(203,'mod/book:edit','write',70,'mod_book',4),(204,'mod/chat:addinstance','write',50,'mod_chat',4),(205,'mod/chat:chat','write',70,'mod_chat',16),(206,'mod/chat:readlog','read',70,'mod_chat',0),(207,'mod/chat:deletelog','write',70,'mod_chat',0),(208,'mod/chat:exportparticipatedsession','read',70,'mod_chat',8),(209,'mod/chat:exportsession','read',70,'mod_chat',8),(210,'mod/choice:addinstance','write',50,'mod_choice',4),(211,'mod/choice:choose','write',70,'mod_choice',0),(212,'mod/choice:readresponses','read',70,'mod_choice',0),(213,'mod/choice:deleteresponses','write',70,'mod_choice',0),(214,'mod/choice:downloadresponses','read',70,'mod_choice',0),(215,'mod/data:addinstance','write',50,'mod_data',4),(216,'mod/data:viewentry','read',70,'mod_data',0),(217,'mod/data:writeentry','write',70,'mod_data',16),(218,'mod/data:comment','write',70,'mod_data',16),(219,'mod/data:rate','write',70,'mod_data',0),(220,'mod/data:viewrating','read',70,'mod_data',0),(221,'mod/data:viewanyrating','read',70,'mod_data',8),(222,'mod/data:viewallratings','read',70,'mod_data',8),(223,'mod/data:approve','write',70,'mod_data',16),(224,'mod/data:manageentries','write',70,'mod_data',16),(225,'mod/data:managecomments','write',70,'mod_data',16),(226,'mod/data:managetemplates','write',70,'mod_data',20),(227,'mod/data:viewalluserpresets','read',70,'mod_data',0),(228,'mod/data:manageuserpresets','write',70,'mod_data',20),(229,'mod/data:exportentry','read',70,'mod_data',8),(230,'mod/data:exportownentry','read',70,'mod_data',0),(231,'mod/data:exportallentries','read',70,'mod_data',8),(232,'mod/data:exportuserinfo','read',70,'mod_data',8),(233,'mod/feedback:addinstance','write',50,'mod_feedback',4),(234,'mod/feedback:view','read',70,'mod_feedback',0),(235,'mod/feedback:complete','write',70,'mod_feedback',16),(236,'mod/feedback:viewanalysepage','read',70,'mod_feedback',8),(237,'mod/feedback:deletesubmissions','write',70,'mod_feedback',0),(238,'mod/feedback:mapcourse','write',70,'mod_feedback',0),(239,'mod/feedback:edititems','write',70,'mod_feedback',20),(240,'mod/feedback:createprivatetemplate','write',70,'mod_feedback',16),(241,'mod/feedback:createpublictemplate','write',70,'mod_feedback',16),(242,'mod/feedback:deletetemplate','write',70,'mod_feedback',0),(243,'mod/feedback:viewreports','read',70,'mod_feedback',8),(244,'mod/feedback:receivemail','read',70,'mod_feedback',8),(245,'mod/folder:addinstance','write',50,'mod_folder',4),(246,'mod/folder:view','read',70,'mod_folder',0),(247,'mod/folder:managefiles','write',70,'mod_folder',16),(248,'mod/forum:addinstance','write',50,'mod_forum',4),(249,'mod/forum:viewdiscussion','read',70,'mod_forum',0),(250,'mod/forum:viewhiddentimedposts','read',70,'mod_forum',0),(251,'mod/forum:startdiscussion','write',70,'mod_forum',16),(252,'mod/forum:replypost','write',70,'mod_forum',16),(253,'mod/forum:addnews','write',70,'mod_forum',16),(254,'mod/forum:replynews','write',70,'mod_forum',16),(255,'mod/forum:viewrating','read',70,'mod_forum',0),(256,'mod/forum:viewanyrating','read',70,'mod_forum',8),(257,'mod/forum:viewallratings','read',70,'mod_forum',8),(258,'mod/forum:rate','write',70,'mod_forum',0),(259,'mod/forum:createattachment','write',70,'mod_forum',16),(260,'mod/forum:deleteownpost','read',70,'mod_forum',0),(261,'mod/forum:deleteanypost','read',70,'mod_forum',0),(262,'mod/forum:splitdiscussions','read',70,'mod_forum',0),(263,'mod/forum:movediscussions','read',70,'mod_forum',0),(264,'mod/forum:editanypost','write',70,'mod_forum',16),(265,'mod/forum:viewqandawithoutposting','read',70,'mod_forum',0),(266,'mod/forum:viewsubscribers','read',70,'mod_forum',0),(267,'mod/forum:managesubscriptions','read',70,'mod_forum',16),(268,'mod/forum:postwithoutthrottling','write',70,'mod_forum',16),(269,'mod/forum:exportdiscussion','read',70,'mod_forum',8),(270,'mod/forum:exportpost','read',70,'mod_forum',8),(271,'mod/forum:exportownpost','read',70,'mod_forum',8),(272,'mod/forum:addquestion','write',70,'mod_forum',16),(273,'mod/forum:allowforcesubscribe','read',70,'mod_forum',0),(274,'mod/forum:canposttomygroups','write',70,'mod_forum',0),(275,'mod/glossary:addinstance','write',50,'mod_glossary',4),(276,'mod/glossary:view','read',70,'mod_glossary',0),(277,'mod/glossary:write','write',70,'mod_glossary',16),(278,'mod/glossary:manageentries','write',70,'mod_glossary',16),(279,'mod/glossary:managecategories','write',70,'mod_glossary',16),(280,'mod/glossary:comment','write',70,'mod_glossary',16),(281,'mod/glossary:managecomments','write',70,'mod_glossary',16),(282,'mod/glossary:import','write',70,'mod_glossary',16),(283,'mod/glossary:export','read',70,'mod_glossary',0),(284,'mod/glossary:approve','write',70,'mod_glossary',16),(285,'mod/glossary:rate','write',70,'mod_glossary',0),(286,'mod/glossary:viewrating','read',70,'mod_glossary',0),(287,'mod/glossary:viewanyrating','read',70,'mod_glossary',8),(288,'mod/glossary:viewallratings','read',70,'mod_glossary',8),(289,'mod/glossary:exportentry','read',70,'mod_glossary',8),(290,'mod/glossary:exportownentry','read',70,'mod_glossary',0),(291,'mod/imscp:view','read',70,'mod_imscp',0),(292,'mod/imscp:addinstance','write',50,'mod_imscp',4),(293,'mod/label:addinstance','write',50,'mod_label',4),(294,'mod/lesson:addinstance','write',50,'mod_lesson',4),(295,'mod/lesson:edit','write',70,'mod_lesson',4),(296,'mod/lesson:grade','write',70,'mod_lesson',20),(297,'mod/lesson:viewreports','read',70,'mod_lesson',8),(298,'mod/lesson:manage','write',70,'mod_lesson',0),(299,'mod/lesson:manageoverrides','write',70,'mod_lesson',0),(300,'mod/lti:view','read',70,'mod_lti',0),(301,'mod/lti:addinstance','write',50,'mod_lti',4),(302,'mod/lti:manage','write',70,'mod_lti',8),(303,'mod/lti:addcoursetool','write',50,'mod_lti',0),(304,'mod/lti:requesttooladd','write',50,'mod_lti',0),(305,'mod/page:view','read',70,'mod_page',0),(306,'mod/page:addinstance','write',50,'mod_page',4),(307,'mod/quiz:view','read',70,'mod_quiz',0),(308,'mod/quiz:addinstance','write',50,'mod_quiz',4),(309,'mod/quiz:attempt','write',70,'mod_quiz',16),(310,'mod/quiz:reviewmyattempts','read',70,'mod_quiz',0),(311,'mod/quiz:manage','write',70,'mod_quiz',16),(312,'mod/quiz:manageoverrides','write',70,'mod_quiz',0),(313,'mod/quiz:preview','write',70,'mod_quiz',0),(314,'mod/quiz:grade','write',70,'mod_quiz',20),(315,'mod/quiz:regrade','write',70,'mod_quiz',16),(316,'mod/quiz:viewreports','read',70,'mod_quiz',8),(317,'mod/quiz:deleteattempts','write',70,'mod_quiz',32),(318,'mod/quiz:ignoretimelimits','read',70,'mod_quiz',0),(319,'mod/quiz:emailconfirmsubmission','read',70,'mod_quiz',0),(320,'mod/quiz:emailnotifysubmission','read',70,'mod_quiz',0),(321,'mod/quiz:emailwarnoverdue','read',70,'mod_quiz',0),(322,'mod/resource:view','read',70,'mod_resource',0),(323,'mod/resource:addinstance','write',50,'mod_resource',4),(324,'mod/scorm:addinstance','write',50,'mod_scorm',4),(325,'mod/scorm:viewreport','read',70,'mod_scorm',0),(326,'mod/scorm:skipview','read',70,'mod_scorm',0),(327,'mod/scorm:savetrack','write',70,'mod_scorm',0),(328,'mod/scorm:viewscores','read',70,'mod_scorm',0),(329,'mod/scorm:deleteresponses','write',70,'mod_scorm',0),(330,'mod/scorm:deleteownresponses','write',70,'mod_scorm',0),(331,'mod/survey:addinstance','write',50,'mod_survey',4),(332,'mod/survey:participate','read',70,'mod_survey',0),(333,'mod/survey:readresponses','read',70,'mod_survey',0),(334,'mod/survey:download','read',70,'mod_survey',0),(335,'mod/url:view','read',70,'mod_url',0),(336,'mod/url:addinstance','write',50,'mod_url',4),(337,'mod/wiki:addinstance','write',50,'mod_wiki',4),(338,'mod/wiki:viewpage','read',70,'mod_wiki',0),(339,'mod/wiki:editpage','write',70,'mod_wiki',16),(340,'mod/wiki:createpage','write',70,'mod_wiki',16),(341,'mod/wiki:viewcomment','read',70,'mod_wiki',0),(342,'mod/wiki:editcomment','write',70,'mod_wiki',16),(343,'mod/wiki:managecomment','write',70,'mod_wiki',0),(344,'mod/wiki:managefiles','write',70,'mod_wiki',0),(345,'mod/wiki:overridelock','write',70,'mod_wiki',0),(346,'mod/wiki:managewiki','write',70,'mod_wiki',0),(347,'mod/workshop:view','read',70,'mod_workshop',0),(348,'mod/workshop:addinstance','write',50,'mod_workshop',4),(349,'mod/workshop:switchphase','write',70,'mod_workshop',0),(350,'mod/workshop:editdimensions','write',70,'mod_workshop',4),(351,'mod/workshop:submit','write',70,'mod_workshop',0),(352,'mod/workshop:peerassess','write',70,'mod_workshop',0),(353,'mod/workshop:manageexamples','write',70,'mod_workshop',0),(354,'mod/workshop:allocate','write',70,'mod_workshop',0),(355,'mod/workshop:publishsubmissions','write',70,'mod_workshop',0),(356,'mod/workshop:viewauthornames','read',70,'mod_workshop',0),(357,'mod/workshop:viewreviewernames','read',70,'mod_workshop',0),(358,'mod/workshop:viewallsubmissions','read',70,'mod_workshop',0),(359,'mod/workshop:viewpublishedsubmissions','read',70,'mod_workshop',0),(360,'mod/workshop:viewauthorpublished','read',70,'mod_workshop',0),(361,'mod/workshop:viewallassessments','read',70,'mod_workshop',0),(362,'mod/workshop:overridegrades','write',70,'mod_workshop',0),(363,'mod/workshop:ignoredeadlines','write',70,'mod_workshop',0),(364,'enrol/category:synchronised','write',10,'enrol_category',0),(365,'enrol/category:config','write',50,'enrol_category',0),(366,'enrol/cohort:config','write',50,'enrol_cohort',0),(367,'enrol/cohort:unenrol','write',50,'enrol_cohort',0),(368,'enrol/database:unenrol','write',50,'enrol_database',0),(369,'enrol/database:config','write',50,'enrol_database',0),(370,'enrol/flatfile:manage','write',50,'enrol_flatfile',0),(371,'enrol/flatfile:unenrol','write',50,'enrol_flatfile',0),(372,'enrol/guest:config','write',50,'enrol_guest',0),(373,'enrol/imsenterprise:config','write',50,'enrol_imsenterprise',0),(374,'enrol/ldap:manage','write',50,'enrol_ldap',0),(375,'enrol/manual:config','write',50,'enrol_manual',0),(376,'enrol/manual:enrol','write',50,'enrol_manual',0),(377,'enrol/manual:manage','write',50,'enrol_manual',0),(378,'enrol/manual:unenrol','write',50,'enrol_manual',0),(379,'enrol/manual:unenrolself','write',50,'enrol_manual',0),(380,'enrol/meta:config','write',50,'enrol_meta',0),(381,'enrol/meta:selectaslinked','read',50,'enrol_meta',0),(382,'enrol/meta:unenrol','write',50,'enrol_meta',0),(383,'enrol/mnet:config','write',50,'enrol_mnet',0),(384,'enrol/paypal:config','write',50,'enrol_paypal',0),(385,'enrol/paypal:manage','write',50,'enrol_paypal',0),(386,'enrol/paypal:unenrol','write',50,'enrol_paypal',0),(387,'enrol/paypal:unenrolself','write',50,'enrol_paypal',0),(388,'enrol/self:config','write',50,'enrol_self',0),(389,'enrol/self:manage','write',50,'enrol_self',0),(390,'enrol/self:holdkey','write',50,'enrol_self',0),(391,'enrol/self:unenrolself','write',50,'enrol_self',0),(392,'enrol/self:unenrol','write',50,'enrol_self',0),(393,'message/airnotifier:managedevice','write',10,'message_airnotifier',0),(394,'block/activity_modules:addinstance','write',80,'block_activity_modules',20),(395,'block/activity_results:addinstance','write',80,'block_activity_results',20),(396,'block/admin_bookmarks:myaddinstance','write',10,'block_admin_bookmarks',0),(397,'block/admin_bookmarks:addinstance','write',80,'block_admin_bookmarks',20),(398,'block/badges:addinstance','read',80,'block_badges',0),(399,'block/badges:myaddinstance','read',10,'block_badges',8),(400,'block/blog_menu:addinstance','write',80,'block_blog_menu',20),(401,'block/blog_recent:addinstance','write',80,'block_blog_recent',20),(402,'block/blog_tags:addinstance','write',80,'block_blog_tags',20),(403,'block/calendar_month:myaddinstance','write',10,'block_calendar_month',0),(404,'block/calendar_month:addinstance','write',80,'block_calendar_month',20),(405,'block/calendar_upcoming:myaddinstance','write',10,'block_calendar_upcoming',0),(406,'block/calendar_upcoming:addinstance','write',80,'block_calendar_upcoming',20),(407,'block/comments:myaddinstance','write',10,'block_comments',0),(408,'block/comments:addinstance','write',80,'block_comments',20),(409,'block/community:myaddinstance','write',10,'block_community',0),(410,'block/community:addinstance','write',80,'block_community',20),(411,'block/completionstatus:addinstance','write',80,'block_completionstatus',20),(412,'block/course_list:myaddinstance','write',10,'block_course_list',0),(413,'block/course_list:addinstance','write',80,'block_course_list',20),(414,'block/course_overview:myaddinstance','write',10,'block_course_overview',0),(415,'block/course_overview:addinstance','write',80,'block_course_overview',20),(416,'block/course_summary:addinstance','write',80,'block_course_summary',20),(417,'block/feedback:addinstance','write',80,'block_feedback',20),(418,'block/glossary_random:myaddinstance','write',10,'block_glossary_random',0),(419,'block/glossary_random:addinstance','write',80,'block_glossary_random',20),(420,'block/html:myaddinstance','write',10,'block_html',0),(421,'block/html:addinstance','write',80,'block_html',20),(422,'block/login:addinstance','write',80,'block_login',20),(423,'block/mentees:myaddinstance','write',10,'block_mentees',0),(424,'block/mentees:addinstance','write',80,'block_mentees',20),(425,'block/messages:myaddinstance','write',10,'block_messages',0),(426,'block/messages:addinstance','write',80,'block_messages',20),(427,'block/mnet_hosts:myaddinstance','write',10,'block_mnet_hosts',0),(428,'block/mnet_hosts:addinstance','write',80,'block_mnet_hosts',20),(429,'block/myprofile:myaddinstance','write',10,'block_myprofile',0),(430,'block/myprofile:addinstance','write',80,'block_myprofile',20),(431,'block/navigation:myaddinstance','write',10,'block_navigation',0),(432,'block/navigation:addinstance','write',80,'block_navigation',20),(433,'block/news_items:myaddinstance','write',10,'block_news_items',0),(434,'block/news_items:addinstance','write',80,'block_news_items',20),(435,'block/online_users:myaddinstance','write',10,'block_online_users',0),(436,'block/online_users:addinstance','write',80,'block_online_users',20),(437,'block/online_users:viewlist','read',80,'block_online_users',0),(438,'block/participants:addinstance','write',80,'block_participants',20),(439,'block/private_files:myaddinstance','write',10,'block_private_files',0),(440,'block/private_files:addinstance','write',80,'block_private_files',20),(441,'block/quiz_results:addinstance','write',80,'block_quiz_results',20),(442,'block/recent_activity:addinstance','write',80,'block_recent_activity',20),(443,'block/recent_activity:viewaddupdatemodule','read',50,'block_recent_activity',0),(444,'block/recent_activity:viewdeletemodule','read',50,'block_recent_activity',0),(445,'block/rss_client:myaddinstance','write',10,'block_rss_client',0),(446,'block/rss_client:addinstance','write',80,'block_rss_client',20),(447,'block/rss_client:manageownfeeds','write',80,'block_rss_client',0),(448,'block/rss_client:manageanyfeeds','write',80,'block_rss_client',16),(449,'block/search_forums:addinstance','write',80,'block_search_forums',20),(450,'block/section_links:addinstance','write',80,'block_section_links',20),(451,'block/selfcompletion:addinstance','write',80,'block_selfcompletion',20),(452,'block/settings:myaddinstance','write',10,'block_settings',0),(453,'block/settings:addinstance','write',80,'block_settings',20),(454,'block/site_main_menu:addinstance','write',80,'block_site_main_menu',20),(455,'block/social_activities:addinstance','write',80,'block_social_activities',20),(456,'block/tag_flickr:addinstance','write',80,'block_tag_flickr',20),(457,'block/tag_youtube:addinstance','write',80,'block_tag_youtube',20),(458,'block/tags:myaddinstance','write',10,'block_tags',0),(459,'block/tags:addinstance','write',80,'block_tags',20),(460,'report/completion:view','read',50,'report_completion',8),(461,'report/courseoverview:view','read',10,'report_courseoverview',8),(462,'report/log:view','read',50,'report_log',8),(463,'report/log:viewtoday','read',50,'report_log',8),(464,'report/loglive:view','read',50,'report_loglive',8),(465,'report/outline:view','read',50,'report_outline',8),(466,'report/participation:view','read',50,'report_participation',8),(467,'report/performance:view','read',10,'report_performance',2),(468,'report/progress:view','read',50,'report_progress',8),(469,'report/questioninstances:view','read',10,'report_questioninstances',0),(470,'report/security:view','read',10,'report_security',2),(471,'report/stats:view','read',50,'report_stats',8),(472,'report/usersessions:manageownsessions','write',30,'report_usersessions',0),(473,'gradeexport/ods:view','read',50,'gradeexport_ods',8),(474,'gradeexport/ods:publish','read',50,'gradeexport_ods',8),(475,'gradeexport/txt:view','read',50,'gradeexport_txt',8),(476,'gradeexport/txt:publish','read',50,'gradeexport_txt',8),(477,'gradeexport/xls:view','read',50,'gradeexport_xls',8),(478,'gradeexport/xls:publish','read',50,'gradeexport_xls',8),(479,'gradeexport/xml:view','read',50,'gradeexport_xml',8),(480,'gradeexport/xml:publish','read',50,'gradeexport_xml',8),(481,'gradeimport/csv:view','write',50,'gradeimport_csv',0),(482,'gradeimport/direct:view','write',50,'gradeimport_direct',0),(483,'gradeimport/xml:view','write',50,'gradeimport_xml',0),(484,'gradeimport/xml:publish','write',50,'gradeimport_xml',0),(485,'gradereport/grader:view','read',50,'gradereport_grader',8),(486,'gradereport/history:view','read',50,'gradereport_history',8),(487,'gradereport/outcomes:view','read',50,'gradereport_outcomes',8),(488,'gradereport/overview:view','read',50,'gradereport_overview',8),(489,'gradereport/singleview:view','read',50,'gradereport_singleview',8),(490,'gradereport/user:view','read',50,'gradereport_user',8),(491,'webservice/amf:use','read',50,'webservice_amf',0),(492,'webservice/rest:use','read',50,'webservice_rest',0),(493,'webservice/soap:use','read',50,'webservice_soap',0),(494,'webservice/xmlrpc:use','read',50,'webservice_xmlrpc',0),(495,'repository/alfresco:view','read',70,'repository_alfresco',0),(496,'repository/areafiles:view','read',70,'repository_areafiles',0),(497,'repository/boxnet:view','read',70,'repository_boxnet',0),(498,'repository/coursefiles:view','read',70,'repository_coursefiles',0),(499,'repository/dropbox:view','read',70,'repository_dropbox',0),(500,'repository/equella:view','read',70,'repository_equella',0),(501,'repository/filesystem:view','read',70,'repository_filesystem',0),(502,'repository/flickr:view','read',70,'repository_flickr',0),(503,'repository/flickr_public:view','read',70,'repository_flickr_public',0),(504,'repository/googledocs:view','read',70,'repository_googledocs',0),(505,'repository/local:view','read',70,'repository_local',0),(506,'repository/merlot:view','read',70,'repository_merlot',0),(507,'repository/picasa:view','read',70,'repository_picasa',0),(508,'repository/recent:view','read',70,'repository_recent',0),(509,'repository/s3:view','read',70,'repository_s3',0),(510,'repository/skydrive:view','read',70,'repository_skydrive',0),(511,'repository/upload:view','read',70,'repository_upload',0),(512,'repository/url:view','read',70,'repository_url',0),(513,'repository/user:view','read',70,'repository_user',0),(514,'repository/webdav:view','read',70,'repository_webdav',0),(515,'repository/wikimedia:view','read',70,'repository_wikimedia',0),(516,'repository/youtube:view','read',70,'repository_youtube',0),(517,'tool/customlang:view','read',10,'tool_customlang',2),(518,'tool/customlang:edit','write',10,'tool_customlang',6),(519,'tool/monitor:subscribe','read',50,'tool_monitor',8),(520,'tool/monitor:managerules','write',50,'tool_monitor',4),(521,'tool/monitor:managetool','write',10,'tool_monitor',4),(522,'tool/uploaduser:uploaduserpictures','write',10,'tool_uploaduser',16),(523,'booktool/exportimscp:export','read',70,'booktool_exportimscp',0),(524,'booktool/importhtml:import','write',70,'booktool_importhtml',4),(525,'booktool/print:print','read',70,'booktool_print',0),(526,'quiz/grading:viewstudentnames','read',70,'quiz_grading',0),(527,'quiz/grading:viewidnumber','read',70,'quiz_grading',0),(528,'quiz/statistics:view','read',70,'quiz_statistics',0);
/*!40000 ALTER TABLE `mdl_capabilities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_chat`
--

DROP TABLE IF EXISTS `mdl_chat`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_chat` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8_unicode_ci NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `keepdays` bigint(11) NOT NULL DEFAULT '0',
  `studentlogs` smallint(4) NOT NULL DEFAULT '0',
  `chattime` bigint(10) NOT NULL DEFAULT '0',
  `schedule` smallint(4) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_chat_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Each of these is a chat room';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_chat`
--

LOCK TABLES `mdl_chat` WRITE;
/*!40000 ALTER TABLE `mdl_chat` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_chat` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_chat_messages`
--

DROP TABLE IF EXISTS `mdl_chat_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_chat_messages` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `chatid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `system` tinyint(1) NOT NULL DEFAULT '0',
  `message` longtext COLLATE utf8_unicode_ci NOT NULL,
  `timestamp` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_chatmess_use_ix` (`userid`),
  KEY `mdl_chatmess_gro_ix` (`groupid`),
  KEY `mdl_chatmess_timcha_ix` (`timestamp`,`chatid`),
  KEY `mdl_chatmess_cha_ix` (`chatid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Stores all the actual chat messages';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_chat_messages`
--

LOCK TABLES `mdl_chat_messages` WRITE;
/*!40000 ALTER TABLE `mdl_chat_messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_chat_messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_chat_messages_current`
--

DROP TABLE IF EXISTS `mdl_chat_messages_current`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_chat_messages_current` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `chatid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `system` tinyint(1) NOT NULL DEFAULT '0',
  `message` longtext COLLATE utf8_unicode_ci NOT NULL,
  `timestamp` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_chatmesscurr_use_ix` (`userid`),
  KEY `mdl_chatmesscurr_gro_ix` (`groupid`),
  KEY `mdl_chatmesscurr_timcha_ix` (`timestamp`,`chatid`),
  KEY `mdl_chatmesscurr_cha_ix` (`chatid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Stores current session';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_chat_messages_current`
--

LOCK TABLES `mdl_chat_messages_current` WRITE;
/*!40000 ALTER TABLE `mdl_chat_messages_current` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_chat_messages_current` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_chat_users`
--

DROP TABLE IF EXISTS `mdl_chat_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_chat_users` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `chatid` bigint(11) NOT NULL DEFAULT '0',
  `userid` bigint(11) NOT NULL DEFAULT '0',
  `groupid` bigint(11) NOT NULL DEFAULT '0',
  `version` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ip` varchar(45) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `firstping` bigint(10) NOT NULL DEFAULT '0',
  `lastping` bigint(10) NOT NULL DEFAULT '0',
  `lastmessageping` bigint(10) NOT NULL DEFAULT '0',
  `sid` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `course` bigint(10) NOT NULL DEFAULT '0',
  `lang` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mdl_chatuser_use_ix` (`userid`),
  KEY `mdl_chatuser_las_ix` (`lastping`),
  KEY `mdl_chatuser_gro_ix` (`groupid`),
  KEY `mdl_chatuser_cha_ix` (`chatid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Keeps track of which users are in which chat rooms';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_chat_users`
--

LOCK TABLES `mdl_chat_users` WRITE;
/*!40000 ALTER TABLE `mdl_chat_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_chat_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_choice`
--

DROP TABLE IF EXISTS `mdl_choice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_choice` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8_unicode_ci NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `publish` tinyint(2) NOT NULL DEFAULT '0',
  `showresults` tinyint(2) NOT NULL DEFAULT '0',
  `display` smallint(4) NOT NULL DEFAULT '0',
  `allowupdate` tinyint(2) NOT NULL DEFAULT '0',
  `allowmultiple` tinyint(2) NOT NULL DEFAULT '0',
  `showunanswered` tinyint(2) NOT NULL DEFAULT '0',
  `includeinactive` tinyint(2) NOT NULL DEFAULT '1',
  `limitanswers` tinyint(2) NOT NULL DEFAULT '0',
  `timeopen` bigint(10) NOT NULL DEFAULT '0',
  `timeclose` bigint(10) NOT NULL DEFAULT '0',
  `showpreview` tinyint(2) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `completionsubmit` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_choi_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Available choices are stored here';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_choice`
--

LOCK TABLES `mdl_choice` WRITE;
/*!40000 ALTER TABLE `mdl_choice` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_choice` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_choice_answers`
--

DROP TABLE IF EXISTS `mdl_choice_answers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_choice_answers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `choiceid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `optionid` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_choiansw_use_ix` (`userid`),
  KEY `mdl_choiansw_cho_ix` (`choiceid`),
  KEY `mdl_choiansw_opt_ix` (`optionid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='choices performed by users';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_choice_answers`
--

LOCK TABLES `mdl_choice_answers` WRITE;
/*!40000 ALTER TABLE `mdl_choice_answers` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_choice_answers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_choice_options`
--

DROP TABLE IF EXISTS `mdl_choice_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_choice_options` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `choiceid` bigint(10) NOT NULL DEFAULT '0',
  `text` longtext COLLATE utf8_unicode_ci,
  `maxanswers` bigint(10) DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_choiopti_cho_ix` (`choiceid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='available options to choice';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_choice_options`
--

LOCK TABLES `mdl_choice_options` WRITE;
/*!40000 ALTER TABLE `mdl_choice_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_choice_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_cohort`
--

DROP TABLE IF EXISTS `mdl_cohort`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_cohort` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `name` varchar(254) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `idnumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8_unicode_ci,
  `descriptionformat` tinyint(2) NOT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `component` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_coho_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Each record represents one cohort (aka site-wide group).';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_cohort`
--

LOCK TABLES `mdl_cohort` WRITE;
/*!40000 ALTER TABLE `mdl_cohort` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_cohort` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_cohort_members`
--

DROP TABLE IF EXISTS `mdl_cohort_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_cohort_members` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `cohortid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timeadded` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_cohomemb_cohuse_uix` (`cohortid`,`userid`),
  KEY `mdl_cohomemb_coh_ix` (`cohortid`),
  KEY `mdl_cohomemb_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Link a user to a cohort.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_cohort_members`
--

LOCK TABLES `mdl_cohort_members` WRITE;
/*!40000 ALTER TABLE `mdl_cohort_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_cohort_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_comments`
--

DROP TABLE IF EXISTS `mdl_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_comments` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `component` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `commentarea` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL,
  `content` longtext COLLATE utf8_unicode_ci NOT NULL,
  `format` tinyint(2) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='moodle comments module';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_comments`
--

LOCK TABLES `mdl_comments` WRITE;
/*!40000 ALTER TABLE `mdl_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_config`
--

DROP TABLE IF EXISTS `mdl_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_config` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_conf_nam_uix` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=473 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Moodle configuration variables';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_config`
--

LOCK TABLES `mdl_config` WRITE;
/*!40000 ALTER TABLE `mdl_config` DISABLE KEYS */;
INSERT INTO `mdl_config` VALUES (2,'rolesactive','1'),(3,'auth','email'),(4,'auth_pop3mailbox','INBOX'),(5,'enrol_plugins_enabled','manual,guest,self,cohort'),(6,'theme','clean'),(7,'filter_multilang_converted','1'),(8,'siteidentifier','dBmCqZmaXQs0X5NyyuSCAQGH73yfGArZsprucelogin.com'),(9,'backup_version','2008111700'),(10,'backup_release','2.0 dev'),(11,'mnet_dispatcher_mode','off'),(12,'sessiontimeout','7200'),(13,'stringfilters',''),(14,'filterall','0'),(15,'texteditors','atto,tinymce,textarea'),(16,'upgrade_minmaxgradestepignored','1'),(17,'upgrade_extracreditweightsstepignored','1'),(18,'upgrade_calculatedgradeitemsignored','1'),(19,'mnet_localhost_id','1'),(20,'mnet_all_hosts_id','2'),(21,'siteguest','1'),(22,'siteadmins','2,4'),(23,'themerev','1462734501'),(24,'jsrev','1462734501'),(25,'gdversion','2'),(26,'licenses','unknown,allrightsreserved,public,cc,cc-nd,cc-nc-nd,cc-nc,cc-nc-sa,cc-sa'),(27,'version','2015111603.09'),(28,'enableoutcomes','0'),(29,'usecomments','1'),(30,'usetags','1'),(31,'enablenotes','1'),(32,'enableportfolios','0'),(33,'enablewebservices','0'),(34,'messaging','1'),(35,'messaginghidereadnotifications','0'),(36,'messagingdeletereadnotificationsdelay','604800'),(37,'messagingallowemailoverride','0'),(38,'enablestats','0'),(39,'enablerssfeeds','0'),(40,'enableblogs','1'),(41,'enablecompletion','1'),(42,'completiondefault','1'),(43,'enableavailability','0'),(44,'enableplagiarism','0'),(45,'enablebadges','1'),(46,'defaultpreference_maildisplay','2'),(47,'defaultpreference_mailformat','1'),(48,'defaultpreference_maildigest','0'),(49,'defaultpreference_autosubscribe','1'),(50,'defaultpreference_trackforums','0'),(51,'autologinguests','0'),(52,'hiddenuserfields',''),(53,'showuseridentity','email'),(54,'fullnamedisplay','language'),(55,'alternativefullnameformat','language'),(56,'maxusersperpage','100'),(57,'enablegravatar','0'),(58,'gravatardefaulturl','mm'),(59,'enablecourserequests','0'),(60,'defaultrequestcategory','1'),(61,'requestcategoryselection','0'),(62,'courserequestnotify',''),(63,'grade_profilereport','user'),(64,'grade_aggregationposition','1'),(65,'grade_includescalesinaggregation','1'),(66,'grade_hiddenasdate','0'),(67,'gradepublishing','0'),(68,'grade_export_displaytype','1'),(69,'grade_export_decimalpoints','2'),(70,'grade_navmethod','0'),(71,'grade_export_userprofilefields','firstname,lastname,idnumber,institution,department,email'),(72,'grade_export_customprofilefields',''),(73,'recovergradesdefault','0'),(74,'gradeexport',''),(75,'unlimitedgrades','0'),(76,'grade_report_showmin','1'),(77,'gradepointmax','100'),(78,'gradepointdefault','100'),(79,'grade_minmaxtouse','1'),(80,'grade_mygrades_report','overview'),(81,'gradereport_mygradeurl',''),(82,'grade_hideforcedsettings','1'),(83,'grade_aggregation','13'),(84,'grade_aggregation_flag','0'),(85,'grade_aggregations_visible','13'),(86,'grade_aggregateonlygraded','1'),(87,'grade_aggregateonlygraded_flag','2'),(88,'grade_aggregateoutcomes','0'),(89,'grade_aggregateoutcomes_flag','2'),(90,'grade_keephigh','0'),(91,'grade_keephigh_flag','3'),(92,'grade_droplow','0'),(93,'grade_droplow_flag','2'),(94,'grade_overridecat','1'),(95,'grade_displaytype','1'),(96,'grade_decimalpoints','2'),(97,'grade_item_advanced','iteminfo,idnumber,gradepass,plusfactor,multfactor,display,decimals,hiddenuntil,locktime'),(98,'grade_report_studentsperpage','100'),(99,'grade_report_showonlyactiveenrol','1'),(100,'grade_report_quickgrading','1'),(101,'grade_report_showquickfeedback','0'),(102,'grade_report_meanselection','1'),(103,'grade_report_enableajax','0'),(104,'grade_report_showcalculations','1'),(105,'grade_report_showeyecons','0'),(106,'grade_report_showaverages','1'),(107,'grade_report_showlocks','0'),(108,'grade_report_showranges','0'),(109,'grade_report_showanalysisicon','1'),(110,'grade_report_showuserimage','1'),(111,'grade_report_showactivityicons','1'),(112,'grade_report_shownumberofgrades','0'),(113,'grade_report_averagesdisplaytype','inherit'),(114,'grade_report_rangesdisplaytype','inherit'),(115,'grade_report_averagesdecimalpoints','inherit'),(116,'grade_report_rangesdecimalpoints','inherit'),(117,'grade_report_historyperpage','50'),(118,'grade_report_overview_showrank','0'),(119,'grade_report_overview_showtotalsifcontainhidden','0'),(120,'grade_report_user_showrank','0'),(121,'grade_report_user_showpercentage','1'),(122,'grade_report_user_showgrade','1'),(123,'grade_report_user_showfeedback','1'),(124,'grade_report_user_showrange','1'),(125,'grade_report_user_showweight','1'),(126,'grade_report_user_showaverage','0'),(127,'grade_report_user_showlettergrade','0'),(128,'grade_report_user_rangedecimals','0'),(129,'grade_report_user_showhiddenitems','1'),(130,'grade_report_user_showtotalsifcontainhidden','0'),(131,'grade_report_user_showcontributiontocoursetotal','1'),(132,'badges_defaultissuername',''),(133,'badges_defaultissuercontact',''),(134,'badges_badgesalt','badges1462257482'),(135,'badges_allowexternalbackpack','1'),(136,'badges_allowcoursebadges','1'),(137,'forcetimezone','99'),(138,'country','0'),(139,'defaultcity',''),(140,'geoipfile','/home/sprucelogin/moodledata/geoip/GeoLiteCity.dat'),(141,'googlemapkey3',''),(142,'allcountrycodes',''),(143,'autolang','1'),(144,'lang','en'),(145,'langmenu','1'),(146,'langlist',''),(147,'langrev','1462734501'),(148,'langcache','1'),(149,'langstringcache','1'),(150,'locale',''),(151,'latinexcelexport','0'),(152,'requiremodintro','0'),(154,'authloginviaemail','0'),(155,'allowaccountssameemail','0'),(156,'authpreventaccountcreation','0'),(157,'loginpageautofocus','0'),(158,'guestloginbutton','1'),(159,'limitconcurrentlogins','0'),(160,'alternateloginurl',''),(161,'forgottenpasswordurl',''),(162,'auth_instructions',''),(163,'allowemailaddresses',''),(164,'denyemailaddresses',''),(165,'verifychangedemail','1'),(166,'recaptchapublickey',''),(167,'recaptchaprivatekey',''),(168,'filteruploadedfiles','0'),(169,'filtermatchoneperpage','0'),(170,'filtermatchonepertext','0'),(171,'sitedefaultlicense','allrightsreserved'),(172,'portfolio_moderate_filesize_threshold','1048576'),(173,'portfolio_high_filesize_threshold','5242880'),(174,'portfolio_moderate_db_threshold','20'),(175,'portfolio_high_db_threshold','50'),(176,'repositorycacheexpire','120'),(177,'repositorygetfiletimeout','30'),(178,'repositorysyncfiletimeout','1'),(179,'repositorysyncimagetimeout','3'),(180,'repositoryallowexternallinks','1'),(181,'legacyfilesinnewcourses','0'),(182,'legacyfilesaddallowed','1'),(183,'mobilecssurl',''),(184,'enablewsdocumentation','0'),(185,'allowbeforeblock','0'),(186,'allowedip',''),(187,'blockedip',''),(188,'protectusernames','1'),(189,'forcelogin','0'),(190,'forceloginforprofiles','1'),(191,'forceloginforprofileimage','0'),(192,'opentogoogle','0'),(193,'maxbytes','0'),(194,'userquota','104857600'),(195,'allowobjectembed','0'),(196,'enabletrusttext','0'),(197,'maxeditingtime','1800'),(198,'extendedusernamechars','0'),(199,'sitepolicy',''),(200,'sitepolicyguest',''),(201,'keeptagnamecase','1'),(202,'profilesforenrolledusersonly','1'),(203,'cronclionly','1'),(204,'cronremotepassword',''),(205,'lockoutthreshold','0'),(206,'lockoutwindow','1800'),(207,'lockoutduration','1800'),(208,'passwordpolicy','1'),(209,'minpasswordlength','8'),(210,'minpassworddigits','1'),(211,'minpasswordlower','1'),(212,'minpasswordupper','1'),(213,'minpasswordnonalphanum','1'),(214,'maxconsecutiveidentchars','0'),(215,'passwordreuselimit','0'),(216,'pwresettime','1800'),(217,'passwordchangelogout','0'),(218,'groupenrolmentkeypolicy','1'),(219,'disableuserimages','0'),(220,'emailchangeconfirmation','1'),(221,'rememberusername','2'),(222,'strictformsrequired','0'),(223,'loginhttps','0'),(224,'cookiesecure','0'),(225,'cookiehttponly','0'),(226,'allowframembedding','0'),(227,'loginpasswordautocomplete','0'),(228,'displayloginfailures','0'),(229,'notifyloginfailures',''),(230,'notifyloginthreshold','10'),(231,'runclamonupload','0'),(232,'pathtoclam',''),(233,'quarantinedir',''),(234,'clamfailureonupload','donothing'),(235,'themelist',''),(236,'themedesignermode','0'),(237,'allowuserthemes','0'),(238,'allowcoursethemes','0'),(239,'allowcategorythemes','0'),(240,'allowthemechangeonurl','0'),(241,'allowuserblockhiding','1'),(242,'allowblockstodock','1'),(243,'custommenuitems',''),(244,'customusermenuitems','grades,grades|/grade/report/mygrades.php|grades\nmessages,message|/message/index.php|message\npreferences,moodle|/user/preferences.php|preferences'),(245,'enabledevicedetection','1'),(246,'devicedetectregex','[]'),(247,'calendartype','gregorian'),(248,'calendar_adminseesall','0'),(249,'calendar_site_timeformat','0'),(250,'calendar_startwday','1'),(251,'calendar_weekend','65'),(252,'calendar_lookahead','21'),(253,'calendar_maxevents','10'),(254,'enablecalendarexport','1'),(255,'calendar_customexport','1'),(256,'calendar_exportlookahead','365'),(257,'calendar_exportlookback','5'),(258,'calendar_exportsalt','5rMPBxsAVtL9h9FUvwqbMhDLHBzCTUXcrV11bidZ7hKw2REImI77aaw6tH2r'),(259,'calendar_showicalsource','1'),(260,'useblogassociations','1'),(261,'bloglevel','4'),(262,'useexternalblogs','1'),(263,'externalblogcrontime','86400'),(264,'maxexternalblogsperuser','1'),(265,'blogusecomments','1'),(266,'blogshowcommentscount','1'),(267,'defaulthomepage','1'),(268,'allowguestmymoodle','1'),(269,'navshowfullcoursenames','0'),(270,'navshowcategories','1'),(271,'navshowmycoursecategories','0'),(272,'navshowallcourses','0'),(273,'navexpandmycourses','1'),(274,'navsortmycoursessort','sortorder'),(275,'navcourselimit','20'),(276,'usesitenameforsitepages','0'),(277,'linkadmincategories','0'),(278,'linkcoursesections','0'),(279,'navshowfrontpagemods','1'),(280,'navadduserpostslinks','1'),(281,'formatstringstriptags','1'),(282,'emoticons','[{\"text\":\":-)\",\"imagename\":\"s\\/smiley\",\"imagecomponent\":\"core\",\"altidentifier\":\"smiley\",\"altcomponent\":\"core_pix\"},{\"text\":\":)\",\"imagename\":\"s\\/smiley\",\"imagecomponent\":\"core\",\"altidentifier\":\"smiley\",\"altcomponent\":\"core_pix\"},{\"text\":\":-D\",\"imagename\":\"s\\/biggrin\",\"imagecomponent\":\"core\",\"altidentifier\":\"biggrin\",\"altcomponent\":\"core_pix\"},{\"text\":\";-)\",\"imagename\":\"s\\/wink\",\"imagecomponent\":\"core\",\"altidentifier\":\"wink\",\"altcomponent\":\"core_pix\"},{\"text\":\":-\\/\",\"imagename\":\"s\\/mixed\",\"imagecomponent\":\"core\",\"altidentifier\":\"mixed\",\"altcomponent\":\"core_pix\"},{\"text\":\"V-.\",\"imagename\":\"s\\/thoughtful\",\"imagecomponent\":\"core\",\"altidentifier\":\"thoughtful\",\"altcomponent\":\"core_pix\"},{\"text\":\":-P\",\"imagename\":\"s\\/tongueout\",\"imagecomponent\":\"core\",\"altidentifier\":\"tongueout\",\"altcomponent\":\"core_pix\"},{\"text\":\":-p\",\"imagename\":\"s\\/tongueout\",\"imagecomponent\":\"core\",\"altidentifier\":\"tongueout\",\"altcomponent\":\"core_pix\"},{\"text\":\"B-)\",\"imagename\":\"s\\/cool\",\"imagecomponent\":\"core\",\"altidentifier\":\"cool\",\"altcomponent\":\"core_pix\"},{\"text\":\"^-)\",\"imagename\":\"s\\/approve\",\"imagecomponent\":\"core\",\"altidentifier\":\"approve\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-)\",\"imagename\":\"s\\/wideeyes\",\"imagecomponent\":\"core\",\"altidentifier\":\"wideeyes\",\"altcomponent\":\"core_pix\"},{\"text\":\":o)\",\"imagename\":\"s\\/clown\",\"imagecomponent\":\"core\",\"altidentifier\":\"clown\",\"altcomponent\":\"core_pix\"},{\"text\":\":-(\",\"imagename\":\"s\\/sad\",\"imagecomponent\":\"core\",\"altidentifier\":\"sad\",\"altcomponent\":\"core_pix\"},{\"text\":\":(\",\"imagename\":\"s\\/sad\",\"imagecomponent\":\"core\",\"altidentifier\":\"sad\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-.\",\"imagename\":\"s\\/shy\",\"imagecomponent\":\"core\",\"altidentifier\":\"shy\",\"altcomponent\":\"core_pix\"},{\"text\":\":-I\",\"imagename\":\"s\\/blush\",\"imagecomponent\":\"core\",\"altidentifier\":\"blush\",\"altcomponent\":\"core_pix\"},{\"text\":\":-X\",\"imagename\":\"s\\/kiss\",\"imagecomponent\":\"core\",\"altidentifier\":\"kiss\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-o\",\"imagename\":\"s\\/surprise\",\"imagecomponent\":\"core\",\"altidentifier\":\"surprise\",\"altcomponent\":\"core_pix\"},{\"text\":\"P-|\",\"imagename\":\"s\\/blackeye\",\"imagecomponent\":\"core\",\"altidentifier\":\"blackeye\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-[\",\"imagename\":\"s\\/angry\",\"imagecomponent\":\"core\",\"altidentifier\":\"angry\",\"altcomponent\":\"core_pix\"},{\"text\":\"(grr)\",\"imagename\":\"s\\/angry\",\"imagecomponent\":\"core\",\"altidentifier\":\"angry\",\"altcomponent\":\"core_pix\"},{\"text\":\"xx-P\",\"imagename\":\"s\\/dead\",\"imagecomponent\":\"core\",\"altidentifier\":\"dead\",\"altcomponent\":\"core_pix\"},{\"text\":\"|-.\",\"imagename\":\"s\\/sleepy\",\"imagecomponent\":\"core\",\"altidentifier\":\"sleepy\",\"altcomponent\":\"core_pix\"},{\"text\":\"}-]\",\"imagename\":\"s\\/evil\",\"imagecomponent\":\"core\",\"altidentifier\":\"evil\",\"altcomponent\":\"core_pix\"},{\"text\":\"(h)\",\"imagename\":\"s\\/heart\",\"imagecomponent\":\"core\",\"altidentifier\":\"heart\",\"altcomponent\":\"core_pix\"},{\"text\":\"(heart)\",\"imagename\":\"s\\/heart\",\"imagecomponent\":\"core\",\"altidentifier\":\"heart\",\"altcomponent\":\"core_pix\"},{\"text\":\"(y)\",\"imagename\":\"s\\/yes\",\"imagecomponent\":\"core\",\"altidentifier\":\"yes\",\"altcomponent\":\"core\"},{\"text\":\"(n)\",\"imagename\":\"s\\/no\",\"imagecomponent\":\"core\",\"altidentifier\":\"no\",\"altcomponent\":\"core\"},{\"text\":\"(martin)\",\"imagename\":\"s\\/martin\",\"imagecomponent\":\"core\",\"altidentifier\":\"martin\",\"altcomponent\":\"core_pix\"},{\"text\":\"( )\",\"imagename\":\"s\\/egg\",\"imagecomponent\":\"core\",\"altidentifier\":\"egg\",\"altcomponent\":\"core_pix\"}]'),(283,'core_media_enable_youtube','1'),(284,'core_media_enable_vimeo','0'),(285,'core_media_enable_mp3','1'),(286,'core_media_enable_flv','1'),(287,'core_media_enable_swf','1'),(288,'core_media_enable_html5audio','1'),(289,'core_media_enable_html5video','1'),(290,'core_media_enable_qt','1'),(291,'core_media_enable_wmp','1'),(292,'core_media_enable_rm','1'),(293,'docroot','http://docs.moodle.org'),(294,'doclang',''),(295,'doctonewwindow','0'),(296,'courselistshortnames','0'),(297,'coursesperpage','20'),(298,'courseswithsummarieslimit','10'),(299,'courseoverviewfileslimit','1'),(300,'courseoverviewfilesext','.jpg,.gif,.png'),(301,'useexternalyui','0'),(302,'yuicomboloading','1'),(303,'cachejs','1'),(304,'modchooserdefault','1'),(305,'modeditingmenu','1'),(306,'blockeditingmenu','1'),(307,'additionalhtmlhead',''),(308,'additionalhtmltopofbody',''),(309,'additionalhtmlfooter',''),(310,'pathtodu',''),(311,'aspellpath',''),(312,'pathtodot',''),(313,'pathtogs','/usr/bin/gs'),(314,'supportname','Admin User'),(315,'supportemail',''),(316,'supportpage',''),(317,'dbsessions','0'),(318,'sessioncookie',''),(319,'sessioncookiepath',''),(320,'sessioncookiedomain',''),(321,'statsfirstrun','none'),(322,'statsmaxruntime','0'),(323,'statsruntimedays','31'),(324,'statsruntimestarthour','0'),(325,'statsruntimestartminute','0'),(326,'statsuserthreshold','0'),(327,'slasharguments','1'),(328,'getremoteaddrconf','0'),(329,'proxyhost',''),(330,'proxyport','0'),(331,'proxytype','HTTP'),(332,'proxyuser',''),(333,'proxypassword',''),(334,'proxybypass','localhost, 127.0.0.1'),(335,'maintenance_enabled','0'),(336,'maintenance_message',''),(337,'deleteunconfirmed','168'),(338,'deleteincompleteusers','0'),(339,'disablegradehistory','0'),(340,'gradehistorylifetime','0'),(341,'tempdatafoldercleanup','168'),(342,'extramemorylimit','512M'),(343,'maxtimelimit','0'),(344,'curlcache','120'),(345,'curltimeoutkbitrate','56'),(346,'updateautocheck','1'),(347,'updateminmaturity','200'),(348,'updatenotifybuilds','0'),(349,'enablesafebrowserintegration','0'),(350,'dndallowtextandlinks','0'),(351,'enablecssoptimiser','0'),(352,'debug','0'),(353,'debugdisplay','1'),(354,'debugsmtp','0'),(355,'perfdebug','7'),(356,'debugstringids','0'),(357,'debugvalidators','0'),(358,'debugpageinfo','0'),(359,'profilingenabled','0'),(360,'profilingincluded',''),(361,'profilingexcluded',''),(362,'profilingautofrec','0'),(363,'profilingallowme','0'),(364,'profilingallowall','0'),(365,'profilinglifetime','1440'),(366,'profilingimportprefix','(I)'),(367,'release','3.0.3+ (Build: 20160429)'),(368,'branch','30'),(369,'localcachedirpurged','1462734501'),(370,'scheduledtaskreset','1462734502'),(371,'allversionshash','379036a63800ae65493bf14f8ce36c0769de0795'),(373,'notloggedinroleid','6'),(374,'guestroleid','6'),(375,'defaultuserroleid','7'),(376,'creatornewroleid','3'),(377,'restorernewroleid','3'),(378,'gradebookroles','5'),(379,'chat_method','ajax'),(380,'chat_refresh_userlist','10'),(381,'chat_old_ping','35'),(382,'chat_refresh_room','5'),(383,'chat_normal_updatemode','jsupdate'),(384,'chat_serverhost','sprucelogin.com'),(385,'chat_serverip','127.0.0.1'),(386,'chat_serverport','9111'),(387,'chat_servermax','100'),(388,'data_enablerssfeeds','0'),(389,'feedback_allowfullanonymous','0'),(390,'forum_displaymode','3'),(391,'forum_replytouser','1'),(392,'forum_shortpost','300'),(393,'forum_longpost','600'),(394,'forum_manydiscussions','100'),(395,'forum_maxbytes','512000'),(396,'forum_maxattachments','9'),(397,'forum_trackingtype','1'),(398,'forum_trackreadposts','1'),(399,'forum_allowforcedreadtracking','0'),(400,'forum_oldpostdays','14'),(401,'forum_usermarksread','0'),(402,'forum_cleanreadtime','2'),(403,'digestmailtime','17'),(404,'forum_enablerssfeeds','0'),(405,'forum_enabletimedposts','0'),(406,'glossary_entbypage','10'),(407,'glossary_dupentries','0'),(408,'glossary_allowcomments','0'),(409,'glossary_linkbydefault','1'),(410,'glossary_defaultapproval','1'),(411,'glossary_enablerssfeeds','0'),(412,'glossary_linkentries','0'),(413,'glossary_casesensitive','0'),(414,'glossary_fullmatch','0'),(415,'lesson_slideshowwidth','640'),(416,'lesson_slideshowheight','480'),(417,'lesson_slideshowbgcolor','#FFFFFF'),(418,'lesson_mediawidth','640'),(419,'lesson_mediaheight','480'),(420,'lesson_mediaclose','0'),(421,'lesson_maxanswers','4'),(422,'lesson_defaultnextpage','0'),(423,'block_course_list_adminview','all'),(424,'block_course_list_hideallcourseslink','0'),(425,'block_html_allowcssclasses','0'),(426,'block_online_users_timetosee','5'),(427,'block_rss_client_num_entries','5'),(428,'block_rss_client_timeout','30'),(429,'filter_censor_badwords',''),(430,'filter_multilang_force_old','0'),(431,'logguests','1'),(432,'loglifetime','0'),(433,'airnotifierurl','https://messages.moodle.net'),(434,'airnotifierport','443'),(435,'airnotifiermobileappname','com.moodle.moodlemobile'),(436,'airnotifierappname','commoodlemoodlemobile'),(437,'airnotifieraccesskey',''),(438,'smtphosts',''),(439,'smtpsecure',''),(440,'smtpauthtype','LOGIN'),(441,'smtpuser',''),(442,'smtppass',''),(443,'smtpmaxbulk','1'),(444,'noreplyaddress','noreply@sprucelogin.com'),(445,'emailonlyfromnoreplyaddress','0'),(446,'sitemailcharset','0'),(447,'allowusermailcharset','0'),(448,'allowattachments','1'),(449,'mailnewline','LF'),(450,'jabberhost',''),(451,'jabberserver',''),(452,'jabberusername',''),(453,'jabberpassword',''),(454,'jabberport','5222'),(455,'enablemobilewebservice','0'),(456,'profileroles','5,4,3'),(457,'coursecontact','3'),(458,'frontpage','6'),(459,'frontpageloggedin','5,0'),(460,'maxcategorydepth','2'),(461,'frontpagecourselimit','200'),(462,'commentsperpage','15'),(463,'defaultfrontpageroleid','5'),(464,'messageinbound_enabled','0'),(465,'messageinbound_mailbox',''),(466,'messageinbound_domain',''),(467,'messageinbound_host',''),(468,'messageinbound_hostssl','ssl'),(469,'messageinbound_hostuser',''),(470,'messageinbound_hostpass',''),(471,'timezone','Africa/Abidjan'),(472,'registerauth','');
/*!40000 ALTER TABLE `mdl_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_config_log`
--

DROP TABLE IF EXISTS `mdl_config_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_config_log` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `plugin` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` longtext COLLATE utf8_unicode_ci,
  `oldvalue` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_conflog_tim_ix` (`timemodified`),
  KEY `mdl_conflog_use_ix` (`userid`)
) ENGINE=InnoDB AUTO_INCREMENT=935 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Changes done in server configuration through admin UI';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_config_log`
--

LOCK TABLES `mdl_config_log` WRITE;
/*!40000 ALTER TABLE `mdl_config_log` DISABLE KEYS */;
INSERT INTO `mdl_config_log` VALUES (1,0,1462257486,NULL,'enableoutcomes','0',NULL),(2,0,1462257486,NULL,'usecomments','1',NULL),(3,0,1462257486,NULL,'usetags','1',NULL),(4,0,1462257486,NULL,'enablenotes','1',NULL),(5,0,1462257486,NULL,'enableportfolios','0',NULL),(6,0,1462257486,NULL,'enablewebservices','0',NULL),(7,0,1462257486,NULL,'messaging','1',NULL),(8,0,1462257486,NULL,'messaginghidereadnotifications','0',NULL),(9,0,1462257486,NULL,'messagingdeletereadnotificationsdelay','604800',NULL),(10,0,1462257486,NULL,'messagingallowemailoverride','0',NULL),(11,0,1462257486,NULL,'enablestats','0',NULL),(12,0,1462257486,NULL,'enablerssfeeds','0',NULL),(13,0,1462257486,NULL,'enableblogs','1',NULL),(14,0,1462257486,NULL,'enablecompletion','0',NULL),(15,0,1462257486,NULL,'completiondefault','1',NULL),(16,0,1462257486,NULL,'enableavailability','0',NULL),(17,0,1462257487,NULL,'enableplagiarism','0',NULL),(18,0,1462257487,NULL,'enablebadges','1',NULL),(19,0,1462257487,NULL,'defaultpreference_maildisplay','2',NULL),(20,0,1462257487,NULL,'defaultpreference_mailformat','1',NULL),(21,0,1462257487,NULL,'defaultpreference_maildigest','0',NULL),(22,0,1462257487,NULL,'defaultpreference_autosubscribe','1',NULL),(23,0,1462257487,NULL,'defaultpreference_trackforums','0',NULL),(24,0,1462257487,NULL,'autologinguests','0',NULL),(25,0,1462257487,NULL,'hiddenuserfields','',NULL),(26,0,1462257487,NULL,'showuseridentity','email',NULL),(27,0,1462257487,NULL,'fullnamedisplay','language',NULL),(28,0,1462257487,NULL,'alternativefullnameformat','language',NULL),(29,0,1462257487,NULL,'maxusersperpage','100',NULL),(30,0,1462257487,NULL,'enablegravatar','0',NULL),(31,0,1462257487,NULL,'gravatardefaulturl','mm',NULL),(32,0,1462257487,'moodlecourse','visible','1',NULL),(33,0,1462257487,'moodlecourse','format','weeks',NULL),(34,0,1462257487,'moodlecourse','maxsections','52',NULL),(35,0,1462257487,'moodlecourse','numsections','10',NULL),(36,0,1462257487,'moodlecourse','hiddensections','0',NULL),(37,0,1462257487,'moodlecourse','coursedisplay','0',NULL),(38,0,1462257487,'moodlecourse','lang','',NULL),(39,0,1462257487,'moodlecourse','newsitems','5',NULL),(40,0,1462257487,'moodlecourse','showgrades','1',NULL),(41,0,1462257487,'moodlecourse','showreports','0',NULL),(42,0,1462257487,'moodlecourse','maxbytes','0',NULL),(43,0,1462257487,'moodlecourse','enablecompletion','0',NULL),(44,0,1462257487,'moodlecourse','groupmode','0',NULL),(45,0,1462257487,'moodlecourse','groupmodeforce','0',NULL),(46,0,1462257487,NULL,'enablecourserequests','0',NULL),(47,0,1462257487,NULL,'defaultrequestcategory','1',NULL),(48,0,1462257487,NULL,'requestcategoryselection','0',NULL),(49,0,1462257487,NULL,'courserequestnotify','',NULL),(50,0,1462257487,'backup','loglifetime','30',NULL),(51,0,1462257487,'backup','backup_general_users','1',NULL),(52,0,1462257487,'backup','backup_general_users_locked','',NULL),(53,0,1462257487,'backup','backup_general_anonymize','0',NULL),(54,0,1462257487,'backup','backup_general_anonymize_locked','',NULL),(55,0,1462257487,'backup','backup_general_role_assignments','1',NULL),(56,0,1462257487,'backup','backup_general_role_assignments_locked','',NULL),(57,0,1462257487,'backup','backup_general_activities','1',NULL),(58,0,1462257487,'backup','backup_general_activities_locked','',NULL),(59,0,1462257487,'backup','backup_general_blocks','1',NULL),(60,0,1462257487,'backup','backup_general_blocks_locked','',NULL),(61,0,1462257487,'backup','backup_general_filters','1',NULL),(62,0,1462257487,'backup','backup_general_filters_locked','',NULL),(63,0,1462257487,'backup','backup_general_comments','1',NULL),(64,0,1462257487,'backup','backup_general_comments_locked','',NULL),(65,0,1462257487,'backup','backup_general_badges','1',NULL),(66,0,1462257487,'backup','backup_general_badges_locked','',NULL),(67,0,1462257487,'backup','backup_general_userscompletion','1',NULL),(68,0,1462257487,'backup','backup_general_userscompletion_locked','',NULL),(69,0,1462257487,'backup','backup_general_logs','0',NULL),(70,0,1462257487,'backup','backup_general_logs_locked','',NULL),(71,0,1462257487,'backup','backup_general_histories','0',NULL),(72,0,1462257487,'backup','backup_general_histories_locked','',NULL),(73,0,1462257487,'backup','backup_general_questionbank','1',NULL),(74,0,1462257487,'backup','backup_general_questionbank_locked','',NULL),(75,0,1462257487,'backup','backup_general_groups','1',NULL),(76,0,1462257487,'backup','backup_general_groups_locked','',NULL),(77,0,1462257487,'backup','import_general_maxresults','10',NULL),(78,0,1462257487,'backup','import_general_duplicate_admin_allowed','0',NULL),(79,0,1462257487,'backup','backup_auto_active','0',NULL),(80,0,1462257487,'backup','backup_auto_weekdays','0000000',NULL),(81,0,1462257487,'backup','backup_auto_hour','0',NULL),(82,0,1462257487,'backup','backup_auto_minute','0',NULL),(83,0,1462257487,'backup','backup_auto_storage','0',NULL),(84,0,1462257487,'backup','backup_auto_destination','',NULL),(85,0,1462257487,'backup','backup_auto_max_kept','1',NULL),(86,0,1462257487,'backup','backup_auto_delete_days','0',NULL),(87,0,1462257487,'backup','backup_auto_min_kept','0',NULL),(88,0,1462257487,'backup','backup_shortname','0',NULL),(89,0,1462257487,'backup','backup_auto_skip_hidden','1',NULL),(90,0,1462257487,'backup','backup_auto_skip_modif_days','30',NULL),(91,0,1462257487,'backup','backup_auto_skip_modif_prev','0',NULL),(92,0,1462257487,'backup','backup_auto_users','1',NULL),(93,0,1462257487,'backup','backup_auto_role_assignments','1',NULL),(94,0,1462257487,'backup','backup_auto_activities','1',NULL),(95,0,1462257487,'backup','backup_auto_blocks','1',NULL),(96,0,1462257487,'backup','backup_auto_filters','1',NULL),(97,0,1462257487,'backup','backup_auto_comments','1',NULL),(98,0,1462257487,'backup','backup_auto_badges','1',NULL),(99,0,1462257487,'backup','backup_auto_userscompletion','1',NULL),(100,0,1462257487,'backup','backup_auto_logs','0',NULL),(101,0,1462257487,'backup','backup_auto_histories','0',NULL),(102,0,1462257487,'backup','backup_auto_questionbank','1',NULL),(103,0,1462257487,'backup','backup_auto_groups','1',NULL),(104,0,1462257487,NULL,'grade_profilereport','user',NULL),(105,0,1462257487,NULL,'grade_aggregationposition','1',NULL),(106,0,1462257487,NULL,'grade_includescalesinaggregation','1',NULL),(107,0,1462257487,NULL,'grade_hiddenasdate','0',NULL),(108,0,1462257487,NULL,'gradepublishing','0',NULL),(109,0,1462257487,NULL,'grade_export_displaytype','1',NULL),(110,0,1462257487,NULL,'grade_export_decimalpoints','2',NULL),(111,0,1462257487,NULL,'grade_navmethod','0',NULL),(112,0,1462257487,NULL,'grade_export_userprofilefields','firstname,lastname,idnumber,institution,department,email',NULL),(113,0,1462257487,NULL,'grade_export_customprofilefields','',NULL),(114,0,1462257487,NULL,'recovergradesdefault','0',NULL),(115,0,1462257487,NULL,'gradeexport','',NULL),(116,0,1462257487,NULL,'unlimitedgrades','0',NULL),(117,0,1462257487,NULL,'grade_report_showmin','1',NULL),(118,0,1462257487,NULL,'gradepointmax','100',NULL),(119,0,1462257487,NULL,'gradepointdefault','100',NULL),(120,0,1462257487,NULL,'grade_minmaxtouse','1',NULL),(121,0,1462257487,NULL,'grade_mygrades_report','overview',NULL),(122,0,1462257487,NULL,'gradereport_mygradeurl','',NULL),(123,0,1462257487,NULL,'grade_hideforcedsettings','1',NULL),(124,0,1462257487,NULL,'grade_aggregation','13',NULL),(125,0,1462257487,NULL,'grade_aggregation_flag','0',NULL),(126,0,1462257487,NULL,'grade_aggregations_visible','13',NULL),(127,0,1462257487,NULL,'grade_aggregateonlygraded','1',NULL),(128,0,1462257487,NULL,'grade_aggregateonlygraded_flag','2',NULL),(129,0,1462257487,NULL,'grade_aggregateoutcomes','0',NULL),(130,0,1462257487,NULL,'grade_aggregateoutcomes_flag','2',NULL),(131,0,1462257487,NULL,'grade_keephigh','0',NULL),(132,0,1462257487,NULL,'grade_keephigh_flag','3',NULL),(133,0,1462257487,NULL,'grade_droplow','0',NULL),(134,0,1462257487,NULL,'grade_droplow_flag','2',NULL),(135,0,1462257487,NULL,'grade_overridecat','1',NULL),(136,0,1462257487,NULL,'grade_displaytype','1',NULL),(137,0,1462257487,NULL,'grade_decimalpoints','2',NULL),(138,0,1462257487,NULL,'grade_item_advanced','iteminfo,idnumber,gradepass,plusfactor,multfactor,display,decimals,hiddenuntil,locktime',NULL),(139,0,1462257487,NULL,'grade_report_studentsperpage','100',NULL),(140,0,1462257487,NULL,'grade_report_showonlyactiveenrol','1',NULL),(141,0,1462257487,NULL,'grade_report_quickgrading','1',NULL),(142,0,1462257487,NULL,'grade_report_showquickfeedback','0',NULL),(143,0,1462257487,NULL,'grade_report_meanselection','1',NULL),(144,0,1462257487,NULL,'grade_report_enableajax','0',NULL),(145,0,1462257487,NULL,'grade_report_showcalculations','1',NULL),(146,0,1462257487,NULL,'grade_report_showeyecons','0',NULL),(147,0,1462257487,NULL,'grade_report_showaverages','1',NULL),(148,0,1462257487,NULL,'grade_report_showlocks','0',NULL),(149,0,1462257487,NULL,'grade_report_showranges','0',NULL),(150,0,1462257487,NULL,'grade_report_showanalysisicon','1',NULL),(151,0,1462257487,NULL,'grade_report_showuserimage','1',NULL),(152,0,1462257487,NULL,'grade_report_showactivityicons','1',NULL),(153,0,1462257487,NULL,'grade_report_shownumberofgrades','0',NULL),(154,0,1462257487,NULL,'grade_report_averagesdisplaytype','inherit',NULL),(155,0,1462257487,NULL,'grade_report_rangesdisplaytype','inherit',NULL),(156,0,1462257487,NULL,'grade_report_averagesdecimalpoints','inherit',NULL),(157,0,1462257487,NULL,'grade_report_rangesdecimalpoints','inherit',NULL),(158,0,1462257487,NULL,'grade_report_historyperpage','50',NULL),(159,0,1462257487,NULL,'grade_report_overview_showrank','0',NULL),(160,0,1462257487,NULL,'grade_report_overview_showtotalsifcontainhidden','0',NULL),(161,0,1462257487,NULL,'grade_report_user_showrank','0',NULL),(162,0,1462257487,NULL,'grade_report_user_showpercentage','1',NULL),(163,0,1462257487,NULL,'grade_report_user_showgrade','1',NULL),(164,0,1462257487,NULL,'grade_report_user_showfeedback','1',NULL),(165,0,1462257487,NULL,'grade_report_user_showrange','1',NULL),(166,0,1462257488,NULL,'grade_report_user_showweight','1',NULL),(167,0,1462257488,NULL,'grade_report_user_showaverage','0',NULL),(168,0,1462257488,NULL,'grade_report_user_showlettergrade','0',NULL),(169,0,1462257488,NULL,'grade_report_user_rangedecimals','0',NULL),(170,0,1462257488,NULL,'grade_report_user_showhiddenitems','1',NULL),(171,0,1462257488,NULL,'grade_report_user_showtotalsifcontainhidden','0',NULL),(172,0,1462257488,NULL,'grade_report_user_showcontributiontocoursetotal','1',NULL),(173,0,1462257488,NULL,'badges_defaultissuername','',NULL),(174,0,1462257488,NULL,'badges_defaultissuercontact','',NULL),(175,0,1462257488,NULL,'badges_badgesalt','badges1462257482',NULL),(176,0,1462257488,NULL,'badges_allowexternalbackpack','1',NULL),(177,0,1462257488,NULL,'badges_allowcoursebadges','1',NULL),(178,0,1462257489,NULL,'forcetimezone','99',NULL),(179,0,1462257489,NULL,'country','0',NULL),(180,0,1462257489,NULL,'defaultcity','',NULL),(181,0,1462257489,NULL,'geoipfile','/home/sprucelogin/moodledata/geoip/GeoLiteCity.dat',NULL),(182,0,1462257489,NULL,'googlemapkey3','',NULL),(183,0,1462257489,NULL,'allcountrycodes','',NULL),(184,0,1462257489,NULL,'autolang','1',NULL),(185,0,1462257489,NULL,'lang','en',NULL),(186,0,1462257489,NULL,'langmenu','1',NULL),(187,0,1462257489,NULL,'langlist','',NULL),(188,0,1462257489,NULL,'langcache','1',NULL),(189,0,1462257489,NULL,'langstringcache','1',NULL),(190,0,1462257489,NULL,'locale','',NULL),(191,0,1462257489,NULL,'latinexcelexport','0',NULL),(192,0,1462257489,NULL,'requiremodintro','0',NULL),(193,0,1462257489,NULL,'registerauth','',NULL),(194,0,1462257489,NULL,'authloginviaemail','0',NULL),(195,0,1462257489,NULL,'allowaccountssameemail','0',NULL),(196,0,1462257489,NULL,'authpreventaccountcreation','0',NULL),(197,0,1462257489,NULL,'loginpageautofocus','0',NULL),(198,0,1462257489,NULL,'guestloginbutton','1',NULL),(199,0,1462257489,NULL,'limitconcurrentlogins','0',NULL),(200,0,1462257489,NULL,'alternateloginurl','',NULL),(201,0,1462257489,NULL,'forgottenpasswordurl','',NULL),(202,0,1462257489,NULL,'auth_instructions','',NULL),(203,0,1462257489,NULL,'allowemailaddresses','',NULL),(204,0,1462257489,NULL,'denyemailaddresses','',NULL),(205,0,1462257489,NULL,'verifychangedemail','1',NULL),(206,0,1462257489,NULL,'recaptchapublickey','',NULL),(207,0,1462257489,NULL,'recaptchaprivatekey','',NULL),(208,0,1462257489,'cachestore_memcache','testservers','',NULL),(209,0,1462257489,'cachestore_memcached','testservers','',NULL),(210,0,1462257489,'cachestore_mongodb','testserver','',NULL),(211,0,1462257489,NULL,'filteruploadedfiles','0',NULL),(212,0,1462257489,NULL,'filtermatchoneperpage','0',NULL),(213,0,1462257489,NULL,'filtermatchonepertext','0',NULL),(214,0,1462257489,NULL,'sitedefaultlicense','allrightsreserved',NULL),(215,0,1462257489,NULL,'portfolio_moderate_filesize_threshold','1048576',NULL),(216,0,1462257489,NULL,'portfolio_high_filesize_threshold','5242880',NULL),(217,0,1462257489,NULL,'portfolio_moderate_db_threshold','20',NULL),(218,0,1462257489,NULL,'portfolio_high_db_threshold','50',NULL),(219,0,1462257489,'question_preview','behaviour','deferredfeedback',NULL),(220,0,1462257489,'question_preview','correctness','1',NULL),(221,0,1462257489,'question_preview','marks','2',NULL),(222,0,1462257489,'question_preview','markdp','2',NULL),(223,0,1462257489,'question_preview','feedback','1',NULL),(224,0,1462257489,'question_preview','generalfeedback','1',NULL),(225,0,1462257489,'question_preview','rightanswer','1',NULL),(226,0,1462257489,'question_preview','history','0',NULL),(227,0,1462257489,NULL,'repositorycacheexpire','120',NULL),(228,0,1462257489,NULL,'repositorygetfiletimeout','30',NULL),(229,0,1462257489,NULL,'repositorysyncfiletimeout','1',NULL),(230,0,1462257489,NULL,'repositorysyncimagetimeout','3',NULL),(231,0,1462257489,NULL,'repositoryallowexternallinks','1',NULL),(232,0,1462257489,NULL,'legacyfilesinnewcourses','0',NULL),(233,0,1462257489,NULL,'legacyfilesaddallowed','1',NULL),(234,0,1462257489,NULL,'mobilecssurl','',NULL),(235,0,1462257489,NULL,'enablewsdocumentation','0',NULL),(236,0,1462257489,NULL,'allowbeforeblock','0',NULL),(237,0,1462257489,NULL,'allowedip','',NULL),(238,0,1462257489,NULL,'blockedip','',NULL),(239,0,1462257489,NULL,'protectusernames','1',NULL),(240,0,1462257489,NULL,'forcelogin','0',NULL),(241,0,1462257489,NULL,'forceloginforprofiles','1',NULL),(242,0,1462257489,NULL,'forceloginforprofileimage','0',NULL),(243,0,1462257489,NULL,'opentogoogle','0',NULL),(244,0,1462257489,NULL,'maxbytes','0',NULL),(245,0,1462257489,NULL,'userquota','104857600',NULL),(246,0,1462257489,NULL,'allowobjectembed','0',NULL),(247,0,1462257489,NULL,'enabletrusttext','0',NULL),(248,0,1462257489,NULL,'maxeditingtime','1800',NULL),(249,0,1462257489,NULL,'extendedusernamechars','0',NULL),(250,0,1462257489,NULL,'sitepolicy','',NULL),(251,0,1462257489,NULL,'sitepolicyguest','',NULL),(252,0,1462257489,NULL,'keeptagnamecase','1',NULL),(253,0,1462257489,NULL,'profilesforenrolledusersonly','1',NULL),(254,0,1462257489,NULL,'cronclionly','1',NULL),(255,0,1462257489,NULL,'cronremotepassword','',NULL),(256,0,1462257489,NULL,'lockoutthreshold','0',NULL),(257,0,1462257489,NULL,'lockoutwindow','1800',NULL),(258,0,1462257489,NULL,'lockoutduration','1800',NULL),(259,0,1462257489,NULL,'passwordpolicy','1',NULL),(260,0,1462257489,NULL,'minpasswordlength','8',NULL),(261,0,1462257489,NULL,'minpassworddigits','1',NULL),(262,0,1462257489,NULL,'minpasswordlower','1',NULL),(263,0,1462257489,NULL,'minpasswordupper','1',NULL),(264,0,1462257489,NULL,'minpasswordnonalphanum','1',NULL),(265,0,1462257489,NULL,'maxconsecutiveidentchars','0',NULL),(266,0,1462257489,NULL,'passwordreuselimit','0',NULL),(267,0,1462257489,NULL,'pwresettime','1800',NULL),(268,0,1462257489,NULL,'passwordchangelogout','0',NULL),(269,0,1462257489,NULL,'groupenrolmentkeypolicy','1',NULL),(270,0,1462257489,NULL,'disableuserimages','0',NULL),(271,0,1462257489,NULL,'emailchangeconfirmation','1',NULL),(272,0,1462257489,NULL,'rememberusername','2',NULL),(273,0,1462257489,NULL,'strictformsrequired','0',NULL),(274,0,1462257489,NULL,'loginhttps','0',NULL),(275,0,1462257489,NULL,'cookiesecure','0',NULL),(276,0,1462257489,NULL,'cookiehttponly','0',NULL),(277,0,1462257490,NULL,'allowframembedding','0',NULL),(278,0,1462257490,NULL,'loginpasswordautocomplete','0',NULL),(279,0,1462257490,NULL,'displayloginfailures','0',NULL),(280,0,1462257490,NULL,'notifyloginfailures','',NULL),(281,0,1462257490,NULL,'notifyloginthreshold','10',NULL),(282,0,1462257490,NULL,'runclamonupload','0',NULL),(283,0,1462257490,NULL,'pathtoclam','',NULL),(284,0,1462257490,NULL,'quarantinedir','',NULL),(285,0,1462257490,NULL,'clamfailureonupload','donothing',NULL),(286,0,1462257490,NULL,'themelist','',NULL),(287,0,1462257490,NULL,'themedesignermode','0',NULL),(288,0,1462257490,NULL,'allowuserthemes','0',NULL),(289,0,1462257490,NULL,'allowcoursethemes','0',NULL),(290,0,1462257490,NULL,'allowcategorythemes','0',NULL),(291,0,1462257490,NULL,'allowthemechangeonurl','0',NULL),(292,0,1462257490,NULL,'allowuserblockhiding','1',NULL),(293,0,1462257490,NULL,'allowblockstodock','1',NULL),(294,0,1462257490,NULL,'custommenuitems','',NULL),(295,0,1462257490,NULL,'customusermenuitems','grades,grades|/grade/report/mygrades.php|grades\nmessages,message|/message/index.php|message\npreferences,moodle|/user/preferences.php|preferences',NULL),(296,0,1462257490,NULL,'enabledevicedetection','1',NULL),(297,0,1462257490,NULL,'devicedetectregex','[]',NULL),(298,0,1462257490,'theme_clean','invert','0',NULL),(299,0,1462257490,'theme_clean','logo','',NULL),(300,0,1462257490,'theme_clean','customcss','',NULL),(301,0,1462257490,'theme_clean','footnote','',NULL),(302,0,1462257490,'theme_more','textcolor','#333366',NULL),(303,0,1462257490,'theme_more','linkcolor','#FF6500',NULL),(304,0,1462257490,'theme_more','bodybackground','',NULL),(305,0,1462257490,'theme_more','backgroundimage','',NULL),(306,0,1462257490,'theme_more','backgroundrepeat','repeat',NULL),(307,0,1462257490,'theme_more','backgroundposition','0',NULL),(308,0,1462257490,'theme_more','backgroundfixed','0',NULL),(309,0,1462257490,'theme_more','contentbackground','#FFFFFF',NULL),(310,0,1462257490,'theme_more','secondarybackground','#FFFFFF',NULL),(311,0,1462257490,'theme_more','invert','1',NULL),(312,0,1462257490,'theme_more','logo','',NULL),(313,0,1462257490,'theme_more','customcss','',NULL),(314,0,1462257490,'theme_more','footnote','',NULL),(315,0,1462257490,NULL,'calendartype','gregorian',NULL),(316,0,1462257490,NULL,'calendar_adminseesall','0',NULL),(317,0,1462257490,NULL,'calendar_site_timeformat','0',NULL),(318,0,1462257490,NULL,'calendar_startwday','1',NULL),(319,0,1462257490,NULL,'calendar_weekend','65',NULL),(320,0,1462257490,NULL,'calendar_lookahead','21',NULL),(321,0,1462257490,NULL,'calendar_maxevents','10',NULL),(322,0,1462257490,NULL,'enablecalendarexport','1',NULL),(323,0,1462257490,NULL,'calendar_customexport','1',NULL),(324,0,1462257490,NULL,'calendar_exportlookahead','365',NULL),(325,0,1462257490,NULL,'calendar_exportlookback','5',NULL),(326,0,1462257490,NULL,'calendar_exportsalt','5rMPBxsAVtL9h9FUvwqbMhDLHBzCTUXcrV11bidZ7hKw2REImI77aaw6tH2r',NULL),(327,0,1462257490,NULL,'calendar_showicalsource','1',NULL),(328,0,1462257490,NULL,'useblogassociations','1',NULL),(329,0,1462257490,NULL,'bloglevel','4',NULL),(330,0,1462257490,NULL,'useexternalblogs','1',NULL),(331,0,1462257490,NULL,'externalblogcrontime','86400',NULL),(332,0,1462257490,NULL,'maxexternalblogsperuser','1',NULL),(333,0,1462257490,NULL,'blogusecomments','1',NULL),(334,0,1462257490,NULL,'blogshowcommentscount','1',NULL),(335,0,1462257490,NULL,'defaulthomepage','1',NULL),(336,0,1462257490,NULL,'allowguestmymoodle','1',NULL),(337,0,1462257490,NULL,'navshowfullcoursenames','0',NULL),(338,0,1462257490,NULL,'navshowcategories','1',NULL),(339,0,1462257490,NULL,'navshowmycoursecategories','0',NULL),(340,0,1462257490,NULL,'navshowallcourses','0',NULL),(341,0,1462257490,NULL,'navexpandmycourses','1',NULL),(342,0,1462257490,NULL,'navsortmycoursessort','sortorder',NULL),(343,0,1462257490,NULL,'navcourselimit','20',NULL),(344,0,1462257490,NULL,'usesitenameforsitepages','0',NULL),(345,0,1462257490,NULL,'linkadmincategories','0',NULL),(346,0,1462257490,NULL,'linkcoursesections','0',NULL),(347,0,1462257490,NULL,'navshowfrontpagemods','1',NULL),(348,0,1462257490,NULL,'navadduserpostslinks','1',NULL),(349,0,1462257490,NULL,'formatstringstriptags','1',NULL),(350,0,1462257490,NULL,'emoticons','[{\"text\":\":-)\",\"imagename\":\"s\\/smiley\",\"imagecomponent\":\"core\",\"altidentifier\":\"smiley\",\"altcomponent\":\"core_pix\"},{\"text\":\":)\",\"imagename\":\"s\\/smiley\",\"imagecomponent\":\"core\",\"altidentifier\":\"smiley\",\"altcomponent\":\"core_pix\"},{\"text\":\":-D\",\"imagename\":\"s\\/biggrin\",\"imagecomponent\":\"core\",\"altidentifier\":\"biggrin\",\"altcomponent\":\"core_pix\"},{\"text\":\";-)\",\"imagename\":\"s\\/wink\",\"imagecomponent\":\"core\",\"altidentifier\":\"wink\",\"altcomponent\":\"core_pix\"},{\"text\":\":-\\/\",\"imagename\":\"s\\/mixed\",\"imagecomponent\":\"core\",\"altidentifier\":\"mixed\",\"altcomponent\":\"core_pix\"},{\"text\":\"V-.\",\"imagename\":\"s\\/thoughtful\",\"imagecomponent\":\"core\",\"altidentifier\":\"thoughtful\",\"altcomponent\":\"core_pix\"},{\"text\":\":-P\",\"imagename\":\"s\\/tongueout\",\"imagecomponent\":\"core\",\"altidentifier\":\"tongueout\",\"altcomponent\":\"core_pix\"},{\"text\":\":-p\",\"imagename\":\"s\\/tongueout\",\"imagecomponent\":\"core\",\"altidentifier\":\"tongueout\",\"altcomponent\":\"core_pix\"},{\"text\":\"B-)\",\"imagename\":\"s\\/cool\",\"imagecomponent\":\"core\",\"altidentifier\":\"cool\",\"altcomponent\":\"core_pix\"},{\"text\":\"^-)\",\"imagename\":\"s\\/approve\",\"imagecomponent\":\"core\",\"altidentifier\":\"approve\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-)\",\"imagename\":\"s\\/wideeyes\",\"imagecomponent\":\"core\",\"altidentifier\":\"wideeyes\",\"altcomponent\":\"core_pix\"},{\"text\":\":o)\",\"imagename\":\"s\\/clown\",\"imagecomponent\":\"core\",\"altidentifier\":\"clown\",\"altcomponent\":\"core_pix\"},{\"text\":\":-(\",\"imagename\":\"s\\/sad\",\"imagecomponent\":\"core\",\"altidentifier\":\"sad\",\"altcomponent\":\"core_pix\"},{\"text\":\":(\",\"imagename\":\"s\\/sad\",\"imagecomponent\":\"core\",\"altidentifier\":\"sad\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-.\",\"imagename\":\"s\\/shy\",\"imagecomponent\":\"core\",\"altidentifier\":\"shy\",\"altcomponent\":\"core_pix\"},{\"text\":\":-I\",\"imagename\":\"s\\/blush\",\"imagecomponent\":\"core\",\"altidentifier\":\"blush\",\"altcomponent\":\"core_pix\"},{\"text\":\":-X\",\"imagename\":\"s\\/kiss\",\"imagecomponent\":\"core\",\"altidentifier\":\"kiss\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-o\",\"imagename\":\"s\\/surprise\",\"imagecomponent\":\"core\",\"altidentifier\":\"surprise\",\"altcomponent\":\"core_pix\"},{\"text\":\"P-|\",\"imagename\":\"s\\/blackeye\",\"imagecomponent\":\"core\",\"altidentifier\":\"blackeye\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-[\",\"imagename\":\"s\\/angry\",\"imagecomponent\":\"core\",\"altidentifier\":\"angry\",\"altcomponent\":\"core_pix\"},{\"text\":\"(grr)\",\"imagename\":\"s\\/angry\",\"imagecomponent\":\"core\",\"altidentifier\":\"angry\",\"altcomponent\":\"core_pix\"},{\"text\":\"xx-P\",\"imagename\":\"s\\/dead\",\"imagecomponent\":\"core\",\"altidentifier\":\"dead\",\"altcomponent\":\"core_pix\"},{\"text\":\"|-.\",\"imagename\":\"s\\/sleepy\",\"imagecomponent\":\"core\",\"altidentifier\":\"sleepy\",\"altcomponent\":\"core_pix\"},{\"text\":\"}-]\",\"imagename\":\"s\\/evil\",\"imagecomponent\":\"core\",\"altidentifier\":\"evil\",\"altcomponent\":\"core_pix\"},{\"text\":\"(h)\",\"imagename\":\"s\\/heart\",\"imagecomponent\":\"core\",\"altidentifier\":\"heart\",\"altcomponent\":\"core_pix\"},{\"text\":\"(heart)\",\"imagename\":\"s\\/heart\",\"imagecomponent\":\"core\",\"altidentifier\":\"heart\",\"altcomponent\":\"core_pix\"},{\"text\":\"(y)\",\"imagename\":\"s\\/yes\",\"imagecomponent\":\"core\",\"altidentifier\":\"yes\",\"altcomponent\":\"core\"},{\"text\":\"(n)\",\"imagename\":\"s\\/no\",\"imagecomponent\":\"core\",\"altidentifier\":\"no\",\"altcomponent\":\"core\"},{\"text\":\"(martin)\",\"imagename\":\"s\\/martin\",\"imagecomponent\":\"core\",\"altidentifier\":\"martin\",\"altcomponent\":\"core_pix\"},{\"text\":\"( )\",\"imagename\":\"s\\/egg\",\"imagecomponent\":\"core\",\"altidentifier\":\"egg\",\"altcomponent\":\"core_pix\"}]',NULL),(351,0,1462257490,NULL,'core_media_enable_youtube','1',NULL),(352,0,1462257490,NULL,'core_media_enable_vimeo','0',NULL),(353,0,1462257490,NULL,'core_media_enable_mp3','1',NULL),(354,0,1462257490,NULL,'core_media_enable_flv','1',NULL),(355,0,1462257490,NULL,'core_media_enable_swf','1',NULL),(356,0,1462257490,NULL,'core_media_enable_html5audio','1',NULL),(357,0,1462257490,NULL,'core_media_enable_html5video','1',NULL),(358,0,1462257490,NULL,'core_media_enable_qt','1',NULL),(359,0,1462257490,NULL,'core_media_enable_wmp','1',NULL),(360,0,1462257490,NULL,'core_media_enable_rm','1',NULL),(361,0,1462257490,NULL,'docroot','http://docs.moodle.org',NULL),(362,0,1462257490,NULL,'doclang','',NULL),(363,0,1462257490,NULL,'doctonewwindow','0',NULL),(364,0,1462257490,NULL,'courselistshortnames','0',NULL),(365,0,1462257490,NULL,'coursesperpage','20',NULL),(366,0,1462257490,NULL,'courseswithsummarieslimit','10',NULL),(367,0,1462257490,NULL,'courseoverviewfileslimit','1',NULL),(368,0,1462257490,NULL,'courseoverviewfilesext','.jpg,.gif,.png',NULL),(369,0,1462257490,NULL,'useexternalyui','0',NULL),(370,0,1462257490,NULL,'yuicomboloading','1',NULL),(371,0,1462257490,NULL,'cachejs','1',NULL),(372,0,1462257490,NULL,'modchooserdefault','1',NULL),(373,0,1462257490,NULL,'modeditingmenu','1',NULL),(374,0,1462257490,NULL,'blockeditingmenu','1',NULL),(375,0,1462257490,NULL,'additionalhtmlhead','',NULL),(376,0,1462257490,NULL,'additionalhtmltopofbody','',NULL),(377,0,1462257490,NULL,'additionalhtmlfooter','',NULL),(378,0,1462257490,NULL,'pathtodu','',NULL),(379,0,1462257490,NULL,'aspellpath','',NULL),(380,0,1462257490,NULL,'pathtodot','',NULL),(381,0,1462257490,NULL,'pathtogs','/usr/bin/gs',NULL),(382,0,1462257490,NULL,'supportname','Admin User',NULL),(383,0,1462257490,NULL,'supportemail','',NULL),(384,0,1462257490,NULL,'supportpage','',NULL),(385,0,1462257490,NULL,'dbsessions','0',NULL),(386,0,1462257490,NULL,'sessioncookie','',NULL),(387,0,1462257490,NULL,'sessioncookiepath','',NULL),(388,0,1462257490,NULL,'sessioncookiedomain','',NULL),(389,0,1462257490,NULL,'statsfirstrun','none',NULL),(390,0,1462257491,NULL,'statsmaxruntime','0',NULL),(391,0,1462257491,NULL,'statsruntimedays','31',NULL),(392,0,1462257491,NULL,'statsruntimestarthour','0',NULL),(393,0,1462257491,NULL,'statsruntimestartminute','0',NULL),(394,0,1462257491,NULL,'statsuserthreshold','0',NULL),(395,0,1462257491,NULL,'slasharguments','1',NULL),(396,0,1462257491,NULL,'getremoteaddrconf','0',NULL),(397,0,1462257491,NULL,'proxyhost','',NULL),(398,0,1462257491,NULL,'proxyport','0',NULL),(399,0,1462257491,NULL,'proxytype','HTTP',NULL),(400,0,1462257491,NULL,'proxyuser','',NULL),(401,0,1462257491,NULL,'proxypassword','',NULL),(402,0,1462257491,NULL,'proxybypass','localhost, 127.0.0.1',NULL),(403,0,1462257491,NULL,'maintenance_enabled','0',NULL),(404,0,1462257491,NULL,'maintenance_message','',NULL),(405,0,1462257491,NULL,'deleteunconfirmed','168',NULL),(406,0,1462257491,NULL,'deleteincompleteusers','0',NULL),(407,0,1462257491,NULL,'disablegradehistory','0',NULL),(408,0,1462257491,NULL,'gradehistorylifetime','0',NULL),(409,0,1462257491,NULL,'tempdatafoldercleanup','168',NULL),(410,0,1462257491,NULL,'extramemorylimit','512M',NULL),(411,0,1462257491,NULL,'maxtimelimit','0',NULL),(412,0,1462257491,NULL,'curlcache','120',NULL),(413,0,1462257491,NULL,'curltimeoutkbitrate','56',NULL),(414,0,1462257491,NULL,'updateautocheck','1',NULL),(415,0,1462257491,NULL,'updateminmaturity','200',NULL),(416,0,1462257491,NULL,'updatenotifybuilds','0',NULL),(417,0,1462257491,NULL,'enablesafebrowserintegration','0',NULL),(418,0,1462257491,NULL,'dndallowtextandlinks','0',NULL),(419,0,1462257491,NULL,'enablecssoptimiser','0',NULL),(420,0,1462257491,NULL,'debug','0',NULL),(421,0,1462257491,NULL,'debugdisplay','1',NULL),(422,0,1462257491,NULL,'debugsmtp','0',NULL),(423,0,1462257491,NULL,'perfdebug','7',NULL),(424,0,1462257491,NULL,'debugstringids','0',NULL),(425,0,1462257491,NULL,'debugvalidators','0',NULL),(426,0,1462257491,NULL,'debugpageinfo','0',NULL),(427,0,1462257491,NULL,'profilingenabled','0',NULL),(428,0,1462257491,NULL,'profilingincluded','',NULL),(429,0,1462257491,NULL,'profilingexcluded','',NULL),(430,0,1462257491,NULL,'profilingautofrec','0',NULL),(431,0,1462257491,NULL,'profilingallowme','0',NULL),(432,0,1462257491,NULL,'profilingallowall','0',NULL),(433,0,1462257491,NULL,'profilinglifetime','1440',NULL),(434,0,1462257491,NULL,'profilingimportprefix','(I)',NULL),(435,0,1462257540,'activitynames','filter_active','1',''),(436,0,1462257540,'mathjaxloader','filter_active','1',''),(437,0,1462257540,'mediaplugin','filter_active','1',''),(438,2,1462257598,NULL,'notloggedinroleid','6',NULL),(439,2,1462257598,NULL,'guestroleid','6',NULL),(440,2,1462257598,NULL,'defaultuserroleid','7',NULL),(441,2,1462257598,NULL,'creatornewroleid','3',NULL),(442,2,1462257598,NULL,'restorernewroleid','3',NULL),(443,2,1462257598,NULL,'gradebookroles','5',NULL),(444,2,1462257598,'assign','feedback_plugin_for_gradebook','assignfeedback_comments',NULL),(445,2,1462257598,'assign','showrecentsubmissions','0',NULL),(446,2,1462257598,'assign','submissionreceipts','1',NULL),(447,2,1462257598,'assign','submissionstatement','This assignment is my own work, except where I have acknowledged the use of the works of other people.',NULL),(448,2,1462257598,'assign','alwaysshowdescription','1',NULL),(449,2,1462257598,'assign','alwaysshowdescription_adv','',NULL),(450,2,1462257598,'assign','alwaysshowdescription_locked','',NULL),(451,2,1462257598,'assign','allowsubmissionsfromdate','0',NULL),(452,2,1462257598,'assign','allowsubmissionsfromdate_enabled','1',NULL),(453,2,1462257598,'assign','allowsubmissionsfromdate_adv','',NULL),(454,2,1462257598,'assign','duedate','604800',NULL),(455,2,1462257598,'assign','duedate_enabled','1',NULL),(456,2,1462257598,'assign','duedate_adv','',NULL),(457,2,1462257598,'assign','cutoffdate','1209600',NULL),(458,2,1462257598,'assign','cutoffdate_enabled','',NULL),(459,2,1462257598,'assign','cutoffdate_adv','',NULL),(460,2,1462257598,'assign','submissiondrafts','0',NULL),(461,2,1462257598,'assign','submissiondrafts_adv','',NULL),(462,2,1462257598,'assign','submissiondrafts_locked','',NULL),(463,2,1462257598,'assign','requiresubmissionstatement','0',NULL),(464,2,1462257598,'assign','requiresubmissionstatement_adv','',NULL),(465,2,1462257598,'assign','requiresubmissionstatement_locked','',NULL),(466,2,1462257598,'assign','attemptreopenmethod','none',NULL),(467,2,1462257598,'assign','attemptreopenmethod_adv','',NULL),(468,2,1462257598,'assign','attemptreopenmethod_locked','',NULL),(469,2,1462257598,'assign','maxattempts','-1',NULL),(470,2,1462257598,'assign','maxattempts_adv','',NULL),(471,2,1462257598,'assign','maxattempts_locked','',NULL),(472,2,1462257598,'assign','teamsubmission','0',NULL),(473,2,1462257598,'assign','teamsubmission_adv','',NULL),(474,2,1462257598,'assign','teamsubmission_locked','',NULL),(475,2,1462257598,'assign','preventsubmissionnotingroup','0',NULL),(476,2,1462257598,'assign','preventsubmissionnotingroup_adv','',NULL),(477,2,1462257598,'assign','preventsubmissionnotingroup_locked','',NULL),(478,2,1462257598,'assign','requireallteammemberssubmit','0',NULL),(479,2,1462257598,'assign','requireallteammemberssubmit_adv','',NULL),(480,2,1462257598,'assign','requireallteammemberssubmit_locked','',NULL),(481,2,1462257598,'assign','teamsubmissiongroupingid','',NULL),(482,2,1462257598,'assign','teamsubmissiongroupingid_adv','',NULL),(483,2,1462257598,'assign','sendnotifications','0',NULL),(484,2,1462257598,'assign','sendnotifications_adv','',NULL),(485,2,1462257598,'assign','sendnotifications_locked','',NULL),(486,2,1462257598,'assign','sendlatenotifications','0',NULL),(487,2,1462257598,'assign','sendlatenotifications_adv','',NULL),(488,2,1462257598,'assign','sendlatenotifications_locked','',NULL),(489,2,1462257598,'assign','sendstudentnotifications','1',NULL),(490,2,1462257598,'assign','sendstudentnotifications_adv','',NULL),(491,2,1462257598,'assign','sendstudentnotifications_locked','',NULL),(492,2,1462257598,'assign','blindmarking','0',NULL),(493,2,1462257598,'assign','blindmarking_adv','',NULL),(494,2,1462257598,'assign','blindmarking_locked','',NULL),(495,2,1462257598,'assign','markingworkflow','0',NULL),(496,2,1462257598,'assign','markingworkflow_adv','',NULL),(497,2,1462257598,'assign','markingworkflow_locked','',NULL),(498,2,1462257598,'assign','markingallocation','0',NULL),(499,2,1462257598,'assign','markingallocation_adv','',NULL),(500,2,1462257598,'assign','markingallocation_locked','',NULL),(501,2,1462257598,'assignsubmission_file','default','1',NULL),(502,2,1462257598,'assignsubmission_file','maxfiles','20',NULL),(503,2,1462257598,'assignsubmission_file','maxbytes','1048576',NULL),(504,2,1462257598,'assignsubmission_onlinetext','default','0',NULL),(505,2,1462257598,'assignfeedback_comments','default','1',NULL),(506,2,1462257598,'assignfeedback_comments','inline','0',NULL),(507,2,1462257598,'assignfeedback_comments','inline_adv','',NULL),(508,2,1462257598,'assignfeedback_comments','inline_locked','',NULL),(509,2,1462257598,'assignfeedback_editpdf','stamps','',NULL),(510,2,1462257598,'assignfeedback_file','default','0',NULL),(511,2,1462257598,'assignfeedback_offline','default','0',NULL),(512,2,1462257598,'book','numberingoptions','0,1,2,3',NULL),(513,2,1462257598,'book','navoptions','0,1,2',NULL),(514,2,1462257598,'book','numbering','1',NULL),(515,2,1462257598,'book','navstyle','1',NULL),(516,2,1462257598,NULL,'chat_method','ajax',NULL),(517,2,1462257598,NULL,'chat_refresh_userlist','10',NULL),(518,2,1462257598,NULL,'chat_old_ping','35',NULL),(519,2,1462257598,NULL,'chat_refresh_room','5',NULL),(520,2,1462257598,NULL,'chat_normal_updatemode','jsupdate',NULL),(521,2,1462257598,NULL,'chat_serverhost','sprucelogin.com',NULL),(522,2,1462257598,NULL,'chat_serverip','127.0.0.1',NULL),(523,2,1462257598,NULL,'chat_serverport','9111',NULL),(524,2,1462257598,NULL,'chat_servermax','100',NULL),(525,2,1462257598,NULL,'data_enablerssfeeds','0',NULL),(526,2,1462257598,NULL,'feedback_allowfullanonymous','0',NULL),(527,2,1462257598,'folder','showexpanded','1',NULL),(528,2,1462257598,NULL,'forum_displaymode','3',NULL),(529,2,1462257598,NULL,'forum_replytouser','1',NULL),(530,2,1462257598,NULL,'forum_shortpost','300',NULL),(531,2,1462257598,NULL,'forum_longpost','600',NULL),(532,2,1462257598,NULL,'forum_manydiscussions','100',NULL),(533,2,1462257598,NULL,'forum_maxbytes','512000',NULL),(534,2,1462257598,NULL,'forum_maxattachments','9',NULL),(535,2,1462257598,NULL,'forum_trackingtype','1',NULL),(536,2,1462257598,NULL,'forum_trackreadposts','1',NULL),(537,2,1462257598,NULL,'forum_allowforcedreadtracking','0',NULL),(538,2,1462257598,NULL,'forum_oldpostdays','14',NULL),(539,2,1462257599,NULL,'forum_usermarksread','0',NULL),(540,2,1462257599,NULL,'forum_cleanreadtime','2',NULL),(541,2,1462257599,NULL,'digestmailtime','17',NULL),(542,2,1462257599,NULL,'forum_enablerssfeeds','0',NULL),(543,2,1462257599,NULL,'forum_enabletimedposts','0',NULL),(544,2,1462257599,NULL,'glossary_entbypage','10',NULL),(545,2,1462257599,NULL,'glossary_dupentries','0',NULL),(546,2,1462257599,NULL,'glossary_allowcomments','0',NULL),(547,2,1462257599,NULL,'glossary_linkbydefault','1',NULL),(548,2,1462257599,NULL,'glossary_defaultapproval','1',NULL),(549,2,1462257599,NULL,'glossary_enablerssfeeds','0',NULL),(550,2,1462257599,NULL,'glossary_linkentries','0',NULL),(551,2,1462257599,NULL,'glossary_casesensitive','0',NULL),(552,2,1462257599,NULL,'glossary_fullmatch','0',NULL),(553,2,1462257599,'imscp','keepold','1',NULL),(554,2,1462257599,'imscp','keepold_adv','',NULL),(555,2,1462257599,'label','dndmedia','1',NULL),(556,2,1462257599,'label','dndresizewidth','400',NULL),(557,2,1462257599,'label','dndresizeheight','400',NULL),(558,2,1462257599,NULL,'lesson_slideshowwidth','640',NULL),(559,2,1462257599,NULL,'lesson_slideshowheight','480',NULL),(560,2,1462257599,NULL,'lesson_slideshowbgcolor','#FFFFFF',NULL),(561,2,1462257599,NULL,'lesson_mediawidth','640',NULL),(562,2,1462257599,NULL,'lesson_mediaheight','480',NULL),(563,2,1462257599,NULL,'lesson_mediaclose','0',NULL),(564,2,1462257599,NULL,'lesson_maxanswers','4',NULL),(565,2,1462257599,NULL,'lesson_defaultnextpage','0',NULL),(566,2,1462257599,'page','displayoptions','5',NULL),(567,2,1462257599,'page','printheading','1',NULL),(568,2,1462257599,'page','printintro','0',NULL),(569,2,1462257599,'page','display','5',NULL),(570,2,1462257599,'page','popupwidth','620',NULL),(571,2,1462257599,'page','popupheight','450',NULL),(572,2,1462257599,'quiz','timelimit','0',NULL),(573,2,1462257599,'quiz','timelimit_adv','',NULL),(574,2,1462257599,'quiz','overduehandling','autosubmit',NULL),(575,2,1462257599,'quiz','overduehandling_adv','',NULL),(576,2,1462257599,'quiz','graceperiod','86400',NULL),(577,2,1462257599,'quiz','graceperiod_adv','',NULL),(578,2,1462257599,'quiz','graceperiodmin','60',NULL),(579,2,1462257599,'quiz','attempts','0',NULL),(580,2,1462257599,'quiz','attempts_adv','',NULL),(581,2,1462257599,'quiz','grademethod','1',NULL),(582,2,1462257599,'quiz','grademethod_adv','',NULL),(583,2,1462257599,'quiz','maximumgrade','10',NULL),(584,2,1462257599,'quiz','questionsperpage','1',NULL),(585,2,1462257599,'quiz','questionsperpage_adv','',NULL),(586,2,1462257599,'quiz','navmethod','free',NULL),(587,2,1462257599,'quiz','navmethod_adv','1',NULL),(588,2,1462257599,'quiz','shuffleanswers','1',NULL),(589,2,1462257599,'quiz','shuffleanswers_adv','',NULL),(590,2,1462257599,'quiz','preferredbehaviour','deferredfeedback',NULL),(591,2,1462257599,'quiz','canredoquestions','0',NULL),(592,2,1462257599,'quiz','canredoquestions_adv','1',NULL),(593,2,1462257599,'quiz','attemptonlast','0',NULL),(594,2,1462257599,'quiz','attemptonlast_adv','1',NULL),(595,2,1462257599,'quiz','reviewattempt','69904',NULL),(596,2,1462257599,'quiz','reviewcorrectness','69904',NULL),(597,2,1462257599,'quiz','reviewmarks','69904',NULL),(598,2,1462257599,'quiz','reviewspecificfeedback','69904',NULL),(599,2,1462257599,'quiz','reviewgeneralfeedback','69904',NULL),(600,2,1462257599,'quiz','reviewrightanswer','69904',NULL),(601,2,1462257599,'quiz','reviewoverallfeedback','4368',NULL),(602,2,1462257599,'quiz','showuserpicture','0',NULL),(603,2,1462257599,'quiz','showuserpicture_adv','',NULL),(604,2,1462257599,'quiz','decimalpoints','2',NULL),(605,2,1462257599,'quiz','decimalpoints_adv','',NULL),(606,2,1462257599,'quiz','questiondecimalpoints','-1',NULL),(607,2,1462257599,'quiz','questiondecimalpoints_adv','1',NULL),(608,2,1462257599,'quiz','showblocks','0',NULL),(609,2,1462257599,'quiz','showblocks_adv','1',NULL),(610,2,1462257599,'quiz','password','',NULL),(611,2,1462257599,'quiz','password_adv','',NULL),(612,2,1462257599,'quiz','subnet','',NULL),(613,2,1462257599,'quiz','subnet_adv','1',NULL),(614,2,1462257599,'quiz','delay1','0',NULL),(615,2,1462257599,'quiz','delay1_adv','1',NULL),(616,2,1462257599,'quiz','delay2','0',NULL),(617,2,1462257599,'quiz','delay2_adv','1',NULL),(618,2,1462257599,'quiz','browsersecurity','-',NULL),(619,2,1462257599,'quiz','browsersecurity_adv','1',NULL),(620,2,1462257599,'quiz','initialnumfeedbacks','2',NULL),(621,2,1462257599,'quiz','autosaveperiod','60',NULL),(622,2,1462257599,'resource','framesize','130',NULL),(623,2,1462257599,'resource','displayoptions','0,1,4,5,6',NULL),(624,2,1462257599,'resource','printintro','1',NULL),(625,2,1462257599,'resource','display','0',NULL),(626,2,1462257599,'resource','showsize','0',NULL),(627,2,1462257599,'resource','showtype','0',NULL),(628,2,1462257599,'resource','showdate','0',NULL),(629,2,1462257599,'resource','popupwidth','620',NULL),(630,2,1462257599,'resource','popupheight','450',NULL),(631,2,1462257599,'resource','filterfiles','0',NULL),(632,2,1462257599,'scorm','displaycoursestructure','0',NULL),(633,2,1462257599,'scorm','displaycoursestructure_adv','',NULL),(634,2,1462257599,'scorm','popup','0',NULL),(635,2,1462257599,'scorm','popup_adv','',NULL),(636,2,1462257599,'scorm','displayactivityname','1',NULL),(637,2,1462257599,'scorm','framewidth','100',NULL),(638,2,1462257599,'scorm','framewidth_adv','1',NULL),(639,2,1462257599,'scorm','frameheight','500',NULL),(640,2,1462257599,'scorm','frameheight_adv','1',NULL),(641,2,1462257599,'scorm','winoptgrp_adv','1',NULL),(642,2,1462257599,'scorm','scrollbars','0',NULL),(643,2,1462257599,'scorm','directories','0',NULL),(644,2,1462257599,'scorm','location','0',NULL),(645,2,1462257599,'scorm','menubar','0',NULL),(646,2,1462257599,'scorm','toolbar','0',NULL),(647,2,1462257599,'scorm','status','0',NULL),(648,2,1462257599,'scorm','skipview','0',NULL),(649,2,1462257599,'scorm','skipview_adv','1',NULL),(650,2,1462257599,'scorm','hidebrowse','0',NULL),(651,2,1462257599,'scorm','hidebrowse_adv','1',NULL),(652,2,1462257599,'scorm','hidetoc','0',NULL),(653,2,1462257599,'scorm','hidetoc_adv','1',NULL),(654,2,1462257599,'scorm','nav','1',NULL),(655,2,1462257599,'scorm','nav_adv','1',NULL),(656,2,1462257599,'scorm','navpositionleft','-100',NULL),(657,2,1462257599,'scorm','navpositionleft_adv','1',NULL),(658,2,1462257599,'scorm','navpositiontop','-100',NULL),(659,2,1462257599,'scorm','navpositiontop_adv','1',NULL),(660,2,1462257599,'scorm','collapsetocwinsize','767',NULL),(661,2,1462257599,'scorm','collapsetocwinsize_adv','1',NULL),(662,2,1462257599,'scorm','displayattemptstatus','1',NULL),(663,2,1462257599,'scorm','displayattemptstatus_adv','',NULL),(664,2,1462257599,'scorm','grademethod','1',NULL),(665,2,1462257599,'scorm','maxgrade','100',NULL),(666,2,1462257599,'scorm','maxattempt','0',NULL),(667,2,1462257599,'scorm','whatgrade','0',NULL),(668,2,1462257599,'scorm','forcecompleted','0',NULL),(669,2,1462257599,'scorm','forcenewattempt','0',NULL),(670,2,1462257599,'scorm','autocommit','0',NULL),(671,2,1462257599,'scorm','lastattemptlock','0',NULL),(672,2,1462257599,'scorm','auto','0',NULL),(673,2,1462257599,'scorm','updatefreq','0',NULL),(674,2,1462257599,'scorm','scorm12standard','1',NULL),(675,2,1462257599,'scorm','allowtypeexternal','0',NULL),(676,2,1462257599,'scorm','allowtypelocalsync','0',NULL),(677,2,1462257599,'scorm','allowtypeexternalaicc','0',NULL),(678,2,1462257599,'scorm','allowaicchacp','0',NULL),(679,2,1462257599,'scorm','aicchacptimeout','30',NULL),(680,2,1462257599,'scorm','aicchacpkeepsessiondata','1',NULL),(681,2,1462257599,'scorm','aiccuserid','1',NULL),(682,2,1462257599,'scorm','forcejavascript','1',NULL),(683,2,1462257599,'scorm','allowapidebug','0',NULL),(684,2,1462257599,'scorm','apidebugmask','.*',NULL),(685,2,1462257599,'scorm','protectpackagedownloads','0',NULL),(686,2,1462257599,'url','framesize','130',NULL),(687,2,1462257599,'url','secretphrase','',NULL),(688,2,1462257599,'url','rolesinparams','0',NULL),(689,2,1462257599,'url','displayoptions','0,1,5,6',NULL),(690,2,1462257599,'url','printintro','1',NULL),(691,2,1462257599,'url','display','0',NULL),(692,2,1462257599,'url','popupwidth','620',NULL),(693,2,1462257599,'url','popupheight','450',NULL),(694,2,1462257599,'workshop','grade','80',NULL),(695,2,1462257599,'workshop','gradinggrade','20',NULL),(696,2,1462257599,'workshop','gradedecimals','0',NULL),(697,2,1462257599,'workshop','maxbytes','0',NULL),(698,2,1462257599,'workshop','strategy','accumulative',NULL),(699,2,1462257599,'workshop','examplesmode','0',NULL),(700,2,1462257599,'workshopallocation_random','numofreviews','5',NULL),(701,2,1462257599,'workshopform_numerrors','grade0','No',NULL),(702,2,1462257599,'workshopform_numerrors','grade1','Yes',NULL),(703,2,1462257599,'workshopeval_best','comparison','5',NULL),(704,2,1462257599,NULL,'block_course_list_adminview','all',NULL),(705,2,1462257599,NULL,'block_course_list_hideallcourseslink','0',NULL),(706,2,1462257599,'block_course_overview','defaultmaxcourses','10',NULL),(707,2,1462257599,'block_course_overview','forcedefaultmaxcourses','0',NULL),(708,2,1462257599,'block_course_overview','showchildren','0',NULL),(709,2,1462257599,'block_course_overview','showwelcomearea','0',NULL),(710,2,1462257599,'block_course_overview','showcategories','0',NULL),(711,2,1462257599,NULL,'block_html_allowcssclasses','0',NULL),(712,2,1462257599,NULL,'block_online_users_timetosee','5',NULL),(713,2,1462257599,NULL,'block_rss_client_num_entries','5',NULL),(714,2,1462257599,NULL,'block_rss_client_timeout','30',NULL),(715,2,1462257599,'block_section_links','numsections1','22',NULL),(716,2,1462257599,'block_section_links','incby1','2',NULL),(717,2,1462257599,'block_section_links','numsections2','40',NULL),(718,2,1462257599,'block_section_links','incby2','5',NULL),(719,2,1462257599,'block_tag_youtube','apikey','',NULL),(720,2,1462257599,'format_singleactivity','activitytype','forum',NULL),(721,2,1462257599,'enrol_cohort','roleid','5',NULL),(722,2,1462257599,'enrol_cohort','unenrolaction','0',NULL),(723,2,1462257599,'enrol_database','dbtype','',NULL),(724,2,1462257599,'enrol_database','dbhost','localhost',NULL),(725,2,1462257599,'enrol_database','dbuser','',NULL),(726,2,1462257599,'enrol_database','dbpass','',NULL),(727,2,1462257599,'enrol_database','dbname','',NULL),(728,2,1462257599,'enrol_database','dbencoding','utf-8',NULL),(729,2,1462257599,'enrol_database','dbsetupsql','',NULL),(730,2,1462257599,'enrol_database','dbsybasequoting','0',NULL),(731,2,1462257599,'enrol_database','debugdb','0',NULL),(732,2,1462257599,'enrol_database','localcoursefield','idnumber',NULL),(733,2,1462257599,'enrol_database','localuserfield','idnumber',NULL),(734,2,1462257599,'enrol_database','localrolefield','shortname',NULL),(735,2,1462257599,'enrol_database','localcategoryfield','id',NULL),(736,2,1462257599,'enrol_database','remoteenroltable','',NULL),(737,2,1462257599,'enrol_database','remotecoursefield','',NULL),(738,2,1462257599,'enrol_database','remoteuserfield','',NULL),(739,2,1462257599,'enrol_database','remoterolefield','',NULL),(740,2,1462257599,'enrol_database','remoteotheruserfield','',NULL),(741,2,1462257599,'enrol_database','defaultrole','5',NULL),(742,2,1462257599,'enrol_database','ignorehiddencourses','0',NULL),(743,2,1462257599,'enrol_database','unenrolaction','0',NULL),(744,2,1462257599,'enrol_database','newcoursetable','',NULL),(745,2,1462257599,'enrol_database','newcoursefullname','fullname',NULL),(746,2,1462257599,'enrol_database','newcourseshortname','shortname',NULL),(747,2,1462257599,'enrol_database','newcourseidnumber','idnumber',NULL),(748,2,1462257599,'enrol_database','newcoursecategory','',NULL),(749,2,1462257600,'enrol_database','defaultcategory','1',NULL),(750,2,1462257600,'enrol_database','templatecourse','',NULL),(751,2,1462257600,'enrol_flatfile','location','',NULL),(752,2,1462257600,'enrol_flatfile','encoding','UTF-8',NULL),(753,2,1462257600,'enrol_flatfile','mailstudents','0',NULL),(754,2,1462257600,'enrol_flatfile','mailteachers','0',NULL),(755,2,1462257600,'enrol_flatfile','mailadmins','0',NULL),(756,2,1462257600,'enrol_flatfile','unenrolaction','3',NULL),(757,2,1462257600,'enrol_flatfile','expiredaction','3',NULL),(758,2,1462257600,'enrol_guest','requirepassword','0',NULL),(759,2,1462257600,'enrol_guest','usepasswordpolicy','0',NULL),(760,2,1462257600,'enrol_guest','showhint','0',NULL),(761,2,1462257600,'enrol_guest','defaultenrol','1',NULL),(762,2,1462257600,'enrol_guest','status','1',NULL),(763,2,1462257600,'enrol_guest','status_adv','',NULL),(764,2,1462257600,'enrol_imsenterprise','imsfilelocation','',NULL),(765,2,1462257600,'enrol_imsenterprise','logtolocation','',NULL),(766,2,1462257600,'enrol_imsenterprise','mailadmins','0',NULL),(767,2,1462257600,'enrol_imsenterprise','createnewusers','0',NULL),(768,2,1462257600,'enrol_imsenterprise','imsdeleteusers','0',NULL),(769,2,1462257600,'enrol_imsenterprise','fixcaseusernames','0',NULL),(770,2,1462257600,'enrol_imsenterprise','fixcasepersonalnames','0',NULL),(771,2,1462257600,'enrol_imsenterprise','imssourcedidfallback','0',NULL),(772,2,1462257600,'enrol_imsenterprise','imsrolemap01','5',NULL),(773,2,1462257600,'enrol_imsenterprise','imsrolemap02','3',NULL),(774,2,1462257600,'enrol_imsenterprise','imsrolemap03','3',NULL),(775,2,1462257600,'enrol_imsenterprise','imsrolemap04','5',NULL),(776,2,1462257600,'enrol_imsenterprise','imsrolemap05','0',NULL),(777,2,1462257600,'enrol_imsenterprise','imsrolemap06','4',NULL),(778,2,1462257600,'enrol_imsenterprise','imsrolemap07','0',NULL),(779,2,1462257600,'enrol_imsenterprise','imsrolemap08','4',NULL),(780,2,1462257600,'enrol_imsenterprise','truncatecoursecodes','0',NULL),(781,2,1462257600,'enrol_imsenterprise','createnewcourses','0',NULL),(782,2,1462257600,'enrol_imsenterprise','createnewcategories','0',NULL),(783,2,1462257600,'enrol_imsenterprise','imsunenrol','0',NULL),(784,2,1462257600,'enrol_imsenterprise','imscoursemapshortname','coursecode',NULL),(785,2,1462257600,'enrol_imsenterprise','imscoursemapfullname','short',NULL),(786,2,1462257600,'enrol_imsenterprise','imscoursemapsummary','ignore',NULL),(787,2,1462257600,'enrol_imsenterprise','imsrestricttarget','',NULL),(788,2,1462257600,'enrol_imsenterprise','imscapitafix','0',NULL),(789,2,1462257600,'enrol_manual','expiredaction','1',NULL),(790,2,1462257600,'enrol_manual','expirynotifyhour','6',NULL),(791,2,1462257600,'enrol_manual','defaultenrol','1',NULL),(792,2,1462257600,'enrol_manual','status','0',NULL),(793,2,1462257600,'enrol_manual','roleid','5',NULL),(794,2,1462257600,'enrol_manual','enrolstart','4',NULL),(795,2,1462257600,'enrol_manual','enrolperiod','0',NULL),(796,2,1462257600,'enrol_manual','expirynotify','0',NULL),(797,2,1462257600,'enrol_manual','expirythreshold','86400',NULL),(798,2,1462257600,'enrol_meta','nosyncroleids','',NULL),(799,2,1462257600,'enrol_meta','syncall','1',NULL),(800,2,1462257600,'enrol_meta','unenrolaction','3',NULL),(801,2,1462257600,'enrol_meta','coursesort','sortorder',NULL),(802,2,1462257600,'enrol_mnet','roleid','5',NULL),(803,2,1462257600,'enrol_mnet','roleid_adv','1',NULL),(804,2,1462257600,'enrol_paypal','paypalbusiness','',NULL),(805,2,1462257600,'enrol_paypal','mailstudents','0',NULL),(806,2,1462257600,'enrol_paypal','mailteachers','0',NULL),(807,2,1462257600,'enrol_paypal','mailadmins','0',NULL),(808,2,1462257600,'enrol_paypal','expiredaction','3',NULL),(809,2,1462257600,'enrol_paypal','status','1',NULL),(810,2,1462257600,'enrol_paypal','cost','0',NULL),(811,2,1462257600,'enrol_paypal','currency','USD',NULL),(812,2,1462257600,'enrol_paypal','roleid','5',NULL),(813,2,1462257600,'enrol_paypal','enrolperiod','0',NULL),(814,2,1462257600,'enrol_self','requirepassword','0',NULL),(815,2,1462257600,'enrol_self','usepasswordpolicy','0',NULL),(816,2,1462257600,'enrol_self','showhint','0',NULL),(817,2,1462257600,'enrol_self','expiredaction','1',NULL),(818,2,1462257600,'enrol_self','expirynotifyhour','6',NULL),(819,2,1462257600,'enrol_self','defaultenrol','1',NULL),(820,2,1462257600,'enrol_self','status','1',NULL),(821,2,1462257600,'enrol_self','newenrols','1',NULL),(822,2,1462257600,'enrol_self','groupkey','0',NULL),(823,2,1462257600,'enrol_self','roleid','5',NULL),(824,2,1462257600,'enrol_self','enrolperiod','0',NULL),(825,2,1462257600,'enrol_self','expirynotify','0',NULL),(826,2,1462257600,'enrol_self','expirythreshold','86400',NULL),(827,2,1462257600,'enrol_self','longtimenosee','0',NULL),(828,2,1462257600,'enrol_self','maxenrolled','0',NULL),(829,2,1462257600,'enrol_self','sendcoursewelcomemessage','1',NULL),(830,2,1462257600,NULL,'filter_censor_badwords','',NULL),(831,2,1462257600,'filter_emoticon','formats','1,4,0',NULL),(832,2,1462257600,'filter_mathjaxloader','httpurl','http://cdn.mathjax.org/mathjax/2.5-latest/MathJax.js',NULL),(833,2,1462257600,'filter_mathjaxloader','httpsurl','https://cdn.mathjax.org/mathjax/2.5-latest/MathJax.js',NULL),(834,2,1462257600,'filter_mathjaxloader','texfiltercompatibility','0',NULL),(835,2,1462257600,'filter_mathjaxloader','mathjaxconfig','\nMathJax.Hub.Config({\n    config: [\"Accessible.js\", \"Safe.js\"],\n    errorSettings: { message: [\"!\"] },\n    skipStartupTypeset: true,\n    messageStyle: \"none\"\n});\n',NULL),(836,2,1462257600,'filter_mathjaxloader','additionaldelimiters','',NULL),(837,2,1462257600,NULL,'filter_multilang_force_old','0',NULL),(838,2,1462257600,'filter_tex','latexpreamble','\\usepackage[latin1]{inputenc}\n\\usepackage{amsmath}\n\\usepackage{amsfonts}\n\\RequirePackage{amsmath,amssymb,latexsym}\n',NULL),(839,2,1462257600,'filter_tex','latexbackground','#FFFFFF',NULL),(840,2,1462257600,'filter_tex','density','120',NULL),(841,2,1462257600,'filter_tex','pathlatex','/usr/bin/latex',NULL),(842,2,1462257600,'filter_tex','pathdvips','/usr/bin/dvips',NULL),(843,2,1462257600,'filter_tex','pathconvert','/usr/bin/convert',NULL),(844,2,1462257600,'filter_tex','pathdvisvgm','/usr/bin/dvisvgm',NULL),(845,2,1462257600,'filter_tex','pathmimetex','',NULL),(846,2,1462257600,'filter_tex','convertformat','gif',NULL),(847,2,1462257600,'filter_urltolink','formats','0',NULL),(848,2,1462257600,'filter_urltolink','embedimages','1',NULL),(849,2,1462257600,'logstore_database','dbdriver','',NULL),(850,2,1462257600,'logstore_database','dbhost','',NULL),(851,2,1462257600,'logstore_database','dbuser','',NULL),(852,2,1462257600,'logstore_database','dbpass','',NULL),(853,2,1462257600,'logstore_database','dbname','',NULL),(854,2,1462257600,'logstore_database','dbtable','',NULL),(855,2,1462257600,'logstore_database','dbpersist','0',NULL),(856,2,1462257600,'logstore_database','dbsocket','',NULL),(857,2,1462257600,'logstore_database','dbport','',NULL),(858,2,1462257600,'logstore_database','dbschema','',NULL),(859,2,1462257600,'logstore_database','dbcollation','',NULL),(860,2,1462257600,'logstore_database','buffersize','50',NULL),(861,2,1462257600,'logstore_database','logguests','0',NULL),(862,2,1462257600,'logstore_database','includelevels','1,2,0',NULL),(863,2,1462257600,'logstore_database','includeactions','c,r,u,d',NULL),(864,2,1462257600,'logstore_legacy','loglegacy','0',NULL),(865,2,1462257600,NULL,'logguests','1',NULL),(866,2,1462257600,NULL,'loglifetime','0',NULL),(867,2,1462257600,'logstore_standard','logguests','1',NULL),(868,2,1462257600,'logstore_standard','loglifetime','0',NULL),(869,2,1462257600,'logstore_standard','buffersize','50',NULL),(870,2,1462257600,NULL,'airnotifierurl','https://messages.moodle.net',NULL),(871,2,1462257600,NULL,'airnotifierport','443',NULL),(872,2,1462257600,NULL,'airnotifiermobileappname','com.moodle.moodlemobile',NULL),(873,2,1462257600,NULL,'airnotifierappname','commoodlemoodlemobile',NULL),(874,2,1462257600,NULL,'airnotifieraccesskey','',NULL),(875,2,1462257600,NULL,'smtphosts','',NULL),(876,2,1462257600,NULL,'smtpsecure','',NULL),(877,2,1462257600,NULL,'smtpauthtype','LOGIN',NULL),(878,2,1462257600,NULL,'smtpuser','',NULL),(879,2,1462257600,NULL,'smtppass','',NULL),(880,2,1462257600,NULL,'smtpmaxbulk','1',NULL),(881,2,1462257600,NULL,'noreplyaddress','noreply@sprucelogin.com',NULL),(882,2,1462257600,NULL,'emailonlyfromnoreplyaddress','0',NULL),(883,2,1462257600,NULL,'sitemailcharset','0',NULL),(884,2,1462257600,NULL,'allowusermailcharset','0',NULL),(885,2,1462257600,NULL,'allowattachments','1',NULL),(886,2,1462257600,NULL,'mailnewline','LF',NULL),(887,2,1462257600,NULL,'jabberhost','',NULL),(888,2,1462257600,NULL,'jabberserver','',NULL),(889,2,1462257600,NULL,'jabberusername','',NULL),(890,2,1462257600,NULL,'jabberpassword','',NULL),(891,2,1462257600,NULL,'jabberport','5222',NULL),(892,2,1462257600,'editor_atto','toolbar','collapse = collapse\nstyle1 = title, bold, italic\nlist = unorderedlist, orderedlist\nlinks = link\nfiles = image, media, managefiles\nstyle2 = underline, strike, subscript, superscript\nalign = align\nindent = indent\ninsert = equation, charmap, table, clear\nundo = undo\naccessibility = accessibilitychecker, accessibilityhelper\nother = html',NULL),(893,2,1462257600,'editor_atto','autosavefrequency','60',NULL),(894,2,1462257600,'atto_collapse','showgroups','5',NULL),(895,2,1462257600,'atto_equation','librarygroup1','\n\\cdot\n\\times\n\\ast\n\\div\n\\diamond\n\\pm\n\\mp\n\\oplus\n\\ominus\n\\otimes\n\\oslash\n\\odot\n\\circ\n\\bullet\n\\asymp\n\\equiv\n\\subseteq\n\\supseteq\n\\leq\n\\geq\n\\preceq\n\\succeq\n\\sim\n\\simeq\n\\approx\n\\subset\n\\supset\n\\ll\n\\gg\n\\prec\n\\succ\n\\infty\n\\in\n\\ni\n\\forall\n\\exists\n\\neq\n',NULL),(896,2,1462257600,'atto_equation','librarygroup2','\n\\leftarrow\n\\rightarrow\n\\uparrow\n\\downarrow\n\\leftrightarrow\n\\nearrow\n\\searrow\n\\swarrow\n\\nwarrow\n\\Leftarrow\n\\Rightarrow\n\\Uparrow\n\\Downarrow\n\\Leftrightarrow\n',NULL),(897,2,1462257600,'atto_equation','librarygroup3','\n\\alpha\n\\beta\n\\gamma\n\\delta\n\\epsilon\n\\zeta\n\\eta\n\\theta\n\\iota\n\\kappa\n\\lambda\n\\mu\n\\nu\n\\xi\n\\pi\n\\rho\n\\sigma\n\\tau\n\\upsilon\n\\phi\n\\chi\n\\psi\n\\omega\n\\Gamma\n\\Delta\n\\Theta\n\\Lambda\n\\Xi\n\\Pi\n\\Sigma\n\\Upsilon\n\\Phi\n\\Psi\n\\Omega\n',NULL),(898,2,1462257600,'atto_equation','librarygroup4','\n\\sum{a,b}\n\\sqrt[a]{b+c}\n\\int_{a}^{b}{c}\n\\iint_{a}^{b}{c}\n\\iiint_{a}^{b}{c}\n\\oint{a}\n(a)\n[a]\n\\lbrace{a}\\rbrace\n\\left| \\begin{matrix} a_1 & a_2 \\ a_3 & a_4 \\end{matrix} \\right|\n\\frac{a}{b+c}\n\\vec{a}\n\\binom {a} {b}\n{a \\brack b}\n{a \\brace b}\n',NULL),(899,2,1462257600,'atto_table','allowborders','0',NULL),(900,2,1462257600,'atto_table','allowbackgroundcolour','0',NULL),(901,2,1462257600,'atto_table','allowwidth','0',NULL),(902,2,1462257600,'editor_tinymce','customtoolbar','wrap,formatselect,wrap,bold,italic,wrap,bullist,numlist,wrap,link,unlink,wrap,image\n\nundo,redo,wrap,underline,strikethrough,sub,sup,wrap,justifyleft,justifycenter,justifyright,wrap,outdent,indent,wrap,forecolor,backcolor,wrap,ltr,rtl\n\nfontselect,fontsizeselect,wrap,code,search,replace,wrap,nonbreaking,charmap,table,wrap,cleanup,removeformat,pastetext,pasteword,wrap,fullscreen',NULL),(903,2,1462257600,'editor_tinymce','fontselectlist','Trebuchet=Trebuchet MS,Verdana,Arial,Helvetica,sans-serif;Arial=arial,helvetica,sans-serif;Courier New=courier new,courier,monospace;Georgia=georgia,times new roman,times,serif;Tahoma=tahoma,arial,helvetica,sans-serif;Times New Roman=times new roman,times,serif;Verdana=verdana,arial,helvetica,sans-serif;Impact=impact;Wingdings=wingdings',NULL),(904,2,1462257600,'editor_tinymce','customconfig','',NULL),(905,2,1462257600,'tinymce_moodleemoticon','requireemoticon','1',NULL),(906,2,1462257600,'tinymce_spellchecker','spellengine','',NULL),(907,2,1462257600,'tinymce_spellchecker','spelllanguagelist','+English=en,Danish=da,Dutch=nl,Finnish=fi,French=fr,German=de,Italian=it,Polish=pl,Portuguese=pt,Spanish=es,Swedish=sv',NULL),(908,2,1462257600,NULL,'enablemobilewebservice','0',NULL),(909,2,1462257600,NULL,'profileroles','5,4,3',NULL),(910,2,1462257600,NULL,'coursecontact','3',NULL),(911,2,1462257600,NULL,'frontpage','6',NULL),(912,2,1462257600,NULL,'frontpageloggedin','6',NULL),(913,2,1462257600,NULL,'maxcategorydepth','2',NULL),(914,2,1462257600,NULL,'frontpagecourselimit','200',NULL),(915,2,1462257600,NULL,'commentsperpage','15',NULL),(916,2,1462257600,NULL,'defaultfrontpageroleid','8',NULL),(917,2,1462257600,NULL,'messageinbound_enabled','0',NULL),(918,2,1462257600,NULL,'messageinbound_mailbox','',NULL),(919,2,1462257600,NULL,'messageinbound_domain','',NULL),(920,2,1462257600,NULL,'messageinbound_host','',NULL),(921,2,1462257600,NULL,'messageinbound_hostssl','ssl',NULL),(922,2,1462257600,NULL,'messageinbound_hostuser','',NULL),(923,2,1462257600,NULL,'messageinbound_hostpass','',NULL),(924,2,1462257629,NULL,'timezone','Africa/Abidjan',NULL),(925,2,1462257629,NULL,'registerauth','',NULL),(926,2,1462542546,'scorm','scorm12standard','0','1'),(927,2,1462554704,NULL,'enablecompletion','1','0'),(928,2,1462586019,NULL,'frontpageloggedin','5','6'),(929,2,1462586019,NULL,'defaultfrontpageroleid','6','8'),(930,2,1462586955,NULL,'defaultfrontpageroleid','8','6'),(931,2,1462587022,NULL,'defaultfrontpageroleid','5','8'),(932,2,1462587114,NULL,'frontpage','6,0','6'),(933,2,1462587253,NULL,'frontpage','6','6,0'),(934,2,1462587253,NULL,'frontpageloggedin','5,0','5');
/*!40000 ALTER TABLE `mdl_config_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_config_plugins`
--

DROP TABLE IF EXISTS `mdl_config_plugins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_config_plugins` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `plugin` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'core',
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_confplug_plunam_uix` (`plugin`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=1125 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Moodle modules and plugins configuration variables';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_config_plugins`
--

LOCK TABLES `mdl_config_plugins` WRITE;
/*!40000 ALTER TABLE `mdl_config_plugins` DISABLE KEYS */;
INSERT INTO `mdl_config_plugins` VALUES (1,'question','multichoice_sortorder','1'),(2,'question','truefalse_sortorder','2'),(3,'question','match_sortorder','3'),(4,'question','shortanswer_sortorder','4'),(5,'question','numerical_sortorder','5'),(6,'question','essay_sortorder','6'),(7,'moodlecourse','visible','1'),(8,'moodlecourse','format','weeks'),(9,'moodlecourse','maxsections','52'),(10,'moodlecourse','numsections','10'),(11,'moodlecourse','hiddensections','0'),(12,'moodlecourse','coursedisplay','0'),(13,'moodlecourse','lang',''),(14,'moodlecourse','newsitems','5'),(15,'moodlecourse','showgrades','1'),(16,'moodlecourse','showreports','0'),(17,'moodlecourse','maxbytes','0'),(18,'moodlecourse','enablecompletion','0'),(19,'moodlecourse','groupmode','0'),(20,'moodlecourse','groupmodeforce','0'),(21,'backup','loglifetime','30'),(22,'backup','backup_general_users','1'),(23,'backup','backup_general_users_locked',''),(24,'backup','backup_general_anonymize','0'),(25,'backup','backup_general_anonymize_locked',''),(26,'backup','backup_general_role_assignments','1'),(27,'backup','backup_general_role_assignments_locked',''),(28,'backup','backup_general_activities','1'),(29,'backup','backup_general_activities_locked',''),(30,'backup','backup_general_blocks','1'),(31,'backup','backup_general_blocks_locked',''),(32,'backup','backup_general_filters','1'),(33,'backup','backup_general_filters_locked',''),(34,'backup','backup_general_comments','1'),(35,'backup','backup_general_comments_locked',''),(36,'backup','backup_general_badges','1'),(37,'backup','backup_general_badges_locked',''),(38,'backup','backup_general_userscompletion','1'),(39,'backup','backup_general_userscompletion_locked',''),(40,'backup','backup_general_logs','0'),(41,'backup','backup_general_logs_locked',''),(42,'backup','backup_general_histories','0'),(43,'backup','backup_general_histories_locked',''),(44,'backup','backup_general_questionbank','1'),(45,'backup','backup_general_questionbank_locked',''),(46,'backup','backup_general_groups','1'),(47,'backup','backup_general_groups_locked',''),(48,'backup','import_general_maxresults','10'),(49,'backup','import_general_duplicate_admin_allowed','0'),(50,'backup','backup_auto_active','0'),(51,'backup','backup_auto_weekdays','0000000'),(52,'backup','backup_auto_hour','0'),(53,'backup','backup_auto_minute','0'),(54,'backup','backup_auto_storage','0'),(55,'backup','backup_auto_destination',''),(56,'backup','backup_auto_max_kept','1'),(57,'backup','backup_auto_delete_days','0'),(58,'backup','backup_auto_min_kept','0'),(59,'backup','backup_shortname','0'),(60,'backup','backup_auto_skip_hidden','1'),(61,'backup','backup_auto_skip_modif_days','30'),(62,'backup','backup_auto_skip_modif_prev','0'),(63,'backup','backup_auto_users','1'),(64,'backup','backup_auto_role_assignments','1'),(65,'backup','backup_auto_activities','1'),(66,'backup','backup_auto_blocks','1'),(67,'backup','backup_auto_filters','1'),(68,'backup','backup_auto_comments','1'),(69,'backup','backup_auto_badges','1'),(70,'backup','backup_auto_userscompletion','1'),(71,'backup','backup_auto_logs','0'),(72,'backup','backup_auto_histories','0'),(73,'backup','backup_auto_questionbank','1'),(74,'backup','backup_auto_groups','1'),(75,'cachestore_memcache','testservers',''),(76,'cachestore_memcached','testservers',''),(77,'cachestore_mongodb','testserver',''),(78,'question_preview','behaviour','deferredfeedback'),(79,'question_preview','correctness','1'),(80,'question_preview','marks','2'),(81,'question_preview','markdp','2'),(82,'question_preview','feedback','1'),(83,'question_preview','generalfeedback','1'),(84,'question_preview','rightanswer','1'),(85,'question_preview','history','0'),(86,'theme_clean','invert','0'),(87,'theme_clean','logo',''),(88,'theme_clean','customcss',''),(89,'theme_clean','footnote',''),(90,'theme_more','textcolor','#333366'),(91,'theme_more','linkcolor','#FF6500'),(92,'theme_more','bodybackground',''),(93,'theme_more','backgroundimage',''),(94,'theme_more','backgroundrepeat','repeat'),(95,'theme_more','backgroundposition','0'),(96,'theme_more','backgroundfixed','0'),(97,'theme_more','contentbackground','#FFFFFF'),(98,'theme_more','secondarybackground','#FFFFFF'),(99,'theme_more','invert','1'),(100,'theme_more','logo',''),(101,'theme_more','customcss',''),(102,'theme_more','footnote',''),(103,'availability_completion','version','2015111600'),(104,'availability_date','version','2015111600'),(105,'availability_grade','version','2015111600'),(106,'availability_group','version','2015111600'),(107,'availability_grouping','version','2015111600'),(108,'availability_profile','version','2015111600'),(109,'qtype_calculated','version','2015111600'),(110,'qtype_calculatedmulti','version','2015111600'),(111,'qtype_calculatedsimple','version','2015111600'),(112,'qtype_ddimageortext','version','2015111600'),(113,'qtype_ddmarker','version','2015111600'),(114,'qtype_ddwtos','version','2015111600'),(115,'qtype_description','version','2015111600'),(116,'qtype_essay','version','2015111600'),(117,'qtype_gapselect','version','2015111600'),(118,'qtype_match','version','2015111600'),(119,'qtype_missingtype','version','2015111600'),(120,'qtype_multianswer','version','2015111600'),(121,'qtype_multichoice','version','2015111600'),(122,'qtype_numerical','version','2015111600'),(123,'qtype_random','version','2015111600'),(124,'qtype_randomsamatch','version','2015111600'),(125,'qtype_shortanswer','version','2015111600'),(126,'qtype_truefalse','version','2015111600'),(127,'mod_assign','version','2015111600'),(128,'mod_assignment','version','2015111600'),(130,'mod_book','version','2015111600'),(131,'mod_chat','version','2015111600'),(132,'mod_choice','version','2015111600'),(133,'mod_data','version','2015111600'),(134,'mod_feedback','version','2015111600'),(136,'mod_folder','version','2015111600'),(138,'mod_forum','version','2015111600'),(139,'mod_glossary','version','2015111600'),(140,'mod_imscp','version','2015111600'),(142,'mod_label','version','2015111600'),(143,'mod_lesson','version','2015111600'),(144,'mod_lti','version','2015111600'),(145,'mod_page','version','2015111600'),(147,'mod_quiz','version','2015111601'),(148,'mod_resource','version','2015111600'),(149,'mod_scorm','version','2015111601'),(150,'mod_survey','version','2015111600'),(152,'mod_url','version','2015111600'),(154,'mod_wiki','version','2015111600'),(156,'mod_workshop','version','2015111600'),(157,'auth_cas','version','2015111600'),(159,'auth_db','version','2015111600'),(161,'auth_email','version','2015111600'),(162,'auth_fc','version','2015111600'),(164,'auth_imap','version','2015111600'),(166,'auth_ldap','version','2015111600'),(168,'auth_manual','version','2015111600'),(169,'auth_mnet','version','2015111600'),(171,'auth_nntp','version','2015111600'),(173,'auth_nologin','version','2015111600'),(174,'auth_none','version','2015111600'),(175,'auth_pam','version','2015111600'),(177,'auth_pop3','version','2015111600'),(179,'auth_radius','version','2015111600'),(181,'auth_shibboleth','version','2015111600'),(183,'auth_webservice','version','2015111600'),(184,'calendartype_gregorian','version','2015111600'),(185,'enrol_category','version','2015111600'),(187,'enrol_cohort','version','2015111600'),(188,'enrol_database','version','2015111600'),(190,'enrol_flatfile','version','2015111600'),(192,'enrol_flatfile','map_1','manager'),(193,'enrol_flatfile','map_2','coursecreator'),(194,'enrol_flatfile','map_3','editingteacher'),(195,'enrol_flatfile','map_4','teacher'),(196,'enrol_flatfile','map_5','student'),(197,'enrol_flatfile','map_6','guest'),(198,'enrol_flatfile','map_7','user'),(199,'enrol_flatfile','map_8','frontpage'),(200,'enrol_guest','version','2015111600'),(201,'enrol_imsenterprise','version','2015111600'),(203,'enrol_ldap','version','2015111600'),(205,'enrol_manual','version','2015111600'),(207,'enrol_meta','version','2015111600'),(209,'enrol_mnet','version','2015111600'),(210,'enrol_paypal','version','2015111600'),(211,'enrol_self','version','2015111600'),(213,'message_airnotifier','version','2015111600'),(215,'message','airnotifier_provider_enrol_flatfile_flatfile_enrolment_permitted','permitted'),(216,'message','airnotifier_provider_enrol_imsenterprise_imsenterprise_enrolment_permitted','permitted'),(217,'message','airnotifier_provider_enrol_manual_expiry_notification_permitted','permitted'),(218,'message','airnotifier_provider_enrol_paypal_paypal_enrolment_permitted','permitted'),(219,'message','airnotifier_provider_enrol_self_expiry_notification_permitted','permitted'),(220,'message','airnotifier_provider_mod_assign_assign_notification_permitted','permitted'),(221,'message','airnotifier_provider_mod_assignment_assignment_updates_permitted','permitted'),(222,'message','airnotifier_provider_mod_feedback_submission_permitted','permitted'),(223,'message','airnotifier_provider_mod_feedback_message_permitted','permitted'),(224,'message','airnotifier_provider_mod_forum_posts_permitted','permitted'),(225,'message','airnotifier_provider_mod_lesson_graded_essay_permitted','permitted'),(226,'message','airnotifier_provider_mod_quiz_submission_permitted','permitted'),(227,'message','airnotifier_provider_mod_quiz_confirmation_permitted','permitted'),(228,'message','airnotifier_provider_mod_quiz_attempt_overdue_permitted','permitted'),(229,'message','airnotifier_provider_moodle_notices_permitted','permitted'),(230,'message','airnotifier_provider_moodle_errors_permitted','permitted'),(231,'message','airnotifier_provider_moodle_availableupdate_permitted','permitted'),(232,'message','airnotifier_provider_moodle_instantmessage_permitted','permitted'),(233,'message','airnotifier_provider_moodle_backup_permitted','permitted'),(234,'message','airnotifier_provider_moodle_courserequested_permitted','permitted'),(235,'message','airnotifier_provider_moodle_courserequestapproved_permitted','permitted'),(236,'message','airnotifier_provider_moodle_courserequestrejected_permitted','permitted'),(237,'message','airnotifier_provider_moodle_badgerecipientnotice_permitted','permitted'),(238,'message','airnotifier_provider_moodle_badgecreatornotice_permitted','permitted'),(239,'message_email','version','2015111600'),(241,'message','email_provider_enrol_flatfile_flatfile_enrolment_permitted','permitted'),(242,'message','message_provider_enrol_flatfile_flatfile_enrolment_loggedin','email'),(243,'message','message_provider_enrol_flatfile_flatfile_enrolment_loggedoff','email'),(244,'message','email_provider_enrol_imsenterprise_imsenterprise_enrolment_permitted','permitted'),(245,'message','message_provider_enrol_imsenterprise_imsenterprise_enrolment_loggedin','email'),(246,'message','message_provider_enrol_imsenterprise_imsenterprise_enrolment_loggedoff','email'),(247,'message','email_provider_enrol_manual_expiry_notification_permitted','permitted'),(248,'message','message_provider_enrol_manual_expiry_notification_loggedin','email'),(249,'message','message_provider_enrol_manual_expiry_notification_loggedoff','email'),(250,'message','email_provider_enrol_paypal_paypal_enrolment_permitted','permitted'),(251,'message','message_provider_enrol_paypal_paypal_enrolment_loggedin','email'),(252,'message','message_provider_enrol_paypal_paypal_enrolment_loggedoff','email'),(253,'message','email_provider_enrol_self_expiry_notification_permitted','permitted'),(254,'message','message_provider_enrol_self_expiry_notification_loggedin','email'),(255,'message','message_provider_enrol_self_expiry_notification_loggedoff','email'),(256,'message','email_provider_mod_assign_assign_notification_permitted','permitted'),(257,'message','message_provider_mod_assign_assign_notification_loggedin','email'),(258,'message','message_provider_mod_assign_assign_notification_loggedoff','email'),(259,'message','email_provider_mod_assignment_assignment_updates_permitted','permitted'),(260,'message','message_provider_mod_assignment_assignment_updates_loggedin','email'),(261,'message','message_provider_mod_assignment_assignment_updates_loggedoff','email'),(262,'message','email_provider_mod_feedback_submission_permitted','permitted'),(263,'message','message_provider_mod_feedback_submission_loggedin','email'),(264,'message','message_provider_mod_feedback_submission_loggedoff','email'),(265,'message','email_provider_mod_feedback_message_permitted','permitted'),(266,'message','message_provider_mod_feedback_message_loggedin','email'),(267,'message','message_provider_mod_feedback_message_loggedoff','email'),(268,'message','email_provider_mod_forum_posts_permitted','permitted'),(269,'message','message_provider_mod_forum_posts_loggedin','email'),(270,'message','message_provider_mod_forum_posts_loggedoff','email'),(271,'message','email_provider_mod_lesson_graded_essay_permitted','permitted'),(272,'message','message_provider_mod_lesson_graded_essay_loggedin','email'),(273,'message','message_provider_mod_lesson_graded_essay_loggedoff','email'),(274,'message','email_provider_mod_quiz_submission_permitted','permitted'),(275,'message','message_provider_mod_quiz_submission_loggedin','email'),(276,'message','message_provider_mod_quiz_submission_loggedoff','email'),(277,'message','email_provider_mod_quiz_confirmation_permitted','permitted'),(278,'message','message_provider_mod_quiz_confirmation_loggedin','email'),(279,'message','message_provider_mod_quiz_confirmation_loggedoff','email'),(280,'message','email_provider_mod_quiz_attempt_overdue_permitted','permitted'),(281,'message','message_provider_mod_quiz_attempt_overdue_loggedin','email'),(282,'message','message_provider_mod_quiz_attempt_overdue_loggedoff','email'),(283,'message','email_provider_moodle_notices_permitted','permitted'),(284,'message','message_provider_moodle_notices_loggedin','email'),(285,'message','message_provider_moodle_notices_loggedoff','email'),(286,'message','email_provider_moodle_errors_permitted','permitted'),(287,'message','message_provider_moodle_errors_loggedin','email'),(288,'message','message_provider_moodle_errors_loggedoff','email'),(289,'message','email_provider_moodle_availableupdate_permitted','permitted'),(290,'message','message_provider_moodle_availableupdate_loggedin','email'),(291,'message','message_provider_moodle_availableupdate_loggedoff','email'),(292,'message','email_provider_moodle_instantmessage_permitted','permitted'),(293,'message','message_provider_moodle_instantmessage_loggedoff','popup,email'),(294,'message','email_provider_moodle_backup_permitted','permitted'),(295,'message','message_provider_moodle_backup_loggedin','email'),(296,'message','message_provider_moodle_backup_loggedoff','email'),(297,'message','email_provider_moodle_courserequested_permitted','permitted'),(298,'message','message_provider_moodle_courserequested_loggedin','email'),(299,'message','message_provider_moodle_courserequested_loggedoff','email'),(300,'message','email_provider_moodle_courserequestapproved_permitted','permitted'),(301,'message','message_provider_moodle_courserequestapproved_loggedin','email'),(302,'message','message_provider_moodle_courserequestapproved_loggedoff','email'),(303,'message','email_provider_moodle_courserequestrejected_permitted','permitted'),(304,'message','message_provider_moodle_courserequestrejected_loggedin','email'),(305,'message','message_provider_moodle_courserequestrejected_loggedoff','email'),(306,'message','email_provider_moodle_badgerecipientnotice_permitted','permitted'),(307,'message','message_provider_moodle_badgerecipientnotice_loggedoff','popup,email'),(308,'message','email_provider_moodle_badgecreatornotice_permitted','permitted'),(309,'message','message_provider_moodle_badgecreatornotice_loggedoff','email'),(310,'message_jabber','version','2015111600'),(312,'message','jabber_provider_enrol_flatfile_flatfile_enrolment_permitted','permitted'),(313,'message','jabber_provider_enrol_imsenterprise_imsenterprise_enrolment_permitted','permitted'),(314,'message','jabber_provider_enrol_manual_expiry_notification_permitted','permitted'),(315,'message','jabber_provider_enrol_paypal_paypal_enrolment_permitted','permitted'),(316,'message','jabber_provider_enrol_self_expiry_notification_permitted','permitted'),(317,'message','jabber_provider_mod_assign_assign_notification_permitted','permitted'),(318,'message','jabber_provider_mod_assignment_assignment_updates_permitted','permitted'),(319,'message','jabber_provider_mod_feedback_submission_permitted','permitted'),(320,'message','jabber_provider_mod_feedback_message_permitted','permitted'),(321,'message','jabber_provider_mod_forum_posts_permitted','permitted'),(322,'message','jabber_provider_mod_lesson_graded_essay_permitted','permitted'),(323,'message','jabber_provider_mod_quiz_submission_permitted','permitted'),(324,'message','jabber_provider_mod_quiz_confirmation_permitted','permitted'),(325,'message','jabber_provider_mod_quiz_attempt_overdue_permitted','permitted'),(326,'message','jabber_provider_moodle_notices_permitted','permitted'),(327,'message','jabber_provider_moodle_errors_permitted','permitted'),(328,'message','jabber_provider_moodle_availableupdate_permitted','permitted'),(329,'message','jabber_provider_moodle_instantmessage_permitted','permitted'),(330,'message','jabber_provider_moodle_backup_permitted','permitted'),(331,'message','jabber_provider_moodle_courserequested_permitted','permitted'),(332,'message','jabber_provider_moodle_courserequestapproved_permitted','permitted'),(333,'message','jabber_provider_moodle_courserequestrejected_permitted','permitted'),(334,'message','jabber_provider_moodle_badgerecipientnotice_permitted','permitted'),(335,'message','jabber_provider_moodle_badgecreatornotice_permitted','permitted'),(336,'message_popup','version','2015111600'),(338,'message','popup_provider_enrol_flatfile_flatfile_enrolment_permitted','permitted'),(339,'message','popup_provider_enrol_imsenterprise_imsenterprise_enrolment_permitted','permitted'),(340,'message','popup_provider_enrol_manual_expiry_notification_permitted','permitted'),(341,'message','popup_provider_enrol_paypal_paypal_enrolment_permitted','permitted'),(342,'message','popup_provider_enrol_self_expiry_notification_permitted','permitted'),(343,'message','popup_provider_mod_assign_assign_notification_permitted','permitted'),(344,'message','popup_provider_mod_assignment_assignment_updates_permitted','permitted'),(345,'message','popup_provider_mod_feedback_submission_permitted','permitted'),(346,'message','popup_provider_mod_feedback_message_permitted','permitted'),(347,'message','popup_provider_mod_forum_posts_permitted','permitted'),(348,'message','popup_provider_mod_lesson_graded_essay_permitted','permitted'),(349,'message','popup_provider_mod_quiz_submission_permitted','permitted'),(350,'message','popup_provider_mod_quiz_confirmation_permitted','permitted'),(351,'message','popup_provider_mod_quiz_attempt_overdue_permitted','permitted'),(352,'message','popup_provider_moodle_notices_permitted','permitted'),(353,'message','popup_provider_moodle_errors_permitted','permitted'),(354,'message','popup_provider_moodle_availableupdate_permitted','permitted'),(355,'message','popup_provider_moodle_instantmessage_permitted','permitted'),(356,'message','message_provider_moodle_instantmessage_loggedin','popup'),(357,'message','popup_provider_moodle_backup_permitted','permitted'),(358,'message','popup_provider_moodle_courserequested_permitted','permitted'),(359,'message','popup_provider_moodle_courserequestapproved_permitted','permitted'),(360,'message','popup_provider_moodle_courserequestrejected_permitted','permitted'),(361,'message','popup_provider_moodle_badgerecipientnotice_permitted','permitted'),(362,'message','message_provider_moodle_badgerecipientnotice_loggedin','popup'),(363,'message','popup_provider_moodle_badgecreatornotice_permitted','permitted'),(364,'block_activity_modules','version','2015111600'),(365,'block_activity_results','version','2015111600'),(366,'block_admin_bookmarks','version','2015111600'),(367,'block_badges','version','2015111600'),(368,'block_blog_menu','version','2015111600'),(369,'block_blog_recent','version','2015111600'),(370,'block_blog_tags','version','2015111600'),(371,'block_calendar_month','version','2015111600'),(372,'block_calendar_upcoming','version','2015111600'),(373,'block_comments','version','2015111600'),(374,'block_community','version','2015111600'),(375,'block_completionstatus','version','2015111600'),(376,'block_course_list','version','2015111600'),(377,'block_course_overview','version','2015111600'),(378,'block_course_summary','version','2015111600'),(379,'block_feedback','version','2015111600'),(381,'block_glossary_random','version','2015111600'),(382,'block_html','version','2015111600'),(383,'block_login','version','2015111600'),(384,'block_mentees','version','2015111600'),(385,'block_messages','version','2015111600'),(386,'block_mnet_hosts','version','2015111600'),(387,'block_myprofile','version','2015111600'),(388,'block_navigation','version','2015111600'),(389,'block_news_items','version','2015111600'),(390,'block_online_users','version','2015111600'),(391,'block_participants','version','2015111600'),(392,'block_private_files','version','2015111600'),(393,'block_quiz_results','version','2015111600'),(395,'block_recent_activity','version','2015111600'),(396,'block_rss_client','version','2015111600'),(397,'block_search_forums','version','2015111600'),(398,'block_section_links','version','2015111600'),(399,'block_selfcompletion','version','2015111600'),(400,'block_settings','version','2015111600'),(401,'block_site_main_menu','version','2015111600'),(402,'block_social_activities','version','2015111600'),(403,'block_tag_flickr','version','2015111600'),(404,'block_tag_youtube','version','2015111600'),(406,'block_tags','version','2015111600'),(407,'filter_activitynames','version','2015111600'),(409,'filter_algebra','version','2015111600'),(410,'filter_censor','version','2015111600'),(411,'filter_data','version','2015111600'),(413,'filter_emailprotect','version','2015111600'),(414,'filter_emoticon','version','2015111600'),(415,'filter_glossary','version','2015111600'),(417,'filter_mathjaxloader','version','2015111600'),(419,'filter_mediaplugin','version','2015111600'),(421,'filter_multilang','version','2015111600'),(422,'filter_tex','version','2015111600'),(424,'filter_tidy','version','2015111600'),(425,'filter_urltolink','version','2015111600'),(426,'editor_atto','version','2015111600'),(428,'editor_textarea','version','2015111600'),(429,'editor_tinymce','version','2015111600'),(430,'format_singleactivity','version','2015111600'),(431,'format_social','version','2015111600'),(432,'format_topics','version','2015111600'),(433,'format_weeks','version','2015111600'),(434,'profilefield_checkbox','version','2015111600'),(435,'profilefield_datetime','version','2015111600'),(436,'profilefield_menu','version','2015111600'),(437,'profilefield_text','version','2015111600'),(438,'profilefield_textarea','version','2015111600'),(439,'report_backups','version','2015111600'),(440,'report_completion','version','2015111600'),(442,'report_configlog','version','2015111600'),(443,'report_courseoverview','version','2015111600'),(444,'report_eventlist','version','2015111600'),(445,'report_log','version','2015111600'),(447,'report_loglive','version','2015111600'),(448,'report_outline','version','2015111600'),(450,'report_participation','version','2015111600'),(452,'report_performance','version','2015111600'),(453,'report_progress','version','2015111600'),(455,'report_questioninstances','version','2015111600'),(456,'report_security','version','2015111600'),(457,'report_stats','version','2015111600'),(459,'report_usersessions','version','2015111600'),(460,'gradeexport_ods','version','2015111600'),(461,'gradeexport_txt','version','2015111600'),(462,'gradeexport_xls','version','2015111600'),(463,'gradeexport_xml','version','2015111600'),(464,'gradeimport_csv','version','2015111600'),(465,'gradeimport_direct','version','2015111600'),(466,'gradeimport_xml','version','2015111600'),(467,'gradereport_grader','version','2015111600'),(468,'gradereport_history','version','2015111600'),(469,'gradereport_outcomes','version','2015111600'),(470,'gradereport_overview','version','2015111600'),(471,'gradereport_singleview','version','2015111600'),(472,'gradereport_user','version','2015111600'),(473,'gradingform_guide','version','2015111600'),(474,'gradingform_rubric','version','2015111600'),(475,'mnetservice_enrol','version','2015111600'),(476,'webservice_amf','version','2015111600'),(477,'webservice_rest','version','2015111600'),(478,'webservice_soap','version','2015111600'),(479,'webservice_xmlrpc','version','2015111600'),(480,'repository_alfresco','version','2015111600'),(481,'repository_areafiles','version','2015111600'),(483,'areafiles','enablecourseinstances','0'),(484,'areafiles','enableuserinstances','0'),(485,'repository_boxnet','version','2015111600'),(486,'repository_coursefiles','version','2015111600'),(487,'repository_dropbox','version','2015111600'),(488,'repository_equella','version','2015111600'),(489,'repository_filesystem','version','2015111600'),(490,'repository_flickr','version','2015111600'),(491,'repository_flickr_public','version','2015111600'),(492,'repository_googledocs','version','2015111600'),(493,'repository_local','version','2015111600'),(495,'local','enablecourseinstances','0'),(496,'local','enableuserinstances','0'),(497,'repository_merlot','version','2015111600'),(498,'repository_picasa','version','2015111600'),(499,'repository_recent','version','2015111600'),(501,'recent','enablecourseinstances','0'),(502,'recent','enableuserinstances','0'),(503,'repository_s3','version','2015111600'),(504,'repository_skydrive','version','2015111600'),(505,'repository_upload','version','2015111600'),(507,'upload','enablecourseinstances','0'),(508,'upload','enableuserinstances','0'),(509,'repository_url','version','2015111600'),(511,'url','enablecourseinstances','0'),(512,'url','enableuserinstances','0'),(513,'repository_user','version','2015111600'),(515,'user','enablecourseinstances','0'),(516,'user','enableuserinstances','0'),(517,'repository_webdav','version','2015111600'),(518,'repository_wikimedia','version','2015111600'),(520,'wikimedia','enablecourseinstances','0'),(521,'wikimedia','enableuserinstances','0'),(522,'repository_youtube','version','2015111600'),(524,'portfolio_boxnet','version','2015111600'),(525,'portfolio_download','version','2015111600'),(526,'portfolio_flickr','version','2015111600'),(527,'portfolio_googledocs','version','2015111600'),(528,'portfolio_mahara','version','2015111600'),(529,'portfolio_picasa','version','2015111600'),(530,'qbehaviour_adaptive','version','2015111600'),(531,'qbehaviour_adaptivenopenalty','version','2015111600'),(532,'qbehaviour_deferredcbm','version','2015111600'),(533,'qbehaviour_deferredfeedback','version','2015111600'),(534,'qbehaviour_immediatecbm','version','2015111600'),(535,'qbehaviour_immediatefeedback','version','2015111600'),(536,'qbehaviour_informationitem','version','2015111600'),(537,'qbehaviour_interactive','version','2015111600'),(538,'qbehaviour_interactivecountback','version','2015111600'),(539,'qbehaviour_manualgraded','version','2015111600'),(541,'question','disabledbehaviours','manualgraded'),(542,'qbehaviour_missing','version','2015111600'),(543,'qformat_aiken','version','2015111600'),(544,'qformat_blackboard_six','version','2015111600'),(545,'qformat_examview','version','2015111600'),(546,'qformat_gift','version','2015111600'),(547,'qformat_missingword','version','2015111600'),(548,'qformat_multianswer','version','2015111600'),(549,'qformat_webct','version','2015111600'),(550,'qformat_xhtml','version','2015111600'),(551,'qformat_xml','version','2015111600'),(552,'tool_assignmentupgrade','version','2015111600'),(553,'tool_availabilityconditions','version','2015111600'),(554,'tool_behat','version','2015111600'),(555,'tool_capability','version','2015111600'),(556,'tool_customlang','version','2015111600'),(558,'tool_dbtransfer','version','2015111600'),(559,'tool_filetypes','version','2015111600'),(560,'tool_generator','version','2015111600'),(561,'tool_health','version','2015111600'),(562,'tool_innodb','version','2015111600'),(563,'tool_installaddon','version','2015111600'),(564,'tool_langimport','version','2015111600'),(565,'tool_log','version','2015111600'),(567,'tool_log','enabled_stores','logstore_standard'),(568,'tool_messageinbound','version','2015111600'),(569,'message','airnotifier_provider_tool_messageinbound_invalidrecipienthandler_permitted','permitted'),(570,'message','email_provider_tool_messageinbound_invalidrecipienthandler_permitted','permitted'),(571,'message','jabber_provider_tool_messageinbound_invalidrecipienthandler_permitted','permitted'),(572,'message','popup_provider_tool_messageinbound_invalidrecipienthandler_permitted','permitted'),(573,'message','message_provider_tool_messageinbound_invalidrecipienthandler_loggedin','email'),(574,'message','message_provider_tool_messageinbound_invalidrecipienthandler_loggedoff','email'),(575,'message','airnotifier_provider_tool_messageinbound_messageprocessingerror_permitted','permitted'),(576,'message','email_provider_tool_messageinbound_messageprocessingerror_permitted','permitted'),(577,'message','jabber_provider_tool_messageinbound_messageprocessingerror_permitted','permitted'),(578,'message','popup_provider_tool_messageinbound_messageprocessingerror_permitted','permitted'),(579,'message','message_provider_tool_messageinbound_messageprocessingerror_loggedin','email'),(580,'message','message_provider_tool_messageinbound_messageprocessingerror_loggedoff','email'),(581,'message','airnotifier_provider_tool_messageinbound_messageprocessingsuccess_permitted','permitted'),(582,'message','email_provider_tool_messageinbound_messageprocessingsuccess_permitted','permitted'),(583,'message','jabber_provider_tool_messageinbound_messageprocessingsuccess_permitted','permitted'),(584,'message','popup_provider_tool_messageinbound_messageprocessingsuccess_permitted','permitted'),(585,'message','message_provider_tool_messageinbound_messageprocessingsuccess_loggedin','email'),(586,'message','message_provider_tool_messageinbound_messageprocessingsuccess_loggedoff','email'),(587,'tool_monitor','version','2015111600'),(588,'message','airnotifier_provider_tool_monitor_notification_permitted','permitted'),(589,'message','email_provider_tool_monitor_notification_permitted','permitted'),(590,'message','jabber_provider_tool_monitor_notification_permitted','permitted'),(591,'message','popup_provider_tool_monitor_notification_permitted','permitted'),(592,'message','message_provider_tool_monitor_notification_loggedin','email'),(593,'message','message_provider_tool_monitor_notification_loggedoff','email'),(594,'tool_multilangupgrade','version','2015111600'),(595,'tool_phpunit','version','2015111600'),(596,'tool_profiling','version','2015111600'),(597,'tool_replace','version','2015111600'),(598,'tool_spamcleaner','version','2015111600'),(599,'tool_task','version','2015111600'),(600,'tool_templatelibrary','version','2015111600'),(601,'tool_unsuproles','version','2015111600'),(603,'tool_uploadcourse','version','2015111600'),(604,'tool_uploaduser','version','2015111600'),(605,'tool_xmldb','version','2015111600'),(606,'cachestore_file','version','2015111600'),(607,'cachestore_memcache','version','2015111600'),(608,'cachestore_memcached','version','2015111600'),(609,'cachestore_mongodb','version','2015111600'),(610,'cachestore_session','version','2015111600'),(611,'cachestore_static','version','2015111600'),(612,'cachelock_file','version','2015111600'),(613,'theme_base','version','2015111600'),(614,'theme_bootstrapbase','version','2015111600'),(615,'theme_canvas','version','2015111600'),(616,'theme_clean','version','2015111600'),(617,'theme_more','version','2015111600'),(619,'assignsubmission_comments','version','2015111600'),(621,'assignsubmission_file','sortorder','1'),(622,'assignsubmission_comments','sortorder','2'),(623,'assignsubmission_onlinetext','sortorder','0'),(624,'assignsubmission_file','version','2015111600'),(625,'assignsubmission_onlinetext','version','2015111600'),(627,'assignfeedback_comments','version','2015111600'),(629,'assignfeedback_comments','sortorder','0'),(630,'assignfeedback_editpdf','sortorder','1'),(631,'assignfeedback_file','sortorder','3'),(632,'assignfeedback_offline','sortorder','2'),(633,'assignfeedback_editpdf','version','2015111600'),(635,'assignfeedback_file','version','2015111600'),(637,'assignfeedback_offline','version','2015111600'),(638,'assignment_offline','version','2015111600'),(639,'assignment_online','version','2015111600'),(640,'assignment_upload','version','2015111600'),(641,'assignment_uploadsingle','version','2015111600'),(642,'booktool_exportimscp','version','2015111600'),(643,'booktool_importhtml','version','2015111600'),(644,'booktool_print','version','2015111600'),(645,'datafield_checkbox','version','2015111600'),(646,'datafield_date','version','2015111600'),(647,'datafield_file','version','2015111600'),(648,'datafield_latlong','version','2015111600'),(649,'datafield_menu','version','2015111600'),(650,'datafield_multimenu','version','2015111600'),(651,'datafield_number','version','2015111600'),(652,'datafield_picture','version','2015111600'),(653,'datafield_radiobutton','version','2015111600'),(654,'datafield_text','version','2015111600'),(655,'datafield_textarea','version','2015111600'),(656,'datafield_url','version','2015111600'),(657,'datapreset_imagegallery','version','2015111600'),(658,'ltiservice_memberships','version','2015111600'),(659,'ltiservice_profile','version','2015111600'),(660,'ltiservice_toolproxy','version','2015111600'),(661,'ltiservice_toolsettings','version','2015111601'),(662,'quiz_grading','version','2015111600'),(664,'quiz_overview','version','2015111600'),(666,'quiz_responses','version','2015111600'),(668,'quiz_statistics','version','2015111600'),(670,'quizaccess_delaybetweenattempts','version','2015111600'),(671,'quizaccess_ipaddress','version','2015111600'),(672,'quizaccess_numattempts','version','2015111600'),(673,'quizaccess_openclosedate','version','2015111600'),(674,'quizaccess_password','version','2015111600'),(675,'quizaccess_safebrowser','version','2015111600'),(676,'quizaccess_securewindow','version','2015111600'),(677,'quizaccess_timelimit','version','2015111600'),(678,'scormreport_basic','version','2015111600'),(679,'scormreport_graphs','version','2015111600'),(680,'scormreport_interactions','version','2015111600'),(681,'scormreport_objectives','version','2015111600'),(682,'workshopform_accumulative','version','2015111600'),(684,'workshopform_comments','version','2015111600'),(686,'workshopform_numerrors','version','2015111600'),(688,'workshopform_rubric','version','2015111600'),(690,'workshopallocation_manual','version','2015111600'),(691,'workshopallocation_random','version','2015111600'),(692,'workshopallocation_scheduled','version','2015111600'),(693,'workshopeval_best','version','2015111600'),(694,'atto_accessibilitychecker','version','2015111600'),(695,'atto_accessibilityhelper','version','2015111600'),(696,'atto_align','version','2015111600'),(697,'atto_backcolor','version','2015111600'),(698,'atto_bold','version','2015111600'),(699,'atto_charmap','version','2015111600'),(700,'atto_clear','version','2015111600'),(701,'atto_collapse','version','2015111600'),(702,'atto_emoticon','version','2015111600'),(703,'atto_equation','version','2015111600'),(704,'atto_fontcolor','version','2015111600'),(705,'atto_html','version','2015111600'),(706,'atto_image','version','2015111600'),(707,'atto_indent','version','2015111600'),(708,'atto_italic','version','2015111600'),(709,'atto_link','version','2015111600'),(710,'atto_managefiles','version','2015111600'),(711,'atto_media','version','2015111600'),(712,'atto_noautolink','version','2015111600'),(713,'atto_orderedlist','version','2015111600'),(714,'atto_rtl','version','2015111600'),(715,'atto_strike','version','2015111600'),(716,'atto_subscript','version','2015111600'),(717,'atto_superscript','version','2015111600'),(718,'atto_table','version','2015111600'),(719,'atto_title','version','2015111600'),(720,'atto_underline','version','2015111600'),(721,'atto_undo','version','2015111600'),(722,'atto_unorderedlist','version','2015111600'),(723,'tinymce_ctrlhelp','version','2015111600'),(724,'tinymce_managefiles','version','2015111600'),(725,'tinymce_moodleemoticon','version','2015111600'),(726,'tinymce_moodleimage','version','2015111600'),(727,'tinymce_moodlemedia','version','2015111600'),(728,'tinymce_moodlenolink','version','2015111600'),(729,'tinymce_pdw','version','2015111600'),(730,'tinymce_spellchecker','version','2015111600'),(732,'tinymce_wrap','version','2015111600'),(733,'logstore_database','version','2015111600'),(734,'logstore_legacy','version','2015111600'),(735,'logstore_standard','version','2015111601'),(736,'assign','feedback_plugin_for_gradebook','assignfeedback_comments'),(737,'assign','showrecentsubmissions','0'),(738,'assign','submissionreceipts','1'),(739,'assign','submissionstatement','This assignment is my own work, except where I have acknowledged the use of the works of other people.'),(740,'assign','alwaysshowdescription','1'),(741,'assign','alwaysshowdescription_adv',''),(742,'assign','alwaysshowdescription_locked',''),(743,'assign','allowsubmissionsfromdate','0'),(744,'assign','allowsubmissionsfromdate_enabled','1'),(745,'assign','allowsubmissionsfromdate_adv',''),(746,'assign','duedate','604800'),(747,'assign','duedate_enabled','1'),(748,'assign','duedate_adv',''),(749,'assign','cutoffdate','1209600'),(750,'assign','cutoffdate_enabled',''),(751,'assign','cutoffdate_adv',''),(752,'assign','submissiondrafts','0'),(753,'assign','submissiondrafts_adv',''),(754,'assign','submissiondrafts_locked',''),(755,'assign','requiresubmissionstatement','0'),(756,'assign','requiresubmissionstatement_adv',''),(757,'assign','requiresubmissionstatement_locked',''),(758,'assign','attemptreopenmethod','none'),(759,'assign','attemptreopenmethod_adv',''),(760,'assign','attemptreopenmethod_locked',''),(761,'assign','maxattempts','-1'),(762,'assign','maxattempts_adv',''),(763,'assign','maxattempts_locked',''),(764,'assign','teamsubmission','0'),(765,'assign','teamsubmission_adv',''),(766,'assign','teamsubmission_locked',''),(767,'assign','preventsubmissionnotingroup','0'),(768,'assign','preventsubmissionnotingroup_adv',''),(769,'assign','preventsubmissionnotingroup_locked',''),(770,'assign','requireallteammemberssubmit','0'),(771,'assign','requireallteammemberssubmit_adv',''),(772,'assign','requireallteammemberssubmit_locked',''),(773,'assign','teamsubmissiongroupingid',''),(774,'assign','teamsubmissiongroupingid_adv',''),(775,'assign','sendnotifications','0'),(776,'assign','sendnotifications_adv',''),(777,'assign','sendnotifications_locked',''),(778,'assign','sendlatenotifications','0'),(779,'assign','sendlatenotifications_adv',''),(780,'assign','sendlatenotifications_locked',''),(781,'assign','sendstudentnotifications','1'),(782,'assign','sendstudentnotifications_adv',''),(783,'assign','sendstudentnotifications_locked',''),(784,'assign','blindmarking','0'),(785,'assign','blindmarking_adv',''),(786,'assign','blindmarking_locked',''),(787,'assign','markingworkflow','0'),(788,'assign','markingworkflow_adv',''),(789,'assign','markingworkflow_locked',''),(790,'assign','markingallocation','0'),(791,'assign','markingallocation_adv',''),(792,'assign','markingallocation_locked',''),(793,'assignsubmission_file','default','1'),(794,'assignsubmission_file','maxfiles','20'),(795,'assignsubmission_file','maxbytes','1048576'),(796,'assignsubmission_onlinetext','default','0'),(797,'assignfeedback_comments','default','1'),(798,'assignfeedback_comments','inline','0'),(799,'assignfeedback_comments','inline_adv',''),(800,'assignfeedback_comments','inline_locked',''),(801,'assignfeedback_editpdf','stamps',''),(802,'assignfeedback_file','default','0'),(803,'assignfeedback_offline','default','0'),(804,'book','numberingoptions','0,1,2,3'),(805,'book','navoptions','0,1,2'),(806,'book','numbering','1'),(807,'book','navstyle','1'),(808,'folder','showexpanded','1'),(809,'imscp','keepold','1'),(810,'imscp','keepold_adv',''),(811,'label','dndmedia','1'),(812,'label','dndresizewidth','400'),(813,'label','dndresizeheight','400'),(814,'page','displayoptions','5'),(815,'page','printheading','1'),(816,'page','printintro','0'),(817,'page','display','5'),(818,'page','popupwidth','620'),(819,'page','popupheight','450'),(820,'quiz','timelimit','0'),(821,'quiz','timelimit_adv',''),(822,'quiz','overduehandling','autosubmit'),(823,'quiz','overduehandling_adv',''),(824,'quiz','graceperiod','86400'),(825,'quiz','graceperiod_adv',''),(826,'quiz','graceperiodmin','60'),(827,'quiz','attempts','0'),(828,'quiz','attempts_adv',''),(829,'quiz','grademethod','1'),(830,'quiz','grademethod_adv',''),(831,'quiz','maximumgrade','10'),(832,'quiz','questionsperpage','1'),(833,'quiz','questionsperpage_adv',''),(834,'quiz','navmethod','free'),(835,'quiz','navmethod_adv','1'),(836,'quiz','shuffleanswers','1'),(837,'quiz','shuffleanswers_adv',''),(838,'quiz','preferredbehaviour','deferredfeedback'),(839,'quiz','canredoquestions','0'),(840,'quiz','canredoquestions_adv','1'),(841,'quiz','attemptonlast','0'),(842,'quiz','attemptonlast_adv','1'),(843,'quiz','reviewattempt','69904'),(844,'quiz','reviewcorrectness','69904'),(845,'quiz','reviewmarks','69904'),(846,'quiz','reviewspecificfeedback','69904'),(847,'quiz','reviewgeneralfeedback','69904'),(848,'quiz','reviewrightanswer','69904'),(849,'quiz','reviewoverallfeedback','4368'),(850,'quiz','showuserpicture','0'),(851,'quiz','showuserpicture_adv',''),(852,'quiz','decimalpoints','2'),(853,'quiz','decimalpoints_adv',''),(854,'quiz','questiondecimalpoints','-1'),(855,'quiz','questiondecimalpoints_adv','1'),(856,'quiz','showblocks','0'),(857,'quiz','showblocks_adv','1'),(858,'quiz','password',''),(859,'quiz','password_adv',''),(860,'quiz','subnet',''),(861,'quiz','subnet_adv','1'),(862,'quiz','delay1','0'),(863,'quiz','delay1_adv','1'),(864,'quiz','delay2','0'),(865,'quiz','delay2_adv','1'),(866,'quiz','browsersecurity','-'),(867,'quiz','browsersecurity_adv','1'),(868,'quiz','initialnumfeedbacks','2'),(869,'quiz','autosaveperiod','60'),(870,'resource','framesize','130'),(871,'resource','displayoptions','0,1,4,5,6'),(872,'resource','printintro','1'),(873,'resource','display','0'),(874,'resource','showsize','0'),(875,'resource','showtype','0'),(876,'resource','showdate','0'),(877,'resource','popupwidth','620'),(878,'resource','popupheight','450'),(879,'resource','filterfiles','0'),(880,'scorm','displaycoursestructure','0'),(881,'scorm','displaycoursestructure_adv',''),(882,'scorm','popup','0'),(883,'scorm','popup_adv',''),(884,'scorm','displayactivityname','1'),(885,'scorm','framewidth','100'),(886,'scorm','framewidth_adv','1'),(887,'scorm','frameheight','500'),(888,'scorm','frameheight_adv','1'),(889,'scorm','winoptgrp_adv','1'),(890,'scorm','scrollbars','0'),(891,'scorm','directories','0'),(892,'scorm','location','0'),(893,'scorm','menubar','0'),(894,'scorm','toolbar','0'),(895,'scorm','status','0'),(896,'scorm','skipview','0'),(897,'scorm','skipview_adv','1'),(898,'scorm','hidebrowse','0'),(899,'scorm','hidebrowse_adv','1'),(900,'scorm','hidetoc','0'),(901,'scorm','hidetoc_adv','1'),(902,'scorm','nav','1'),(903,'scorm','nav_adv','1'),(904,'scorm','navpositionleft','-100'),(905,'scorm','navpositionleft_adv','1'),(906,'scorm','navpositiontop','-100'),(907,'scorm','navpositiontop_adv','1'),(908,'scorm','collapsetocwinsize','767'),(909,'scorm','collapsetocwinsize_adv','1'),(910,'scorm','displayattemptstatus','1'),(911,'scorm','displayattemptstatus_adv',''),(912,'scorm','grademethod','1'),(913,'scorm','maxgrade','100'),(914,'scorm','maxattempt','0'),(915,'scorm','whatgrade','0'),(916,'scorm','forcecompleted','0'),(917,'scorm','forcenewattempt','0'),(918,'scorm','autocommit','0'),(919,'scorm','lastattemptlock','0'),(920,'scorm','auto','0'),(921,'scorm','updatefreq','0'),(922,'scorm','scorm12standard','0'),(923,'scorm','allowtypeexternal','0'),(924,'scorm','allowtypelocalsync','0'),(925,'scorm','allowtypeexternalaicc','0'),(926,'scorm','allowaicchacp','0'),(927,'scorm','aicchacptimeout','30'),(928,'scorm','aicchacpkeepsessiondata','1'),(929,'scorm','aiccuserid','1'),(930,'scorm','forcejavascript','1'),(931,'scorm','allowapidebug','0'),(932,'scorm','apidebugmask','.*'),(933,'scorm','protectpackagedownloads','0'),(934,'url','framesize','130'),(935,'url','secretphrase',''),(936,'url','rolesinparams','0'),(937,'url','displayoptions','0,1,5,6'),(938,'url','printintro','1'),(939,'url','display','0'),(940,'url','popupwidth','620'),(941,'url','popupheight','450'),(942,'workshop','grade','80'),(943,'workshop','gradinggrade','20'),(944,'workshop','gradedecimals','0'),(945,'workshop','maxbytes','0'),(946,'workshop','strategy','accumulative'),(947,'workshop','examplesmode','0'),(948,'workshopallocation_random','numofreviews','5'),(949,'workshopform_numerrors','grade0','No'),(950,'workshopform_numerrors','grade1','Yes'),(951,'workshopeval_best','comparison','5'),(952,'block_course_overview','defaultmaxcourses','10'),(953,'block_course_overview','forcedefaultmaxcourses','0'),(954,'block_course_overview','showchildren','0'),(955,'block_course_overview','showwelcomearea','0'),(956,'block_course_overview','showcategories','0'),(957,'block_section_links','numsections1','22'),(958,'block_section_links','incby1','2'),(959,'block_section_links','numsections2','40'),(960,'block_section_links','incby2','5'),(961,'block_tag_youtube','apikey',''),(962,'format_singleactivity','activitytype','forum'),(963,'enrol_cohort','roleid','5'),(964,'enrol_cohort','unenrolaction','0'),(965,'enrol_database','dbtype',''),(966,'enrol_database','dbhost','localhost'),(967,'enrol_database','dbuser',''),(968,'enrol_database','dbpass',''),(969,'enrol_database','dbname',''),(970,'enrol_database','dbencoding','utf-8'),(971,'enrol_database','dbsetupsql',''),(972,'enrol_database','dbsybasequoting','0'),(973,'enrol_database','debugdb','0'),(974,'enrol_database','localcoursefield','idnumber'),(975,'enrol_database','localuserfield','idnumber'),(976,'enrol_database','localrolefield','shortname'),(977,'enrol_database','localcategoryfield','id'),(978,'enrol_database','remoteenroltable',''),(979,'enrol_database','remotecoursefield',''),(980,'enrol_database','remoteuserfield',''),(981,'enrol_database','remoterolefield',''),(982,'enrol_database','remoteotheruserfield',''),(983,'enrol_database','defaultrole','5'),(984,'enrol_database','ignorehiddencourses','0'),(985,'enrol_database','unenrolaction','0'),(986,'enrol_database','newcoursetable',''),(987,'enrol_database','newcoursefullname','fullname'),(988,'enrol_database','newcourseshortname','shortname'),(989,'enrol_database','newcourseidnumber','idnumber'),(990,'enrol_database','newcoursecategory',''),(991,'enrol_database','defaultcategory','1'),(992,'enrol_database','templatecourse',''),(993,'enrol_flatfile','location',''),(994,'enrol_flatfile','encoding','UTF-8'),(995,'enrol_flatfile','mailstudents','0'),(996,'enrol_flatfile','mailteachers','0'),(997,'enrol_flatfile','mailadmins','0'),(998,'enrol_flatfile','unenrolaction','3'),(999,'enrol_flatfile','expiredaction','3'),(1000,'enrol_guest','requirepassword','0'),(1001,'enrol_guest','usepasswordpolicy','0'),(1002,'enrol_guest','showhint','0'),(1003,'enrol_guest','defaultenrol','1'),(1004,'enrol_guest','status','1'),(1005,'enrol_guest','status_adv',''),(1006,'enrol_imsenterprise','imsfilelocation',''),(1007,'enrol_imsenterprise','logtolocation',''),(1008,'enrol_imsenterprise','mailadmins','0'),(1009,'enrol_imsenterprise','createnewusers','0'),(1010,'enrol_imsenterprise','imsdeleteusers','0'),(1011,'enrol_imsenterprise','fixcaseusernames','0'),(1012,'enrol_imsenterprise','fixcasepersonalnames','0'),(1013,'enrol_imsenterprise','imssourcedidfallback','0'),(1014,'enrol_imsenterprise','imsrolemap01','5'),(1015,'enrol_imsenterprise','imsrolemap02','3'),(1016,'enrol_imsenterprise','imsrolemap03','3'),(1017,'enrol_imsenterprise','imsrolemap04','5'),(1018,'enrol_imsenterprise','imsrolemap05','0'),(1019,'enrol_imsenterprise','imsrolemap06','4'),(1020,'enrol_imsenterprise','imsrolemap07','0'),(1021,'enrol_imsenterprise','imsrolemap08','4'),(1022,'enrol_imsenterprise','truncatecoursecodes','0'),(1023,'enrol_imsenterprise','createnewcourses','0'),(1024,'enrol_imsenterprise','createnewcategories','0'),(1025,'enrol_imsenterprise','imsunenrol','0'),(1026,'enrol_imsenterprise','imscoursemapshortname','coursecode'),(1027,'enrol_imsenterprise','imscoursemapfullname','short'),(1028,'enrol_imsenterprise','imscoursemapsummary','ignore'),(1029,'enrol_imsenterprise','imsrestricttarget',''),(1030,'enrol_imsenterprise','imscapitafix','0'),(1031,'enrol_manual','expiredaction','1'),(1032,'enrol_manual','expirynotifyhour','6'),(1033,'enrol_manual','defaultenrol','1'),(1034,'enrol_manual','status','0'),(1035,'enrol_manual','roleid','5'),(1036,'enrol_manual','enrolstart','4'),(1037,'enrol_manual','enrolperiod','0'),(1038,'enrol_manual','expirynotify','0'),(1039,'enrol_manual','expirythreshold','86400'),(1040,'enrol_meta','nosyncroleids',''),(1041,'enrol_meta','syncall','1'),(1042,'enrol_meta','unenrolaction','3'),(1043,'enrol_meta','coursesort','sortorder'),(1044,'enrol_mnet','roleid','5'),(1045,'enrol_mnet','roleid_adv','1'),(1046,'enrol_paypal','paypalbusiness',''),(1047,'enrol_paypal','mailstudents','0'),(1048,'enrol_paypal','mailteachers','0'),(1049,'enrol_paypal','mailadmins','0'),(1050,'enrol_paypal','expiredaction','3'),(1051,'enrol_paypal','status','1'),(1052,'enrol_paypal','cost','0'),(1053,'enrol_paypal','currency','USD'),(1054,'enrol_paypal','roleid','5'),(1055,'enrol_paypal','enrolperiod','0'),(1056,'enrol_self','requirepassword','0'),(1057,'enrol_self','usepasswordpolicy','0'),(1058,'enrol_self','showhint','0'),(1059,'enrol_self','expiredaction','1'),(1060,'enrol_self','expirynotifyhour','6'),(1061,'enrol_self','defaultenrol','1'),(1062,'enrol_self','status','1'),(1063,'enrol_self','newenrols','1'),(1064,'enrol_self','groupkey','0'),(1065,'enrol_self','roleid','5'),(1066,'enrol_self','enrolperiod','0'),(1067,'enrol_self','expirynotify','0'),(1068,'enrol_self','expirythreshold','86400'),(1069,'enrol_self','longtimenosee','0'),(1070,'enrol_self','maxenrolled','0'),(1071,'enrol_self','sendcoursewelcomemessage','1'),(1072,'filter_emoticon','formats','1,4,0'),(1073,'filter_mathjaxloader','httpurl','http://cdn.mathjax.org/mathjax/2.5-latest/MathJax.js'),(1074,'filter_mathjaxloader','httpsurl','https://cdn.mathjax.org/mathjax/2.5-latest/MathJax.js'),(1075,'filter_mathjaxloader','texfiltercompatibility','0'),(1076,'filter_mathjaxloader','mathjaxconfig','\nMathJax.Hub.Config({\n    config: [\"Accessible.js\", \"Safe.js\"],\n    errorSettings: { message: [\"!\"] },\n    skipStartupTypeset: true,\n    messageStyle: \"none\"\n});\n'),(1077,'filter_mathjaxloader','additionaldelimiters',''),(1078,'filter_tex','latexpreamble','\\usepackage[latin1]{inputenc}\n\\usepackage{amsmath}\n\\usepackage{amsfonts}\n\\RequirePackage{amsmath,amssymb,latexsym}\n'),(1079,'filter_tex','latexbackground','#FFFFFF'),(1080,'filter_tex','density','120'),(1081,'filter_tex','pathlatex','/usr/bin/latex'),(1082,'filter_tex','pathdvips','/usr/bin/dvips'),(1083,'filter_tex','pathconvert','/usr/bin/convert'),(1084,'filter_tex','pathdvisvgm','/usr/bin/dvisvgm'),(1085,'filter_tex','pathmimetex',''),(1086,'filter_tex','convertformat','gif'),(1087,'filter_urltolink','formats','0'),(1088,'filter_urltolink','embedimages','1'),(1089,'logstore_database','dbdriver',''),(1090,'logstore_database','dbhost',''),(1091,'logstore_database','dbuser',''),(1092,'logstore_database','dbpass',''),(1093,'logstore_database','dbname',''),(1094,'logstore_database','dbtable',''),(1095,'logstore_database','dbpersist','0'),(1096,'logstore_database','dbsocket',''),(1097,'logstore_database','dbport',''),(1098,'logstore_database','dbschema',''),(1099,'logstore_database','dbcollation',''),(1100,'logstore_database','buffersize','50'),(1101,'logstore_database','logguests','0'),(1102,'logstore_database','includelevels','1,2,0'),(1103,'logstore_database','includeactions','c,r,u,d'),(1104,'logstore_legacy','loglegacy','0'),(1105,'logstore_standard','logguests','1'),(1106,'logstore_standard','loglifetime','0'),(1107,'logstore_standard','buffersize','50'),(1108,'editor_atto','toolbar','collapse = collapse\nstyle1 = title, bold, italic\nlist = unorderedlist, orderedlist\nlinks = link\nfiles = image, media, managefiles\nstyle2 = underline, strike, subscript, superscript\nalign = align\nindent = indent\ninsert = equation, charmap, table, clear\nundo = undo\naccessibility = accessibilitychecker, accessibilityhelper\nother = html'),(1109,'editor_atto','autosavefrequency','60'),(1110,'atto_collapse','showgroups','5'),(1111,'atto_equation','librarygroup1','\n\\cdot\n\\times\n\\ast\n\\div\n\\diamond\n\\pm\n\\mp\n\\oplus\n\\ominus\n\\otimes\n\\oslash\n\\odot\n\\circ\n\\bullet\n\\asymp\n\\equiv\n\\subseteq\n\\supseteq\n\\leq\n\\geq\n\\preceq\n\\succeq\n\\sim\n\\simeq\n\\approx\n\\subset\n\\supset\n\\ll\n\\gg\n\\prec\n\\succ\n\\infty\n\\in\n\\ni\n\\forall\n\\exists\n\\neq\n'),(1112,'atto_equation','librarygroup2','\n\\leftarrow\n\\rightarrow\n\\uparrow\n\\downarrow\n\\leftrightarrow\n\\nearrow\n\\searrow\n\\swarrow\n\\nwarrow\n\\Leftarrow\n\\Rightarrow\n\\Uparrow\n\\Downarrow\n\\Leftrightarrow\n'),(1113,'atto_equation','librarygroup3','\n\\alpha\n\\beta\n\\gamma\n\\delta\n\\epsilon\n\\zeta\n\\eta\n\\theta\n\\iota\n\\kappa\n\\lambda\n\\mu\n\\nu\n\\xi\n\\pi\n\\rho\n\\sigma\n\\tau\n\\upsilon\n\\phi\n\\chi\n\\psi\n\\omega\n\\Gamma\n\\Delta\n\\Theta\n\\Lambda\n\\Xi\n\\Pi\n\\Sigma\n\\Upsilon\n\\Phi\n\\Psi\n\\Omega\n'),(1114,'atto_equation','librarygroup4','\n\\sum{a,b}\n\\sqrt[a]{b+c}\n\\int_{a}^{b}{c}\n\\iint_{a}^{b}{c}\n\\iiint_{a}^{b}{c}\n\\oint{a}\n(a)\n[a]\n\\lbrace{a}\\rbrace\n\\left| \\begin{matrix} a_1 & a_2 \\ a_3 & a_4 \\end{matrix} \\right|\n\\frac{a}{b+c}\n\\vec{a}\n\\binom {a} {b}\n{a \\brack b}\n{a \\brace b}\n'),(1115,'atto_table','allowborders','0'),(1116,'atto_table','allowbackgroundcolour','0'),(1117,'atto_table','allowwidth','0'),(1118,'editor_tinymce','customtoolbar','wrap,formatselect,wrap,bold,italic,wrap,bullist,numlist,wrap,link,unlink,wrap,image\n\nundo,redo,wrap,underline,strikethrough,sub,sup,wrap,justifyleft,justifycenter,justifyright,wrap,outdent,indent,wrap,forecolor,backcolor,wrap,ltr,rtl\n\nfontselect,fontsizeselect,wrap,code,search,replace,wrap,nonbreaking,charmap,table,wrap,cleanup,removeformat,pastetext,pasteword,wrap,fullscreen'),(1119,'editor_tinymce','fontselectlist','Trebuchet=Trebuchet MS,Verdana,Arial,Helvetica,sans-serif;Arial=arial,helvetica,sans-serif;Courier New=courier new,courier,monospace;Georgia=georgia,times new roman,times,serif;Tahoma=tahoma,arial,helvetica,sans-serif;Times New Roman=times new roman,times,serif;Verdana=verdana,arial,helvetica,sans-serif;Impact=impact;Wingdings=wingdings'),(1120,'editor_tinymce','customconfig',''),(1121,'tinymce_moodleemoticon','requireemoticon','1'),(1122,'tinymce_spellchecker','spellengine',''),(1123,'tinymce_spellchecker','spelllanguagelist','+English=en,Danish=da,Dutch=nl,Finnish=fi,French=fr,German=de,Italian=it,Polish=pl,Portuguese=pt,Spanish=es,Swedish=sv'),(1124,'enrol_ldap','objectclass','(objectClass=*)');
/*!40000 ALTER TABLE `mdl_config_plugins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_context`
--

DROP TABLE IF EXISTS `mdl_context`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_context` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextlevel` bigint(10) NOT NULL DEFAULT '0',
  `instanceid` bigint(10) NOT NULL DEFAULT '0',
  `path` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `depth` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_cont_conins_uix` (`contextlevel`,`instanceid`),
  KEY `mdl_cont_ins_ix` (`instanceid`),
  KEY `mdl_cont_pat_ix` (`path`)
) ENGINE=InnoDB AUTO_INCREMENT=87 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='one of these must be set';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_context`
--

LOCK TABLES `mdl_context` WRITE;
/*!40000 ALTER TABLE `mdl_context` DISABLE KEYS */;
INSERT INTO `mdl_context` VALUES (1,10,0,'/1',1),(2,50,1,'/1/2',2),(3,40,1,'/1/3',2),(4,30,1,'/1/4',2),(5,30,2,'/1/5',2),(6,80,1,'/1/2/6',3),(7,80,2,'/1/2/7',3),(8,80,3,'/1/2/8',3),(9,80,4,'/1/9',2),(10,80,5,'/1/10',2),(11,80,6,'/1/11',2),(12,80,7,'/1/12',2),(13,80,8,'/1/13',2),(14,80,9,'/1/14',2),(15,80,10,'/1/15',2),(16,80,11,'/1/16',2),(17,80,12,'/1/17',2),(24,50,2,'/1/3/24',3),(25,80,19,'/1/3/24/25',4),(26,80,20,'/1/3/24/26',4),(27,80,21,'/1/3/24/27',4),(28,80,22,'/1/3/24/28',4),(29,70,1,'/1/3/24/29',4),(30,70,2,'/1/3/24/30',4),(31,30,3,'/1/31',2),(38,70,3,'/1/3/24/38',4),(39,70,4,'/1/3/24/39',4),(40,80,29,'/1/3/24/40',4),(42,70,5,'/1/2/42',3),(43,70,6,'/1/2/43',3),(56,80,43,'/1/31/56',3),(57,80,44,'/1/31/57',3),(58,80,45,'/1/31/58',3),(59,80,46,'/1/31/59',3),(60,80,47,'/1/31/60',3),(61,80,48,'/1/31/61',3),(62,80,49,'/1/5/62',3),(63,80,50,'/1/5/63',3),(64,80,51,'/1/5/64',3),(65,80,52,'/1/5/65',3),(66,80,53,'/1/5/66',3),(67,80,54,'/1/5/67',3),(68,30,4,'/1/68',2),(69,80,55,'/1/68/69',3),(70,80,56,'/1/68/70',3),(71,80,57,'/1/68/71',3),(72,80,58,'/1/68/72',3),(73,80,59,'/1/68/73',3),(74,80,60,'/1/68/74',3),(75,70,7,'/1/3/24/75',4),(78,70,10,'/1/3/24/78',4),(81,70,13,'/1/3/24/81',4),(82,70,14,'/1/3/24/82',4),(83,70,15,'/1/3/24/83',4),(84,70,16,'/1/3/24/84',4),(85,70,17,'/1/3/24/85',4),(86,70,18,'/1/3/24/86',4);
/*!40000 ALTER TABLE `mdl_context` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_context_temp`
--

DROP TABLE IF EXISTS `mdl_context_temp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_context_temp` (
  `id` bigint(10) NOT NULL,
  `path` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `depth` tinyint(2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Used by build_context_path() in upgrade and cron to keep con';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_context_temp`
--

LOCK TABLES `mdl_context_temp` WRITE;
/*!40000 ALTER TABLE `mdl_context_temp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_context_temp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course`
--

DROP TABLE IF EXISTS `mdl_course`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `category` bigint(10) NOT NULL DEFAULT '0',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `fullname` varchar(254) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shortname` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `idnumber` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `summary` longtext COLLATE utf8_unicode_ci,
  `summaryformat` tinyint(2) NOT NULL DEFAULT '0',
  `format` varchar(21) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'topics',
  `showgrades` tinyint(2) NOT NULL DEFAULT '1',
  `newsitems` mediumint(5) NOT NULL DEFAULT '1',
  `startdate` bigint(10) NOT NULL DEFAULT '0',
  `marker` bigint(10) NOT NULL DEFAULT '0',
  `maxbytes` bigint(10) NOT NULL DEFAULT '0',
  `legacyfiles` smallint(4) NOT NULL DEFAULT '0',
  `showreports` smallint(4) NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `visibleold` tinyint(1) NOT NULL DEFAULT '1',
  `groupmode` smallint(4) NOT NULL DEFAULT '0',
  `groupmodeforce` smallint(4) NOT NULL DEFAULT '0',
  `defaultgroupingid` bigint(10) NOT NULL DEFAULT '0',
  `lang` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `calendartype` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `theme` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `requested` tinyint(1) NOT NULL DEFAULT '0',
  `enablecompletion` tinyint(1) NOT NULL DEFAULT '0',
  `completionnotify` tinyint(1) NOT NULL DEFAULT '0',
  `cacherev` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_cour_cat_ix` (`category`),
  KEY `mdl_cour_idn_ix` (`idnumber`),
  KEY `mdl_cour_sho_ix` (`shortname`),
  KEY `mdl_cour_sor_ix` (`sortorder`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Central course table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course`
--

LOCK TABLES `mdl_course` WRITE;
/*!40000 ALTER TABLE `mdl_course` DISABLE KEYS */;
INSERT INTO `mdl_course` VALUES (1,0,1,'Spruce School of Real Estate','SpruceOnline','','<p><a class=\"twitter-timeline\" width=\"227\" height=\"200\" data-tweet-limit=\"1\" href=\"https://twitter.com/SpruceSchool\" data-widget-id=\"350001322067644416\">Tweets by @SpruceSchool</a></p>\r\n<script type=\"text/javascript\">// <![CDATA[\r\n!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?\'http\':\'https\';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+\"://platform.twitter.com/widgets.js\";fjs.parentNode.insertBefore(js,fjs);}}(document,\"script\",\"twitter-wjs\");\r\n// ]]></script>',0,'site',1,1,0,0,0,0,0,1,1,0,0,0,'','','',1462257482,1462587253,0,0,0,1462734501),(2,1,10001,'WV Real Estate License Class','WV Pre Sales License','','',1,'weeks',1,5,1462492800,0,0,0,0,1,1,0,0,0,'','','',1462457642,1462457642,0,0,0,1462750043);
/*!40000 ALTER TABLE `mdl_course` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_categories`
--

DROP TABLE IF EXISTS `mdl_course_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_categories` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `idnumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8_unicode_ci,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  `parent` bigint(10) NOT NULL DEFAULT '0',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `coursecount` bigint(10) NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `visibleold` tinyint(1) NOT NULL DEFAULT '1',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `depth` bigint(10) NOT NULL DEFAULT '0',
  `path` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `theme` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_courcate_par_ix` (`parent`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Course categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_categories`
--

LOCK TABLES `mdl_course_categories` WRITE;
/*!40000 ALTER TABLE `mdl_course_categories` DISABLE KEYS */;
INSERT INTO `mdl_course_categories` VALUES (1,'Miscellaneous',NULL,NULL,0,0,10000,1,1,1,1462257482,1,'/1',NULL);
/*!40000 ALTER TABLE `mdl_course_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_completion_aggr_methd`
--

DROP TABLE IF EXISTS `mdl_course_completion_aggr_methd`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_completion_aggr_methd` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `criteriatype` bigint(10) DEFAULT NULL,
  `method` tinyint(1) NOT NULL DEFAULT '0',
  `value` decimal(10,5) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_courcompaggrmeth_coucr_uix` (`course`,`criteriatype`),
  KEY `mdl_courcompaggrmeth_cou_ix` (`course`),
  KEY `mdl_courcompaggrmeth_cri_ix` (`criteriatype`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Course completion aggregation methods for criteria';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_completion_aggr_methd`
--

LOCK TABLES `mdl_course_completion_aggr_methd` WRITE;
/*!40000 ALTER TABLE `mdl_course_completion_aggr_methd` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_course_completion_aggr_methd` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_completion_crit_compl`
--

DROP TABLE IF EXISTS `mdl_course_completion_crit_compl`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_completion_crit_compl` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `course` bigint(10) NOT NULL DEFAULT '0',
  `criteriaid` bigint(10) NOT NULL DEFAULT '0',
  `gradefinal` decimal(10,5) DEFAULT NULL,
  `unenroled` bigint(10) DEFAULT NULL,
  `timecompleted` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_courcompcritcomp_useco_uix` (`userid`,`course`,`criteriaid`),
  KEY `mdl_courcompcritcomp_use_ix` (`userid`),
  KEY `mdl_courcompcritcomp_cou_ix` (`course`),
  KEY `mdl_courcompcritcomp_cri_ix` (`criteriaid`),
  KEY `mdl_courcompcritcomp_tim_ix` (`timecompleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Course completion user records';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_completion_crit_compl`
--

LOCK TABLES `mdl_course_completion_crit_compl` WRITE;
/*!40000 ALTER TABLE `mdl_course_completion_crit_compl` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_course_completion_crit_compl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_completion_criteria`
--

DROP TABLE IF EXISTS `mdl_course_completion_criteria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_completion_criteria` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `criteriatype` bigint(10) NOT NULL DEFAULT '0',
  `module` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `moduleinstance` bigint(10) DEFAULT NULL,
  `courseinstance` bigint(10) DEFAULT NULL,
  `enrolperiod` bigint(10) DEFAULT NULL,
  `timeend` bigint(10) DEFAULT NULL,
  `gradepass` decimal(10,5) DEFAULT NULL,
  `role` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_courcompcrit_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Course completion criteria';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_completion_criteria`
--

LOCK TABLES `mdl_course_completion_criteria` WRITE;
/*!40000 ALTER TABLE `mdl_course_completion_criteria` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_course_completion_criteria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_completions`
--

DROP TABLE IF EXISTS `mdl_course_completions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_completions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `course` bigint(10) NOT NULL DEFAULT '0',
  `timeenrolled` bigint(10) NOT NULL DEFAULT '0',
  `timestarted` bigint(10) NOT NULL DEFAULT '0',
  `timecompleted` bigint(10) DEFAULT NULL,
  `reaggregate` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_courcomp_usecou_uix` (`userid`,`course`),
  KEY `mdl_courcomp_use_ix` (`userid`),
  KEY `mdl_courcomp_cou_ix` (`course`),
  KEY `mdl_courcomp_tim_ix` (`timecompleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Course completion records';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_completions`
--

LOCK TABLES `mdl_course_completions` WRITE;
/*!40000 ALTER TABLE `mdl_course_completions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_course_completions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_format_options`
--

DROP TABLE IF EXISTS `mdl_course_format_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_format_options` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `format` varchar(21) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sectionid` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_courformopti_couforsec_uix` (`courseid`,`format`,`sectionid`,`name`),
  KEY `mdl_courformopti_cou_ix` (`courseid`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Stores format-specific options for the course or course sect';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_format_options`
--

LOCK TABLES `mdl_course_format_options` WRITE;
/*!40000 ALTER TABLE `mdl_course_format_options` DISABLE KEYS */;
INSERT INTO `mdl_course_format_options` VALUES (1,1,'site',0,'numsections','0'),(2,2,'weeks',0,'numsections','4'),(3,2,'weeks',0,'hiddensections','0'),(4,2,'weeks',0,'coursedisplay','0');
/*!40000 ALTER TABLE `mdl_course_format_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_modules`
--

DROP TABLE IF EXISTS `mdl_course_modules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_modules` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `module` bigint(10) NOT NULL DEFAULT '0',
  `instance` bigint(10) NOT NULL DEFAULT '0',
  `section` bigint(10) NOT NULL DEFAULT '0',
  `idnumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `added` bigint(10) NOT NULL DEFAULT '0',
  `score` smallint(4) NOT NULL DEFAULT '0',
  `indent` mediumint(5) NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `visibleold` tinyint(1) NOT NULL DEFAULT '1',
  `groupmode` smallint(4) NOT NULL DEFAULT '0',
  `groupingid` bigint(10) NOT NULL DEFAULT '0',
  `completion` tinyint(1) NOT NULL DEFAULT '0',
  `completiongradeitemnumber` bigint(10) DEFAULT NULL,
  `completionview` tinyint(1) NOT NULL DEFAULT '0',
  `completionexpected` bigint(10) NOT NULL DEFAULT '0',
  `showdescription` tinyint(1) NOT NULL DEFAULT '0',
  `availability` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_courmodu_vis_ix` (`visible`),
  KEY `mdl_courmodu_cou_ix` (`course`),
  KEY `mdl_courmodu_mod_ix` (`module`),
  KEY `mdl_courmodu_ins_ix` (`instance`),
  KEY `mdl_courmodu_idncou_ix` (`idnumber`,`course`),
  KEY `mdl_courmodu_gro_ix` (`groupingid`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='course_modules table retrofitted from MySQL';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_modules`
--

LOCK TABLES `mdl_course_modules` WRITE;
/*!40000 ALTER TABLE `mdl_course_modules` DISABLE KEYS */;
INSERT INTO `mdl_course_modules` VALUES (1,2,9,1,1,NULL,1462457647,0,0,1,1,0,0,0,NULL,0,0,0,NULL),(2,2,18,1,1,'',1462458050,0,0,0,0,0,0,0,NULL,0,0,0,NULL),(3,2,18,2,1,'',1462543851,0,0,0,0,0,0,0,NULL,0,0,0,NULL),(4,2,12,1,1,NULL,1462553783,0,0,1,1,0,0,0,NULL,0,0,0,NULL),(5,1,9,2,6,NULL,1462587118,0,0,1,1,0,0,0,NULL,0,0,0,NULL),(6,1,12,2,6,NULL,1462587814,0,0,1,1,0,0,0,NULL,0,0,0,NULL),(7,2,14,1,2,'',1462652156,0,0,1,1,0,0,0,NULL,0,0,0,NULL),(10,2,18,5,1,'',1462657939,0,0,0,0,0,0,0,NULL,0,0,0,NULL),(13,2,18,8,1,'',1462716817,0,0,0,0,0,0,0,NULL,0,0,0,NULL),(14,2,18,9,1,'',1462716998,0,0,0,0,0,0,0,NULL,0,0,0,NULL),(15,2,18,10,1,'',1462725700,0,0,0,0,0,0,0,NULL,0,0,0,NULL),(16,2,18,11,1,'',1462731284,0,0,0,0,0,0,0,NULL,0,0,0,NULL),(17,2,18,12,2,'',1462749689,0,0,1,1,0,0,0,NULL,0,0,0,NULL),(18,2,18,13,1,'',1462749702,0,0,0,0,0,0,0,NULL,0,0,0,NULL);
/*!40000 ALTER TABLE `mdl_course_modules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_modules_completion`
--

DROP TABLE IF EXISTS `mdl_course_modules_completion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_modules_completion` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `coursemoduleid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `completionstate` tinyint(1) NOT NULL,
  `viewed` tinyint(1) DEFAULT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_courmoducomp_usecou_uix` (`userid`,`coursemoduleid`),
  KEY `mdl_courmoducomp_cou_ix` (`coursemoduleid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Stores the completion state (completed or not completed, etc';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_modules_completion`
--

LOCK TABLES `mdl_course_modules_completion` WRITE;
/*!40000 ALTER TABLE `mdl_course_modules_completion` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_course_modules_completion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_published`
--

DROP TABLE IF EXISTS `mdl_course_published`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_published` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `huburl` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `courseid` bigint(10) NOT NULL,
  `timepublished` bigint(10) NOT NULL,
  `enrollable` tinyint(1) NOT NULL DEFAULT '1',
  `hubcourseid` bigint(10) NOT NULL,
  `status` tinyint(1) DEFAULT '0',
  `timechecked` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Information about how and when an local courses were publish';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_published`
--

LOCK TABLES `mdl_course_published` WRITE;
/*!40000 ALTER TABLE `mdl_course_published` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_course_published` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_request`
--

DROP TABLE IF EXISTS `mdl_course_request`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_request` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `fullname` varchar(254) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shortname` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `summary` longtext COLLATE utf8_unicode_ci NOT NULL,
  `summaryformat` tinyint(2) NOT NULL DEFAULT '0',
  `category` bigint(10) NOT NULL DEFAULT '0',
  `reason` longtext COLLATE utf8_unicode_ci NOT NULL,
  `requester` bigint(10) NOT NULL DEFAULT '0',
  `password` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mdl_courrequ_sho_ix` (`shortname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='course requests';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_request`
--

LOCK TABLES `mdl_course_request` WRITE;
/*!40000 ALTER TABLE `mdl_course_request` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_course_request` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_sections`
--

DROP TABLE IF EXISTS `mdl_course_sections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_sections` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `section` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `summary` longtext COLLATE utf8_unicode_ci,
  `summaryformat` tinyint(2) NOT NULL DEFAULT '0',
  `sequence` longtext COLLATE utf8_unicode_ci,
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `availability` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_coursect_cousec_uix` (`course`,`section`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='to define the sections for each course';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_sections`
--

LOCK TABLES `mdl_course_sections` WRITE;
/*!40000 ALTER TABLE `mdl_course_sections` DISABLE KEYS */;
INSERT INTO `mdl_course_sections` VALUES (1,2,0,NULL,'',1,'2,4,3,10,13,14,15,16,1,18',1,NULL),(2,2,1,NULL,'',1,'7,17',1,NULL),(3,2,2,NULL,'',1,'',1,NULL),(4,2,3,NULL,'',1,'',1,NULL),(5,2,4,NULL,'',1,'',1,NULL),(6,1,0,NULL,'',1,'6,5',1,NULL);
/*!40000 ALTER TABLE `mdl_course_sections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_data`
--

DROP TABLE IF EXISTS `mdl_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_data` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8_unicode_ci NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `comments` smallint(4) NOT NULL DEFAULT '0',
  `timeavailablefrom` bigint(10) NOT NULL DEFAULT '0',
  `timeavailableto` bigint(10) NOT NULL DEFAULT '0',
  `timeviewfrom` bigint(10) NOT NULL DEFAULT '0',
  `timeviewto` bigint(10) NOT NULL DEFAULT '0',
  `requiredentries` int(8) NOT NULL DEFAULT '0',
  `requiredentriestoview` int(8) NOT NULL DEFAULT '0',
  `maxentries` int(8) NOT NULL DEFAULT '0',
  `rssarticles` smallint(4) NOT NULL DEFAULT '0',
  `singletemplate` longtext COLLATE utf8_unicode_ci,
  `listtemplate` longtext COLLATE utf8_unicode_ci,
  `listtemplateheader` longtext COLLATE utf8_unicode_ci,
  `listtemplatefooter` longtext COLLATE utf8_unicode_ci,
  `addtemplate` longtext COLLATE utf8_unicode_ci,
  `rsstemplate` longtext COLLATE utf8_unicode_ci,
  `rsstitletemplate` longtext COLLATE utf8_unicode_ci,
  `csstemplate` longtext COLLATE utf8_unicode_ci,
  `jstemplate` longtext COLLATE utf8_unicode_ci,
  `asearchtemplate` longtext COLLATE utf8_unicode_ci,
  `approval` smallint(4) NOT NULL DEFAULT '0',
  `manageapproved` smallint(4) NOT NULL DEFAULT '1',
  `scale` bigint(10) NOT NULL DEFAULT '0',
  `assessed` bigint(10) NOT NULL DEFAULT '0',
  `assesstimestart` bigint(10) NOT NULL DEFAULT '0',
  `assesstimefinish` bigint(10) NOT NULL DEFAULT '0',
  `defaultsort` bigint(10) NOT NULL DEFAULT '0',
  `defaultsortdir` smallint(4) NOT NULL DEFAULT '0',
  `editany` smallint(4) NOT NULL DEFAULT '0',
  `notification` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_data_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='all database activities';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_data`
--

LOCK TABLES `mdl_data` WRITE;
/*!40000 ALTER TABLE `mdl_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_data_content`
--

DROP TABLE IF EXISTS `mdl_data_content`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_data_content` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `fieldid` bigint(10) NOT NULL DEFAULT '0',
  `recordid` bigint(10) NOT NULL DEFAULT '0',
  `content` longtext COLLATE utf8_unicode_ci,
  `content1` longtext COLLATE utf8_unicode_ci,
  `content2` longtext COLLATE utf8_unicode_ci,
  `content3` longtext COLLATE utf8_unicode_ci,
  `content4` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_datacont_rec_ix` (`recordid`),
  KEY `mdl_datacont_fie_ix` (`fieldid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='the content introduced in each record/fields';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_data_content`
--

LOCK TABLES `mdl_data_content` WRITE;
/*!40000 ALTER TABLE `mdl_data_content` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_data_content` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_data_fields`
--

DROP TABLE IF EXISTS `mdl_data_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_data_fields` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `dataid` bigint(10) NOT NULL DEFAULT '0',
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8_unicode_ci NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `param1` longtext COLLATE utf8_unicode_ci,
  `param2` longtext COLLATE utf8_unicode_ci,
  `param3` longtext COLLATE utf8_unicode_ci,
  `param4` longtext COLLATE utf8_unicode_ci,
  `param5` longtext COLLATE utf8_unicode_ci,
  `param6` longtext COLLATE utf8_unicode_ci,
  `param7` longtext COLLATE utf8_unicode_ci,
  `param8` longtext COLLATE utf8_unicode_ci,
  `param9` longtext COLLATE utf8_unicode_ci,
  `param10` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_datafiel_typdat_ix` (`type`,`dataid`),
  KEY `mdl_datafiel_dat_ix` (`dataid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='every field available';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_data_fields`
--

LOCK TABLES `mdl_data_fields` WRITE;
/*!40000 ALTER TABLE `mdl_data_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_data_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_data_records`
--

DROP TABLE IF EXISTS `mdl_data_records`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_data_records` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `dataid` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `approved` smallint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_datareco_dat_ix` (`dataid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='every record introduced';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_data_records`
--

LOCK TABLES `mdl_data_records` WRITE;
/*!40000 ALTER TABLE `mdl_data_records` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_data_records` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_editor_atto_autosave`
--

DROP TABLE IF EXISTS `mdl_editor_atto_autosave`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_editor_atto_autosave` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `elementid` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contextid` bigint(10) NOT NULL,
  `pagehash` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `userid` bigint(10) NOT NULL,
  `drafttext` longtext COLLATE utf8_unicode_ci NOT NULL,
  `draftid` bigint(10) DEFAULT NULL,
  `pageinstance` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_editattoauto_eleconuse_uix` (`elementid`,`contextid`,`userid`,`pagehash`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Draft text that is auto-saved every 5 seconds while an edito';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_editor_atto_autosave`
--

LOCK TABLES `mdl_editor_atto_autosave` WRITE;
/*!40000 ALTER TABLE `mdl_editor_atto_autosave` DISABLE KEYS */;
INSERT INTO `mdl_editor_atto_autosave` VALUES (12,'id_introeditor',38,'91250d678a16261214568e1801507c8bb5a0ecba',2,'',790173417,'yui_3_17_2_1_1462587464407_514',1462587451),(24,'summary',1,'ef0968f8401f81f0465c2578a77e270bf9510219',2,'<p><a class=\"twitter-timeline\" width=\"227\" height=\"200\" data-tweet-limit=\"1\" href=\"https://twitter.com/SpruceSchool\" data-widget-id=\"350001322067644416\">Tweets by @SpruceSchool</a></p>\n<script type=\"text/javascript\">// <![CDATA[\n!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?\'http\':\'https\';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+\"://platform.twitter.com/widgets.js\";fjs.parentNode.insertBefore(js,fjs);}}(document,\"script\",\"twitter-wjs\");\n// ]]></script>',-1,'yui_3_17_2_1_1462651798158_167',1462651799),(25,'id_introeditor',30,'2885d01323cfd78ba499ef855fbf6dd6bae16532',2,'',656173619,'yui_3_17_2_1_1462736864526_515',1462736915),(30,'summary',1,'ef0968f8401f81f0465c2578a77e270bf9510219',4,'',-1,'yui_3_17_2_1_1462651740465_167',1462651741),(32,'id_introeditor',38,'e7c768e0513d81ff225c491f3887a03dd8993e26',2,'',613556333,'yui_3_17_2_1_1462654740186_499',1462654743),(34,'id_summary_editor',24,'6be4f1bc6d4f2acf7d1693ffd70042be5d7c976a',2,'',587949366,'yui_3_17_2_1_1462656898764_109',1462656899),(35,'id_summary_editor',3,'ebb9496d54ef3acd4f1443596c339b863dd10534',2,'',974540289,'yui_3_17_2_1_1462657013452_365',1462657014),(41,'id_introeditor',30,'2885d01323cfd78ba499ef855fbf6dd6bae16532',4,'',496783858,'yui_3_17_2_1_1462659620793_517',1462659622),(42,'id_introeditor',78,'cd037a2e8fe57ed88d3fec3725c1ec7c2ebabbc2',4,'',604246119,'yui_3_17_2_1_1462659660009_517',1462659661),(50,'id_s__maintenance_message',1,'2738d785471176c70c22068f694e52bd87cab6ed',2,'',-1,'yui_3_17_2_1_1462734056760_167',1462734100),(53,'id_introeditor',83,'c233e0267abac10974e55d29424a6bb48904a00d',2,'',163335550,'yui_3_17_2_1_1462749435659_515',1462749449);
/*!40000 ALTER TABLE `mdl_editor_atto_autosave` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol`
--

DROP TABLE IF EXISTS `mdl_enrol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `enrol` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `status` bigint(10) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `enrolperiod` bigint(10) DEFAULT '0',
  `enrolstartdate` bigint(10) DEFAULT '0',
  `enrolenddate` bigint(10) DEFAULT '0',
  `expirynotify` tinyint(1) DEFAULT '0',
  `expirythreshold` bigint(10) DEFAULT '0',
  `notifyall` tinyint(1) DEFAULT '0',
  `password` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cost` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `currency` varchar(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  `roleid` bigint(10) DEFAULT '0',
  `customint1` bigint(10) DEFAULT NULL,
  `customint2` bigint(10) DEFAULT NULL,
  `customint3` bigint(10) DEFAULT NULL,
  `customint4` bigint(10) DEFAULT NULL,
  `customint5` bigint(10) DEFAULT NULL,
  `customint6` bigint(10) DEFAULT NULL,
  `customint7` bigint(10) DEFAULT NULL,
  `customint8` bigint(10) DEFAULT NULL,
  `customchar1` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customchar2` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customchar3` varchar(1333) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customdec1` decimal(12,7) DEFAULT NULL,
  `customdec2` decimal(12,7) DEFAULT NULL,
  `customtext1` longtext COLLATE utf8_unicode_ci,
  `customtext2` longtext COLLATE utf8_unicode_ci,
  `customtext3` longtext COLLATE utf8_unicode_ci,
  `customtext4` longtext COLLATE utf8_unicode_ci,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_enro_enr_ix` (`enrol`),
  KEY `mdl_enro_cou_ix` (`courseid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Instances of enrolment plugins used in courses, fields marke';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol`
--

LOCK TABLES `mdl_enrol` WRITE;
/*!40000 ALTER TABLE `mdl_enrol` DISABLE KEYS */;
INSERT INTO `mdl_enrol` VALUES (1,'manual',0,2,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1462457642,1462457642),(2,'guest',1,2,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1462457642,1462457642),(3,'self',1,2,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1462457642,1462457642);
/*!40000 ALTER TABLE `mdl_enrol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol_flatfile`
--

DROP TABLE IF EXISTS `mdl_enrol_flatfile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol_flatfile` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `action` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `roleid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `courseid` bigint(10) NOT NULL,
  `timestart` bigint(10) NOT NULL DEFAULT '0',
  `timeend` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_enroflat_cou_ix` (`courseid`),
  KEY `mdl_enroflat_use_ix` (`userid`),
  KEY `mdl_enroflat_rol_ix` (`roleid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='enrol_flatfile table retrofitted from MySQL';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol_flatfile`
--

LOCK TABLES `mdl_enrol_flatfile` WRITE;
/*!40000 ALTER TABLE `mdl_enrol_flatfile` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_enrol_flatfile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol_paypal`
--

DROP TABLE IF EXISTS `mdl_enrol_paypal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol_paypal` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `business` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `receiver_email` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `receiver_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `item_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `instanceid` bigint(10) NOT NULL DEFAULT '0',
  `memo` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tax` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `option_name1` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `option_selection1_x` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `option_name2` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `option_selection2_x` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payment_status` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `pending_reason` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `reason_code` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `txn_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `parent_txn_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payment_type` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `timeupdated` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Holds all known information about PayPal transactions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol_paypal`
--

LOCK TABLES `mdl_enrol_paypal` WRITE;
/*!40000 ALTER TABLE `mdl_enrol_paypal` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_enrol_paypal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_event`
--

DROP TABLE IF EXISTS `mdl_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_event` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` longtext COLLATE utf8_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8_unicode_ci NOT NULL,
  `format` smallint(4) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `repeatid` bigint(10) NOT NULL DEFAULT '0',
  `modulename` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `instance` bigint(10) NOT NULL DEFAULT '0',
  `eventtype` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `timestart` bigint(10) NOT NULL DEFAULT '0',
  `timeduration` bigint(10) NOT NULL DEFAULT '0',
  `visible` smallint(4) NOT NULL DEFAULT '1',
  `uuid` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sequence` bigint(10) NOT NULL DEFAULT '1',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `subscriptionid` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_even_cou_ix` (`courseid`),
  KEY `mdl_even_use_ix` (`userid`),
  KEY `mdl_even_tim_ix` (`timestart`),
  KEY `mdl_even_tim2_ix` (`timeduration`),
  KEY `mdl_even_grocouvisuse_ix` (`groupid`,`courseid`,`visible`,`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='For everything with a time associated to it';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_event`
--

LOCK TABLES `mdl_event` WRITE;
/*!40000 ALTER TABLE `mdl_event` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_event_subscriptions`
--

DROP TABLE IF EXISTS `mdl_event_subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_event_subscriptions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `eventtype` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `pollinterval` bigint(10) NOT NULL DEFAULT '0',
  `lastupdated` bigint(10) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Tracks subscriptions to remote calendars.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_event_subscriptions`
--

LOCK TABLES `mdl_event_subscriptions` WRITE;
/*!40000 ALTER TABLE `mdl_event_subscriptions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_event_subscriptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_events_handlers`
--

DROP TABLE IF EXISTS `mdl_events_handlers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_events_handlers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `eventname` varchar(166) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `component` varchar(166) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `handlerfile` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `handlerfunction` longtext COLLATE utf8_unicode_ci,
  `schedule` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` bigint(10) NOT NULL DEFAULT '0',
  `internal` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_evenhand_evecom_uix` (`eventname`,`component`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='This table is for storing which components requests what typ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_events_handlers`
--

LOCK TABLES `mdl_events_handlers` WRITE;
/*!40000 ALTER TABLE `mdl_events_handlers` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_events_handlers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_events_queue`
--

DROP TABLE IF EXISTS `mdl_events_queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_events_queue` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `eventdata` longtext COLLATE utf8_unicode_ci NOT NULL,
  `stackdump` longtext COLLATE utf8_unicode_ci,
  `userid` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_evenqueu_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='This table is for storing queued events. It stores only one ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_events_queue`
--

LOCK TABLES `mdl_events_queue` WRITE;
/*!40000 ALTER TABLE `mdl_events_queue` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_events_queue` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_events_queue_handlers`
--

DROP TABLE IF EXISTS `mdl_events_queue_handlers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_events_queue_handlers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `queuedeventid` bigint(10) NOT NULL,
  `handlerid` bigint(10) NOT NULL,
  `status` bigint(10) DEFAULT NULL,
  `errormessage` longtext COLLATE utf8_unicode_ci,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_evenqueuhand_que_ix` (`queuedeventid`),
  KEY `mdl_evenqueuhand_han_ix` (`handlerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='This is the list of queued handlers for processing. The even';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_events_queue_handlers`
--

LOCK TABLES `mdl_events_queue_handlers` WRITE;
/*!40000 ALTER TABLE `mdl_events_queue_handlers` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_events_queue_handlers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_external_functions`
--

DROP TABLE IF EXISTS `mdl_external_functions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_external_functions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `classname` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `methodname` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `classpath` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `component` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `capabilities` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_extefunc_nam_uix` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=193 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='list of all external functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_external_functions`
--

LOCK TABLES `mdl_external_functions` WRITE;
/*!40000 ALTER TABLE `mdl_external_functions` DISABLE KEYS */;
INSERT INTO `mdl_external_functions` VALUES (1,'core_cohort_create_cohorts','core_cohort_external','create_cohorts','cohort/externallib.php','moodle','moodle/cohort:manage'),(2,'core_cohort_delete_cohorts','core_cohort_external','delete_cohorts','cohort/externallib.php','moodle','moodle/cohort:manage'),(3,'core_cohort_get_cohorts','core_cohort_external','get_cohorts','cohort/externallib.php','moodle','moodle/cohort:view'),(4,'core_cohort_update_cohorts','core_cohort_external','update_cohorts','cohort/externallib.php','moodle','moodle/cohort:manage'),(5,'core_cohort_add_cohort_members','core_cohort_external','add_cohort_members','cohort/externallib.php','moodle','moodle/cohort:assign'),(6,'core_cohort_delete_cohort_members','core_cohort_external','delete_cohort_members','cohort/externallib.php','moodle','moodle/cohort:assign'),(7,'core_cohort_get_cohort_members','core_cohort_external','get_cohort_members','cohort/externallib.php','moodle','moodle/cohort:view'),(8,'core_comment_get_comments','core_comment_external','get_comments',NULL,'moodle','moodle/comment:view'),(9,'core_grades_get_grades','core_grades_external','get_grades',NULL,'moodle','moodle/grade:view, moodle/grade:viewall, moodle/grade:viewhidden'),(10,'core_grades_update_grades','core_grades_external','update_grades',NULL,'moodle',''),(11,'moodle_group_create_groups','moodle_group_external','create_groups','group/externallib.php','moodle','moodle/course:managegroups'),(12,'core_group_create_groups','core_group_external','create_groups','group/externallib.php','moodle','moodle/course:managegroups'),(13,'moodle_group_get_groups','moodle_group_external','get_groups','group/externallib.php','moodle','moodle/course:managegroups'),(14,'core_group_get_groups','core_group_external','get_groups','group/externallib.php','moodle','moodle/course:managegroups'),(15,'moodle_group_get_course_groups','moodle_group_external','get_course_groups','group/externallib.php','moodle','moodle/course:managegroups'),(16,'core_group_get_course_groups','core_group_external','get_course_groups','group/externallib.php','moodle','moodle/course:managegroups'),(17,'moodle_group_delete_groups','moodle_group_external','delete_groups','group/externallib.php','moodle','moodle/course:managegroups'),(18,'core_group_delete_groups','core_group_external','delete_groups','group/externallib.php','moodle','moodle/course:managegroups'),(19,'moodle_group_get_groupmembers','moodle_group_external','get_groupmembers','group/externallib.php','moodle','moodle/course:managegroups'),(20,'core_group_get_group_members','core_group_external','get_group_members','group/externallib.php','moodle','moodle/course:managegroups'),(21,'moodle_group_add_groupmembers','moodle_group_external','add_groupmembers','group/externallib.php','moodle','moodle/course:managegroups'),(22,'core_group_add_group_members','core_group_external','add_group_members','group/externallib.php','moodle','moodle/course:managegroups'),(23,'moodle_group_delete_groupmembers','moodle_group_external','delete_groupmembers','group/externallib.php','moodle','moodle/course:managegroups'),(24,'core_group_delete_group_members','core_group_external','delete_group_members','group/externallib.php','moodle','moodle/course:managegroups'),(25,'core_group_create_groupings','core_group_external','create_groupings','group/externallib.php','moodle',''),(26,'core_group_update_groupings','core_group_external','update_groupings','group/externallib.php','moodle',''),(27,'core_group_get_groupings','core_group_external','get_groupings','group/externallib.php','moodle',''),(28,'core_group_get_course_groupings','core_group_external','get_course_groupings','group/externallib.php','moodle',''),(29,'core_group_delete_groupings','core_group_external','delete_groupings','group/externallib.php','moodle',''),(30,'core_group_assign_grouping','core_group_external','assign_grouping','group/externallib.php','moodle',''),(31,'core_group_unassign_grouping','core_group_external','unassign_grouping','group/externallib.php','moodle',''),(32,'core_group_get_course_user_groups','core_group_external','get_course_user_groups','group/externallib.php','moodle','moodle/course:managegroups'),(33,'core_group_get_activity_allowed_groups','core_group_external','get_activity_allowed_groups','group/externallib.php','moodle',''),(34,'core_group_get_activity_groupmode','core_group_external','get_activity_groupmode','group/externallib.php','moodle',''),(35,'core_notes_get_course_notes','core_notes_external','get_course_notes','notes/externallib.php','moodle','moodle/notes:view'),(36,'moodle_file_get_files','moodle_file_external','get_files','files/externallib.php','moodle',''),(37,'core_files_get_files','core_files_external','get_files','files/externallib.php','moodle',''),(38,'moodle_file_upload','moodle_file_external','upload','files/externallib.php','moodle',''),(39,'core_files_upload','core_files_external','upload','files/externallib.php','moodle',''),(40,'moodle_user_create_users','moodle_user_external','create_users','user/externallib.php','moodle','moodle/user:create'),(41,'core_user_create_users','core_user_external','create_users','user/externallib.php','moodle','moodle/user:create'),(42,'core_user_get_users','core_user_external','get_users','user/externallib.php','moodle','moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update'),(43,'moodle_user_get_users_by_id','moodle_user_external','get_users_by_id','user/externallib.php','moodle','moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update'),(44,'core_user_get_users_by_field','core_user_external','get_users_by_field','user/externallib.php','moodle','moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update'),(45,'core_user_get_users_by_id','core_user_external','get_users_by_id','user/externallib.php','moodle','moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update'),(46,'moodle_user_get_users_by_courseid','moodle_user_external','get_users_by_courseid','user/externallib.php','moodle','moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update, moodle/site:accessallgroups'),(47,'moodle_user_get_course_participants_by_id','moodle_user_external','get_course_participants_by_id','user/externallib.php','moodle','moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update, moodle/site:accessallgroups'),(48,'core_user_get_course_user_profiles','core_user_external','get_course_user_profiles','user/externallib.php','moodle','moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update, moodle/site:accessallgroups'),(49,'moodle_user_delete_users','moodle_user_external','delete_users','user/externallib.php','moodle','moodle/user:delete'),(50,'core_user_delete_users','core_user_external','delete_users','user/externallib.php','moodle','moodle/user:delete'),(51,'moodle_user_update_users','moodle_user_external','update_users','user/externallib.php','moodle','moodle/user:update'),(52,'core_user_update_users','core_user_external','update_users','user/externallib.php','moodle','moodle/user:update'),(53,'core_user_add_user_device','core_user_external','add_user_device','user/externallib.php','moodle',''),(54,'core_user_remove_user_device','core_user_external','remove_user_device','user/externallib.php','moodle',''),(55,'core_user_view_user_list','core_user_external','view_user_list','user/externallib.php','moodle','moodle/course:viewparticipants'),(56,'core_user_view_user_profile','core_user_external','view_user_profile','user/externallib.php','moodle','moodle/user:viewdetails'),(57,'core_user_add_user_private_files','core_user_external','add_user_private_files','user/externallib.php','moodle','moodle/user:manageownfiles'),(58,'core_enrol_get_enrolled_users_with_capability','core_enrol_external','get_enrolled_users_with_capability','enrol/externallib.php','moodle',''),(59,'moodle_enrol_get_enrolled_users','moodle_enrol_external','get_enrolled_users','enrol/externallib.php','moodle','moodle/site:viewparticipants, moodle/course:viewparticipants,\n            moodle/role:review, moodle/site:accessallgroups, moodle/course:enrolreview'),(60,'core_enrol_get_enrolled_users','core_enrol_external','get_enrolled_users','enrol/externallib.php','moodle','moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update, moodle/site:accessallgroups'),(61,'moodle_enrol_get_users_courses','moodle_enrol_external','get_users_courses','enrol/externallib.php','moodle','moodle/course:viewparticipants'),(62,'core_enrol_get_users_courses','core_enrol_external','get_users_courses','enrol/externallib.php','moodle','moodle/course:viewparticipants'),(63,'core_enrol_get_course_enrolment_methods','core_enrol_external','get_course_enrolment_methods','enrol/externallib.php','moodle',''),(64,'moodle_role_assign','moodle_enrol_external','role_assign','enrol/externallib.php','moodle','moodle/role:assign'),(65,'core_role_assign_roles','core_role_external','assign_roles','enrol/externallib.php','moodle','moodle/role:assign'),(66,'moodle_role_unassign','moodle_enrol_external','role_unassign','enrol/externallib.php','moodle','moodle/role:assign'),(67,'core_role_unassign_roles','core_role_external','unassign_roles','enrol/externallib.php','moodle','moodle/role:assign'),(68,'core_course_get_contents','core_course_external','get_course_contents','course/externallib.php','moodle','moodle/course:update,moodle/course:viewhiddencourses'),(69,'moodle_course_get_courses','moodle_course_external','get_courses','course/externallib.php','moodle','moodle/course:view,moodle/course:update,moodle/course:viewhiddencourses'),(70,'core_course_get_courses','core_course_external','get_courses','course/externallib.php','moodle','moodle/course:view,moodle/course:update,moodle/course:viewhiddencourses'),(71,'core_course_search_courses','core_course_external','search_courses','course/externallib.php','moodle',''),(72,'moodle_course_create_courses','moodle_course_external','create_courses','course/externallib.php','moodle','moodle/course:create,moodle/course:visibility'),(73,'core_course_create_courses','core_course_external','create_courses','course/externallib.php','moodle','moodle/course:create,moodle/course:visibility'),(74,'core_course_delete_courses','core_course_external','delete_courses','course/externallib.php','moodle','moodle/course:delete'),(75,'core_course_delete_modules','core_course_external','delete_modules','course/externallib.php','moodle','moodle/course:manageactivities'),(76,'core_course_duplicate_course','core_course_external','duplicate_course','course/externallib.php','moodle','moodle/backup:backupcourse,moodle/restore:restorecourse,moodle/course:create'),(77,'core_course_update_courses','core_course_external','update_courses','course/externallib.php','moodle','moodle/course:update,moodle/course:changecategory,moodle/course:changefullname,moodle/course:changeshortname,moodle/course:changeidnumber,moodle/course:changesummary,moodle/course:visibility'),(78,'core_course_view_course','core_course_external','view_course','course/externallib.php','moodle',''),(79,'core_course_get_course_module','core_course_external','get_course_module','course/externallib.php','moodle',''),(80,'core_course_get_course_module_by_instance','core_course_external','get_course_module_by_instance','course/externallib.php','moodle',''),(81,'core_course_get_categories','core_course_external','get_categories','course/externallib.php','moodle','moodle/category:viewhiddencategories'),(82,'core_course_create_categories','core_course_external','create_categories','course/externallib.php','moodle','moodle/category:manage'),(83,'core_course_update_categories','core_course_external','update_categories','course/externallib.php','moodle','moodle/category:manage'),(84,'core_course_delete_categories','core_course_external','delete_categories','course/externallib.php','moodle','moodle/category:manage'),(85,'core_course_import_course','core_course_external','import_course','course/externallib.php','moodle','moodle/backup:backuptargetimport, moodle/restore:restoretargetimport'),(86,'moodle_message_send_instantmessages','moodle_message_external','send_instantmessages','message/externallib.php','moodle','moodle/site:sendmessage'),(87,'core_message_send_instant_messages','core_message_external','send_instant_messages','message/externallib.php','moodle','moodle/site:sendmessage'),(88,'core_message_create_contacts','core_message_external','create_contacts','message/externallib.php','moodle',''),(89,'core_message_delete_contacts','core_message_external','delete_contacts','message/externallib.php','moodle',''),(90,'core_message_block_contacts','core_message_external','block_contacts','message/externallib.php','moodle',''),(91,'core_message_unblock_contacts','core_message_external','unblock_contacts','message/externallib.php','moodle',''),(92,'core_message_get_contacts','core_message_external','get_contacts','message/externallib.php','moodle',''),(93,'core_message_search_contacts','core_message_external','search_contacts','message/externallib.php','moodle',''),(94,'core_message_get_messages','core_message_external','get_messages','message/externallib.php','moodle',''),(95,'core_message_get_blocked_users','core_message_external','get_blocked_users','message/externallib.php','moodle',''),(96,'core_message_mark_message_read','core_message_external','mark_message_read','message/externallib.php','moodle',''),(97,'moodle_notes_create_notes','moodle_notes_external','create_notes','notes/externallib.php','moodle','moodle/notes:manage'),(98,'core_notes_create_notes','core_notes_external','create_notes','notes/externallib.php','moodle','moodle/notes:manage'),(99,'core_notes_delete_notes','core_notes_external','delete_notes','notes/externallib.php','moodle','moodle/notes:manage'),(100,'core_notes_get_notes','core_notes_external','get_notes','notes/externallib.php','moodle','moodle/notes:view'),(101,'core_notes_update_notes','core_notes_external','update_notes','notes/externallib.php','moodle','moodle/notes:manage'),(102,'core_notes_view_notes','core_notes_external','view_notes','notes/externallib.php','moodle','moodle/notes:view'),(103,'core_grading_get_definitions','core_grading_external','get_definitions',NULL,'moodle',''),(104,'core_grade_get_definitions','core_grade_external','get_definitions','grade/externallib.php','moodle',''),(105,'core_grading_save_definitions','core_grading_external','save_definitions',NULL,'moodle',''),(106,'core_grading_get_gradingform_instances','core_grading_external','get_gradingform_instances',NULL,'moodle',''),(107,'moodle_webservice_get_siteinfo','moodle_webservice_external','get_siteinfo','webservice/externallib.php','moodle',''),(108,'core_webservice_get_site_info','core_webservice_external','get_site_info','webservice/externallib.php','moodle',''),(109,'core_get_string','core_external','get_string','lib/external/externallib.php','moodle',''),(110,'core_get_strings','core_external','get_strings','lib/external/externallib.php','moodle',''),(111,'core_get_component_strings','core_external','get_component_strings','lib/external/externallib.php','moodle',''),(112,'core_calendar_delete_calendar_events','core_calendar_external','delete_calendar_events','calendar/externallib.php','moodle','moodle/calendar:manageentries'),(113,'core_calendar_get_calendar_events','core_calendar_external','get_calendar_events','calendar/externallib.php','moodle','moodle/calendar:manageentries'),(114,'core_calendar_create_calendar_events','core_calendar_external','create_calendar_events','calendar/externallib.php','moodle','moodle/calendar:manageentries'),(115,'core_output_load_template','core\\output\\external','load_template',NULL,'moodle',''),(116,'core_completion_update_activity_completion_status_manually','core_completion_external','update_activity_completion_status_manually',NULL,'moodle',''),(117,'core_completion_mark_course_self_completed','core_completion_external','mark_course_self_completed',NULL,'moodle',''),(118,'core_completion_get_activities_completion_status','core_completion_external','get_activities_completion_status',NULL,'moodle',''),(119,'core_completion_get_course_completion_status','core_completion_external','get_course_completion_status',NULL,'moodle','report/completion:view'),(120,'core_rating_get_item_ratings','core_rating_external','get_item_ratings',NULL,'moodle','moodle/rating:view'),(121,'core_tag_update_tags','core_tag_external','update_tags',NULL,'moodle',''),(122,'core_tag_get_tags','core_tag_external','get_tags',NULL,'moodle',''),(123,'mod_assign_get_grades','mod_assign_external','get_grades','mod/assign/externallib.php','mod_assign',''),(124,'mod_assign_get_assignments','mod_assign_external','get_assignments','mod/assign/externallib.php','mod_assign',''),(125,'mod_assign_get_submissions','mod_assign_external','get_submissions','mod/assign/externallib.php','mod_assign',''),(126,'mod_assign_get_user_flags','mod_assign_external','get_user_flags','mod/assign/externallib.php','mod_assign',''),(127,'mod_assign_set_user_flags','mod_assign_external','set_user_flags','mod/assign/externallib.php','mod_assign','mod/assign:grade'),(128,'mod_assign_get_user_mappings','mod_assign_external','get_user_mappings','mod/assign/externallib.php','mod_assign',''),(129,'mod_assign_revert_submissions_to_draft','mod_assign_external','revert_submissions_to_draft','mod/assign/externallib.php','mod_assign',''),(130,'mod_assign_lock_submissions','mod_assign_external','lock_submissions','mod/assign/externallib.php','mod_assign',''),(131,'mod_assign_unlock_submissions','mod_assign_external','unlock_submissions','mod/assign/externallib.php','mod_assign',''),(132,'mod_assign_save_submission','mod_assign_external','save_submission','mod/assign/externallib.php','mod_assign',''),(133,'mod_assign_submit_for_grading','mod_assign_external','submit_for_grading','mod/assign/externallib.php','mod_assign',''),(134,'mod_assign_save_grade','mod_assign_external','save_grade','mod/assign/externallib.php','mod_assign',''),(135,'mod_assign_save_grades','mod_assign_external','save_grades','mod/assign/externallib.php','mod_assign',''),(136,'mod_assign_save_user_extensions','mod_assign_external','save_user_extensions','mod/assign/externallib.php','mod_assign',''),(137,'mod_assign_reveal_identities','mod_assign_external','reveal_identities','mod/assign/externallib.php','mod_assign',''),(138,'mod_assign_view_grading_table','mod_assign_external','view_grading_table','mod/assign/externallib.php','mod_assign','mod/assign:view, mod/assign:viewgrades'),(139,'mod_book_view_book','mod_book_external','view_book',NULL,'mod_book','mod/book:read'),(140,'mod_book_get_books_by_courses','mod_book_external','get_books_by_courses',NULL,'mod_book',''),(141,'mod_chat_login_user','mod_chat_external','login_user',NULL,'mod_chat','mod/chat:chat'),(142,'mod_chat_get_chat_users','mod_chat_external','get_chat_users',NULL,'mod_chat','mod/chat:chat'),(143,'mod_chat_send_chat_message','mod_chat_external','send_chat_message',NULL,'mod_chat','mod/chat:chat'),(144,'mod_chat_get_chat_latest_messages','mod_chat_external','get_chat_latest_messages',NULL,'mod_chat','mod/chat:chat'),(145,'mod_chat_view_chat','mod_chat_external','view_chat',NULL,'mod_chat','mod/chat:chat'),(146,'mod_chat_get_chats_by_courses','mod_chat_external','get_chats_by_courses',NULL,'mod_chat',''),(147,'mod_choice_get_choice_results','mod_choice_external','get_choice_results',NULL,'mod_choice',''),(148,'mod_choice_get_choice_options','mod_choice_external','get_choice_options',NULL,'mod_choice','mod/choice:choose'),(149,'mod_choice_submit_choice_response','mod_choice_external','submit_choice_response',NULL,'mod_choice','mod/choice:choose'),(150,'mod_choice_view_choice','mod_choice_external','view_choice',NULL,'mod_choice',''),(151,'mod_choice_get_choices_by_courses','mod_choice_external','get_choices_by_courses',NULL,'mod_choice',''),(152,'mod_choice_delete_choice_responses','mod_choice_external','delete_choice_responses',NULL,'mod_choice','mod/choice:choose'),(153,'mod_data_get_databases_by_courses','mod_data_external','get_databases_by_courses',NULL,'mod_data','mod/data:viewentry'),(154,'mod_folder_view_folder','mod_folder_external','view_folder',NULL,'mod_folder','mod/folder:view'),(155,'mod_forum_get_forums_by_courses','mod_forum_external','get_forums_by_courses','mod/forum/externallib.php','mod_forum','mod/forum:viewdiscussion'),(156,'mod_forum_get_forum_discussions','mod_forum_external','get_forum_discussions','mod/forum/externallib.php','mod_forum','mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting'),(157,'mod_forum_get_forum_discussion_posts','mod_forum_external','get_forum_discussion_posts','mod/forum/externallib.php','mod_forum','mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting'),(158,'mod_forum_get_forum_discussions_paginated','mod_forum_external','get_forum_discussions_paginated','mod/forum/externallib.php','mod_forum','mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting'),(159,'mod_forum_view_forum','mod_forum_external','view_forum','mod/forum/externallib.php','mod_forum','mod/forum:viewdiscussion'),(160,'mod_forum_view_forum_discussion','mod_forum_external','view_forum_discussion','mod/forum/externallib.php','mod_forum','mod/forum:viewdiscussion'),(161,'mod_forum_add_discussion_post','mod_forum_external','add_discussion_post','mod/forum/externallib.php','mod_forum','mod/forum:replypost'),(162,'mod_forum_add_discussion','mod_forum_external','add_discussion','mod/forum/externallib.php','mod_forum','mod/forum:startdiscussion'),(163,'mod_imscp_view_imscp','mod_imscp_external','view_imscp',NULL,'mod_imscp','mod/imscp:view'),(164,'mod_imscp_get_imscps_by_courses','mod_imscp_external','get_imscps_by_courses',NULL,'mod_imscp','moodle/imscp:view'),(165,'mod_lti_get_tool_launch_data','mod_lti_external','get_tool_launch_data',NULL,'mod_lti','mod/lti:view'),(166,'mod_lti_get_ltis_by_courses','mod_lti_external','get_ltis_by_courses',NULL,'mod_lti','mod/lti:view'),(167,'mod_lti_view_lti','mod_lti_external','view_lti',NULL,'mod_lti','mod/lti:view'),(168,'mod_page_view_page','mod_page_external','view_page',NULL,'mod_page','mod/page:view'),(169,'mod_resource_view_resource','mod_resource_external','view_resource',NULL,'mod_resource','mod/resource:view'),(170,'mod_scorm_view_scorm','mod_scorm_external','view_scorm',NULL,'mod_scorm',''),(171,'mod_scorm_get_scorm_attempt_count','mod_scorm_external','get_scorm_attempt_count',NULL,'mod_scorm',''),(172,'mod_scorm_get_scorm_scoes','mod_scorm_external','get_scorm_scoes',NULL,'mod_scorm',''),(173,'mod_scorm_get_scorm_user_data','mod_scorm_external','get_scorm_user_data',NULL,'mod_scorm',''),(174,'mod_scorm_insert_scorm_tracks','mod_scorm_external','insert_scorm_tracks',NULL,'mod_scorm','mod/scorm:savetrack'),(175,'mod_scorm_get_scorm_sco_tracks','mod_scorm_external','get_scorm_sco_tracks',NULL,'mod_scorm',''),(176,'mod_scorm_get_scorms_by_courses','mod_scorm_external','get_scorms_by_courses',NULL,'mod_scorm',''),(177,'mod_survey_get_surveys_by_courses','mod_survey_external','get_surveys_by_courses',NULL,'mod_survey',''),(178,'mod_survey_view_survey','mod_survey_external','view_survey',NULL,'mod_survey','mod/survey:participate'),(179,'mod_survey_get_questions','mod_survey_external','get_questions',NULL,'mod_survey','mod/survey:participate'),(180,'mod_survey_submit_answers','mod_survey_external','submit_answers',NULL,'mod_survey','mod/survey:participate'),(181,'mod_url_view_url','mod_url_external','view_url',NULL,'mod_url','mod/url:view'),(182,'moodle_enrol_manual_enrol_users','moodle_enrol_manual_external','manual_enrol_users','enrol/manual/externallib.php','enrol_manual','enrol/manual:enrol'),(183,'enrol_manual_enrol_users','enrol_manual_external','enrol_users','enrol/manual/externallib.php','enrol_manual','enrol/manual:enrol'),(184,'enrol_manual_unenrol_users','enrol_manual_external','unenrol_users','enrol/manual/externallib.php','enrol_manual','enrol/manual:unenrol'),(185,'enrol_self_get_instance_info','enrol_self_external','get_instance_info','enrol/self/externallib.php','enrol_self',''),(186,'enrol_self_enrol_user','enrol_self_external','enrol_user','enrol/self/externallib.php','enrol_self',''),(187,'message_airnotifier_is_system_configured','message_airnotifier_external','is_system_configured','message/output/airnotifier/externallib.php','message_airnotifier',''),(188,'message_airnotifier_are_notification_preferences_configured','message_airnotifier_external','are_notification_preferences_configured','message/output/airnotifier/externallib.php','message_airnotifier',''),(189,'gradereport_user_get_grades_table','gradereport_user_external','get_grades_table','grade/report/user/externallib.php','gradereport_user','gradereport/user:view'),(190,'gradereport_user_view_grade_report','gradereport_user_external','view_grade_report','grade/report/user/externallib.php','gradereport_user','gradereport/user:view'),(191,'tool_templatelibrary_list_templates','tool_templatelibrary\\external','list_templates',NULL,'tool_templatelibrary',''),(192,'tool_templatelibrary_load_canonical_template','tool_templatelibrary\\external','load_canonical_template',NULL,'tool_templatelibrary','');
/*!40000 ALTER TABLE `mdl_external_functions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_external_services`
--

DROP TABLE IF EXISTS `mdl_external_services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_external_services` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL,
  `requiredcapability` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `restrictedusers` tinyint(1) NOT NULL,
  `component` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `shortname` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `downloadfiles` tinyint(1) NOT NULL DEFAULT '0',
  `uploadfiles` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_exteserv_nam_uix` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='built in and custom external services';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_external_services`
--

LOCK TABLES `mdl_external_services` WRITE;
/*!40000 ALTER TABLE `mdl_external_services` DISABLE KEYS */;
INSERT INTO `mdl_external_services` VALUES (1,'Moodle mobile web service',0,NULL,0,'moodle',1462257485,1462257600,'moodle_mobile_app',1,1);
/*!40000 ALTER TABLE `mdl_external_services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_external_services_functions`
--

DROP TABLE IF EXISTS `mdl_external_services_functions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_external_services_functions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `externalserviceid` bigint(10) NOT NULL,
  `functionname` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mdl_exteservfunc_ext_ix` (`externalserviceid`)
) ENGINE=InnoDB AUTO_INCREMENT=116 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='lists functions available in each service group';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_external_services_functions`
--

LOCK TABLES `mdl_external_services_functions` WRITE;
/*!40000 ALTER TABLE `mdl_external_services_functions` DISABLE KEYS */;
INSERT INTO `mdl_external_services_functions` VALUES (1,1,'moodle_enrol_get_users_courses'),(2,1,'moodle_enrol_get_enrolled_users'),(3,1,'moodle_user_get_users_by_id'),(4,1,'moodle_webservice_get_siteinfo'),(5,1,'moodle_notes_create_notes'),(6,1,'moodle_user_get_course_participants_by_id'),(7,1,'moodle_user_get_users_by_courseid'),(8,1,'moodle_message_send_instantmessages'),(9,1,'core_course_get_contents'),(10,1,'core_get_component_strings'),(11,1,'core_user_add_user_device'),(12,1,'core_calendar_get_calendar_events'),(13,1,'core_enrol_get_users_courses'),(14,1,'core_enrol_get_enrolled_users'),(15,1,'core_enrol_get_course_enrolment_methods'),(16,1,'enrol_self_enrol_user'),(17,1,'core_user_get_users_by_id'),(18,1,'core_webservice_get_site_info'),(19,1,'core_notes_create_notes'),(20,1,'core_user_get_course_user_profiles'),(21,1,'core_message_send_instant_messages'),(22,1,'mod_assign_get_grades'),(23,1,'mod_assign_get_assignments'),(24,1,'mod_assign_get_submissions'),(25,1,'mod_assign_get_user_flags'),(26,1,'mod_assign_set_user_flags'),(27,1,'mod_assign_get_user_mappings'),(28,1,'mod_assign_revert_submissions_to_draft'),(29,1,'mod_assign_lock_submissions'),(30,1,'mod_assign_unlock_submissions'),(31,1,'mod_assign_save_submission'),(32,1,'mod_assign_submit_for_grading'),(33,1,'mod_assign_save_grade'),(34,1,'mod_assign_save_user_extensions'),(35,1,'mod_assign_reveal_identities'),(36,1,'message_airnotifier_is_system_configured'),(37,1,'message_airnotifier_are_notification_preferences_configured'),(38,1,'core_grades_update_grades'),(39,1,'mod_forum_get_forums_by_courses'),(40,1,'mod_forum_get_forum_discussions_paginated'),(41,1,'mod_forum_get_forum_discussion_posts'),(42,1,'mod_forum_add_discussion_post'),(43,1,'mod_forum_add_discussion'),(44,1,'core_files_get_files'),(45,1,'core_message_get_messages'),(46,1,'core_message_create_contacts'),(47,1,'core_message_delete_contacts'),(48,1,'core_message_block_contacts'),(49,1,'core_message_unblock_contacts'),(50,1,'core_message_get_contacts'),(51,1,'core_message_search_contacts'),(52,1,'core_message_get_blocked_users'),(53,1,'gradereport_user_get_grades_table'),(54,1,'core_group_get_course_user_groups'),(55,1,'core_group_get_activity_allowed_groups'),(56,1,'core_group_get_activity_groupmode'),(57,1,'core_user_remove_user_device'),(58,1,'core_course_get_courses'),(59,1,'core_completion_update_activity_completion_status_manually'),(60,1,'core_completion_mark_course_self_completed'),(61,1,'mod_data_get_databases_by_courses'),(62,1,'core_comment_get_comments'),(63,1,'mod_forum_view_forum'),(64,1,'core_course_view_course'),(65,1,'core_course_search_courses'),(66,1,'core_course_get_course_module'),(67,1,'core_course_get_course_module_by_instance'),(68,1,'core_completion_get_activities_completion_status'),(69,1,'core_notes_get_course_notes'),(70,1,'core_completion_get_course_completion_status'),(71,1,'core_user_view_user_list'),(72,1,'core_message_mark_message_read'),(73,1,'core_notes_view_notes'),(74,1,'core_notes_delete_notes'),(75,1,'mod_forum_view_forum_discussion'),(76,1,'core_user_view_user_profile'),(77,1,'gradereport_user_view_grade_report'),(78,1,'core_rating_get_item_ratings'),(79,1,'mod_url_view_url'),(80,1,'core_user_get_users_by_field'),(81,1,'core_user_add_user_private_files'),(82,1,'mod_assign_view_grading_table'),(83,1,'mod_scorm_view_scorm'),(84,1,'mod_scorm_get_scorm_scoes'),(85,1,'mod_scorm_get_scorm_user_data'),(86,1,'mod_scorm_insert_scorm_tracks'),(87,1,'mod_scorm_get_scorm_sco_tracks'),(88,1,'mod_scorm_get_scorm_attempt_count'),(89,1,'mod_scorm_get_scorms_by_courses'),(90,1,'mod_survey_get_surveys_by_courses'),(91,1,'mod_survey_view_survey'),(92,1,'mod_survey_get_questions'),(93,1,'mod_survey_submit_answers'),(94,1,'mod_page_view_page'),(95,1,'mod_resource_view_resource'),(96,1,'mod_folder_view_folder'),(97,1,'mod_chat_login_user'),(98,1,'mod_chat_get_chat_users'),(99,1,'mod_chat_send_chat_message'),(100,1,'mod_chat_get_chat_latest_messages'),(101,1,'mod_chat_view_chat'),(102,1,'mod_chat_get_chats_by_courses'),(103,1,'mod_book_view_book'),(104,1,'mod_book_get_books_by_courses'),(105,1,'mod_choice_get_choice_results'),(106,1,'mod_choice_get_choice_options'),(107,1,'mod_choice_submit_choice_response'),(108,1,'mod_choice_view_choice'),(109,1,'mod_choice_get_choices_by_courses'),(110,1,'mod_choice_delete_choice_responses'),(111,1,'mod_lti_get_tool_launch_data'),(112,1,'mod_lti_get_ltis_by_courses'),(113,1,'mod_lti_view_lti'),(114,1,'mod_imscp_view_imscp'),(115,1,'mod_imscp_get_imscps_by_courses');
/*!40000 ALTER TABLE `mdl_external_services_functions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_external_services_users`
--

DROP TABLE IF EXISTS `mdl_external_services_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_external_services_users` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `externalserviceid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `iprestriction` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `validuntil` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_exteservuser_ext_ix` (`externalserviceid`),
  KEY `mdl_exteservuser_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='users allowed to use services with restricted users flag';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_external_services_users`
--

LOCK TABLES `mdl_external_services_users` WRITE;
/*!40000 ALTER TABLE `mdl_external_services_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_external_services_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_external_tokens`
--

DROP TABLE IF EXISTS `mdl_external_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_external_tokens` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `token` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tokentype` smallint(4) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `externalserviceid` bigint(10) NOT NULL,
  `sid` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contextid` bigint(10) NOT NULL,
  `creatorid` bigint(10) NOT NULL DEFAULT '1',
  `iprestriction` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `validuntil` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `lastaccess` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_extetoke_use_ix` (`userid`),
  KEY `mdl_extetoke_ext_ix` (`externalserviceid`),
  KEY `mdl_extetoke_con_ix` (`contextid`),
  KEY `mdl_extetoke_cre_ix` (`creatorid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Security tokens for accessing of external services';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_external_tokens`
--

LOCK TABLES `mdl_external_tokens` WRITE;
/*!40000 ALTER TABLE `mdl_external_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_external_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_feedback`
--

DROP TABLE IF EXISTS `mdl_feedback`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_feedback` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8_unicode_ci NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `anonymous` tinyint(1) NOT NULL DEFAULT '1',
  `email_notification` tinyint(1) NOT NULL DEFAULT '1',
  `multiple_submit` tinyint(1) NOT NULL DEFAULT '1',
  `autonumbering` tinyint(1) NOT NULL DEFAULT '1',
  `site_after_submit` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `page_after_submit` longtext COLLATE utf8_unicode_ci NOT NULL,
  `page_after_submitformat` tinyint(2) NOT NULL DEFAULT '0',
  `publish_stats` tinyint(1) NOT NULL DEFAULT '0',
  `timeopen` bigint(10) NOT NULL DEFAULT '0',
  `timeclose` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `completionsubmit` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_feed_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='all feedbacks';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_feedback`
--

LOCK TABLES `mdl_feedback` WRITE;
/*!40000 ALTER TABLE `mdl_feedback` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_feedback` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_feedback_completed`
--

DROP TABLE IF EXISTS `mdl_feedback_completed`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_feedback_completed` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `feedback` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `random_response` bigint(10) NOT NULL DEFAULT '0',
  `anonymous_response` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_feedcomp_use_ix` (`userid`),
  KEY `mdl_feedcomp_fee_ix` (`feedback`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='filled out feedback';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_feedback_completed`
--

LOCK TABLES `mdl_feedback_completed` WRITE;
/*!40000 ALTER TABLE `mdl_feedback_completed` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_feedback_completed` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_feedback_completedtmp`
--

DROP TABLE IF EXISTS `mdl_feedback_completedtmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_feedback_completedtmp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `feedback` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `guestid` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `random_response` bigint(10) NOT NULL DEFAULT '0',
  `anonymous_response` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_feedcomp_use2_ix` (`userid`),
  KEY `mdl_feedcomp_fee2_ix` (`feedback`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='filled out feedback';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_feedback_completedtmp`
--

LOCK TABLES `mdl_feedback_completedtmp` WRITE;
/*!40000 ALTER TABLE `mdl_feedback_completedtmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_feedback_completedtmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_feedback_item`
--

DROP TABLE IF EXISTS `mdl_feedback_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_feedback_item` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `feedback` bigint(10) NOT NULL DEFAULT '0',
  `template` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `label` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `presentation` longtext COLLATE utf8_unicode_ci NOT NULL,
  `typ` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `hasvalue` tinyint(1) NOT NULL DEFAULT '0',
  `position` smallint(3) NOT NULL DEFAULT '0',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `dependitem` bigint(10) NOT NULL DEFAULT '0',
  `dependvalue` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `options` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mdl_feeditem_fee_ix` (`feedback`),
  KEY `mdl_feeditem_tem_ix` (`template`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='feedback_items';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_feedback_item`
--

LOCK TABLES `mdl_feedback_item` WRITE;
/*!40000 ALTER TABLE `mdl_feedback_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_feedback_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_feedback_sitecourse_map`
--

DROP TABLE IF EXISTS `mdl_feedback_sitecourse_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_feedback_sitecourse_map` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `feedbackid` bigint(10) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_feedsitemap_cou_ix` (`courseid`),
  KEY `mdl_feedsitemap_fee_ix` (`feedbackid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='feedback sitecourse map';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_feedback_sitecourse_map`
--

LOCK TABLES `mdl_feedback_sitecourse_map` WRITE;
/*!40000 ALTER TABLE `mdl_feedback_sitecourse_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_feedback_sitecourse_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_feedback_template`
--

DROP TABLE IF EXISTS `mdl_feedback_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_feedback_template` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `ispublic` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mdl_feedtemp_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='templates of feedbackstructures';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_feedback_template`
--

LOCK TABLES `mdl_feedback_template` WRITE;
/*!40000 ALTER TABLE `mdl_feedback_template` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_feedback_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_feedback_tracking`
--

DROP TABLE IF EXISTS `mdl_feedback_tracking`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_feedback_tracking` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `feedback` bigint(10) NOT NULL DEFAULT '0',
  `completed` bigint(10) NOT NULL DEFAULT '0',
  `tmp_completed` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_feedtrac_use_ix` (`userid`),
  KEY `mdl_feedtrac_fee_ix` (`feedback`),
  KEY `mdl_feedtrac_com_ix` (`completed`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='feedback trackingdata';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_feedback_tracking`
--

LOCK TABLES `mdl_feedback_tracking` WRITE;
/*!40000 ALTER TABLE `mdl_feedback_tracking` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_feedback_tracking` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_feedback_value`
--

DROP TABLE IF EXISTS `mdl_feedback_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_feedback_value` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course_id` bigint(10) NOT NULL DEFAULT '0',
  `item` bigint(10) NOT NULL DEFAULT '0',
  `completed` bigint(10) NOT NULL DEFAULT '0',
  `tmp_completed` bigint(10) NOT NULL DEFAULT '0',
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_feedvalu_cou_ix` (`course_id`),
  KEY `mdl_feedvalu_ite_ix` (`item`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='values of the completeds';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_feedback_value`
--

LOCK TABLES `mdl_feedback_value` WRITE;
/*!40000 ALTER TABLE `mdl_feedback_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_feedback_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_feedback_valuetmp`
--

DROP TABLE IF EXISTS `mdl_feedback_valuetmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_feedback_valuetmp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course_id` bigint(10) NOT NULL DEFAULT '0',
  `item` bigint(10) NOT NULL DEFAULT '0',
  `completed` bigint(10) NOT NULL DEFAULT '0',
  `tmp_completed` bigint(10) NOT NULL DEFAULT '0',
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_feedvalu_cou2_ix` (`course_id`),
  KEY `mdl_feedvalu_ite2_ix` (`item`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='values of the completedstmp';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_feedback_valuetmp`
--

LOCK TABLES `mdl_feedback_valuetmp` WRITE;
/*!40000 ALTER TABLE `mdl_feedback_valuetmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_feedback_valuetmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_files`
--

DROP TABLE IF EXISTS `mdl_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_files` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contenthash` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `pathnamehash` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contextid` bigint(10) NOT NULL,
  `component` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `filearea` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL,
  `filepath` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `filename` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `userid` bigint(10) DEFAULT NULL,
  `filesize` bigint(10) NOT NULL,
  `mimetype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` bigint(10) NOT NULL DEFAULT '0',
  `source` longtext COLLATE utf8_unicode_ci,
  `author` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `license` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `referencefileid` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_file_pat_uix` (`pathnamehash`),
  KEY `mdl_file_comfilconite_ix` (`component`,`filearea`,`contextid`,`itemid`),
  KEY `mdl_file_con_ix` (`contenthash`),
  KEY `mdl_file_con2_ix` (`contextid`),
  KEY `mdl_file_use_ix` (`userid`),
  KEY `mdl_file_ref_ix` (`referencefileid`)
) ENGINE=InnoDB AUTO_INCREMENT=11687 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='description of files, content is stored in sha1 file pool';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_files`
--

LOCK TABLES `mdl_files` WRITE;
/*!40000 ALTER TABLE `mdl_files` DISABLE KEYS */;
INSERT INTO `mdl_files` VALUES (1,'41cfeee5884a43a4650a851f4f85e7b28316fcc9','a48e186a2cc853a9e94e9305f4e9bc086391212d',1,'theme_more','backgroundimage',0,'/','background.jpg',2,4451,'image/jpeg',0,NULL,NULL,NULL,1462257554,1462257554,0,NULL),(2,'da39a3ee5e6b4b0d3255bfef95601890afd80709','d1da7ab1bb9c08a926037367bf8ce9a838034ead',1,'theme_more','backgroundimage',0,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462257554,1462257554,0,NULL),(3,'fb262df98d67c4e2a5c9802403821e00cf2992af','508e674d49c30d4fde325fe6c7f6fd3d56b247e1',1,'assignfeedback_editpdf','stamps',0,'/','smile.png',2,1600,'image/png',0,NULL,NULL,NULL,1462257555,1462257555,0,NULL),(4,'da39a3ee5e6b4b0d3255bfef95601890afd80709','70b7cdade7b4e27d4e83f0cdaad10d6a3c0cccb5',1,'assignfeedback_editpdf','stamps',0,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462257555,1462257555,0,NULL),(5,'a4f146f120e7e00d21291b924e26aaabe9f4297a','68317eab56c67d32aeaee5acf509a0c4aa828b6b',1,'assignfeedback_editpdf','stamps',0,'/','sad.png',2,1702,'image/png',0,NULL,NULL,NULL,1462257555,1462257555,0,NULL),(6,'33957e31ba9c763a74638b825f0a9154acf475e1','695a55ff780e61c9e59428aa425430b0d6bde53b',1,'assignfeedback_editpdf','stamps',0,'/','tick.png',2,1187,'image/png',0,NULL,NULL,NULL,1462257555,1462257555,0,NULL),(7,'d613d55f37bb76d38d4ffb4b7b83e6c694778c30','373e63af262a9b8466ba8632551520be793c37ff',1,'assignfeedback_editpdf','stamps',0,'/','cross.png',2,1230,'image/png',0,NULL,NULL,NULL,1462257555,1462257555,0,NULL),(8,'57364dfe033e61a122409fca8fff131851d85f61','520e3429c3739fd2b2a93394fb2862a03c4775e8',5,'user','draft',405829500,'/','Scavenger_Hunt.zip',2,7460988,'application/zip',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:18:\"Scavenger_Hunt.zip\";}','Admin User','allrightsreserved',1462457889,1462457889,0,NULL),(9,'da39a3ee5e6b4b0d3255bfef95601890afd80709','52a6d1b15e1fa0fb172c5ef61e3851ca4b81b65e',5,'user','draft',405829500,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462457889,1462457889,0,NULL),(12,'cc65d61810bae1591d3dd488bb8ced2b6e7e9ac8','b96cc55c78c6e82bf994f6166532b05f52a572d4',30,'mod_scorm','content',0,'/story_content/','thumbnail.jpg',NULL,10656,'image/jpeg',0,NULL,NULL,NULL,1462458050,1462458050,0,NULL),(13,'da39a3ee5e6b4b0d3255bfef95601890afd80709','a2446fe6f446ce98c5c705a72e69af9bf71d297b',30,'mod_scorm','content',0,'/story_content/','.',NULL,0,NULL,0,NULL,NULL,NULL,1462458050,1462458050,0,NULL),(14,'da39a3ee5e6b4b0d3255bfef95601890afd80709','c604e7e08b9a90392fbfc6de9b144a661e0e3a0b',30,'mod_scorm','content',0,'/','.',NULL,0,NULL,0,NULL,NULL,NULL,1462458050,1462458050,0,NULL),(15,'8983b462e89748abf8ceb31571c5cdbc986f57d6','d55f7e55e60b1d42472c05357be1b217f83ef1b8',30,'mod_scorm','content',0,'/','meta.xml',NULL,770,'application/xml',0,NULL,NULL,NULL,1462458050,1462458050,0,NULL),(16,'ba082c0b83df72d31144e5724e2b250eeaa4c99c','fb574d190ea0ede79c529e7045a2c93d0ab70535',30,'mod_scorm','content',0,'/story_content/','frame.xml',NULL,26318,'application/xml',0,NULL,NULL,NULL,1462458050,1462458050,0,NULL),(17,'319cdaf30a848b19f1309b6779302c6036dd7595','9dc3de8e14493cfb377b1952d10fdcc6b0ed6bc5',30,'mod_scorm','content',0,'/story_content/','frame.js',NULL,16944,'application/x-javascript',0,NULL,NULL,NULL,1462458050,1462458050,0,NULL),(18,'c6cc03a4c6ee98abcb81d7dcd0e723d8e34f7f1a','3128b40863a0d7a742465a0885fafc04b6c42b09',30,'mod_scorm','content',0,'/story_content/','user.js',NULL,30,'application/x-javascript',0,NULL,NULL,NULL,1462458050,1462458050,0,NULL),(19,'3f7b1c9832640d709ca955a6f638bd4203bcf6c4','f917a6d4b9e2ae2e926931622998448f6fe94fb0',30,'mod_scorm','content',0,'/mobile/','app_store.png',NULL,4587,'image/png',0,NULL,NULL,NULL,1462458050,1462458050,0,NULL),(20,'da39a3ee5e6b4b0d3255bfef95601890afd80709','153f0a8e0dcfb32c103b7959ad75d5ae73d51735',30,'mod_scorm','content',0,'/mobile/','.',NULL,0,NULL,0,NULL,NULL,NULL,1462458050,1462458050,0,NULL),(21,'8574782cf40d97051befab6af065a2557ee16475','955a3e3b123cae250a1c143a60a6ad852431ab03',30,'mod_scorm','content',0,'/mobile/','mobile_icon.png',NULL,9726,'image/png',0,NULL,NULL,NULL,1462458050,1462458050,0,NULL),(22,'52c09f553fe9ad08c63636cf8ed59bd28919ef3b','b5267fd28e5e4afd27ee66b6eb32ffaa6608f434',30,'mod_scorm','content',0,'/mobile/','linen_background.jpg',NULL,606,'image/jpeg',0,NULL,NULL,NULL,1462458050,1462458050,0,NULL),(23,'1b0bc2712eab97692a1717c5df60188d71f8e645','6ff1a5a636c08a5b276afc16da55c5dd75e1e3ba',30,'mod_scorm','content',0,'/','story_unsupported.html',NULL,366,'text/html',0,NULL,NULL,NULL,1462458050,1462458050,0,NULL),(24,'2f8900cc0ffc1c8dfcb1de49b2b650cd1806408f','888ac402e3947db8e0c190891014c1fd1f0e128d',30,'mod_scorm','content',0,'/mobile/','player.css',NULL,69936,'text/css',0,NULL,NULL,NULL,1462458050,1462458050,0,NULL),(25,'d56ec6538d5ba6cf5ce7d0d9f56205583c38ee1d','8af77a85bc38fa1da919d737c3a172f08a004d26',30,'mod_scorm','content',0,'/mobile/','player_compiled.js',NULL,882853,'application/x-javascript',0,NULL,NULL,NULL,1462458050,1462458050,0,NULL),(26,'28f26e14f1907930eb8df6c5b0fbc8427e48676c','01d82441c3261896a93efb94ae2d21c546a6b1e8',30,'mod_scorm','content',0,'/story_content/','FontFactory.swf',NULL,24082,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458050,1462458050,0,NULL),(27,'d1ccdfb6601029056e5007b9adbe39ba305e2b58','264870b5112e8b96c873721223b1d2bd775cf2a5',30,'mod_scorm','content',0,'/story_content/','fonts.swf',NULL,8730,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(28,'53dcea117c084182a1f664dbb47c341124000cca','e5be48e0da7c684b1a48ff66af628e6339c187bf',30,'mod_scorm','content',0,'/story_content/','fonts.xml',NULL,14677,'application/xml',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(29,'a2611a0356ee8eef62c7c6f878e5ef8f926c1d44','09389e5e49947e69973f23a3377e4012b5a50f56',30,'mod_scorm','content',0,'/mobile/','fonts.js',NULL,17241,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(30,'a697b1306cf5ff1db534904cb3c04d151d448c1d','9f9e0b772b44967f16d37f0cda39c2c22bc6d5b2',30,'mod_scorm','content',0,'/','story.swf',NULL,388040,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(31,'de729b2ef0af58c6db478f6e8b81913fa075692f','47cc90daf177bcddb3dd32ae1bfddf996b5749cc',30,'mod_scorm','content',0,'/story_content/','frame.swf',NULL,110825,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(32,'1f151ee895c7772a7008485d5393917d267abc15','83d01a4661ba4006cbd79b5ef49bb53eea9f4494',30,'mod_scorm','content',0,'/story_content/slides/','5WDTsPU3sY7.swf',NULL,2230,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(33,'da39a3ee5e6b4b0d3255bfef95601890afd80709','2497a67b505a970b8d264b29fd8c24f08d31f674',30,'mod_scorm','content',0,'/story_content/slides/','.',NULL,0,NULL,0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(34,'81c8308d6307d7ac0ac63608b149251e9c6b9887','bc429db05655f44a72f4f3f204ffc531a6d2cc1e',30,'mod_scorm','content',0,'/story_content/slides/','6E7Co0M8Hdd.swf',NULL,2180,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(35,'a2b4e348f99a897127d0912534d207216f50f19b','d696627e8a8926ff5b42a658e7eb4c91a445b9f2',30,'mod_scorm','content',0,'/mobile/slides/','5WDTsPU3sY7.gz',NULL,1949,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(36,'da39a3ee5e6b4b0d3255bfef95601890afd80709','78a43d76bc7aae165c15fcdedfe437209e5e2bef',30,'mod_scorm','content',0,'/mobile/slides/','.',NULL,0,NULL,0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(37,'ebe5d638380a0c49c675892205d108c5321a9926','5c635d4475541eb1b1db58d9fc5f6bf303f1d073',30,'mod_scorm','content',0,'/mobile/slides/','6E7Co0M8Hdd.gz',NULL,1903,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(38,'0121e2d2f0200a904fddff426aa529845ba44897','5fa7be1e9b2aa9d96a86ecd3f8dff5b61907315e',30,'mod_scorm','content',0,'/mobile/slides/','6E7Co0M8Hdd.js',NULL,8858,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(39,'9990506ca0e29c3beac6a7e4b415755ebc975f3b','6c407d507eddacc847b2c0f888a73452acd4f8b8',30,'mod_scorm','content',0,'/mobile/slides/','5WDTsPU3sY7.js',NULL,7614,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(40,'fe1660c7904127b162e883d9ff4375bd407514b6','e134d9193ce99f54f13f3492e3c36af79e644267',30,'mod_scorm','content',0,'/story_content/slides/','5YTcbU7HjCc.swf',NULL,3830,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(41,'38b6142a1cb8193602c8d01a278e1aa3ca2cb400','fad71bd49f1695ccf69b35b56a9d8463af1cbd66',30,'mod_scorm','content',0,'/story_content/slides/','6c1IgjY08V1.swf',NULL,3847,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(42,'167bba0014319372d486af1064c594ce4ce4e63f','13ab55d1aa0528acf0b68e428d7db7cc2e7234d8',30,'mod_scorm','content',0,'/mobile/slides/','5YTcbU7HjCc.gz',NULL,3538,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(43,'dd877d4ef2359c1ad8fe8a5e16d9528618f1fa17','e2c5907a3751a000b2c06f4ba7ef971019c39be8',30,'mod_scorm','content',0,'/story_content/slides/','66hRApKTxJe.swf',NULL,3839,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(44,'e777138d26fd5219ca63d627d7dc4320dd407072','f4340f94880de6f6f9c848c2d95d10c067dda64f',30,'mod_scorm','content',0,'/story_content/slides/','66JicJLn69T.swf',NULL,3849,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(45,'03ab58a6aa0f24a0747f2326a997d8c80d6fc1cf','3828e687e8a58a70dd9e55b9a73cd26da5036362',30,'mod_scorm','content',0,'/mobile/slides/','6c1IgjY08V1.gz',NULL,3555,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(46,'bb0707bc4fc721fdda970ec6050217ec2ca33b2e','dddd461af95e6533ee7dd52227cda7256b88686f',30,'mod_scorm','content',0,'/mobile/slides/','66JicJLn69T.gz',NULL,3554,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(47,'b2d561d41b4ed44172e1f329e44711edb0e5f3e0','1043c3f725d19cd8ba04c4e43160f58aada88bad',30,'mod_scorm','content',0,'/mobile/slides/','66hRApKTxJe.gz',NULL,3549,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(48,'dfccd6462c7eeb80ac4125f69885e04ea630e9fe','c1766b4186769153872b3d567ad4081081d601f3',30,'mod_scorm','content',0,'/mobile/slides/','66hRApKTxJe.js',NULL,17560,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(49,'0070359010b2969d1b68500eb876600bbfb58173','c6755d6ba6db6ef51876abee7e077aee01a1bb1b',30,'mod_scorm','content',0,'/mobile/slides/','66JicJLn69T.js',NULL,17558,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(50,'40b412a4dac848bd12038b45694667eb165a9c87','f58564b578d026cd7e65178061d867b23ce1ba40',30,'mod_scorm','content',0,'/mobile/slides/','6c1IgjY08V1.js',NULL,17568,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(51,'f691cab99479f3366c79f3c92567f1f45612a1ff','9957207002b685693240def3e1a36a7cdfd544a2',30,'mod_scorm','content',0,'/mobile/slides/','5YTcbU7HjCc.js',NULL,17544,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(52,'652a5d844fc41220044b9525c2614448d2de9695','51f45117d84503cce6773154e0692b2efeec8954',30,'mod_scorm','content',0,'/story_content/slides/','6k20a7qJqE4.swf',NULL,3838,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(53,'8409ef0f08ab784ba2865f93d8bb05ce46d5ce57','c51d78baa8595dd070388ce04a9722a02e357dcf',30,'mod_scorm','content',0,'/story_content/slides/','6ZGbkjA9bts.swf',NULL,3842,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(54,'1575f4d6128a9258ac5c9f9cfef353bc1abfb8a6','57498c5bbc44cfe1ddb4d35a7bd7007e9df99a00',30,'mod_scorm','content',0,'/story_content/slides/','5za88QxsUb6.swf',NULL,3840,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(55,'f17aee29223471eea14908fc66f2ef437837a369','20fb6ef5f3e1a1940133994e41ddcc3eff70b0dd',30,'mod_scorm','content',0,'/mobile/slides/','6ZGbkjA9bts.gz',NULL,3550,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(56,'e196cd8f1076846b32398f676d0cfce80a812dfa','3485aa771245c19964922fdabdc8ae660b546cff',30,'mod_scorm','content',0,'/mobile/slides/','5za88QxsUb6.gz',NULL,3547,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(57,'5a21d7127e49d8f5d1a304e439f07fda8615ee8a','978b9f8bcd20cd6f45bfae75c206b83563d68258',30,'mod_scorm','content',0,'/story_content/slides/','6HcattBsmAb.swf',NULL,3827,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(58,'327e30b8826567a84b90b4d7f546a1dc1d568cfb','e2be7dafa8d242314b0b7463516040e029d3286a',30,'mod_scorm','content',0,'/mobile/slides/','6k20a7qJqE4.gz',NULL,3545,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(59,'4b6af262a31a882f87a451c5e3b156e7e246479c','66f13ebcd4cbddc525f506a9d209080522da8c82',30,'mod_scorm','content',0,'/mobile/slides/','6HcattBsmAb.gz',NULL,3533,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(60,'6ff85560d7280e9d7153e73889240f5c23d79845','6d8d2f2468e6b07eaa3edade1e308312fb9abe4f',30,'mod_scorm','content',0,'/mobile/slides/','6ZGbkjA9bts.js',NULL,17557,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(61,'a90b5ffa969fd2bed40286ae88b209846be0f334','310c3c4ad5f5fe94bfcbeebe1988739fedf04316',30,'mod_scorm','content',0,'/mobile/slides/','5za88QxsUb6.js',NULL,17549,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(62,'53f0b14cebad148dc5f0655a66f96155313366ba','87d80d7d8b141252d655d0ca8896569e15ff3c10',30,'mod_scorm','content',0,'/mobile/slides/','6HcattBsmAb.js',NULL,17544,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(63,'baa956a6307f64e9277e5942cd90580affba4986','0bf1f73c056b7bf66e57e5c3592fb692ac9fa887',30,'mod_scorm','content',0,'/story_content/slides/','5dJYKEWa0BW.swf',NULL,3856,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(64,'7917ccdc5b09d6d129425d1fbc5a18b832cebb7d','a612629d10caae71c032411befb125ac00ce7567',30,'mod_scorm','content',0,'/story_content/slides/','6jch4g9mwpg.swf',NULL,3855,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(65,'6ab3a0b503fafff784524f3780789716575b334d','bf5dd915a9235fb29fe658d4235352f20662d65d',30,'mod_scorm','content',0,'/mobile/slides/','6k20a7qJqE4.js',NULL,17554,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(66,'238d13b22f478bef6e41a621dcd9e757f1151939','234e40d468da3da648a001cd1d87fd88237f5fe8',30,'mod_scorm','content',0,'/mobile/slides/','5dJYKEWa0BW.gz',NULL,3564,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(67,'91055c1e3a2b42b0cae4be6808eece1551fe0488','63c6d9eb250c47e0528fbe5fe0eb8a1c4ca642cc',30,'mod_scorm','content',0,'/mobile/slides/','6jch4g9mwpg.gz',NULL,3562,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(68,'e6a87e136ce15d46d2d544952764b537face1eda','0ad854c7b8016850a8a6e8b9268cc9663c583c65',30,'mod_scorm','content',0,'/story_content/slides/','66NynDIc8nu.swf',NULL,3821,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(69,'6531feb7da946f7cffea76b0ede414ef201b3479','a58558bd3108c3b11506b224e061cd15ff22c9f0',30,'mod_scorm','content',0,'/mobile/slides/','66NynDIc8nu.gz',NULL,3528,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(70,'ba318c982162a6367c27878739b7796aa20f3eb3','88446ae4683f0dfed4f1133ae23d3537ecee5c45',30,'mod_scorm','content',0,'/story_content/slides/','6HtlWbVowge.swf',NULL,3854,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(71,'f397e75c98b110c877e0f99b3c8af9b86778f033','220aeaf64f7598b0da194eaef311d065793264bd',30,'mod_scorm','content',0,'/mobile/slides/','6HtlWbVowge.gz',NULL,3564,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(72,'547f76e99e9c5ea6993f08a5b91067c9cc07e8b5','806b48c073320fc4303d773d524a663ee9ff5560',30,'mod_scorm','content',0,'/mobile/slides/','5dJYKEWa0BW.js',NULL,17585,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(73,'dcec22fd48241fb15870ed66dd6852fc0694dd7a','1f0e23a67246f1be546d8b9a1b1b1fe93eba429e',30,'mod_scorm','content',0,'/mobile/slides/','6jch4g9mwpg.js',NULL,17577,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(74,'d4b01821fec84c5c1742b00a4f7a56fb0c73a5c8','5008e0fb97db5f887b5754af8fe8f26864aadb5e',30,'mod_scorm','content',0,'/mobile/slides/','66NynDIc8nu.js',NULL,17543,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(75,'e9d61c4c481a5290d6f2c07ee783bb8eb7a60db0','a139c39528b3e73881601367f17da6887df7b1e1',30,'mod_scorm','content',0,'/story_content/slides/','6prQPQLWT87.swf',NULL,3851,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(76,'1696750ccba8e660a45f21762dce44dfc728a3b4','4b41f444903b82de6b8372520c9eb3c32d90c010',30,'mod_scorm','content',0,'/story_content/slides/','5bJGUQRawFW.swf',NULL,3840,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(77,'0f346cc0de92cfbd2f7fb48dcd998ed9641a4827','05269480949def4ecbc840b6b8721d801ef4222c',30,'mod_scorm','content',0,'/mobile/slides/','6prQPQLWT87.gz',NULL,3558,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(78,'79e400c4dfea9a21bdb725eeeb7734d76356f43e','845dc6718f7309bf2ba0ecd8f7c45925f8681113',30,'mod_scorm','content',0,'/mobile/slides/','5bJGUQRawFW.gz',NULL,3546,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(79,'ceac8d9f84f239dd657796f9cf116fc72438fea4','385f250fff077a44e48bb4a97feaad4731245103',30,'mod_scorm','content',0,'/story_content/slides/','6mzhLwhD3sB.swf',NULL,3837,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(80,'6cc652b5e410bde6763abce83bbe791a5810aec7','b130c89690799ff5aa50c87b3e0262e24ac788bd',30,'mod_scorm','content',0,'/mobile/slides/','6mzhLwhD3sB.gz',NULL,3544,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(81,'a99b77eedfd9eabae5afd1ccc34464d1b5c365b9','d97a5391bed646d03ed46d129db17ece965716be',30,'mod_scorm','content',0,'/mobile/slides/','6HtlWbVowge.js',NULL,17580,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(82,'3b41ec24719e1ac70d5419c53be4027ad9237e57','2e24ed9f7b396645c38e7d699a6347a57f03330e',30,'mod_scorm','content',0,'/story_content/slides/','6BiaUipA8jl.swf',NULL,3837,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(83,'32c1c61748dc1a3edcd43bd98a24fedc10a1d483','4e06d632332f06b14af778b2c18b1562ef6ae7a3',30,'mod_scorm','content',0,'/mobile/slides/','6BiaUipA8jl.gz',NULL,3545,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(84,'45416fb8f3196ebf5e5f4b7072bdd6a6649107aa','868f52cb2f2a2d20f6454933f740b3f39a3a1a46',30,'mod_scorm','content',0,'/mobile/slides/','6prQPQLWT87.js',NULL,17565,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(85,'b61b456b3214d398d1ccd7cb584d54cbfaaf12e1','df9ad284ae805341ed396ef96baf2e223216c06f',30,'mod_scorm','content',0,'/mobile/slides/','5bJGUQRawFW.js',NULL,17551,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(86,'c436b054086cf1c9c15568dd464ea08ffb522750','a4d22593196d5705871af4f5db069e45d3b3275b',30,'mod_scorm','content',0,'/mobile/slides/','6mzhLwhD3sB.js',NULL,17563,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(87,'058c9a14e59b4e23c64e71f639dd2b2d8892f839','4e92b908baef512c843d611b2bec4ba2eaf9e802',30,'mod_scorm','content',0,'/story_content/slides/','5hS2gNfdUrx.swf',NULL,3853,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(88,'4c261246e57c8a7d10e92dbc8ab30ee3f191b136','ac26b8558550a326e7e5a4fc8b0423ae21684499',30,'mod_scorm','content',0,'/story_content/slides/','657qiziqAk5.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(89,'1d112fd4a73156bcd0572d0779855018d07d49f7','f06d342b55cb12f37e3910cc9d02f8feda802ed4',30,'mod_scorm','content',0,'/mobile/slides/','5hS2gNfdUrx.gz',NULL,3559,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(90,'683965a89062a3acad6c30dd2f9fc8e50751b1d4','3ac4958f8a80cc2cd68421df34a0a4205dec01e7',30,'mod_scorm','content',0,'/story_content/slides/','6ijOdRGFo4a.swf',NULL,3820,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(91,'7188317b66e51752d24e92833c88e921c25cf5cd','920bee1e7eb3bcd5611622fb70f2eddf8b70fcbc',30,'mod_scorm','content',0,'/mobile/slides/','657qiziqAk5.gz',NULL,3557,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(92,'6fdfddb6fe190bfd639aff7d0da457e760cefee1','69cab914320ec3d983cb7e699d94c35cdc1da6ea',30,'mod_scorm','content',0,'/mobile/slides/','6ijOdRGFo4a.gz',NULL,3528,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(93,'1d798bc690ba70df75ee61241dd3c8dd1911903e','7661260817f757d78c319a9147048a200c5782aa',30,'mod_scorm','content',0,'/mobile/slides/','6BiaUipA8jl.js',NULL,17561,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(94,'478cfb8a82ebdb6900415eb1cb3f22ab797ae105','67cf1d304e23160578535aa68302a2507e8f73cf',30,'mod_scorm','content',0,'/story_content/slides/','6JVknDz3aRB.swf',NULL,3840,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(95,'ad8969c45c51c9e7b5c2693b6774224101625ec5','2ceaff4cf64bb80b28c8331217b4487f7564ca50',30,'mod_scorm','content',0,'/mobile/slides/','6JVknDz3aRB.gz',NULL,3547,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(96,'ef3b7ace928258fefcbdcef462ba5e285a7599a9','833a8cc9b8d7070edb2f024043f12fa76165b631',30,'mod_scorm','content',0,'/mobile/slides/','5hS2gNfdUrx.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(97,'7288b4877d3cd5f5e9db77f0da69924acb212a1c','5f373be72accd46d9b2d5869ed6b0881c2e00eec',30,'mod_scorm','content',0,'/mobile/slides/','657qiziqAk5.js',NULL,17565,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(98,'3acf02959e79d9cfdbb94377f90461f1a282af1e','920fc8633a221c317355c6b7d520a2002d8526af',30,'mod_scorm','content',0,'/story_content/slides/','5jrDaEHgLvG.swf',NULL,3847,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(99,'89b68be82f9288ae51aceb26c131ff3f4a7f8ee0','73851801cb1f34eb171313458cb603d1ae079321',30,'mod_scorm','content',0,'/mobile/slides/','6ijOdRGFo4a.js',NULL,17542,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(100,'93752167ba6870c31619bb7bf5c082e34c242161','068d53c11b338e26feb4c82f302b16728b2b28b3',30,'mod_scorm','content',0,'/mobile/slides/','5jrDaEHgLvG.gz',NULL,3555,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(101,'e70492f0fb3cbe4bd7e2f3835544a7e58d428257','846095533fa12e9fbead1a94e4fda57176e15261',30,'mod_scorm','content',0,'/story_content/slides/','6I1oWPwjGhC.swf',NULL,3839,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(102,'c5ba1b5b6bbd0249d93bb829e6e43c650b159121','2b2233f5a9d7f68e177f609f23e56f5f21302ba1',30,'mod_scorm','content',0,'/mobile/slides/','6I1oWPwjGhC.gz',NULL,3545,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(103,'da178ed0462a54caf72ede12d3ab962e80e15883','06ef6982cc11b1890e9b14a48df3b2e0e85cd1e6',30,'mod_scorm','content',0,'/mobile/slides/','6JVknDz3aRB.js',NULL,17555,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(104,'dfb3e15ea767794b3e4e166be0555b58a9acc9c5','e69ec4e2bc25718ca23f785d6caa8fe8d085ada5',30,'mod_scorm','content',0,'/story_content/slides/','5txGmXUZWlK.swf',NULL,3835,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(105,'6f661715cd55ff074cd79a25a8f73442bc684874','1c279c1e0cba164bef896805336ab1b05fee84cb',30,'mod_scorm','content',0,'/mobile/slides/','5txGmXUZWlK.gz',NULL,3540,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(106,'5931f615e21f46095b51c9d42efe374f0d41c220','169d3ba4569a20490063c35b8641a2b3a7b36ed4',30,'mod_scorm','content',0,'/story_content/slides/','65RabatkkZQ.swf',NULL,3849,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(107,'76da19680c19fe229566dbb7c3b564ea593b6d0d','3fca208248201bfc6d2c65bd6aba44e77a74e2d1',30,'mod_scorm','content',0,'/mobile/slides/','5jrDaEHgLvG.js',NULL,17552,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(108,'80afed9d8bb6912e5151a0275740566a074f1d42','096bdbd3d2fc13eb50dd4c3667270d046b23b455',30,'mod_scorm','content',0,'/mobile/slides/','65RabatkkZQ.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(109,'4f24c951ffced4675de95bbc6b5bd31f35d320c0','7c41f5e6aff40f14a7a3b68b5bc75d7d0b8a5eb3',30,'mod_scorm','content',0,'/mobile/slides/','6I1oWPwjGhC.js',NULL,17547,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(110,'2d04acc55c6695b56c98ca303a7b9ea6b1d777e4','7fc5b85f65d68d3d99c0d735fd355ed0dee9fa4b',30,'mod_scorm','content',0,'/story_content/slides/','62EN4tBv0PE.swf',NULL,3845,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(111,'34594bf7cdf539a170505c9f71db0f7be9fee635','279c138dcce704412953593f9f81341e75f69e7d',30,'mod_scorm','content',0,'/mobile/slides/','62EN4tBv0PE.gz',NULL,3553,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(112,'28754446eb0022be623cac06f7073a5f373dae24','035df56b923468c4771e35a3a9173209956335a3',30,'mod_scorm','content',0,'/story_content/slides/','6LFuS7yilXm.swf',NULL,3849,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(113,'224716510c68b99a104ad4f85d232f033cc0446c','9b49af6374eac29db0dfb722e383a055cc4635e6',30,'mod_scorm','content',0,'/mobile/slides/','6LFuS7yilXm.gz',NULL,3554,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(114,'5cc1909a7981812fbfde054152e2f2b6e5cbd28f','6b9e9d94dfec1f3e86243943b5fa9283030fb1b8',30,'mod_scorm','content',0,'/mobile/slides/','5txGmXUZWlK.js',NULL,17565,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(115,'666e5843986a5d439f0c9ad9698d0c9eb3024620','f2b2bdc331e968464736eb34b15c2eef836c81fd',30,'mod_scorm','content',0,'/mobile/slides/','65RabatkkZQ.js',NULL,17573,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(116,'ecad7257268e5708e96c6b535cfd63e2247cde52','39400b82adfd7d0322bb7dcd8e16f4b88bf3dcfb',30,'mod_scorm','content',0,'/story_content/slides/','5ZcN5onhbE8.swf',NULL,3837,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(117,'15407bd14f2a0e255553064d3430d1a54452ba0e','271a68092242a11553a78e60498f9d79b04b73b9',30,'mod_scorm','content',0,'/mobile/slides/','5ZcN5onhbE8.gz',NULL,3543,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(118,'9e9638c2fc3e83edb725f686ec0e3428d0529ca2','0cfc235e0f4cbb5f93826ca3f718f644fb396356',30,'mod_scorm','content',0,'/mobile/slides/','62EN4tBv0PE.js',NULL,17560,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(119,'4000bbd34e87f6c238f0ac599eaf1be64490c2db','081ac168f009d0d0b48d41832cb70dce82ee6207',30,'mod_scorm','content',0,'/story_content/slides/','6V69PJC6jtr.swf',NULL,3877,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(120,'d8617ae20e95b6c10c12ba7c77358d9d14ef12b0','894e65b90f991cf4f6e3b248c9a16e84e159b14c',30,'mod_scorm','content',0,'/mobile/slides/','6V69PJC6jtr.gz',NULL,3586,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(121,'c799e01a224d44a05627bead022a9805da5dcdeb','de66891cb86369bd91c04c442b7d8cc7af5e3113',30,'mod_scorm','content',0,'/mobile/slides/','6LFuS7yilXm.js',NULL,17565,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(122,'3deb87286c86587b7226457d03b94a2870309403','85b053d0f8e863bf44ee90db467799719a1c0732',30,'mod_scorm','content',0,'/story_content/slides/','6cn5P2mFsa1.swf',NULL,3831,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(123,'aad309bc1405760b101f9cbe52059f20f852439c','4b49b0bf9ba9f04fa14125421e9233e4cbd6f834',30,'mod_scorm','content',0,'/mobile/slides/','6cn5P2mFsa1.gz',NULL,3537,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(124,'9d0ed3a26e00d82c664255c615d742a9916c0a68','bdb07a91c93eaea408668fdfb99f897a127f0a24',30,'mod_scorm','content',0,'/story_content/slides/','5qgfH8fSmoS.swf',NULL,3842,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(125,'40f2347653922177d6a5fbac4935821ef70fba31','6fc24b5bab79c1b7f5490fc59f33d3258465c6da',30,'mod_scorm','content',0,'/mobile/slides/','5qgfH8fSmoS.gz',NULL,3549,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(126,'21158623bd8f46baadd498ee9bbb759b09b4501d','51649de2636d41349ed1265a636137baa8648691',30,'mod_scorm','content',0,'/mobile/slides/','6V69PJC6jtr.js',NULL,17632,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(127,'47b6fcf3f0926f3d7e29a7e3c2dfb81c2a970924','7eb44cd270253811bdca8d7eb176d126043a1421',30,'mod_scorm','content',0,'/mobile/slides/','5ZcN5onhbE8.js',NULL,17558,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(128,'a04ac7ffad086f2de1c1146e60593d6cee36af1e','6d59eb10706d77f2c621a23b9c69269c324ef9de',30,'mod_scorm','content',0,'/mobile/slides/','6cn5P2mFsa1.js',NULL,17550,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(129,'a8db22cf69e0d924ac478b7a9b6af622e4590b3f','52b5eae1d4503395fa0e45467c6218c04a44dd63',30,'mod_scorm','content',0,'/mobile/slides/','5qgfH8fSmoS.js',NULL,17555,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(130,'b91c53aed0fed436f21b351a5a1b6dce7fd93cd3','a3e1faaa62523beecf86a60efb2e30539f4aa649',30,'mod_scorm','content',0,'/story_content/slides/','5oaCJV0nHpZ.swf',NULL,3839,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(131,'ddcf124bee7f8563c33f72c2616a553733853a36','7cfd4ace98a9c8a52d343eef02d10de5f66775e5',30,'mod_scorm','content',0,'/mobile/slides/','5oaCJV0nHpZ.gz',NULL,3545,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(132,'3fdd6b3f199119d5b289d6174a02356f6d37eeca','da8c36097476f0a59257e5f6954b339c163ee2eb',30,'mod_scorm','content',0,'/story_content/slides/','6Puc33rYBFj.swf',NULL,3831,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(133,'0c48768ff1b18f45eab86598206afd48199ec7ba','cd05ae84cc513f559e02b5c23f7cf841ecc8fc3a',30,'mod_scorm','content',0,'/story_content/slides/','5ZrUezXN3mL.swf',NULL,3848,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(134,'54ab16d423e10ae9e0140b77eafef0772bc59e16','ea780dccc505d08d474bec8fb9ae660d430f0545',30,'mod_scorm','content',0,'/mobile/slides/','6Puc33rYBFj.gz',NULL,3538,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(135,'a2a9cadb04c4f61fb85f2e7549e85ee52d2c6e97','4bf5c54c489751fe1c4d5e98be0ae1c7b945d9d5',30,'mod_scorm','content',0,'/story_content/slides/','5dkrglb7dsY.swf',NULL,3852,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(136,'4e918092d23608c7d4b5f1d05f19a23a5ab42438','e3bd5ed319f01b1f31904611fac1de2b764a3003',30,'mod_scorm','content',0,'/mobile/slides/','5ZrUezXN3mL.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(137,'698a6efe4d5014e8c7d4dddf181acbd43ff14fdb','9815ed364287256b0d363f90e100ccb3894fad85',30,'mod_scorm','content',0,'/mobile/slides/','5dkrglb7dsY.gz',NULL,3560,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(138,'38bc0556b0fddeb6da32d5e094253d6cc4c3826c','48c3a25a67f4bf07b443d5e8ea68d26d215f2a1b',30,'mod_scorm','content',0,'/mobile/slides/','5oaCJV0nHpZ.js',NULL,17549,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(139,'d9e542dd2059bf9574108ce38c6b25eb4d714c9d','d7a23cedf0a00b8085cd64de9072a3856be4471f',30,'mod_scorm','content',0,'/mobile/slides/','6Puc33rYBFj.js',NULL,17557,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(140,'2f3be47d0ced5e3891ad55a158a9d89ec0aefeeb','7053c4603456e84df6b2aeddb1cc748e875fb427',30,'mod_scorm','content',0,'/mobile/slides/','5ZrUezXN3mL.js',NULL,17563,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(141,'23da6585f94ea0114c3bef05b253f9b3c438d3f4','cb5f286e0396dd916d14cbb12681b9d483fc0848',30,'mod_scorm','content',0,'/story_content/slides/','6ESepQz0ms4.swf',NULL,3845,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(142,'419147a3870bf41a29d9c657a93a7da867ae5662','f649da653101e48f4db22697f3a98092ab1a4d85',30,'mod_scorm','content',0,'/mobile/slides/','5dkrglb7dsY.js',NULL,17571,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(143,'36f5fd8633df179f2a0fefcbfb515e1f87230c16','609548703b9b60a3c2626559e0619810dfd5e758',30,'mod_scorm','content',0,'/mobile/slides/','6ESepQz0ms4.gz',NULL,3551,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(144,'e150c2da542cd126c22c35356d738b3e578936c1','43e18a983b004ff779ec0b9de4bb863d4c30bafd',30,'mod_scorm','content',0,'/story_content/slides/','6LbBlWoKM1r.swf',NULL,3838,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(145,'b9ab9a84fad96be80becc93d41afc4450c089a44','35cebf52df2caf74efe57cb3658cbb93db36c8da',30,'mod_scorm','content',0,'/story_content/slides/','6OoxvI4MRMR.swf',NULL,3836,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(146,'e96c581f9a5dde527cc34bd64873acc512a583cf','33720bfa305a0ee38c3e2188e15eb910c4793b05',30,'mod_scorm','content',0,'/mobile/slides/','6LbBlWoKM1r.gz',NULL,3545,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(147,'7b9cf48614b056f51faac192348022365da77ff4','94897f462f35117692fcf85c2dd62280a052a4f4',30,'mod_scorm','content',0,'/mobile/slides/','6OoxvI4MRMR.gz',NULL,3542,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(148,'54934ee175310500d4fc367331de284135338cc9','44b3c01e68e79576b32409c10872ddea526775c2',30,'mod_scorm','content',0,'/story_content/slides/','6hDlmZ6LJMT.swf',NULL,3828,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(149,'022733f63dd1334fa61929a80f45c6a9e91922b0','eec1dfb4db68db8e3136ba73436fa3b0f2c53fc4',30,'mod_scorm','content',0,'/mobile/slides/','6hDlmZ6LJMT.gz',NULL,3535,'application/g-zip',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(150,'e42f694bd3e2444b77c46fc7fb217d3f2f09b1d6','e8f7b476bd6c9c8220afd8caea4957b0f81b0ad5',30,'mod_scorm','content',0,'/mobile/slides/','6ESepQz0ms4.js',NULL,17565,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(151,'b8b993d01eff692047593360bd4018c913bd7c2b','4d63d290835aa9ad445cc4b50488954557154651',30,'mod_scorm','content',0,'/mobile/slides/','6LbBlWoKM1r.js',NULL,17553,'application/x-javascript',0,NULL,NULL,NULL,1462458051,1462458051,0,NULL),(152,'f4ba4383127203325dd500845f7b0c642ded2a1b','b83bc3d34290536712bd9ed1181fc90b3271138f',30,'mod_scorm','content',0,'/story_content/slides/','6VRNQkLSWKn.swf',NULL,3865,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(153,'3b1ef4e28c86e66565c68137808c12ac428d9cd7','796dbf78bed1f6236f721979eb4dc2cf98b9c3e2',30,'mod_scorm','content',0,'/mobile/slides/','6OoxvI4MRMR.js',NULL,17550,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(154,'760a32482e35acd03c9a6d6d9bb6db1d6052b951','a9bee05f937bb8100ed306400efdd2c8b87b5b0e',30,'mod_scorm','content',0,'/mobile/slides/','6VRNQkLSWKn.gz',NULL,3574,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(155,'b5e4bb4d9aa393930ff9e5653f65f829af7973d2','286d341131b94482147bd9ca9fb8ca36eef1b997',30,'mod_scorm','content',0,'/story_content/slides/','6m6aBSJnyMZ.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(156,'14d18c27de624fdf371f7fe58c2a2640f5e328bf','f479d1c4a3bf989fd3e738673b0a02036675ecdf',30,'mod_scorm','content',0,'/story_content/slides/','6G2gY5qdUZT.swf',NULL,3846,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(157,'25dc2b9d5711b3bb7ab0bf030954830c471c0412','98cbf0b5d13481fa9b6d1a97663b08d8217de8ac',30,'mod_scorm','content',0,'/mobile/slides/','6m6aBSJnyMZ.gz',NULL,3557,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(158,'aa62a8ad4daa4b09e7dcfbcb27552a3da7364c56','85c508d32e0bf50c00fc32c828a34e8ab327ea66',30,'mod_scorm','content',0,'/mobile/slides/','6G2gY5qdUZT.gz',NULL,3552,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(159,'dd832322f5139f83c5f63e65dbe4513df6934bce','0057290b366264917517e38c6448121dc92288c3',30,'mod_scorm','content',0,'/mobile/slides/','6hDlmZ6LJMT.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(160,'39c3d92be81cfa203aaeb850acab7ade131ea6f8','7a27f8347d7633bcfe2f1654451cb1afaba8a4cb',30,'mod_scorm','content',0,'/story_content/slides/','6qbbInui4nM.swf',NULL,3823,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(161,'ca8f45ad782c3f2b7a5cac3b5f874eaab0f58a0c','283df0ca1c5715340014e56233bd26d212758f69',30,'mod_scorm','content',0,'/mobile/slides/','6qbbInui4nM.gz',NULL,3529,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(162,'b68d36c6152d6d69a2c42edebb2f9d7d0df773cf','f70794caabf7ef7f56e488b9767d970f5a1f1633',30,'mod_scorm','content',0,'/mobile/slides/','6VRNQkLSWKn.js',NULL,17592,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(163,'1c7827a3ef291a82ebaf94b41c7d2c045d9101ff','024cccd55f33c2afb111141235fdf28d0baef330',30,'mod_scorm','content',0,'/story_content/slides/','6ZdGJT7tkUj.swf',NULL,3838,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(164,'3e293722bd8a8bafe90144769b4ab30ee8db5ec3','c748324e3869aea777a782ff6b5817df79eb7bd2',30,'mod_scorm','content',0,'/mobile/slides/','6G2gY5qdUZT.js',NULL,17565,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(165,'35557ec3f1c7413b489ba5431bcd7dff5800a62b','df52d59ca3a1b67f202e336507967acb51e4b1e1',30,'mod_scorm','content',0,'/mobile/slides/','6m6aBSJnyMZ.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(166,'0421ce4f573e1ca1d51322ebca5939dd76f1d1e8','3beb6aacf79625ccf298d586308967f432a1b468',30,'mod_scorm','content',0,'/mobile/slides/','6qbbInui4nM.js',NULL,17545,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(167,'da3571c661b8186be6fb9e8d9a9784e5c7456443','b97c9c3b054cb6e3037b460359e36b20cae45ee4',30,'mod_scorm','content',0,'/mobile/slides/','6ZdGJT7tkUj.gz',NULL,3546,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(168,'f2fc05a1f5d74db28bb84aa4a1f0a4c1d12954d2','5afca452f8d7be5f06f98acae218b11337a2d1a5',30,'mod_scorm','content',0,'/story_content/slides/','5XSYF6g2R67.swf',NULL,3827,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(169,'baf4e4d90493bd066693a5b774012b78473ba9a3','4d5d6563063730e1f3b690cf1d8c88a39a01c8f5',30,'mod_scorm','content',0,'/story_content/slides/','6SkDAsJD01x.swf',NULL,3853,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(170,'16909b8b0141b6423993fbb44b9e00a3c526bd83','34a980076813e0923cf2f4f54426272a7c581ca5',30,'mod_scorm','content',0,'/mobile/slides/','5XSYF6g2R67.gz',NULL,3533,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(171,'857a1ef94f6764a796723fa02916d13977ee2949','6d21f3518da5bed8989e02f88da7897d00508b3c',30,'mod_scorm','content',0,'/mobile/slides/','6SkDAsJD01x.gz',NULL,3558,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(172,'8abcaf47485596e62c612912f4960ea6ffcb3165','33b446067cae7b8a1f7bffac5e6b4efb5e56a0e9',30,'mod_scorm','content',0,'/mobile/slides/','6ZdGJT7tkUj.js',NULL,17550,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(173,'ac29926e0b8f9888589326afac82969ac7514729','0cb8a621e563715f2f7e37de936651fb93fd63f1',30,'mod_scorm','content',0,'/story_content/slides/','5ka81WMqmif.swf',NULL,3848,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(174,'8f52d0a86613be6f76217632c2406498072e0298','ff175fc41de0c16a2a299187e8cf6bc6ff002d32',30,'mod_scorm','content',0,'/mobile/slides/','5ka81WMqmif.gz',NULL,3554,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(175,'39b5ed37fddca164d7eed2c8dcabe67d7bb6f543','5fe70314fbf6515b12e389370e1b12cf1dbcfa72',30,'mod_scorm','content',0,'/story_content/slides/','5YlIy4WCgGo.swf',NULL,3851,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(176,'0daa01d5c5ae4b48cc97b18d7c74f73c2359bf66','fef07df5a7fa9c750be3f3d4ef369cddaab72d21',30,'mod_scorm','content',0,'/mobile/slides/','5XSYF6g2R67.js',NULL,17547,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(177,'2dd55be6458f83e055715ceb2e60af776c769485','3ac6a7267df3aaabe26492ca6ba621acf3d2cb94',30,'mod_scorm','content',0,'/mobile/slides/','6SkDAsJD01x.js',NULL,17569,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(178,'47176b97636f226e096990cfc6a91b2169ebdfb5','2069ffa8f697e228dbc5c5d417491e2a859f8474',30,'mod_scorm','content',0,'/mobile/slides/','5YlIy4WCgGo.gz',NULL,3558,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(179,'86e7140f2746778bb48005c18d433bb26b0bfffa','698d535c454f9ccfbd406ad22fd97cc9049bdc5f',30,'mod_scorm','content',0,'/mobile/slides/','5ka81WMqmif.js',NULL,17570,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(180,'9f3ddf51666f7fc092ca934b8d64bf68c2912385','449698a6423e95dbe99e16d5ece935fbd20712a1',30,'mod_scorm','content',0,'/story_content/slides/','5fJqkMm0Cu5.swf',NULL,3832,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(181,'a61f74df3d712c7a704ba4182bad2836dd33eadf','43570af1553d14d48872adf488830b51465f6ff7',30,'mod_scorm','content',0,'/mobile/slides/','5fJqkMm0Cu5.gz',NULL,3537,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(182,'2c508626a6fcab184604b987cae119bb39c2e343','2c9b69925306bfaaaa675a0c47405f9002751131',30,'mod_scorm','content',0,'/story_content/slides/','6B7tMy9t1OZ.swf',NULL,3854,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(183,'0e1b17eb5cb1f1e07570fa0a8212baa81a6f0c1f','8b9990b998071ff42402c938d506291f4c6fba1a',30,'mod_scorm','content',0,'/mobile/slides/','6B7tMy9t1OZ.gz',NULL,3561,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(184,'6f779216258efde495a7ba23463777e4515eeb24','88c707636fa7412bf16a446db033da4c305f521e',30,'mod_scorm','content',0,'/story_content/slides/','5YkCyXo7FVJ.swf',NULL,3854,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(185,'c1c51e6949407321649fdcad43b2aa8c21ef19c7','578b023904b1e73e97cf59d28b9020acd238189b',30,'mod_scorm','content',0,'/mobile/slides/','5YkCyXo7FVJ.gz',NULL,3562,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(186,'80cba9d77c85decfbaa404b9c63ffca20229fa35','5d0fd6926988cee2e87f9bb2533412614d7ff9b3',30,'mod_scorm','content',0,'/mobile/slides/','5YlIy4WCgGo.js',NULL,17565,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(187,'e2b8ed2ab671e307d52e1068158925a0aec8120f','dbc4b72020cf4d1c5065f5a0db9f3a3be022dca9',30,'mod_scorm','content',0,'/mobile/slides/','5fJqkMm0Cu5.js',NULL,17553,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(188,'19cee9c73cae14d7dc3f1681ff971ed2f89b9be2','d4dc968479a9d3c7eb56be731c826e87e768bf34',30,'mod_scorm','content',0,'/mobile/slides/','5YkCyXo7FVJ.js',NULL,17579,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(189,'b710b71957af8a8e443953afa99a1f9d29334789','00decb8580a620df84382f5a1d36d456ca480965',30,'mod_scorm','content',0,'/story_content/slides/','617ff5uUxvJ.swf',NULL,3831,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(190,'118dd83f579baaaf5ab9a3fcc591a19056eead75','c61aa12e7da08e4f51b6284e53b1420a41141a2d',30,'mod_scorm','content',0,'/mobile/slides/','6B7tMy9t1OZ.js',NULL,17563,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(191,'1a699c3715149866810fa1666c543fd13e63f8ff','1ca327d315a162ac50357833e097d002fb49c747',30,'mod_scorm','content',0,'/story_content/slides/','6kvRcUFBLh8.swf',NULL,3832,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(192,'6ff341f5af6ece36ab977248d33f967905a5cc70','4f4efb37f2dafd550942a1a2ef0693f550b2fef7',30,'mod_scorm','content',0,'/mobile/slides/','617ff5uUxvJ.gz',NULL,3538,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(193,'48a691f3b668d12d85be81c71d33dd1c0706fba7','e054cce33a7aefe045d8d8e058c11dce821a4701',30,'mod_scorm','content',0,'/mobile/slides/','6kvRcUFBLh8.gz',NULL,3542,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(194,'dcdbe7e2f2d744ba95490b6e3f7b9450beab7850','7f231906c15c55ebeb40c88db5c68482b534a441',30,'mod_scorm','content',0,'/story_content/slides/','6L50STrz0pi.swf',NULL,3832,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(195,'7a379e6c7c9d98ca53ffc1a4539d412d04530477','ad2143ed349a78edefa56f61ed0c083541a1cc6e',30,'mod_scorm','content',0,'/mobile/slides/','6L50STrz0pi.gz',NULL,3538,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(196,'4a3bca68f343e62049b6228f88dd43b97f0eb12e','055323afa23dbb9c05062079bd1c7a29e386ebdf',30,'mod_scorm','content',0,'/story_content/slides/','6SC4VSy0U6q.swf',NULL,3846,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(197,'a2234c6c1c125966bc0566ad8ea9d2c18a6684bb','2e2072cff2091446b49675f3230ef882d44dae5b',30,'mod_scorm','content',0,'/mobile/slides/','6SC4VSy0U6q.gz',NULL,3553,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(198,'1cb8e898581d5b00f51ccc56db3776f0e09e4230','942a35199a9d677a3e657c5f45b804fb55a08b55',30,'mod_scorm','content',0,'/mobile/slides/','6kvRcUFBLh8.js',NULL,17549,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(199,'1b0d4030f173b7ecd4d9316147f430272822198a','b080cae9afb0b02124d9bd97d9c4eb37a677c80d',30,'mod_scorm','content',0,'/mobile/slides/','6SC4VSy0U6q.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(200,'4668fe92aa390acc8860e2ce215dad6f47303aac','43a5a0a82cedc84624f9ece10bb8389795593270',30,'mod_scorm','content',0,'/story_content/slides/','5sb0ntlwoxm.swf',NULL,3830,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(201,'2862bd5558620ba9b02266abbbf6fc16c383d5cc','a4589ec41cfa86c9ff4bf5c96bee1aa28375b8b0',30,'mod_scorm','content',0,'/mobile/slides/','617ff5uUxvJ.js',NULL,17549,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(202,'269ff7383029fd306698fbc6a8ff503262f2cd26','9631bde2d32a8ca3d587083b147018210f5836d8',30,'mod_scorm','content',0,'/mobile/slides/','5sb0ntlwoxm.gz',NULL,3537,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(203,'7a894b57de161d305600f608dd205e85bc98a368','0316bcc4bf237804b4769c5d76c3a017b1176afe',30,'mod_scorm','content',0,'/story_content/slides/','6ZrG5eE4fen.swf',NULL,3860,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(204,'75fdecc7d2f27989c367e12b4ddf02092a81b644','ae674e4f07ee708aae21eadef3e1ab3bc4ba3148',30,'mod_scorm','content',0,'/story_content/slides/','6oBjmdDxOFe.swf',NULL,3834,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(205,'5c26e4fb71f37787a229b7d4008216366c5bcd4b','4e59e57ed48f3ebb0478ec9bc5c4e5b09f0e7b65',30,'mod_scorm','content',0,'/mobile/slides/','6L50STrz0pi.js',NULL,17553,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(206,'f9c07bfbf64919364c81c18d949e5524c84b223c','a498490f7930d5310f607d3aef6c760911b83fd8',30,'mod_scorm','content',0,'/mobile/slides/','6ZrG5eE4fen.gz',NULL,3570,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(207,'c746f0ac6bf84e4faf464b89e8b1b8d38c75ddeb','642588fa459e8f037d497ee908269433d2cb4cb6',30,'mod_scorm','content',0,'/mobile/slides/','6oBjmdDxOFe.gz',NULL,3541,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(208,'491718c2f44c492391dab95f644e7a63e6d0c057','b8e21d76e01d8fb8fda847a1e7b5ec9efb191486',30,'mod_scorm','content',0,'/story_content/slides/','6CUI8R1ZiWn.swf',NULL,3837,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(209,'2af14fa9bc1e7e7144f172859a8ff5ef54dc970a','8d7beb781ca73444c58d8ead99c3b462e2467f04',30,'mod_scorm','content',0,'/mobile/slides/','6CUI8R1ZiWn.gz',NULL,3544,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(210,'01570effc3f74195f387cb711d7816109c77aa84','1497f9b7b10e9114e3bbcfef5aa284f3d6226fd0',30,'mod_scorm','content',0,'/mobile/slides/','5sb0ntlwoxm.js',NULL,17551,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(211,'1465e3741f05d8d5d4595a2f6c4bdb20080bf594','8871fec075aa6ad2a5367fb06bef1d13886d9165',30,'mod_scorm','content',0,'/mobile/slides/','6ZrG5eE4fen.js',NULL,17589,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(212,'b840899139e645010816ba38d029856c4724e4bf','93aea2f3d230d57f2ddc1c00bb93f21eb4cddcfc',30,'mod_scorm','content',0,'/story_content/slides/','5sfXNp3dZP5.swf',NULL,3849,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(213,'6332b5e2908a57d6478a77a63b463cf4366067a0','8def0ea72bb9202ad3c1d0ee75843d7ed67aebf0',30,'mod_scorm','content',0,'/story_content/slides/','6YHAPu0TGKJ.swf',NULL,3855,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(214,'74fb6202fe3f54b0dd6ead15f884ec1deed65d96','4651e44d405eb9a4a7feeed6a9da9ce7878f1d75',30,'mod_scorm','content',0,'/mobile/slides/','5sfXNp3dZP5.gz',NULL,3555,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(215,'33105e482627017738cb4cb396e0079186f5cbfb','086bfd51c640813bc076aac7f7c2c28879e53903',30,'mod_scorm','content',0,'/mobile/slides/','6YHAPu0TGKJ.gz',NULL,3562,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(216,'fe9683ec152a0bfbc7858c280e63fb9a3b365f82','ea0d509377341a44eee3a901eb77fe6ea7487d3b',30,'mod_scorm','content',0,'/mobile/slides/','6CUI8R1ZiWn.js',NULL,17551,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(217,'9c059d938e4f5a4dd808d676baa4ade5ebd175df','021927908b13f079bc95a2868026ae888a9a695c',30,'mod_scorm','content',0,'/story_content/slides/','6CkBwsNx0VI.swf',NULL,3835,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(218,'34786168c17756d2fda4689a55efaf0259b63585','5db48243c219958164b683fdacc45c317c096045',30,'mod_scorm','content',0,'/mobile/slides/','6CkBwsNx0VI.gz',NULL,3543,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(219,'f9e70db44cb6a0bbcd0d8bc50d31a870ca00123e','1cdcc18d94d1339abb948e505c2b9dbe0e569082',30,'mod_scorm','content',0,'/mobile/slides/','6oBjmdDxOFe.js',NULL,17554,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(220,'2c283b7198d3c7f9e55d265354a460d7ec55e91c','be6a7e0cc5bc3476e1fc53522824cf20eebc1639',30,'mod_scorm','content',0,'/mobile/slides/','5sfXNp3dZP5.js',NULL,17568,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(221,'a63ae801e0730b2b60a3665549a5171d918c5530','9bc1a3dfcc9274e1d6249ee62177abcd065714ac',30,'mod_scorm','content',0,'/story_content/slides/','6GiGHBU1wvR.swf',NULL,3837,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(222,'b46853898fc647110cf05dc44ed8317afd65a99c','5447fd34c42de541336a811537c9205105af73f5',30,'mod_scorm','content',0,'/mobile/slides/','6YHAPu0TGKJ.js',NULL,17576,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(223,'0fb2181b67a171e1d9144529e6783877ee96905a','f37344c0c2b8b81d92da44059962b7cb2079c2cc',30,'mod_scorm','content',0,'/mobile/slides/','6GiGHBU1wvR.gz',NULL,3541,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(224,'d2cf4d4170d72e1755eed20761101d7387d57dcb','0538a6f4605c2d083346a7f0248fe344a986a8e2',30,'mod_scorm','content',0,'/story_content/slides/','6KRJUNa614Y.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(225,'0c98ab757f3f671391e929458f94d2c0b7835d5c','0797895e68377cdc0050263b6c73d8f73de5a5fe',30,'mod_scorm','content',0,'/mobile/slides/','6CkBwsNx0VI.js',NULL,17552,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(226,'50a6b4bbba6e264656a32194b610fc0bb98aa599','9d42aeed521c023c97199adda9629f6ad5836e98',30,'mod_scorm','content',0,'/story_content/slides/','5WFeazCeqom.swf',NULL,3840,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(227,'9ba938309059aaaef42ff3b08b9ffb01278a7900','cc09fb029136fb8089292599999138fc00e1a479',30,'mod_scorm','content',0,'/mobile/slides/','6KRJUNa614Y.gz',NULL,3555,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(228,'6c1e13ffff0f30135a2c5ef72463cbbee1560999','f496de694eaa6b24703b33be49915f1395ab886c',30,'mod_scorm','content',0,'/mobile/slides/','5WFeazCeqom.gz',NULL,3547,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(229,'283c077203fe31cc4df4ffed024f95f968da5b6e','78a4cbf185b133ecb34d7b17d28d1bc095a5dd50',30,'mod_scorm','content',0,'/story_content/slides/','6Lf1VgV6vDk.swf',NULL,3847,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(230,'fdc06685c048a3a7338dddb2d8a71a40270b023f','8a026fde98c0de5bec86dc695a7710d7a9396464',30,'mod_scorm','content',0,'/mobile/slides/','6Lf1VgV6vDk.gz',NULL,3554,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(231,'4211ca29617d49dcbfd1bc93bfc62cf834d55bea','fecefc48e671beae572dafaaa44379c0d689ab8b',30,'mod_scorm','content',0,'/mobile/slides/','6GiGHBU1wvR.js',NULL,17563,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(232,'3c9f32e4825bcffb4d53bfe86e40495bc542da09','adac2e2509b0ab017a779596a3ce9e16069fe16a',30,'mod_scorm','content',0,'/story_content/slides/','606HvSAMpsD.swf',NULL,3834,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(233,'894f77ca8db35469d4fd5ef9e277bd2d3e329f00','406a7832015b5c24190f16bade638db99508e2c0',30,'mod_scorm','content',0,'/mobile/slides/','606HvSAMpsD.gz',NULL,3540,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(234,'c410b9fad212d5e679a0106a1f3f195e2c604550','5546642216da9aa58ec94c0b8e5546f65aaab65b',30,'mod_scorm','content',0,'/mobile/slides/','6KRJUNa614Y.js',NULL,17567,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(235,'5dff5ad65e1534907b8fc834e4804f14ca7a3921','2df55a67658f95d9f567dccf58d90260868eddcf',30,'mod_scorm','content',0,'/story_content/slides/','6UnEWjiAXnh.swf',NULL,3852,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(236,'ff6afd430a9871e72cad7527d76116d8a31e3a9a','4a834b7ab03542bc1f77bb227e7c664292914eee',30,'mod_scorm','content',0,'/mobile/slides/','6UnEWjiAXnh.gz',NULL,3559,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(237,'fcaa66a339706c5afb3108219eb49f8e323de099','f1b5732019e827b2b8a97d91af478495d00c769c',30,'mod_scorm','content',0,'/mobile/slides/','5WFeazCeqom.js',NULL,17557,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(238,'9244a478d0cf1928304d23e97555d97baf45b164','a363f91b293a37c57dd690eda84c5bd03a880a4b',30,'mod_scorm','content',0,'/mobile/slides/','6Lf1VgV6vDk.js',NULL,17565,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(239,'857fad697306e3bbf0a731d73b5a51933c544a7b','f81a2683914a82899a790a918d437588720c7d97',30,'mod_scorm','content',0,'/mobile/slides/','606HvSAMpsD.js',NULL,17546,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(240,'9a48647bf04a8528ed468bc8aa426fd9be1d3974','f8396b6c991a587e5681633ff8b2dd0af31774a3',30,'mod_scorm','content',0,'/story_content/slides/','5VaAn8Toajb.swf',NULL,3838,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(241,'2227f9159fe0bb7b2a59a7eefe95bfbc69b41c11','e1471e1b6f1718c35c7cfe0e6c1ddc3dec567564',30,'mod_scorm','content',0,'/mobile/slides/','5VaAn8Toajb.gz',NULL,3544,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(242,'9904d1b149dbfe5ff72d0401682b054bf153075a','6f5ae399d393a3da6d59fd36d6850293b77b1dbc',30,'mod_scorm','content',0,'/story_content/slides/','6laJBhKZI16.swf',NULL,3844,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(243,'0b72d2278b546b8352a5169074fea29251efffd4','2e11692fa81da7f76f7a31a6dbf7b01e86ca2c22',30,'mod_scorm','content',0,'/mobile/slides/','6laJBhKZI16.gz',NULL,3551,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(244,'17869abb842aa5aee2fe7ef9e5fe74eeb51458ed','23e81dd0351db6c309b674eaf9f07d8612a94691',30,'mod_scorm','content',0,'/story_content/slides/','6bJiSaz7Bug.swf',NULL,3845,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(245,'3eebc77e19702da9f06e494e216c98e04e9ac1d9','c83207cdd85e0c22d155c75fc736c7d4f72e022a',30,'mod_scorm','content',0,'/mobile/slides/','6bJiSaz7Bug.gz',NULL,3553,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(246,'3003e67267e232e33e74246efa185728f90c6cc9','758edf6bd36f0a5a02016f310bf85b88c22e4a29',30,'mod_scorm','content',0,'/mobile/slides/','6UnEWjiAXnh.js',NULL,17578,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(247,'35769259292ca7d8784b8383543d6dfcbce6e2c0','29d393918e2dcfea6f62c1df4b52c6e16b3c0f39',30,'mod_scorm','content',0,'/story_content/slides/','6CURBxzG3Ge.swf',NULL,3849,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(248,'8cf2c9a7ec259bdf0ea906f38ae1b8d638cbeaaa','157564040b2642bf2ed32bc773ea4c87d3df4405',30,'mod_scorm','content',0,'/mobile/slides/','6CURBxzG3Ge.gz',NULL,3555,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(249,'e9eae33f082a897cb3e8da18336a2f7c20c6ce1a','ff20e7c60428e347fb0224be870bda055e1a0bf2',30,'mod_scorm','content',0,'/mobile/slides/','5VaAn8Toajb.js',NULL,17557,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(250,'85201c4f8e78cb5257ce878eaf14ca087f4cb95f','d6f9eb9b8ca2c1b2828c2e761eac1e0cb0fccb32',30,'mod_scorm','content',0,'/mobile/slides/','6laJBhKZI16.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(251,'e679bb27c48a7d86ebce5129020effd2fe96cef3','ff5a9eb045810e90458a11bcfebc9817e5ba99dc',30,'mod_scorm','content',0,'/story_content/slides/','6EZfnmbHoon.swf',NULL,3845,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(252,'43ac16d2202cc69bb3ddfca172c3ae0e46400db2','274636e5e7ad4a653238582798f966848248a460',30,'mod_scorm','content',0,'/mobile/slides/','6EZfnmbHoon.gz',NULL,3551,'application/g-zip',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(253,'8b3fcdb6c7f6824011b4202243e23f57c7d00ce3','87244a360e45ae1ea7353f689ea78e796652a2c3',30,'mod_scorm','content',0,'/story_content/slides/','5ytzR0BqPIN.swf',NULL,3855,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(254,'e0458e0e8502e30f9a4448b637a76a27de66d1d8','ca7594afba560662f3dae102de8182c3ba1cfd7e',30,'mod_scorm','content',0,'/mobile/slides/','6bJiSaz7Bug.js',NULL,17582,'application/x-javascript',0,NULL,NULL,NULL,1462458052,1462458052,0,NULL),(255,'2248ee8b3731f876996a14160d1a7acddcd82c1a','79488ce8c17ee010e49ec7438e4ffdce059a660d',30,'mod_scorm','content',0,'/mobile/slides/','5ytzR0BqPIN.gz',NULL,3563,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(256,'ab65618c56a15049756736467f1bd1617d27c3b5','cb2237425fe450c32c3d9714ff5653da0c49b3ce',30,'mod_scorm','content',0,'/story_content/slides/','5mvxCQMy4l4.swf',NULL,3827,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(257,'992d252d9e6966a5f94215e09fe5fa2a7acd1eb1','bf75b6f16153a201e59b177b557e6260b23effb1',30,'mod_scorm','content',0,'/mobile/slides/','5mvxCQMy4l4.gz',NULL,3533,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(258,'bed80ad61f2c38a76e47a15ea17b6916729f7781','550e56120c106f6385ed167a6f9520263a5c36b9',30,'mod_scorm','content',0,'/mobile/slides/','6CURBxzG3Ge.js',NULL,17569,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(259,'1c6d6a581ef64d2af72d79c65a9181e1a699f7b1','1b4ba3b2669817616ce2aacc4f7ad3515226c6e8',30,'mod_scorm','content',0,'/mobile/slides/','6EZfnmbHoon.js',NULL,17565,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(260,'4192929ad0cb43993a727f808fad12ba31c5f11f','bbe5de3cf85c83a4a6dc65e171ed8d6cc8f33f1f',30,'mod_scorm','content',0,'/mobile/slides/','5ytzR0BqPIN.js',NULL,17569,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(261,'ee75eba293cde2cd9b2b5065890f06e5ae45855b','940040290e477e735cfb7363c879ed9c025080a5',30,'mod_scorm','content',0,'/story_content/slides/','67rTcOjrmsO.swf',NULL,3871,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(262,'5865616dd52ee95ec68f6e68836b33c57e298d70','98aa739d0bf59fd42ccb50a12c3e82ad43683faf',30,'mod_scorm','content',0,'/story_content/slides/','5cBYyyP8MAx.swf',NULL,3847,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(263,'0628eff18fc3cc4f11c0848aefe17e1cd6143845','85435861d02f84d2f6edac973e418448a35dc189',30,'mod_scorm','content',0,'/mobile/slides/','67rTcOjrmsO.gz',NULL,3579,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(264,'d90c06d60b057744f0cb8119f2f5931461cdd511','b60ce7f305eea7770ed4c7b05e933f8b20855374',30,'mod_scorm','content',0,'/mobile/slides/','5cBYyyP8MAx.gz',NULL,3554,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(265,'ba4f5a83f85f286a44955ce8bcf6545fd52518b4','87982e3fd96d0d004e298fe3cdeb08b4336cc6cc',30,'mod_scorm','content',0,'/story_content/slides/','5XiDO9f3nk6.swf',NULL,3833,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(266,'c726a77db60cc748eee08303eee158251e01ec04','bbf72256bc9451b9d7c1b02d4dd28c7794634036',30,'mod_scorm','content',0,'/mobile/slides/','5XiDO9f3nk6.gz',NULL,3539,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(267,'a49d6594b6faf8ca1a629505a13e6efda10b9e29','fd69b5494f74d7a922b08343076185b42ce1eb97',30,'mod_scorm','content',0,'/mobile/slides/','5mvxCQMy4l4.js',NULL,17549,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(268,'d75dce258f71e6c31ad4b0a89cac4bf5c90efe4c','d1ef60d0a0034172e791971511d73e177a37f74d',30,'mod_scorm','content',0,'/story_content/slides/','6WmeE6WWDwl.swf',NULL,3834,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(269,'c0503aa7769ce656682fe2a2a93aec3dffa87432','969d29f455f0df57a2e6d339a28a06c18ed16762',30,'mod_scorm','content',0,'/mobile/slides/','6WmeE6WWDwl.gz',NULL,3541,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(270,'80f27686522f5da7051d1d6d90cc830a771f4180','7a0f17704edd5e7056fb3041515f0a92c0d3d362',30,'mod_scorm','content',0,'/mobile/slides/','5cBYyyP8MAx.js',NULL,17567,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(271,'85be5b74ba9372d265b646c4b9a13041d77dd1d4','918a8ad4726ad376847a055315ea57fc17b7aa9c',30,'mod_scorm','content',0,'/mobile/slides/','67rTcOjrmsO.js',NULL,17602,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(272,'3a3b12ec48df6495470c37a1094084ce87558ea1','60089baa957e42cbde1d6a4b154c20c175ae5e38',30,'mod_scorm','content',0,'/mobile/slides/','5XiDO9f3nk6.js',NULL,17549,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(273,'2f53c4708b67fa980dda96e4f31bfe578e397b59','69bb6f181cd9d718c87cd3f4ec4c64608143c702',30,'mod_scorm','content',0,'/story_content/slides/','5uGLZMEkFLP.swf',NULL,3873,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(274,'8fa55d79f90bba6b9a54c88cda36e17d40eac7d1','a31be591ac37669e48c62ad3c56e2f75a983ca5f',30,'mod_scorm','content',0,'/story_content/slides/','66wfRZ2gK3P.swf',NULL,3857,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(275,'88e18cf3695fe4a9843eb180bc59484b15fe40f0','0fc9e8a3e518d9b9c9c468f8d1907dc6adf307b6',30,'mod_scorm','content',0,'/mobile/slides/','5uGLZMEkFLP.gz',NULL,3579,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(276,'64e9c1e67edf0e60d1320e7a5249a0ff8289ef03','5559f06e30a13ef0a311b3c177fd672c056b9255',30,'mod_scorm','content',0,'/mobile/slides/','66wfRZ2gK3P.gz',NULL,3562,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(277,'d1c2c735dd75e59a7f88f554483338b3f33b8812','636d3296f5fa6dcc90f9937d0935b1d7e6126571',30,'mod_scorm','content',0,'/story_content/slides/','5idfF2nSH6p.swf',NULL,3845,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(278,'699f346e7ad73fc534b96cf8944826859224b56f','0609177bb4c610de61cf77965ff6066e6cd2817a',30,'mod_scorm','content',0,'/mobile/slides/','6WmeE6WWDwl.js',NULL,17552,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(279,'a6929732fbc34aac7340b3345a2b49f35e3b7a8d','5b4c6cb9cf79129a946d00285b8ea43fa0d1f621',30,'mod_scorm','content',0,'/mobile/slides/','5idfF2nSH6p.gz',NULL,3552,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(280,'278a2ad6c7f713626c1af441457c46f49b3e5d94','d61b4aedf26c4c12420c74d0a69cf031ba4e898a',30,'mod_scorm','content',0,'/story_content/slides/','5XyWqpbTUsi.swf',NULL,3819,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(281,'b4673c6a6f42b3763565f5f69d37db9bcf55d7f6','380c18377166a1ee7393786caac9bb8a0e3ad50c',30,'mod_scorm','content',0,'/mobile/slides/','5XyWqpbTUsi.gz',NULL,3527,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(282,'2275d8b1aaccbebe07aa57f9ab60fd4ba37a8199','39d78d2313f67cf4a43db44f996874c6b8c88e12',30,'mod_scorm','content',0,'/mobile/slides/','5uGLZMEkFLP.js',NULL,17600,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(283,'12016c41f6198143917a7fa56f3179eda17a9348','abe071609880af0bd4288d869ffd407c8080fe3b',30,'mod_scorm','content',0,'/mobile/slides/','66wfRZ2gK3P.js',NULL,17575,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(284,'f46b08cb4f5300d92d448b10d77884a663684e5a','fc8306948e539774094ec5101a76353273628365',30,'mod_scorm','content',0,'/story_content/slides/','5kbr0YWqGeZ.swf',NULL,3851,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(285,'144a9055cec61ee6a074aa58aa74a6a684563f97','b7494bc1015a6857c2ca4819dbaa568243c420d4',30,'mod_scorm','content',0,'/story_content/slides/','5VaZdGTmsGt.swf',NULL,3855,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(286,'e12bcddc60e1d6fff9ef13fc003064371e5bbfd2','f4df05ef7615ca38299cd22dea7506984be63ada',30,'mod_scorm','content',0,'/mobile/slides/','5kbr0YWqGeZ.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(287,'67da98af59691a162040a639d342a65c31f2c04b','17ab726a72fd3e47a6e72d7f694efbbed763249d',30,'mod_scorm','content',0,'/mobile/slides/','5VaZdGTmsGt.gz',NULL,3562,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(288,'401eaa4d775d77b35135a70c2bf76bd2688a4605','9d729fa1e5d93acf16f10e65d26f186924b0d154',30,'mod_scorm','content',0,'/mobile/slides/','5idfF2nSH6p.js',NULL,17574,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(289,'3a9e0462fe64efe71bef7fc74867c6c7f4a46687','1373db1b91cf61b3364265b2c8f512917bd5bc37',30,'mod_scorm','content',0,'/story_content/slides/','5kHW3JZ7slI.swf',NULL,3851,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(290,'3880cb3e680a031e050019140f06b331f1b47c75','2189eb01c2917d979a367959b535743b977f5562',30,'mod_scorm','content',0,'/mobile/slides/','5kHW3JZ7slI.gz',NULL,3559,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(291,'cd0ef97afd49971d3967eec4590693a1d712f009','339b326500125431372cda5110474287e7a06363',30,'mod_scorm','content',0,'/mobile/slides/','5XyWqpbTUsi.js',NULL,17549,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(292,'c8a66a76a379da6033fbb882c7502a0a5374a040','846d7953560a9b8db33687934a90ce1ce5ca4208',30,'mod_scorm','content',0,'/story_content/slides/','6Pp0phutaiL.swf',NULL,3825,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(293,'507ea8bf8dc30169e8c93374349c42e573de5880','7653a9adf5f72a07a83425c86837ea2fe107b6b0',30,'mod_scorm','content',0,'/mobile/slides/','6Pp0phutaiL.gz',NULL,3534,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(294,'5db9b71d4273cb9440385d854f70df48184157a1','1915f678b6a99dc6121f2fe6948edcf9104cba6d',30,'mod_scorm','content',0,'/mobile/slides/','5VaZdGTmsGt.js',NULL,17572,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(295,'6877b6105056e650aaf38413cd3df683189262ef','c5e5df71db295803d5bb70ccc1828829e204f577',30,'mod_scorm','content',0,'/mobile/slides/','5kbr0YWqGeZ.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(296,'3eca5807831baa529e73e7e32ec8f6a662a17710','eab42fc719c1735d7eaf312830e31d559e897698',30,'mod_scorm','content',0,'/story_content/slides/','6ZNNqo3xTIR.swf',NULL,3859,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(297,'94953a4f39dd4100d3f89f90c12ff6fde508f356','be448281b14e90f40688cdfd338ce5044c742312',30,'mod_scorm','content',0,'/story_content/slides/','5ylQgOKk5th.swf',NULL,3838,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(298,'efcc7c2c4e8c0b88ffcc32b2057b3bc8c70f4cec','25a74665a0c44835f3705c9859907afef5195c44',30,'mod_scorm','content',0,'/mobile/slides/','6ZNNqo3xTIR.gz',NULL,3568,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(299,'e63559ec8aa1d2ff0ee7095540ca3afd4b1396a9','c75343fa5564db390886b8030c178e9592363e03',30,'mod_scorm','content',0,'/mobile/slides/','5ylQgOKk5th.gz',NULL,3546,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(300,'25fac7765d5abd247d572a5cbac56e1308ec2c9b','b53c19d95a4972cab671686968a838a3e02a22d7',30,'mod_scorm','content',0,'/mobile/slides/','5kHW3JZ7slI.js',NULL,17584,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(301,'c824a648b36f141777067e305b597da26cc732b1','bc7cd4c8c8eb6ac79d2cec74b879db85ba6fb714',30,'mod_scorm','content',0,'/mobile/slides/','6Pp0phutaiL.js',NULL,17545,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(302,'39ed585b2ca044e8216ccfcdd3a95c5394249dde','ddcf5f80f69c32c7f8fa8c3151246e768d5aa4c6',30,'mod_scorm','content',0,'/story_content/slides/','5uAnHMNnpou.swf',NULL,3846,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(303,'ffa3be038d85beab6d1dd0ef18d4732e25afdb16','f0ff36dc07c9dbc0d04e363a34fe1886c3df65d2',30,'mod_scorm','content',0,'/mobile/slides/','5uAnHMNnpou.gz',NULL,3551,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(304,'29b146a1df0349c33d5bcc4b005c101765a4c9d7','ee424d5f09bd388251b3b58c51030e9481249312',30,'mod_scorm','content',0,'/story_content/slides/','5t9mIpbBeAV.swf',NULL,3831,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(305,'8cc9cfdac48f930e8fcbc9dd75d1f10551c70304','3d164246c8aaa02ac6f4605e1ae615358aaec632',30,'mod_scorm','content',0,'/mobile/slides/','5t9mIpbBeAV.gz',NULL,3538,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(306,'bab308c0690a396a500ca6ce00d2200732518f92','a642d5c4c07d7e02eb840dd533ac1ec3d8271da0',30,'mod_scorm','content',0,'/mobile/slides/','6ZNNqo3xTIR.js',NULL,17583,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(307,'a8ce7e132ea021c51f5f5fb2b804ac921ed68c08','baae7a264c1adc213052b769fd68037085596c00',30,'mod_scorm','content',0,'/mobile/slides/','5ylQgOKk5th.js',NULL,17557,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(308,'d4ad59652ff4f561818887bb32fde62472db321e','aa223c43e96293fd9aff45171efb677ac8c945aa',30,'mod_scorm','content',0,'/story_content/slides/','6bpy4ztcOhp.swf',NULL,3851,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(309,'24aab256a9b299fde7e53079051be8b4699fb505','6e70de3df5c349f83e607ca3538c32304c3129fe',30,'mod_scorm','content',0,'/mobile/slides/','6bpy4ztcOhp.gz',NULL,3557,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(310,'37407d0792bb9217804a47816de2f408b96610b0','cddfd346d03cb66ca9c1b928d8bee028130bec14',30,'mod_scorm','content',0,'/story_content/slides/','6clSaWCNZzn.swf',NULL,3871,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(311,'922b05f0d054f4f08714ba42e75eb007d3af34ec','a62ae49d3bd3abb341123845a9cad2c54e9941f0',30,'mod_scorm','content',0,'/mobile/slides/','6clSaWCNZzn.gz',NULL,3577,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(312,'59b1c1953e6c04cbfd92798e6168ad53e60e5bf1','17385b0e418e617f5896d60954ac48c3b7298680',30,'mod_scorm','content',0,'/mobile/slides/','5uAnHMNnpou.js',NULL,17564,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(313,'79ab80faa2651bc6c4cf523c6045f81423548b93','65ee12434d5ed47fe069c02923266c8e12690c39',30,'mod_scorm','content',0,'/mobile/slides/','5t9mIpbBeAV.js',NULL,17553,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(314,'ce05c2963b464bdf134277ae98ea7184480e9f74','e841d7fc3140b291c751456eacd544cc20e6d51a',30,'mod_scorm','content',0,'/story_content/slides/','5p0gOIIQpop.swf',NULL,3857,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(315,'d5f1f8de4b1f526e5f2165028f0408eb86c2ea15','3fc69478e1a6f54d526729426476baafcca128d1',30,'mod_scorm','content',0,'/mobile/slides/','5p0gOIIQpop.gz',NULL,3566,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(316,'96d800e2b6a16e47029dcfd762f8c746b9b6c5ac','ad6c38f37312fde51c4c985b29affdfb13c0c9a3',30,'mod_scorm','content',0,'/story_content/slides/','6HhftmMm8LP.swf',NULL,3823,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(317,'c4dfea93bb4bb34e9a754464cc56179974776529','c9ce573638b8575fad70ca84e500c437d0a1206b',30,'mod_scorm','content',0,'/mobile/slides/','6HhftmMm8LP.gz',NULL,3530,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(318,'70772bb8e76f4b8b8c3b518467ae4d9bab572710','cc1f19fb5356392205f01bff0c637b941ce31781',30,'mod_scorm','content',0,'/mobile/slides/','6bpy4ztcOhp.js',NULL,17570,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(319,'3ef142bce230816029adac3fac45b61560c1c237','f01b6e73c8bfd7832955ffb01e45e00676f849e7',30,'mod_scorm','content',0,'/mobile/slides/','6clSaWCNZzn.js',NULL,17610,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(320,'72a97cf0650e4f80905721274da11d9eda5a36c1','210d2bf942ce98bbd26fcf56a1ebe279f8304e20',30,'mod_scorm','content',0,'/story_content/slides/','6F6BIcS60rg.swf',NULL,3846,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(321,'3fd733d11eeaf570d1395f4cb066cbee7dd8d8ed','e27b0ca94fda8e35b95af4cc4857d94688d3efa9',30,'mod_scorm','content',0,'/mobile/slides/','6F6BIcS60rg.gz',NULL,3554,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(322,'9ed159798b99a2725281484ddd965d52b3e68317','f45945bb9afc1b2fc4dbae28d75ec9f52dbec049',30,'mod_scorm','content',0,'/story_content/slides/','6iz3mLtagN2.swf',NULL,3851,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(323,'03eaab08a381da1ac70a7122ac31ed77cadf9686','8402a4f35ffccf6cd0954aab23a35fce1b4bed6c',30,'mod_scorm','content',0,'/mobile/slides/','6iz3mLtagN2.gz',NULL,3559,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(324,'7c9736d2ff13550d1d3b7ab67d7d9a27231d3618','499054926f0907f8f8ebfc15a9cb13f4c6b26fb7',30,'mod_scorm','content',0,'/mobile/slides/','5p0gOIIQpop.js',NULL,17589,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(325,'111d389eb9a8147c4a6083d5344c45ebbd268755','f90e72c36ab20e0f69e13d227d6b56ab25e061bc',30,'mod_scorm','content',0,'/mobile/slides/','6HhftmMm8LP.js',NULL,17546,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(326,'90c8d10a53f0e562e0c042ede0fbc6e7f240556d','26fb5a7464c73a929d72d5d579bf31c5a2109f28',30,'mod_scorm','content',0,'/story_content/slides/','66OMtCpTQCq.swf',NULL,3854,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(327,'2c0aa132a7b367da97dda06c71e55894259ef8ef','9fd4447893f07240c2c1d3d21d6a265d42ddde0d',30,'mod_scorm','content',0,'/mobile/slides/','66OMtCpTQCq.gz',NULL,3562,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(328,'de550dc14d55576f6c93efc9d2bbd4ca8e459011','b9606f68ffe08ba4aab8c69f362eff1898000da4',30,'mod_scorm','content',0,'/story_content/slides/','6czgPl8Uym9.swf',NULL,3836,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(329,'6aca51cdd7b0d8d321aca58e3ec6bed7ba61ee3c','2af2e86b2407e3d3f723463ad7d264afafcbd8ba',30,'mod_scorm','content',0,'/mobile/slides/','6czgPl8Uym9.gz',NULL,3541,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(330,'71a26f179c4b46b38ac40503ae7899df9b4eca79','a1276c76b93f23049d2bdc8e3d0c028a6a9f122a',30,'mod_scorm','content',0,'/mobile/slides/','6F6BIcS60rg.js',NULL,17567,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(331,'29f0aed3ccd5c982db825dc278624b1523674a0a','a16030dc1ed43cd8eaf1f76a18981082be8f8ea2',30,'mod_scorm','content',0,'/mobile/slides/','6iz3mLtagN2.js',NULL,17573,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(332,'778cc8ea63faa996b9d2df790511659807dd22ed','206f40fc653fd29884400888d0b3b1f841cb2457',30,'mod_scorm','content',0,'/story_content/slides/','6G9Zx1exZkg.swf',NULL,3857,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(333,'55de4a1141d43c6bc698607a9a0c9ebca037e32a','b18d498dabfcad827ed82c11f11e75b1f616592e',30,'mod_scorm','content',0,'/story_content/slides/','6de4Ye2EHfs.swf',NULL,3832,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(334,'6fb5db8cf21d0ce8f84329457a5c78ee4d324c31','e306b873ad331dc49aab2e68a614eb49096c3b86',30,'mod_scorm','content',0,'/mobile/slides/','6de4Ye2EHfs.gz',NULL,3540,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(335,'cd25be0fc16b99136daf3dd1eb1bc24c86f4f912','1d7c04b427286d3b83a2cfcdbc93f23184924279',30,'mod_scorm','content',0,'/mobile/slides/','6G9Zx1exZkg.gz',NULL,3564,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(336,'4958a556eeae974246c447387effd06e3ebba9d2','d16b9d8a57df2027132a36be146edbc452ae9cc3',30,'mod_scorm','content',0,'/mobile/slides/','66OMtCpTQCq.js',NULL,17573,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(337,'cff261b6c6e94e80f0f8d2dcc309b57226364616','9d94949f89fcd1f7ce64cfe766b5854c23dc7d55',30,'mod_scorm','content',0,'/mobile/slides/','6czgPl8Uym9.js',NULL,17563,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(338,'0386f1ae7fb218fdaead009b30dd600cd79a2d13','52baff68e00e3613ca5aedca7308c69582813cde',30,'mod_scorm','content',0,'/story_content/slides/','5hweYIJIZZU.swf',NULL,3841,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(339,'087dd99a0d64e17d99749d59a40e33d598dc5b89','13e2726b9ae7684e70f18a9413f2ffb7e0a6d3d9',30,'mod_scorm','content',0,'/mobile/slides/','5hweYIJIZZU.gz',NULL,3547,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(340,'65c70cc75f98cca018c32f0aa1437160aaf69394','7952689c7bc4de313d8470147a8d577ebe593e59',30,'mod_scorm','content',0,'/story_content/slides/','6EETQHZ0s8f.swf',NULL,3848,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(341,'ccbd991087f307ff132e2807c22e99a2f374cdb4','a84e4c10ccc5316920369914bdd48dc822c5d397',30,'mod_scorm','content',0,'/mobile/slides/','6EETQHZ0s8f.gz',NULL,3554,'application/g-zip',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(342,'544e93515d5607ad3923433a01716c1445fce639','fd034ea3b5063c9433bf5bc23f20be9c265bbd91',30,'mod_scorm','content',0,'/mobile/slides/','6de4Ye2EHfs.js',NULL,17551,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(343,'4d6d4a44d4f9fc82e1f9cf3baf17bd8f254582d8','ce0e459c84f26f26b5123261e598b18b2cd17264',30,'mod_scorm','content',0,'/mobile/slides/','6G9Zx1exZkg.js',NULL,17577,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(344,'3354d6771c0b35e9c0e9653184c6f3ca1d5fcd25','63321ca7ef0cf13a2cceee58cfc9d40aed7bc3cb',30,'mod_scorm','content',0,'/story_content/slides/','5pVDFUVSm38.swf',NULL,3848,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(345,'63b41a803aca412931c6eaae93840ec5ea3c5de2','98ea961072c9f3450b2c28d5825751346f190f1d',30,'mod_scorm','content',0,'/story_content/slides/','5WnadNEEnYz.swf',NULL,3847,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(346,'cf924116913e924c6b700726cb68f6f0be0f8124','2bdc62d7d1fa90a9bb4e44fe557e6d05412b0289',30,'mod_scorm','content',0,'/mobile/slides/','5hweYIJIZZU.js',NULL,17568,'application/x-javascript',0,NULL,NULL,NULL,1462458053,1462458053,0,NULL),(347,'d9cf91e5c0ad3f6e3f46e5be8a491da135fa17d0','ecc1ed7babc78e1420ec16ad5d9a0944e4478d03',30,'mod_scorm','content',0,'/mobile/slides/','5pVDFUVSm38.gz',NULL,3555,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(348,'42547b62f730607b04cef0b1416cf301e00d9edf','6ba8ba4c88b9b8631b129c8ef19df1baf04bc41b',30,'mod_scorm','content',0,'/mobile/slides/','5WnadNEEnYz.gz',NULL,3554,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(349,'84d3ad58e6ff0629bd35665d6b5ee108ab88b53e','f5be0824010b8cd2f3de3e1242be4a5c5745042e',30,'mod_scorm','content',0,'/mobile/slides/','6EETQHZ0s8f.js',NULL,17567,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(350,'5dc0b190b9bc9d5bf6acd0ba01d6cf86742278ad','0bbc19601f165663babacea166c7710e2a19829f',30,'mod_scorm','content',0,'/story_content/slides/','6LPuqfMFC4B.swf',NULL,3843,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(351,'686cc6baf7aad9f301ee61a453c4853a2212b04d','5a583408928b817d26dc4bb6bd0bdecd732e8183',30,'mod_scorm','content',0,'/mobile/slides/','6LPuqfMFC4B.gz',NULL,3548,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(352,'56ebb64e5c225edd5455583b24b888fccf683c0e','e502d53cae3138d8aa98e699f0b050c6c4d58485',30,'mod_scorm','content',0,'/story_content/slides/','6inKYZyrYwc.swf',NULL,3854,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(353,'f38a4f3efb8bf12641b3d3ef8f86c03455bc50f2','b50111ba98c947726ed7de5173d558d3f961c80d',30,'mod_scorm','content',0,'/mobile/slides/','6inKYZyrYwc.gz',NULL,3558,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(354,'ed25f38b652d4c047521c1f87912525ae3256d06','272daaf9a83b29c2c0629e59895fa1b42b80d0dc',30,'mod_scorm','content',0,'/mobile/slides/','5WnadNEEnYz.js',NULL,17568,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(355,'4488158da6fe7f47966462f6d46cf62708463000','4f012b15517abb4c799e5071c5f60508bba798ab',30,'mod_scorm','content',0,'/mobile/slides/','5pVDFUVSm38.js',NULL,17568,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(356,'c1307c94e9ee57a4a366f0bfb2972bb26e985693','89eda673a39fae9fd37128a8e354570ac8cf5434',30,'mod_scorm','content',0,'/story_content/slides/','6SbCb68KFAA.swf',NULL,3844,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(357,'adbf5361ce75bd5791539ce530252ddfee3788e7','673f58efdcb72e4c31fa3099c9c4eeb9797ea806',30,'mod_scorm','content',0,'/mobile/slides/','6SbCb68KFAA.gz',NULL,3552,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(358,'aefb749a2b76ff03d3bb6c350d4765cf8ba7597b','721b45820835d40ff931f102b00e8d00336896de',30,'mod_scorm','content',0,'/mobile/slides/','6inKYZyrYwc.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(359,'f247c69674e8475213e59442baeaf1a8393b369c','7a45b1233a973abf7c0c416dbd63abb61fde8a4a',30,'mod_scorm','content',0,'/story_content/slides/','5yoDlQYSljm.swf',NULL,3847,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(360,'1a84ccf1a66f20179601bf61da4f3b590d8df91c','d9b671ca2985d1829c8fcedbc62f5ed3e566c3c0',30,'mod_scorm','content',0,'/mobile/slides/','6LPuqfMFC4B.js',NULL,17556,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(361,'524c59c15d60d6bacb93c3bd32bdc41291266bf4','71d8a39364e13931dbf117a1cdad2cfd872b4a35',30,'mod_scorm','content',0,'/mobile/slides/','5yoDlQYSljm.gz',NULL,3553,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(362,'ef0582facb78cfbb5ec44f9e76faa0112f7a5373','6c25911c65227ae91c5653641abc12735550fb5f',30,'mod_scorm','content',0,'/story_content/slides/','6TU3SaYv0FM.swf',NULL,3854,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(363,'bb4e5241e0ddf4739a028487478e327b88354d24','b5fffbb5b598bc00bfebe7f7c6e010f36ba760d9',30,'mod_scorm','content',0,'/story_content/slides/','6oHe5o9jeKP.swf',NULL,3833,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(364,'ebf6e8403ead25bdb902f5df28f59520681855fb','5cd0930dc4f8984f1f54bad7e2694c0dde753f31',30,'mod_scorm','content',0,'/mobile/slides/','6TU3SaYv0FM.gz',NULL,3560,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(365,'631900026d1daae42f51d67206532d3a6adc6746','23c881bfd074669b39220a6310c9eb96810b7450',30,'mod_scorm','content',0,'/mobile/slides/','6oHe5o9jeKP.gz',NULL,3540,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(366,'d7fbfe7cb7ccf123b16cbce350a67fa32ffeea5b','8a8161ce712ba70fa20861de7ffd3af4e0961c0f',30,'mod_scorm','content',0,'/mobile/slides/','6SbCb68KFAA.js',NULL,17558,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(367,'508e4aa5a284831837c1ba4bbd8267ae65576304','67dba3cfe394b8360d6c2e4184fde99009b8c16c',30,'mod_scorm','content',0,'/mobile/slides/','5yoDlQYSljm.js',NULL,17553,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(368,'d6888a21813a04744bd4e526ac1679d8831d40af','a55b5514522fbd76ab9fdf889075a6375831a07c',30,'mod_scorm','content',0,'/mobile/slides/','6TU3SaYv0FM.js',NULL,17567,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(369,'c95cb21b1e2e868b957fd46ecfb3ac551899c300','a14034250e1612a781b7bfac7e44161d0052abfe',30,'mod_scorm','content',0,'/mobile/slides/','6oHe5o9jeKP.js',NULL,17565,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(370,'6b9b8105939343ca4625ca9f52a3693f382fc2d2','90d98ab0ec2a00279fd94b69d77498ed9015d222',30,'mod_scorm','content',0,'/story_content/slides/','6enyhoguWG7.swf',NULL,3855,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(371,'c41062f360a4aac0e86bb2f7d0ad66afe6e0acb5','18ae0058a58e75de1cd81857497f67e5a28b74fd',30,'mod_scorm','content',0,'/story_content/slides/','6Kt30Li9YFT.swf',NULL,3839,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(372,'ad55bd041caf1b338eaebe530619b681652301a1','17238adfe535ec8d4ff06e5763aaeb7332e2f311',30,'mod_scorm','content',0,'/story_content/slides/','61MmppR3DqV.swf',NULL,3836,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(373,'d8ccd2c06be7cc1b7fb1c57b96ff6e48c6a1b0c7','3b18b48c0bdd08760ad6c17bdfde7cb8b6e37745',30,'mod_scorm','content',0,'/mobile/slides/','6Kt30Li9YFT.gz',NULL,3543,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(374,'a400b687ae2512f29e7ceacb4699964ef4df586e','dd9bdf2f269d57f6bfff53196a94990e1f7a8b04',30,'mod_scorm','content',0,'/mobile/slides/','61MmppR3DqV.gz',NULL,3544,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(375,'06938bf379deaf2bcc9ed33083ddc86d661e5a92','8ff82b60bd271b8ebdfc82bc443e808584fcce69',30,'mod_scorm','content',0,'/story_content/slides/','5jMyDsT22uH.swf',NULL,3865,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(376,'f8cb4615e89c6c9022294fc8791dba1ff263ff83','c190a32513c0d65a99435c9a71cbf2d3fcc91577',30,'mod_scorm','content',0,'/mobile/slides/','6enyhoguWG7.gz',NULL,3562,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(377,'0c8b9cd74a94e625394e8aa7a1fd8dbeb049bff5','a03dc05a3ee1cff49389e3fe3d8a9a793751d13e',30,'mod_scorm','content',0,'/mobile/slides/','5jMyDsT22uH.gz',NULL,3574,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(378,'ee1194963b00e4e00157753e8afa81f142957a36','32a214e1117940e125ee2de1c3fd21b7bd2f320f',30,'mod_scorm','content',0,'/story_content/slides/','62Yoo4qOsxf.swf',NULL,3838,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(379,'ad6027dfafce739d51b90d8d57801ae7d9c0cde7','6dd3c36e8bdd3831c12820c95761e68427fb7a2e',30,'mod_scorm','content',0,'/mobile/slides/','62Yoo4qOsxf.gz',NULL,3544,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(380,'5ef619d42a3cf650a2784251041e93356591c6ee','dd442a09b12b93fbc60f868c37d611ff8da35472',30,'mod_scorm','content',0,'/mobile/slides/','61MmppR3DqV.js',NULL,17553,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(381,'35cbac45b184a6ce4ff38e0a18e38f0cddf8092f','865137352a717c212bac590602827e77958aa781',30,'mod_scorm','content',0,'/mobile/slides/','5jMyDsT22uH.js',NULL,17607,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(382,'55684f6b4817afbcea781e2fc1e6ee8915146127','6e77484bf6c36f1eb796ed0c93ec83e75af15447',30,'mod_scorm','content',0,'/mobile/slides/','6enyhoguWG7.js',NULL,17572,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(383,'3a24e65999aed59a2ca7f394665a526c9fd883de','39b15429b7b0881244e73d328e1c299a8dcd443e',30,'mod_scorm','content',0,'/mobile/slides/','62Yoo4qOsxf.js',NULL,17554,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(384,'bb672c63090a4e7cda2674ccfa6dd3282ffa7c97','dcfb18a015affc0bf6cec670beaabc321f2f1754',30,'mod_scorm','content',0,'/story_content/slides/','624Rn5dzm5V.swf',NULL,3839,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(385,'bd35968639224eb0aa570b27ab77fd21ccac0fc7','e6945894b4391f2a29b28aa17b3b76345dfc4872',30,'mod_scorm','content',0,'/mobile/slides/','624Rn5dzm5V.gz',NULL,3547,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(386,'ff7e664ab3180a635ba1b0c9b250a88ce318cbde','86762f9dd40961589ba7a57348fea3b6e12722b0',30,'mod_scorm','content',0,'/story_content/slides/','5oTBwOERUS8.swf',NULL,3852,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(387,'2672f06dfc456e03030593943e6249aa15d22604','4cabdfd2014837717498e2d0b30dff2d0126ce94',30,'mod_scorm','content',0,'/mobile/slides/','5oTBwOERUS8.gz',NULL,3560,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(388,'37ab1e4d9c2ea659962d3159ecc3fc483e6bc9e4','52f96c33acdfb9b7b785111493c469e860552e3d',30,'mod_scorm','content',0,'/story_content/slides/','63k0Ngu9M0Q.swf',NULL,3848,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(389,'fd3bff5a2882ca53c8457e9fb574c9ee8e49ae17','e90fd9f53d334d86b71eed4560d47653440f328a',30,'mod_scorm','content',0,'/story_content/slides/','6kpBYHuWERO.swf',NULL,3860,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(390,'fa6c9ab88d88e1c08fcdc47f4f3b00b2e1dbd9ce','88dfe3e2a854585dcb278e02198a1c43baf85071',30,'mod_scorm','content',0,'/mobile/slides/','6kpBYHuWERO.gz',NULL,3569,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(391,'1bdd8335b325242823ae2bdc4f06c22e8dbe5a65','bfee8200e1385838b1d2c5c97574ac32e2b4db89',30,'mod_scorm','content',0,'/mobile/slides/','63k0Ngu9M0Q.gz',NULL,3554,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(392,'39ab98c341b09743ab55d8d064332b5e34e871f5','5e47fd41c9aabb486daa9a967111a7c9da731284',30,'mod_scorm','content',0,'/mobile/slides/','6Kt30Li9YFT.js',NULL,17563,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(393,'d72a8ab94ed8a223b084af11cf660c8e9aa44b9d','d908a63386a401a03402de01326e006bf1bc78cc',30,'mod_scorm','content',0,'/mobile/slides/','624Rn5dzm5V.js',NULL,17554,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(394,'acde4c2bc909a88538a3b731497655b0da4bc9fd','a8c66c29660e411fcca54cddc9a83582f613bf52',30,'mod_scorm','content',0,'/mobile/slides/','63k0Ngu9M0Q.js',NULL,17573,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(395,'3992e8032194b7581db0ebf86c7e19d2f4ce2767','189ce6be6fae73c31820dc235ff4a6b624ab9c21',30,'mod_scorm','content',0,'/mobile/slides/','5oTBwOERUS8.js',NULL,17579,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(396,'567e420ca970d57cead98f01c050e53004c2e251','ed3ff3af8e049afe5d6725c77099d9ad8607b6b0',30,'mod_scorm','content',0,'/story_content/slides/','6DIoWGJzifu.swf',NULL,3848,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(397,'fd15cb11dbe77b376ab61175405cbee430c3310e','24aa31fda36932298f26c05bda0f5ea188911b07',30,'mod_scorm','content',0,'/story_content/slides/','6SC2F12NmUh.swf',NULL,3843,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(398,'f8405d3a11cc67b100498b0035f20262d98ea20e','d0de4ceeb7c940a39ec4a8794bd3c0ec9546602f',30,'mod_scorm','content',0,'/story_content/slides/','6Baxm9erM0z.swf',NULL,3852,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(399,'e7dbb403eae349c819fa1119ec7868e4a6dcc43a','adb1c2f5755d0438e178cd69a53bfb7adf323e9a',30,'mod_scorm','content',0,'/mobile/slides/','6DIoWGJzifu.gz',NULL,3553,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(400,'4ab37987e140bf3b90eb1d3b894a9307ff92be79','1d7cae7389708287446293211d903b3e3890677c',30,'mod_scorm','content',0,'/mobile/slides/','6Baxm9erM0z.gz',NULL,3563,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(401,'4bfe21c1e05b6a3d2f87dd60c5811aa84b0775c6','8eae7f2fcd29e490e889543d21d5df9ce3bb7d7d',30,'mod_scorm','content',0,'/story_content/slides/','6EvPE3ni3qJ.swf',NULL,3830,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(402,'50b0c79c77f312d4d316d6888e74c2d75cf8fb2c','16e83dd17a3988af3e25d6e6dd41d06c3b962c0c',30,'mod_scorm','content',0,'/mobile/slides/','6SC2F12NmUh.gz',NULL,3552,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(403,'d2557410ceb6797a0c1f4daa4f2bda7da4996d90','6f3b7fdec027e57a4aaca1e5aafd63d5fce72e73',30,'mod_scorm','content',0,'/mobile/slides/','6EvPE3ni3qJ.gz',NULL,3537,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(404,'65d6ee3d475d7367128480bda2dce11fa382c9f6','31e2536d84eebc60a2cd642f8018036cbc1e823c',30,'mod_scorm','content',0,'/mobile/slides/','6kpBYHuWERO.js',NULL,17585,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(405,'eb1ba54810b9a76c70719983ef1f5f47bbfa5a0a','3e4d7e08372457c704816f75bef6b19cb0ed0fb0',30,'mod_scorm','content',0,'/story_content/slides/','69Ma8BUCODr.swf',NULL,3838,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(406,'5f84fc02ba269e398ad6c2e22fc39f270dcc8d26','a37827dbb58d8cec266591e714998f3ff52cc9d4',30,'mod_scorm','content',0,'/mobile/slides/','69Ma8BUCODr.gz',NULL,3546,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(407,'9947a0aba423a578810d93ea99c46085d8693779','a0f4dddc562900e241e4aaa3c437d1809c140940',30,'mod_scorm','content',0,'/mobile/slides/','6SC2F12NmUh.js',NULL,17556,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(408,'decb739e104802817272d740a04303d21738492d','adbb37c07924eb7a93eba674a3b8870c43aea473',30,'mod_scorm','content',0,'/mobile/slides/','6EvPE3ni3qJ.js',NULL,17559,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(409,'f1ffe92a8c0321a9d4424a6fa8ee632008878652','5e6f99158e50c167576adcd072f9b8ce0546dffd',30,'mod_scorm','content',0,'/story_content/slides/','6JgIZn3Yb1D.swf',NULL,3842,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(410,'555fddf847b0e4ed449409684454f3788d4d3e8e','76b15bfba094564e5ab04b717c50bd8ba5e60084',30,'mod_scorm','content',0,'/story_content/slides/','5Wjkd9uSMg4.swf',NULL,3832,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(411,'b994975bbc6e48e46b01ff1120160432cffd0657','4b617837f095e59e6de09fe8f4a0a19b4f70296a',30,'mod_scorm','content',0,'/mobile/slides/','6Baxm9erM0z.js',NULL,17598,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(412,'164e598b2d55b1eb9d1ab572875db2b5543a61a5','0360d4952fe69177de99ca6698218d14fe8a8098',30,'mod_scorm','content',0,'/mobile/slides/','6JgIZn3Yb1D.gz',NULL,3550,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(413,'39f1137f3fea7d54f78272ae80a2116f91aefe28','0e40acb65064f6544c884fa8692bd7d18c43f4fa',30,'mod_scorm','content',0,'/mobile/slides/','5Wjkd9uSMg4.gz',NULL,3537,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(414,'27e2030d6eb09c96325bb912a84bdf126e527944','876ba00215eb9273601bfc0a9688b58ea31971bb',30,'mod_scorm','content',0,'/mobile/slides/','6DIoWGJzifu.js',NULL,17573,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(415,'3750ae370cf6c11de8662bc886f310b2bebc3bf8','ca5b308bac4d0b2ec5df93e3d74dffb52fb441a6',30,'mod_scorm','content',0,'/story_content/slides/','5bWdCCHSLbC.swf',NULL,3855,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(416,'e73c69232c017a860bf32fd69e001e631f4a78c4','087a6e2af6936a80bed1a86e35e346e0190a7b9a',30,'mod_scorm','content',0,'/mobile/slides/','5bWdCCHSLbC.gz',NULL,3563,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(417,'78cb663327d3a01cb7c2b15d8fb0e56c82ab4fa5','11df16a33d57aee6a44220e899fea6017561b918',30,'mod_scorm','content',0,'/story_content/slides/','6TlRq6Gachp.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(418,'ec5780b35418d65a6dacfe138241636947ddf814','ed1449e93651214862e92046f41f55ef2ed3ef17',30,'mod_scorm','content',0,'/mobile/slides/','6TlRq6Gachp.gz',NULL,3554,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(419,'b1e0559e51b0ca3e742b3280dbd74833bcb35c1b','674a9d7d94c595e652618ff807cf7f8f588ce4ca',30,'mod_scorm','content',0,'/mobile/slides/','69Ma8BUCODr.js',NULL,17554,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(420,'db01ce5348ab8193ca476230ebbe12171174771d','a244372a6af37ccefb75fe77da99d45f93ef2e78',30,'mod_scorm','content',0,'/mobile/slides/','5Wjkd9uSMg4.js',NULL,17561,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(421,'0945fc079fcf4328d5b674e55ef31e111fa82793','567c3cb2b7de2718856e1f52b379ba36f8d897ec',30,'mod_scorm','content',0,'/story_content/slides/','5poK1SuzgWv.swf',NULL,3830,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(422,'03bb68fe8f92930a12ef95a6863979cb2c75854d','279f4ae4e9b9e64e0887bae6fd69fc680d199bc4',30,'mod_scorm','content',0,'/mobile/slides/','5poK1SuzgWv.gz',NULL,3537,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(423,'1aac5cc068a87a7026444e51e7166d895985b9d3','75d68b1de1554284682f2dbd38556f6813163926',30,'mod_scorm','content',0,'/mobile/slides/','6JgIZn3Yb1D.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(424,'d2c1d8e0bf8bfc93efaf28affc9f4e23dca8390f','37225465923fcd883bd79aae2cc3b1f7090eec9c',30,'mod_scorm','content',0,'/story_content/slides/','6AkJco77COc.swf',NULL,3844,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(425,'efb4cbf339d1c700a376a78a776e4c0ec510cb6c','dd479bc90803a43e62a9e0b756f562496948ef03',30,'mod_scorm','content',0,'/mobile/slides/','6AkJco77COc.gz',NULL,3551,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(426,'91ded922f5cd6617b03f1674d70628cc825c3fb7','a62b884433104574b4376d33d1557a9d8c3c3b35',30,'mod_scorm','content',0,'/story_content/slides/','69J9e0ppNDS.swf',NULL,3840,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(427,'d0dceeece7944b5a3afb7f0e88c0482854dc76af','6f54928866dbf318888d0b6470b02f0ca7e3998a',30,'mod_scorm','content',0,'/mobile/slides/','69J9e0ppNDS.gz',NULL,3545,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(428,'05d9252b1279a8c27f9b516f206b61e191d89e4d','4cdc6750f0956c6e0e87b86615734ad7dfbfa1a7',30,'mod_scorm','content',0,'/mobile/slides/','5bWdCCHSLbC.js',NULL,17579,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(429,'be9b3a3db0c2afe54b4f76f443ffdad77d13ccb4','0c4c4ef578d9774839491b9b11e2dc95df2845e1',30,'mod_scorm','content',0,'/mobile/slides/','5poK1SuzgWv.js',NULL,17547,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(430,'0d1a6805849adf89ae46567a9f0c44f4673a6cda','4389c8f42c7c559c39a68f333e4f9efe82582e98',30,'mod_scorm','content',0,'/mobile/slides/','6TlRq6Gachp.js',NULL,17573,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(431,'5f274b7439f239a10aad9029047ca15525c560f6','5ab88523990fa100d142b9cd2baf578b1ef4705c',30,'mod_scorm','content',0,'/story_content/slides/','6hRq4yRE6RE.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(432,'4fdb7f99d5617b7dfdc0ca1ae947a0567c008915','b4b5c29eacc90fe1438c16eca30583bff89f152d',30,'mod_scorm','content',0,'/mobile/slides/','6hRq4yRE6RE.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(433,'d9ead97159fc68a1fa73eeb580a7453737e9f2fc','5c96e455dae200d812398d8b4b92f3bc8d0d3290',30,'mod_scorm','content',0,'/story_content/slides/','6QBl1D8DOoe.swf',NULL,3854,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(434,'72cb6105160bf726ce922cdfb84edbbf91e09ab1','279638c7a355402251a9f600b855b858940d906c',30,'mod_scorm','content',0,'/story_content/slides/','69Q0YIHyjaU.swf',NULL,3826,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(435,'72432c2fc9f0a68ced071aff0317292038a60542','3e64fbcbd973c5a300a04eb6939adb5e44796808',30,'mod_scorm','content',0,'/mobile/slides/','6QBl1D8DOoe.gz',NULL,3563,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(436,'d9766a5e0973c15f93013cb82c1e955e04d2306b','5f70945f8cc71d802998d4529c137581a4813b3a',30,'mod_scorm','content',0,'/mobile/slides/','69Q0YIHyjaU.gz',NULL,3532,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(437,'7f978f3363097c9454b25bb8226bee697a799a5e','f9f0174afa6bbbb74c96da7cdacd41d1ba5080bf',30,'mod_scorm','content',0,'/mobile/slides/','6AkJco77COc.js',NULL,17563,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(438,'f8c56fc5d7ccb2f924042477c60e1059fea186ab','02ae8df4d3118ef305575401d9edccaf38e5821c',30,'mod_scorm','content',0,'/mobile/slides/','69J9e0ppNDS.js',NULL,17559,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(439,'276da3b8a0eef5ee9711f2276d75e4b787a7f9d1','39b0738c261e3da3eba56ebf466767590b83d1bc',30,'mod_scorm','content',0,'/mobile/slides/','69Q0YIHyjaU.js',NULL,17547,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(440,'6dc694be640902c7020f9c2306fdb4680ae8d084','175a18a9016255e57a68c4be3af0073471079d7e',30,'mod_scorm','content',0,'/mobile/slides/','6QBl1D8DOoe.js',NULL,17590,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(441,'e88ad9efe501e185a6d7c65156e442a3d4dfb1c8','145d11a219b61367486476bab15ef49086e16cf7',30,'mod_scorm','content',0,'/story_content/slides/','6ZxFo111xNw.swf',NULL,3831,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(442,'027fefa64af96e46e6cd3cad8e20e8f93b6ebf49','1067e11ed529812accdcbecb499d1a8768393ef8',30,'mod_scorm','content',0,'/mobile/slides/','6ZxFo111xNw.gz',NULL,3537,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(443,'db5edd2da3f70787a82dcdedfbaa76018f2f3b4a','b390c7b1d95fbd62ab16795e1b6a617b71de4f4a',30,'mod_scorm','content',0,'/story_content/slides/','6Lu497EDaHT.swf',NULL,3846,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(444,'45e331b5a5ddf30eb83950daf8f624004fa31e08','ccfbd06a49fa0f7f66b8e129f6cdf94d94c14899',30,'mod_scorm','content',0,'/mobile/slides/','6Lu497EDaHT.gz',NULL,3553,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(445,'22ad8f0ace88fbf7abd412874339a34adeec4f9c','02d8b5c788a6709892fd5223ca736079db13cd74',30,'mod_scorm','content',0,'/story_content/slides/','6MRApYFwZ0H.swf',NULL,3833,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(446,'2d87136490737ffd72d033862ec832d40d08042e','9a2169546489bba33fd9f75b57a94f7eca96a6ed',30,'mod_scorm','content',0,'/mobile/slides/','6MRApYFwZ0H.gz',NULL,3537,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(447,'9b9ac5e31209725d922e0e01ff00d62e7b171ef6','6e60a3869ed9a5508693715ef3278bfc63f9b529',30,'mod_scorm','content',0,'/mobile/slides/','6hRq4yRE6RE.js',NULL,17568,'application/x-javascript',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(448,'0860a3947d32ce723c4400dd21055394268ab95d','76fd8a389bbc9570b1429ba6dad42a02128ef472',30,'mod_scorm','content',0,'/story_content/slides/','69HARjiQiF8.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(449,'65bd26d5bdd25b446fa6476cfd649dfedc10f97e','929ed90faafc53fead3c78907ceee2109836b561',30,'mod_scorm','content',0,'/mobile/slides/','69HARjiQiF8.gz',NULL,3557,'application/g-zip',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(450,'ba3ddf3a514c889675cb9a640ba171f180c6835c','cf3ef6fd7f8b1c42fa326e09de0a2319b673a2c7',30,'mod_scorm','content',0,'/story_content/slides/','6ZTiQ79iku9.swf',NULL,3856,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458054,1462458054,0,NULL),(451,'f31964f6103ac72272fc580c4503c1ec22240ebd','2dc00b1102d8a72c237dcd4d66f94b466d27ddb0',30,'mod_scorm','content',0,'/mobile/slides/','6ZTiQ79iku9.gz',NULL,3561,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(452,'855b34d54d2c9e63c484b1fdf9eeaee1818fbce9','cd94197ad4e0eb352b064d6be4205e950a215509',30,'mod_scorm','content',0,'/mobile/slides/','6ZxFo111xNw.js',NULL,17561,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(453,'20ac5ecd09d6cdf8545629fe603978cb1b2b298e','ef2da2a8e9bc4e5a860bc3e68d0b4699ceaea02b',30,'mod_scorm','content',0,'/story_content/slides/','5w68UKtwlJS.swf',NULL,3834,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(454,'6310dffb2a4d130f8a908278396933c1561603a3','786272f4b6d7ec5bd22cbb600bf5c5c6eb641dc2',30,'mod_scorm','content',0,'/mobile/slides/','6Lu497EDaHT.js',NULL,17565,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(455,'ffaf52733921fbc178956ffb50a315f68d6d470c','9f01e913044d326218a667a9f101149f000d578d',30,'mod_scorm','content',0,'/mobile/slides/','5w68UKtwlJS.gz',NULL,3540,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(456,'606b7e579a57ff8f1d6625bb13ee58b6577b8d64','f882c36b3a350a3390cfb9d843674fd70c0c1974',30,'mod_scorm','content',0,'/story_content/slides/','5uhUtFfDxIa.swf',NULL,3841,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(457,'3b2684afe28e40260f2a3fb5a13f630db314186c','aa33716db4f52fde5a3bdc688eea03c301c4e3eb',30,'mod_scorm','content',0,'/mobile/slides/','5uhUtFfDxIa.gz',NULL,3547,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(458,'76ca33cebf701b514a9c42afacad81dfed1db7e1','185ce8513aa011e34043be13cbd835e99a439856',30,'mod_scorm','content',0,'/mobile/slides/','6MRApYFwZ0H.js',NULL,17561,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(459,'f6302a3ba9bb54577b9f859049d329616b32ff2a','7c961892557cf3f97527b83c341e0b322197d5a4',30,'mod_scorm','content',0,'/mobile/slides/','69HARjiQiF8.js',NULL,17564,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(460,'20a1958229e42b1561a1d54bb806afba47684111','f99e94c987f5019ece9eb5eee136804ac7e5338b',30,'mod_scorm','content',0,'/story_content/slides/','6F5dC7UJZHm.swf',NULL,3830,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(461,'c7cb76d09b4ea2c7a7b960027686efae407f0ead','2bb7904563ca0a4619c3200099891e368f1aa6b8',30,'mod_scorm','content',0,'/mobile/slides/','6F5dC7UJZHm.gz',NULL,3535,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(462,'3f23d767958bf4833c9ceb3125bc75bc5b76cc5a','fce6cf211496a270bb2d6897babe068ba3826238',30,'mod_scorm','content',0,'/mobile/slides/','6ZTiQ79iku9.js',NULL,17570,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(463,'39e081777683cba36370a972896ae0b34eef0cd7','974d489094317de54625f68fa49a27cfc6a65881',30,'mod_scorm','content',0,'/story_content/slides/','6cngoiQ3nVC.swf',NULL,3844,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(464,'2e6ff7c7e11e202aa42b1d4fcc79c9456596e41d','bb952e836e238a7a20566f292cbbd688d9ebcaf9',30,'mod_scorm','content',0,'/mobile/slides/','6cngoiQ3nVC.gz',NULL,3552,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(465,'f6967b1858c394f0100d1b45b6b738942feffa00','b43979e54b7ca2ccc7b579a08370b23f653f6d93',30,'mod_scorm','content',0,'/story_content/slides/','5sXoWQopVL3.swf',NULL,3851,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(466,'6d7374cdb5e538d3e1e789da5a27deaa7bce3783','117dcc7328395055f73e603219f36a3d72f14bb3',30,'mod_scorm','content',0,'/mobile/slides/','5sXoWQopVL3.gz',NULL,3558,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(467,'f6a22fdd22fdffc5e3151079e0783a1bdc32d801','835cb7ccf14f7d45653a6094068a6e160a08510b',30,'mod_scorm','content',0,'/mobile/slides/','5uhUtFfDxIa.js',NULL,17567,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(468,'489aeaf9dc5debc8364108a74a6c2b67199eb306','e3c5fd04cc89d66f38659abd22753f691f2d8416',30,'mod_scorm','content',0,'/mobile/slides/','6cngoiQ3nVC.js',NULL,17565,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(469,'d09503b529424214064649f94ba875dcfc21e0b1','38a551c24672604b87e7001769e04eace4552e4e',30,'mod_scorm','content',0,'/story_content/slides/','6lmHf2LAWs2.swf',NULL,3837,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(470,'f2698457a7067ddf29092d65ce5e96e7949260c7','c09e4e95fe3310d4e77c5c546aea4ec6101ccc4a',30,'mod_scorm','content',0,'/mobile/slides/','6lmHf2LAWs2.gz',NULL,3545,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(471,'222ed7f3ddaae98e490b6d5c1e60afc48618fda8','f7a9f63ba656a1331ac9e0a9fd9192123d87d71e',30,'mod_scorm','content',0,'/mobile/slides/','5sXoWQopVL3.js',NULL,17568,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(472,'e24e49c59eeef3abd364bd579e6093cefd712e8d','edd2858b06ff8048bd37e5e8847d08d7b7ae9ddb',30,'mod_scorm','content',0,'/mobile/slides/','6F5dC7UJZHm.js',NULL,17556,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(473,'56853c07a608c840afdea5736dac1cc0b352db3c','b57c8914b2510d1e131d157f18de76098b2d9c21',30,'mod_scorm','content',0,'/mobile/slides/','5w68UKtwlJS.js',NULL,17558,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(474,'b7d88da60e4357ed855129886c9b5721c0b58a11','4e2f725c9aa15b1bc010afce36dcc0895765c8fb',30,'mod_scorm','content',0,'/story_content/slides/','5ilzt7OxCCA.swf',NULL,3848,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(475,'4915500a169a25af78771c5e795c3e9bab8afe41','7a598e9f2841015d326012169349e65d3fca999b',30,'mod_scorm','content',0,'/mobile/slides/','5ilzt7OxCCA.gz',NULL,3554,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(476,'52b80dbf3e8c5c055cc47e93c752804c753d564c','705536a51890b913386ec7f6940c495bdffb1a54',30,'mod_scorm','content',0,'/story_content/slides/','5fdsgy6aPoN.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(477,'46d5ae25511cdc223658d22e3f93ce33e470443e','8cdd875f2eb0fc6eaacec12a7f497c1849f97d2d',30,'mod_scorm','content',0,'/mobile/slides/','5fdsgy6aPoN.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(478,'e6d34c035745075d971706d4110122e14eb864a3','345c8c820dc8fa0b245d427f4f3e9247d6d1cc0b',30,'mod_scorm','content',0,'/story_content/slides/','6NlqXVxlFPl.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(479,'94fa6442f6436c7c835a0916d92042f5a3f1ba37','aa479a9f86aba5efbfd9589b0983013b422b9a0a',30,'mod_scorm','content',0,'/mobile/slides/','6NlqXVxlFPl.gz',NULL,3558,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(480,'01f65260629dcd6cc4609f824bac7102ed84d005','08dccb25c42ff33d23ad01d49069b2865e82acc0',30,'mod_scorm','content',0,'/story_content/slides/','6gZjIZ8HMHg.swf',NULL,3848,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(481,'d58bad238a1a6e7df205270aeb916fb76d11e43e','14e27ef2808275ccd9d355d143af74077b3ed208',30,'mod_scorm','content',0,'/mobile/slides/','6lmHf2LAWs2.js',NULL,17550,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(482,'a32af46a96bd13391297a6a1339ead2fb8c4cdd0','8a1bcb631cd04ff6c80b1b088bcbdbeb8598f9d8',30,'mod_scorm','content',0,'/mobile/slides/','5ilzt7OxCCA.js',NULL,17572,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(483,'b0596365c58844f36afba3a7737703a21c748649','d2d0df04539da5c48e9e41422558f9b2e88ade08',30,'mod_scorm','content',0,'/mobile/slides/','5fdsgy6aPoN.js',NULL,17568,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(484,'d3a9af1bc2aaa94c9731b062d74825283f2d8607','58cfce4db79ea2d1dd3e551407dbc9a3096bc19e',30,'mod_scorm','content',0,'/mobile/slides/','6gZjIZ8HMHg.gz',NULL,3554,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(485,'a075994d4a10bd1f3d0dbb25a4e977eda6e919fb','dfe26a1eb170b8bcd0c666e97bbbb49892aa4c21',30,'mod_scorm','content',0,'/story_content/slides/','6O8mfvEdlaO.swf',NULL,3840,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(486,'63a36dc452a422f56900b54085336c4c8f159bbd','4206f05c6562983f589249d75579008560aa84b2',30,'mod_scorm','content',0,'/mobile/slides/','6NlqXVxlFPl.js',NULL,17568,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(487,'53e7509747425bfdb4bbc529cd7f6d89cfd1ec54','c16f0edc5ac2396e3bfbbf696069e69955af82eb',30,'mod_scorm','content',0,'/mobile/slides/','6O8mfvEdlaO.gz',NULL,3547,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(488,'d49e21d6e397f564112290e5ce1ce47d7724dd3a','19e7b266450bb7a835d188dd9bd0c5bcc76ffe76',30,'mod_scorm','content',0,'/story_content/slides/','6etJR8ftVvz.swf',NULL,3835,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(489,'ee070dade20d3bb8644f877c5fffc612ee7c18d6','cf2391db50c74499e870602dab07451cd3d4a9b8',30,'mod_scorm','content',0,'/story_content/slides/','60xtbE9S2IE.swf',NULL,3836,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(490,'a8a8d2d67512deeb442d2c23427d47f20f883d76','209df78fb931fe7cf3fa44ed2816bd4e894ccb05',30,'mod_scorm','content',0,'/mobile/slides/','60xtbE9S2IE.gz',NULL,3543,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(491,'06c3b6ce399251d18ca744089519239bde9b79ba','774b448eae5ec634f92623900eb77de65b7960d6',30,'mod_scorm','content',0,'/mobile/slides/','6etJR8ftVvz.gz',NULL,3543,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(492,'9b94f2d196495823f4570926486fdda0bae31ffa','96cf9ffa5a5afc5c142faa5945d5d802f9d0ede6',30,'mod_scorm','content',0,'/mobile/slides/','6gZjIZ8HMHg.js',NULL,17578,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(493,'f3ad7b7316a14f46c615513c79876b485b7b3775','b8d64fcf7cbd37b6d4b08ba988667d4b7b8b4363',30,'mod_scorm','content',0,'/mobile/slides/','6O8mfvEdlaO.js',NULL,17556,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(494,'a581865fd4b96b307bd94cf1c834b4fce11a1b86','9135ecdc31cf0b53e925e0644b510686a72ece89',30,'mod_scorm','content',0,'/story_content/slides/','5qbZ77W2Ldv.swf',NULL,3838,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(495,'0a3fa6d6a519c5e976282b2ba9202b624507d40a','6921405d07da460ffa00af5dd80bd281c1e2d27a',30,'mod_scorm','content',0,'/mobile/slides/','5qbZ77W2Ldv.gz',NULL,3544,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(496,'37164dfd12930a02ee05ecea26582f29bc808a0e','4af0e9728073a6365d8c028ec5638bb305eae58d',30,'mod_scorm','content',0,'/mobile/slides/','60xtbE9S2IE.js',NULL,17553,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(497,'77fc005a3e3b0ab5410a862bb34c334085d3207a','a12ea64d599197ee417976a63c13d5b735626a8f',30,'mod_scorm','content',0,'/story_content/slides/','5i1E71teHOK.swf',NULL,3841,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(498,'2f04b510847792c9b8dcd7d5062efa7a85a164c1','760d738dd387cbea2b17cfd47b54bddd5a63d46b',30,'mod_scorm','content',0,'/story_content/slides/','62WrPvGEE6v.swf',NULL,3852,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(499,'1d908717fd2cb2eb1b498bde7d92f516f0fc97d0','9963f48820b0871dba8aebbdf5e5691792761fbc',30,'mod_scorm','content',0,'/mobile/slides/','5i1E71teHOK.gz',NULL,3548,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(500,'b549f87c149c719483ca946742277379b87bb6c2','a330c7b93caf4227b580e4ef3d7b7703d3def318',30,'mod_scorm','content',0,'/mobile/slides/','62WrPvGEE6v.gz',NULL,3564,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(501,'afbb4dcf1ca242d284b184eec819bad518351b8b','265837295e2d7f0a418fdad110eaa3b595f18c6d',30,'mod_scorm','content',0,'/story_content/slides/','5qZfa4q001W.swf',NULL,3844,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(502,'32e3f70b6f8d5c82d193abead12f7056957ae81d','2e6320b2421baafe4bd132d3aefbc3dbfe84da00',30,'mod_scorm','content',0,'/mobile/slides/','5qbZ77W2Ldv.js',NULL,17553,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(503,'e2c7f2aa4559adc8b282f2d644a07a0f44fe5e73','9425cc023a08a66b46706feccc2af94140f4d277',30,'mod_scorm','content',0,'/mobile/slides/','5qZfa4q001W.gz',NULL,3550,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(504,'e1da6cc12e9c5de64aceb2642509e931d2a6e7bd','1f80b4379a61f84dc2eb2eabb81a3941b6b69eb6',30,'mod_scorm','content',0,'/mobile/slides/','6etJR8ftVvz.js',NULL,17548,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(505,'429ecab42a53c7da99a0bef7094b84f651f7f68c','4950b6d4e6c069f051e7b6830bf1d5bc31d41798',30,'mod_scorm','content',0,'/story_content/slides/','6IhUua1qiZ1.swf',NULL,3853,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(506,'ba6e66a410df91bedb9fc3e846f191a072093876','dfba38c012537b71ac6dc952cf0c8ae83634b0f0',30,'mod_scorm','content',0,'/mobile/slides/','6IhUua1qiZ1.gz',NULL,3558,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(507,'8a7bbe0527c15e228f4b52fabcbc540c7e76c085','a999d3e04fda2cbb17f96a5148f7edcd1af8a16c',30,'mod_scorm','content',0,'/mobile/slides/','5i1E71teHOK.js',NULL,17553,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(508,'a54f1ec72d679f9314a19c9e9b6f74293e12008a','c52d5153b291913f0f4da76afd33f84b7a73f633',30,'mod_scorm','content',0,'/mobile/slides/','62WrPvGEE6v.js',NULL,17590,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(509,'eae832974f6e581e142068d19a786941fb25884f','121192e686b9fadda0d0cd0a1ceb9a6f773df682',30,'mod_scorm','content',0,'/story_content/slides/','6b7ae1DKzyi.swf',NULL,3841,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(510,'cd06e1ac77551185dafbeb09e3ffb051c799a5f2','5f326b807ab70b091689be1d0ad18a84a279ae1a',30,'mod_scorm','content',0,'/mobile/slides/','6b7ae1DKzyi.gz',NULL,3546,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(511,'c26d2b1e82cb1be8ba505cbda98fd02a83b38d40','bab7a0c0cfd73f70a731fc4704eb1227d264a40f',30,'mod_scorm','content',0,'/story_content/slides/','5kv9VoSnQpi.swf',NULL,3834,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(512,'bf661db3190d30251dcbd1f91025822624dd855c','cbfdd6998957f191c2201bf3553205d41125489e',30,'mod_scorm','content',0,'/mobile/slides/','5kv9VoSnQpi.gz',NULL,3542,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(513,'82215d844f15bcfd268927e20ef86d9777ca4d1a','801c067946e02f27dda7199c8ef075cd2983b955',30,'mod_scorm','content',0,'/mobile/slides/','5qZfa4q001W.js',NULL,17558,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(514,'e4901b1426f45f849f300458566f3ebc939b6606','ef08008eafc2e5344403c1b1c889e4fd9149226a',30,'mod_scorm','content',0,'/story_content/slides/','6WSBbkU4jVl.swf',NULL,3854,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(515,'31eb9a387f1ec059700a85fae013ab9857713ba1','4db9549c571d5b2a056b264a39dc33cf64f874d7',30,'mod_scorm','content',0,'/mobile/slides/','6WSBbkU4jVl.gz',NULL,3561,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(516,'66aaa3e45f64bc86ac08f2a3a6ea455bc84f43af','beeeee5b0caf57a94b642a030f07fbdfae847af4',30,'mod_scorm','content',0,'/mobile/slides/','6b7ae1DKzyi.js',NULL,17567,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(517,'eb5078e8e30ce1ccc322392afd91d9c960e33853','1054020bc5e73d218c0e52828b2e2617c214daa9',30,'mod_scorm','content',0,'/mobile/slides/','5kv9VoSnQpi.js',NULL,17558,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(518,'08617d85527c7e3a6032c3f1f892768abbefe97a','aa1256158b947c8ae72b5badb4a85465107b516e',30,'mod_scorm','content',0,'/story_content/slides/','5jN80qUO20X.swf',NULL,3848,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(519,'8b67e167c5dc984389efbbb978e1dee933993239','d343a01d028a2e2ddc0d01e0d89d79d382565245',30,'mod_scorm','content',0,'/mobile/slides/','5jN80qUO20X.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(520,'9a6c348588a06794ace32516c985ebe286722b26','695a99a10555d6c6b91bd53ab6b5bc14063b8f38',30,'mod_scorm','content',0,'/story_content/slides/','6p1zBCkiPJK.swf',NULL,3859,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(521,'d86f83804c64b9f99699ba96db98b58e4021dff4','74e78108183b585a1a17fb98e4d783c6a78b65c8',30,'mod_scorm','content',0,'/mobile/slides/','6p1zBCkiPJK.gz',NULL,3564,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(522,'beda8fc565bf4d9135dc155de9d9d580129883b3','43d26e592e868d15eb466752a7b9bf97c451ad82',30,'mod_scorm','content',0,'/story_content/slides/','5lToHth3r4E.swf',NULL,3841,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(523,'d1d5c181125df1d966ae13f4c1e1c80707de7906','24d1c8c8c6339ba630364f397d4f1d9907581aa0',30,'mod_scorm','content',0,'/mobile/slides/','5lToHth3r4E.gz',NULL,3548,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(524,'9239ea6e330a132d9f789d6964faa0c746ebcc81','3292a6febf22c44fb641fd7b21e380d82ae064a5',30,'mod_scorm','content',0,'/mobile/slides/','6IhUua1qiZ1.js',NULL,17571,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(525,'481d81e9cebc18e093baa3a58c0fec227602bcf3','bf0806ee38408b5ec98a3aa5455162fd2e613f34',30,'mod_scorm','content',0,'/mobile/slides/','5jN80qUO20X.js',NULL,17569,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(526,'83b86e0aa4b700ec11358721c1c74980d36161ea','8a539524fc12330b8fbc842d061923e0045925fe',30,'mod_scorm','content',0,'/story_content/slides/','61nGabyQuES.swf',NULL,3856,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(527,'4a2fe3fd0fa1ad28e7fba796ab2c2ec8a07bb0a0','1e29865ec734f75bde7c0e24f854cbfd4f905d48',30,'mod_scorm','content',0,'/mobile/slides/','61nGabyQuES.gz',NULL,3562,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(528,'4e00aae9fb53a52cae1d179849c5f9112eafa325','448c10a75f187e081845d85453c0c75bd0972415',30,'mod_scorm','content',0,'/story_content/slides/','5xSBr3euEFx.swf',NULL,3835,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(529,'1b73daaf2557e09369a1687e4ad912d947f2b383','8b663733fb6af401481cf82c12f0e9fe274bb44e',30,'mod_scorm','content',0,'/mobile/slides/','6p1zBCkiPJK.js',NULL,17575,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(530,'6f79945a231e920affe0a82a53c5651c320055e9','75abbc3a4b6cbc17994a43c2babd665f062d4c5b',30,'mod_scorm','content',0,'/mobile/slides/','5xSBr3euEFx.gz',NULL,3542,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(531,'a4ca3779ae677b4b295f5aa2dbb38858a6afbac3','f306dd30d85e947d16e3fc57f06033f823eeff30',30,'mod_scorm','content',0,'/mobile/slides/','6WSBbkU4jVl.js',NULL,17582,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(532,'23738b2f814b058c42022cdef034164331fd94e7','2d070f3cea530d2308d82dfd58852b3074c8b093',30,'mod_scorm','content',0,'/story_content/slides/','6A0SNdq5Bo1.swf',NULL,3836,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(533,'8aaab170eeff5a375d0a9671eb27b192a491a6e7','f292e9c15414e1067eadbd58eab88ed1242da104',30,'mod_scorm','content',0,'/mobile/slides/','6A0SNdq5Bo1.gz',NULL,3543,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(534,'5bdd4943ecc44bb37d8b4befdfff4e0f7b93294c','0a49dfd54e330c5edc6bafe443068774f30b19ad',30,'mod_scorm','content',0,'/story_content/slides/','6O4DM92FeaH.swf',NULL,3848,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(535,'6074336a69956ac97856ad9d118279c56d8e4d0b','8913414976ebf4d0524471fbdcecce50b347e6cb',30,'mod_scorm','content',0,'/mobile/slides/','6O4DM92FeaH.gz',NULL,3555,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(536,'9063182de33a22e3d410d6b1a1e403fcfd186558','5622ca000046dbb7a6475d324bc486126dbb9d63',30,'mod_scorm','content',0,'/mobile/slides/','61nGabyQuES.js',NULL,17578,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(537,'0b1f5d4deb56c18b21fb36b90ec3189205e54af9','0af55e84cbd0f2d475f1e7887e61a1af5226d27a',30,'mod_scorm','content',0,'/mobile/slides/','5lToHth3r4E.js',NULL,17557,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(538,'07a7eee0e420b7c048429e814e75bb1212918590','c925dabbf49229ece06a55aa6bcebbf58f808971',30,'mod_scorm','content',0,'/mobile/slides/','5xSBr3euEFx.js',NULL,17551,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(539,'075dee3fcc6cec58941657a897e21b36a7d1c259','cec0d16a59b55bde93e4682e4e55ca8f431b94e3',30,'mod_scorm','content',0,'/mobile/slides/','6A0SNdq5Bo1.js',NULL,17572,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(540,'02b94365e537163a9fdf5073180ec51c620e65e1','520df35be90e058e67ffbd8acdb4b6ad4eeb56f9',30,'mod_scorm','content',0,'/mobile/slides/','6O4DM92FeaH.js',NULL,17573,'application/x-javascript',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(541,'bd08f970f47531c0ca8c4bc5aebd968d386e9ed2','5272652a8adb204b5aa7dda56237f79326f04e63',30,'mod_scorm','content',0,'/story_content/slides/','6bOlCuIRn06.swf',NULL,3854,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(542,'9202e1f90016afdeef6dcebb709f82c44fbc29bc','505a1f3132e0112e2753d21d81409a1b5705206e',30,'mod_scorm','content',0,'/mobile/slides/','6bOlCuIRn06.gz',NULL,3562,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(543,'57b0f6de68a449847d36b4fee200e12c058427f7','d08a8713cce6ab2f212e5d4f85c82b0f2630187d',30,'mod_scorm','content',0,'/story_content/slides/','6mckTBejlZw.swf',NULL,3844,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(544,'c9215ddcc5a10a8cccae516161c543fce89cd07f','edddc3ce157917df023b267150424c7412f0e477',30,'mod_scorm','content',0,'/story_content/slides/','6ZDrWs2NB2q.swf',NULL,3845,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(545,'343a56309c288125a0c4c1d4e074c632e17382d6','b8beb026cad2038467329f59361ff745efc4640d',30,'mod_scorm','content',0,'/story_content/slides/','6k2YiJ0cGHN.swf',NULL,3840,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(546,'23e9d74b262ace53ffb96fc568008d8453eff6f8','a8322d8260da0807537d853b49c7055e95cbb3ca',30,'mod_scorm','content',0,'/mobile/slides/','6ZDrWs2NB2q.gz',NULL,3552,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(547,'e191ce8242abfeb60c1641061125c529bfc4082f','3ed452e9755fd72f704ce4fc4a61aab37af533e2',30,'mod_scorm','content',0,'/mobile/slides/','6k2YiJ0cGHN.gz',NULL,3546,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(548,'71c616237f15f92ce8fcb56feaefe820932d1023','3237a065775e7ce8398271d191deaae3eb49250c',30,'mod_scorm','content',0,'/mobile/slides/','6mckTBejlZw.gz',NULL,3550,'application/g-zip',0,NULL,NULL,NULL,1462458055,1462458055,0,NULL),(549,'ceeed261548da8346bf9b0685b09b9e93d1bf398','095d61c0538ceaf0ef8c1c1c6a6a98c742c51798',30,'mod_scorm','content',0,'/story_content/slides/','5oKkkAJBsjT.swf',NULL,3847,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(550,'683b4c4f43166731249160b828d9eb73ca477442','0c30dfa1ccadca1a53752a106b3cdfddbdd38525',30,'mod_scorm','content',0,'/mobile/slides/','5oKkkAJBsjT.gz',NULL,3553,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(551,'c47f607873b7dc0a4358932a0993aac6215157d4','e1132014e6e1d3dc81efcb8637b633025988b1a3',30,'mod_scorm','content',0,'/mobile/slides/','6ZDrWs2NB2q.js',NULL,17560,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(552,'50043250154a79ddb14b1b8d13215d9f90414edc','a8a8d0f571ffaeeb2af4d76cbfa7448e81833b5a',30,'mod_scorm','content',0,'/mobile/slides/','6mckTBejlZw.js',NULL,17555,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(553,'0c679e45afa1bb56597a464de102cbbbceeda18a','81c410e11d587074db02f5aca21140f4c842f029',30,'mod_scorm','content',0,'/story_content/slides/','6pFqSHfg8pE.swf',NULL,3841,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(554,'d8a7a19e60ec5e65214badbf65408043ff46e7d2','c1e98f52e630f1a7290ae337faa18f75ad0e30b5',30,'mod_scorm','content',0,'/mobile/slides/','6pFqSHfg8pE.gz',NULL,3549,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(555,'1585f9e0e6c111cd061a67adcbebf9df6b158861','925f3ebb1453b748e5e07e659d330e176248b035',30,'mod_scorm','content',0,'/mobile/slides/','5oKkkAJBsjT.js',NULL,17593,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(556,'962dd5d56ac5ecf0be205c60ddcd97689effc46c','d8c1cb4b53d01f1940b23c17511a8140470041b6',30,'mod_scorm','content',0,'/mobile/slides/','6bOlCuIRn06.js',NULL,17581,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(557,'92d6adbe73c77a4f738fae73c29f53550584423d','41249ea7519193029779e712cb6886b2f7205eb4',30,'mod_scorm','content',0,'/story_content/slides/','5vN5zBBWeGZ.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(558,'b2a8c3ff8d6c39c41f09ecbbfbc064ca743e340c','700be40c4b48aff8f5e0af12ef36e65f88b00ca2',30,'mod_scorm','content',0,'/mobile/slides/','5vN5zBBWeGZ.gz',NULL,3559,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(559,'f04c08913a3e2f6930fc92cce92e93e3ddec7522','e463d88f5c7f69b5e02cfc251a01266e54788932',30,'mod_scorm','content',0,'/story_content/slides/','5r8I5f2tvM9.swf',NULL,3845,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(560,'10cd4e35eba01d68d58d2d6ce225220f65c3b612','3baf1e11dc2cc353ef8d6b17e4262d9179f50211',30,'mod_scorm','content',0,'/mobile/slides/','5r8I5f2tvM9.gz',NULL,3550,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(561,'2aa5400e840b79b27c8ad728caa92280922e3549','8779d6e04265a388cb2671146a6c3321706601d1',30,'mod_scorm','content',0,'/mobile/slides/','6k2YiJ0cGHN.js',NULL,17553,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(562,'0da83b3b527724431059ca5e3e335c4ae35c1426','3e01c43caa97dff371155eb45361753eba79a68a',30,'mod_scorm','content',0,'/story_content/slides/','6WHx988guib.swf',NULL,3856,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(563,'c1928f7de3c5a6612ce88957377b2cdd84a617a4','d6ba475ace66e2ec2de769c73bd45bf9b4a6a643',30,'mod_scorm','content',0,'/mobile/slides/','5vN5zBBWeGZ.js',NULL,17575,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(564,'9a2658cafa4c7a9aca29a4c3e97c8d1630841b80','498d6fde8b02d44b3d4da3165e2320d7348cfd8d',30,'mod_scorm','content',0,'/mobile/slides/','6WHx988guib.gz',NULL,3562,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(565,'31e8e1b5ef01d877fdd9d338007f10b3907c5ce5','e826f5bc95d960b09d67cea686966eaa1d7b2fe9',30,'mod_scorm','content',0,'/mobile/slides/','5r8I5f2tvM9.js',NULL,17557,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(566,'ad131ee526e61e8d7e76fa36f47ee199de264b62','2527f9eea353b761b37d55909145fccedec06c1d',30,'mod_scorm','content',0,'/mobile/slides/','6pFqSHfg8pE.js',NULL,17546,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(567,'ac928780ee3e2187a765350ffe7cba828665124a','9336bf376a166bdf6b50a4886ae084ea9e139a0b',30,'mod_scorm','content',0,'/story_content/slides/','5fCsJhImCwu.swf',NULL,3873,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(568,'65a928c7ca50094b5ddb27680bb8d65dd86c01f3','01123a6d518b7ef9089422452a818e27c7a03cc4',30,'mod_scorm','content',0,'/story_content/slides/','5e9qFX9Qumt.swf',NULL,3839,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(569,'39fe7653b890f5a4c32166349ba69e5d87db3ebc','cf95f142bcdbfdd25933189d60e53c5bca9aba9b',30,'mod_scorm','content',0,'/mobile/slides/','5fCsJhImCwu.gz',NULL,3581,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(570,'d4dc0a82ea3486cad63edcc00e13361a824062f4','7b6f29ba9a5731862fb1fc5bcb0a77ec0da16226',30,'mod_scorm','content',0,'/mobile/slides/','5e9qFX9Qumt.gz',NULL,3545,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(571,'c16cc006e9589d70fe5a366d04b3dfbbe110b8f3','acb2597a5ceb3b1cc2898a7e8f9f8503aa191cfa',30,'mod_scorm','content',0,'/story_content/slides/','6LJXvdaEimB.swf',NULL,3849,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(572,'5e1b245906f9f1498158a95ddb30145d6caa2e06','baabe9b4e3ec1783306ffd4238eb3e8f4488cf9a',30,'mod_scorm','content',0,'/mobile/slides/','6LJXvdaEimB.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(573,'5207982528b09a7fefcac0217ae9cf95db249394','10893d1fd5b54ab7dde9148bbe0ce54df2364e69',30,'mod_scorm','content',0,'/mobile/slides/','6WHx988guib.js',NULL,17581,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(574,'6bf42585a93709076e378f537ec51b65095ff5b3','b3fb5706a8479b56cc5b11e870dc36b789e21c4c',30,'mod_scorm','content',0,'/story_content/slides/','6JXmGNGQif9.swf',NULL,3862,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(575,'e667a421df317b9eb7405e5c4b3bcdecc121e9b0','e83293d404f798e3f38002748a9f4ff999c2786d',30,'mod_scorm','content',0,'/mobile/slides/','6JXmGNGQif9.gz',NULL,3571,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(576,'fe796fd677ec37d7d1a64dea6f592ff785751d46','57f33e536a6814e640414420aa3239dbcd815a4e',30,'mod_scorm','content',0,'/mobile/slides/','5e9qFX9Qumt.js',NULL,17555,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(577,'87b35ca3fcf19962c6faf8c73d13cd6a517ecc4b','563208c93a5892e83f4ab1909e0683634a2bd9f9',30,'mod_scorm','content',0,'/story_content/slides/','6GLcYM6U1sJ.swf',NULL,3843,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(578,'be96735c9798e60760aa0dd1811e6caf63d4a0ba','c1a2bfb1e52132e28ea5bbb8d760eff1dedcdb9b',30,'mod_scorm','content',0,'/mobile/slides/','6GLcYM6U1sJ.gz',NULL,3551,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(579,'999cfe6cd93cced5d3c2f0f8d034e57433a1466e','cd77ab3244fb6320924e48675e3fa7a5615c6234',30,'mod_scorm','content',0,'/story_content/slides/','6c38L0jn6X8.swf',NULL,3840,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(580,'96c6f8c74fd368d369b09237d8ffbc7cd884787b','5aa6b4dc1250c30247711645140a3421116e857e',30,'mod_scorm','content',0,'/mobile/slides/','6LJXvdaEimB.js',NULL,17574,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(581,'e4b036f67a7b9f240e9a58607f0446be2a1bbfe9','4cafbcba9cb72a419444d4c47acc74414e927a8d',30,'mod_scorm','content',0,'/mobile/slides/','6c38L0jn6X8.gz',NULL,3547,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(582,'72ac4d7fabb8cc4b4e10d425634733a049889434','f087a59e8ae57e75b861ecdea6d7bf8140bcd63e',30,'mod_scorm','content',0,'/mobile/slides/','5fCsJhImCwu.js',NULL,17621,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(583,'3067c9b68ebac79860c7669aefe763b0c87590f8','f7859944f8c810448ad984247cdf4de1bcafb19c',30,'mod_scorm','content',0,'/story_content/slides/','69ylR7eKc3F.swf',NULL,3843,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(584,'24b720e33425c89bcbcf00f724f985ce825bf09f','bdc2e322bdd88d160a356080315799f6656ecb73',30,'mod_scorm','content',0,'/mobile/slides/','69ylR7eKc3F.gz',NULL,3549,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(585,'11bfcd4f029c79f6aeb4977a8a054b3c39224151','56c2813f0427cd52a3dd1546acd2eed47b795327',30,'mod_scorm','content',0,'/mobile/slides/','6GLcYM6U1sJ.js',NULL,17573,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(586,'b21139e3dff05969e464908878cf0f51800ecbfd','2ec269e414863907d8bc39ea6a0c364a7053eaa6',30,'mod_scorm','content',0,'/story_content/slides/','64ofgBD2qoP.swf',NULL,3843,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(587,'91b4735339c5d6b0ad256c9cc742c219a1766e85','e6f43aaa1c484e83e2fd9264148bb8eff46b666e',30,'mod_scorm','content',0,'/mobile/slides/','6c38L0jn6X8.js',NULL,17562,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(588,'e575816a0e5ebad0b2d668bab4976544a20f6837','6cd2b6078b03fbb6646733fbed7fc23dacb425b8',30,'mod_scorm','content',0,'/mobile/slides/','6JXmGNGQif9.js',NULL,17594,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(589,'d012f7fd179d47f8e1ca8576a89636e3f68e02c5','2dcde5d2037783875d433118eeee519240e3066d',30,'mod_scorm','content',0,'/mobile/slides/','64ofgBD2qoP.gz',NULL,3548,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(590,'4f9f4a56393157d05808eddc038c1d4453713bd7','1955f308ee1de48cb780601d68f300d736782e5c',30,'mod_scorm','content',0,'/story_content/slides/','6fRsCKsq7vT.swf',NULL,3855,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(591,'9c4a4b18e155eabb5f89594aebb1501478b80a66','3864225c3da05853ab868e9080a53a3ca75cd439',30,'mod_scorm','content',0,'/story_content/slides/','6UwpwqhY6HK.swf',NULL,3851,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(592,'5ef78112cc99277465e1a57c1e52ae94873c8b0f','4cebfd769bdbc910f9883810b90f0f312d5b2edb',30,'mod_scorm','content',0,'/mobile/slides/','6fRsCKsq7vT.gz',NULL,3563,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(593,'49498d4cb3bfaf0ace9b78306336e4c9960fc029','112360dd1a8d8104dfcc474205429c5ed8a4b816',30,'mod_scorm','content',0,'/mobile/slides/','6UwpwqhY6HK.gz',NULL,3558,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(594,'a6149167e73d0f5b65ffed144dfdc4a5df37ff4a','d2bff41ff8ac42d8141bf1c6051b99e5c453d9d9',30,'mod_scorm','content',0,'/mobile/slides/','69ylR7eKc3F.js',NULL,17565,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(595,'f6925c01a659a6ad222d5e80e0bd07ee4a74ed6d','060f85b40c2f71c5f93db96c68ad4a282cee0398',30,'mod_scorm','content',0,'/story_content/slides/','5Ui9hk42yxJ.swf',NULL,3842,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(596,'aa22fda8280606798a659cf154ed5af57659a253','8bcbecd439deec0d4473b1908fb222b2f056aba7',30,'mod_scorm','content',0,'/mobile/slides/','64ofgBD2qoP.js',NULL,17564,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(597,'0f0c48ccf24e09448ca96c225c2cc1c5c3f8c222','5c102d18f61c19dd5425bbaabb1a97648ece5ac0',30,'mod_scorm','content',0,'/mobile/slides/','5Ui9hk42yxJ.gz',NULL,3550,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(598,'82095f03e18305db7b42ba981be3d9d3cd3ecd71','adb978d27421485d34ca35712c6542f2a52a06bb',30,'mod_scorm','content',0,'/mobile/slides/','6fRsCKsq7vT.js',NULL,17581,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(599,'9729086d351e1c34fe48e64ad325585b35e2dc9d','b6ef72d3dd083d86e8f67006fc00471a71a883d5',30,'mod_scorm','content',0,'/mobile/slides/','6UwpwqhY6HK.js',NULL,17568,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(600,'4d114759120ec4c4235514153b529ce591643726','4d6ab5d9bfd96826e0d7f8bb148d964f4217952e',30,'mod_scorm','content',0,'/story_content/slides/','6OXQSAgrTXF.swf',NULL,3853,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(601,'0c2d7f9c497ea2661f1a166d93c2a5d0a48f9c29','067dc258598bfe6855a097c3c5530dc3db533247',30,'mod_scorm','content',0,'/mobile/slides/','6OXQSAgrTXF.gz',NULL,3561,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(602,'424f12f45575fd8d73d54cfacbd9077da226c5bf','1b2bda76fd84b55eb9477de2f6180ab317e3f02c',30,'mod_scorm','content',0,'/story_content/slides/','67qyLJmaOuA.swf',NULL,3851,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(603,'9796e8bb5e2a1c202a19fc7a4e3e3649da6b5417','86e65e7e132ed5960586205ab55fb45f4b9c79c9',30,'mod_scorm','content',0,'/mobile/slides/','67qyLJmaOuA.gz',NULL,3558,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(604,'bc0e5a5c9e9296e0df9f6bcc9916e8d3a74f2746','15c15676e3f04a34bb8482cd3165aa55856146a3',30,'mod_scorm','content',0,'/story_content/slides/','6nf5fWw7cwT.swf',NULL,3851,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(605,'eaf353091496043dd5096594fed257c39463da65','cc831620ebcc4f44d2d1dfff76e2c27ac77da427',30,'mod_scorm','content',0,'/mobile/slides/','6nf5fWw7cwT.gz',NULL,3559,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(606,'152d0ba06f468b0df7452a83122051f4b1fb279b','9472858badd01b3da3abce7cc80b0fa5bcb8552e',30,'mod_scorm','content',0,'/mobile/slides/','5Ui9hk42yxJ.js',NULL,17553,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(607,'70c2b922e6c5f08e0b23c2872d89b43f15b96672','dcdfcd9d8a51a114beb3c6b6de25a85d158fbd0f',30,'mod_scorm','content',0,'/story_content/slides/','6CBgXjlZV0s.swf',NULL,3841,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(608,'83c30faf75dd4315937909c0a4a6de74a55fcc02','9238bf9e54ca22e3ba2603a0fdffd7e2fa241db9',30,'mod_scorm','content',0,'/mobile/slides/','6OXQSAgrTXF.js',NULL,17579,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(609,'71ea05ffbbbdee74a198b1ad08cd0a8a97ce59a4','fc280fc0c94c6851351a17406435f94af9a06021',30,'mod_scorm','content',0,'/mobile/slides/','6CBgXjlZV0s.gz',NULL,3550,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(610,'a5596ef64cede264eb453e43306f177562a18ad8','f72870f37c6d9eb169c6322ca6e96f28fd6a706b',30,'mod_scorm','content',0,'/mobile/slides/','6nf5fWw7cwT.js',NULL,17590,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(611,'ace7caabb7617e1284975b53a9d3a3bb466e8536','01dacac63defc1cdd51a842fadf82dd99b3d922d',30,'mod_scorm','content',0,'/mobile/slides/','67qyLJmaOuA.js',NULL,17569,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(612,'306892eb25ba54da4b825013534d0db0be6a35fe','e2834ed21c452c1375ab24e2d2f0eb55b0842fed',30,'mod_scorm','content',0,'/story_content/slides/','5vablTVbgqP.swf',NULL,3851,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(613,'3f3e6bb660f6693e922e776415206d0b5cd2c577','f53290bd46a8712545e836e4d7593b3a55283ada',30,'mod_scorm','content',0,'/mobile/slides/','5vablTVbgqP.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(614,'0dfc0014945a3ce07ca04fce968a1fe16b9fedc6','fd356f89ff84d4a2687416d7ddb47f16a4959b36',30,'mod_scorm','content',0,'/story_content/slides/','6efuJsc60Jn.swf',NULL,3857,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(615,'6c271ee3912847ac38f56bae311c831ec9583a9d','0a20da277a94d49e32572c7db09a713df4865005',30,'mod_scorm','content',0,'/story_content/slides/','6esjZlNryGk.swf',NULL,3843,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(616,'cbd8200273b95329518de876cde0183ca6399c03','690f67909be4d1dd105f505419d688ae02dca021',30,'mod_scorm','content',0,'/mobile/slides/','6efuJsc60Jn.gz',NULL,3565,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(617,'2a38b6fca06975e567438fffdfc52046535196a1','b921ae99998dd3c80617c56f265866e1f9b7cf3b',30,'mod_scorm','content',0,'/mobile/slides/','6esjZlNryGk.gz',NULL,3549,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(618,'a7814f9a1ce73d9d2e952a6dd2d9814701747fd5','418909b67eaef6615d33f169e4a219ee0abfbb45',30,'mod_scorm','content',0,'/mobile/slides/','6CBgXjlZV0s.js',NULL,17556,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(619,'9eef3d2b981ec932fbc47e0d2e0e0f70e4e7855a','5d5561d71b40bf8dfb2afcbe232de183ffc16d63',30,'mod_scorm','content',0,'/mobile/slides/','5vablTVbgqP.js',NULL,17584,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(620,'a98f2d2e586f69fe1c64fd8ea0f02bd2181f30fe','f68072e8341f6b9ffa1bfc2b89b11bde8c82769b',30,'mod_scorm','content',0,'/story_content/slides/','6n8UHfIxjCD.swf',NULL,3839,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(621,'f8e57f07c2cb7b652d537a7384c2d43956476846','970865150d4fe727e17c1f203b587ba094b984b9',30,'mod_scorm','content',0,'/mobile/slides/','6n8UHfIxjCD.gz',NULL,3546,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(622,'a3933e850108da5ff1a2b6555acfb4004a7bd8b2','72d4aaeab554af5108a7f25b47d5af7ef5ea3836',30,'mod_scorm','content',0,'/story_content/slides/','6L9mUgYazc4.swf',NULL,3834,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(623,'d1ddb27756592d8a4d4d2fbd8db2d26b041675d0','bc837c0b3e9bfbac1e3a7da69b8a89f540d99ef1',30,'mod_scorm','content',0,'/mobile/slides/','6efuJsc60Jn.js',NULL,17583,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(624,'045c41f3881cd0c1fb9bafdc53f3430e1c9f4cd0','3214bd235b7fd68483d241f4b720a1429ccf62e7',30,'mod_scorm','content',0,'/mobile/slides/','6L9mUgYazc4.gz',NULL,3542,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(625,'db4587844b59d2e9fd4219d05409e76441e49920','6189f566325f22bff912459076809dceedd20d68',30,'mod_scorm','content',0,'/mobile/slides/','6esjZlNryGk.js',NULL,17568,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(626,'220c4e5af62f3a0ff3ef6c03b0703a8a523993c4','9f0609316d567b8eadaad042c55e66d105ac7529',30,'mod_scorm','content',0,'/story_content/slides/','6D4WsfosoAv.swf',NULL,3856,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(627,'f6d4c89a30581711b4e7b69b3e9453c55e3924dc','76e8d6b36a9f3074d845020ad6552c2ad0eb319c',30,'mod_scorm','content',0,'/mobile/slides/','6D4WsfosoAv.gz',NULL,3566,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(628,'e2fb0926f48b42bc9762fb54bdd82105fd5af1d6','6af622e4d705cb85ad6106a8887ef54c5c255f76',30,'mod_scorm','content',0,'/story_content/slides/','6cQip7crmai.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(629,'20eef0f934315ae9a679a5b0d2819f3be4d7f2de','b863346861f619d5cb2d3c04f6341321b9772a27',30,'mod_scorm','content',0,'/story_content/slides/','6FiZ6H4bzBl.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(630,'311a29c812766f940b88189a5e79eb58339522c5','8af3206267ebac3d87bdc455b0bae967e23bb3b1',30,'mod_scorm','content',0,'/mobile/slides/','6n8UHfIxjCD.js',NULL,17552,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(631,'8f95073477a9801425419fdf42bd8af23d3effae','bad34cccb58ddecd0ff31ecbf156e449780217cb',30,'mod_scorm','content',0,'/mobile/slides/','6L9mUgYazc4.js',NULL,17553,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(632,'5365e94f77cef88014473584c15930f849425a69','d852efc22f0999dd26f0c56db5431f17111198fe',30,'mod_scorm','content',0,'/mobile/slides/','6cQip7crmai.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(633,'2ce081bd81e13009d3cdaa186a9d6a5e062cad81','955d3e423b513624fc24e5040dd95b02641ba6ae',30,'mod_scorm','content',0,'/mobile/slides/','6D4WsfosoAv.js',NULL,17600,'application/x-javascript',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(634,'0fc151a6a851a95a9c15220469534c075b4b011a','b8e7f518b350187422fe221f13c6ae1c8b8cee69',30,'mod_scorm','content',0,'/mobile/slides/','6FiZ6H4bzBl.gz',NULL,3555,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(635,'14b40211b5558783d5c76dd7ae5e0f5b67f461d6','c0c4fd1a65dd787bada4fb4b296448f97fa35c8b',30,'mod_scorm','content',0,'/story_content/slides/','5i4quPiAoD3.swf',NULL,3839,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(636,'b73bfd09601f760da06960a1c7b01a0387f8a397','b48781d71408026b7996e3093189adf847a51575',30,'mod_scorm','content',0,'/mobile/slides/','5i4quPiAoD3.gz',NULL,3545,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(637,'b2123311e239cb90daa854029c3085bedbcc1ce0','9d9aaaa738662bac6ee471f7253fab7c61f20828',30,'mod_scorm','content',0,'/story_content/slides/','6FKNMJ4NKLi.swf',NULL,3845,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(638,'9dee8ceb2f3c7ec3e60c7d687bf00cebaa5deae0','94554d85f29650a86894243a9e29abc63a4720d5',30,'mod_scorm','content',0,'/mobile/slides/','6FKNMJ4NKLi.gz',NULL,3550,'application/g-zip',0,NULL,NULL,NULL,1462458056,1462458056,0,NULL),(639,'d04b964f0a8cee633dbf31efbba0472ddea1eeb6','7d90c604f9c11c118c0108b8165dcdf0aedd3f25',30,'mod_scorm','content',0,'/mobile/slides/','6FiZ6H4bzBl.js',NULL,17573,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(640,'077b9595895543e92384e0ae5eafb8f94254ffa5','4c42c4c00ede3baa382589bbbaeecd8623e18bc9',30,'mod_scorm','content',0,'/story_content/slides/','6pEyTScUuNO.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(641,'2af32a8205141318f87342ba3cd9f6b0aea9f91c','eeed78debbb4ba3c56b8aa4ad23bb8dc620cb917',30,'mod_scorm','content',0,'/mobile/slides/','6pEyTScUuNO.gz',NULL,3561,'application/g-zip',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(642,'74b8e7b776bed91a64cd0cb85e6c161e7549e111','70b6f62aa1ada0f9a23f273c72c0bbdf44063a93',30,'mod_scorm','content',0,'/story_content/slides/','5op52oBkFmW.swf',NULL,3847,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(643,'2cd21a3afb7704b6b3a3a48dbcfe5670dca683c2','fa1541de322592a9e25fe528153bdd371bb57fe7',30,'mod_scorm','content',0,'/mobile/slides/','5op52oBkFmW.gz',NULL,3554,'application/g-zip',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(644,'b222205d7aad61ca823b4529f06290b4c674aa87','033720034ec401dda45115f5cdc1a2a2ffaab2e4',30,'mod_scorm','content',0,'/mobile/slides/','6FKNMJ4NKLi.js',NULL,17565,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(645,'f501d71d588f31ca39f0e9eedb8b03bc3bcfa52a','a3a8727c2db56f3e82c9a6beb24214a16591ce43',30,'mod_scorm','content',0,'/story_content/slides/','6Dk7sbYELJM.swf',NULL,3847,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(646,'49f56848c26eaf55f4b111b4b465bb99401cf4cf','8f6a16d24650414401e4be6d32e08b836e752931',30,'mod_scorm','content',0,'/mobile/slides/','6Dk7sbYELJM.gz',NULL,3554,'application/g-zip',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(647,'63c4e229d6c5632eff39e1a545cb108f67fa1205','efc71592eaeddc95fb876091c7e274b5e09e7e38',30,'mod_scorm','content',0,'/mobile/slides/','6cQip7crmai.js',NULL,17567,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(648,'48e7bf6c9ee2c21f6d4c91a2ddc0f212d959b69e','84ea115a91d89e0288942d8f1f72a1443e7eca02',30,'mod_scorm','content',0,'/mobile/slides/','5i4quPiAoD3.js',NULL,17551,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(649,'b95f7c435c3437beae4f5c53bea535a102c63396','7c30c6121975f8d08d706937f399988e8318e862',30,'mod_scorm','content',0,'/story_content/slides/','5f9Lm5ZcihX.swf',NULL,3840,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(650,'fa98cf6e237a5be3ca091ea862779b5d48d0cd30','45d8ea3c37bc536f29e315de83d6e7a69f829648',30,'mod_scorm','content',0,'/mobile/slides/','5op52oBkFmW.js',NULL,17571,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(651,'d24e623b534b7ea7a0c1485d52654ee3fdcd45b1','26229e3cab14d61774479c5134ce6947d12e6fcd',30,'mod_scorm','content',0,'/mobile/slides/','5f9Lm5ZcihX.gz',NULL,3548,'application/g-zip',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(652,'7b8efddc8f645aaa96465a574fb6f497e2e3bd8f','01ca3a1bdf7dbb511e65c049fd5c042f15243158',30,'mod_scorm','content',0,'/story_content/slides/','69ZQL5t9utU.swf',NULL,3843,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(653,'688112a60146d74f15a5837d4baf200810023c2e','68b63e549c7732e287ac7ce552c3f0f85d4694c0',30,'mod_scorm','content',0,'/mobile/slides/','6pEyTScUuNO.js',NULL,17590,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(654,'8f9d4949f6a7f8649bc0af067666a5ac1699e2bc','a747d814abfb9c4dbb350ae380416adacdc71239',30,'mod_scorm','content',0,'/mobile/slides/','69ZQL5t9utU.gz',NULL,3548,'application/g-zip',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(655,'8abe7f2a23238f36aa0ab28e93ba45c26c9c028f','99551e33b42df72ed2daae737ea12521b7136efa',30,'mod_scorm','content',0,'/story_content/slides/','60g0s32O7nZ.swf',NULL,3854,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(656,'1550cbe9424b118b4b34b260ff3e34de44c5c06f','75427ac218204f92fb3eb63025791c36c3176ced',30,'mod_scorm','content',0,'/mobile/slides/','60g0s32O7nZ.gz',NULL,3563,'application/g-zip',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(657,'961ae1ca94c20e7696cb0b4629e3cfdddf2d1c63','c6cb063b473ba25d91b085461d11d3ef8e0c2772',30,'mod_scorm','content',0,'/mobile/slides/','5f9Lm5ZcihX.js',NULL,17551,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(658,'09d0c645fe6815916931298963834139626acac1','73c2b6e6805d86b3778c3b46fdfc3d5121c3d3ba',30,'mod_scorm','content',0,'/mobile/slides/','69ZQL5t9utU.js',NULL,17556,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(659,'f61e92e925ae48ad92b7c1a7bb510fafc72cc79e','a0aa8506fe9f0bfcc6abac16b1e8f2110bd30b00',30,'mod_scorm','content',0,'/mobile/slides/','6Dk7sbYELJM.js',NULL,17568,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(660,'44ddd9719ec8a4cfc07e03b5f72d8d4bce0f218f','14dc87283be03be89d308cbd81a33add2d4a934a',30,'mod_scorm','content',0,'/story_content/slides/','5xTbom0eVUc.swf',NULL,3841,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(661,'9ecce541cbaa52d89d3dcdcb6bbacad87cb3f5a2','43b50e8ebd66362f2934cd6c025c56146cb9a66a',30,'mod_scorm','content',0,'/mobile/slides/','5xTbom0eVUc.gz',NULL,3547,'application/g-zip',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(662,'ee3c42a97414c92bd5f7ec99372e65944987881d','3c62b2b9a0a56303472315d7cb46a14835b88367',30,'mod_scorm','content',0,'/story_content/slides/','6ShDPNMzpuo.swf',NULL,3860,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(663,'11ed220838d05ac932204f4c41afc22ecccee6ae','5b1176df7d875a7b2a21304596192b21024ae968',30,'mod_scorm','content',0,'/mobile/slides/','6ShDPNMzpuo.gz',NULL,3565,'application/g-zip',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(664,'b26c378bd88a94835a62cc03b8ecdbb263e2fc8d','fb424bf589efc8e6a3b50a7491fbe211ec32f9c8',30,'mod_scorm','content',0,'/story_content/slides/','6eBTJYZTcQK.swf',NULL,3839,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(665,'3d85faed75ca00c582616264a13c3366aea8c103','933b68ac813dd88e0d4d99d19331524aec242947',30,'mod_scorm','content',0,'/mobile/slides/','6eBTJYZTcQK.gz',NULL,3547,'application/g-zip',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(666,'58f1e19d6fa2b6538cbffeb9d9651a7b4ce5f25d','fe8a0b29378e35ef6723eddfad1b29bcaa25bb30',30,'mod_scorm','content',0,'/mobile/slides/','60g0s32O7nZ.js',NULL,17598,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(667,'7f6d507c110aa42f6025adb3ee9aa5ada2652fc6','ecf9a7b4cdde224ba73c2d2558da9558b461ab44',30,'mod_scorm','content',0,'/mobile/slides/','5xTbom0eVUc.js',NULL,17559,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(668,'cbd5a9575b14d05dd64ccd7e0e53e9c1f70cbb2a','6ba28507f64cf005fe16b01ebdb4134935b6d070',30,'mod_scorm','content',0,'/story_content/slides/','5VEdwZ894Iv.swf',NULL,3838,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(669,'58956a2e8661324b6b96a16ccca9dd00516addcf','8616397ae40c86f1b1c020739fc10274e6eff98f',30,'mod_scorm','content',0,'/mobile/slides/','5VEdwZ894Iv.gz',NULL,3545,'application/g-zip',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(670,'c69c0aeebf00523cbf173d20ad5871ef3b2e5e9d','2ef1ba7df65cc9bcb695344a0845b6a0604ab852',30,'mod_scorm','content',0,'/story_content/slides/','5yVi62QmT2U.swf',NULL,3856,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(671,'98e50107eae5906a64cb12e950ef21ae212409c1','2f7631d4a48fe0f8ff88700ce4f5a6ec38d8abf9',30,'mod_scorm','content',0,'/mobile/slides/','5yVi62QmT2U.gz',NULL,3561,'application/g-zip',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(672,'6657b19f17691d750697564c8b07c9def8f6a6f5','fe97275b15f44b9f75f78e32b37f28e311f6cbd0',30,'mod_scorm','content',0,'/story_content/slides/','5hAa1CeeGIn.swf',NULL,3849,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(673,'09930cb6993a98a60837e5da5b43123f26e882e6','934f0e296dd5215d872f4e78afb5b109d536d034',30,'mod_scorm','content',0,'/mobile/slides/','5hAa1CeeGIn.gz',NULL,3560,'application/g-zip',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(674,'81d15fde6fc0920a9e5d011eb5e7996f2485758f','fa3afc5a960d564f5af2e4e05a808accc38ce05e',30,'mod_scorm','content',0,'/mobile/slides/','6ShDPNMzpuo.js',NULL,17571,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(675,'118e5111e2192f0cc3640a7b826604d42e7bf0fc','578448093c23a722dd6f60d1ee9b3ce7f8a167b6',30,'mod_scorm','content',0,'/story_content/slides/','6Q2ybi7a4QD.swf',NULL,3858,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(676,'1daa8f55649129971480c9538b06a53fe152dd33','432570a3896fbb1dcc009124c1017b72aa89c39f',30,'mod_scorm','content',0,'/mobile/slides/','6Q2ybi7a4QD.gz',NULL,3564,'application/g-zip',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(677,'84dc33da98bdd7c3f138d2cfb5454a22a35bea04','62949cef10fb4ad8bd04197d3e086a2fba5a9428',30,'mod_scorm','content',0,'/mobile/slides/','6eBTJYZTcQK.js',NULL,17556,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(678,'0826263df2a19792b49c0e0039282a555dbe0358','00599cdde1437bab5f74ad3370bc86b3743fa0c9',30,'mod_scorm','content',0,'/story_content/slides/','6eDrLGs6v3K.swf',NULL,3848,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(679,'8cae8fe3dff637752b66a070fef0318ff6991a53','ad724c7d817b5d40a84f1bd9e149d14b919d6560',30,'mod_scorm','content',0,'/mobile/slides/','5VEdwZ894Iv.js',NULL,17554,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(680,'c0a5679eb03c8b07afb07a46f72a6c5d95734e02','b2af1f6392dcceadd0e28e7320a6e1acae1c791e',30,'mod_scorm','content',0,'/mobile/slides/','5hAa1CeeGIn.js',NULL,17599,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(681,'ba7f6155b9740046d40d660350d1e2d3d7832901','45caebb03d4e36299335f8808b27dabf69f53143',30,'mod_scorm','content',0,'/story_content/slides/','6ADCiZir6XZ.swf',NULL,3841,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(682,'5cc4158ff76c295e83488c4868c2d3bfb10d3c5a','0bb993d505b959f46bb7fad9ca2ff1be2cacf130',30,'mod_scorm','content',0,'/mobile/slides/','6ADCiZir6XZ.gz',NULL,3548,'application/g-zip',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(683,'407b41a3c7c38958a94fbbd9ef030359c1ff6d07','a7bf878309225c8fee19790abcd3f7ced3fb8324',30,'mod_scorm','content',0,'/story_content/slides/','6kvJpitwf2W.swf',NULL,3864,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(684,'33b81bbcedb7d96d8ef32700f505fc2167d7aa2d','b84209ea4c21bb457d173516e114793e99cb09bc',30,'mod_scorm','content',0,'/mobile/slides/','6kvJpitwf2W.gz',NULL,3573,'application/g-zip',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(685,'d90031fe56b4c45e04d3bf5aad7a1dcfc19c6995','1ec10f0fb098056972a998a0137c2f838a13e2ee',30,'mod_scorm','content',0,'/mobile/slides/','5yVi62QmT2U.js',NULL,17576,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(686,'876df6ff5a4180889fcfe71dfcef3ef86ad70457','461d92599e06d9f6fdfac67ed4b065a872b98ae5',30,'mod_scorm','content',0,'/mobile/slides/','6eDrLGs6v3K.gz',NULL,3557,'application/g-zip',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(687,'6509d43788341e51dd8d67f1b89636241d0bc202','03873f2c1df62e121faf7961056ee4eb786615b9',30,'mod_scorm','content',0,'/mobile/slides/','6Q2ybi7a4QD.js',NULL,17587,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(688,'f19ded31e949dd72a2c7509c9f5e940c5976adbe','ee06496afe7fc37644f88557c81a34ea691867a1',30,'mod_scorm','content',0,'/story_content/slides/','67jC5NAWgTo.swf',NULL,3849,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(689,'fda985ebcb09b77234706d2a9b540a12d588374a','dceaf617da8300526a3cdaad4a4b47adaf930233',30,'mod_scorm','content',0,'/mobile/slides/','67jC5NAWgTo.gz',NULL,3555,'application/g-zip',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(690,'69bdd04fd6107c8195caf52309897d648604bc8c','d5fcb19122101b921b349580f7df8c33a04d3e56',30,'mod_scorm','content',0,'/mobile/slides/','6kvJpitwf2W.js',NULL,17600,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(691,'6b5f47602ea0b4e5a847826e1bd7801af068328f','ce778e55802c92952bb6df113b1bb4f923bd614c',30,'mod_scorm','content',0,'/mobile/slides/','6ADCiZir6XZ.js',NULL,17549,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(692,'d642e17e43c37094fc50766b951f1e65a886a519','f1cedb0a96bbd9a9abd9b6659604d0a4b5428468',30,'mod_scorm','content',0,'/story_content/slides/','5vpmlBVmoJk.swf',NULL,3835,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(693,'344ee6e20f9fc174db45d779a02333c944276f7f','a15f47198d16f39384832574f4bf1ad742c208d1',30,'mod_scorm','content',0,'/mobile/slides/','5vpmlBVmoJk.gz',NULL,3542,'application/g-zip',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(694,'e9be86fd06333cb6c62be4c9efad99685a04c0a2','99d81d912a39f2edd3d9f31b32f1a459062e3f65',30,'mod_scorm','content',0,'/mobile/slides/','67jC5NAWgTo.js',NULL,17576,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(695,'2663087da0202d5fc06034c3dd2ab1982d3203ec','499c04a2d3e3e08377fca11f2f3cbe4c3c095ab3',30,'mod_scorm','content',0,'/story_content/slides/','6cECEvqvjHN.swf',NULL,3869,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(696,'9e910d1b47d31da010624ffe9fcf99a972e1491e','c3e1e64fac1b6c0f6e47c69da49577ae6d357177',30,'mod_scorm','content',0,'/mobile/slides/','6cECEvqvjHN.gz',NULL,3576,'application/g-zip',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(697,'cd33bb304f2e33218932119cb0c062f0bc720d49','d24a433f8164f295b9fbca7be08d4a2ee48a6789',30,'mod_scorm','content',0,'/story_content/slides/','61K4VWfuMlg.swf',NULL,3851,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(698,'b30e0f829db34b4d31f4366714d0d7f5c465b6d7','77b8ed4722f3273a4eb56970257ab228433743f2',30,'mod_scorm','content',0,'/story_content/slides/','5XWyAnV4PUk.swf',NULL,3849,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(699,'69050a7ec05cfddc82aad781e34d5c2770dbf9af','96053c963e87a2613e9c7c81f38dbebbaef7fa68',30,'mod_scorm','content',0,'/mobile/slides/','61K4VWfuMlg.gz',NULL,3557,'application/g-zip',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(700,'66f2e0b139db129ba8561186b938ce46c78e8067','50cfac516a6a9a4a397ab5c11fa852f80842d848',30,'mod_scorm','content',0,'/mobile/slides/','5XWyAnV4PUk.gz',NULL,3558,'application/g-zip',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(701,'9485e55e73fe0f35a178846757833849b18a0e01','b8a140e0487c768bfb47782e89ab2edbd2660d33',30,'mod_scorm','content',0,'/mobile/slides/','6eDrLGs6v3K.js',NULL,17574,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(702,'61bbc5883fde62686645165b1fd95467a98c23ca','48d5f87babb26d436b9ffcfeb99f795fc49c2d4f',30,'mod_scorm','content',0,'/mobile/slides/','5XWyAnV4PUk.js',NULL,17580,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(703,'970574f94c4a0c4b964bdecc367cb61b56498714','b3cd93f056754e5a627670732efe904e85f8a313',30,'mod_scorm','content',0,'/mobile/slides/','61K4VWfuMlg.js',NULL,17584,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(704,'5c032bc3e151043ab339e05b000a92e761a71a09','45ad69683b81e62496dbcb64ea79fdc8ba00ea1f',30,'mod_scorm','content',0,'/mobile/slides/','5vpmlBVmoJk.js',NULL,17553,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(705,'f99698806b26b802e28eb4d74827737cf4117566','caaaa3a3ab34fef146ca86aed17e7050acfbc68e',30,'mod_scorm','content',0,'/story_content/slides/','6Snd00tOn98.swf',NULL,3856,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(706,'c57e897b2653291537288f49eb99589a99d453f4','4624391dbc3175cccbe911ea2f445fd734c4e7d0',30,'mod_scorm','content',0,'/story_content/slides/','6chz4TUH3C3.swf',NULL,3851,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(707,'51fd7e76149bdfebc059466f8d7a372af87d1c19','769f01099d0072972343aac58b4fa2bc732a67ff',30,'mod_scorm','content',0,'/mobile/slides/','6chz4TUH3C3.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(708,'e08d7d911d108bfa57255006a89cbc53c79255bc','74fe075194855a0d75981e707b551dce40bdb1b9',30,'mod_scorm','content',0,'/mobile/slides/','6Snd00tOn98.gz',NULL,3565,'application/g-zip',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(709,'eb7567b31290000899408aea4dded0b0740db2c8','07f6e09f110d3c7426b7ec5cfe751787cecbe0ff',30,'mod_scorm','content',0,'/story_content/slides/','6HauCDHL2LV.swf',NULL,3862,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(710,'e994550387211659bf412bec063e4e506ec55044','5b33ba469b66d36d2878bf1e0ab3cd96f8f0d783',30,'mod_scorm','content',0,'/mobile/slides/','6cECEvqvjHN.js',NULL,17633,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(711,'a37513f1166c113f7d81a4a70f2b7a6ff3d4002c','a9e36d656ea487dac1de7a0e5228e10206b0e0e3',30,'mod_scorm','content',0,'/story_content/slides/','627xqYrkRh1.swf',NULL,3839,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(712,'d67af449bb8f39bbcf093fe5a4dc8d9822302d3d','dba9dd5685972df6b23876eba380d541b986ca1a',30,'mod_scorm','content',0,'/mobile/slides/','6HauCDHL2LV.gz',NULL,3570,'application/g-zip',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(713,'64d77a72a2b2633b1fe9edd836b247f291554d07','fd336e2cb133870526f574c2a963744a68897126',30,'mod_scorm','content',0,'/mobile/slides/','627xqYrkRh1.gz',NULL,3546,'application/g-zip',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(714,'3639e15f25583d1de39211733f5f35f32844428c','2429a88314171c046c4f481f049a44eeddd137b1',30,'mod_scorm','content',0,'/story_content/slides/','5oLSAYaSlpn.swf',NULL,3843,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(715,'0bb86b71201ddb39282dd89752ef97b803974d08','823e0d15ee2c376e57099b8d965aaadc8adf0e28',30,'mod_scorm','content',0,'/mobile/slides/','5oLSAYaSlpn.gz',NULL,3551,'application/g-zip',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(716,'081aec79ae3ae2fcf90b0adcd459c671135d9b95','3148cdd34c88d00346bb76387d236ea627928c80',30,'mod_scorm','content',0,'/mobile/slides/','6HauCDHL2LV.js',NULL,17638,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(717,'b61ac481275e8991b765e753b1835cffc9df411d','4f147ef5e2ce6a014e2889cdd25299514ee3b146',30,'mod_scorm','content',0,'/mobile/slides/','6chz4TUH3C3.js',NULL,17569,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(718,'3b90824db2717ec4763cb5e7dce7fe94a21a0c87','f09e83b8f75e29905a8113dfd160121582f63c12',30,'mod_scorm','content',0,'/mobile/slides/','5oLSAYaSlpn.js',NULL,17557,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(719,'60023a8d735b0dda571c96c4b9f3fe7ed271829e','efb65020127bc5014e1858904fd9be9e2e9b0c5e',30,'mod_scorm','content',0,'/mobile/slides/','627xqYrkRh1.js',NULL,17552,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(720,'e63df5eda631ea4741735da2dd29c58b48739435','8617418fd51ee11e61f262c9be8504c54bf0ff77',30,'mod_scorm','content',0,'/story_content/slides/','5bKnDZrVzhH.swf',NULL,3846,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(721,'12e2f5924860bcffddd891655a5ca446adf3fa25','5eb4b834868f3d9cb684f3afb4d6ecc1da20ba42',30,'mod_scorm','content',0,'/mobile/slides/','5bKnDZrVzhH.gz',NULL,3553,'application/g-zip',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(722,'8fb0d3b5e055288576fb0b2b8b1fe6ebde12d5b7','a24b17bb4bd7e34cc5cc8b1fcd71d613f41f1fde',30,'mod_scorm','content',0,'/story_content/slides/','6OW3tw5t4ov.swf',NULL,3836,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(723,'f5a3375bfea0ebbc627156288374acfee5250be2','c98f699987ef80c3f4a8bc52515a7768cd72f808',30,'mod_scorm','content',0,'/mobile/slides/','6OW3tw5t4ov.gz',NULL,3544,'application/g-zip',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(724,'3b452a45e1de7bb652a2ce123288fcd3483b0f41','71ecf5ff84708cd0d9954598ede6a58a1dca5a73',30,'mod_scorm','content',0,'/story_content/slides/','63uZYLgtt7Q.swf',NULL,3862,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(725,'96139507319fa81e77f375f6045ee51b5bdc5c93','6c2a7b7b40c08f65dc23ced36c71eee0808b699c',30,'mod_scorm','content',0,'/mobile/slides/','6Snd00tOn98.js',NULL,17574,'application/x-javascript',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(726,'cf89d6da9f19091a19e8e381e32db2abf48b9274','ea3681106a93718346866971fdd9c9457fbee412',30,'mod_scorm','content',0,'/story_content/slides/','5qDHXApYrRj.swf',NULL,3862,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458057,1462458057,0,NULL),(727,'2e53ddc6f438d7afb354ff302907dbbe31465fc7','5787eb2b439ca1b666e342da6c2572f256f9a390',30,'mod_scorm','content',0,'/mobile/slides/','63uZYLgtt7Q.gz',NULL,3570,'application/g-zip',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(728,'a370555ef455d9cc6c82bb6c464cc0e376bffab5','b8b3af0142c0c13ade63a4db94c48fed442c80fe',30,'mod_scorm','content',0,'/mobile/slides/','5qDHXApYrRj.gz',NULL,3570,'application/g-zip',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(729,'448e6c4acf94d4a8cfb9dabaf1961041430c975d','2d2ed5e4d6067b8ae89bbb64001d4993e7d372a3',30,'mod_scorm','content',0,'/story_content/slides/','6dh7mXjLOJk.swf',NULL,3838,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(730,'130e8e24680c59e61e63399f14183a597b08eaf4','3fcf7ee21b90ee28126d5e7b02c359b284265b8f',30,'mod_scorm','content',0,'/mobile/slides/','6dh7mXjLOJk.gz',NULL,3545,'application/g-zip',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(731,'7891262b1f567032462aad399b0eab1705fc4639','2ecd10b394cb4c7089191f74da2bb165d7b98330',30,'mod_scorm','content',0,'/mobile/slides/','5bKnDZrVzhH.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(732,'120e01b59735b6eafff099aef1b6c67eecfd794d','7dd4e3085fbfcbf252f04177ae850e26cee6391d',30,'mod_scorm','content',0,'/mobile/slides/','6OW3tw5t4ov.js',NULL,17553,'application/x-javascript',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(733,'6ee98b44d84700a1d52dee7df5151315301c6651','dc3b1a82508d8d16ba429a4e6043ad4ed2b0ae2b',30,'mod_scorm','content',0,'/story_content/slides/','6jrqfj5al5D.swf',NULL,3849,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(734,'9afe6e27326d0f17eceecaa632c3d7d2053a3fb9','205d29975483dd44edaaae736a6e5178dfd57c77',30,'mod_scorm','content',0,'/story_content/slides/','5yUZOgpDDwO.swf',NULL,3858,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(735,'422c6c9d27dccb921da12ee6c7cffdb00e074fdb','c0704062923050fc2ac432b50de509b917f21282',30,'mod_scorm','content',0,'/mobile/slides/','5yUZOgpDDwO.gz',NULL,3566,'application/g-zip',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(736,'54fd7d13c1461fe3a24c40c5e700cd136b5d9def','738b2c3dfa6ad6424d8a605cbe2d0c52edce2988',30,'mod_scorm','content',0,'/mobile/slides/','6jrqfj5al5D.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(737,'211241ad99332fb6769b7f5d0109c346c5f60f06','0c7a5c25546f366f09c162658b1b25207e06e795',30,'mod_scorm','content',0,'/mobile/slides/','5qDHXApYrRj.js',NULL,17598,'application/x-javascript',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(738,'352c94c48e3d242bd69263ceb6d01c455e1ab3af','0cede2928da383f7975ad2251daedb4af6f17a99',30,'mod_scorm','content',0,'/mobile/slides/','5yUZOgpDDwO.js',NULL,17586,'application/x-javascript',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(739,'5c2872bb0e26b28f3356bb7171be61fec010e038','404a5dfc8cf77b5653030b3d10c82d236ec12ade',30,'mod_scorm','content',0,'/mobile/slides/','6dh7mXjLOJk.js',NULL,17551,'application/x-javascript',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(740,'cc16191f5696f45cc3ad847a334651d8bb7330fd','8bdd7ffeba3f93b43748e6b950b981818321940f',30,'mod_scorm','content',0,'/mobile/slides/','63uZYLgtt7Q.js',NULL,17592,'application/x-javascript',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(741,'e6383c1f69b6efbec8040a797b53a40076d6ad20','8b5494112007f9d392b164ddcd2767d32d1847a7',30,'mod_scorm','content',0,'/mobile/slides/','6jrqfj5al5D.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(742,'0b85ee8faf2db9f070fe559d5281c5d0b1dc502d','3cede2d618f18aa7943ee9f9d77a20ebfa92daa0',30,'mod_scorm','content',0,'/story_content/slides/','5kOSc7gR7d2.swf',NULL,3844,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(743,'c66111c329365679c73f4ea8aeb7afddd213b1f3','689544d9caedec4c1a3724f4e660d2991f13fdeb',30,'mod_scorm','content',0,'/story_content/slides/','6er0aHapC1D.swf',NULL,3836,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(744,'0f587357b0811144dc0caa72587db277ed7ad34d','ab30809bfc5f42c5cec975f1a31ab868fa352d8a',30,'mod_scorm','content',0,'/mobile/slides/','6er0aHapC1D.gz',NULL,3544,'application/g-zip',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(745,'6cecbe28bf2fb137833946b8425b053ab601ea87','d3a01cee2a3d090f88488456eb7c27f96246aded',30,'mod_scorm','content',0,'/mobile/slides/','5kOSc7gR7d2.gz',NULL,3549,'application/g-zip',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(746,'2a0c48fbbce42240c42ae1e90ff965cdef48357b','ba71aa4bfc28b3becc10c731cc86aa2cdd5d694f',30,'mod_scorm','content',0,'/story_content/slides/','6FleWvFlaok.swf',NULL,3844,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(747,'39db4b6342b872a3672aee4f5a688ace770f32a3','3661410105c1e99321aabd4e66a6ea1467c961dc',30,'mod_scorm','content',0,'/mobile/slides/','6FleWvFlaok.gz',NULL,3552,'application/g-zip',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(748,'82618cae176d28cd43accdd3fbfd25a3efefa3b0','ca968c0b60b960f4bb913e59451dc8cdb33b34b5',30,'mod_scorm','content',0,'/story_content/slides/','6IXKR4g5gRP.swf',NULL,3840,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(749,'497e882747ce406d5fd52cad1757d48b8b8f707b','8fc10cc253541f195b38e49a7dc6b66fe0e60af8',30,'mod_scorm','content',0,'/mobile/slides/','6IXKR4g5gRP.gz',NULL,3548,'application/g-zip',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(750,'cde873b27de570f4dc918ae918f0f5d18d5f99fb','807eb84f9c7d47eed289be94e30a696813baa2b6',30,'mod_scorm','content',0,'/story_content/slides/','5lRjs6Wji5F.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(751,'c97ad39666cacf8e774d64a65d9ff93cd38e00b8','c4f8a5af8a0e461dca798946f5e77e42bd212f38',30,'mod_scorm','content',0,'/mobile/slides/','6er0aHapC1D.js',NULL,17555,'application/x-javascript',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(752,'bf91f9a4fae03f3f21f14432e9bf6c4c0b3d49b9','d2e6b9c4ed911bdfbde5da908b9b5c126185cf37',30,'mod_scorm','content',0,'/mobile/slides/','5lRjs6Wji5F.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(753,'2cd52e6e9d7c047bff05a4f1fae82e63f1adda64','2f7062d19e81a0748ba0b7a7ae6c26611fc698af',30,'mod_scorm','content',0,'/mobile/slides/','6IXKR4g5gRP.js',NULL,17554,'application/x-javascript',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(754,'de5cc76bc7eff02c506d64a7c70605bab7441db9','1a1546aa9d1a420a31a068caa559da557c1f6c5c',30,'mod_scorm','content',0,'/story_content/slides/','6LRr28MbgLV.swf',NULL,3837,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(755,'34083a9629a19d151822787846cff7987146806c','dc5f83f3e6b5e516aca31fd963672b26300b374e',30,'mod_scorm','content',0,'/mobile/slides/','5kOSc7gR7d2.js',NULL,17563,'application/x-javascript',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(756,'46b47e748a1c9142d2076fbb5d17e6d52365bfac','bbfc6fd96473a6d2b3cdd9684c845cba69bdc05e',30,'mod_scorm','content',0,'/story_content/slides/','6FCO32kEEyK.swf',NULL,3849,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(757,'8756857c6e7507f37083a7d38f9f0f33bd03bfb5','5a2e29404a696fb9df296ef95fcee7d6a5a24f61',30,'mod_scorm','content',0,'/mobile/slides/','6LRr28MbgLV.gz',NULL,3544,'application/g-zip',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(758,'6330c45bc7e8b2f112f3cd816c3f3f4b294b68e8','dfabe7d97c7b2bf1f01362bf80837948e8eecfb7',30,'mod_scorm','content',0,'/mobile/slides/','6FCO32kEEyK.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(759,'a9106af1e4f0a5fbd1b4abd8c4ed6d8ca51b673d','e2e5de5ff27c0649adc2cacb3c3a6b0c6652819c',30,'mod_scorm','content',0,'/mobile/slides/','6FleWvFlaok.js',NULL,17565,'application/x-javascript',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(760,'372a6a8e662b2792a484157489dc47936618353e','54a6caeea837d03c911352dda700450ac037bae6',30,'mod_scorm','content',0,'/story_content/slides/','62wZh4VX2Cu.swf',NULL,3844,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(761,'ab1e89bbbbe1aca28dd9fffba5e9662ee66da80a','34fab8f11dceee86e8a39cce536b06cad4f7767e',30,'mod_scorm','content',0,'/mobile/slides/','62wZh4VX2Cu.gz',NULL,3550,'application/g-zip',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(762,'45ac7b8e1541b4c72b6670a61eb79350281d3d6e','a7fde26bf57629e8bdb8ad51eaeb29278c4af2a5',30,'mod_scorm','content',0,'/story_content/slides/','6oRLCJ7mezO.swf',NULL,3841,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(763,'9c757da4ddc97c7008bd2a8c1229bc68a9c86d27','14a94550e2cf17faf8a5bd63656ea31fdfefe323',30,'mod_scorm','content',0,'/mobile/slides/','6oRLCJ7mezO.gz',NULL,3547,'application/g-zip',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(764,'ed3af71587ad65b9abddb94136374646640822f7','9ab020c677cdbd9fd56ccdd66702e197e5ed1332',30,'mod_scorm','content',0,'/mobile/slides/','6FCO32kEEyK.js',NULL,17571,'application/x-javascript',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(765,'a0b17fe3a41eacacdb4f3fcc31bea7016ae318ad','64058bfe1b0a2eab3403584d033578595772954d',30,'mod_scorm','content',0,'/mobile/slides/','6LRr28MbgLV.js',NULL,17549,'application/x-javascript',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(766,'1384ace283ca8534f5d1f832267833ab63ef2ec9','0eead7ab5a13436da1b9c91c4c6a7818f5566fd8',30,'mod_scorm','content',0,'/story_content/slides/','6FefHvAB0dA.swf',NULL,3849,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(767,'e577d89c3b4e283eb419ad8206e47bc92bd9fcf9','b00de2cd46f4aa6426df77dcf45c6862ff25afce',30,'mod_scorm','content',0,'/mobile/slides/','62wZh4VX2Cu.js',NULL,17570,'application/x-javascript',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(768,'8fe6c06a51d243f9c37aa79012b975a95171c812','26c85d26ecedfeb84ea132ae4dbc82918b6dfed3',30,'mod_scorm','content',0,'/mobile/slides/','5lRjs6Wji5F.js',NULL,17575,'application/x-javascript',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(769,'baa7325ccafd742148ed8f8175edfcfa3bfd79a1','0ddceaad023ee44b191f82ad2368aa1043555334',30,'mod_scorm','content',0,'/mobile/slides/','6FefHvAB0dA.gz',NULL,3554,'application/g-zip',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(770,'8f65afde94f96d29bbad461c34d797f9b767596f','59f3a9387cba3054ede8519a1ca3d70fa296f9fe',30,'mod_scorm','content',0,'/mobile/slides/','6oRLCJ7mezO.js',NULL,17553,'application/x-javascript',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(771,'c52d38ad7a8320ca3b0aae16619847100edc992f','84ff5f71b8e17e12f522f6018ff73eb51cb18790',30,'mod_scorm','content',0,'/story_content/slides/','6hTslOy2zZe.swf',NULL,3854,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(772,'3b82294109186e5f4fb1f7dbd3458389ec76d03a','a4c796de6b14955f3ad0599f0d3d61a187abecef',30,'mod_scorm','content',0,'/story_content/slides/','68PVQUzCdzw.swf',NULL,3849,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(773,'84ef6179163f8ddfaa02efe67564a31af2f32c23','37c71c87caff5ff9851d6a9dc9409c503fe86574',30,'mod_scorm','content',0,'/story_content/slides/','5cUSu495X0l.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(774,'515fe26722d61e47fc3f4862853706ee3e7e2480','32a10212175ef7c2c1119302a7c3a5b7e9a84e7e',30,'mod_scorm','content',0,'/story_content/slides/','5pZbUmNs7pi.swf',NULL,3843,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(775,'604a8f6997b202fe8c65e0d6c1fc6ecbbd4e55a7','4456f31732656edc896fb89ce6eb4e6d2d55fd71',30,'mod_scorm','content',0,'/mobile/slides/','6FefHvAB0dA.js',NULL,17574,'application/x-javascript',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(776,'636633af6299233f95f10bd905850d4186e1408d','3f9c09cf8c18c45bcbb58592ab6fe53a90c4b042',30,'mod_scorm','content',0,'/mobile/slides/','68PVQUzCdzw.gz',NULL,3555,'application/g-zip',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(777,'74e88f1277dd84e5b8ab61bd709cf4f6a793d33f','5ac5a223c4a8fd1c9de1e51108b9211d0419d870',30,'mod_scorm','content',0,'/mobile/slides/','5pZbUmNs7pi.gz',NULL,3548,'application/g-zip',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(778,'ea86a855b9a545e81fc28c52be05207fe30a9576','03a51763475ad9d7109e4e9ef4a213b94a230bba',30,'mod_scorm','content',0,'/mobile/slides/','5cUSu495X0l.gz',NULL,3558,'application/g-zip',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(779,'b2d943cce94ef2aa4a827abb4e1dc19583a31930','e01dde9e6d150bb3c42af97a69187ceff15b955d',30,'mod_scorm','content',0,'/mobile/slides/','6hTslOy2zZe.gz',NULL,3560,'application/g-zip',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(780,'74c8b732cd5fd80c44d7289f06793a47818bf052','64898b2f19dbd9fdb95b4f8dbe47aaf48aca8df4',30,'mod_scorm','content',0,'/story_content/slides/','5wd08GSPqfa.swf',NULL,3836,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(781,'750964f240858da1f6116f40448c5e09c46fe0e4','5348ec87e2959e1a0486e13444ce9e83d6d71b98',30,'mod_scorm','content',0,'/mobile/slides/','5wd08GSPqfa.gz',NULL,3545,'application/g-zip',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(782,'90adac4befd933a902d66d597886d9e325694f7c','97693d5f7701ddf5c2043d16096970b31091fc02',30,'mod_scorm','content',0,'/mobile/slides/','6hTslOy2zZe.js',NULL,17569,'application/x-javascript',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(783,'dddf75b87fde17ec18d6cf098171863ebb3753c3','11009ab89de3563a32778da17312c081ae4dbf92',30,'mod_scorm','content',0,'/mobile/slides/','5cUSu495X0l.js',NULL,17575,'application/x-javascript',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(784,'2bc6ab30089d7298d37bb99f8806be4c97bd4da2','437fe8cd7af21fdb2c8fbcaf8e6bb4db40b4a204',30,'mod_scorm','content',0,'/mobile/slides/','5wd08GSPqfa.js',NULL,17552,'application/x-javascript',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(785,'bce0117b0e63897fb4c311a2ca443469c8f9a5d6','ecf0e3249544fc913619ca7a1b9c92aed5615168',30,'mod_scorm','content',0,'/story_content/slides/','5XveHg6D5Ot.swf',NULL,3846,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(786,'98d3637da7e91c779346ae1c1bace03625c42bd2','4105ef16cd289f86aaaa87b63aeb292e72c73f93',30,'mod_scorm','content',0,'/story_content/slides/','5xRZ8iLSAzj.swf',NULL,3855,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(787,'08dc5df2290a75c73ffa4d15818394cab98f8fe2','519942deba416ac38b542f2d20049c1c4a9ed0bd',30,'mod_scorm','content',0,'/mobile/slides/','5xRZ8iLSAzj.gz',NULL,3562,'application/g-zip',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(788,'3de0ff9c1fd4e7716ea1e1eb2f8fa9f85e8c0514','c88e0793acad43d07d53224f568b0f098860e7ae',30,'mod_scorm','content',0,'/mobile/slides/','5XveHg6D5Ot.gz',NULL,3555,'application/g-zip',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(789,'85bd9d4f1ac8894eccbcd3799a6ef51cd4332b50','6c4af3d86f091cb84508ba696526c289510ebd4c',30,'mod_scorm','content',0,'/mobile/slides/','68PVQUzCdzw.js',NULL,17571,'application/x-javascript',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(790,'05ccefb1dea7cecc8431e49262c59dae0d2d796f','87932b5b8377d1b223162e477fc1d041b90299b5',30,'mod_scorm','content',0,'/mobile/slides/','5pZbUmNs7pi.js',NULL,17555,'application/x-javascript',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(791,'6764ea4ab9e066716d832c9f3ccc54801609b6bf','b8266aec4ad7f2183c1bf1efed6308455e175c51',30,'mod_scorm','content',0,'/mobile/slides/','5xRZ8iLSAzj.js',NULL,17572,'application/x-javascript',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(792,'1c4ab04a6c3a18bbea5c79313c9b16386d313cbc','561db9ba2358d027ccdd360e45ee2ce6683e336d',30,'mod_scorm','content',0,'/mobile/slides/','5XveHg6D5Ot.js',NULL,17573,'application/x-javascript',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(793,'301ce18b0f49421f4125df0550ce70fe0db82a2c','fcc86ed8fbfebb6d4e3141002ecdd0b46bdc2796',30,'mod_scorm','content',0,'/story_content/slides/','6bjy7jnmcUQ.swf',NULL,3838,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(794,'70add6c2ab8a6229c75c6ea1b964af23465e3674','b66ed8e4bdd1719870d71ed5891dd98f6e5ec6b9',30,'mod_scorm','content',0,'/story_content/slides/','5xnlZ3HmpFm.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(795,'5e727095ca000ee705fc106d8553e42bdf0e5e05','9c30ae483e348d5604f7cf637e49086d6b5682cc',30,'mod_scorm','content',0,'/story_content/slides/','5yDF5abzTSr.swf',NULL,3844,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(796,'cabcb55c115829f7071dcb24b62b9938007be700','85e91b990c55cbd2648d8c4ed72408ee8e5970dc',30,'mod_scorm','content',0,'/mobile/slides/','6bjy7jnmcUQ.gz',NULL,3547,'application/g-zip',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(797,'a49ca82658000311ad08b2711c22bbde7b15d483','b14ab8ed16861db79d21e82f02b8cc2ee2d56b19',30,'mod_scorm','content',0,'/story_content/slides/','5uAYAKH4EjI.swf',NULL,3851,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(798,'ddc30bc85275620b5ccf7cfebe84ee4b8632e09a','8b811fb7b0838265318f4ef315235de14e55357a',30,'mod_scorm','content',0,'/story_content/slides/','6NhjMQ3mtev.swf',NULL,3836,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(799,'6c93c7b24c1ee2454aa46bac23c2187a08186495','759632a03449ea5a4cb69c014e35b33f527fed05',30,'mod_scorm','content',0,'/mobile/slides/','5xnlZ3HmpFm.gz',NULL,3555,'application/g-zip',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(800,'eb9ded4e2620331d26981081f788b894425d0c1d','465b998dbafd5f8423e9ca3359d20903ec89fbaf',30,'mod_scorm','content',0,'/mobile/slides/','5uAYAKH4EjI.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(801,'ab14a7fd87699b5bd4ce1806b16ced33a8303b24','6528829763abbfa3d142be46776fed284e99bf94',30,'mod_scorm','content',0,'/mobile/slides/','6NhjMQ3mtev.gz',NULL,3543,'application/g-zip',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(802,'9084819c68638d5862ab4bfc7d3851c079464798','76bbfa6e30a2fa94921cc2442d0c2416536a54b3',30,'mod_scorm','content',0,'/mobile/slides/','6bjy7jnmcUQ.js',NULL,17548,'application/x-javascript',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(803,'8595af43c5fcae251c77b8c2c54f3b1ab5deabac','e36191aa81abfe98680edaf997e72f8b4abf54f7',30,'mod_scorm','content',0,'/mobile/slides/','5xnlZ3HmpFm.js',NULL,17568,'application/x-javascript',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(804,'6505d3925f82f4bdad0e8802a1d77fcf3054e108','52902d7b1fc4223ad20cbffdfb747d8768e40eca',30,'mod_scorm','content',0,'/mobile/slides/','5yDF5abzTSr.gz',NULL,3550,'application/g-zip',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(805,'d30e9329289c7d41d8c3bbbc1b788ea462574513','6843bed210175ba4a6ba2df238d0fda93d277447',30,'mod_scorm','content',0,'/story_content/slides/','6iKctyrIqI4.swf',NULL,3848,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(806,'444f82448dc77b97cb9bd8e2f36187b4429f5681','9645f16cb1cfd392afaa68bb1a418de9beb7bf7e',30,'mod_scorm','content',0,'/story_content/slides/','5kSC4b9wOgS.swf',NULL,3855,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458058,1462458058,0,NULL),(807,'6363ade22ddc2265818381412d48a51a6b45ef60','53b63a4e729c2795c51e185e737a6fa33fe6a6f8',30,'mod_scorm','content',0,'/mobile/slides/','5kSC4b9wOgS.gz',NULL,3561,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(808,'bb71edbd27cfcd1f071b6c20e5a51b81c2a95f59','e6779ad03a31c93a162539681c5578adb79ee79a',30,'mod_scorm','content',0,'/story_content/slides/','6QstvfND6VG.swf',NULL,3844,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(809,'cc52d8b761bc6da212517b3494b7936afdb833e0','efafa230313f7ef95d6792a3f0918fee0d6ed0a4',30,'mod_scorm','content',0,'/mobile/slides/','6iKctyrIqI4.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(810,'711bd7d5505476e0df625c868dc39a62ebb2021a','0fab594e9afcdc3e21f6a2855c3fe1dc9904153e',30,'mod_scorm','content',0,'/story_content/slides/','64mYVR9aBBT.swf',NULL,3840,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(811,'a74f7fb583ae4ebd6c07d90cb8b08fa7ee0201c4','0fdee9a11ab1140d9e2e3a8194306be4cec45c58',30,'mod_scorm','content',0,'/mobile/slides/','6QstvfND6VG.gz',NULL,3552,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(812,'6348d70c31ce155f98320e0491aa40c1659193a6','b7808ef0661195585d99d08feca4597f7da7f068',30,'mod_scorm','content',0,'/story_content/slides/','6CxYt2EqXqO.swf',NULL,3841,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(813,'01682f8426af99dbd5584a213255af95bc91d57b','24d7fd9abf3c810a5c516c28c6a044ae7e287002',30,'mod_scorm','content',0,'/mobile/slides/','64mYVR9aBBT.gz',NULL,3547,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(814,'d86d65dd46f1b2c2ed3c0b5053f298c24b46241d','1c6148ebe1f776f4d3732555233273dcc217ba7d',30,'mod_scorm','content',0,'/mobile/slides/','6CxYt2EqXqO.gz',NULL,3548,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(815,'830c27b32cb9b9fddff28e9f033dc49383beec1c','481f80590ecca23b7b0c239d0f786f4f15db3c9b',30,'mod_scorm','content',0,'/mobile/slides/','5uAYAKH4EjI.js',NULL,17570,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(816,'253993f1b9e84d494cede45b7905ebbe3fe16be5','1da93dd6917d82c6ad248f4333344fc226c20aee',30,'mod_scorm','content',0,'/mobile/slides/','5yDF5abzTSr.js',NULL,17554,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(817,'6cc4406ec4e6609b49c076baab8f0df384b38761','c7dde331faa4c830f970261f00643347dbf4ebba',30,'mod_scorm','content',0,'/story_content/slides/','6YAbpFglX5a.swf',NULL,3849,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(818,'f924c146d31f0d6074114bd36956e640cd37a29b','b7d2b80639687a944713c1f37b1df7053e7ecf8f',30,'mod_scorm','content',0,'/mobile/slides/','6YAbpFglX5a.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(819,'b8c8ffcde5772c8e0f52f0bca3e273ae6677b07d','43bbf487de74cc83f6be320885b75d459f53017e',30,'mod_scorm','content',0,'/mobile/slides/','6NhjMQ3mtev.js',NULL,17551,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(820,'78c9f7bfc418a3a343f222d4679b9b4f33d112b1','a8ddb108ab3f94e78609d4261e65e0734c8aa7bb',30,'mod_scorm','content',0,'/mobile/slides/','6QstvfND6VG.js',NULL,17562,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(821,'a13c67763cf6691a9889640ce9f3047bf683ee4f','a806fc4bb85680540b4c6da2ed877a478ca6cd16',30,'mod_scorm','content',0,'/mobile/slides/','6iKctyrIqI4.js',NULL,17564,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(822,'bcb6789400e6d5898d4e007c262add951ee89f3d','97e6a9f74200a6faa8004c8b4effa0c1ac0c455f',30,'mod_scorm','content',0,'/story_content/slides/','5kpzexOb3n0.swf',NULL,3831,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(823,'ee51c765dc9d4b35fac8856983fc0292d6a7885e','798473b34aca51a28b6cffd3ee3a37ef9355a7c8',30,'mod_scorm','content',0,'/mobile/slides/','5kpzexOb3n0.gz',NULL,3538,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(824,'80e79ffbdcc1cbba43096c20cd83cdf889ebd405','52dbdedce6e6c0dbf07a61df24b324ade58b1b18',30,'mod_scorm','content',0,'/story_content/slides/','6U11QyxFzm9.swf',NULL,3857,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(825,'eb2fcb822663b088df01e2b93b2c66374702671f','470e33ce30c50bf21ab826922e3d72b92c97da3b',30,'mod_scorm','content',0,'/mobile/slides/','6U11QyxFzm9.gz',NULL,3563,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(826,'3731a87930ab5cb241ca0d3984d43cec078c580e','fffa022a44d4aac621f47cf10ca1c950c9bad508',30,'mod_scorm','content',0,'/story_content/slides/','6f8s4QskmKT.swf',NULL,3843,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(827,'dc4cb82e9794782ed5bad7c05cb1dc6c419c4a05','8f511cdccf62ddeb9e898f01c3184547fe0febbe',30,'mod_scorm','content',0,'/mobile/slides/','6f8s4QskmKT.gz',NULL,3549,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(828,'52f1cf042f1143e55c9822054f404ac190ee0f14','b088bb42e8e9d846cbdfbdbe4a48f267a3a1d4ee',30,'mod_scorm','content',0,'/story_content/slides/','5ZWTY15RcIB.swf',NULL,3835,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(829,'a38df70cbfd39e42e9ba80b3b7eaae1235e614a3','79e9f510f5a55cf45c2c17d9cefc2df95225b834',30,'mod_scorm','content',0,'/mobile/slides/','64mYVR9aBBT.js',NULL,17563,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(830,'33e21e690706ed89998dab21cac60995b761781e','4bb09dcd8ebbaf778265c0cb1f8ceef09a8adad1',30,'mod_scorm','content',0,'/mobile/slides/','5ZWTY15RcIB.gz',NULL,3542,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(831,'c344a3ee36a2ba51e500cf00677f06c1ad2fdacb','7f6449605b09ec0a221a8da516a82fd89a25e190',30,'mod_scorm','content',0,'/mobile/slides/','5kSC4b9wOgS.js',NULL,17579,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(832,'c1f7e46172bed9bdfab8235e207733f5aa514576','103a4c419149f8da9ed2d6c2858ed08e2530ba44',30,'mod_scorm','content',0,'/mobile/slides/','6CxYt2EqXqO.js',NULL,17556,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(833,'019b3febc168be56b42c3a6c231b593b73c5c493','29074553439ea8e393d5f71c0bce032c5a1e45b2',30,'mod_scorm','content',0,'/mobile/slides/','6f8s4QskmKT.js',NULL,17565,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(834,'efa5529efd46b77dd344d3c39c160cd6730b5c18','02fc84307c4be8a8f3e4383662430b8a3de74699',30,'mod_scorm','content',0,'/mobile/slides/','5kpzexOb3n0.js',NULL,17556,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(835,'29816e218e58c580929405032070de84143caa97','fe8210c1e6d6d29db97a9e9a51bcc9c9f75e1a0e',30,'mod_scorm','content',0,'/story_content/slides/','6HapbN87lZz.swf',NULL,3853,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(836,'08dc30bcf7fa77e890aaa02cc443925fc58cee59','91dab67945e40a28cbbe4e6cec96b42ca280d89c',30,'mod_scorm','content',0,'/mobile/slides/','6HapbN87lZz.gz',NULL,3558,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(837,'4567eec8aa2ab58e1c2d5c12944aec648d27be62','64628909bcee339bf7d052108c4a5e4bc75ea465',30,'mod_scorm','content',0,'/story_content/slides/','6BrZkdLzHB7.swf',NULL,3835,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(838,'571d388bb36e80accdaf065dca8102784dded70c','c0336419db8d3eebe2fcacc9af7251f87b7d4425',30,'mod_scorm','content',0,'/story_content/slides/','5hAmE0QdSHf.swf',NULL,3847,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(839,'33747395e583bca44fe0feeb4fd26bbfc4b68bd0','cd239d9baa18127d8bf7548bb32ace60a2637e97',30,'mod_scorm','content',0,'/story_content/slides/','6nTZ9yUxsh9.swf',NULL,3836,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(840,'cca3d23cf61c10d01675ba5032853e427800a885','37840554a8502f1ae7ede46ff84e03f7a41f7604',30,'mod_scorm','content',0,'/mobile/slides/','6BrZkdLzHB7.gz',NULL,3543,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(841,'44ca7892554617b0d3b8c77bcf63cf0ec44eda73','b71edbb9d23f9253f17d2b3b9295e01461186023',30,'mod_scorm','content',0,'/mobile/slides/','6nTZ9yUxsh9.gz',NULL,3542,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(842,'8e8a49afe1d53131c12910588e104b6c7690136e','f8fac1f0601ae598128272bfda1a77c4675caf18',30,'mod_scorm','content',0,'/mobile/slides/','5hAmE0QdSHf.gz',NULL,3552,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(843,'41e2293b63b99133bbcd6d22fd7ab15ed66dc64d','f022d410800aaf9d89c86a9fb57be9cf7e404b71',30,'mod_scorm','content',0,'/story_content/slides/','5j3oWpaWNQF.swf',NULL,3852,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(844,'a70416cf70697503660e4d096d695d692238b62a','97260e8ae2264b664cdf99590296e4c4c4971167',30,'mod_scorm','content',0,'/mobile/slides/','5j3oWpaWNQF.gz',NULL,3557,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(845,'e4b39d7ca5cf72043b6e315943e289a9fcd4b4d2','f8ed77a74492d4c3ab0e9657fd71835bbf617f15',30,'mod_scorm','content',0,'/mobile/slides/','6U11QyxFzm9.js',NULL,17578,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(846,'44f9ca4b58d171c693f3ad126b0beb7005abfcc6','66b7f9bf22e01bda7237013f3ba4f5183f8956e8',30,'mod_scorm','content',0,'/story_content/slides/','6dPJKA080H6.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(847,'b631c4a02b8a8888049b1f679ba79dd21c642dd1','ab650451c2d3c9c9ee504ed99fc31c72da2297da',30,'mod_scorm','content',0,'/mobile/slides/','6dPJKA080H6.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(848,'98e59826e6fb630856177274d415bc4d068b9a6f','7676c1c1fefe893db8678906ef1e31ff696cfb68',30,'mod_scorm','content',0,'/mobile/slides/','6YAbpFglX5a.js',NULL,17569,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(849,'9081e622507499f2edd7dad4b8881e13a2b17794','143f38bc48bfaa09d3db54a21a973799ea123523',30,'mod_scorm','content',0,'/mobile/slides/','5ZWTY15RcIB.js',NULL,17551,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(850,'401cd295877ed63a8d984a9cda357da4742d79a6','ab03b85beca105cb02e7698c8fcdc434a3970ea5',30,'mod_scorm','content',0,'/story_content/slides/','6Gx1XzQGGbE.swf',NULL,3848,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(851,'a33587224783e67e794ee9ab9357a0813d4cb1a7','465693a4fcf7a3a8f814075e1b367583c39d3a59',30,'mod_scorm','content',0,'/story_content/slides/','6pkukPjaI8E.swf',NULL,3849,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(852,'cc8772043918c0bf5a0f64f39197a96a4ef47740','3e553be17631bfe77dcf48a3fb5b921b95a47b00',30,'mod_scorm','content',0,'/mobile/slides/','6pkukPjaI8E.gz',NULL,3557,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(853,'6aab93b82ffc1cfd480220a58458c97fa5e40553','04d86836316f40a5eb337848b10668e4b6f89d04',30,'mod_scorm','content',0,'/mobile/slides/','6dPJKA080H6.js',NULL,17568,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(854,'d6472fc55db12d2b08f7e3726e8457e91f348921','e301b842313c04eeed9a7e17867a2b782243a24d',30,'mod_scorm','content',0,'/mobile/slides/','5hAmE0QdSHf.js',NULL,17569,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(855,'1a207965d8919285c772f512a4a718e9e9877b9d','038350a3dedb7abe69cf5016dc4a2faca459811c',30,'mod_scorm','content',0,'/mobile/slides/','6BrZkdLzHB7.js',NULL,17549,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(856,'4a682105e5557e45050cbc6da5bc471ecc326430','844122b287fca6e5af8b5a86df10889f06afd11f',30,'mod_scorm','content',0,'/mobile/slides/','6Gx1XzQGGbE.gz',NULL,3557,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(857,'6514b6e2bce1067c11205a157cff56603a4e2242','982ee46eefa68e036cb393af1bb12b75f23f2002',30,'mod_scorm','content',0,'/mobile/slides/','6HapbN87lZz.js',NULL,17575,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(858,'00064fd0f169c6d7e3dc7a569b8a5688bd5d6a92','755b28c8a5fcf06a0bdae4c63dc3f2c2f189c9ce',30,'mod_scorm','content',0,'/story_content/slides/','5WmEIP9AOop.swf',NULL,3857,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(859,'926323421ad4d6489541c7db4dd1801628ad3be7','a02ea3e8e41f030244d7f6f4f46776774b620736',30,'mod_scorm','content',0,'/mobile/slides/','5j3oWpaWNQF.js',NULL,17569,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(860,'f88a792ec2f0d3bc7f26a19d132d9dabed2c33c5','414827818cbed6135330ff997b2e62ab49f24316',30,'mod_scorm','content',0,'/mobile/slides/','5WmEIP9AOop.gz',NULL,3563,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(861,'749006ae1463608e417ebe99ddfe02a1070f005c','29072521f8054d275b0c8f3d5671df37de8a062b',30,'mod_scorm','content',0,'/mobile/slides/','6nTZ9yUxsh9.js',NULL,17565,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(862,'f1bf057cf7f21f13adeff4872fefcc5b9ddc81d0','ba77264ad86b2f26bfc5e2756e155ca248b5ae79',30,'mod_scorm','content',0,'/mobile/slides/','6pkukPjaI8E.js',NULL,17564,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(863,'3590ab0e9707c121199061a434110ec051c8bd72','d9779000694572eea82fbb20c405c59875605ef5',30,'mod_scorm','content',0,'/mobile/slides/','5WmEIP9AOop.js',NULL,17568,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(864,'7ba530c304d4d59b42a516bcca362eb65464786a','dd719cf798d580a65061e45017ce372c3d406669',30,'mod_scorm','content',0,'/mobile/slides/','6Gx1XzQGGbE.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(865,'30886b4f607fed927c2c311243a91e39daeadfd4','305da6867d2a372a867641ca9db9917281949b61',30,'mod_scorm','content',0,'/story_content/slides/','6MqmaEonNhe.swf',NULL,3839,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(866,'7b6a75bd1b17e9967f322aba5c247a8c0ba26c73','19c512d65817c8df20fb1ebae08fc022cd8ff096',30,'mod_scorm','content',0,'/mobile/slides/','6MqmaEonNhe.gz',NULL,3546,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(867,'206d9f62c7200f1cc522c1975f9705809890c120','cb34e3b15cd5c8c9ac0803d07ff3c814b5431cf1',30,'mod_scorm','content',0,'/story_content/slides/','6g1lgLhjRb2.swf',NULL,3855,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(868,'72172eab8afcf147768e65acaf6faeb2b4482758','3409b5ee371586ae2faa0e801afa85ca9581f693',30,'mod_scorm','content',0,'/mobile/slides/','6g1lgLhjRb2.gz',NULL,3562,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(869,'9528643352ff28af581e56c1511624f1716d999d','c6a45554ee14e5c2cff078db52af0f2bf36e9fdc',30,'mod_scorm','content',0,'/story_content/slides/','6mOsnJdHY5S.swf',NULL,3857,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(870,'febd9d1bb076baec9e148e94d200c6f8aab58f6f','fda18fb57c6cf9d1d16891f683a35c9884da5e99',30,'mod_scorm','content',0,'/mobile/slides/','6mOsnJdHY5S.gz',NULL,3564,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(871,'abcf05021f8c1842cac76d83cd07c454cefba08d','fc6cb9f5147041e7647ebd2800647e3ad69ea7c5',30,'mod_scorm','content',0,'/story_content/slides/','6qHFvG86T4n.swf',NULL,3838,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(872,'d9dfe765ad55242cfe1b0b060dadc6491d51b4c1','3a3686ffeec9250b9ba2cc0e3b1d08b779d4f442',30,'mod_scorm','content',0,'/story_content/slides/','62WdvjdgRFA.swf',NULL,3837,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(873,'f73b5a443b8bfb617d0a5ac9115169d317ac1efd','3f890154f2e8a25b8029f020e6a19952d44261ee',30,'mod_scorm','content',0,'/story_content/slides/','6nYJIfj7mb4.swf',NULL,3855,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(874,'48452bc95332bffe765e49a6134a045a508652fc','927b9fafa54efc6e342f332f213d10581115f1e9',30,'mod_scorm','content',0,'/mobile/slides/','6qHFvG86T4n.gz',NULL,3544,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(875,'faf4666923e77bccfc36b24877e9eac2bd75d200','c025ba2a59330219c3d8aac3d89ba4f97d897b02',30,'mod_scorm','content',0,'/mobile/slides/','62WdvjdgRFA.gz',NULL,3546,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(876,'e272c59a0a3bbcfcdabe8fe4a7d3ec0b015c4cd6','ddf5e11e543ddaf2ff260bd761b4af11c88e1d91',30,'mod_scorm','content',0,'/mobile/slides/','6nYJIfj7mb4.gz',NULL,3562,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(877,'1b0d68c8d6428fc7ff62edbe30a037e05f89590e','da473aec283aee8478af3ace84bfabac67ecf3e2',30,'mod_scorm','content',0,'/story_content/slides/','6S1sP9UzZRf.swf',NULL,3841,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(878,'c383a3dbba94996fbdfe069b2230be0b7199a4a4','dbdad417d62305669a355c1f06dc41feb6bcc922',30,'mod_scorm','content',0,'/mobile/slides/','6S1sP9UzZRf.gz',NULL,3548,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(879,'e82e88aaae7dfbab7cdfab5dbe9c48ac090d2e61','4c37fa64a51d77e3bf537215837c56daacedcfd4',30,'mod_scorm','content',0,'/story_content/slides/','6UeLOcDBaE8.swf',NULL,3858,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(880,'1c3ac0f35404ef39a3d4ea8a5adf0d7481ed6db9','ec001ee24923ee287edcb407d9815c569bda9ef7',30,'mod_scorm','content',0,'/mobile/slides/','6UeLOcDBaE8.gz',NULL,3568,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(881,'5d1c9f907de39e25f503726267d7ee678f4af261','0c683553f94517e17e67cdbba227dd971dc6ee78',30,'mod_scorm','content',0,'/story_content/slides/','69I0vEJEJT5.swf',NULL,3836,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(882,'01e71e2c5eb352401c6570eaec2656dee8d9d505','4e00aed33f958c6b1aa1b7c9e06faff5f5a1ec49',30,'mod_scorm','content',0,'/mobile/slides/','69I0vEJEJT5.gz',NULL,3543,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(883,'551f3126df87a9fdba24f6fc34734c184d0c156d','7f0bf0bb36b43515979be6014eb4cfb1e89841cf',30,'mod_scorm','content',0,'/mobile/slides/','6g1lgLhjRb2.js',NULL,17577,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(884,'0ffb7ae164df2d1391bf279ff830717fd22619a1','6ba16f6fab004c3a269bc82b57b50060706cc922',30,'mod_scorm','content',0,'/mobile/slides/','6MqmaEonNhe.js',NULL,17554,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(885,'59ca57b8a14b100959b45ea7bd836154932c1519','ae18d10a7a252087522f57a0091b6f51d32d6d94',30,'mod_scorm','content',0,'/mobile/slides/','6S1sP9UzZRf.js',NULL,17554,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(886,'66c2c00b4b16d6f419536897d258f72b85cf821d','df44a915c6f7c91244fe944a2f3c390f71f8fb3f',30,'mod_scorm','content',0,'/mobile/slides/','62WdvjdgRFA.js',NULL,17556,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(887,'16c09c137be85177d5ff1c04cf71da7fe1024ad5','7a2709081434e9b53f51d7ebfea2535b98e9dfdd',30,'mod_scorm','content',0,'/mobile/slides/','6qHFvG86T4n.js',NULL,17565,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(888,'d0cf519567f83a033b68f408792e9d97cfa3866a','f82b8ea42fb0b8a5f2553b3b6ee9f44464a10cdd',30,'mod_scorm','content',0,'/mobile/slides/','6mOsnJdHY5S.js',NULL,17565,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(889,'f4090393ea1732196d76d2c5474b2de4a45ab7ca','451ad9aafe0f0118a9e863137d7d64e969c09f02',30,'mod_scorm','content',0,'/story_content/slides/','6EW9UsapxeQ.swf',NULL,3857,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(890,'780eaf38bfd8698353dede037095775e7ad88637','183577fbc7f3af9eba38305bfb2a48cd1a207949',30,'mod_scorm','content',0,'/mobile/slides/','6EW9UsapxeQ.gz',NULL,3565,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(891,'a917b83b0cb400860ff6f902913881fde19d92fc','18c85de67be56e6c6952b510a2bfba29855a09e8',30,'mod_scorm','content',0,'/story_content/slides/','60rbkPEjk0U.swf',NULL,3841,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(892,'78f7154e6e26158569213193b72b2214988ddfd4','5905d287eeec8bef47f8aeefcaa92b1e96172e89',30,'mod_scorm','content',0,'/story_content/slides/','6ff1FiGZbTp.swf',NULL,3852,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(893,'cb86499cb468b41f3c5677a9d54d3a36376bb0b9','d129be132b413bde87bd472b6d7b19314d7bc7e4',30,'mod_scorm','content',0,'/mobile/slides/','60rbkPEjk0U.gz',NULL,3548,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(894,'8f02e0a5c2d51e54067c3255ea95274d9afebbc4','083a155b4c6ef66a927cb24dfd0049e46cadfc3e',30,'mod_scorm','content',0,'/mobile/slides/','6ff1FiGZbTp.gz',NULL,3559,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(895,'5908008c8529f5aa32b030cc354d33ce7aa85b28','541b17afabf7f987c83f011fa6a5e5195de9dbc3',30,'mod_scorm','content',0,'/mobile/slides/','6nYJIfj7mb4.js',NULL,17567,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(896,'c845856abdbd6044fc7fc8f03ee2cf56ecae80bf','566f3c26626f5b83ab590d573e5d3eb10af16b78',30,'mod_scorm','content',0,'/story_content/slides/','5gDxOPfnFxx.swf',NULL,3857,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(897,'3ffc7b079b062c3e719869dd1fe3469616c218a8','a9c3b17f81ce8d74bd65981f7ccffd5074231b50',30,'mod_scorm','content',0,'/mobile/slides/','5gDxOPfnFxx.gz',NULL,3566,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(898,'d20e32b3e5dc930230ba52e118c4d791f9664a48','4d12fc8fc70ede86cd876c0d8cacd1d4474fa81e',30,'mod_scorm','content',0,'/story_content/slides/','6ZINwBpbU84.swf',NULL,3840,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(899,'dab661abf09f7b2654b9015636493ec0234ac9a9','4854932a61d85e80ba2e4a6b75cd82bb4eaaa049',30,'mod_scorm','content',0,'/story_content/slides/','5ur8KmrDdxN.swf',NULL,3847,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(900,'c7803f79dbf344bee0760c4e6542e00bf3cc9393','5781104af0214831a5934172cc88bda4142d516a',30,'mod_scorm','content',0,'/mobile/slides/','6ZINwBpbU84.gz',NULL,3546,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(901,'05837415f275363181af404984a6fc4e4f9bef21','cca6c26a555d8bfefbb37f5eae0538313cd8ff36',30,'mod_scorm','content',0,'/mobile/slides/','5ur8KmrDdxN.gz',NULL,3554,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(902,'34442705bd1e7350baa54fd42ceb43f2267319fa','f522df46af8325f5a39e12dc5565fab270ba3d31',30,'mod_scorm','content',0,'/story_content/slides/','6AM89gPbHJQ.swf',NULL,3837,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(903,'0b1a15eaa5fcc6b7def362c1ef53524eb74013e0','b476a10a2aecb8d345131d6195fec5fd99370d70',30,'mod_scorm','content',0,'/mobile/slides/','6AM89gPbHJQ.gz',NULL,3544,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(904,'7c5ea407f573a795542b5652a33b1dbf2c9a3bfe','48528a283d5d4e4435f5f74c5f294cb850532dac',30,'mod_scorm','content',0,'/story_content/slides/','5qAtY6ai7rA.swf',NULL,3847,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(905,'8007425a6f7fadd7d5bd9580ef985a31e1ea8613','e6a7d213be38abc46169fcedafb992af5594e7f2',30,'mod_scorm','content',0,'/mobile/slides/','5qAtY6ai7rA.gz',NULL,3552,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(906,'fdae3e2c620a2ebd334e078712d82ce2eb7fba36','459584235c606af6b35502aa2f13cebd4311dc3f',30,'mod_scorm','content',0,'/mobile/slides/','6UeLOcDBaE8.js',NULL,17583,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(907,'63eb3d331986c99be8c2fd9153d2479a083fa483','b4877d29cb2897d2ec902c35a56e9f94036c4df1',30,'mod_scorm','content',0,'/mobile/slides/','69I0vEJEJT5.js',NULL,17552,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(908,'f16f97ab8491fc75122ada5fa25dc736ea9917c0','fa67189b5564a6ea10b1743d2ccf74082d53fae4',30,'mod_scorm','content',0,'/story_content/slides/','5qH1tAVOgXk.swf',NULL,3875,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(909,'4bd16367ac10c6ddc51c9541391f413716f795ee','96acef31c40b718ac4a4ee6df10934123d6d9d7e',30,'mod_scorm','content',0,'/mobile/slides/','5qH1tAVOgXk.gz',NULL,3583,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(910,'fd32b3ce81b081e1ace21fc7ad99eafc39266b72','73ab9028f69dbf25a1d1649252e1c996d88798d6',30,'mod_scorm','content',0,'/story_content/slides/','5oanEK4QscL.swf',NULL,3847,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(911,'c3e6efac4415de564c740de5253a18d44eee2f34','0ee9d00017d7ad65a64cb95e10f13b99f4562e27',30,'mod_scorm','content',0,'/mobile/slides/','5oanEK4QscL.gz',NULL,3554,'application/g-zip',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(912,'24cf78c00ec1ea02a58fd37c21530c3c84e37dd6','e2d30da369ac9b26e92bc1990d95c97664179e71',30,'mod_scorm','content',0,'/mobile/slides/','6ff1FiGZbTp.js',NULL,17572,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(913,'e0667c64b79e71cbf554d3515607f7745de8703b','f858d2f79ee7c8b4bf0900aef202ee4359392ffd',30,'mod_scorm','content',0,'/mobile/slides/','5gDxOPfnFxx.js',NULL,17590,'application/x-javascript',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(914,'fa3b8853945387379eb7ea302d38cc9cccb3a086','888c096392d0dff6c678904c53ec65cd88adb632',30,'mod_scorm','content',0,'/story_content/slides/','5f39qZ83Nxh.swf',NULL,3845,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458059,1462458059,0,NULL),(915,'9b363ffd81625ecf985bf58dd237734244e2c899','92e60ac6043eb64f32732b06f3379eb327864a6e',30,'mod_scorm','content',0,'/mobile/slides/','6AM89gPbHJQ.js',NULL,17550,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(916,'774972500099a63e1968f43e89231fba6ee2c0a1','1fc0a6f9d6f90b4e2cf3e34437ef477a78b7039a',30,'mod_scorm','content',0,'/mobile/slides/','5f39qZ83Nxh.gz',NULL,3551,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(917,'c8c5e0437766374f2de61c2413c97452e73030a8','edadfc8532c204fcb28361ea995ac41c8d63ce6f',30,'mod_scorm','content',0,'/story_content/slides/','5zowhWbwfjA.swf',NULL,3858,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(918,'65371c3c3b9ba9e67c5865c8f2324772e6cf3dd8','f8598e03ba17d2d93cd6c75ca4fb04eb703e94b5',30,'mod_scorm','content',0,'/story_content/slides/','5aYCNkBouyk.swf',NULL,3846,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(919,'8565dcd78cbcf9c26b1ba153be9e838c1718b940','1077920bd28fa527801778a9e1e3983a7cd4db13',30,'mod_scorm','content',0,'/mobile/slides/','5zowhWbwfjA.gz',NULL,3568,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(920,'b1becf87838cdec9fc76fc487e70fc9d9ebdf652','756600cba79076b9f09c377d16d7fc53c453e8e9',30,'mod_scorm','content',0,'/mobile/slides/','6ZINwBpbU84.js',NULL,17553,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(921,'81ad44271c1dfdeb9eeecefc26fa97b8a5a80c73','6370f7b0ee0ad313ee79eaec3c7fb5827fcacc90',30,'mod_scorm','content',0,'/mobile/slides/','5ur8KmrDdxN.js',NULL,17552,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(922,'ab09d1b76e3f29d267920b8337c50daa2e2b15fa','2f4c0329616aad9a9f4d100c8f62b75c03ad7d52',30,'mod_scorm','content',0,'/mobile/slides/','5aYCNkBouyk.gz',NULL,3554,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(923,'c458d41b5eb27e72a25144e373382307d1f9ab87','797640f01a42c2f3c393aedb1f87d36a4c0772a0',30,'mod_scorm','content',0,'/story_content/slides/','6Vd2YI7QZpE.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(924,'2f1290bd58dcfa79dcf7d656a076b87210877d0f','28924a694a8167edb78a952b1118eefa4b0b74e7',30,'mod_scorm','content',0,'/mobile/slides/','6EW9UsapxeQ.js',NULL,17586,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(925,'9526820f9186bd93af952aabac167e018ae7d621','a6fa228c338346dd98f7abb71836510badab4c7c',30,'mod_scorm','content',0,'/mobile/slides/','6Vd2YI7QZpE.gz',NULL,3555,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(926,'80db5ad917e21166f184e8e2020b44a9b33ad9b8','d057e95af9b9b883529609c760698cf062c24f5b',30,'mod_scorm','content',0,'/mobile/slides/','60rbkPEjk0U.js',NULL,17561,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(927,'bf39e1ca121f09c30ced4ee09b832d7b8e830176','2fee3c635d51ceadca65f2be084f21c0ff43d29a',30,'mod_scorm','content',0,'/story_content/slides/','6LtIRGTKz7O.swf',NULL,3843,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(928,'6d0ef2ec8058abfbdc4743c4ba0e89593ede8532','11100e86e467652fe9463f0f2d72d34baa2dbf80',30,'mod_scorm','content',0,'/mobile/slides/','6LtIRGTKz7O.gz',NULL,3551,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(929,'81165d2d2dbeb8d0de2fb555b433c359bc96930f','298edac99ad454630458d2c7aa66b3a471a4ada6',30,'mod_scorm','content',0,'/mobile/slides/','5qAtY6ai7rA.js',NULL,17570,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(930,'5553f46526f6e6faef5489ca1695edeae4d193b5','d0b095384817345c2c2027b1711a921f2065675d',30,'mod_scorm','content',0,'/story_content/slides/','6UoXdAmepAE.swf',NULL,3844,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(931,'d0d66f8e44f121d9a0c50978fe244eb199ed1667','3d63c1b88bcf8df57b01de084a25919fde27b3a6',30,'mod_scorm','content',0,'/mobile/slides/','6UoXdAmepAE.gz',NULL,3552,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(932,'84a342440ab3d8925e3d037fa6639bc27ba4ab37','bcb53c2c70bb73c3b531b05f51fa8cf263c08a6d',30,'mod_scorm','content',0,'/story_content/slides/','6iWqZlNv6RW.swf',NULL,3853,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(933,'8d19753a9ced85be2391bd062b0b54cf9ab0b6dd','3b326b2caa05088663422278e3f62c0ec1e64aad',30,'mod_scorm','content',0,'/mobile/slides/','6iWqZlNv6RW.gz',NULL,3559,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(934,'c1dfe5c829713df75719c602aaaff1f76300d829','d72c6faeddf075d3b89ba0c82dbf76f9bfbfa00a',30,'mod_scorm','content',0,'/mobile/slides/','5oanEK4QscL.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(935,'3517488bde048da604765e386bb95997647a9e6e','c156b3329f106adcaf1b66ec383e1af5722a18cc',30,'mod_scorm','content',0,'/story_content/slides/','6SaU5Uvbs1f.swf',NULL,3848,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(936,'2d84bf56da948992c63f0e6d0423532d253659f7','914f351a9679bee7ec47e28456aa77e7891d2169',30,'mod_scorm','content',0,'/story_content/slides/','5vBoQ7dFD6Q.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(937,'a47d914a108255632427ba99dd5cf1d18942bf95','397f92ea7a35484545cc488a2436a97fdf3cefb5',30,'mod_scorm','content',0,'/mobile/slides/','6SaU5Uvbs1f.gz',NULL,3555,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(938,'ff062ec366d53a9963b967f873293f27214e03ed','aabb7cdac8c10e087c1b843ae1d7ee9be12997dc',30,'mod_scorm','content',0,'/mobile/slides/','5vBoQ7dFD6Q.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(939,'c7aad57cf77ac590772ce13cd8b777f6286c7aed','ec212b7b844e0d2b1c7a1e3624dcfdc319a60ce2',30,'mod_scorm','content',0,'/mobile/slides/','5qH1tAVOgXk.js',NULL,17603,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(940,'3be0994397f6bd549f24c296d2cf1cadc07dc9b3','691becea74440907c7d47c4986a17e936ff35c0f',30,'mod_scorm','content',0,'/story_content/slides/','6eNCBAo1bwM.swf',NULL,3845,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(941,'07d1ee5a680d64189636f2436d77a73bda173177','16888dc63ce8bcdd59be8d88a138e1439a357684',30,'mod_scorm','content',0,'/mobile/slides/','6eNCBAo1bwM.gz',NULL,3553,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(942,'85a381b71bbdc4a4f9656a7efe6e7075adcdb514','52c8b75413f91b05bb980ca8ebe535f8db00523c',30,'mod_scorm','content',0,'/story_content/slides/','6Gdj999Ua6v.swf',NULL,3841,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(943,'88fe3f0289078ef0b01108139f8096e1935ef9f4','6a91361f5f820eb8eef306e21171540bc2afa062',30,'mod_scorm','content',0,'/mobile/slides/','6Gdj999Ua6v.gz',NULL,3549,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(944,'7a3c44e24349b55d44898395be6234f778eaf2d1','6d23d7d0b34ac84205ca1b0b13232a94bd7aa9d1',30,'mod_scorm','content',0,'/mobile/slides/','5zowhWbwfjA.js',NULL,17615,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(945,'4afeba3ead23dcfc3c0a5db815ed94a715a6285e','390d6cc2e9f79bcc5932cc3e7f9c7c368ec56023',30,'mod_scorm','content',0,'/mobile/slides/','5aYCNkBouyk.js',NULL,17569,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(946,'096e404553ec0130640db066117f5ed97728501e','81ebe108091c23ebfdd963b7d1093a904c6d88d1',30,'mod_scorm','content',0,'/mobile/slides/','6Vd2YI7QZpE.js',NULL,17565,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(947,'dce41a91513121bb554a0736a4b6a5b371bc4bf5','b39d626bb8e208dfe0a50d1e80b1edf927a47b55',30,'mod_scorm','content',0,'/story_content/slides/','5jHqXIOLD5d.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(948,'709632b87278f8dc5877eb27d6a82487e8c21c57','8985e3af3d9798b6ed539be4fc788ee28c20f235',30,'mod_scorm','content',0,'/mobile/slides/','5jHqXIOLD5d.gz',NULL,3555,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(949,'b2da8b142aeabfdc8b6ff5bca070daa7e11e8860','130183f15fd416b043ef625cea5744cf7bf7e7ff',30,'mod_scorm','content',0,'/mobile/slides/','6UoXdAmepAE.js',NULL,17556,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(950,'f5cd225e81536f6ed6d53609e5ab306768f22e52','63d9120318cdf301efb2b8f1510464c925eedb14',30,'mod_scorm','content',0,'/story_content/slides/','5nirpXxlnx1.swf',NULL,3840,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(951,'5079633dd1307f4d86582c61650c1e05328edd91','11a915eedfb14e42ff184bdf59d870829f091f6b',30,'mod_scorm','content',0,'/mobile/slides/','5nirpXxlnx1.gz',NULL,3547,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(952,'88ce2b09be6325151245633bc9d77379ecc8522e','8abb950e3da4923ed147101126605a1b57e6373d',30,'mod_scorm','content',0,'/story_content/slides/','6OBdeccCHXM.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(953,'a2a87a87aa6b22ae1e159996f0dce84956b412cb','401ef8892b26082ad2f88610696bfe204ee98b28',30,'mod_scorm','content',0,'/mobile/slides/','6OBdeccCHXM.gz',NULL,3557,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(954,'8ba1c7358b245026096d7fac7e9b2b8e74d9fd2d','7295e26c0cf11ebf82fbd6bca82e68c76fbe74fc',30,'mod_scorm','content',0,'/mobile/slides/','6iWqZlNv6RW.js',NULL,17574,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(955,'c97eeebb4b21a32ca2b44c52fcdb1c388bd2ce55','1b3d33a63b280a4e4afaafeabb08295e1186fa00',30,'mod_scorm','content',0,'/mobile/slides/','5f39qZ83Nxh.js',NULL,17563,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(956,'c35a177940efca733f137e6bd60f30daa9489fda','436e4da2e7a3d41638f359fef7717d8dd494a2dc',30,'mod_scorm','content',0,'/mobile/slides/','6SaU5Uvbs1f.js',NULL,17577,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(957,'5b8d67cef9682b59a6bcd2cb660f94bcf648d499','bbbf1a3423e4854500c3842bf2f9b8c56b5df787',30,'mod_scorm','content',0,'/mobile/slides/','6LtIRGTKz7O.js',NULL,17555,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(958,'5f86b1c013021fa96b950f1b29ea68d7de205a64','9d18edaa65f5d20b009aa3df87e023ecb5e10bd0',30,'mod_scorm','content',0,'/story_content/slides/','6n9h4x0hNaS.swf',NULL,3838,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(959,'efc06b46bfd0cb2a5ab3f305bddf731f5064c2e7','a143102e00fe6ed154a89b6d47aee96990671b02',30,'mod_scorm','content',0,'/mobile/slides/','6n9h4x0hNaS.gz',NULL,3547,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(960,'d2351b31f699a22be42f227e6550e2320850ee6f','d04931d31bae7f02f50e27fc3fd94713acf411f3',30,'mod_scorm','content',0,'/story_content/slides/','6nF8RYG1lOt.swf',NULL,3848,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(961,'f6c6a483b5219275d361f28aa092f67bc67b0180','a609d5300f866c3c790e84fcb1c111ec600dd524',30,'mod_scorm','content',0,'/story_content/slides/','6YH5M7i0ibV.swf',NULL,3842,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(962,'4127a1e1e9d0a33c79a3af15960ba6edde6c193d','3affa870ba87a3071cf1f401f326c3e9da55113e',30,'mod_scorm','content',0,'/mobile/slides/','6eNCBAo1bwM.js',NULL,17567,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(963,'80ae74d5f989b8de7399c7fe34991fac9eff35a8','b1f2bb3be2fecd4c69c5e8f91428adf2b061d62c',30,'mod_scorm','content',0,'/mobile/slides/','6YH5M7i0ibV.gz',NULL,3551,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(964,'3de19acf49083ee3bb20cc829f3d9d2ac5e27029','07084a42fbef9ba2f5bd60c5b4a6cae846f16cd9',30,'mod_scorm','content',0,'/mobile/slides/','6nF8RYG1lOt.gz',NULL,3555,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(965,'474ea48dd750220f5237681a6526074180e6972e','7cdd2816da5c1ba743b24ac34e9027cd18507726',30,'mod_scorm','content',0,'/mobile/slides/','5vBoQ7dFD6Q.js',NULL,17572,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(966,'b537334b7273d09d5090835e53a09fe572ff45c6','faf7fe5650103c500819310c6fa0bbbb0065dd80',30,'mod_scorm','content',0,'/mobile/slides/','5jHqXIOLD5d.js',NULL,17564,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(967,'160509ae04c97683694879edd206a0ed81ae3db2','244435ce392bf4f233f7ef198d17e7c8128e58dd',30,'mod_scorm','content',0,'/story_content/slides/','6PpGpRE2GEh.swf',NULL,3853,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(968,'a93914aeb0ad5fad02de702d83a79d57456efd6c','c878d17a1087d4eb945541d2f5db35c1a621b142',30,'mod_scorm','content',0,'/mobile/slides/','6PpGpRE2GEh.gz',NULL,3560,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(969,'d0d7a3dcb2458f4a20fb45893aa51f0cc98d88c4','c7468292f55a7b34a1433f7a87c2beea05df7817',30,'mod_scorm','content',0,'/mobile/slides/','6Gdj999Ua6v.js',NULL,17552,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(970,'577a44914be9265e783e289fb5c0ac60f9af3d9f','13bcc820f5d610990ff5d26bb0548223938b3ffb',30,'mod_scorm','content',0,'/story_content/slides/','5dPA7cTC36W.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(971,'1ef9e9db77df52f063b2856dedc1b7094f07fbfc','b65095d8f62c8a02cd7010e1731d8a2bc6923d15',30,'mod_scorm','content',0,'/mobile/slides/','5dPA7cTC36W.gz',NULL,3557,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(972,'cb9a5afb0b4a56c9b39a519dab59364a236fe9fa','f10e3c305cd6ef73acdc7179a6c9ec226bfe45dc',30,'mod_scorm','content',0,'/mobile/slides/','6OBdeccCHXM.js',NULL,17568,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(973,'de07642700c3d00743a0ab13b3e4ef63ae64e173','3e348e11afdebd913df9a6b84d5209bd64c79b51',30,'mod_scorm','content',0,'/story_content/slides/','6YtHlxpb1kJ.swf',NULL,3847,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(974,'2cdde01e2a229e022a67d3acec76c436bdc80b72','7cbb7bd2ed884f0cb958543265f40c139eed928b',30,'mod_scorm','content',0,'/story_content/slides/','5vqzsQ1v3hc.swf',NULL,3845,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(975,'fbf3717c9c93d7666fea24c75d20d910e4709260','6058415ed120a70a4972a3e78cef0be45799db18',30,'mod_scorm','content',0,'/mobile/slides/','5vqzsQ1v3hc.gz',NULL,3551,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(976,'8ac42611497727ce5a5e2be22352aa96bc33647c','0f828cedc1dd347f044698e7ee315a36e9390839',30,'mod_scorm','content',0,'/story_content/slides/','6azuEffNkXv.swf',NULL,3835,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(977,'28d537dec2c7d37ff5871aad1f418d09ea79c117','bb7d43d77232efa9131be252ec1b4a2d9e365370',30,'mod_scorm','content',0,'/mobile/slides/','6YtHlxpb1kJ.gz',NULL,3555,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(978,'e9091734b7457dc4e06a0bc781f66eb6edfbc038','8b202847c37b179c32ad7d61b285ee334ac6ee9f',30,'mod_scorm','content',0,'/mobile/slides/','6azuEffNkXv.gz',NULL,3542,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(979,'6fde8b61c425e66cd42221476f11e060dd4c6b21','910a0eca87ae84e2281e21a2cd630c6c82991f37',30,'mod_scorm','content',0,'/mobile/slides/','6n9h4x0hNaS.js',NULL,17556,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(980,'8b4e7aad998d3743c45e23fdbb044b816ea8f6b0','f26a5edd4e2794a732b600b0319b061dc673405f',30,'mod_scorm','content',0,'/story_content/slides/','67G7jF9cEcS.swf',NULL,3854,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(981,'215ad0cc3655a943c2c2ab4e5c40198c48abf48f','7c6476bba05d99e9bfa99782dc0197c3ae159bff',30,'mod_scorm','content',0,'/mobile/slides/','67G7jF9cEcS.gz',NULL,3560,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(982,'ef936a2d33ad67c92a8a95f4758e65081cf6bc5b','627c3de90719a4e302e8bff18489205bcee3221d',30,'mod_scorm','content',0,'/story_content/slides/','6ElCfyZp6z3.swf',NULL,3846,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(983,'7c136ed4bc28dbf95f841e4d91cd9f02640e38b7','352d758553e8d9db90b9bb00660bc9a2d14fdcfb',30,'mod_scorm','content',0,'/mobile/slides/','6ElCfyZp6z3.gz',NULL,3553,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(984,'7f970be60eeb150d9eebcef2a63cfd3c9f554126','738221e0a942555aaa45860cd72889e457fdf1f3',30,'mod_scorm','content',0,'/mobile/slides/','5nirpXxlnx1.js',NULL,17554,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(985,'0e47bfef8e1d676b97b9d41900df4170e76435bb','3f43a47af39d4a965fdf000d4b8f223497a3bfff',30,'mod_scorm','content',0,'/story_content/slides/','5jeHCJx1QPv.swf',NULL,3859,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(986,'fb96780d859ac492a47e9a81bb3d168bf7795686','aaed522ae029b4a77684233ce536495b337ebb7f',30,'mod_scorm','content',0,'/mobile/slides/','5jeHCJx1QPv.gz',NULL,3567,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(987,'62682c4444e312a95158626123674bc558a27f13','7740f67891d1db0d8ff5bf8d8069e2913b195123',30,'mod_scorm','content',0,'/mobile/slides/','6azuEffNkXv.js',NULL,17555,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(988,'742041a4a156e3aaca3b166c4eedd12258894498','c4add781a979bc8f697250182b585b38ad3ffa52',30,'mod_scorm','content',0,'/mobile/slides/','67G7jF9cEcS.js',NULL,17570,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(989,'c12befe99fc989161b4b0e72cd4980f81370795f','c80517e0e1d3ab41135fd6c6e59eac5a8b798d41',30,'mod_scorm','content',0,'/story_content/slides/','66mSeyflhLR.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(990,'943dfa015e406598cfbd4316a937ea826be432ad','f1d4ead2e603f1cfc92d6372880098e0c58a5b6d',30,'mod_scorm','content',0,'/mobile/slides/','66mSeyflhLR.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(991,'d09f4e085ba727f1f5328c4834acd28978843c2c','23828c00d84d38b3adcd9c004a30a1fbf6cfdb53',30,'mod_scorm','content',0,'/mobile/slides/','6nF8RYG1lOt.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(992,'d895e1d90e50c8449d6fa7dbc77109ed8cc4f8c5','4a413642a605de743f3e6a2695c22b98cffa2f7e',30,'mod_scorm','content',0,'/story_content/slides/','6QcyNtXuTNw.swf',NULL,3842,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(993,'9bb9cae21988d0f2cd24375ee61f7d1d9bb7fe30','fff1822304fc2cea39bdc657d830d9d4c5d44503',30,'mod_scorm','content',0,'/mobile/slides/','6QcyNtXuTNw.gz',NULL,3548,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(994,'dc3d9771c7c3ee5d7fe762e6b9fbd3c01facd14e','0bc13cc8c46050606a39cd7ee76a9ce43b64262f',30,'mod_scorm','content',0,'/story_content/slides/','6lTKDdPrtLb.swf',NULL,3846,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(995,'f68931ae7220e217cf11ef37e284db5f483ae8a6','759f08c1ccc7effbbb6d3d83cd6388fb06786ad5',30,'mod_scorm','content',0,'/story_content/slides/','61TgDGzpnkH.swf',NULL,3867,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(996,'edf04d0f34115316fc9f51cceb5685b6bd75add5','dac48c7771a1df4b9056da5aed7945beb29e444f',30,'mod_scorm','content',0,'/mobile/slides/','6lTKDdPrtLb.gz',NULL,3551,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(997,'ede06fc3956c238dbc586383b59c8b3cefebc26c','6c5a17dad3e6c29f3242b2f9f5c08186ccb08b0b',30,'mod_scorm','content',0,'/mobile/slides/','61TgDGzpnkH.gz',NULL,3575,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(998,'977499117dc59b8dc591e96db8a6df287497e97e','87e9cc5ddf4182b846e51d7f88b73d6599bc2c5d',30,'mod_scorm','content',0,'/mobile/slides/','6YtHlxpb1kJ.js',NULL,17568,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(999,'d7f1efcecd535ed34ed3a5cbf75041e7fefe8157','3977bbd859073163605449eb38eb549851c77a63',30,'mod_scorm','content',0,'/mobile/slides/','5dPA7cTC36W.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(1000,'ea1c268611e1cb9178e347fb64638daa212f2ddf','e76087d478bd64c0c5bcd6d6f194fd1c8171ce2f',30,'mod_scorm','content',0,'/mobile/slides/','6PpGpRE2GEh.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(1001,'5ab12e65625793ec337eca50be32c0875ceb3b4e','80d4190873a94ddd4d7a8a412ae03776464f35e6',30,'mod_scorm','content',0,'/story_content/slides/','5YhAkwMVWPf.swf',NULL,3856,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(1002,'6e8aff3b46f909aab5cae242257179a2e393e9ac','15438b03c2cbd3b43d16ebe8eba97b2cc2fd9381',30,'mod_scorm','content',0,'/mobile/slides/','5YhAkwMVWPf.gz',NULL,3563,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(1003,'a3c2b1d38cda1b331eafbd405f5926192ff245bc','e83a1420ac4e3a8a313a064a45094f896c1a50eb',30,'mod_scorm','content',0,'/mobile/slides/','66mSeyflhLR.js',NULL,17571,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(1004,'cb16609700ac117e8ba1e47b4a4f8c1fd8af2b6e','fdf2c2ccf602c78078944751db2ece8ddcc6d4b0',30,'mod_scorm','content',0,'/mobile/slides/','6ElCfyZp6z3.js',NULL,17556,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(1005,'8c1899e55c649604818c773e4ec5c3f82371bf69','161ed85c2420d7f2d866590fe42640e10bfdd514',30,'mod_scorm','content',0,'/story_content/slides/','5m1vzEPovCc.swf',NULL,3857,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(1006,'21c4029af65b65cd6ee4a9778f3579c29c3158ad','26e650b6a181a9176479062cd68914e32f91a4bc',30,'mod_scorm','content',0,'/story_content/slides/','5tfyOAwkrTl.swf',NULL,3858,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(1007,'fcc06582a60752f6cc376a0c90d58ee1ac5dea3f','ba2b92aeaaa46a7e504d2fd61db2d0628313ae83',30,'mod_scorm','content',0,'/mobile/slides/','5m1vzEPovCc.gz',NULL,3565,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(1008,'254ee6b9bf09c44dc809f949a051ea3de0d5c357','3576b25bc01f582e55968d941d44584d513ace82',30,'mod_scorm','content',0,'/story_content/slides/','5X7cNtX5LQI.swf',NULL,3847,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(1009,'7f9c4112ef9354c39e2fd350687bc3c33ea9a105','6292a43a9b27c3d2e678c2308f7fe30d07a97d71',30,'mod_scorm','content',0,'/mobile/slides/','5X7cNtX5LQI.gz',NULL,3553,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(1010,'d9777e7e94bbb6c7eccdcc2a917fe1c79675bf6c','eef9b74eb985e468d7925c9a0053b3d97cab2a5f',30,'mod_scorm','content',0,'/mobile/slides/','6QcyNtXuTNw.js',NULL,17556,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(1011,'abbefa6360205b50aea98d1abfc5079f29a416a2','dd421921a3e4452ec7680fd03cdb7c5a40dee898',30,'mod_scorm','content',0,'/story_content/slides/','6d7myVZ213T.swf',NULL,3838,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(1012,'1567893d2faaf70ed1dc7be954594c38008b8288','24bcba6da7653d5e62aa521194f493adf86a551f',30,'mod_scorm','content',0,'/mobile/slides/','6d7myVZ213T.gz',NULL,3544,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(1013,'1c0e94dc0fcd6dc0f5e6f53698305efa28c3bd0b','611fce64ac90eb8b235048ed4a46d759c6f62fbf',30,'mod_scorm','content',0,'/mobile/slides/','6YH5M7i0ibV.js',NULL,17553,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(1014,'fdb1f679c8eadcd88bc94fcef902beeff7e2dcff','b13bcf9665969e7f110bbb178c8a0c3bf56632f6',30,'mod_scorm','content',0,'/mobile/slides/','5tfyOAwkrTl.gz',NULL,3569,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(1015,'f334d6e0c8dc2636b9a37aa3312f85df954a887c','27ee60c909521459907089b12653147b41559bc5',30,'mod_scorm','content',0,'/mobile/slides/','6lTKDdPrtLb.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(1016,'321d6456e468e3887ff6e87be123e48ea2b712f6','ab2f93cb8bddd7e145213dd18ab22fc5888067fd',30,'mod_scorm','content',0,'/mobile/slides/','5m1vzEPovCc.js',NULL,17581,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(1017,'846a2a150c2e10ec7ed2e07c5c469d20130cda8f','a51d45cb74c66235ca12e05ead38afef9c1ed3a1',30,'mod_scorm','content',0,'/mobile/slides/','5vqzsQ1v3hc.js',NULL,17567,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(1018,'cabdf02d4be67f2eec0aa3a9a1899a196316513b','0651cdd675b35f827282af331dcc0d3e5c971811',30,'mod_scorm','content',0,'/story_content/slides/','6Kl1FUDZoy1.swf',NULL,3839,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(1019,'84d05f08f0d24413e9577c61cc748ee36639712a','d3c7302c304ed9d6959fc5c698b233c5b99ffc8b',30,'mod_scorm','content',0,'/mobile/slides/','6Kl1FUDZoy1.gz',NULL,3547,'application/g-zip',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(1020,'c81d8b522977007ebb3a5b66e004103fb933c044','80c558e05eb30f3c9fb9c8b04f47d671067b9404',30,'mod_scorm','content',0,'/mobile/slides/','61TgDGzpnkH.js',NULL,17607,'application/x-javascript',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(1021,'b24fae8270bc1cfbcea5976ab9f9a49b3db6be79','a15688eec55a08d4a9716c4de03a43c7f2bb8862',30,'mod_scorm','content',0,'/story_content/slides/','5yxeEmEcXk7.swf',NULL,3846,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458060,1462458060,0,NULL),(1022,'4041ccde291e194ab12fc4dadb8dbc3aaf3914ec','53426c2629d5657fb411c364aa3c8f2945a6f06a',30,'mod_scorm','content',0,'/mobile/slides/','5yxeEmEcXk7.gz',NULL,3553,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1023,'a1a89f0906e2c9b5000dad5f99c6e5563d9e955d','617964516389e19e5ebe7ae06a8836da955273e6',30,'mod_scorm','content',0,'/mobile/slides/','5X7cNtX5LQI.js',NULL,17570,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1024,'88062623f8133a366521052dc1c5fdb8bc325ffb','3ecf0bce1a3ff744532a69ea5e1cebc0b24089e3',30,'mod_scorm','content',0,'/story_content/slides/','6jqYfrzSSYy.swf',NULL,3835,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1025,'c6e7dc6e32dd230e739889d9377dee286be11282','1a54f05912175f178d5dfb68eb033b0642403b2f',30,'mod_scorm','content',0,'/mobile/slides/','6jqYfrzSSYy.gz',NULL,3541,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1026,'e46300f4c9ad74689fa1b7cbd8afcc6a10a88161','22123a58f7da13e4a5864974fda43bdd40b51702',30,'mod_scorm','content',0,'/mobile/slides/','6d7myVZ213T.js',NULL,17554,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1027,'2412065474635b98605c677d7d081eb055ae7b5d','8ffc4cf785fd63ad4e98df26b370aafe300da685',30,'mod_scorm','content',0,'/mobile/slides/','5jeHCJx1QPv.js',NULL,17599,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1028,'c080390ad3731b00b9abf2493c03c673541cc442','61d6d40b9455d8e098b57986726ea2fa2ce9aa3c',30,'mod_scorm','content',0,'/mobile/slides/','5tfyOAwkrTl.js',NULL,17580,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1029,'15026764e0bf2e9460c619e7c7f4357a1e306b4b','e914b3ab777df4fd4194a38477ffe7a170adfb30',30,'mod_scorm','content',0,'/story_content/slides/','5bkSQkJcxNP.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1030,'4e21d7c5d5d08ca8794ae9a14dd2f2f3fbefa640','dfa7bc96360eec52cff5e004f86ec5488b53e001',30,'mod_scorm','content',0,'/story_content/slides/','5bUza0q4mpK.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1031,'32d57548f6e3716b7bacd23ad6c7926cd3e33474','b458076579d3acccd1d54c2855566ee042537b61',30,'mod_scorm','content',0,'/mobile/slides/','5bkSQkJcxNP.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1032,'a86c156a943f9673bfa774b77ba323bafb1c5146','4054d3950fac86b5e74566a4304a3a7fba0bbb8e',30,'mod_scorm','content',0,'/story_content/slides/','6nnXvcCsR6r.swf',NULL,3847,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1033,'07452ae720f53905406b5f4f29f0bfd92778ce9b','3e4f362fa386322768e54c8fc02c5c7dd47f4b8c',30,'mod_scorm','content',0,'/mobile/slides/','5bUza0q4mpK.gz',NULL,3557,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1034,'914f0b2d60538ca52a0946fe2fa4eb23847cfe49','7da72fd7ee677a7e6973fab413db3cb54e698fc4',30,'mod_scorm','content',0,'/mobile/slides/','6nnXvcCsR6r.gz',NULL,3554,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1035,'82f9148d7c4cbefcecb8003c477c11a8af68357a','299250a72dacf823465a2fed93c40d09913ccae4',30,'mod_scorm','content',0,'/story_content/slides/','5kxH6iXENbJ.swf',NULL,3846,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1036,'3626f6e296f6792886b4729056d3d3c0b7172d50','13a93bca65b84b82c345e1101aca76415e82fa6f',30,'mod_scorm','content',0,'/mobile/slides/','5kxH6iXENbJ.gz',NULL,3552,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1037,'3fa3134446d2704448fadd2ed3ab5a746cb5991e','e1ce8d206004ba6a43e0dace397511a6f9e5a19e',30,'mod_scorm','content',0,'/story_content/slides/','6EqQKCK03SC.swf',NULL,3846,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1038,'bdf639b5773d72b8bddf3c1be662cff55cfaea77','31ec2d27c278f44d42a3769ca5922902c8c190dd',30,'mod_scorm','content',0,'/story_content/slides/','6IWpQEAED4w.swf',NULL,3874,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1039,'a543070c045ab517be4c16121cf62815c77b3566','216967f0d92aa765e4f5020977d46821b44cdba9',30,'mod_scorm','content',0,'/mobile/slides/','6IWpQEAED4w.gz',NULL,3579,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1040,'48f292b10c45862c87621becbc2301adddd5719d','4709a84c80d7b154d310a4a124c27f3690465de9',30,'mod_scorm','content',0,'/mobile/slides/','5yxeEmEcXk7.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1041,'2cf3fbee28916d9a30e19c956c2503b4483a225b','5176d509bbdc66851600c25e3de5ba1af98d2424',30,'mod_scorm','content',0,'/story_content/slides/','5ws3t2eayFj.swf',NULL,3841,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1042,'8dd3e9925df27ba07ad8350667dd20ed8f9e7e59','ad255f5c767d36ccc5d3f241d8bbefa55475ef1e',30,'mod_scorm','content',0,'/mobile/slides/','5bkSQkJcxNP.js',NULL,17561,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1043,'94d0a83d4834ac6e54d2320409f470aeec11ef97','aa53ef3c1b3b909b1031c552a409bbfdb65a2224',30,'mod_scorm','content',0,'/mobile/slides/','5ws3t2eayFj.gz',NULL,3547,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1044,'5c5c29ff7472d7901633656a7de7bca795d555b6','a3e3c5e51e88a2d1fceb3b1430da35df4e4a5050',30,'mod_scorm','content',0,'/mobile/slides/','6EqQKCK03SC.gz',NULL,3553,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1045,'3040642ab976018a0a3cab66a3ef9ac751b6eafe','791f908e38dc4d0f63524e3047d62f2b68c93587',30,'mod_scorm','content',0,'/mobile/slides/','5YhAkwMVWPf.js',NULL,17583,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1046,'74996f9ccc743396db0af47f6fdee232e1cb4c2d','4b12459e5c4d95f338f7a787e39c409a5f58fb3f',30,'mod_scorm','content',0,'/story_content/slides/','5qpo2E50x4O.swf',NULL,3836,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1047,'b965efd2ad4ae90a3d412fba92766bb74f0b5f25','56099c3cf4000e447e8d33fad0389243130bbde7',30,'mod_scorm','content',0,'/mobile/slides/','5qpo2E50x4O.gz',NULL,3542,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1048,'2991d3867be51b0d09066959f35455d2a0c7e49d','29905e920ee51aebe87a8a7a4b38e14bc21b0e2a',30,'mod_scorm','content',0,'/mobile/slides/','6nnXvcCsR6r.js',NULL,17565,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1049,'bd08e036121e0919879bf4e58cb18f1df6ff1d78','ca17a9d803cf4ef80b2a11b1d3f9d31b7fa61bf8',30,'mod_scorm','content',0,'/story_content/slides/','5W3Aba8Ckqz.swf',NULL,3852,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1050,'25383563461f3dbc8593a966067b7248de93568b','9a23c595b6984e286cf6501e101ba72d447ebfcc',30,'mod_scorm','content',0,'/mobile/slides/','5kxH6iXENbJ.js',NULL,17564,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1051,'cb31e96419b250b6a7f2a7649eff6300fdc8ce07','db80561dce8fb53c2dc59b6b4f52f2466a8ce38b',30,'mod_scorm','content',0,'/mobile/slides/','6Kl1FUDZoy1.js',NULL,17553,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1052,'8cefa2e402bfbfc8822f00e5416509af9f905b49','025d5f96aca2771ffb0f9c44a5a2208fa6156c23',30,'mod_scorm','content',0,'/story_content/slides/','5ahMOlS8sQw.swf',NULL,3851,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1053,'4f837622f59272917cc8cd81428929f5c37d11ad','af3edd1f6def5fa14c354c003e53e121268a35b6',30,'mod_scorm','content',0,'/mobile/slides/','5W3Aba8Ckqz.gz',NULL,3560,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1054,'f4b706604ecf616cb3a0d17bcab43ca4c1653fca','e27ebf0b86b9ebb5b297e7dfdd7153e0546cc5e8',30,'mod_scorm','content',0,'/mobile/slides/','5ahMOlS8sQw.gz',NULL,3557,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1055,'60edc3947d5b41715b82005fbdb89ab7934b37f0','4638382086916909062b6ea93491d98a15dc8a70',30,'mod_scorm','content',0,'/mobile/slides/','6jqYfrzSSYy.js',NULL,17550,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1056,'97c658437beb22b02e2bd6d6a1a82520ee5f7115','e8563870632f4263e45a211c332fa74f4fb96020',30,'mod_scorm','content',0,'/mobile/slides/','5bUza0q4mpK.js',NULL,17570,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1057,'a8249cfbffa343fb61c7183588490cf4fd8c55fe','ab360130c098773a75e922d04ebc22e0ad04f103',30,'mod_scorm','content',0,'/mobile/slides/','5ahMOlS8sQw.js',NULL,17571,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1058,'f0a64f3dee7fb08857835ca5aca8a86b730507fb','f3bfeb5c6bbaf510b2c70f6a58d3455352c9dcbd',30,'mod_scorm','content',0,'/mobile/slides/','5W3Aba8Ckqz.js',NULL,17573,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1059,'07bd64216ceb13754d171398da1090b2c55687c4','e7ddaba1f461ab5fb5bdbe8e2aad7c1ed17699f7',30,'mod_scorm','content',0,'/mobile/slides/','5ws3t2eayFj.js',NULL,17564,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1060,'9c2f2f6f372bf6b527c60f411c507ed7069a37cf','b7a7696f53b404e3653ed40f79689bf718a25eab',30,'mod_scorm','content',0,'/mobile/slides/','6EqQKCK03SC.js',NULL,17562,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1061,'1c9da3976b136fbfc81cabaf4eacd2cb20353c10','f9ab8297d88ae7dee64d3cf743b52cd51b16b7e0',30,'mod_scorm','content',0,'/mobile/slides/','6IWpQEAED4w.js',NULL,17600,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1062,'c9ea0bd28998d6850b878bf65d8ee0921e7fa9a0','0bbe87ab1d46440f130e16b7b9bb5d2a39907249',30,'mod_scorm','content',0,'/mobile/slides/','5qpo2E50x4O.js',NULL,17551,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1063,'aebaa1ec9ce4f42082387e44dc76f534c1d2a5de','3465a44f04b3dfa90f96083ea0fc1fbf2df9afc2',30,'mod_scorm','content',0,'/story_content/slides/','66DdNbRVAwe.swf',NULL,3839,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1064,'91ad6408c76f86ca3539e91b342669105b22cba1','caaf6aa7e63102e0665f0d84277f9b22a827e9f4',30,'mod_scorm','content',0,'/story_content/slides/','5u3XrInAoVN.swf',NULL,3849,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1065,'da6983d87622c372a7927ca8a0c5a5335c2bc1bd','b3f0f4e932260842a7b6b0d9a3bad8b7ef6dc57d',30,'mod_scorm','content',0,'/story_content/slides/','5uRobkQ2TmV.swf',NULL,3846,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1066,'51b9737f7dd64156a55bf628d782b3c6bbe04725','47c1e355ec81e2020887de9c0cbf69447748a24a',30,'mod_scorm','content',0,'/story_content/slides/','62JVKR96Va5.swf',NULL,3860,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1067,'57798553254d4cc9819878f8a091a3894d82afb9','f30968d2d2b0af2119de21009bddf49f9f9fb86a',30,'mod_scorm','content',0,'/mobile/slides/','5uRobkQ2TmV.gz',NULL,3551,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1068,'90a0d47d96c5905f6777296b28172188e6299065','0b10643fc904f5115e5a21379a3cde81608d15ab',30,'mod_scorm','content',0,'/story_content/slides/','5pZtmtYHazI.swf',NULL,3847,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1069,'820b80620810ff95f014ae0c5cbd3e34ab61646e','7e1ddb18119250d0d6088fe092cfbc66bd913bb5',30,'mod_scorm','content',0,'/story_content/slides/','6N5B8q6d0D4.swf',NULL,3842,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1070,'a3dcc3bc665ff9bf15083a7294da0825331ba356','e57ec1ddf4e7628f8ccdffe2c15523740a2d2d46',30,'mod_scorm','content',0,'/mobile/slides/','6N5B8q6d0D4.gz',NULL,3547,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1071,'beda49dc69bfbace104f7d671430fdd28158c0f2','6561494e72bc3cb5ca693aed538bd4347a651f8a',30,'mod_scorm','content',0,'/story_content/slides/','5jaj9Gi7HWf.swf',NULL,3847,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1072,'2aa5aad45cd9413d40e82656166ec77f4643908e','2d3a975156caecabf46202a0dc285bc8a41e9787',30,'mod_scorm','content',0,'/story_content/slides/','5fbSRJEyPrK.swf',NULL,3852,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1073,'c150d60118a482dfbf5c99b8377799db34f61b50','6f395c36c33bcf738ddff0c149ad59259cb9b3c0',30,'mod_scorm','content',0,'/mobile/slides/','5u3XrInAoVN.gz',NULL,3555,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1074,'617fe993c4bc940ea5c681748a373205a20b004e','936fea4b248fe2a7861ab5a98371ff0024aebbb4',30,'mod_scorm','content',0,'/story_content/slides/','6BT0E2nxRBC.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1075,'d3460cc69367ac93301679fe3dcee5a9ba8d11e0','a3436dfdca17929cf96544f12a945f20b1fb6ca4',30,'mod_scorm','content',0,'/mobile/slides/','5fbSRJEyPrK.gz',NULL,3559,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1076,'194415b74adca6dd020c57faf6c2b57bd118127d','d743f37c1192352ffea66802cb5d20cc2d7bf2e4',30,'mod_scorm','content',0,'/mobile/slides/','66DdNbRVAwe.gz',NULL,3546,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1077,'3b61120e869f4a964e1da6e67b394e4b5358e4c0','d10d672895d7ec830747d8fea43fc395963aedee',30,'mod_scorm','content',0,'/mobile/slides/','6BT0E2nxRBC.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1078,'b07cd4bbb96b8374a9c33c1324be62e03a9b93ca','30c3cee60f2184ca2ddcc4b768d18030b3390751',30,'mod_scorm','content',0,'/mobile/slides/','5pZtmtYHazI.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1079,'e8fb355b99a0dcd635fd597cfead5518eeb4abfc','a891cb28a372bd17523e1f438a50c514d13aa80f',30,'mod_scorm','content',0,'/story_content/slides/','6kEA7dl418p.swf',NULL,3852,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1080,'8d5374bcb7357bc25ffa4e110db6a67578f9363d','e18570943a42ec27c6506bc7d6060f57160e9093',30,'mod_scorm','content',0,'/mobile/slides/','5jaj9Gi7HWf.gz',NULL,3553,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1081,'5bd694e5876f34978dd390c458f5654248260204','f124eb853cf8b5cce3e1bc54094e47dbd376e8bb',30,'mod_scorm','content',0,'/story_content/slides/','5ixIWqbp5mh.swf',NULL,3855,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1082,'e88b36b7503a04c6f9c8565a7f58f73eadf27163','618d69a110696ac1e5e667c0565f93ce2cfd1898',30,'mod_scorm','content',0,'/mobile/slides/','62JVKR96Va5.gz',NULL,3570,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1083,'661696c243c5d80566b6373861607e79bd8587a8','9e377a6cd1aacb87ea3e85a504126dfc585ab80c',30,'mod_scorm','content',0,'/mobile/slides/','5ixIWqbp5mh.gz',NULL,3561,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1084,'a642dc48a2db495e241aca6c813bc91549901d2f','8897083e8ec1e13e4a85af8c3f6ec1448e4fe27f',30,'mod_scorm','content',0,'/story_content/slides/','5k017lTZMh7.swf',NULL,3853,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1085,'11497dfd16d7c088a0b5890343c4a686b40a472d','55f5735b58453ea3f18fd9affdae2bf4b6ecf2ad',30,'mod_scorm','content',0,'/mobile/slides/','6kEA7dl418p.gz',NULL,3558,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1086,'a5eeacc9df11b1d308a2811c73f76af7b42be4fb','beae395d9bbdcc29672a10fb5b490af35b748488',30,'mod_scorm','content',0,'/mobile/slides/','5k017lTZMh7.gz',NULL,3559,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1087,'b34f13240e6b6c1b3be431c4d7ac5a95d67bbe34','60874194e7149e8748b6a41d9a10984d1ffad084',30,'mod_scorm','content',0,'/mobile/slides/','6BT0E2nxRBC.js',NULL,17569,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1088,'ab016624192154673866bd0a1fc97380f9d648c2','0c287294ad7a754ddb03a3940d662278109a76c9',30,'mod_scorm','content',0,'/story_content/slides/','6Hoaa3otO0c.swf',NULL,3849,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1089,'075e761354a5443ff2ce9f25631d6f4ae01b5b13','216b7b5975717c750affbde28782378eaad93726',30,'mod_scorm','content',0,'/mobile/slides/','5uRobkQ2TmV.js',NULL,17561,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1090,'a11968ae7a780d5168fa98300cfd8f926b8bd415','be6eacab4cdbb5c0655b2c67435ff83baf77e400',30,'mod_scorm','content',0,'/mobile/slides/','6Hoaa3otO0c.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1091,'dc8219ddd2112104ce098b1db6b9e8679dc8b59f','def613d0c9bb2f68026a5bab51bd186a5040f91a',30,'mod_scorm','content',0,'/story_content/slides/','5rVcg0J7ZWH.swf',NULL,3840,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1092,'c0aa80d2c5fa20b4d83d93365557fa896fdc16f1','b24556d6ec308bb536b9c6d88a4a29fd389e6b5c',30,'mod_scorm','content',0,'/mobile/slides/','5rVcg0J7ZWH.gz',NULL,3545,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1093,'fbdbf11b270b6ddac95565c847cab9bf2ea54ca4','5a0fee59030a2a728a5bc1913ebf3efb02770bc4',30,'mod_scorm','content',0,'/mobile/slides/','66DdNbRVAwe.js',NULL,17556,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1094,'9801284acdc854f70c1291c45a81efa1b43ee036','d6232a10c0b026349faa8a6cf08f017203defea8',30,'mod_scorm','content',0,'/mobile/slides/','6N5B8q6d0D4.js',NULL,17554,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1095,'125a964fbba2ecd68ae335fccdf17fa9d39ec4b5','17e0b8aec1bcabc4b71d1bf3a5faaf2cb1be67a8',30,'mod_scorm','content',0,'/mobile/slides/','5jaj9Gi7HWf.js',NULL,17563,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1096,'6f35076a7ddfa2095e879dcbbe270bb50a4a6170','86704d08599669ca35a039baf1a907a30d24a00e',30,'mod_scorm','content',0,'/story_content/slides/','6pGFlgo6Z0o.swf',NULL,3835,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1097,'b286663f0e0023c09f07b8029382c08b590de27c','93fb9d9c674cc3acbfb5e261b1680b6973083326',30,'mod_scorm','content',0,'/story_content/slides/','5xZ1sygPufs.swf',NULL,3847,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1098,'f3a4313350ebfdcd1426d6c1bb0973119e250d27','9eacf0269e7178d17f1ce52cf7b3d7bfb515e760',30,'mod_scorm','content',0,'/mobile/slides/','6pGFlgo6Z0o.gz',NULL,3543,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1099,'0d6e8aee1deb2363864f4b3d330fc20ee73492cf','41329bbe7edfca711791619fb27472acacfec643',30,'mod_scorm','content',0,'/mobile/slides/','5xZ1sygPufs.gz',NULL,3553,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1100,'5aa3b930131659e7e46e1573b6cfdc786c16ef75','cd9b9a21ebb6711d99b599b3997d0a8c7c858917',30,'mod_scorm','content',0,'/story_content/slides/','5d4w5obQmh7.swf',NULL,3838,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1101,'fde80e88cde16dbc9a5eb8d92aa993426fc4c268','2e4f41a2783f14d693f223506b53b607bf04fd50',30,'mod_scorm','content',0,'/mobile/slides/','5u3XrInAoVN.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1102,'f8227d49e827ddccfa791af7a593b4a6d11ae8be','26a4b27ad1ceb74cfd8d214c3cc1380f18421cc0',30,'mod_scorm','content',0,'/mobile/slides/','5d4w5obQmh7.gz',NULL,3545,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1103,'eb27c20f067f226a11038971286ea911ed896f56','0b4bbab76550cb1dfcc4ec3c097d60ab292f3714',30,'mod_scorm','content',0,'/mobile/slides/','5pZtmtYHazI.js',NULL,17582,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1104,'bb36aeef96775dfb7be0dc946e8d1d9386200dad','4333ef17b1a19ec085293e89ffd24fa6259a566b',30,'mod_scorm','content',0,'/story_content/slides/','6jYHjCjZKvb.swf',NULL,3863,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1105,'018f1fb75f41d87a652ba139d5ec5e3a1adea07a','80813f2bd937c1b72e515b51cde1bb331bc54820',30,'mod_scorm','content',0,'/mobile/slides/','6jYHjCjZKvb.gz',NULL,3573,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1106,'c1baba2caef63ebf1c6209e9a92d377504202345','406744628b36ee116399d37ca092aa0f6e4ceca0',30,'mod_scorm','content',0,'/story_content/slides/','6ote4NdTZQi.swf',NULL,3847,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1107,'2f13f9dca479b4d47aeca06321c2440fae08000c','8a74d94d1c43e9e6411f71730fa1124b72e42236',30,'mod_scorm','content',0,'/mobile/slides/','62JVKR96Va5.js',NULL,17586,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1108,'2d0ec8d65d7ee23758e30331224139183933579f','acf64e44ea6468b77a9682142ffca6cb19df29a5',30,'mod_scorm','content',0,'/mobile/slides/','6ote4NdTZQi.gz',NULL,3554,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1109,'1c2ead3b10d6b998ef37cb9bd0dfa70380e84b0b','41060bb4f60f15b01e211bf6837853d0c9855dbd',30,'mod_scorm','content',0,'/mobile/slides/','5ixIWqbp5mh.js',NULL,17582,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1110,'410577c67e88992b9b8809d8e00f6d61799220ed','ebee9303738a1c1da3d04a0777a5c41b74499c5c',30,'mod_scorm','content',0,'/mobile/slides/','5xZ1sygPufs.js',NULL,17568,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1111,'2b56aa10848ab05369afa4d6251a6030ae6e29a5','11178b6806636f1a90b7035683dcbb515f836931',30,'mod_scorm','content',0,'/story_content/slides/','5zzOZTMOsXw.swf',NULL,3837,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1112,'4d856c5b5981db34231432cef7e11efcf8a5ae7b','5ec2ae9ace2cbef838b7acaee2f30f69c04f9fc4',30,'mod_scorm','content',0,'/mobile/slides/','5zzOZTMOsXw.gz',NULL,3545,'application/g-zip',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1113,'6776ea0d6514d7b81e047dd572941829a7202233','2bd9ecefa49e8d59a7346a5829fc3ea6c995ab92',30,'mod_scorm','content',0,'/mobile/slides/','6Hoaa3otO0c.js',NULL,17569,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1114,'35f9049327118f5fc306e22a9338b605f60aac74','7c7b47dee4f0e627167b1736841684ac1ddd37fa',30,'mod_scorm','content',0,'/story_content/slides/','5ZJDepFlzMb.swf',NULL,3848,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1115,'8c1c5415f33ad5095b8ff96cca4af9cf8f717a70','a66e6d5db0d62ba8d3c69279ee324c176000dcf7',30,'mod_scorm','content',0,'/mobile/slides/','5fbSRJEyPrK.js',NULL,17570,'application/x-javascript',0,NULL,NULL,NULL,1462458061,1462458061,0,NULL),(1116,'8b87d3add72c7b0d81de4721d0bd9024053cb72a','dc90bddb1c7b28f3c2e48be0fedfb89f5aeb4b54',30,'mod_scorm','content',0,'/mobile/slides/','5ZJDepFlzMb.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1117,'372fbc782de31a40349e4436393edebe49e3a747','6516b45940dbf04ac06f9b7a14e3c7f0a9b93512',30,'mod_scorm','content',0,'/story_content/slides/','6AHckfsoPA3.swf',NULL,3860,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1118,'f8d08becccb9535f6c1c9ff10b9eeec928737415','f3bfbfd7011c3f79f5341f0d5086c4971739350e',30,'mod_scorm','content',0,'/mobile/slides/','6AHckfsoPA3.gz',NULL,3570,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1119,'69e8f4726be1c53c7b82bf81241df3ddae3e2778','67d736959e6bc5e46fb659bce1ce4d07b7c4a7a1',30,'mod_scorm','content',0,'/story_content/slides/','6NcX1vHR4TG.swf',NULL,3845,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1120,'32e8225df17fb8ab7b4550a1c2dc96dfce181dc9','39a2c9cb3a563c9cfb2243a7f5630a4780433d7d',30,'mod_scorm','content',0,'/mobile/slides/','6NcX1vHR4TG.gz',NULL,3552,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1121,'7571b7fd5cbe09c6d75e52ac5d88a14581a1cf29','2f25347090e5de6de9f2bdde1d08f0b856d5c253',30,'mod_scorm','content',0,'/mobile/slides/','5k017lTZMh7.js',NULL,17571,'application/x-javascript',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1122,'8d6b259568c15f0618cac2a531b06df56c6ef6ec','d43042b012ae41d211138b1b72448667342dc0fd',30,'mod_scorm','content',0,'/mobile/slides/','6pGFlgo6Z0o.js',NULL,17554,'application/x-javascript',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1123,'b6aa3066e3d200811ef0045a7e14f92c1a74981d','1a016660e9663476492b9426ccb54cda4f880af4',30,'mod_scorm','content',0,'/mobile/slides/','6ote4NdTZQi.js',NULL,17570,'application/x-javascript',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1124,'83f9d4cfdfd6f773ba65e6687e561eb48ff573d3','dcc58decd346963f3689effe052ff71ec6d33176',30,'mod_scorm','content',0,'/story_content/slides/','6gLK444yJWc.swf',NULL,3851,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1125,'8875d5ab215328cc7b928f20e472b2a25841b69e','68fb2d07153aa76d3ffc152394ff17c10d0b70bb',30,'mod_scorm','content',0,'/mobile/slides/','6gLK444yJWc.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1126,'3ccfc32e1b65010abcc76a5be8cdf66648d6ecc3','617f9b4e0faf53c8bb5677c849a30c7609f145d0',30,'mod_scorm','content',0,'/mobile/slides/','6kEA7dl418p.js',NULL,17570,'application/x-javascript',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1127,'773225bdbdbc47d0e1919c4a81a40cc86728d663','9ad52ac0cf8a2eb948f2e6f879e2d1fe79645a30',30,'mod_scorm','content',0,'/mobile/slides/','6jYHjCjZKvb.js',NULL,17593,'application/x-javascript',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1128,'f34dd67436ee847b01c9915fc1a0e30e7cc4d8aa','263eecdd65a4ba1c6732518743a2685aa83a178a',30,'mod_scorm','content',0,'/story_content/slides/','5ol7OfZrteu.swf',NULL,3845,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1129,'c44dbf7f5120cab7d57df4fb9ae07abf5ff9bb72','478a1d816189cff6e387e9cc2dfee3d07905384a',30,'mod_scorm','content',0,'/mobile/slides/','5ZJDepFlzMb.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1130,'f5e63de7112d319045fd4aa063d51c4ec8a2b809','426b65904dc084cb34f3e8e7a966a6a245ea5616',30,'mod_scorm','content',0,'/mobile/slides/','5ol7OfZrteu.gz',NULL,3550,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1131,'1608066dbcfc6baaf39c6d3716763bfbdb8fc048','cd6c37eaae4c364887cb885ec0631dfc09d2ea52',30,'mod_scorm','content',0,'/mobile/slides/','5d4w5obQmh7.js',NULL,17551,'application/x-javascript',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1132,'355fe19215cc910cefe6aedb9adc63093a74cc54','6932345903ec0e96589fedbea92737bc650f90e9',30,'mod_scorm','content',0,'/mobile/slides/','5zzOZTMOsXw.js',NULL,17551,'application/x-javascript',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1133,'9c4ced00b1d5bffd3918848d646c54891fb042c1','83704d0f30a40818853109ac840744b4c5aeff64',30,'mod_scorm','content',0,'/story_content/slides/','6lN6kJXHwMs.swf',NULL,3851,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1134,'1cd3021be9b1400e73ec2c589fd4118f7568c9e1','9186d23e65a52759179c382875e61349fb00cfcb',30,'mod_scorm','content',0,'/mobile/slides/','6lN6kJXHwMs.gz',NULL,3558,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1135,'92c0e6b60e3d4bcdc89d00849529ae44e69f6663','796570f36bfa61987d409db45fb8d08d3355d238',30,'mod_scorm','content',0,'/story_content/slides/','6PlSD2dHd2Z.swf',NULL,3841,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1136,'384f18fa46f2357b4fbcba2edd280159cffd30b4','f6a4edccd5ecf9c5b68e92a6856d4b011c96e132',30,'mod_scorm','content',0,'/mobile/slides/','6PlSD2dHd2Z.gz',NULL,3548,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1137,'e782a1beb26164a4327895ea9a3211d60d754d30','83cc9cd5e1f98059bd6682fe950c8af5bb83a62b',30,'mod_scorm','content',0,'/mobile/slides/','5rVcg0J7ZWH.js',NULL,17556,'application/x-javascript',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1138,'a46cbfcf90fa034d4f6bf6830e8c531cc3edede2','6baaf487c858962312825d005e5e33dbc54a739a',30,'mod_scorm','content',0,'/story_content/slides/','5sBRKgBZsnZ.swf',NULL,3842,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1139,'e20ceb69da90e4ba5cec3109cd7b13628edd1f55','9eac90e464cf699ebfc45e0e8946de83bc6774fa',30,'mod_scorm','content',0,'/story_content/slides/','5t8uQKBqgcQ.swf',NULL,3851,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1140,'2462e5cc2c7de9f522e6b99d8e0540099d19ab83','814484fe1a62b9c013734e906aab76aff9679267',30,'mod_scorm','content',0,'/mobile/slides/','5sBRKgBZsnZ.gz',NULL,3550,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1141,'273621ae5061dc528ff5380d760bf01f82207ad7','207f181d510fff295328dcb2bac87b7280c485c6',30,'mod_scorm','content',0,'/story_content/slides/','67k8dLey07Q.swf',NULL,3844,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1142,'ca56c8afef127976fd82cc811ba4739d4fece0b4','5b6974b02c342363467d275bf3e1fd3bdfbc6171',30,'mod_scorm','content',0,'/mobile/slides/','5t8uQKBqgcQ.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1143,'f86ddd16043d26f9672131ad8ace4eaa493e1ec0','c7c000d313923f14ce02297e771f719099ffd4bf',30,'mod_scorm','content',0,'/mobile/slides/','6gLK444yJWc.js',NULL,17577,'application/x-javascript',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1144,'90fb986697bb018a1f69c1641e9f994eefcb9507','62177a4c0c1aa53e4f5299f8cadf0e143f13e0d4',30,'mod_scorm','content',0,'/mobile/slides/','6AHckfsoPA3.js',NULL,17585,'application/x-javascript',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1145,'226147a97f0b92ae43446a5e2a3c1f8f6f14ed21','f25d34b67b9097b58c57c7872eb12eff524ac276',30,'mod_scorm','content',0,'/mobile/slides/','67k8dLey07Q.gz',NULL,3552,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1146,'51f22e5c3e25a3ac0606effc1be648c373914635','42bc15a613c6e406c657953ac074b1c69aa5a08c',30,'mod_scorm','content',0,'/mobile/slides/','6NcX1vHR4TG.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1147,'3507e1b15f4139e99498775445744476eaf69ee7','b0dd6f0e3b76f27b53288bfc03cff8ff989f3c7a',30,'mod_scorm','content',0,'/story_content/slides/','6TyFAbv6MGN.swf',NULL,3841,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1148,'8f46148595a204f5a6e48576d871bd5ab72fa795','44f74f2ff5672d218abfb76b81a322204f9fd3a9',30,'mod_scorm','content',0,'/mobile/slides/','6TyFAbv6MGN.gz',NULL,3549,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1149,'6a4f479da3b0b65d28305039f30f2ef587f26a9c','714fd7432d02701d609ea579dca99c3f5c6a692f',30,'mod_scorm','content',0,'/story_content/slides/','6oYwB8LIZGq.swf',NULL,3851,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1150,'3a6cfe2762412b6fb7328482eeb22b5c261e2c29','c264080d409dd5a0cf9618bf2d662b6624c351fd',30,'mod_scorm','content',0,'/mobile/slides/','5ol7OfZrteu.js',NULL,17567,'application/x-javascript',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1151,'ac1534b0c53d4027af0a916fd4b2f864f75642ce','a0081eed7dd784bd78ce495e851f03b9345acdb0',30,'mod_scorm','content',0,'/mobile/slides/','6oYwB8LIZGq.gz',NULL,3557,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1152,'93e264751458785096b1b717cb12175155992e00','bada0f37b603ffaca75bc3f7bad272bbc068501a',30,'mod_scorm','content',0,'/story_content/slides/','6XFma3MNK93.swf',NULL,3843,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1153,'5141e0c7d8f09195e854047f3ee606c385f3cfda','825743aa10c3f84b1db558a58a1f232cea277900',30,'mod_scorm','content',0,'/story_content/slides/','6SBwuC4DhMM.swf',NULL,3842,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1154,'f3252dfb58d393b379c0c66cf71558c7255f7a86','7075ef9f7bcc5597a3b0d246351f07cf242338aa',30,'mod_scorm','content',0,'/mobile/slides/','6XFma3MNK93.gz',NULL,3550,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1155,'866a25ce4427d8e8e73cb1f950943dbff03cabce','cbcbbc81006d64f681b5b0c31f944f7e49c0e121',30,'mod_scorm','content',0,'/mobile/slides/','6SBwuC4DhMM.gz',NULL,3551,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1156,'ee8f1621c539ca25e2625e63e07c32803694b8a3','5f54768c2c37a7cfde4a3a6561fb847d742a4cce',30,'mod_scorm','content',0,'/story_content/slides/','5jsJhFHCBbw.swf',NULL,3852,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1157,'2d10304c44aaf08babc7b2cbc5f393fde8b60d86','f3abd91f77c15634fe19e66d6ed0e046caccf5fa',30,'mod_scorm','content',0,'/mobile/slides/','5jsJhFHCBbw.gz',NULL,3559,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1158,'2e84d9ec1298197d3aa3b750e80cbdd4b05d8bc0','c5dd7e5c2a0665df9f198731b3c709b2fc4850a2',30,'mod_scorm','content',0,'/mobile/slides/','5sBRKgBZsnZ.js',NULL,17563,'application/x-javascript',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1159,'91e5e7b359eb81eb62e9beb793fe6e0e8b834dcb','c0eef91eb34c341b9f131933ec084695e5f2e2dd',30,'mod_scorm','content',0,'/story_content/slides/','6Fmll6lhSNG.swf',NULL,3876,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1160,'8a34e51aa3357dba21dcabc1cecd70d0398d4bb2','58e0b0dca285c5cbfa9075744e6141e586a28453',30,'mod_scorm','content',0,'/mobile/slides/','6Fmll6lhSNG.gz',NULL,3582,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1161,'26e0dbcc9fe0f39f31e2f731d5ba49204d39ff66','7e2e6584dcf1b890eba812a74ed7689bef76bd22',30,'mod_scorm','content',0,'/story_content/slides/','5ePrCFOdhas.swf',NULL,3841,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1162,'0e5060b751f5fb715313d744957ebbc8c1cc332e','360b017fe5541816678135196cdbe4c8710553fb',30,'mod_scorm','content',0,'/mobile/slides/','67k8dLey07Q.js',NULL,17556,'application/x-javascript',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1163,'535cc7df8970a10436657aba845db82c46b38e57','986f42018de738f7c5e33c5b62c89093be311f61',30,'mod_scorm','content',0,'/mobile/slides/','5ePrCFOdhas.gz',NULL,3548,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1164,'e38f588345c0e8e9ebbfc87d37e4f99dc34d67fc','8c1d633ffa456b071e1c363fe656aa0bde01f9f3',30,'mod_scorm','content',0,'/story_content/slides/','5sE2MJjEd4f.swf',NULL,3845,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1165,'49be01c469ce1ce5a7a2e4cff3e3a712e87ba354','a7b20f5fefddc6aa49f14e85c0c26cc11822aaa3',30,'mod_scorm','content',0,'/mobile/slides/','6XFma3MNK93.js',NULL,17557,'application/x-javascript',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1166,'adeab90645e7f4c2464d94b44ece006b46c7f167','17f3906ad86965dd8022db9b39347d3f4087054c',30,'mod_scorm','content',0,'/mobile/slides/','5sE2MJjEd4f.gz',NULL,3552,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1167,'1924274643d16ab93e4430086967901d6c390f17','74ec76455e13b6f1def90e595546288d2c81cf7c',30,'mod_scorm','content',0,'/mobile/slides/','6PlSD2dHd2Z.js',NULL,17560,'application/x-javascript',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1168,'83b88338be66e420a5add00aab7f40edaea331dc','af9ee8a0d8d9fe10058d99fa17d99eeb9fca9ecb',30,'mod_scorm','content',0,'/story_content/slides/','5vOzFnp8niG.swf',NULL,3844,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1169,'815d5f1048ab55f93df0c7c7f29f07ba2ff674d2','84c6aa31654cd77fb914d8c96c6b4d63a0c94f58',30,'mod_scorm','content',0,'/mobile/slides/','5vOzFnp8niG.gz',NULL,3551,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1170,'6352a910d15eaa7bfd4ec164eaa6f4c8c4ca6de3','6c6aa0a282455795c6ca950145194b0e134742ba',30,'mod_scorm','content',0,'/mobile/slides/','6TyFAbv6MGN.js',NULL,17557,'application/x-javascript',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1171,'1134b1557566e08dbd44b0727fa82b56bf33baab','b2018904090b8a07f0fe4278d84340dd7dd773a2',30,'mod_scorm','content',0,'/mobile/slides/','5jsJhFHCBbw.js',NULL,17585,'application/x-javascript',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1172,'bb6b5da7bf5023a06646c3cd0d2d9d4a5584a6e0','5a07c998a949d8bed062dc67e3d3d155a27eeeab',30,'mod_scorm','content',0,'/story_content/slides/','5rIqG9OEVsO.swf',NULL,3834,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1173,'4025fa11eeccba2420e75ad2b5b308f250361857','1da678cbf086aca507db90428822c75c094d546e',30,'mod_scorm','content',0,'/mobile/slides/','5rIqG9OEVsO.gz',NULL,3542,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1174,'0543493ed9a3b856ec454a4d60f684c09b9c9086','7bf9a505af4364375180dcd77ccc8b4be5ff6676',30,'mod_scorm','content',0,'/mobile/slides/','5t8uQKBqgcQ.js',NULL,17567,'application/x-javascript',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1175,'770a167030338a1f8d1d5ac5e1d4ef2a4a8744f6','c4ec184d86102137540f2909f49fbbee69f1b132',30,'mod_scorm','content',0,'/mobile/slides/','6SBwuC4DhMM.js',NULL,17551,'application/x-javascript',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1176,'76171c0a34521e7fba1095bc8ee249f091255c1d','68da06d9c34751591ae247b2870fdd46af64ce67',30,'mod_scorm','content',0,'/mobile/slides/','5sE2MJjEd4f.js',NULL,17563,'application/x-javascript',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1177,'19723e20f7a2332c8daa3513ae4847fde0853382','19c6275364fc3d89d64068a2a06fc5927200c3c4',30,'mod_scorm','content',0,'/story_content/slides/','5belqhmkXwT.swf',NULL,3849,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1178,'916efdf2f97db29a86436b41fa82146560e12d8f','102816e58ffd3ad7a7ccd6a283d43cdfe2094bff',30,'mod_scorm','content',0,'/mobile/slides/','5belqhmkXwT.gz',NULL,3555,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1179,'812a9265895323a9bb3f56708497666a75b420f5','1e1bec5a1f25549df916a24440368494101b4c7b',30,'mod_scorm','content',0,'/story_content/slides/','5egV3EcV3Qs.swf',NULL,3834,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1180,'843f7d31b899c01a49b3e2103c7f1e80db680830','88d49dc0323d4ab8ec98e2b03e9f878b1147733f',30,'mod_scorm','content',0,'/mobile/slides/','5egV3EcV3Qs.gz',NULL,3543,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1181,'226d8971271bb89ef4d1740cf18fb67c432dcfae','bd042862ac5cb0b39634bc28e1e88b8250e64f68',30,'mod_scorm','content',0,'/mobile/slides/','6lN6kJXHwMs.js',NULL,17571,'application/x-javascript',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1182,'3cf32145f887ba892ee3562debf2a65934aae725','624175e3de62ad070be1b81e4f09b6bee53feb4e',30,'mod_scorm','content',0,'/story_content/slides/','6lNjLJKKEj8.swf',NULL,3845,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1183,'0fd5139018f8136ab034cfdf571b2c23f42c3afd','d98766d9a3b2327d51159bef737e58af96c0de7c',30,'mod_scorm','content',0,'/mobile/slides/','6lNjLJKKEj8.gz',NULL,3551,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1184,'cc83d4bc883ecb203b340919982ae73329dca5de','a911b85b4105da6e8c0e3021288ab9a7b4c8dfe0',30,'mod_scorm','content',0,'/story_content/slides/','5WHjln2XqBl.swf',NULL,3849,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1185,'8bec3bbbea1fe66f8497ec3659b9ee4599664ed3','e7c1d012fdc83b6e565ea4cfa506798baf837870',30,'mod_scorm','content',0,'/story_content/slides/','6V1a0eqMrJf.swf',NULL,3856,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1186,'c4d2e1ec6194a3278682573ff2d0aeca5f9432ee','8ddc02cb9c6c6e820a70df0d62527b7fdfbccf28',30,'mod_scorm','content',0,'/mobile/slides/','5WHjln2XqBl.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1187,'b5c4eb3c24f9fd3878d1c22ac7329a8cc80e38ed','ac090560ab5845c78063f38575ff964666524344',30,'mod_scorm','content',0,'/mobile/slides/','6V1a0eqMrJf.gz',NULL,3561,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1188,'10427f357a8f3ca69898b18e98dfec1255b23684','4afc86edc1b707e89aff8166e0c1c7a3a0035a71',30,'mod_scorm','content',0,'/mobile/slides/','6oYwB8LIZGq.js',NULL,17560,'application/x-javascript',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1189,'dc9cf054027416eb141739f12e1aa3438ef01e86','e40ef175e9f4d07e8fdb6f05e642e1d0b66275db',30,'mod_scorm','content',0,'/story_content/slides/','6nayRCLvESG.swf',NULL,3857,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1190,'1b2853dcb6645cac3c93b4649bf43ac032774bdd','d16a3a3c760f64fd92db1c29abe0b5100124c0a2',30,'mod_scorm','content',0,'/mobile/slides/','6nayRCLvESG.gz',NULL,3563,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1191,'2d3f8cd73a637f8390e548c8c9f53e04590a8873','c9e1b318f849573d90bcc56fd3ad670cd8dfe707',30,'mod_scorm','content',0,'/story_content/slides/','6jQMeEBSq3L.swf',NULL,3843,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1192,'5590dadfc550d2d47c29b79bc8fa8051f6d15515','cddf7c8c35f7512def34bbd1cf577bd10d765d1f',30,'mod_scorm','content',0,'/mobile/slides/','6jQMeEBSq3L.gz',NULL,3549,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1193,'4ffd7d2c8bdbb9bd045d002f22a39f32dd9e21bc','c3be7910ec7026953fa292935ac0d3649d1f5348',30,'mod_scorm','content',0,'/mobile/slides/','5ePrCFOdhas.js',NULL,17556,'application/x-javascript',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1194,'9fa317cbd03f526e4df9007f299222ac478aa190','2f272e985913c20875d44d5b1748b61884849986',30,'mod_scorm','content',0,'/mobile/slides/','6Fmll6lhSNG.js',NULL,17610,'application/x-javascript',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1195,'7101baebc45394ede4eee47e5377649a85f9d0de','728aba51609dc2a6bfa0487d29e4196d8a13278a',30,'mod_scorm','content',0,'/mobile/slides/','5vOzFnp8niG.js',NULL,17559,'application/x-javascript',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1196,'cbe1d573ebc616455e8ef3bf223e3b8e41007a42','4514788ea36b4cb00a0c6207bbd34deb244fb13b',30,'mod_scorm','content',0,'/story_content/slides/','6loZ9bq24kc.swf',NULL,3851,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1197,'12bca08ebb2a0eeaef83b7a3232048e69f79afbd','13f93df91b16ff4dcba8bb454f89aa1b09a8c29c',30,'mod_scorm','content',0,'/mobile/slides/','6loZ9bq24kc.gz',NULL,3557,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1198,'3c9f403db36f5063722121cb55114d94437cafdb','6824f35c9f62eef898d1eca6414ba4ec69d88088',30,'mod_scorm','content',0,'/mobile/slides/','5belqhmkXwT.js',NULL,17560,'application/x-javascript',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1199,'ba319fdc05fb892ba11608b1545f87871ba94f6d','64517007257e9918c5b1b3a3b52aecb85560505b',30,'mod_scorm','content',0,'/story_content/slides/','5jfCInXjoCJ.swf',NULL,3849,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1200,'257b87ddd9ea1b3f748c16becb5ec7c0c9903826','d18373df9d30fd9199d673dc321575aa659441e1',30,'mod_scorm','content',0,'/mobile/slides/','5jfCInXjoCJ.gz',NULL,3555,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1201,'be726d5466bf92e65e65deff44250855d93fd083','519604fb091f23c95b62f3335c9474154f0f6c7d',30,'mod_scorm','content',0,'/story_content/slides/','6rSYX8oWCKS.swf',NULL,3852,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1202,'4d37a85a40f430da4c390c102567d902fe2336ca','ea85a848620ad74b25feda65ffc4af5c08833033',30,'mod_scorm','content',0,'/mobile/slides/','6rSYX8oWCKS.gz',NULL,3559,'application/g-zip',0,NULL,NULL,NULL,1462458062,1462458062,0,NULL),(1203,'7031fe096f263e472683ae6f7f0ac675ea63eda0','e660a4975805a30e160cfb87982eef2891ed580a',30,'mod_scorm','content',0,'/story_content/slides/','5W2nYgCN921.swf',NULL,3843,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1204,'9898a829c08d674d345839f16b45e53653c7621e','21fe7169925bcac44079bcbbeb73bff5583fd85a',30,'mod_scorm','content',0,'/mobile/slides/','5W2nYgCN921.gz',NULL,3551,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1205,'425c75b33ac78ab7014531b957fc9c6c873bec70','c04d3de1d3fe6d5244b84416e92dfd93bbe65821',30,'mod_scorm','content',0,'/mobile/slides/','5rIqG9OEVsO.js',NULL,17552,'application/x-javascript',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1206,'a912b79e3b26c9b4729cca0b9f7a76fe9cf69997','00acdc5619555a7b0fbd036ee826063aabe683f0',30,'mod_scorm','content',0,'/mobile/slides/','5egV3EcV3Qs.js',NULL,17551,'application/x-javascript',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1207,'f4de07503aa397f32a0cd687799e5e6bd8c10cf9','9d04fa36b0b0e26761eab3d8fcd9800b3e85e9c5',30,'mod_scorm','content',0,'/story_content/slides/','6omuoVnTgIb.swf',NULL,3861,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1208,'3d85894f1475575c497184b3848ef6c6b0737f81','ebac201dbde289f5bd3e4b4d2d8465de053b2265',30,'mod_scorm','content',0,'/mobile/slides/','6lNjLJKKEj8.js',NULL,17557,'application/x-javascript',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1209,'74d6e0be104ea46e00bcb65e5e68c723acb5ef60','de2a1d5dc82d537faea68329b3032b600fd3ec5d',30,'mod_scorm','content',0,'/story_content/slides/','5a5cUhINkqb.swf',NULL,3851,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1210,'f7a8bcd338561971ac2719a1fc5b760fbf271812','9965bebef856e06d49076c6331db5aa7a70b7f4c',30,'mod_scorm','content',0,'/mobile/slides/','5WHjln2XqBl.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1211,'57590df3ae4f7f97f8ecd1c9b2d8be508c608d82','266bbc3851f54e34d31de49795758b3e664751ff',30,'mod_scorm','content',0,'/mobile/slides/','6omuoVnTgIb.gz',NULL,3569,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1212,'53be55e753f6c508a823cd4e8d8d30e5f28551a7','e17d8c9f346bcda2539f74ca114a13e87625a95e',30,'mod_scorm','content',0,'/mobile/slides/','5a5cUhINkqb.gz',NULL,3560,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1213,'210864e628529e2b85ac1690f864797294f431cf','81f40a0608fd9eef832b4c5b2792529d1850d0f7',30,'mod_scorm','content',0,'/mobile/slides/','6nayRCLvESG.js',NULL,17577,'application/x-javascript',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1214,'d71e92e7a570544e9a0b3fce146e5905e61a79a9','44df1b8dd42280a6b7fb708c367bea1351d743f7',30,'mod_scorm','content',0,'/story_content/slides/','67kckqhWlNJ.swf',NULL,3833,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1215,'ece9cadb8a6b2629449fc95a08d10cb4ff6e0457','1c10cdd3db4296e0e3f85f1f3deb1286665a8bf1',30,'mod_scorm','content',0,'/mobile/slides/','67kckqhWlNJ.gz',NULL,3542,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1216,'f002fc7f0ac50fc12b719d10605d3224e46cbe3d','955fd972bc0d1f560f77e2d78cebe97166aa2fa9',30,'mod_scorm','content',0,'/mobile/slides/','6V1a0eqMrJf.js',NULL,17572,'application/x-javascript',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1217,'de56d6b30694801fee423853943fbbaffa0bfa85','22e2978bfa2744b50cf97c5b5566a0b3ac7448ea',30,'mod_scorm','content',0,'/story_content/slides/','6UTpyJ5ekrI.swf',NULL,3861,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1218,'79569f344098265d0e7f51a00c1a341045637baa','08c4a13e755d3629a2b56c3b87a16a7d1ba48c33',30,'mod_scorm','content',0,'/story_content/slides/','6R1Fpz84Q0w.swf',NULL,3852,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1219,'42e98da9567b31a60219cd02957e850f6f31102f','3841a7685ebe5aa7c77cf6b27e2abce9f4d523ce',30,'mod_scorm','content',0,'/mobile/slides/','6UTpyJ5ekrI.gz',NULL,3568,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1220,'733cf28785287ac1cf25fffd1e0c00e95e789c69','b8e0718b3bcd7940447faa3d933cde4fe799825a',30,'mod_scorm','content',0,'/mobile/slides/','6R1Fpz84Q0w.gz',NULL,3559,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1221,'7d77b435ebca17e4177e4bc8d2b14b41b8dbc261','abf520163f76d539cdd94b884b3505991079bfa8',30,'mod_scorm','content',0,'/story_content/slides/','6CSdBBF5SFK.swf',NULL,3849,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1222,'a17eb7fe49ab71f6e31f4475809cc34a1eb32757','a7f62979ec9852cedaa4f4d7a41de7b3c632614b',30,'mod_scorm','content',0,'/mobile/slides/','6loZ9bq24kc.js',NULL,17581,'application/x-javascript',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1223,'0c3f88ce82882cd7336de4375089a768555b99aa','3389ec5968d3df23aa8382cf36032acc0d3d6bea',30,'mod_scorm','content',0,'/mobile/slides/','6CSdBBF5SFK.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1224,'7ab204919bb68891eea01e36ac50c4d4df80c64a','5ced5c51381420e201baed451ac647e5d5333138',30,'mod_scorm','content',0,'/story_content/slides/','5ptgXULyc75.swf',NULL,3847,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1225,'f3534808c954c4f5dd636af75dd9bcbd8755ccbe','fc2dcf9a6631e68c15e277fd2d121d5f316424fd',30,'mod_scorm','content',0,'/mobile/slides/','5ptgXULyc75.gz',NULL,3554,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1226,'52c3e8c409b873a7543761ff2e9cab76c4538526','1096ce84f5804748895eba4a86a12b71546f099c',30,'mod_scorm','content',0,'/story_content/slides/','5r9KZxhgr8r.swf',NULL,3849,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1227,'f2d1d958c876bacc36eac11e0905eafc19a5f8cd','55f98b87b7ff29884c785b1552c6295b480e47db',30,'mod_scorm','content',0,'/mobile/slides/','5r9KZxhgr8r.gz',NULL,3555,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1228,'2aa8f4d38b63c0f12b068d3b495e6307f46b92c5','ce17ace2221ac0060cebb29d90f9c0a1707dc9b8',30,'mod_scorm','content',0,'/mobile/slides/','6jQMeEBSq3L.js',NULL,17555,'application/x-javascript',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1229,'19b815e63c91d4c001080d5c3bb255e60ed30481','a06951ac455dc4d0fc0710bba195d1e41f55a87c',30,'mod_scorm','content',0,'/story_content/slides/','6iRF1KpUiDt.swf',NULL,3853,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1230,'cd37f0d566899a25e51e3d248c7b3153a46fb442','477e399e6e51ffcfff60e02b620bf6d4c934e086',30,'mod_scorm','content',0,'/mobile/slides/','6iRF1KpUiDt.gz',NULL,3561,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1231,'a43a35ba4713cfe9fd9db40710f48a25567c7622','5902ac3c50b40c0c846748d42c0a0a2a26a53ee5',30,'mod_scorm','content',0,'/story_content/slides/','5pLJxdkfYji.swf',NULL,3845,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1232,'4bc14071b3b78f0afc6d0972622e8a938ffd54b9','10e938e8ed3df650c4842c6b669a40e7a43c4745',30,'mod_scorm','content',0,'/story_content/slides/','6F36jMGpbst.swf',NULL,3845,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1233,'55178d675ce591a3e413f8dc88b46f754b671cc6','10248b0711f9829dd81c9ce5586ac6230f4879f7',30,'mod_scorm','content',0,'/mobile/slides/','6R1Fpz84Q0w.js',NULL,17567,'application/x-javascript',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1234,'63d4acefd6f971a9c8ccfc537d06ef39815dec06','59f163d1b47f1e4a800f50b04ff9a9968545fe90',30,'mod_scorm','content',0,'/mobile/slides/','6iRF1KpUiDt.js',NULL,17579,'application/x-javascript',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1235,'09b97f7952b93373554a88d97bb13592f810f1ec','d506a8de4f2ef08e0a163ccb6987721fc2ecc508',30,'mod_scorm','content',0,'/mobile/slides/','5pLJxdkfYji.gz',NULL,3551,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1236,'8ccf4e34806ae0290ca69bbc468dba3e7405c74a','3b43aebc608389488af4ab3ec256ee086a6b9db3',30,'mod_scorm','content',0,'/mobile/slides/','5jfCInXjoCJ.js',NULL,17560,'application/x-javascript',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1237,'273023b2787a13aa39d99c76b967782fdde8f14f','4c1a03e4f24404d3e22a3031099609f66581438f',30,'mod_scorm','content',0,'/mobile/slides/','5a5cUhINkqb.js',NULL,17580,'application/x-javascript',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1238,'454ac72a40b5d611fbca139aaa1b9f55e43b9742','5fa7b25f7ff812247bf039c391c67cfdd3b8ba90',30,'mod_scorm','content',0,'/mobile/slides/','67kckqhWlNJ.js',NULL,17552,'application/x-javascript',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1239,'81632ef507e723adf3e5e4d10b68ab5ecfd10119','ebea2f47bef7d59e364a2c671d0b1e547270be1b',30,'mod_scorm','content',0,'/mobile/slides/','5W2nYgCN921.js',NULL,17556,'application/x-javascript',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1240,'f3254564222c3e20a879086915044165dd4239fc','3eb79da71d83237b7c661da837172a95154b0ffa',30,'mod_scorm','content',0,'/mobile/slides/','6CSdBBF5SFK.js',NULL,17555,'application/x-javascript',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1241,'65055aaf9aedc0080a8a98829211eb5655e13564','50f997e95f6db576705ded42f211ae60ed42aa7c',30,'mod_scorm','content',0,'/mobile/slides/','5ptgXULyc75.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1242,'e2bf83c1a24e9576af98bd825fdbd133d2db9d8d','aa6469b242a2da8f42a4125388b00ddbdb7e8857',30,'mod_scorm','content',0,'/mobile/slides/','6rSYX8oWCKS.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1243,'97bb926ea261de883858fc7fc5bef6eb74634556','55da8d1acf942dcc7d49bbf452b11d31535ef692',30,'mod_scorm','content',0,'/mobile/slides/','6F36jMGpbst.gz',NULL,3551,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1244,'2da2917e25674b4f9ff738e80a0df07e8f8073ed','f369327c590c7605cf26f518ab2f723386632378',30,'mod_scorm','content',0,'/mobile/slides/','6UTpyJ5ekrI.js',NULL,17581,'application/x-javascript',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1245,'8865334c656e09f88096face44e305ddc70f9546','a316b477631ec10e66197e704cff2f6c6d8e2bbe',30,'mod_scorm','content',0,'/mobile/slides/','5r9KZxhgr8r.js',NULL,17567,'application/x-javascript',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1246,'9fea4e865562e146ee0ba4acf44692929dbaa81f','af9198379b2f7ba049cf400b65aa82b27ea260bd',30,'mod_scorm','content',0,'/story_content/slides/','6ZGe3NkIaP5.swf',NULL,3842,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1247,'dc9565d0a77c97d61f0dd3dc43cb1c8131f185f4','59a3a3bb72d178aefaf2b0838e6b87bf44d69897',30,'mod_scorm','content',0,'/story_content/slides/','5W9GN2J2BSa.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1248,'9e72820ce04976cdd13aa92f32c669e1680e7f22','2d262772495cbf66369dc343fb590bd8b70dfadf',30,'mod_scorm','content',0,'/mobile/slides/','5pLJxdkfYji.js',NULL,17584,'application/x-javascript',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1249,'4b0535a7274fb1050dff728a1e860ddf019b3e0b','5d1d82540fb8a9fe997d0b35441ac4ec65165631',30,'mod_scorm','content',0,'/mobile/slides/','6ZGe3NkIaP5.gz',NULL,3549,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1250,'b3222cda361f831df6c13f029f30b129cb67b295','d0c01c4c16333c7e9048a45aa7cc95ba7608b31e',30,'mod_scorm','content',0,'/mobile/slides/','6F36jMGpbst.js',NULL,17559,'application/x-javascript',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1251,'eae8f10945dee3e609911c90f5775cce8a1bf2ac','6aac325d1c363d9077785611bf89584fa329ec9b',30,'mod_scorm','content',0,'/story_content/slides/','5ccVhSbmlTY.swf',NULL,3837,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1252,'e47c3199e278a5d73faf1d6738113bf6c2d56f53','408793b4a17cfd0ae6715f4c4b62414c48191a52',30,'mod_scorm','content',0,'/story_content/slides/','5ioSdUXG4gH.swf',NULL,3861,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1253,'21ed5b8d3d3f0be9b39500ad8d696e6337b61ef7','91f2768892ce99ff0d984d6c96e0827bc89555c6',30,'mod_scorm','content',0,'/mobile/slides/','5W9GN2J2BSa.gz',NULL,3559,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1254,'a575107ed9a4b934c81d151d00c69a2d9ad51a36','663b25d36493a428a63616b2a19f8c38c9aacd50',30,'mod_scorm','content',0,'/mobile/slides/','5ioSdUXG4gH.gz',NULL,3571,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1255,'2ccd9e5b77644c63f268f6e685d76d85d29b6651','8a477abdf824968a6b7746845d3ddc6c997ed395',30,'mod_scorm','content',0,'/story_content/slides/','5ansVlNKtXL.swf',NULL,3849,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1256,'ea15fd32ffafe02b7e7cc2629b61d07578ac015d','4616a7a2bd61c80b9e437156eeb52ac195f8c434',30,'mod_scorm','content',0,'/mobile/slides/','6omuoVnTgIb.js',NULL,17588,'application/x-javascript',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1257,'e87eb686e676a614c6b7686841e7bbcdb3fd6464','d54124e454ebe764bf25b2135db3c71c82e494df',30,'mod_scorm','content',0,'/story_content/slides/','5y0egc4HPjQ.swf',NULL,3852,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1258,'dba4973e07ca57b7b61e4d65bf51b80791105d63','8a4c7eefda045771827c9cebdd24f87c4e497631',30,'mod_scorm','content',0,'/story_content/slides/','6kGhRqCmjto.swf',NULL,3843,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1259,'63275bf129ed70a5c1698c8eb3743a674ec9ac39','a988cd62c7be4757af8800701df357a69bf17c23',30,'mod_scorm','content',0,'/story_content/slides/','5tj2HADL4LN.swf',NULL,3879,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1260,'03f4f74d9641ac693a4df06d6c9021d1377c92c1','c5410aec6bbbb3977d0f855eea3aaf60dad62d74',30,'mod_scorm','content',0,'/mobile/slides/','6kGhRqCmjto.gz',NULL,3550,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1261,'72b1d752144840fcb1f28f835fbc4e73ab1b4297','1ecc0508d2254a0f8b3bef2dc7f92d98bd937f1c',30,'mod_scorm','content',0,'/mobile/slides/','5tj2HADL4LN.gz',NULL,3587,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1262,'c2a9225feb980b41ca15c6f5569d01d6da4b155c','7405a2eeb836a5a152842d9983e7f175de0941a9',30,'mod_scorm','content',0,'/story_content/slides/','5k1PHrCqAlg.swf',NULL,3865,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1263,'551ffffffb6cf63aa31d12bd78d701ebf49aacea','4ec933acc70a135bed8509bfc9c0299a9c8a5b29',30,'mod_scorm','content',0,'/story_content/slides/','6T0ugOL2rvm.swf',NULL,3845,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1264,'6c761c774bec2067347b5c55ee549010aa34ee5f','45297f170f1275c1b14e20f651e00df2fd2e1235',30,'mod_scorm','content',0,'/mobile/slides/','5ansVlNKtXL.gz',NULL,3554,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1265,'dc76cb4c02afaaa3fdd95bcb64cf3ab97fed2be2','51adfb2f5a1cf170a42c1a0a8845faf76371f72c',30,'mod_scorm','content',0,'/mobile/slides/','6T0ugOL2rvm.gz',NULL,3553,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1266,'bee3daf9fd194b865dd40b24d840edfa11586dad','d607813e2a14207ac5cb9c8fa4da07a487f79a40',30,'mod_scorm','content',0,'/mobile/slides/','5k1PHrCqAlg.gz',NULL,3575,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1267,'9a77e8e98bd7e7636d5a5e7d7e6829d18c249af0','8978af6273f14d21518b05429019c88cee2329c7',30,'mod_scorm','content',0,'/mobile/slides/','5ccVhSbmlTY.gz',NULL,3545,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1268,'37055eb735be989143f8c9abf3fb427fc7b56112','58d13a7239a136e8b6eaf17f3a473addcdfc87ac',30,'mod_scorm','content',0,'/mobile/slides/','5y0egc4HPjQ.gz',NULL,3559,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1269,'40d4276121664d5ea899ec0e019ff79f71c1f794','e1bcab27ae974d528be1c957feb135c8d38b82f3',30,'mod_scorm','content',0,'/story_content/slides/','6ayRRlEtIln.swf',NULL,3846,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1270,'1ddf6db2be2a5d7e6e42a0fa341a05b046f2142d','40ed0e1903c4486f00bfd96a7a7af86d2aeff0d2',30,'mod_scorm','content',0,'/mobile/slides/','6ayRRlEtIln.gz',NULL,3552,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1271,'f562c32f1b5ca7979c85e439791e88f5a948700f','b7963ad47a22f9be2abb873010e16241cb2140dc',30,'mod_scorm','content',0,'/mobile/slides/','5ioSdUXG4gH.js',NULL,17594,'application/x-javascript',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1272,'f458ef253a7381cdd074cbf92773a9bf17ebffbd','ca1ac07344d4def59f4f42391a9429eb6aca8f16',30,'mod_scorm','content',0,'/mobile/slides/','6ZGe3NkIaP5.js',NULL,17555,'application/x-javascript',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1273,'c74916695a2f3075bcb850b4a2bacd40c4c05394','d80e59dcdecf7149fe7a189634c2230d232e19e3',30,'mod_scorm','content',0,'/mobile/slides/','6kGhRqCmjto.js',NULL,17558,'application/x-javascript',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1274,'3fa184c82bda4b10a20cf2efa92459bfd7dd5c84','9296fd41c5a6afb8cc5fa566416a07c8805f2393',30,'mod_scorm','content',0,'/story_content/slides/','65FrsQIFFy2.swf',NULL,3853,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1275,'c34bcce7b5313961b4c9bc9f80e328a0b984542b','938bcf04be7264a832e3ae1442ea249c1f5890cd',30,'mod_scorm','content',0,'/story_content/slides/','6rTnxXnvJ81.swf',NULL,3844,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1276,'21c2463f0dccb748193370c1e843cec9f63141e7','0ccf96f7e6fce0fcb5cb63bb9fbd8bd78353c433',30,'mod_scorm','content',0,'/mobile/slides/','65FrsQIFFy2.gz',NULL,3562,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1277,'f9f81ee874a0c542fa37f770f9fb38c0953584bc','2c2138f25a270e5e66928633efa60ac226e68d8e',30,'mod_scorm','content',0,'/mobile/slides/','6rTnxXnvJ81.gz',NULL,3552,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1278,'77eb7af8d5e7612b739785acbef0a5b222a93c9c','63052a16a27000365f0c11abc7550b63e5481a78',30,'mod_scorm','content',0,'/story_content/slides/','5gysLNLELk2.swf',NULL,3855,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1279,'b7b9d8fea503703f3e3b8446043799fd322308f7','104714c46157b7a55ce26296880e55538aba614b',30,'mod_scorm','content',0,'/mobile/slides/','5gysLNLELk2.gz',NULL,3566,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1280,'3a621df1e407b96c14017d66e99392571ea56d27','9c9ccd3a80a0f806e4ecaa5cadb71db134f5278a',30,'mod_scorm','content',0,'/story_content/slides/','5wpnG6B1FpH.swf',NULL,3847,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1281,'85a0ade4e8abf3cf403cd0ad34613c9b4c0c75ad','c21b459bdfc0b0e545a90fd4b5bf0edc82ea9d7b',30,'mod_scorm','content',0,'/mobile/slides/','5wpnG6B1FpH.gz',NULL,3552,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1282,'0cf6570659be8528c16dcc6aab6b3aea6e4717da','b7e86ca10a718a4f276bdffb50d36b9bb5a52eaf',30,'mod_scorm','content',0,'/story_content/slides/','65fdRqndRC8.swf',NULL,3859,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1283,'25915b02b1fbab68915caa12bd0dad3cec132327','b9292ba7811c0bc8649dab2de45710b79adabdc6',30,'mod_scorm','content',0,'/mobile/slides/','65fdRqndRC8.gz',NULL,3567,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1284,'b3cda88d3d07d52ad0cbd6f6aa00ab914c0d6d1a','8e9e8c15de714cb4ac55eff2dc73d420c6adb0bb',30,'mod_scorm','content',0,'/mobile/slides/','5W9GN2J2BSa.js',NULL,17573,'application/x-javascript',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1285,'0cdd8fc20a29823c801eec0c7acaa06fae539df8','620628f19d12d84ec375b6021ed1283caa5ce6c8',30,'mod_scorm','content',0,'/mobile/slides/','5tj2HADL4LN.js',NULL,17620,'application/x-javascript',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1286,'18c2fff23786dcfc846c194cb9763402f31f5c3a','e0edcc43db0f2f0416f4b5df259ad961bb479e3b',30,'mod_scorm','content',0,'/story_content/slides/','6Rk2rjRpnbi.swf',NULL,3868,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1287,'9e4f9e7ffd755e7f9067d205b760e103c4bbb1c1','5cde17f81b9e81feb85e56be86e26ce2b9fd41ef',30,'mod_scorm','content',0,'/mobile/slides/','6Rk2rjRpnbi.gz',NULL,3576,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1288,'8b3294599e81836790f8295d051d5f15ee63482e','ab96e23a3514e43295b6508147cdc24380e42fe3',30,'mod_scorm','content',0,'/story_content/slides/','65kwkzyZfqw.swf',NULL,3857,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1289,'c223efea2f7c010b6d326983d5e8d2b45b1880a2','03bbe782059f8e8f730d57e475fb2012147ef239',30,'mod_scorm','content',0,'/mobile/slides/','65kwkzyZfqw.gz',NULL,3562,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1290,'74f86d551856f3d8aff6987ad44c24cc0a163619','d4027deac133ea3be9940d167081d9c3182acd4f',30,'mod_scorm','content',0,'/story_content/slides/','6lDmIWLrfNl.swf',NULL,3839,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1291,'81c3f27db5915011201446914e3f5d73a8c35d5c','e7065d3dda19d81fd08b0865adcabd50ef3ea72f',30,'mod_scorm','content',0,'/mobile/slides/','6lDmIWLrfNl.gz',NULL,3546,'application/g-zip',0,NULL,NULL,NULL,1462458063,1462458063,0,NULL),(1292,'26ba41ab8f9993bc70d9581a53f117372b5c30b2','35d7c11aaea4e9b2964059314faaeb4efa742e04',30,'mod_scorm','content',0,'/mobile/slides/','5k1PHrCqAlg.js',NULL,17596,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1293,'6e931dce48d9dd1f9ec239ee7b4587db91dafff2','274f1506becfe10cb36c5ce81693894e9b3c834e',30,'mod_scorm','content',0,'/story_content/slides/','6kY7eaQe0PX.swf',NULL,3844,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1294,'edac4c5f33ef50f06af3d9df3e453d98df8440b4','91bd00ca26ea0170c5301770f53d634b1f0aa835',30,'mod_scorm','content',0,'/mobile/slides/','5ansVlNKtXL.js',NULL,17585,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1295,'2516bcbef489292da843cc0006adca7fe166d82a','37168f20f1c3e5c60eab2a1ade9545291444a623',30,'mod_scorm','content',0,'/mobile/slides/','6kY7eaQe0PX.gz',NULL,3551,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1296,'21cbaab5e5d6775430186a87488a9f384de3d5c9','d7b83f581d8f829aad4fd98f82a74f03107c51a2',30,'mod_scorm','content',0,'/mobile/slides/','5wpnG6B1FpH.js',NULL,17558,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1297,'953818d6d64478ce46e8db02f125b986f4ce5e27','7317ce19c6f5e432b9097550f7e544cd886a0d19',30,'mod_scorm','content',0,'/story_content/slides/','6WHvvueBvap.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1298,'f1837ef2efaafdf44454560e5d6d07da6b3d1af4','ffd3f2485521c96c3b1433410742cb397f7f1150',30,'mod_scorm','content',0,'/mobile/slides/','6WHvvueBvap.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1299,'11e5223d5b59f5a6ad98e918a70cbcaaaf8b88c2','9cf61f19c78153633fda61e3efd875710d71098b',30,'mod_scorm','content',0,'/mobile/slides/','6T0ugOL2rvm.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1300,'7e77768e81035bb3ac2d725d66479099fa201d96','51b0b8d9497056db7c3f3b3ec1e58ef16b264752',30,'mod_scorm','content',0,'/story_content/slides/','6ovf1erWSkU.swf',NULL,3842,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1301,'39943a862ba649a1b832e614ca760467630b3d99','47eb8519ae0d14a5acc92185678373a57940b6d1',30,'mod_scorm','content',0,'/mobile/slides/','6ovf1erWSkU.gz',NULL,3550,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1302,'ebd4cd6dfa2ac11240857fc503778d01838d1881','79fe4d74c0a6acb3f80052aab28bce2f6286b521',30,'mod_scorm','content',0,'/mobile/slides/','5y0egc4HPjQ.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1303,'124cabecc79f7f1c9934f21de64197bacf0ce496','606e5089c27cd0f4f12a156ad369173b4aaaf71b',30,'mod_scorm','content',0,'/story_content/slides/','5bDhg1lfjtB.swf',NULL,3858,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1304,'b8cb91c1fdb5b9c2f135c60f8d8e09e23f30f2f5','7f385ebb460ebb641a2b957e03f5bd1662e0fdd4',30,'mod_scorm','content',0,'/mobile/slides/','5bDhg1lfjtB.gz',NULL,3564,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1305,'4902213fdfcd13fa1fff74057cb654a6552a1dac','aa4f8edcc9060653a7da7e970f23b8b911d954ee',30,'mod_scorm','content',0,'/story_content/slides/','6OwBw9apqzz.swf',NULL,3841,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1306,'f31c0d4cf071245224f35aa09955455bae6a5d89','98a6b6f79eee3ee4fa5b5a6be3460c843641a288',30,'mod_scorm','content',0,'/mobile/slides/','6OwBw9apqzz.gz',NULL,3548,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1307,'73377944bbc8c6d23570dda292b5ddb4d96bbfcd','e5419447c84bf83caf77d16f65b5d65148bba500',30,'mod_scorm','content',0,'/mobile/slides/','65FrsQIFFy2.js',NULL,17584,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1308,'af87cd2d8eef0e4bd2dcd5ad398fc96fe49f4f5b','4272e14cd50ba9282cfa388938d81c795e2b0c7e',30,'mod_scorm','content',0,'/mobile/slides/','6ayRRlEtIln.js',NULL,17575,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1309,'ad9a6496a2f57b4c75ad02a4d0d702a25b4db8be','793673b8c5a8d972bfa63ca7a1856619430754f2',30,'mod_scorm','content',0,'/mobile/slides/','6kY7eaQe0PX.js',NULL,17557,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1310,'5c9abacbb47b85ebfa61394ad32ff1b72cd9e2ae','0d73578d6e05ef8bb76fc8ddb37c7ae804174359',30,'mod_scorm','content',0,'/story_content/slides/','5s6bzBiWoAy.swf',NULL,3842,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1311,'6c5a848f5c5529ef927bddd3256a2e8d37fd483a','c81abec046c5ec7f293081929c86e3b386ed3393',30,'mod_scorm','content',0,'/mobile/slides/','5s6bzBiWoAy.gz',NULL,3549,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1312,'c23a7e2f631825d08c35ebf3867ec57e94ed033d','26bbd7658b67285e772b16923b5f8177a3709836',30,'mod_scorm','content',0,'/mobile/slides/','6rTnxXnvJ81.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1313,'5839eb9c3db544434feaad8ed7e304d4abc69ca9','25bdf0882f5cd44b23c4620f1c49bf25e1a09b3c',30,'mod_scorm','content',0,'/story_content/slides/','6VYgZsa23Pu.swf',NULL,3856,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1314,'bb1ae45f8cf9d495cb9b5a31067590759d3ee221','77bb62b4b8f0a38523914d0ea1f397aff682e512',30,'mod_scorm','content',0,'/mobile/slides/','6VYgZsa23Pu.gz',NULL,3565,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1315,'1559808cbb35d9ef77fe2d19b5f93e296451c865','2f8f0eaad9d96bf6ae73a8fdf23cb33a04e97939',30,'mod_scorm','content',0,'/mobile/slides/','6lDmIWLrfNl.js',NULL,17551,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1316,'80d2767f4286f03302083b96f8143ecb6ea26617','b68e1ea887f9e06e05abe656616f3dc97a4da9e2',30,'mod_scorm','content',0,'/mobile/slides/','6WHvvueBvap.js',NULL,17568,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1317,'f0d12dbef6a99acf6a9bb65bbc64769f41f54a95','76b0f44a32a00aea3ad79b87007b19d34e6359d3',30,'mod_scorm','content',0,'/story_content/slides/','6joBKy8iQZj.swf',NULL,3863,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1318,'6a05aad5bf761381a0aa6882214ecf4c7e4bdc01','da951aff20342231df57c94609fffa9c1c35ed8c',30,'mod_scorm','content',0,'/mobile/slides/','5gysLNLELk2.js',NULL,17591,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1319,'c817c5d4b96c26295ef30f29e8118b6e1c12f7bb','af2cfc5fcf15b60baf414e20c2cf62e6a77ce870',30,'mod_scorm','content',0,'/mobile/slides/','65fdRqndRC8.js',NULL,17584,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1320,'3b00dd3c84e199744ca90ccab75f6d7a100d41f0','ca34ffae881d8abc707149ea7d96e1aa69a84de8',30,'mod_scorm','content',0,'/mobile/slides/','5ccVhSbmlTY.js',NULL,17553,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1321,'ea5694d4ae67f6a08dccbd2a53d6f5efad931e9c','33e77da74904b8c7a695940ca273f5c5b8534ec4',30,'mod_scorm','content',0,'/mobile/slides/','6joBKy8iQZj.gz',NULL,3571,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1322,'deef119b6fd3ba93179caa1ab62986a39fe2cc43','2485f955a17e16830c7aabeb4df20db980127f14',30,'mod_scorm','content',0,'/story_content/slides/','5YPgY0GAuV3.swf',NULL,3848,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1323,'0c9e474ec80a4afa75a6764289ae2085697bde0a','92dc2e259cf99f9ae075d85bea4cdc116938ef5b',30,'mod_scorm','content',0,'/mobile/slides/','5YPgY0GAuV3.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1324,'8a05d138548887996d8d36d04be2f0d4ea6b3766','848754571a2fdf40f92f1b5e4b0c47dbd1e5a4c6',30,'mod_scorm','content',0,'/story_content/slides/','6ShiFfBMWGj.swf',NULL,3874,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1325,'b3c8bd7351ed0d2f3745294f7a2d873eae5cf38d','da083fb5fa8c736fb51d16c382c2ca8088ca11a1',30,'mod_scorm','content',0,'/mobile/slides/','6ovf1erWSkU.js',NULL,17558,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1326,'3c8ae9597cdf33a9bbfe48c4d424c2e56ca5427d','5556e522db902cb90aa8d4bfbfc8aec4924a80d7',30,'mod_scorm','content',0,'/mobile/slides/','6Rk2rjRpnbi.js',NULL,17613,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1327,'5747cd2d93e304b0781511b70ef4f543da948394','6613ff508a6081c266c94157dbc356bf26e9c467',30,'mod_scorm','content',0,'/mobile/slides/','6VYgZsa23Pu.js',NULL,17613,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1328,'fe71efe7a8626cf39629354b953c6c1227cad91e','d1b0146a390996c73bebc6d8b372fc2300dedef5',30,'mod_scorm','content',0,'/mobile/slides/','65kwkzyZfqw.js',NULL,17570,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1329,'60533cdb8a1c7cd334c004ac59112c40a02dbf3a','45d10a0cb49beabd47608fbe67254e4d64232f10',30,'mod_scorm','content',0,'/mobile/slides/','6OwBw9apqzz.js',NULL,17559,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1330,'8abbe5d3310e5fa4891fe345d2ea54ef7b3ab3bc','d60a0e542fb7fbf5129d45dd7ac4393056a615b7',30,'mod_scorm','content',0,'/mobile/slides/','5bDhg1lfjtB.js',NULL,17573,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1331,'6d1c615b0f6430a4d91b0e24782e29040c44365a','27991df3975bc76000a8b0611e459a9deb41feb2',30,'mod_scorm','content',0,'/mobile/slides/','5YPgY0GAuV3.js',NULL,17557,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1332,'3a4187d269da03301a762e9d38dbced31a1a487c','71470de6ae328ae23895c534097d639ee521c335',30,'mod_scorm','content',0,'/mobile/slides/','6joBKy8iQZj.js',NULL,17592,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1333,'d8201e06866e3b7cbacc7d29e9d10e2a77b9cbbb','b61c878190bcff1b8ea5fba22938bf52a392775d',30,'mod_scorm','content',0,'/mobile/slides/','5s6bzBiWoAy.js',NULL,17564,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1334,'29d9e38935ea8ac7ee2c065f1280827152792a17','a1e9a627210a24e73efe4b29e9b9b77d497bd6c6',30,'mod_scorm','content',0,'/story_content/slides/','6GFeAXiYmCC.swf',NULL,3859,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1335,'b4cbf9bb265b639bed07c44273611cecc1480b03','b619790c9fdb16fba00fc945b262356707dd3610',30,'mod_scorm','content',0,'/story_content/slides/','5VO0ezXf3lf.swf',NULL,3842,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1336,'8a254982ea0ea2ab3ea80e50affc2c7458fb85fc','af4ee2aaf529cc8ae1f38a1eb07b83da773e21aa',30,'mod_scorm','content',0,'/story_content/slides/','5fT6PVWW0UF.swf',NULL,3866,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1337,'94c9dee268ba2549e66a0d1de214dea9fe69fd50','841e4cd86e68be739b8a2dc517051ed2fb449f3e',30,'mod_scorm','content',0,'/story_content/slides/','6kDVVTrZiQ3.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1338,'10d304dc59dabdb8ab283441f65c62bebf5714f6','c146bc102ee75b4a681d89640d8b1bf61b678237',30,'mod_scorm','content',0,'/mobile/slides/','5fT6PVWW0UF.gz',NULL,3574,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1339,'e38112d9410ab0699304fb99d4a988342552a097','95878901a875fe17835c9e4b5918895e2fe7dc8f',30,'mod_scorm','content',0,'/story_content/slides/','66SBjbN8XfC.swf',NULL,3836,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1340,'8b6156b43759450c020c90e426c745237d66cc0f','25c98877db9749324ccf23b1735069b53af4eab2',30,'mod_scorm','content',0,'/mobile/slides/','66SBjbN8XfC.gz',NULL,3543,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1341,'59cca7e60f6330955236538d81b8a8ea2ef6a90f','8b372f97c7113208cec21ecf9e81680741fa992d',30,'mod_scorm','content',0,'/story_content/slides/','65sBwOBHz4W.swf',NULL,3858,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1342,'8fc009fac658d961a42516fb905da88aa3a532eb','dc1d42d22b4e2a4751403cd02e49b7871d6bcc82',30,'mod_scorm','content',0,'/story_content/slides/','5r7KQhSnAxo.swf',NULL,3860,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1343,'95e4484da97cfac24723baa1f5e6667fd4b2be86','22e018061624688a1c36a769728c93e02a9a344c',30,'mod_scorm','content',0,'/mobile/slides/','65sBwOBHz4W.gz',NULL,3568,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1344,'1e40eaecb06e5725bdfb7505af9191cdac3e2432','dc99907e164654e8aff409d1e8fad116efc39a59',30,'mod_scorm','content',0,'/mobile/slides/','5r7KQhSnAxo.gz',NULL,3567,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1345,'4a632dc639393e2440ec5833a4495bdf28686f5e','be434c7780ca0f5428490c2f63d0f69791e47a12',30,'mod_scorm','content',0,'/story_content/slides/','65UmZ47VhNM.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1346,'00c15788bee961fef747999bdc20f1df6fdb9826','e69fc1e851a16fc2c9f4f0c971201a7476593e89',30,'mod_scorm','content',0,'/mobile/slides/','6ShiFfBMWGj.gz',NULL,3581,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1347,'87439248750adce79aaa4de825ecf087b4b65e18','62737b0b38a8edc311d36bfa3b91c852fd0bb861',30,'mod_scorm','content',0,'/story_content/slides/','6eaLwHz8hpK.swf',NULL,3855,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1348,'3b0c7357b3018488465ef99ae96d54978bd50068','36a7d31b4b16adb67c5eb19e84766e0b84e0b5d3',30,'mod_scorm','content',0,'/story_content/slides/','5mBxgbkDdcn.swf',NULL,3852,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1349,'5771072fbe64251fbcc868a52339873f65414b3b','908512442bfe98c2c06f4e62706bb02d89742382',30,'mod_scorm','content',0,'/story_content/slides/','6AD3xpBhjE9.swf',NULL,3849,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1350,'013e4618aa498252059cb7a7162375d0a5fb3960','69ee0d74d65e8443494a173f472a29a903cbc2df',30,'mod_scorm','content',0,'/story_content/slides/','5yW02ywc96R.swf',NULL,3859,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1351,'6559bc13b5e0ca2ff2908941e2a68aa9d645f89f','76a04cc287c8ea8604562d240ae04628a95e4bad',30,'mod_scorm','content',0,'/mobile/slides/','6kDVVTrZiQ3.gz',NULL,3557,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1352,'120002ec536a634a878966295cb6b91e72bca713','38437fa8208c1c47778c7a4551904b5af35563bf',30,'mod_scorm','content',0,'/mobile/slides/','66SBjbN8XfC.js',NULL,17562,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1353,'f55e707544509ff433d206c2852378b58bc069b4','dc36387be083a9894ef27b95fce3908b2abbe0de',30,'mod_scorm','content',0,'/mobile/slides/','5fT6PVWW0UF.js',NULL,17600,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1354,'050e94361a11783648225e2eff679c2845fd433f','8e72cced25d9825f7ed86333c0b9453eeb3a50b3',30,'mod_scorm','content',0,'/mobile/slides/','5r7KQhSnAxo.js',NULL,17568,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1355,'645bc4bdc0c21985cac2091763d2947f0610601c','f3a6bc78cab40fd35d9ff00cc13af76bf206e5e7',30,'mod_scorm','content',0,'/mobile/slides/','5yW02ywc96R.gz',NULL,3568,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1356,'eeaa228424a0a20565507ce3009082e733112968','fce5b2f736817709a6254ea5e6eac31194633558',30,'mod_scorm','content',0,'/mobile/slides/','5mBxgbkDdcn.gz',NULL,3560,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1357,'d018b8db2ca79cd0d3efc47aa729008b4928a13b','5d7709d0f1ea0fee7bcf0952d2b90be113e80d00',30,'mod_scorm','content',0,'/mobile/slides/','6eaLwHz8hpK.gz',NULL,3564,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1358,'ba3cdac8a5e42a89639605548decbf6028afe12c','f69de287f790c96fd6461e849d61098b7d8ea71e',30,'mod_scorm','content',0,'/mobile/slides/','5VO0ezXf3lf.gz',NULL,3550,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1359,'93173679d58a1a4fc4dbaa7573b2b990fe932a70','9edc4703084da8ca1f5e25f18e31e8aa8e7cee2f',30,'mod_scorm','content',0,'/mobile/slides/','65sBwOBHz4W.js',NULL,17593,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1360,'2dbf2a885e5aa328a997908678c9182858406f45','bd52e97c848fd3be212035f84c8e4bad23cc6a47',30,'mod_scorm','content',0,'/story_content/slides/','6VDZJ9WuPDV.swf',NULL,3862,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1361,'2272577cac8d5083be951adeb2127735e7344900','c7ad4e4870061df2e64518b6c3d106d9d9527464',30,'mod_scorm','content',0,'/mobile/slides/','6VDZJ9WuPDV.gz',NULL,3571,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1362,'5be02644286b0b4121c1ecf72c0631a4ed597b98','98e46ea54260477d42bf3642b9d9fc26dc07ea40',30,'mod_scorm','content',0,'/story_content/slides/','5s97YCuFjZv.swf',NULL,3861,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1363,'8f0f050957f7ef32a405c8f8a885a35ff15fd269','17345f5990ad6ad2c7273f40ed5a70d29f1479a1',30,'mod_scorm','content',0,'/story_content/slides/','6F0EEbSbIOi.swf',NULL,3853,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1364,'3690d815dc207e575fc599db59d76d4e2c6e3520','5a1a50103f61046272fa6bebf8a6dc33ef715924',30,'mod_scorm','content',0,'/mobile/slides/','65UmZ47VhNM.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1365,'37472dde152761c7bf89c23fbe87b371b9f812b6','b68459834fb8def3a82a0c5e751bd67911d66ad5',30,'mod_scorm','content',0,'/mobile/slides/','5s97YCuFjZv.gz',NULL,3569,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1366,'b849213143d9873703d747e1eb7ad1c6d60430ab','7b962f4e5f541d4d96abbce5890e6e8f5b770724',30,'mod_scorm','content',0,'/mobile/slides/','6F0EEbSbIOi.gz',NULL,3560,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1367,'4cafcabd5faedf50f751fd1e8918c8680b52965f','7e1077d7d390b8dd3da9e6ab9306f91a7c8ac264',30,'mod_scorm','content',0,'/mobile/slides/','6AD3xpBhjE9.gz',NULL,3555,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1368,'6d916aaf1db99578149607a0616804c362047ec7','4bb40795cdfa86eba54699bf69f9ebc5646db775',30,'mod_scorm','content',0,'/mobile/slides/','5VO0ezXf3lf.js',NULL,17557,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1369,'9f37561a86ef8b6440ec3520e7fb214ca54f2c16','644e8195ff5c5ecf3eb8e5ae9b1c55dea6e77799',30,'mod_scorm','content',0,'/mobile/slides/','5yW02ywc96R.js',NULL,17586,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1370,'1608cced4afa3182e2ed2a7bf3b8e87b39fb47c2','030a4a747a18ba105e8c75a798dba8eee6c74781',30,'mod_scorm','content',0,'/mobile/slides/','6GFeAXiYmCC.gz',NULL,3567,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1371,'494f8fc0cc5d5080f1c7cbf2bac046a966f10ac2','a8ecaae814f9da0714d1e372bba617e85b7888a7',30,'mod_scorm','content',0,'/mobile/slides/','6ShiFfBMWGj.js',NULL,17616,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1372,'b904ea0803bc46d322102960ecadd8a24df1eb36','03bdd60e6695f49ce1c381f504b45a4bc2b1a20d',30,'mod_scorm','content',0,'/story_content/slides/','5xAYn85Jmyq.swf',NULL,3852,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1373,'8171b239408393be9388ebb7ed47e2b3c4473e55','c8dc4fa435fe3c47febad4ff86544fdcf54e2496',30,'mod_scorm','content',0,'/mobile/slides/','5xAYn85Jmyq.gz',NULL,3562,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1374,'ec00937b2b82f2f7e69cbde1ddd219c8f05e8ce4','ba229ceeb4a2893d30f9aba90244543faf8bfb0d',30,'mod_scorm','content',0,'/story_content/slides/','5pdvj0jPaoL.swf',NULL,3836,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1375,'902090cbc5a51ede032b908a40a6d087b8d6421d','260ff94eded7bddd183d8c149fb30e567a632a95',30,'mod_scorm','content',0,'/mobile/slides/','5pdvj0jPaoL.gz',NULL,3543,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1376,'911b6fecb3eeb108e2d3ccbd1d46b558b1b156c0','5c84ec25bb16558bd923d442e0f2931a1ad52634',30,'mod_scorm','content',0,'/story_content/slides/','5jL9GMXojmV.swf',NULL,3835,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1377,'f1b966a3da1dd28da90f8a432c8bbe3cdd2fe6a4','185b6f48d91fdb7319215fade8ec6c5e3bc387cb',30,'mod_scorm','content',0,'/mobile/slides/','5jL9GMXojmV.gz',NULL,3542,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1378,'fa46904957d3a2be876c94c4b6ad29d4ea5ff914','a228ec5538e1c776200307ebfe0e620b8fd82028',30,'mod_scorm','content',0,'/mobile/slides/','6kDVVTrZiQ3.js',NULL,17569,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1379,'2bfbf50d15b0c58b5fcead065ceab6d22352a567','7f8c35f6e343fc142f00d8570148ff361ba63381',30,'mod_scorm','content',0,'/mobile/slides/','5s97YCuFjZv.js',NULL,17594,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1380,'3bb4343acb420cd20ebb94bf690e947d83d2e628','12778b6c1fbe64a6dec5da6b2e7296fd1f2b806f',30,'mod_scorm','content',0,'/mobile/slides/','6F0EEbSbIOi.js',NULL,17567,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1381,'0a07cbeca9949b3b663a75f251589b473d267d44','7eb1ccbc5d6b7268505e8d0784f0bdbadfadff69',30,'mod_scorm','content',0,'/story_content/slides/','5cCDEW17Qw4.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1382,'cb96ef635ea832f945a31155ed89edb103378f4e','2f2ba26b37de40dffcf75cd0a7e4891ade80b05e',30,'mod_scorm','content',0,'/mobile/slides/','5cCDEW17Qw4.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1383,'a912c63d0cd14d8bf4b87245669e902300dd910f','8620fdab110fa04f04a36c221fbe102d476ec218',30,'mod_scorm','content',0,'/mobile/slides/','5mBxgbkDdcn.js',NULL,17588,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1384,'f81506c4e5cb62621d974b739bebb41fdaeef2cb','7070139fe4f8d2bb6c060322d4347d14f1b2a884',30,'mod_scorm','content',0,'/mobile/slides/','65UmZ47VhNM.js',NULL,17568,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1385,'03bf08ef43172913c0bfcaf5c0aa980b6648abf7','6647df1b9f45600bd89c11d59952b89290d177b2',30,'mod_scorm','content',0,'/story_content/slides/','5WN2LnpzmZo.swf',NULL,3853,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1386,'5b101d230c418ed8dd3b8a5db4cc5b3b2800a4cb','7a38d807ee22cb2766086c6e5d8ee252efd3843e',30,'mod_scorm','content',0,'/mobile/slides/','5WN2LnpzmZo.gz',NULL,3561,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1387,'7a9e5e4422f25839948fad0b0230e6689ad62dfd','4fc8c8ad36dc61fb2c098e0bfa590959fa5fdd78',30,'mod_scorm','content',0,'/mobile/slides/','6AD3xpBhjE9.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1388,'27f6f3777fce5720197c8d49c06e927d49b32042','97ebec3607a9b6aa6762037b59f65a3a385fef98',30,'mod_scorm','content',0,'/story_content/slides/','5yx98dlkQtk.swf',NULL,3846,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1389,'3d955ce6b8b899cd21767b4fc4621a910614788e','e11bc19ff16964068529abde77511fe7771aeefe',30,'mod_scorm','content',0,'/mobile/slides/','5yx98dlkQtk.gz',NULL,3552,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1390,'939ad6a5b5636ef16db8cf50cf0b3d2878ea1172','56e0676485e5cf50467bf16ebe46dab361b411c3',30,'mod_scorm','content',0,'/mobile/slides/','5xAYn85Jmyq.js',NULL,17583,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1391,'e14bb5a6892b7e9104d3a7a3552f456774a7a5ee','3ff73d8eabd39fe3474711a5150e74872f02bf6a',30,'mod_scorm','content',0,'/story_content/slides/','6LAI9qLXMbU.swf',NULL,3856,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1392,'afef099c6063c9e280a539d1fb71c1eeb17fb44c','e85eed6093951c936f933df7a1c6d434f395ffd7',30,'mod_scorm','content',0,'/mobile/slides/','6LAI9qLXMbU.gz',NULL,3564,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1393,'67a8867cc2e019a2ece15fbd5a53e0aac4e92e49','f1ddd80371fce29efa1b3388a367bfe247248a82',30,'mod_scorm','content',0,'/story_content/slides/','6I3UymPX355.swf',NULL,3861,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1394,'18767ebf4d63f255ea1239e0c245ea3b42785bfa','83c284eb8d5c6606fd7688e646f7e321b1991176',30,'mod_scorm','content',0,'/mobile/slides/','6I3UymPX355.gz',NULL,3570,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1395,'aea2fe39e013e1d98831479f080020a3238c188b','ecaa1b071247bde580eaa0fd688f4f82ee94c822',30,'mod_scorm','content',0,'/mobile/slides/','6VDZJ9WuPDV.js',NULL,17599,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1396,'53ec973b79dcdcd35d1f14774f4b8221191451c7','485350fafc6f3b2c3f8c562fb159c0059b174f5f',30,'mod_scorm','content',0,'/mobile/slides/','6GFeAXiYmCC.js',NULL,17590,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1397,'96d928b56fab1fd3706d660d36c07c8ade5b54df','f5bd8f56f6d169aba9027d05c1f16062b9fa966b',30,'mod_scorm','content',0,'/mobile/slides/','6eaLwHz8hpK.js',NULL,17583,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1398,'bbc03b4f09d0ffd5161eb41c72babbd251312bed','45f5949b46bdb6e38a31a1afa0f14bcbdb4095a8',30,'mod_scorm','content',0,'/mobile/slides/','5cCDEW17Qw4.js',NULL,17575,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1399,'86b29594bd96bbd1486a271277f09d85586d4f5b','62598cef45f9f05b657bb5aba87f9c1a161e7064',30,'mod_scorm','content',0,'/mobile/slides/','5jL9GMXojmV.js',NULL,17551,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1400,'3fe9f90219fe77f8465a897872a083d6229c5b3f','89eb6d75dc10fad228a6ce9f3a4722c1c190d204',30,'mod_scorm','content',0,'/story_content/slides/','6YCvW9U3Y67.swf',NULL,3848,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1401,'23f13fe94ef4051f7a65589fa972dc99592940e5','2de50bd82fe3c7c322f4d6ed7de697785656914c',30,'mod_scorm','content',0,'/mobile/slides/','6YCvW9U3Y67.gz',NULL,3554,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1402,'1c246bc73b6dd0c5e33ed3acfdd41c1a568eb423','a96c0ec722ea6a84e390f66034a923e69cb607ae',30,'mod_scorm','content',0,'/story_content/slides/','5n0KlxtU2SG.swf',NULL,3853,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1403,'f5e54a9303c388cb99b1965a1a00cb9462ebefa8','2df0acc08f188f73846a6d6841ac5b764c2745f2',30,'mod_scorm','content',0,'/mobile/slides/','5n0KlxtU2SG.gz',NULL,3560,'application/g-zip',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1404,'47eed9dd27ca3d68e8da1b2315ef3b08f03511c4','09a6ee03f12362c2791f5039f4c674ecb4ad1f7b',30,'mod_scorm','content',0,'/mobile/slides/','5yx98dlkQtk.js',NULL,17559,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1405,'e635b797a068c7532a2a032b05a9cfeed3802385','187e3e75564fbd89d741a60128b4878f4e450d79',30,'mod_scorm','content',0,'/story_content/slides/','6fk56HJkCeH.swf',NULL,3851,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1406,'65e6a935d086f98ccdc8ec8ce0426091190d0c12','d090b424f5f34a91e4dc4045ae62a2720d291e5d',30,'mod_scorm','content',0,'/mobile/slides/','5WN2LnpzmZo.js',NULL,17582,'application/x-javascript',0,NULL,NULL,NULL,1462458064,1462458064,0,NULL),(1407,'59b29702a3a4c43f8de6cb47c702264edac60c8a','490011822f9873f17bce94887fd143e2f9647ddb',30,'mod_scorm','content',0,'/mobile/slides/','6LAI9qLXMbU.js',NULL,17574,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1408,'dcd29771237cb7869880599a0180e0b5fa839929','5880b8096e95099d44ec2c4ddfa6c402aba7909d',30,'mod_scorm','content',0,'/mobile/slides/','6fk56HJkCeH.gz',NULL,3558,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1409,'aa8cc3f0540ee9ffd3630e627751602c158060cd','8e6d8539e7019327e8626c0919d4ccc89ba67579',30,'mod_scorm','content',0,'/mobile/slides/','5pdvj0jPaoL.js',NULL,17553,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1410,'785ea58a61c3445d9083fe019af519098fb8d1c6','9bc1a1d2b8874490c1009b17e5c621c8c5cca6a4',30,'mod_scorm','content',0,'/mobile/slides/','6YCvW9U3Y67.js',NULL,17561,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1411,'488bc425b9dbc2627ead40f85607ee20345149a1','640613b6f5454b5fc4abb8fa123c5535d6d3039b',30,'mod_scorm','content',0,'/story_content/slides/','5w76aX8nSKm.swf',NULL,3836,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1412,'6e668409be0a81ca08aaf460686a38de454d73e2','f12697c52590af0f606725f536cc209ebe19c1b6',30,'mod_scorm','content',0,'/mobile/slides/','5w76aX8nSKm.gz',NULL,3544,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1413,'3ec9be712e0731540df93752fa04a369342fc1f1','2abb2c78b75a688478ee57a4297fa86a6d2b21cf',30,'mod_scorm','content',0,'/story_content/slides/','5Utf9imOi6m.swf',NULL,3858,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1414,'753db94a39c8af656582c76418bbb4b88bfd8146','a40a8cf46ef274cfaf883c9f69a8bfd11838ee4c',30,'mod_scorm','content',0,'/mobile/slides/','5n0KlxtU2SG.js',NULL,17578,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1415,'7acaa7ebb6d34c732aaa7b869ac5dbe38c7de4b5','00cab2524567f63cd437b97abebf387070d2d673',30,'mod_scorm','content',0,'/story_content/slides/','5WzWlBfqokO.swf',NULL,3845,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1416,'5640b29e9e80c24418319c1d3c82d4a7336b3d3f','948e7068b11e338480834c1eaa51b88daec1cdf4',30,'mod_scorm','content',0,'/mobile/slides/','5Utf9imOi6m.gz',NULL,3566,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1417,'19c55984e4cf41baa85d5473b44079d7dc832c99','2d751199a68998ce1f7501baf3eb1d1cceb4857d',30,'mod_scorm','content',0,'/story_content/slides/','5bo7HMwKt26.swf',NULL,3857,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1418,'6905b2ed49b56042731931abfaa30eb8b37de512','36b9842038cef4245cd292f3e8917b66607f78cd',30,'mod_scorm','content',0,'/story_content/slides/','6esW9PhnsWW.swf',NULL,3856,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1419,'b5fbddf9c908d5cb0444b34643e684b61e0366ba','2e872dd8a9c13fe40cd38037a788352e2dd9bca5',30,'mod_scorm','content',0,'/mobile/slides/','6esW9PhnsWW.gz',NULL,3565,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1420,'d93ec9d812f6d37e77015df3f6d8606e1e399371','a88c819ab21e1f4cc2e675a71c26d1849067c7bf',30,'mod_scorm','content',0,'/story_content/slides/','6rosVS5J35I.swf',NULL,3892,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1421,'fb48cb19c254415945e4af66866c479b7208426c','2f92bd535c06e94e2c6df439274821c246de042e',30,'mod_scorm','content',0,'/mobile/slides/','5WzWlBfqokO.gz',NULL,3552,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1422,'8656d7aeedea5282f4de2d201f9d15871a63f93b','9ff2b3796f4909314fa9886988261d52fb43e306',30,'mod_scorm','content',0,'/mobile/slides/','5bo7HMwKt26.gz',NULL,3566,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1423,'8c155a92771fbb88fce1c430649d43b00672c274','e3df9012e5bf80c36f4ca61ec7c5af889f9b9eee',30,'mod_scorm','content',0,'/mobile/slides/','6rosVS5J35I.gz',NULL,3602,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1424,'c4b575deb6cd78f70b7d5195bef7ba9331e813cd','6582cf91ad1a9f90aed9d2b524a0d260e6acfb25',30,'mod_scorm','content',0,'/story_content/slides/','5wwVNC1LGCL.swf',NULL,3849,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1425,'475f36e96bebbee9e5f23ddea37074cc5d9ab784','145a1730424c7d100b5a494a0803acbb07f3ae4b',30,'mod_scorm','content',0,'/mobile/slides/','5wwVNC1LGCL.gz',NULL,3557,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1426,'361d00fb207182ea8318deb3925efef35d5bae81','ba43449ef96b998fd468be8b571eb8d257384502',30,'mod_scorm','content',0,'/mobile/slides/','6I3UymPX355.js',NULL,17607,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1427,'e2b0f4d8147e69f023ef4dbd712e4a039e9deba4','e718238f76c6ff62d68e5473cd82ed83119428d7',30,'mod_scorm','content',0,'/story_content/slides/','68Xrx3Ucfxt.swf',NULL,3856,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1428,'f42037c8151106423563095723391fb3a4f46eae','696c44e78185e91e73837d0ca16910ab29129d84',30,'mod_scorm','content',0,'/mobile/slides/','6fk56HJkCeH.js',NULL,17579,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1429,'11c3e1de02187273c4523e7628fc0c877cc58de7','008fb316d61f2a577e4bde25677dd87ee43f5bb2',30,'mod_scorm','content',0,'/mobile/slides/','68Xrx3Ucfxt.gz',NULL,3565,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1430,'439a1f162d8c64cc4a90e1c240d4ab585aefd8a7','77d011d271e88b7395daa9c4a9b446ce1186dacb',30,'mod_scorm','content',0,'/mobile/slides/','5w76aX8nSKm.js',NULL,17552,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1431,'9dbe4435fdc81d3cabf393a27adf9b80bb186d4a','9f9d69160cc48cb9fe32332fa3ac4cf1674235e0',30,'mod_scorm','content',0,'/mobile/slides/','5Utf9imOi6m.js',NULL,17576,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1432,'76425534ceaf69904ec52634e085e986f63ac321','e67b1768577f8405be1048f43915fe61ee006d26',30,'mod_scorm','content',0,'/story_content/slides/','6NVy4Wme7X2.swf',NULL,3846,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1433,'9c94b5776bb98e40c1ec0d352ca26d87af7553a9','be333c5d831bc4a422dd63e123d1f58fd49ce436',30,'mod_scorm','content',0,'/mobile/slides/','6NVy4Wme7X2.gz',NULL,3552,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1434,'96b321a21eadc32efbab1666da581aaec68879d0','ea8cdf2c540b2b234c1e31c9dc3bb12955a28526',30,'mod_scorm','content',0,'/mobile/slides/','5wwVNC1LGCL.js',NULL,17558,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1435,'e815e1ba022b8e3ccc4835bc590634af1aaf16ad','4a94e72a856d885ac3e6d430e563653299bf7433',30,'mod_scorm','content',0,'/story_content/slides/','6PQ3hlH5Mf4.swf',NULL,3837,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1436,'438217188fbf5ec58c898a9cd4517329f0f39415','266bd4fb04e11426b1041e6834a1d1ed1c513a9d',30,'mod_scorm','content',0,'/story_content/slides/','5YKBMtwevRb.swf',NULL,3856,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1437,'7bbb83e695dd08eb356f85f33e5d4997dddbbe2f','987dd545182644a0d85fe596b43e234997747da2',30,'mod_scorm','content',0,'/mobile/slides/','5YKBMtwevRb.gz',NULL,3564,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1438,'a6aff65acd2555c1d2c6ba4728acf1661fdc65ef','bedb23ee3a034cbee4a7d125a4925f45ff17e112',30,'mod_scorm','content',0,'/mobile/slides/','6PQ3hlH5Mf4.gz',NULL,3544,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1439,'17dfad7a549b8b16d320d4ec7a7efd89efbcac3f','f4c3d472da62399c1e286d4f964a060e84696a60',30,'mod_scorm','content',0,'/mobile/slides/','6esW9PhnsWW.js',NULL,17570,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1440,'546a9cbd5b207155ac6640a08501c6acf9f87158','1b1c3c92439ffacd4295e0c582ab45b9465c6b34',30,'mod_scorm','content',0,'/mobile/slides/','5bo7HMwKt26.js',NULL,17585,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1441,'42785eff15b6b7a5ae5931bdc3c52cfb7a404edd','008ff5ce8f991a836f3bdaf64c019f2d69dafaa3',30,'mod_scorm','content',0,'/mobile/slides/','6rosVS5J35I.js',NULL,17659,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1442,'de3338646fe34820473b0a9ff64384c110c8bc50','75690fbb81f3c6b242307d83d3831404897f24ac',30,'mod_scorm','content',0,'/mobile/slides/','5WzWlBfqokO.js',NULL,17557,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1443,'6784db6a34e26feffa7cdd8378155762db9a7a97','4dcf98afb807f31e63e9a84d2c6f0c66a2a4a470',30,'mod_scorm','content',0,'/mobile/slides/','6NVy4Wme7X2.js',NULL,17565,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1444,'e99fbe2c975d7d994c9aa9ad130c8e2cb95f0171','ae3a431e793f773c22f6c0f6a90e9a68342c3e0f',30,'mod_scorm','content',0,'/mobile/slides/','68Xrx3Ucfxt.js',NULL,17602,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1445,'5c784e0b10cffc56d7f9a097675271e677f39a5e','01d66d465dac4900f0c379c0c80203ede3a20f65',30,'mod_scorm','content',0,'/story_content/slides/','6aO1yG7UlGD.swf',NULL,3868,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1446,'977b1c3bcfc9ef583092fae878f9aa994a19d94b','a80386bcf781eabdcdf3299df79c6b5aa1b0ea62',30,'mod_scorm','content',0,'/story_content/slides/','6Pw3QMdkLZr.swf',NULL,3842,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1447,'507d6e43128b40e32057d6ed5aaf0f0a069f1776','7e17249d368855f33ec2e4af8b73d46a5bd4e16a',30,'mod_scorm','content',0,'/mobile/slides/','6aO1yG7UlGD.gz',NULL,3577,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1448,'5f8811e5003470d84690b443055050776a125b46','d4093f5c66b1024ebf4d1e4d588e24944e6f8f86',30,'mod_scorm','content',0,'/story_content/slides/','6YII1ob36Id.swf',NULL,3847,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1449,'db5e2bbc8db728e1de67f296c68a4372143a4a43','0047e5d8124942bf32c67491a29088dbc1df99cc',30,'mod_scorm','content',0,'/mobile/slides/','6Pw3QMdkLZr.gz',NULL,3547,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1450,'171e00368131c39c0614d1513a9eced50abb5bfe','67d876a89797a4210a74e8eb08e833fddf791985',30,'mod_scorm','content',0,'/mobile/slides/','6PQ3hlH5Mf4.js',NULL,17551,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1451,'003dac2029d6eea7d2176d581ea4b82764169082','4707ed8bbbbac093d7d2df44c7ec63fb66bb9e82',30,'mod_scorm','content',0,'/mobile/slides/','6YII1ob36Id.gz',NULL,3553,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1452,'0cdf200fea86140db45257741c30d62f0de4d3a2','6b397f072f317c8d0530518e556cf322ec618059',30,'mod_scorm','content',0,'/story_content/slides/','6mqr7x3H28C.swf',NULL,3855,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1453,'859a1c6d54890ed52ff2b16fb33ca34d56ad2914','afd0aeb2cbcab0a68f3d159b8ffc86711e51405e',30,'mod_scorm','content',0,'/mobile/slides/','6mqr7x3H28C.gz',NULL,3562,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1454,'8099e57d4481042aebc84f27aaf4672257dde035','ab3de8a81b7c1cd3d16e34ec2147e2da924db4b2',30,'mod_scorm','content',0,'/story_content/slides/','6V7nzkHLTHh.swf',NULL,3869,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1455,'20b6a71dfacba8fc83de7918cccb24bb1420b2a4','12eb68d5b327b6b0587f1c3d8e87bdc471dc6143',30,'mod_scorm','content',0,'/mobile/slides/','6V7nzkHLTHh.gz',NULL,3578,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1456,'422aed6c9af9b5b44a627e79e14d641a4929a774','d1ace9cc5782fddb888c154737aff78dd1bc6469',30,'mod_scorm','content',0,'/story_content/slides/','5vi5ad27Y4m.swf',NULL,3840,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1457,'c130f5576f746e2d5945988c688f04eadb164934','fd7970b3f1358fa205b82568cb220781168200e2',30,'mod_scorm','content',0,'/story_content/slides/','62swWIwVgT4.swf',NULL,3857,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1458,'0954a70b35c838a035f33888acdb13ceae03a5b0','e19550987acba56b05ab9c803a2c5d6e36b1d484',30,'mod_scorm','content',0,'/mobile/slides/','5vi5ad27Y4m.gz',NULL,3548,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1459,'365bdb9ff9ef39e5073c644aea2f793ece2dd738','e9d2c24d4dac5caf1975f4ac680bb134b44f20f0',30,'mod_scorm','content',0,'/mobile/slides/','62swWIwVgT4.gz',NULL,3563,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1460,'65e37e48bc1d406fae532da66d0681bc2709668d','506d1eb60dc4ee679cad6c781b4d839227d1131c',30,'mod_scorm','content',0,'/mobile/slides/','5YKBMtwevRb.js',NULL,17582,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1461,'075aa77b3983fe2130b44d64080517e901dd1f63','5e3348e0bb32f17812c02c02eba3084ed1771367',30,'mod_scorm','content',0,'/mobile/slides/','6aO1yG7UlGD.js',NULL,17617,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1462,'2c1025962ec27ce66a65f349f506169db058a554','fa759be6b9a9ef9d04f541d57f544c15dd10890e',30,'mod_scorm','content',0,'/mobile/slides/','6Pw3QMdkLZr.js',NULL,17564,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1463,'30256965044c172327056bc281250066a34cf77c','7aa337f71c59080e138e50ef492b738fc6c287dc',30,'mod_scorm','content',0,'/mobile/slides/','6YII1ob36Id.js',NULL,17576,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1464,'b5d7d6a60bfae26d23fb09289fc24f0cae45aec8','a84834d882adb6715b4e3dc0b34eae306dfa53fa',30,'mod_scorm','content',0,'/mobile/slides/','6mqr7x3H28C.js',NULL,17583,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1465,'6630ef7467a23ff315a8d0c1356bd304ea5ac0a6','87cc23e18d645e39f7ac043bb18876fe7b7cd1ff',30,'mod_scorm','content',0,'/mobile/slides/','62swWIwVgT4.js',NULL,17577,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1466,'0b52a39cd221d6b174b188355be2df433a3f7c3c','5a866763e0a4b538981acb84f20ceb87a42b351a',30,'mod_scorm','content',0,'/mobile/slides/','5vi5ad27Y4m.js',NULL,17565,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1467,'a2e471ad018d38268c1f27a0c41f87f547103c60','d7e74d8e8a8009be467e7282341b85596c7d6a6e',30,'mod_scorm','content',0,'/mobile/slides/','6V7nzkHLTHh.js',NULL,17613,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1468,'3f4043fb634d544ef19ccf8b5246440408349274','ec92b12b12fc4b4f13e5183687929380bc5f9f90',30,'mod_scorm','content',0,'/story_content/slides/','6NrG8jTUqMe.swf',NULL,3843,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1469,'9ad7158acef336ad2a3dba8e6c706430db0b0998','63b36f129a03c1423a3626e52d4f5e797c1ea8c9',30,'mod_scorm','content',0,'/story_content/slides/','6ZFaSHXpN6g.swf',NULL,3858,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1470,'4547848e3818bc5f9ddfcea639a2c0680d4182d6','c5d35d50f34dc906140c4b3242e9544af524d70f',30,'mod_scorm','content',0,'/story_content/slides/','5qg9sf0vnDL.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1471,'3a5169587c0c95c78fd35edb20e8920e7aa411cd','de3291a4636333ae55c253d639b6aafcd6669a68',30,'mod_scorm','content',0,'/story_content/slides/','5tuIESB0GWL.swf',NULL,3840,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1472,'f1f377c966f5053e3c75afb8cc6d5e41c8fa52af','01921f431f0837e4586b71d2d5a2476a68f07244',30,'mod_scorm','content',0,'/story_content/slides/','6BgU9oKGDxv.swf',NULL,3855,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1473,'c14d95b0e2451facbd513e0cb098d458d5bbf26a','0b8b1272a228dff3a544c3ae7cf455ec9d0133a5',30,'mod_scorm','content',0,'/story_content/slides/','6WLrBwYnSS3.swf',NULL,3847,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1474,'e69fad3a09a7948bab92847ab387c61fafe536d4','b97b3ef894d71de4a6a2ee0725da72cb65837866',30,'mod_scorm','content',0,'/mobile/slides/','5tuIESB0GWL.gz',NULL,3548,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1475,'470d819f29bbc8901dda1f47beb3df186f39737a','092793f8a830f6ca4fb7838e5f49f8af27287a45',30,'mod_scorm','content',0,'/mobile/slides/','6ZFaSHXpN6g.gz',NULL,3565,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1476,'b608087fd5439e9a3b5364280494a7ceebf0bb0a','ef6b8b7c896e1ed44a817e059e5adf3738af0140',30,'mod_scorm','content',0,'/mobile/slides/','6NrG8jTUqMe.gz',NULL,3549,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1477,'c43dc18419a2f179e162f1d47baf5a73250a8843','603afa96058baa6d11723c6da3a6e81575f003f2',30,'mod_scorm','content',0,'/mobile/slides/','5qg9sf0vnDL.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1478,'6bd72a085a5f521e42538773eb92e6efb51eb640','682114963528ca0dc886d9610b7fcfa1d672bcec',30,'mod_scorm','content',0,'/mobile/slides/','6WLrBwYnSS3.gz',NULL,3554,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1479,'0e67f800820540fad90b328f361de8a65707add7','9cea968956d7e2e01585ee3ab4a391bfceb3bb14',30,'mod_scorm','content',0,'/mobile/slides/','6BgU9oKGDxv.gz',NULL,3564,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1480,'cd70facb5743611b132767e1f02cd0a1287d9718','17ad49597127558e2e78da6e307df6279eb81071',30,'mod_scorm','content',0,'/mobile/slides/','5qg9sf0vnDL.js',NULL,17574,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1481,'6c3c444996a724f0f6d625de49fe3d155dbe779e','d1b1f196347b8f6d482ccbdaa6789fbb19dac213',30,'mod_scorm','content',0,'/mobile/slides/','6NrG8jTUqMe.js',NULL,17558,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1482,'fb013382d1bbb1648b71da8d09738b1064862d41','f9e4f576e536da42b6bafc1f960447cccaead62c',30,'mod_scorm','content',0,'/mobile/slides/','5tuIESB0GWL.js',NULL,17562,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1483,'13317364a8b0e7caa7f86673aa451c93cbdfffb6','95604770ed23f357d5f9b74ddf93cea33b4edf1e',30,'mod_scorm','content',0,'/mobile/slides/','6WLrBwYnSS3.js',NULL,17572,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1484,'8bc7df84495e8a7577b98333fce4d4b2d9354459','0590745e97cf4eb8f5400f78a6296a037154e690',30,'mod_scorm','content',0,'/story_content/slides/','5af9VdM8K2B.swf',NULL,3849,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1485,'e7171ea5f7a5892fa4e2185093a208099578a002','47ca1766fb61ca116cd07570bb18eda9052744fe',30,'mod_scorm','content',0,'/mobile/slides/','5af9VdM8K2B.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1486,'e5cad196ae7bbd5cd8570d286c5b03b553cd1259','96059d1300eca5bb80e1dd6ec7168be4ebceccd5',30,'mod_scorm','content',0,'/mobile/slides/','6ZFaSHXpN6g.js',NULL,17582,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1487,'08dc5a888ca9eb4dcba3c95bc04fcb46b71ecb8f','faf4878ab22f551293bcf1ea1547eeaab58f54d7',30,'mod_scorm','content',0,'/mobile/slides/','6BgU9oKGDxv.js',NULL,17575,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1488,'2b047d3e4b8ce78d890ea040f7dcc54620a473e5','18e87374201c370e8a6d27b8b1200db24273e164',30,'mod_scorm','content',0,'/story_content/slides/','5W3eS6acLl1.swf',NULL,3840,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1489,'bef3f4ab1626921de70d9f69479f4e599d8ac979','6961105f20fa027ddc11f22a1dbfa2b2865521a2',30,'mod_scorm','content',0,'/story_content/slides/','6P1A9hkR8tK.swf',NULL,3848,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1490,'4055ef62bf2017c075ffcb8931171d8d7745edd0','cfec8a96091e1f2a979801828185152834e791b4',30,'mod_scorm','content',0,'/story_content/slides/','6cthD8J1N2K.swf',NULL,3875,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1491,'5afe02f59a28cb5f01d14dc2ab66dc3782846a2c','a131cd3ed654a615347d548d61346106c70fd7f6',30,'mod_scorm','content',0,'/mobile/slides/','5W3eS6acLl1.gz',NULL,3546,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1492,'3b1dae5edb366d584e4f39e183d288eee3493354','f64616e0cb255d94dc2b97f3168ed1aa4a2735d7',30,'mod_scorm','content',0,'/mobile/slides/','6P1A9hkR8tK.gz',NULL,3554,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1493,'f74be3a8191d13e30a64f62ba7d140d50b586c7c','6cff08ea07872f5fe2ccd89bf97d2031295cf2af',30,'mod_scorm','content',0,'/mobile/slides/','6cthD8J1N2K.gz',NULL,3581,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1494,'2ace5bbf2e9a6d9fc5c797a5a3ceb3c48e7b59fb','556996680165941f2e5db9f841b53afced2e8e97',30,'mod_scorm','content',0,'/story_content/slides/','5x3IcBxFlo4.swf',NULL,3836,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1495,'1398df1bc15fa600b93b0de33626103322345f4c','a1e2aa2eeef15fbf4d6c184018b7f4c55161de74',30,'mod_scorm','content',0,'/mobile/slides/','5x3IcBxFlo4.gz',NULL,3543,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1496,'36824a673bf18b9c5c2194ecd84837dd2cb0818c','76558803f563c9c9fcf989af54227a0270f47a3a',30,'mod_scorm','content',0,'/mobile/slides/','5af9VdM8K2B.js',NULL,17593,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1497,'6babc95615f53ac58a3fd340c263bc6ddf503545','1031ec5c95c897a32ab61c6f33bb3dafd356a70e',30,'mod_scorm','content',0,'/mobile/slides/','6P1A9hkR8tK.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1498,'3020cd66429cda028ceb13d2c3397a62b5210316','9b7472d5d526ba4e197117c0c20cf593c5c3e808',30,'mod_scorm','content',0,'/mobile/slides/','6cthD8J1N2K.js',NULL,17600,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1499,'99ec0f46f708965aabcac0469b2e3cfb798ac175','2ed9245cf8c649ca58fa87424e29418d71826764',30,'mod_scorm','content',0,'/mobile/slides/','5x3IcBxFlo4.js',NULL,17555,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1500,'fea507a43d0178ae612f078ccd000e2314950040','f1a88ebe9ba55389e3cc908c0e572186a890706f',30,'mod_scorm','content',0,'/story_content/slides/','6JzfNrXcIdB.swf',NULL,3846,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1501,'d05f0636c0e355f08a373d21948d20d9cc107f6e','b784bc856046709252a14272eb4ae3c3bb0b5df6',30,'mod_scorm','content',0,'/mobile/slides/','6JzfNrXcIdB.gz',NULL,3550,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1502,'c95231397017cd02556e39afaf2231ec5e31a4ed','3722498dbf5dc0bd980c082aaf3b9730213527f4',30,'mod_scorm','content',0,'/mobile/slides/','5W3eS6acLl1.js',NULL,17555,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1503,'57db3190c3bd831aa4acedb4529b6cbf0185f0db','4061f1e4de321f3f8bb44daae87d039574765d57',30,'mod_scorm','content',0,'/story_content/slides/','6J9YvS19N4v.swf',NULL,3859,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1504,'f4a095e943e1f723ba8a69091345ed2d9a9359be','9576df552d10a3f4fb71a9d33238c10d3aa2d29b',30,'mod_scorm','content',0,'/mobile/slides/','6J9YvS19N4v.gz',NULL,3567,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1505,'fffa6e32abf97d577a57512f0a8a4962cfd6217a','b5c2742e8f6d1224a8a4a9c92df7610371b6ce34',30,'mod_scorm','content',0,'/story_content/slides/','5dTXOZmPLzM.swf',NULL,3848,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1506,'d693ae3355afc0c2b13050f0513b54825bcf6007','2a1b70710fd67227bcfae008340081e7a73bdf61',30,'mod_scorm','content',0,'/mobile/slides/','5dTXOZmPLzM.gz',NULL,3554,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1507,'07eacb21065299bdefd03632135dd0d0792e277c','1a8b08effec01d87c6185eaa0c8cd5c9d6faa8df',30,'mod_scorm','content',0,'/story_content/slides/','6PkmYxmOelB.swf',NULL,3852,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1508,'ea2ba66f5d6a967dcb367e08e7d679deedab3b64','79345ade16fbc9ec15ed598a230000018d187df5',30,'mod_scorm','content',0,'/mobile/slides/','6PkmYxmOelB.gz',NULL,3558,'application/g-zip',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1509,'d734b9e60fce4212a96e2915a0bd9eedc2a69c5e','8c1cda3573fd5e73560b648e4382f489b928f642',30,'mod_scorm','content',0,'/mobile/slides/','6JzfNrXcIdB.js',NULL,17559,'application/x-javascript',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1510,'34d47094f3cb8e380f6de11a48b5e727aaa7bc85','0627fe252390ce67a64cb9c2dd12721637b507e9',30,'mod_scorm','content',0,'/story_content/slides/','5nprQj9Wrvo.swf',NULL,3852,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458065,1462458065,0,NULL),(1511,'43b161ee86c0d4bd4263605418e6cf59487cac62','a54c62e4005ed7f2a831f2d62f5de944214d2a94',30,'mod_scorm','content',0,'/mobile/slides/','5nprQj9Wrvo.gz',NULL,3556,'application/g-zip',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1512,'ebcfe408d4135eda6622cc65597c557d9e26cef6','63b5c8ab081494178a690ccf3a5881ebc5b8fc66',30,'mod_scorm','content',0,'/mobile/slides/','5dTXOZmPLzM.js',NULL,17558,'application/x-javascript',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1513,'3d878d9ae7e2ec6022ecf26c0e8ca8c0ce85d590','a281e4e907cc9ee72f2b3e3c628d578633189351',30,'mod_scorm','content',0,'/mobile/slides/','6J9YvS19N4v.js',NULL,17575,'application/x-javascript',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1514,'21fcbb459e7cbd87659a6f67a1ac69f591641a7f','10c03fd8c6753013c99442ac0c5e8b9ad4c45ba9',30,'mod_scorm','content',0,'/mobile/slides/','6PkmYxmOelB.js',NULL,17568,'application/x-javascript',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1515,'49c62d9416a8e4a397686e0c7d4aeb89c78c212d','e600700450406f1d7ab699edd1186d1eb1f06889',30,'mod_scorm','content',0,'/story_content/slides/','6nwl3hZjMuy.swf',NULL,3858,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1516,'bacd723b638c402e4e46653f52f398c71e2d0196','738749ba9e4bca4d068ed23ae23bfbd1607fee62',30,'mod_scorm','content',0,'/mobile/slides/','6nwl3hZjMuy.gz',NULL,3565,'application/g-zip',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1517,'83828532b76b5512a7647548a118a79a25f3f9da','eafc80745ec0516e3824564f0670fc5fe1f0156d',30,'mod_scorm','content',0,'/mobile/slides/','5nprQj9Wrvo.js',NULL,17563,'application/x-javascript',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1518,'2674e633926fbd149902dd808a7abd3c413c6d99','8f40536fb348ba635eb71abb1d145d5600823497',30,'mod_scorm','content',0,'/story_content/slides/','5vLDhgEw8JP.swf',NULL,3841,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1519,'f54f802cc78510fa2b6ab4e054c2b6377b32c629','17787cd57d033bf4852193226e49d4c2c3667ec6',30,'mod_scorm','content',0,'/mobile/slides/','5vLDhgEw8JP.gz',NULL,3548,'application/g-zip',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1520,'e4ef3fe0e44c27497e0d3147926af1fecc862dca','fe385b3e3100e824fab35b54dba465e20a948896',30,'mod_scorm','content',0,'/mobile/slides/','6nwl3hZjMuy.js',NULL,17572,'application/x-javascript',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1521,'faff59f86665b8800ef07e4833dcb121e4838d36','a62a85568dc6345231e97652c15828bc572105ac',30,'mod_scorm','content',0,'/story_content/slides/','6rYhSDXsFsq.swf',NULL,3850,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1522,'cb57589af837240f1acab24eb2088e1cb6e85e53','f07ddcec1e2eec1e9b36570f545f064f630721fb',30,'mod_scorm','content',0,'/mobile/slides/','6rYhSDXsFsq.gz',NULL,3557,'application/g-zip',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1523,'db565378084242bb2baab9c2af92b369b1dc1dcd','afa76cbe30b674a8d3aa5776a812044f30be01d7',30,'mod_scorm','content',0,'/mobile/slides/','5vLDhgEw8JP.js',NULL,17556,'application/x-javascript',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1524,'a81b7b38195ce8e2a7c0194bb68fdbab100e9c19','d34fb05500a6c62d4619be765d95d1d4038b4d57',30,'mod_scorm','content',0,'/story_content/slides/','6O7B8BZZ91S.swf',NULL,3856,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1525,'298926ef7754a3eba719e9289b515a1494755eb0','ae7922412bfa09a069eda063cd5cb6384ecb5de6',30,'mod_scorm','content',0,'/mobile/slides/','6O7B8BZZ91S.gz',NULL,3560,'application/g-zip',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1526,'b02595ffe5b45e5c4fff51d174b3630c1edd7c14','2a9a5f65869f214c6597875cb5704faa070431d2',30,'mod_scorm','content',0,'/mobile/slides/','6rYhSDXsFsq.js',NULL,17567,'application/x-javascript',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1527,'105d134a73b4b3ff6dea5957bc927ab0df4eefdc','2f664bd2bad12a3e9c12da84d41e77bfbd1d04a3',30,'mod_scorm','content',0,'/story_content/slides/','6jUfFl15K5a.swf',NULL,3847,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1528,'3943c44b6c953aaa433a87c943e9ff9572098d61','9d7f02baf30b16fa0a9d2f2711ee09633b7825ba',30,'mod_scorm','content',0,'/mobile/slides/','6jUfFl15K5a.gz',NULL,3551,'application/g-zip',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1529,'c9e40c46d9b6902d0fd21d90d6460c1e74f59ac2','62a7d6aca0659fc909d0e01de06fbbbd7e935e57',30,'mod_scorm','content',0,'/mobile/slides/','6O7B8BZZ91S.js',NULL,17568,'application/x-javascript',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1530,'7fe9606775167ce607eb9f15a1fb91a43659d480','644c06f7d88852774720c24d5a390fa6b0c2fc23',30,'mod_scorm','content',0,'/story_content/slides/','67Z9Ln5Pt3R.swf',NULL,3844,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1531,'7202c5d32a6c615c604fb34ca0e42537718af028','b1766950d2ba400d16088ab912a3d09656921704',30,'mod_scorm','content',0,'/mobile/slides/','67Z9Ln5Pt3R.gz',NULL,3552,'application/g-zip',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1532,'b2fd9dd3ca906b2929c8117df54c5cfdd4d91b72','5312be48552dd72b9813bc51359fe1db199401dd',30,'mod_scorm','content',0,'/mobile/slides/','6jUfFl15K5a.js',NULL,17566,'application/x-javascript',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1533,'d2a3e40fa3cccab5ece38b9ef463b7617d0a8052','ba910779598879a971edb32585a08f936d7b1981',30,'mod_scorm','content',0,'/story_content/slides/','5wcXifntxBH.swf',NULL,3849,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1534,'83f6a3439eccd0204d5082685423e1566d5fd245','ffcb55ae23f0e12c7d33f7837b62b626b8f2f758',30,'mod_scorm','content',0,'/mobile/slides/','5wcXifntxBH.gz',NULL,3555,'application/g-zip',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1535,'a92df95548b871c30ce048ca585a91a5332024eb','b31cd9934357a9bfec0f30d8f278dd68eb3b6608',30,'mod_scorm','content',0,'/mobile/slides/','67Z9Ln5Pt3R.js',NULL,17556,'application/x-javascript',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1536,'ae6e746984de48251eb6477c78df3672d7da8afe','26f32622933508e877a98161f8f45139643a37db',30,'mod_scorm','content',0,'/story_content/slides/','6nKncQ6Ysx8.swf',NULL,3852,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1537,'60067f8910ab84653e552298a0dca17e38088702','da8d12e845655c467925f123017a2521ae9aebc8',30,'mod_scorm','content',0,'/mobile/slides/','6nKncQ6Ysx8.gz',NULL,3558,'application/g-zip',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1538,'e8697b8b03935aed054c014c5a86f46737029922','82ac47bbb76cced77431a2426698a48f3bc23686',30,'mod_scorm','content',0,'/mobile/slides/','5wcXifntxBH.js',NULL,17568,'application/x-javascript',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1539,'a3ffbffd4f31bf348f1e647ac2e2f7b26f6e4b1e','e2900f19e62d0db1439b5498a5448ed1b9f35c2b',30,'mod_scorm','content',0,'/story_content/slides/','5VHW3rvxKuK.swf',NULL,3847,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1540,'48e5bcff7d42f323642f7120dd1f720eed604afb','8090360379b4f13621dcf3f0b0bc595fb7db3df6',30,'mod_scorm','content',0,'/mobile/slides/','5VHW3rvxKuK.gz',NULL,3553,'application/g-zip',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1541,'b55baf8eb96c6af8429e1b358be0a8dd3c6f7b8f','b3ed2fe5b4661896138a46dff63f4321939f7d82',30,'mod_scorm','content',0,'/mobile/slides/','6nKncQ6Ysx8.js',NULL,17568,'application/x-javascript',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1542,'4faa7bfbf796a6fb44c29fe953b0f8e8005e66ec','7d48749103f21446c101e01f38f3c2b294ea9f0f',30,'mod_scorm','content',0,'/story_content/slides/','5lPQuOqRLSi.swf',NULL,3843,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1543,'62f6d858a72d1ca35708d80e1b152388b6023c84','561eaf73a1192e92f1ae0279a085f3dd3504bb05',30,'mod_scorm','content',0,'/mobile/slides/','5lPQuOqRLSi.gz',NULL,3549,'application/g-zip',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1544,'278c9a3b1cb7432d6af4ef695ef97fb5a6bd8806','a128f428af17720f0324a1050b57045669c6a852',30,'mod_scorm','content',0,'/mobile/slides/','5VHW3rvxKuK.js',NULL,17573,'application/x-javascript',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1545,'21115c6fbfbfe367234ad81e8a8dc55bf07faf0b','2bef15061cf9057f04d57fa1302a45ae9f998b1a',30,'mod_scorm','content',0,'/mobile/slides/','5lPQuOqRLSi.js',NULL,17555,'application/x-javascript',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1546,'469f726402c0f976cec7b31f35ae4818e8382bce','d7c06df3df358b1177a32e61435011bfd021fae6',30,'mod_scorm','content',0,'/story_content/slides/','6nFIyb8drBx.swf',NULL,3844,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1547,'7b26b8fa56f1c09510bf262aee0f4cced394d84b','b265ad6e5ff7b7d5bdcb78207e88e8e51d9de59c',30,'mod_scorm','content',0,'/mobile/slides/','6nFIyb8drBx.gz',NULL,3551,'application/g-zip',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1548,'5d81e5a65d9bf6f6660380efee28e154256223e3','5fe3f3e075688a88b0d5e34015bb1bfe0468785c',30,'mod_scorm','content',0,'/mobile/slides/','6nFIyb8drBx.js',NULL,17556,'application/x-javascript',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1549,'ffff394817b0b53900b5377dbe7a9e557c0beb77','58d854cfaf5de28df7785c6f371ef65d5f50ebed',30,'mod_scorm','content',0,'/story_content/','data.swf',NULL,97481,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1550,'ee4f7e446fc06d5e7ad1274ccb9766daf60dcbde','8431e12bf034d9355e499eb8519ddf928203759e',30,'mod_scorm','content',0,'/mobile/','data.gz',NULL,97114,'application/g-zip',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1551,'3e5988f3d9de2f7a027b35fc0320fd885341129a','895abcca99634ab2cd67d5e0b2a52a42609380ff',30,'mod_scorm','content',0,'/mobile/','data.js',NULL,679956,'application/x-javascript',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1552,'d49690931551d8cc21391e125cbb373d520b94db','b2def48e613c9cbe3cb48b5c23f8788de663177a',30,'mod_scorm','content',0,'/mobile/','masks.js',NULL,27,'application/x-javascript',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1553,'b4a551960cae55536581ea3e4d361d342dac1da5','d8c160c5b766c60a628e0814279605694f3692f2',30,'mod_scorm','content',0,'/','story.html',NULL,4075,'text/html',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1554,'6ce349c16b0dd068005ad3cf77d19a8eb1d59ca1','971cb33e3ac3ffbdbc39bc31b86285a71ef2b77c',30,'mod_scorm','content',0,'/','story_html5.html',NULL,5375,'text/html',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1555,'6c9571ce0e4d1d916330af2a1bbd1e1dc700dea9','782358c9776f6d92bd1771121e0e93e6c5915373',30,'mod_scorm','content',0,'/','index_lms_html5.html',NULL,6758,'text/html',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1556,'e8891e6f832a634d235d552561645e673aad9456','834c52e4bcaae9e70e942cfb6999af8f3903d198',30,'mod_scorm','content',0,'/story_content/','blank.html',NULL,85,'text/html',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1557,'b44ca16c543ac7b9f2ab380cb2780e9ff3ac0cdc','55757b180cef0959617de968890c8d92dda3b2e2',30,'mod_scorm','content',0,'/story_content/','story.js',NULL,44273,'application/x-javascript',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1558,'ddf8c98ed3773963a10e21ec48abb00fa1d343dd','34a97e5a53b8b79ebb9f31ddbdfd107d66ed4557',30,'mod_scorm','content',0,'/','amplaunch.html',NULL,5437,'text/html',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1559,'228e05948d3fe215363bac9c3e4bee4b5bbcf01a','599febfca1f98cdd5d7c36efa1aada2f626d131b',30,'mod_scorm','content',0,'/mobile/','mobileinstall.html',NULL,3988,'text/html',0,NULL,NULL,NULL,1462458066,1462458066,0,NULL),(1560,'b5281975f3d2d0172b3fea270f5712324e053e26','9d2c2bbe0d698572e37561042e9443bde5ba05b4',30,'mod_scorm','content',0,'/','index_lms.html',NULL,2137,'text/html',0,NULL,NULL,NULL,1462458067,1462458067,0,NULL),(1561,'8ac1cbb661d986aa714a7771a41781d47fac4b80','1d15dbff097a20b8fa5bdfcd614be9977db4d289',30,'mod_scorm','content',0,'/lms/','AICCComm.html',NULL,20475,'text/html',0,NULL,NULL,NULL,1462458067,1462458067,0,NULL),(1562,'da39a3ee5e6b4b0d3255bfef95601890afd80709','c18b79b122bef4b5f3516d2327b2db847c59762f',30,'mod_scorm','content',0,'/lms/','.',NULL,0,NULL,0,NULL,NULL,NULL,1462458067,1462458067,0,NULL),(1563,'24d3301e5f14b21edae14a17b5114cb4db230067','baaf1e3b356d4b660261823de74006ac3567f8d6',30,'mod_scorm','content',0,'/lms/','AICCFunctions.js',NULL,85090,'application/x-javascript',0,NULL,NULL,NULL,1462458067,1462458067,0,NULL),(1564,'cf9ed6b3b698cc8610f47f313873222f90bb106b','329bd080e0529e90d827fa766ee3732e7d776f73',30,'mod_scorm','content',0,'/lms/','API.js',NULL,72759,'application/x-javascript',0,NULL,NULL,NULL,1462458067,1462458067,0,NULL),(1565,'8f90339d30498127ef8000add74f638cc7e4b8fb','33c041deb6bdb47244f3afa6fe5ffa6687d6e152',30,'mod_scorm','content',0,'/lms/','APIConstants.js',NULL,2015,'application/x-javascript',0,NULL,NULL,NULL,1462458067,1462458067,0,NULL),(1566,'efdad4dc3f96e694fad7d5f27a9cb74cd6b57ddd','75847e68493df7ca09b41a164f12cbb58668ea20',30,'mod_scorm','content',0,'/lms/','blank.html',NULL,1240,'text/html',0,NULL,NULL,NULL,1462458067,1462458067,0,NULL),(1567,'8bb344d9bd78341e3c757f5e7af27916310296b0','33c59d3579497f3b2a32ae3d1ae2331ec30ab473',30,'mod_scorm','content',0,'/lms/','browsersniff.js',NULL,10790,'application/x-javascript',0,NULL,NULL,NULL,1462458067,1462458067,0,NULL),(1568,'46857629beaebd6d65111d468ff806826d9d0da8','49c7a5e0024f44cbf2bba411b8dfb3f0d87d8ac7',30,'mod_scorm','content',0,'/lms/','Configuration.js',NULL,4416,'application/x-javascript',0,NULL,NULL,NULL,1462458067,1462458067,0,NULL),(1569,'3caef8283a0c69db3730e3082b904fe7ee5cfd8c','c884d8415ea88a280064b185a78c093bcf6c4239',30,'mod_scorm','content',0,'/lms/','goodbye.html',NULL,210,'text/html',0,NULL,NULL,NULL,1462458067,1462458067,0,NULL),(1570,'0114fd96f2cd750d042bc9739c80638c79185021','3ff55b5cfe98d89bc9ae95ad3765d2f96f03d5af',30,'mod_scorm','content',0,'/lms/','lms.js',NULL,11430,'application/x-javascript',0,NULL,NULL,NULL,1462458067,1462458067,0,NULL),(1571,'8d5006852d52737b26a9157948655ef502aa024b','74889587633092dd623f4bb45f7dbfb3b09839ab',30,'mod_scorm','content',0,'/lms/','LMSAPI.js',NULL,5636,'application/x-javascript',0,NULL,NULL,NULL,1462458067,1462458067,0,NULL),(1572,'5217d6bbc0dcd20b0a8713f743138320902ab090','9c1632b2fa63d9c42cd7909c55e9370492337e15',30,'mod_scorm','content',0,'/lms/','NONEFunctions.js',NULL,11384,'application/x-javascript',0,NULL,NULL,NULL,1462458067,1462458067,0,NULL),(1573,'31b7ed1337c0aa2a3fc6834f732dfd20dae070c0','4ecb077e3c23cfde95175cddca5740026e7219c8',30,'mod_scorm','content',0,'/lms/','SCORM2004Functions.js',NULL,77942,'application/x-javascript',0,NULL,NULL,NULL,1462458067,1462458067,0,NULL),(1574,'9fff918d5f90d4d2d3d6c51c36e14d4858efdf80','94bec0dbdd21a8dcb635b99b2dbbaf755f5d3dfe',30,'mod_scorm','content',0,'/lms/','SCORMFunctions.js',NULL,62404,'application/x-javascript',0,NULL,NULL,NULL,1462458067,1462458067,0,NULL),(1575,'722d71c1dd23f3267e83008f63e927ca632fa6b5','48455fa404244cb0bf33b53468855478e782cfe0',30,'mod_scorm','content',0,'/lms/','UtilityFunctions.js',NULL,20533,'application/x-javascript',0,NULL,NULL,NULL,1462458067,1462458067,0,NULL),(1576,'ac1c260262e8011a1766eda642dfbf4804303112','918fd22f1d96f628ad27dd1051a9674e017656e6',30,'mod_scorm','content',0,'/','adlcp_rootv1p2.xsd',NULL,4508,'document/unknown',0,NULL,NULL,NULL,1462458067,1462458067,0,NULL),(1577,'3213c0f4244e63cb1a1ce86e277d74da6160566c','194c8e13448829765e9d74bb6f4b14cb2de25481',30,'mod_scorm','content',0,'/','imscp_rootv1p1p2.xsd',NULL,14905,'document/unknown',0,NULL,NULL,NULL,1462458067,1462458067,0,NULL),(1578,'1299d984ea03036c209b388e625633540a395a33','4a3b57444a1fdbe809859e423eb424de09c37564',30,'mod_scorm','content',0,'/','imsmanifest.xml',NULL,87305,'application/xml',0,NULL,NULL,NULL,1462458067,1462458067,0,NULL),(1579,'f463a5b20626953aaacdb510440d32d39b6e54e8','6d1f798d208587f0b678abf375ab95ccf61addf0',30,'mod_scorm','content',0,'/','imsmd_rootv1p2p1.xsd',NULL,22769,'document/unknown',0,NULL,NULL,NULL,1462458067,1462458067,0,NULL),(1580,'6182547b719732a400e8e2e10271f56d6f444b27','007069c08a67a13aca7bc9eec87a57c9b43b9084',30,'mod_scorm','content',0,'/','ims_xml.xsd',NULL,1213,'document/unknown',0,NULL,NULL,NULL,1462458067,1462458067,0,NULL),(1581,'57364dfe033e61a122409fca8fff131851d85f61','2bb133a1e3aa7f6f1045030e4eceb2ec33e791f1',5,'user','draft',227533708,'/','Scavenger_Hunt.zip',2,7460988,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:18:\"Scavenger_Hunt.zip\";s:8:\"original\";s:228:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTozMDtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MTg6IlNjYXZlbmdlcl9IdW50LnppcCI7fQ==\";}','Admin User','allrightsreserved',1462457889,1462458050,0,NULL),(1582,'da39a3ee5e6b4b0d3255bfef95601890afd80709','4c38d8ec223a793ed668bc5c10370f233c33c7f7',5,'user','draft',227533708,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462458123,1462458123,0,NULL),(1583,'57364dfe033e61a122409fca8fff131851d85f61','54ef7e2fa38504f00d1703aab0ba204baf09cb77',5,'user','draft',99361582,'/','Scavenger_Hunt.zip',2,7460988,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:18:\"Scavenger_Hunt.zip\";s:8:\"original\";s:228:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTozMDtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MTg6IlNjYXZlbmdlcl9IdW50LnppcCI7fQ==\";}','Admin User','allrightsreserved',1462457889,1462458050,0,NULL),(1584,'da39a3ee5e6b4b0d3255bfef95601890afd80709','82f6dae0eebfcfc555db4a9e8a2eeaad2403f020',5,'user','draft',99361582,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462458123,1462458123,0,NULL),(1587,'57364dfe033e61a122409fca8fff131851d85f61','d13b20aaa36f3af4f6be93a911efb1e55435df9b',5,'user','draft',92341131,'/','Scavenger_Hunt.zip',2,7460988,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:18:\"Scavenger_Hunt.zip\";s:8:\"original\";s:228:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTozMDtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MTg6IlNjYXZlbmdlcl9IdW50LnppcCI7fQ==\";}','Admin User','allrightsreserved',1462457889,1462458179,0,NULL),(1588,'da39a3ee5e6b4b0d3255bfef95601890afd80709','71856f941999bf518148b82b45d7eda5759b4ee4',5,'user','draft',92341131,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462458267,1462458267,0,NULL),(1589,'57364dfe033e61a122409fca8fff131851d85f61','c9887f78c3a436dba53663d5b02117ad790ffcb3',5,'user','draft',327454030,'/','Scavenger_Hunt.zip',2,7460988,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:18:\"Scavenger_Hunt.zip\";s:8:\"original\";s:228:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTozMDtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MTg6IlNjYXZlbmdlcl9IdW50LnppcCI7fQ==\";}','Admin User','allrightsreserved',1462457889,1462458179,0,NULL),(1590,'da39a3ee5e6b4b0d3255bfef95601890afd80709','47d67fa5614bf187375eea7cf4323cb4a42e54dd',5,'user','draft',327454030,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462458267,1462458267,0,NULL),(1593,'57364dfe033e61a122409fca8fff131851d85f61','b8a6d41f048902b6485dc5db188b807f120d76f8',5,'user','draft',89372802,'/','Scavenger_Hunt.zip',2,7460988,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:18:\"Scavenger_Hunt.zip\";s:8:\"original\";s:228:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTozMDtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MTg6IlNjYXZlbmdlcl9IdW50LnppcCI7fQ==\";}','Admin User','allrightsreserved',1462457889,1462458292,0,NULL),(1594,'da39a3ee5e6b4b0d3255bfef95601890afd80709','8229378389d3373d73c34b215b8dc0cc73a3c0e8',5,'user','draft',89372802,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462458324,1462458324,0,NULL),(1595,'57364dfe033e61a122409fca8fff131851d85f61','40d2a8bc8b31b64c63b23a1b55865fd0b5efc70b',5,'user','draft',8024963,'/','Scavenger_Hunt.zip',2,7460988,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:18:\"Scavenger_Hunt.zip\";s:8:\"original\";s:228:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTozMDtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MTg6IlNjYXZlbmdlcl9IdW50LnppcCI7fQ==\";}','Admin User','allrightsreserved',1462457889,1462458292,0,NULL),(1596,'da39a3ee5e6b4b0d3255bfef95601890afd80709','05dbbc8568f18a0cacdb8dbc078df8a46e7a76d4',5,'user','draft',8024963,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462458324,1462458324,0,NULL),(1599,'57364dfe033e61a122409fca8fff131851d85f61','ca57a5caf60d5fb7932821ef14678ca784a309b3',5,'user','draft',563699986,'/','Scavenger_Hunt.zip',2,7460988,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:18:\"Scavenger_Hunt.zip\";s:8:\"original\";s:228:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTozMDtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MTg6IlNjYXZlbmdlcl9IdW50LnppcCI7fQ==\";}','Admin User','allrightsreserved',1462457889,1462458354,0,NULL),(1600,'da39a3ee5e6b4b0d3255bfef95601890afd80709','5f59ea036ebff1858f44a148a1f898f885c2e352',5,'user','draft',563699986,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462458386,1462458386,0,NULL),(1601,'57364dfe033e61a122409fca8fff131851d85f61','8b5ed11c11f9716d50709ca0d976e532fa97a48a',5,'user','draft',585461785,'/','Scavenger_Hunt.zip',2,7460988,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:18:\"Scavenger_Hunt.zip\";s:8:\"original\";s:228:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTozMDtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MTg6IlNjYXZlbmdlcl9IdW50LnppcCI7fQ==\";}','Admin User','allrightsreserved',1462457889,1462458354,0,NULL),(1602,'da39a3ee5e6b4b0d3255bfef95601890afd80709','5f033f6fae199dd5f1773a6154bbb3452f0dde38',5,'user','draft',585461785,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462458386,1462458386,0,NULL),(1605,'f5b4a7301c6c19fe18f2f0cce970eccf1abba9cf','d23771814d32ed3b1a0c372eeef23a3a8a126b35',5,'user','draft',142036548,'/','teststudentaccount.csv',2,209,'text/csv',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:22:\"teststudentaccount.csv\";}','Admin User','allrightsreserved',1462542168,1462542168,0,NULL),(1606,'da39a3ee5e6b4b0d3255bfef95601890afd80709','6fe9a7b242372ff3f574b71883b206d41f1e6429',5,'user','draft',142036548,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462542168,1462542168,0,NULL),(1607,'57364dfe033e61a122409fca8fff131851d85f61','875c9c581e53fd37280b4675ca7999e90904b31e',5,'user','draft',663767000,'/','Scavenger_Hunt.zip',2,7460988,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:18:\"Scavenger_Hunt.zip\";s:8:\"original\";s:228:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTozMDtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MTg6IlNjYXZlbmdlcl9IdW50LnppcCI7fQ==\";}','Admin User','allrightsreserved',1462457889,1462458410,0,NULL),(1608,'da39a3ee5e6b4b0d3255bfef95601890afd80709','4b254197dad8644f8c66fdf81532543aea440608',5,'user','draft',663767000,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462542744,1462542744,0,NULL),(1609,'57364dfe033e61a122409fca8fff131851d85f61','57d990ebb224c8986af53e44c33aece24ee5fbe7',5,'user','draft',83243714,'/','Scavenger_Hunt.zip',2,7460988,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:18:\"Scavenger_Hunt.zip\";s:8:\"original\";s:228:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTozMDtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MTg6IlNjYXZlbmdlcl9IdW50LnppcCI7fQ==\";}','Admin User','allrightsreserved',1462457889,1462458410,0,NULL),(1610,'da39a3ee5e6b4b0d3255bfef95601890afd80709','a53158f9b61b88f29c5bb4726da55670e2aaf56d',5,'user','draft',83243714,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462542744,1462542744,0,NULL),(1613,'57364dfe033e61a122409fca8fff131851d85f61','58a5bc0b3f7cfda0523b23bd5900d7fded3cd2cf',5,'user','draft',863738000,'/','Scavenger_Hunt.zip',2,7460988,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:18:\"Scavenger_Hunt.zip\";s:8:\"original\";s:228:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTozMDtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MTg6IlNjYXZlbmdlcl9IdW50LnppcCI7fQ==\";}','Admin User','allrightsreserved',1462457889,1462542850,0,NULL),(1614,'da39a3ee5e6b4b0d3255bfef95601890afd80709','bb2c34376d7af8007a5301582d28e66ce9ddc629',5,'user','draft',863738000,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462543054,1462543054,0,NULL),(1615,'57364dfe033e61a122409fca8fff131851d85f61','0990c636d3151d204f7d4bde74a747dcfdc6d74f',5,'user','draft',676171230,'/','Scavenger_Hunt.zip',2,7460988,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:18:\"Scavenger_Hunt.zip\";s:8:\"original\";s:228:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTozMDtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MTg6IlNjYXZlbmdlcl9IdW50LnppcCI7fQ==\";}','Admin User','allrightsreserved',1462457889,1462542850,0,NULL),(1616,'da39a3ee5e6b4b0d3255bfef95601890afd80709','dd92c8226fa2f3ae1c0343cfc343e102b5aa5690',5,'user','draft',676171230,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462543054,1462543054,0,NULL),(1619,'7cb3bc0b97ae5d8f045b2897096001df0c3e118f','327f53f600f775d569d3832144b22055ca18ead9',5,'user','draft',988045161,'/','test_res.zip',2,983555,'application/zip',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:12:\"test_res.zip\";}','Admin User','allrightsreserved',1462543754,1462543754,0,NULL),(1620,'da39a3ee5e6b4b0d3255bfef95601890afd80709','f39bf7aa4d701fd7bd3b8762f16a86e86cbb50bb',5,'user','draft',988045161,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462543754,1462543754,0,NULL),(1621,'7cb3bc0b97ae5d8f045b2897096001df0c3e118f','6a4fbbfa0e4711660ade9b2c903d667d10527f42',38,'mod_scorm','package',0,'/','test_res.zip',2,983555,'application/zip',0,'test_res.zip','Admin User','allrightsreserved',1462543754,1462543851,0,NULL),(1622,'da39a3ee5e6b4b0d3255bfef95601890afd80709','9b658adaf6bbfd3e1a61fc0cddc5292d942b3615',38,'mod_scorm','package',0,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462543754,1462543851,0,NULL),(1623,'c44e845a83c8fd6d4b34222f7281c63fac3c6598','f3dff4163879b0f97da58a8432486c57eabaa617',38,'mod_scorm','content',0,'/story_content/','thumbnail.jpg',NULL,19425,'image/jpeg',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1624,'da39a3ee5e6b4b0d3255bfef95601890afd80709','3182682becdbd83a2a38c29fec6d9a939b8be5e6',38,'mod_scorm','content',0,'/story_content/','.',NULL,0,NULL,0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1625,'da39a3ee5e6b4b0d3255bfef95601890afd80709','27e083ee64af3fb227546c5835bc9303a014a1e6',38,'mod_scorm','content',0,'/','.',NULL,0,NULL,0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1626,'725a32d6d8ca2b4e50a618b7021065dc32345d78','549343c9e86eeaa73466fe16051dfdf2886e4683',38,'mod_scorm','content',0,'/','meta.xml',NULL,764,'application/xml',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1627,'1dac40233d17fd9aac319d0b620457b2de8516db','14b69552682ad3ff0ed2fe88be1d2b300cc3b22b',38,'mod_scorm','content',0,'/story_content/','frame.xml',NULL,26679,'application/xml',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1628,'44f83a56d6ddc53dee45ef1f50e02c25ebbddc52','7c520ae229560e492ec865534f0c56d69896cad5',38,'mod_scorm','content',0,'/story_content/','frame.js',NULL,17233,'application/x-javascript',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1629,'c6cc03a4c6ee98abcb81d7dcd0e723d8e34f7f1a','5e59bed760aa2d6a26dba73d9e33da47283baccc',38,'mod_scorm','content',0,'/story_content/','user.js',NULL,30,'application/x-javascript',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1630,'3f7b1c9832640d709ca955a6f638bd4203bcf6c4','642195df9d91711067a1f944662d9b79ad1917fd',38,'mod_scorm','content',0,'/mobile/','app_store.png',NULL,4587,'image/png',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1631,'da39a3ee5e6b4b0d3255bfef95601890afd80709','2dd18cbefd09864211fdbe47dbfb9c3a0073bc27',38,'mod_scorm','content',0,'/mobile/','.',NULL,0,NULL,0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1632,'8574782cf40d97051befab6af065a2557ee16475','0169a096b97b4a5bec0fb38aec2491557ba9c37f',38,'mod_scorm','content',0,'/mobile/','mobile_icon.png',NULL,9726,'image/png',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1633,'52c09f553fe9ad08c63636cf8ed59bd28919ef3b','f89f914beebdaa0c47b40dae233c87b5c02ae081',38,'mod_scorm','content',0,'/mobile/','linen_background.jpg',NULL,606,'image/jpeg',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1634,'1b0bc2712eab97692a1717c5df60188d71f8e645','c42955d971f4827ee2f90e3ce0ced9c2ce98f7e7',38,'mod_scorm','content',0,'/','story_unsupported.html',NULL,366,'text/html',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1635,'2f8900cc0ffc1c8dfcb1de49b2b650cd1806408f','1d3e809e4c1978614fe332b5e9f9bedd6cc970c5',38,'mod_scorm','content',0,'/mobile/','player.css',NULL,69936,'text/css',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1636,'d56ec6538d5ba6cf5ce7d0d9f56205583c38ee1d','fb0b3bf575e98d9b00b4bb3c45546536f9edf776',38,'mod_scorm','content',0,'/mobile/','player_compiled.js',NULL,882853,'application/x-javascript',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1637,'82df31b1050050c74d71e17e9bd83c98083cd5ad','e4cbf997e5c66a90e291295909bf7c91fd3ab083',38,'mod_scorm','content',0,'/story_content/','FontFactory.swf',NULL,21219,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1638,'90ba75786334ab5229b300383965238d40ef1890','0fd1645c1684846f3112416103bb1bcc49ad6d9c',38,'mod_scorm','content',0,'/story_content/','fonts.swf',NULL,6793,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1639,'2e525c67190bb9a7b05f4db4d229e9c7e6c04457','b034d99f14d793166e6e34520cc3330a425293ca',38,'mod_scorm','content',0,'/story_content/','fonts.xml',NULL,11267,'application/xml',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1640,'30cf0027e750083d72bb1645fa53fa9a848a013d','1379f0ddb38e8fe0dde029f9d1d6f4d7921ca33e',38,'mod_scorm','content',0,'/mobile/','fonts.js',NULL,13206,'application/x-javascript',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1641,'33b43fe16959618f688e84749a2e27d863167cf4','b7e68645cfe3b3528bbe9d5a289c92000d791c38',38,'mod_scorm','content',0,'/','story.swf',NULL,404743,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1642,'a7e4d4239ee2d438e82c38a2d85c9b3387c11e1a','ba7a424ddeef69b18707c0d1d4ebfe3ee18844da',38,'mod_scorm','content',0,'/story_content/','frame.swf',NULL,110566,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1643,'a4f3b66ca9209008193571b069b18a348e5c278a','baa921e9b36b2f03701c20660a323ee80bd7663c',38,'mod_scorm','content',0,'/story_content/slides/','6jbxQgh9lfa.swf',NULL,2109,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1644,'da39a3ee5e6b4b0d3255bfef95601890afd80709','a9693718c90a0430077a0e9511922a5901008f37',38,'mod_scorm','content',0,'/story_content/slides/','.',NULL,0,NULL,0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1645,'8a7643884b14329f10bfafd850fd5b2093985d9a','065fe3d37d17ea5154ea1ed87714e800e038c3d9',38,'mod_scorm','content',0,'/mobile/slides/','6jbxQgh9lfa.gz',NULL,1829,'application/g-zip',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1646,'da39a3ee5e6b4b0d3255bfef95601890afd80709','e1c4feab8f97b754705a08527cd5c7813ebfc1d0',38,'mod_scorm','content',0,'/mobile/slides/','.',NULL,0,NULL,0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1647,'3a38706e966d0520e122c80b5162dafd31d01a85','e069c9f24515f6755ecc9c092550072759feaaa3',38,'mod_scorm','content',0,'/story_content/slides/','6iS78tBk5w8.swf',NULL,3323,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1648,'b62e9ca387dc869983c0aa18bfca00a6c37b0bc4','3eebaa962b7f7d76a17e2aebc844a3acf70635f7',38,'mod_scorm','content',0,'/mobile/slides/','6iS78tBk5w8.gz',NULL,3034,'application/g-zip',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1649,'3868faa8c62649b07078e92efbbdb0fbd267fbd4','24b76692a46366af12bc8f1e1af6ba8325426630',38,'mod_scorm','content',0,'/story_content/slides/','6HJKpzAfqs0.swf',NULL,4391,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1650,'ade057bac3fa69f83ebdac594652bec267488e79','c6db512b8afcf5f9947fb19f69867604b92f3ca6',38,'mod_scorm','content',0,'/mobile/slides/','6HJKpzAfqs0.gz',NULL,4094,'application/g-zip',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1651,'b5d3d927800b62e1f89f5996c913b9bce62867ae','76f92c0075e4bf116abdfe7103acab331ec93cb4',38,'mod_scorm','content',0,'/mobile/slides/','6jbxQgh9lfa.js',NULL,8658,'application/x-javascript',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1652,'ca753e2581d3f1a80a0b7137ead2a65a302b4ceb','49f99c47d1144986044caa8201601aeecc4c9880',38,'mod_scorm','content',0,'/mobile/slides/','6iS78tBk5w8.js',NULL,14558,'application/x-javascript',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1653,'1f92a2ecb377e2593b109ebec49edf515bc532d7','2fa9e17783f850daaaff8fc8b8dab451ce61c457',38,'mod_scorm','content',0,'/mobile/slides/','6HJKpzAfqs0.js',NULL,27419,'application/x-javascript',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1654,'edbd98ab2f67f73da7489030c2450417377111c1','90cf6238774cbd71e431eecf6f80ffa400bcb6a5',38,'mod_scorm','content',0,'/story_content/','data.swf',NULL,6489,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1655,'4218eb0cdf0cc1cb27abf3aa875929246586653c','335ff7fe569a787a5109bed466596be1e9c4f070',38,'mod_scorm','content',0,'/mobile/','data.gz',NULL,6184,'application/g-zip',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1656,'e0e9d7fac6d25484f63cc2cc9092b916ff446077','3d778ce236d28361de1e88e87df2e79f184e736e',38,'mod_scorm','content',0,'/mobile/','data.js',NULL,32658,'application/x-javascript',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1657,'d49690931551d8cc21391e125cbb373d520b94db','305859a4fa8b2d05e04ce9122fcce09edd0ca59f',38,'mod_scorm','content',0,'/mobile/','masks.js',NULL,27,'application/x-javascript',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1658,'bb1468262020389590272e91d45eddf7a9b947ae','ba4847fc64f7211d8c970050fac6f2cf25f99c02',38,'mod_scorm','content',0,'/','story.html',NULL,4069,'text/html',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1659,'f99aebdfb141354c5264ddc96d53edff93b95a66','af549c43004a4cd0160504b36bbb07c7b44a8779',38,'mod_scorm','content',0,'/','story_html5.html',NULL,5363,'text/html',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1660,'39da761e2b37d621e98e96a956a0f93273cfdd7f','431db0eb022354cba43c611fc9c17aa0df743219',38,'mod_scorm','content',0,'/','index_lms_html5.html',NULL,6752,'text/html',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1661,'e8891e6f832a634d235d552561645e673aad9456','087bb4b2d2bd7dab5bb9848b9433f8a0ab7193e4',38,'mod_scorm','content',0,'/story_content/','blank.html',NULL,85,'text/html',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1662,'b44ca16c543ac7b9f2ab380cb2780e9ff3ac0cdc','16cd53aa1a26d13822b0f8b6434e082ef8771b7f',38,'mod_scorm','content',0,'/story_content/','story.js',NULL,44273,'application/x-javascript',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1663,'91416202ebe27b085b9e77e863d8f756bcf37ca5','3b9953312c1b6043e363f7bdac83cf67dabb8bf6',38,'mod_scorm','content',0,'/','amplaunch.html',NULL,5425,'text/html',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1664,'992bd5f15bd38ad1e2f9d03cb0a497ee65e29ab4','38eba06ef54afbe216d4c63f6c46f8fae81b749f',38,'mod_scorm','content',0,'/mobile/','mobileinstall.html',NULL,3982,'text/html',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1665,'1bbd81f0fd47631a4515187e5e4823f613015500','524c1919e0178ace1efcf6731e6439b05db3cec1',38,'mod_scorm','content',0,'/','index_lms.html',NULL,2131,'text/html',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1666,'8ac1cbb661d986aa714a7771a41781d47fac4b80','5fd5095c772a2dcd66b076b3cce18a42c1590a3a',38,'mod_scorm','content',0,'/lms/','AICCComm.html',NULL,20475,'text/html',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1667,'da39a3ee5e6b4b0d3255bfef95601890afd80709','8c17d57a2203aa4e6605f8dd4317c57276222307',38,'mod_scorm','content',0,'/lms/','.',NULL,0,NULL,0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1668,'24d3301e5f14b21edae14a17b5114cb4db230067','dfd1a0a64b27ee6d5ea2e59b56afe7032a05b7a2',38,'mod_scorm','content',0,'/lms/','AICCFunctions.js',NULL,85090,'application/x-javascript',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1669,'cf9ed6b3b698cc8610f47f313873222f90bb106b','ab6c1c6e2f5ad0c964aa7d9906705c8e3014ba89',38,'mod_scorm','content',0,'/lms/','API.js',NULL,72759,'application/x-javascript',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1670,'8f90339d30498127ef8000add74f638cc7e4b8fb','c15603177e4d8c7d2bae81757662ce9d69214f37',38,'mod_scorm','content',0,'/lms/','APIConstants.js',NULL,2015,'application/x-javascript',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1671,'efdad4dc3f96e694fad7d5f27a9cb74cd6b57ddd','e2fbfe99343047dbd5534a4841fd7c3d6af43ab7',38,'mod_scorm','content',0,'/lms/','blank.html',NULL,1240,'text/html',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1672,'8bb344d9bd78341e3c757f5e7af27916310296b0','96141b1fb089230577745f74077ff944df80ad93',38,'mod_scorm','content',0,'/lms/','browsersniff.js',NULL,10790,'application/x-javascript',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1673,'46857629beaebd6d65111d468ff806826d9d0da8','03e8a756bd9794349a5082938bb8131d670f431f',38,'mod_scorm','content',0,'/lms/','Configuration.js',NULL,4416,'application/x-javascript',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1674,'3caef8283a0c69db3730e3082b904fe7ee5cfd8c','6617a1eab22125e849bccf346d9093da3604393d',38,'mod_scorm','content',0,'/lms/','goodbye.html',NULL,210,'text/html',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1675,'0114fd96f2cd750d042bc9739c80638c79185021','4712008be06b280e2ca9afbaaf81f4660b49269e',38,'mod_scorm','content',0,'/lms/','lms.js',NULL,11430,'application/x-javascript',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1676,'8d5006852d52737b26a9157948655ef502aa024b','234dced753fccb5a105b8749d20412f6c1ba6600',38,'mod_scorm','content',0,'/lms/','LMSAPI.js',NULL,5636,'application/x-javascript',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1677,'5217d6bbc0dcd20b0a8713f743138320902ab090','a2eca0cacedca3326fd233e0df512dbc9944bcd8',38,'mod_scorm','content',0,'/lms/','NONEFunctions.js',NULL,11384,'application/x-javascript',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1678,'31b7ed1337c0aa2a3fc6834f732dfd20dae070c0','9b5ad5f05f76dc792ded9880584a1976c709d1ce',38,'mod_scorm','content',0,'/lms/','SCORM2004Functions.js',NULL,77942,'application/x-javascript',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1679,'9fff918d5f90d4d2d3d6c51c36e14d4858efdf80','5d43c6400cd918912d6619e22ec89d1153ff2ea3',38,'mod_scorm','content',0,'/lms/','SCORMFunctions.js',NULL,62404,'application/x-javascript',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1680,'722d71c1dd23f3267e83008f63e927ca632fa6b5','f128ff5c39a66f1890fd56277be30d70f760dac0',38,'mod_scorm','content',0,'/lms/','UtilityFunctions.js',NULL,20533,'application/x-javascript',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1681,'ac1c260262e8011a1766eda642dfbf4804303112','50728666854f27b296438c3090f77d0dd7fd9843',38,'mod_scorm','content',0,'/','adlcp_rootv1p2.xsd',NULL,4508,'document/unknown',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1682,'3213c0f4244e63cb1a1ce86e277d74da6160566c','15d94f27566964159c93a8fee0a0d515157b8be3',38,'mod_scorm','content',0,'/','imscp_rootv1p1p2.xsd',NULL,14905,'document/unknown',0,NULL,NULL,NULL,1462543851,1462543851,0,NULL),(1683,'b14828485b1bb41920156e743b112d15509c9bcc','889a69fd65c2a6ffa0be79b5d1e4c03b6dbd9a31',38,'mod_scorm','content',0,'/','imsmanifest.xml',NULL,4994,'application/xml',0,NULL,NULL,NULL,1462543852,1462543852,0,NULL),(1684,'f463a5b20626953aaacdb510440d32d39b6e54e8','47b3089dcdafac7e7381dd2d4a378a450519eef0',38,'mod_scorm','content',0,'/','imsmd_rootv1p2p1.xsd',NULL,22769,'document/unknown',0,NULL,NULL,NULL,1462543852,1462543852,0,NULL),(1685,'6182547b719732a400e8e2e10271f56d6f444b27','25beb416a316e1495882ab3d613674407835623f',38,'mod_scorm','content',0,'/','ims_xml.xsd',NULL,1213,'document/unknown',0,NULL,NULL,NULL,1462543852,1462543852,0,NULL),(1686,'7cb3bc0b97ae5d8f045b2897096001df0c3e118f','36fc0dd727bc36395079a52eaf9ace76347cbc74',5,'user','draft',60036671,'/','test_res.zip',2,983555,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:12:\"test_res.zip\";s:8:\"original\";s:220:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTozODtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MTI6InRlc3RfcmVzLnppcCI7fQ==\";}','Admin User','allrightsreserved',1462543754,1462543851,0,NULL),(1687,'da39a3ee5e6b4b0d3255bfef95601890afd80709','4775964ec634876efe1a3d91574335a8a716b99d',5,'user','draft',60036671,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462544880,1462544880,0,NULL),(1688,'7cb3bc0b97ae5d8f045b2897096001df0c3e118f','9371dc7c3f953fd35f309f675e0cb93cc1fcbb4a',5,'user','draft',698327799,'/','test_res.zip',2,983555,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:12:\"test_res.zip\";s:8:\"original\";s:220:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTozODtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MTI6InRlc3RfcmVzLnppcCI7fQ==\";}','Admin User','allrightsreserved',1462543754,1462543851,0,NULL),(1689,'da39a3ee5e6b4b0d3255bfef95601890afd80709','71181d015420c4a84ce46f5c3c3d0d23be08223a',5,'user','draft',698327799,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462544880,1462544880,0,NULL),(1690,'102a792b633a57ece0b2e051cf3375fb16f0e767','46f0d96afd59218d33f446ac48ac824e13b4ddab',31,'user','draft',773257660,'/','mabel.png',3,1316893,'image/png',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:9:\"mabel.png\";}','Tessa Studente','allrightsreserved',1462586218,1462586218,0,NULL),(1691,'da39a3ee5e6b4b0d3255bfef95601890afd80709','5c91c66766e517e922248c334281ea7f4467021e',31,'user','draft',773257660,'/','.',3,0,NULL,0,NULL,NULL,NULL,1462586219,1462586219,0,NULL),(1692,'df9e3e407b5f5cd32c294e03bc180e93cc0e1c42','3dfc2081af9f9533f3b7c3dcf1bf5ee269620007',1,'core','preview',0,'/thumb/','102a792b633a57ece0b2e051cf3375fb16f0e767',NULL,9499,'image/png',0,NULL,NULL,NULL,1462586220,1462586220,0,NULL),(1693,'da39a3ee5e6b4b0d3255bfef95601890afd80709','74c104d54c05b5f8c633a36da516d37e6c5279e4',1,'core','preview',0,'/thumb/','.',NULL,0,NULL,0,NULL,NULL,NULL,1462586220,1462586220,0,NULL),(1694,'da39a3ee5e6b4b0d3255bfef95601890afd80709','884555719c50529b9df662a38619d04b5b11e25c',1,'core','preview',0,'/','.',NULL,0,NULL,0,NULL,NULL,NULL,1462586220,1462586220,0,NULL),(1697,'6503c0145488d92a464ddea40aac5332d43b5d27','cf492287cfd8d6e6d6e7bdf2abe2a73443635b0c',31,'user','icon',0,'/','f1.png',NULL,19850,'image/png',0,NULL,NULL,NULL,1462586225,1462586225,0,NULL),(1698,'da39a3ee5e6b4b0d3255bfef95601890afd80709','466ee1f722960423b17acd9c4ad69ddf02a2eee8',31,'user','icon',0,'/','.',NULL,0,NULL,0,NULL,NULL,NULL,1462586225,1462586225,0,NULL),(1699,'74b57c5f3e7bb2ed05122e9e8d9485c796037247','08af4d96300ec4e7cd6209f4241c269d5cc35c90',31,'user','icon',0,'/','f2.png',NULL,3254,'image/png',0,NULL,NULL,NULL,1462586225,1462586225,0,NULL),(1700,'259bf57e636c476ed4c2e0c3fa20297ef1b77c06','aa40d722d7be6ce9944cb44b45feb068b2349104',31,'user','icon',0,'/','f3.png',NULL,325488,'image/png',0,NULL,NULL,NULL,1462586225,1462586225,0,NULL),(1701,'7cb3bc0b97ae5d8f045b2897096001df0c3e118f','e709fb0bd9e5e3aea7ca0c1e72876484e74bccb6',5,'user','draft',408219582,'/','test_res.zip',2,983555,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:12:\"test_res.zip\";s:8:\"original\";s:220:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTozODtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MTI6InRlc3RfcmVzLnppcCI7fQ==\";}','Admin User','allrightsreserved',1462543754,1462543851,0,NULL),(1702,'da39a3ee5e6b4b0d3255bfef95601890afd80709','4f6bd1a0a2ef0829041bcb4167ef7535b01bf8e1',5,'user','draft',408219582,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462587449,1462587449,0,NULL),(1703,'7cb3bc0b97ae5d8f045b2897096001df0c3e118f','bff0be1cfb2be05934233193d799066b80e9e755',5,'user','draft',878539948,'/','test_res.zip',2,983555,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:12:\"test_res.zip\";s:8:\"original\";s:220:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTozODtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MTI6InRlc3RfcmVzLnppcCI7fQ==\";}','Admin User','allrightsreserved',1462543754,1462543851,0,NULL),(1704,'da39a3ee5e6b4b0d3255bfef95601890afd80709','5cd62a2638afcc9c2c9e7988aaa6eeab9af67628',5,'user','draft',878539948,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462587449,1462587449,0,NULL),(1705,'57364dfe033e61a122409fca8fff131851d85f61','3617927472795cd12614f139ecd74f51125d762a',5,'user','draft',588261387,'/','Scavenger_Hunt.zip',2,7460988,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:18:\"Scavenger_Hunt.zip\";s:8:\"original\";s:228:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTozMDtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MTg6IlNjYXZlbmdlcl9IdW50LnppcCI7fQ==\";}','Admin User','allrightsreserved',1462457889,1462543074,0,NULL),(1706,'da39a3ee5e6b4b0d3255bfef95601890afd80709','2ed1d5a9e8994c59be023c26f18b528106d99efc',5,'user','draft',588261387,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462587485,1462587485,0,NULL),(1707,'57364dfe033e61a122409fca8fff131851d85f61','30e4bd94efcbd5c7cad1b28e157a446fb1ece466',5,'user','draft',495287442,'/','Scavenger_Hunt.zip',2,7460988,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:18:\"Scavenger_Hunt.zip\";s:8:\"original\";s:228:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTozMDtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MTg6IlNjYXZlbmdlcl9IdW50LnppcCI7fQ==\";}','Admin User','allrightsreserved',1462457889,1462543074,0,NULL),(1708,'da39a3ee5e6b4b0d3255bfef95601890afd80709','a6090baac7e18963809ded507c9c8459e0c0462b',5,'user','draft',495287442,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462587485,1462587485,0,NULL),(1709,'57364dfe033e61a122409fca8fff131851d85f61','fe13c7961ece76e1f39c21a2644f9254522a6207',5,'user','draft',266735239,'/','Scavenger_Hunt.zip',2,7460988,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:18:\"Scavenger_Hunt.zip\";s:8:\"original\";s:228:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTozMDtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MTg6IlNjYXZlbmdlcl9IdW50LnppcCI7fQ==\";}','Admin User','allrightsreserved',1462457889,1462543074,0,NULL),(1710,'da39a3ee5e6b4b0d3255bfef95601890afd80709','8c9db42995c6515ff79c55bf14121b254eb92d42',5,'user','draft',266735239,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462629143,1462629143,0,NULL),(1711,'57364dfe033e61a122409fca8fff131851d85f61','39513c1173ae52907acf1791f1c6fbc5de5640c7',5,'user','draft',977309335,'/','Scavenger_Hunt.zip',2,7460988,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:18:\"Scavenger_Hunt.zip\";s:8:\"original\";s:228:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTozMDtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MTg6IlNjYXZlbmdlcl9IdW50LnppcCI7fQ==\";}','Admin User','allrightsreserved',1462457889,1462543074,0,NULL),(1712,'da39a3ee5e6b4b0d3255bfef95601890afd80709','df2c8b57ced87023656502174701e88e857f2bdb',5,'user','draft',977309335,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462629143,1462629143,0,NULL),(1713,'7cb3bc0b97ae5d8f045b2897096001df0c3e118f','a3d093f48bd6dc39148df571dcba4822e5e6ab51',5,'user','draft',463587668,'/','test_res.zip',2,983555,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:12:\"test_res.zip\";s:8:\"original\";s:220:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTozODtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MTI6InRlc3RfcmVzLnppcCI7fQ==\";}','Admin User','allrightsreserved',1462543754,1462543851,0,NULL),(1714,'da39a3ee5e6b4b0d3255bfef95601890afd80709','cd4a1f18eea55416ccf4a026987baba3d0c05267',5,'user','draft',463587668,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462654739,1462654739,0,NULL),(1715,'7cb3bc0b97ae5d8f045b2897096001df0c3e118f','afda9234b6c81c141adaaa58186f2bb2b715f1db',5,'user','draft',771480011,'/','test_res.zip',2,983555,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:12:\"test_res.zip\";s:8:\"original\";s:220:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTozODtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MTI6InRlc3RfcmVzLnppcCI7fQ==\";}','Admin User','allrightsreserved',1462543754,1462543851,0,NULL),(1716,'da39a3ee5e6b4b0d3255bfef95601890afd80709','e58e7114d2758d265f6ac5f0107a288dfe2d36ea',5,'user','draft',771480011,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462654739,1462654739,0,NULL),(1717,'a6227518be6942705ed52a03ea78bbaa39c19dab','e5551ef7cd67a499f2f96a0d588ae819d7e72f31',5,'user','draft',289456179,'/','Scavenger Hunt_40 test.zip',2,1613146,'application/zip',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:26:\"Scavenger Hunt_40 test.zip\";}','Admin User','allrightsreserved',1462657109,1462657109,0,NULL),(1718,'da39a3ee5e6b4b0d3255bfef95601890afd80709','036650a2f482added898b98cae96bc8ee7711f4e',5,'user','draft',289456179,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462657109,1462657109,0,NULL),(1901,'00ac4e7788162369391f522d9a17a3d77182253f','862b11d126975ef1dfc641ada28796fa39b1fe14',5,'user','draft',663078861,'/','Scavenger Hunt_40 test.zip',2,1068488,'application/zip',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:26:\"Scavenger Hunt_40 test.zip\";}','Admin User','allrightsreserved',1462657557,1462657557,0,NULL),(1902,'da39a3ee5e6b4b0d3255bfef95601890afd80709','d5750911da61c79be51905023f93fefc535f0b2f',5,'user','draft',663078861,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462657557,1462657557,0,NULL),(1986,'11141584e423ce69261569274da1a3df00c5f037','a5dbd6c3274d593b5947d685662f045576b65387',5,'user','draft',541773436,'/','Scavenger Hunt_3 test.zip',2,1002161,'application/zip',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:25:\"Scavenger Hunt_3 test.zip\";}','Admin User','allrightsreserved',1462657930,1462657930,0,NULL),(1987,'da39a3ee5e6b4b0d3255bfef95601890afd80709','0028fdc64f7a7db6f1d29779e74eaca378e8f67c',5,'user','draft',541773436,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462657930,1462657930,0,NULL),(1990,'cc65d61810bae1591d3dd488bb8ced2b6e7e9ac8','2813b46ff244f5f1aa97b623fd4d233fb02482d1',78,'mod_scorm','content',0,'/story_content/','thumbnail.jpg',NULL,10656,'image/jpeg',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(1991,'da39a3ee5e6b4b0d3255bfef95601890afd80709','93df74a3205135af2191d1462c2e3e40bd435458',78,'mod_scorm','content',0,'/story_content/','.',NULL,0,NULL,0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(1992,'da39a3ee5e6b4b0d3255bfef95601890afd80709','7378a4ac78987d4b822bfad9fc5c319ff6d4c970',78,'mod_scorm','content',0,'/','.',NULL,0,NULL,0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(1993,'9a072ce498d7a51efabd7a3e760761f2d9b9a84f','1aad22b264265445a88066e0d7bc1cd4ec24dcc7',78,'mod_scorm','content',0,'/','meta.xml',NULL,777,'application/xml',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(1994,'be094ede2d5ac43e0ffc734a650fb1c9a32dffcd','5743517c970c879cc68a03ec6f6ae0f15a9d07b8',78,'mod_scorm','content',0,'/story_content/','frame.xml',NULL,26325,'application/xml',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(1995,'e57b3817b1cbb778d4e20df299c5f2924cca44c5','c06f814750a5319f4ef6553ef2f6364b8d98f2cc',78,'mod_scorm','content',0,'/story_content/','frame.js',NULL,16954,'application/x-javascript',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(1996,'c6cc03a4c6ee98abcb81d7dcd0e723d8e34f7f1a','083bdb695d2a112e0f0832e0c0f966440f45818c',78,'mod_scorm','content',0,'/story_content/','user.js',NULL,30,'application/x-javascript',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(1997,'3f7b1c9832640d709ca955a6f638bd4203bcf6c4','1322200e38e53e57e3c3f8e0396e68642c85de8f',78,'mod_scorm','content',0,'/mobile/','app_store.png',NULL,4587,'image/png',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(1998,'da39a3ee5e6b4b0d3255bfef95601890afd80709','67d6e06958d1c867c01029b5cce0f67a15fba135',78,'mod_scorm','content',0,'/mobile/','.',NULL,0,NULL,0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(1999,'8574782cf40d97051befab6af065a2557ee16475','9b6426b63fdafda3b759a4fd35d4cb58e781b715',78,'mod_scorm','content',0,'/mobile/','mobile_icon.png',NULL,9726,'image/png',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2000,'52c09f553fe9ad08c63636cf8ed59bd28919ef3b','2fb77a62c6e4b2d24bb19dfe42ec69649c82fb9b',78,'mod_scorm','content',0,'/mobile/','linen_background.jpg',NULL,606,'image/jpeg',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2001,'1b0bc2712eab97692a1717c5df60188d71f8e645','085bb6a927ee2f6159ba732c2522463fed577bfc',78,'mod_scorm','content',0,'/','story_unsupported.html',NULL,366,'text/html',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2002,'2f8900cc0ffc1c8dfcb1de49b2b650cd1806408f','a923f0f6950d30b068fb6c98de97934fab6949cd',78,'mod_scorm','content',0,'/mobile/','player.css',NULL,69936,'text/css',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2003,'d56ec6538d5ba6cf5ce7d0d9f56205583c38ee1d','cc818c78acf42a4f60efd858b4d5c95ad2172413',78,'mod_scorm','content',0,'/mobile/','player_compiled.js',NULL,882853,'application/x-javascript',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2004,'6d0f760c41a3aa8dbc202d06309a0de11e6bef59','fd81a60a3c13bdacb3e2f8ff5c2a873337624774',78,'mod_scorm','content',0,'/story_content/','FontFactory.swf',NULL,22650,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2005,'a1f894063d976f4543d69ddd2f619fedb95ceb37','ebf40bd3b09dbb563f471b3202fe3c18036424f9',78,'mod_scorm','content',0,'/story_content/','fonts.swf',NULL,7756,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2006,'2c45cf556d4e5b51926dacd83083db7c8176d399','9e0ccb0383795c82881884e33bb146711b05eaf3',78,'mod_scorm','content',0,'/story_content/','fonts.xml',NULL,13085,'application/xml',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2007,'6dd4e7e0138a7c836c6140e7981b21f81e0a14de','4ddaa507516acbc1cc9313f5fbf4f7cc43758dac',78,'mod_scorm','content',0,'/mobile/','fonts.js',NULL,15364,'application/x-javascript',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2008,'a697b1306cf5ff1db534904cb3c04d151d448c1d','c3efb5708df4c2d4a162bac44f14bac96403b269',78,'mod_scorm','content',0,'/','story.swf',NULL,388040,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2009,'1c422e4fc097265262fdeb554f4d1c7d2e25fda7','993bcfcf38756bcf6a88891fcc34a6e38b31bcdf',78,'mod_scorm','content',0,'/story_content/','frame.swf',NULL,110644,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2010,'1ddc059ae54d20de9eec61949b499dea0c6e72bd','809fc72d972da085c48135e4437aede4066b6651',78,'mod_scorm','content',0,'/story_content/slides/','5WDTsPU3sY7.swf',NULL,2239,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2011,'da39a3ee5e6b4b0d3255bfef95601890afd80709','718901b214cdd627ff3b2c269447819fa8a22517',78,'mod_scorm','content',0,'/story_content/slides/','.',NULL,0,NULL,0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2012,'bd7d311a2ac00d2bc95579001d6a5e0c15f86a49','06b3fcfd1dc1091a6211f20779b19e9e8a820784',78,'mod_scorm','content',0,'/mobile/slides/','5WDTsPU3sY7.gz',NULL,1958,'application/g-zip',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2013,'da39a3ee5e6b4b0d3255bfef95601890afd80709','00584965e20cad98ae26b464d1017ea449dc793f',78,'mod_scorm','content',0,'/mobile/slides/','.',NULL,0,NULL,0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2014,'519ee1cd8ef3568297aa2f28204ab4424d3e563d','ba080517b41187e6db5a65b8d5cde49d071e2241',78,'mod_scorm','content',0,'/story_content/slides/','6E7Co0M8Hdd.swf',NULL,2181,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2015,'0a9d08fa38f7d74f447ee177cbe9ed9d7447d446','3ea71acb6c8d3b22e2b5e70c82ec4b65df150c5b',78,'mod_scorm','content',0,'/mobile/slides/','6E7Co0M8Hdd.gz',NULL,1904,'application/g-zip',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2016,'f7af6bf9d0fd66730962833cf93aa787ae07a39e','6722a7f9f62ecf7c90431d12078d155140c7b267',78,'mod_scorm','content',0,'/mobile/slides/','5WDTsPU3sY7.js',NULL,7950,'application/x-javascript',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2017,'df1a829c25c188fb5142a6056555072e38692e14','7daaebddeaeff3f6ef36f06306083d6bf41637d6',78,'mod_scorm','content',0,'/mobile/slides/','6E7Co0M8Hdd.js',NULL,8858,'application/x-javascript',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2018,'73f64ff853cf1d5fea76fd154296becff4579287','5d734ccc37ea86b0ca7d9964a47aa311bd706b39',78,'mod_scorm','content',0,'/story_content/slides/','5YTcbU7HjCc.swf',NULL,5009,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2019,'a39d26ac027228bd83c0d86691b9b98dfda836c0','e96029790c3477bdc323186d6d1df26ff879703f',78,'mod_scorm','content',0,'/story_content/slides/','6HcattBsmAb.swf',NULL,4990,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2020,'448d46f955667c61bf1f6155798d32c1723571df','07bed289f8f79ca7c396792d9fed7fbb14f81639',78,'mod_scorm','content',0,'/story_content/slides/','66NynDIc8nu.swf',NULL,4994,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2021,'01b643dc5bf6c17f35ec369aa5cf814975d89193','2da92abb364ba59f9faf3caaa73451374f2c74f5',78,'mod_scorm','content',0,'/mobile/slides/','5YTcbU7HjCc.gz',NULL,4709,'application/g-zip',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2022,'7fded72cb93a63a677700608788ff607c94eebf2','c5e046853b87ddea4f141bb4c173c03aacb95977',78,'mod_scorm','content',0,'/mobile/slides/','6HcattBsmAb.gz',NULL,4690,'application/g-zip',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2023,'c5bddea8dbfb9d815b214ce59591a71d093781c6','a4c7fab879976dba03584f6c734b04de51f12d10',78,'mod_scorm','content',0,'/mobile/slides/','66NynDIc8nu.gz',NULL,4694,'application/g-zip',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2024,'dec095e929b18460fbdb5db8d46abcddcd529a2c','c131dae83d17150cd98236b7b8c281d2c5a8067c',78,'mod_scorm','content',0,'/mobile/slides/','6HcattBsmAb.js',NULL,34410,'application/x-javascript',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2025,'2afd1077557ae15ed3d66bd13cfd344dc9c79214','7cb908376ed37a391aab001e720c2f7146b88a66',78,'mod_scorm','content',0,'/mobile/slides/','66NynDIc8nu.js',NULL,34409,'application/x-javascript',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2026,'ebd8a3a892ac8a8bdf02813ebe028a5076507ea2','d42d0a2c18be328be6df850b78466c9411b3dcb0',78,'mod_scorm','content',0,'/mobile/slides/','5YTcbU7HjCc.js',NULL,34451,'application/x-javascript',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2027,'505231ce0b5c89263193001312a1873c028cbeaf','bafcd3ba5ef6b3b39ed5623748fb37b8a2ae985f',78,'mod_scorm','content',0,'/story_content/','data.swf',NULL,8843,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2028,'6a97ae58eaaf72a6094f37b79a58a092e2f13570','1caede4f7914ed6782cf3bb05c246e57bc57c3ba',78,'mod_scorm','content',0,'/mobile/','data.gz',NULL,8530,'application/g-zip',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2029,'9c0dbea92f945744fbc55f5faef1f8449a59674b','4f1ae786b2e1e151e59001d10d2996a839f949ac',78,'mod_scorm','content',0,'/mobile/','data.js',NULL,60490,'application/x-javascript',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2030,'d49690931551d8cc21391e125cbb373d520b94db','5034af92383723c2cf0487b1084b7fffe782cbd6',78,'mod_scorm','content',0,'/mobile/','masks.js',NULL,27,'application/x-javascript',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2031,'9e4873e7b2c8170bca6d46884e464058546a8aca','124173b02bd5240c012187bba796d0fcc1731454',78,'mod_scorm','content',0,'/','story.html',NULL,4082,'text/html',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2032,'a8edbd6ef154612801e35b0562f6ea74ae41ea42','5a0ef3198e39761438fae650fd86c6331553d97b',78,'mod_scorm','content',0,'/','story_html5.html',NULL,5389,'text/html',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2033,'31a3787d283b2c9d86e92bb2ba61094328307bf9','404272c967b9cf307f1502df858256d3c84f1929',78,'mod_scorm','content',0,'/','index_lms_html5.html',NULL,6765,'text/html',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2034,'e8891e6f832a634d235d552561645e673aad9456','59063aa485ab55982c68a812aba715db17f24e4b',78,'mod_scorm','content',0,'/story_content/','blank.html',NULL,85,'text/html',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2035,'b44ca16c543ac7b9f2ab380cb2780e9ff3ac0cdc','f34b87d777d4c0d81e155d9972c2423550b6d032',78,'mod_scorm','content',0,'/story_content/','story.js',NULL,44273,'application/x-javascript',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2036,'d3a5b5f5558e8e0ff9172c1c4049a8a17cb8ad06','bf33a15a7dbdbde77966c7456df8fbbe622bca46',78,'mod_scorm','content',0,'/','amplaunch.html',NULL,5451,'text/html',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2037,'0b402bbe5aa7b543ecdb03a99e98abaab9f5f101','d949a6b588518aff69837ccf2a79c61e761a1b92',78,'mod_scorm','content',0,'/mobile/','mobileinstall.html',NULL,3995,'text/html',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2038,'05d182574431e0cbe79b59cc36f514cf96a00a96','d61981951b8a09f3a3c73a4a5b3b7efe14d89e4d',78,'mod_scorm','content',0,'/','index_lms.html',NULL,2144,'text/html',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2039,'8ac1cbb661d986aa714a7771a41781d47fac4b80','be21b36f461c87ca2ec2c617167d08418d3ba162',78,'mod_scorm','content',0,'/lms/','AICCComm.html',NULL,20475,'text/html',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2040,'da39a3ee5e6b4b0d3255bfef95601890afd80709','921b51f88d81cf8859a7d80f31698357d888e411',78,'mod_scorm','content',0,'/lms/','.',NULL,0,NULL,0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2041,'24d3301e5f14b21edae14a17b5114cb4db230067','320807da71153a4bb45ba13c52878275f6ccd804',78,'mod_scorm','content',0,'/lms/','AICCFunctions.js',NULL,85090,'application/x-javascript',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2042,'cf9ed6b3b698cc8610f47f313873222f90bb106b','3a357171e3132cc349d03e3584622bae9a9c5488',78,'mod_scorm','content',0,'/lms/','API.js',NULL,72759,'application/x-javascript',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2043,'8f90339d30498127ef8000add74f638cc7e4b8fb','9ece53ec30f844d356e2b3f5e131bbd803c8f426',78,'mod_scorm','content',0,'/lms/','APIConstants.js',NULL,2015,'application/x-javascript',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2044,'efdad4dc3f96e694fad7d5f27a9cb74cd6b57ddd','88e84dfe3f9b427487501eaf5bb8ca0d8e2c1322',78,'mod_scorm','content',0,'/lms/','blank.html',NULL,1240,'text/html',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2045,'8bb344d9bd78341e3c757f5e7af27916310296b0','aed3b4ddfb63fe00a0b85f524c7cf252f659a68a',78,'mod_scorm','content',0,'/lms/','browsersniff.js',NULL,10790,'application/x-javascript',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2046,'46857629beaebd6d65111d468ff806826d9d0da8','4a9a00c03d753bb2d67db3bacf2b355981d8d7ab',78,'mod_scorm','content',0,'/lms/','Configuration.js',NULL,4416,'application/x-javascript',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2047,'3caef8283a0c69db3730e3082b904fe7ee5cfd8c','85708f0e62a7a37e2ddee8bd5a82b54a45ba23e9',78,'mod_scorm','content',0,'/lms/','goodbye.html',NULL,210,'text/html',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2048,'0114fd96f2cd750d042bc9739c80638c79185021','1d43540d5c1fbdef7f697de55fc3cf49d6770988',78,'mod_scorm','content',0,'/lms/','lms.js',NULL,11430,'application/x-javascript',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2049,'8d5006852d52737b26a9157948655ef502aa024b','277b4b358ef6e6a19f0ac044264b93dfb6f62c2f',78,'mod_scorm','content',0,'/lms/','LMSAPI.js',NULL,5636,'application/x-javascript',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2050,'5217d6bbc0dcd20b0a8713f743138320902ab090','77c2b768e7af089b63f1bb88094c221ffd0972c7',78,'mod_scorm','content',0,'/lms/','NONEFunctions.js',NULL,11384,'application/x-javascript',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2051,'31b7ed1337c0aa2a3fc6834f732dfd20dae070c0','722e70d03c66a371c7dcac677a1cb6e9532ab844',78,'mod_scorm','content',0,'/lms/','SCORM2004Functions.js',NULL,77942,'application/x-javascript',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2052,'9fff918d5f90d4d2d3d6c51c36e14d4858efdf80','ecefab27776ec3ca97a751e687082d1eb3c65a2e',78,'mod_scorm','content',0,'/lms/','SCORMFunctions.js',NULL,62404,'application/x-javascript',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2053,'722d71c1dd23f3267e83008f63e927ca632fa6b5','c35d1e77b4862f0aa4213af29644bdabd28eb3e0',78,'mod_scorm','content',0,'/lms/','UtilityFunctions.js',NULL,20533,'application/x-javascript',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2054,'ac1c260262e8011a1766eda642dfbf4804303112','ba2be0b0ee429825beb92d41a242e4db8eeebbd4',78,'mod_scorm','content',0,'/','adlcp_rootv1p2.xsd',NULL,4508,'document/unknown',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2055,'3213c0f4244e63cb1a1ce86e277d74da6160566c','599e7bae37a96019ce0ad1f9f9781bcbce04339e',78,'mod_scorm','content',0,'/','imscp_rootv1p1p2.xsd',NULL,14905,'document/unknown',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2056,'6995f2cfe4be01e3df478c4ed630933a714b78fe','cf78d816a490d367faf581a98691a69e9a0f8a90',78,'mod_scorm','content',0,'/','imsmanifest.xml',NULL,5393,'application/xml',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2057,'f463a5b20626953aaacdb510440d32d39b6e54e8','d3bc3c60b3c64aac613876397a2e14530a9a73d1',78,'mod_scorm','content',0,'/','imsmd_rootv1p2p1.xsd',NULL,22769,'document/unknown',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2058,'6182547b719732a400e8e2e10271f56d6f444b27','b2f5cb1d70ce0e8ca95013f6f1e69798c1b04373',78,'mod_scorm','content',0,'/','ims_xml.xsd',NULL,1213,'document/unknown',0,NULL,NULL,NULL,1462657939,1462657939,0,NULL),(2059,'11141584e423ce69261569274da1a3df00c5f037','a1237314286146fc60489332513b84782f6c84b9',68,'user','draft',975698025,'/','Scavenger Hunt_3 test.zip',2,1002161,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:25:\"Scavenger Hunt_3 test.zip\";s:8:\"original\";s:236:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTo3ODtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MjU6IlNjYXZlbmdlciBIdW50XzMgdGVzdC56aXAiO30=\";}','Admin User','allrightsreserved',1462657930,1462657939,0,NULL),(2060,'da39a3ee5e6b4b0d3255bfef95601890afd80709','fdc9bf9983bf06f7725cf16e5521fca96a427128',68,'user','draft',975698025,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462659533,1462659533,0,NULL),(2061,'11141584e423ce69261569274da1a3df00c5f037','14c7906e801d0c07033d1ec19f959ba0105acb20',68,'user','draft',780696456,'/','Scavenger Hunt_3 test.zip',2,1002161,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:25:\"Scavenger Hunt_3 test.zip\";s:8:\"original\";s:236:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTo3ODtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MjU6IlNjYXZlbmdlciBIdW50XzMgdGVzdC56aXAiO30=\";}','Admin User','allrightsreserved',1462657930,1462657939,0,NULL),(2062,'da39a3ee5e6b4b0d3255bfef95601890afd80709','1f5c1b6fe1b20a07ca69e5d8484a06e4ce95249b',68,'user','draft',780696456,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462659533,1462659533,0,NULL),(2063,'11141584e423ce69261569274da1a3df00c5f037','be2b09efdf95940fd204b7addd900d58a8322d05',78,'mod_scorm','package',0,'/','Scavenger Hunt_3 test.zip',2,1002161,'application/zip',0,'Scavenger Hunt_3 test.zip','Admin User','allrightsreserved',1462657930,1462659571,0,NULL),(2064,'da39a3ee5e6b4b0d3255bfef95601890afd80709','5dde5d2216f5fa4d0cd413093660db661db28da5',78,'mod_scorm','package',0,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462659533,1462659571,0,NULL),(2065,'57364dfe033e61a122409fca8fff131851d85f61','40f98fbcb29e770f2024b236e9a9d5ec30130758',68,'user','draft',119305477,'/','Scavenger_Hunt.zip',2,7460988,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:18:\"Scavenger_Hunt.zip\";s:8:\"original\";s:228:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTozMDtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MTg6IlNjYXZlbmdlcl9IdW50LnppcCI7fQ==\";}','Admin User','allrightsreserved',1462457889,1462543074,0,NULL),(2066,'da39a3ee5e6b4b0d3255bfef95601890afd80709','ab8a10a5360d454624dd5e9f83e5d8fa7053ad3e',68,'user','draft',119305477,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462659589,1462659589,0,NULL),(2067,'57364dfe033e61a122409fca8fff131851d85f61','e678166cd77c8a5c9498ea58125fc0f06967b56c',68,'user','draft',244165387,'/','Scavenger_Hunt.zip',2,7460988,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:18:\"Scavenger_Hunt.zip\";s:8:\"original\";s:228:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTozMDtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MTg6IlNjYXZlbmdlcl9IdW50LnppcCI7fQ==\";}','Admin User','allrightsreserved',1462457889,1462543074,0,NULL),(2068,'da39a3ee5e6b4b0d3255bfef95601890afd80709','e9a78f60ef3c6923b0660c22b167ac6d85b7fbc2',68,'user','draft',244165387,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462659589,1462659589,0,NULL),(2069,'57364dfe033e61a122409fca8fff131851d85f61','d7d2a635b082c823d0a9dbe18307f3a17c09bba4',30,'mod_scorm','package',0,'/','Scavenger_Hunt.zip',2,7460988,'application/zip',0,'Scavenger_Hunt.zip','Admin User','allrightsreserved',1462457889,1462659606,0,NULL),(2070,'da39a3ee5e6b4b0d3255bfef95601890afd80709','83c419f8df107223c67e419a976d0e79ff89ec6c',30,'mod_scorm','package',0,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462659589,1462659606,0,NULL),(2071,'57364dfe033e61a122409fca8fff131851d85f61','bf704e0f3c46f30c9a31b7fccf445d73b949abd3',68,'user','draft',297694698,'/','Scavenger_Hunt.zip',2,7460988,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:18:\"Scavenger_Hunt.zip\";s:8:\"original\";s:228:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTozMDtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MTg6IlNjYXZlbmdlcl9IdW50LnppcCI7fQ==\";}','Admin User','allrightsreserved',1462457889,1462659606,0,NULL),(2072,'da39a3ee5e6b4b0d3255bfef95601890afd80709','ed5aee39807511ecb0ac57a6390e57a489d421f6',68,'user','draft',297694698,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462659620,1462659620,0,NULL),(2073,'57364dfe033e61a122409fca8fff131851d85f61','853e7fa5d18c32497553ec2d76c6b63e50954357',68,'user','draft',788088496,'/','Scavenger_Hunt.zip',2,7460988,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:18:\"Scavenger_Hunt.zip\";s:8:\"original\";s:228:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTozMDtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MTg6IlNjYXZlbmdlcl9IdW50LnppcCI7fQ==\";}','Admin User','allrightsreserved',1462457889,1462659606,0,NULL),(2074,'da39a3ee5e6b4b0d3255bfef95601890afd80709','1e7ebd53ca938543b65f9261b53c9c16e197859a',68,'user','draft',788088496,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462659620,1462659620,0,NULL),(2075,'11141584e423ce69261569274da1a3df00c5f037','64f78b675e9026f93f5b9b48296d5cd90feb49de',68,'user','draft',984701253,'/','Scavenger Hunt_3 test.zip',2,1002161,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:25:\"Scavenger Hunt_3 test.zip\";s:8:\"original\";s:236:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTo3ODtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MjU6IlNjYXZlbmdlciBIdW50XzMgdGVzdC56aXAiO30=\";}','Admin User','allrightsreserved',1462657930,1462659571,0,NULL),(2076,'da39a3ee5e6b4b0d3255bfef95601890afd80709','9082a90c99c4902f7259793ea9ea2c9808b54058',68,'user','draft',984701253,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462659660,1462659660,0,NULL),(2077,'11141584e423ce69261569274da1a3df00c5f037','314e263367d195f26ab36ad172c88478ba386ff7',68,'user','draft',675131140,'/','Scavenger Hunt_3 test.zip',2,1002161,'application/zip',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:25:\"Scavenger Hunt_3 test.zip\";s:8:\"original\";s:236:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aTo3ODtzOjk6ImNvbXBvbmVudCI7czo5OiJtb2Rfc2Nvcm0iO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJwYWNrYWdlIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6MjU6IlNjYXZlbmdlciBIdW50XzMgdGVzdC56aXAiO30=\";}','Admin User','allrightsreserved',1462657930,1462659571,0,NULL),(2078,'da39a3ee5e6b4b0d3255bfef95601890afd80709','eac5a80cde8c356855bc65de969aeac663231b60',68,'user','draft',675131140,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462659660,1462659660,0,NULL),(2079,'1ad5a1f4a5c157ddb1fa68e816b555336c99ee7d','b65b59a774b8bf8e1b77d2ac4a89cf3eaddf9d03',5,'user','draft',566976664,'/','Scavenger Hunt_4 fill.zip',2,1001259,'application/zip',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:25:\"Scavenger Hunt_4 fill.zip\";}','Admin User','allrightsreserved',1462701308,1462701308,0,NULL),(2080,'da39a3ee5e6b4b0d3255bfef95601890afd80709','631d021f5774d9ee3f4bc267320d37eae124b235',5,'user','draft',566976664,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462701308,1462701308,0,NULL),(2152,'eebb873dc153440a5359edc5244284f4b757dee9','9625a7bee1832ae669608b4211e492ec4f855ec9',5,'user','draft',797351857,'/','Scavenger Hunt_4 fill_res.zip',2,1001812,'application/zip',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:29:\"Scavenger Hunt_4 fill_res.zip\";}','Admin User','allrightsreserved',1462701569,1462701569,0,NULL),(2153,'da39a3ee5e6b4b0d3255bfef95601890afd80709','0eb6b9d8d66fdc690ab0ad2c59ae596e93106817',5,'user','draft',797351857,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462701569,1462701569,0,NULL),(2225,'95e4dfc22c4aaf2216a68d30b3a0423a9eeac823','d509d4b931fd1765bd04b31c4ef6bde1d5ac7264',5,'user','draft',187300644,'/','Scavenger_Hunt_pages.zip',2,6917681,'application/zip',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:24:\"Scavenger_Hunt_pages.zip\";}','Admin User','allrightsreserved',1462716771,1462716771,0,NULL),(2226,'da39a3ee5e6b4b0d3255bfef95601890afd80709','5f3f49aaa15217fbb6652ca28912e11d056c087d',5,'user','draft',187300644,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462716771,1462716771,0,NULL),(2227,'95e4dfc22c4aaf2216a68d30b3a0423a9eeac823','51b816c1b2901596b3193570f95d783f2bcd3aeb',81,'mod_scorm','package',0,'/','Scavenger_Hunt_pages.zip',2,6917681,'application/zip',0,'Scavenger_Hunt_pages.zip','Admin User','allrightsreserved',1462716771,1462716817,0,NULL),(2228,'da39a3ee5e6b4b0d3255bfef95601890afd80709','4a9ac73b69c13a9fd4cfaa6dbddaeb52119df378',81,'mod_scorm','package',0,'/','.',2,0,NULL,0,NULL,NULL,NULL,1462716771,1462716817,0,NULL),(2229,'cc65d61810bae1591d3dd488bb8ced2b6e7e9ac8','1caa0aa8c77d844ad87046207b397527d4d19bac',81,'mod_scorm','content',0,'/story_content/','thumbnail.jpg',NULL,10656,'image/jpeg',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2230,'da39a3ee5e6b4b0d3255bfef95601890afd80709','2348c7312435b8794e958544658bb02e508f137f',81,'mod_scorm','content',0,'/story_content/','.',NULL,0,NULL,0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2231,'da39a3ee5e6b4b0d3255bfef95601890afd80709','b085e11de2ecf6745d59c393eff2fee4d4fc1315',81,'mod_scorm','content',0,'/','.',NULL,0,NULL,0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2232,'2b17f4f609b949669059bc53b10be33967a426d7','243290cd39584788917b9671156d6b242a926a08',81,'mod_scorm','content',0,'/','meta.xml',NULL,776,'application/xml',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2233,'9347e3775eead0c1f8d0f2bc385b25407e56dde0','621a505c43f624c215c6de0ac1439807a5b1d3eb',81,'mod_scorm','content',0,'/story_content/','frame.xml',NULL,26324,'application/xml',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2234,'6654cc1694efb43e3b212b6192d2b188b73b1459','1c026747acbf5e76d8b401cc8eb5e4a929934a92',81,'mod_scorm','content',0,'/story_content/','frame.js',NULL,16950,'application/x-javascript',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2235,'c6cc03a4c6ee98abcb81d7dcd0e723d8e34f7f1a','3a8c1d7a48d1dc4ce5fe0fb206584d37b97f981c',81,'mod_scorm','content',0,'/story_content/','user.js',NULL,30,'application/x-javascript',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2236,'3f7b1c9832640d709ca955a6f638bd4203bcf6c4','20c6d12106093242fdf8ba9d9135c732ca13af3d',81,'mod_scorm','content',0,'/mobile/','app_store.png',NULL,4587,'image/png',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2237,'da39a3ee5e6b4b0d3255bfef95601890afd80709','ceb37cbe9367206b2ae35dac2093c4b30d9bf088',81,'mod_scorm','content',0,'/mobile/','.',NULL,0,NULL,0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2238,'8574782cf40d97051befab6af065a2557ee16475','81090dbcf553d027672b2d5d80b3afc20aaf85f6',81,'mod_scorm','content',0,'/mobile/','mobile_icon.png',NULL,9726,'image/png',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2239,'52c09f553fe9ad08c63636cf8ed59bd28919ef3b','129cfe8111cb7b273f15a39ffd230bd6a73a23f7',81,'mod_scorm','content',0,'/mobile/','linen_background.jpg',NULL,606,'image/jpeg',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2240,'1b0bc2712eab97692a1717c5df60188d71f8e645','c7b5b4b055b25688951e98569b20a9ab4b0fadd0',81,'mod_scorm','content',0,'/','story_unsupported.html',NULL,366,'text/html',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2241,'2f8900cc0ffc1c8dfcb1de49b2b650cd1806408f','fa6cfb919b2964efba6cb0540ff0ad35633ae271',81,'mod_scorm','content',0,'/mobile/','player.css',NULL,69936,'text/css',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2242,'d56ec6538d5ba6cf5ce7d0d9f56205583c38ee1d','ce156a48c83806e3355bf2c1dbadaf12696a775e',81,'mod_scorm','content',0,'/mobile/','player_compiled.js',NULL,882853,'application/x-javascript',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2243,'d5898a7f30dce460cb84588c6b359f595bcac180','464a72aec3b2424817236085fc8f38d1a4f184f1',81,'mod_scorm','content',0,'/story_content/','FontFactory.swf',NULL,24217,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2244,'e8378e5520c2b084d577682b2a5bac6dca28751e','5cbe0d22fbf4dcf81fb8c3632fe816b08f1dbad9',81,'mod_scorm','content',0,'/story_content/','fonts.swf',NULL,8763,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2245,'fb839019e256ca8fad73614b3585c68684d186cd','7c6d139ecc797b8d932adcf66699c8730009fe5d',81,'mod_scorm','content',0,'/story_content/','fonts.xml',NULL,14752,'application/xml',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2246,'5cff350a8637d3ebccc0ef1cc8b2e7988f037564','abb3f8b56fdc1c55e7610c5d9c2286bf61515d7b',81,'mod_scorm','content',0,'/mobile/','fonts.js',NULL,17338,'application/x-javascript',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2247,'a697b1306cf5ff1db534904cb3c04d151d448c1d','bf8df9947f76ce594ebc2b79adadd2e5078d59c8',81,'mod_scorm','content',0,'/','story.swf',NULL,388040,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2248,'eb5e9c049f3e6be1a9cf9ddd166e09305229bf3f','292f54d2f95b7b11b83f6025fcc481d523f8dcc0',81,'mod_scorm','content',0,'/story_content/','frame.swf',NULL,110943,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2249,'f41886f4b9e73645a8d4941394812c4b2b95ff1b','4e3fc3109cae1501a82c7f79115eef737271acb3',81,'mod_scorm','content',0,'/story_content/slides/','6E7Co0M8Hdd.swf',NULL,2184,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2250,'da39a3ee5e6b4b0d3255bfef95601890afd80709','fbf21679d70bd0784c9808e61584a5f0fcbe9604',81,'mod_scorm','content',0,'/story_content/slides/','.',NULL,0,NULL,0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2251,'e6cbdc2c292f6e528ee2dbee598bce68509a4c90','5550bf8ede2ce319e52c7e9112f652b007aebec5',81,'mod_scorm','content',0,'/mobile/slides/','6E7Co0M8Hdd.gz',NULL,1905,'application/g-zip',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2252,'da39a3ee5e6b4b0d3255bfef95601890afd80709','76cc41fd2467834e474029ce98dcf498d967f524',81,'mod_scorm','content',0,'/mobile/slides/','.',NULL,0,NULL,0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2253,'d681d90bb294b591e33154ef5177f19f230a3199','e5b328e76461586a314752b87c152caa7a8b6cbb',81,'mod_scorm','content',0,'/story_content/slides/','5WDTsPU3sY7.swf',NULL,2194,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2254,'d99afb5b4949468c450c3f074ee14d3cf50f8908','3f6e94e13876f693a9249ee233e510e48ea6e1c6',81,'mod_scorm','content',0,'/mobile/slides/','5WDTsPU3sY7.gz',NULL,1911,'application/g-zip',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2255,'9ab301aa476177a2d90df095afb4a08acc4cb741','d25e872cbf7b2533f812c40b024c7fedb174db32',81,'mod_scorm','content',0,'/mobile/slides/','6E7Co0M8Hdd.js',NULL,8868,'application/x-javascript',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2256,'823bd4e704b9827a5acdf42d1b5c372729958ca5','6b35ea729e5699c09e3678a2000940a20340a12c',81,'mod_scorm','content',0,'/mobile/slides/','5WDTsPU3sY7.js',NULL,7717,'application/x-javascript',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2257,'0f5a54a25a114f7204d397db59f49d30e6efbb35','65655ef3c4a0880bca5f6bf080114c91b209ccad',81,'mod_scorm','content',0,'/story_content/slides/','5va8hNyQpzh.swf',NULL,3548,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2258,'5059c22d77ecb1437069aa963da48191369fa9da','15480137c93d007321dbab47fed65ac9d3762d78',81,'mod_scorm','content',0,'/mobile/slides/','5va8hNyQpzh.gz',NULL,3259,'application/g-zip',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2259,'222eb5986b3244a93bebc17e828e948e65f59f07','1a449374407e7fd9e3db65b24b089568720bbb37',81,'mod_scorm','content',0,'/story_content/slides/','664ihuBJMoW.swf',NULL,3552,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2260,'5ef1ce07ddd886881ed97ee4d410b83d00dadfe8','f6199f95b30f4e6bec5adbafb624fb5be7245589',81,'mod_scorm','content',0,'/story_content/slides/','63sfpEC0Jln.swf',NULL,3554,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2261,'eaa454598424d938b851a181132db36494bcc4c6','e4858a300f3f4b1d5d738beb16982e1c6caabd61',81,'mod_scorm','content',0,'/mobile/slides/','664ihuBJMoW.gz',NULL,3263,'application/g-zip',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2262,'f2f992d2e2fd2dd5a0ddfaae67b1aef9e5ee79dd','0b6ba2afb9c95bb4702e6cd0bb0fc62ad44f26f7',81,'mod_scorm','content',0,'/mobile/slides/','63sfpEC0Jln.gz',NULL,3265,'application/g-zip',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2263,'741511605449d146d50fbd54ce97974af7718f89','379dcbf663710ea1ef06aa588c2835c626ae57b2',81,'mod_scorm','content',0,'/story_content/slides/','5wSBgWU5h5m.swf',NULL,3548,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2264,'23f2c420a1f031b6b56c09b147c8490bcf989e3e','93bb6b38a4f12523045b0ef1d3f239b3f24bb5f5',81,'mod_scorm','content',0,'/mobile/slides/','5wSBgWU5h5m.gz',NULL,3257,'application/g-zip',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2265,'39410510b442d4fb278c243ba0cd16db415d0fd4','ea3148dba9c0f8726f1f99ebba68829c390749d9',81,'mod_scorm','content',0,'/mobile/slides/','5va8hNyQpzh.js',NULL,15842,'application/x-javascript',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2266,'a2d9b64207835eeb6e6361dee3ee782c825bd395','6b492c3a4de01577efaf890b8562ccbd6c2d9b16',81,'mod_scorm','content',0,'/story_content/slides/','5Xo36PtzY2i.swf',NULL,3545,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2267,'53d5b08fa6d8461a8021e4de615e2816a58cb42f','a76fbc6ddc15c82f06b19ed63835abf2abd10ab3',81,'mod_scorm','content',0,'/mobile/slides/','63sfpEC0Jln.js',NULL,15854,'application/x-javascript',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2268,'a0da70b64ea545d0d42748c90633d42a2db932c7','bd148e1302677330736359d02b55838df7afb224',81,'mod_scorm','content',0,'/mobile/slides/','5Xo36PtzY2i.gz',NULL,3257,'application/g-zip',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2269,'8017573aefe7b31bec547656042897cd5cc918d9','599d1c8bd02108ba5f1e1d44b36e4f9824245fbb',81,'mod_scorm','content',0,'/mobile/slides/','5wSBgWU5h5m.js',NULL,15846,'application/x-javascript',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2270,'11877c8bdea44ad720ca98d269419881aec38c13','2de98ce16c212df5b98d789b108a0c4416544a18',81,'mod_scorm','content',0,'/story_content/slides/','5XpyYsARx7G.swf',NULL,3564,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2271,'12665842c127d9e1bb4e64523029f9e05ee3afbe','381e0fdd9ba2d1674359b6e19a46c44228907a2c',81,'mod_scorm','content',0,'/mobile/slides/','5XpyYsARx7G.gz',NULL,3274,'application/g-zip',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2272,'63b6a85ca7c2ff7b04e6dc9f3d961262f2d068f2','dd32e754e782727da031f84c0b09390d3a6fda98',81,'mod_scorm','content',0,'/story_content/slides/','6C1SEFRWnTB.swf',NULL,3568,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2273,'88f2ac1ba53cffb72e6b1b3ba3059f1aa8956bba','4d00b26fe96dbdbcb1dca815a1c18f8f9b105c39',81,'mod_scorm','content',0,'/mobile/slides/','664ihuBJMoW.js',NULL,15843,'application/x-javascript',0,NULL,NULL,NULL,1462716817,1462716817,0,NULL),(2274,'71e753406782cd448dd3d04b30565056eff3507f','d7adf3ed9cc2062a5abeeb742f66414d2cb1553a',81,'mod_scorm','content',0,'/mobile/slides/','6C1SEFRWnTB.gz',NULL,3277,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2275,'9562d4bdc3ce88d8ba7a8378ed2d16c388670341','f8a15fbabe43a267085442f5c3ee8b395192e340',81,'mod_scorm','content',0,'/story_content/slides/','5g0I7tHBrvy.swf',NULL,3561,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2276,'2193c0869ec41201d7f0623c0f069165ce86ac7b','2597e0b92767bb1ab50c0d75fdfa01b572db747e',81,'mod_scorm','content',0,'/mobile/slides/','5g0I7tHBrvy.gz',NULL,3270,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2277,'d0a5be5ac73b2a2edbb8d49a3ee988f579292830','45b2529b323ef37208faba87d1d82adf74204011',81,'mod_scorm','content',0,'/mobile/slides/','5Xo36PtzY2i.js',NULL,15842,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2278,'74b98ee9d3cf03baae6cd2e08af65887f7944b99','b8ae1767435a48cdb0c8cf90a0fc2ec13ff916a7',81,'mod_scorm','content',0,'/mobile/slides/','5XpyYsARx7G.js',NULL,15878,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2279,'d63cfd568514596147e8b215aefbf7b62dc9a85b','021e2b43aaa3c2bad3d5dc52ecb61d7a1d40ac43',81,'mod_scorm','content',0,'/story_content/slides/','5yPENhkZmNw.swf',NULL,3549,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2280,'0d635bfc71196faabd39c7cf7d447f2ace014722','e50454ac86e774993c49e1968d10a8d9dd15ec18',81,'mod_scorm','content',0,'/story_content/slides/','5zeqC0ZO9HE.swf',NULL,3560,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2281,'96711f2be9966ed0deedf137077e0699f3609766','c4c39e326acced3c262f6baac0dd17c4f58c17d0',81,'mod_scorm','content',0,'/mobile/slides/','5zeqC0ZO9HE.gz',NULL,3271,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2282,'b1135dc79882903bbf27662fbe32aaa49a5fac3a','4a481eb605d459470bdffe34c14f26c4770196c7',81,'mod_scorm','content',0,'/mobile/slides/','5yPENhkZmNw.gz',NULL,3257,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2283,'308ad8f5c47c9a23176e1083c8d5cd14935da536','6ac4a4d5d93092b755c61268ac03e24d8bec9e8a',81,'mod_scorm','content',0,'/mobile/slides/','5g0I7tHBrvy.js',NULL,15869,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2284,'df638dcd5644d0a8aa57b5cf983ec2ba69196792','8f659e5ca9e136ab4b9a3dc27ae60eb8aea57ae5',81,'mod_scorm','content',0,'/mobile/slides/','6C1SEFRWnTB.js',NULL,15874,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2285,'6b35b23bc2cd4ef6f7d2191562384ad057cd0dc3','f7f026b0f0b42f8c1069cd88bfb73c0fd56fafc2',81,'mod_scorm','content',0,'/story_content/slides/','6hB1SveGzaD.swf',NULL,3549,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2286,'6995f1e5a00f3f2a13d9999274b99299eda870a9','8b927b377e3a9599935b3aa0b7d930dd15ad8586',81,'mod_scorm','content',0,'/mobile/slides/','6hB1SveGzaD.gz',NULL,3259,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2287,'0b91e644d503f711ba1ee32cca6764e4af3d7225','8ad43b5c6ec8597dbfad77962f4a24103e37dc5b',81,'mod_scorm','content',0,'/story_content/slides/','5XqPWPKzr1L.swf',NULL,3547,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2288,'8186d67ff5882244e01f0bf18a41cf32a4c1da38','aa23887b45ffb860c6d066dcc67208ae3c6de0dd',81,'mod_scorm','content',0,'/mobile/slides/','5XqPWPKzr1L.gz',NULL,3259,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2289,'88169e6eb354442f4b3499c8d26567bb4ac80b5f','8095f4e61489093bd0b32b8e98c4e823e3dc33ba',81,'mod_scorm','content',0,'/mobile/slides/','5zeqC0ZO9HE.js',NULL,15858,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2290,'e7e3dfbf52760c58322f7df88be5a1d6c78e3139','d9654b1aa5495597c24dbd9380a883e960b8aac2',81,'mod_scorm','content',0,'/mobile/slides/','5yPENhkZmNw.js',NULL,15841,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2291,'c2cae269cdecda9ffd6ee7eab6843df9c00c2ca8','3b3b9d3660ad7252ea2255f090adf73b7141155d',81,'mod_scorm','content',0,'/story_content/slides/','5b5bdphTqNI.swf',NULL,3553,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2292,'749b90a9d51a50ed14b3ece555bf241c5182d1db','ee55c9d81b6d20f6bee4ec0f92d5350722d694c2',81,'mod_scorm','content',0,'/mobile/slides/','5b5bdphTqNI.gz',NULL,3263,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2293,'b4844bc3c538d0cd92e327a0aae6976e26bf9668','be46a38c20d5348343302d42b3f2f34c7cd34b60',81,'mod_scorm','content',0,'/mobile/slides/','6hB1SveGzaD.js',NULL,15853,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2294,'3115dd1838126ed9017c5e7173c15d1c2a511481','b875b551cc00b1f1f22cffe2cdbc6f59626b979e',81,'mod_scorm','content',0,'/story_content/slides/','5e0HE00xNBh.swf',NULL,3554,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2295,'4dc21cdb6b71c4ced502dc057612c97e7212fb62','8b794a313372ff40bed9fde156fa500cf9d06f83',81,'mod_scorm','content',0,'/mobile/slides/','5e0HE00xNBh.gz',NULL,3261,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2296,'9c2c8cfcb3d0b9370a3a0e5eff2ef81cbc875733','281c989e8ac046c43ba6b51e1f9be3e4215dee7f',81,'mod_scorm','content',0,'/mobile/slides/','5XqPWPKzr1L.js',NULL,15843,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2297,'be25dd537ec77bd070a9a7126832ec34cd96ad13','dfbb99d100dc5adfb60dcb60ac86ec5eeeaaa010',81,'mod_scorm','content',0,'/story_content/slides/','6AgxbJNqHWM.swf',NULL,3554,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2298,'9077a62960ac580f1d6e6622ab242b0024da4d16','d8ca38afb3111d470ce407f1f92220a3e6765ab9',81,'mod_scorm','content',0,'/mobile/slides/','6AgxbJNqHWM.gz',NULL,3263,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2299,'d91949c1feece6e07f5e614187a70d9982b02088','e067d5c66116fe01da3156814e6e0469685f814f',81,'mod_scorm','content',0,'/story_content/slides/','6oRea9Rcnp5.swf',NULL,3554,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2300,'bbb7ce98561514c1d7f9f16cbd2f030981250577','5348b6e63b141491dab9edb3f2c1b3b787f5dce9',81,'mod_scorm','content',0,'/mobile/slides/','6oRea9Rcnp5.gz',NULL,3264,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2301,'d1ff745fab9e8ff9100746d9cf7ea707e18eadbb','318386a32a46d4fbcfa6d4b5d43428e9d20c7f2f',81,'mod_scorm','content',0,'/mobile/slides/','5b5bdphTqNI.js',NULL,15858,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2302,'db5ef0eeae3a3e10d8521cff3db4968a8335dec6','339bab5b2003b96cb46136db39b0691584ebe05c',81,'mod_scorm','content',0,'/story_content/slides/','5oqxGwezPH4.swf',NULL,3550,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2303,'229fe2003499416b92c49d9fd1500003ccfb3f66','c75ae1659b56a64883cbdeb8b1cb86926b244ebf',81,'mod_scorm','content',0,'/mobile/slides/','5e0HE00xNBh.js',NULL,15861,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2304,'01f7bf84b7cdc5b089d5a8519bd538472986de46','d7d284034a86c00e270ed7637d281e2d3e1cf629',81,'mod_scorm','content',0,'/mobile/slides/','5oqxGwezPH4.gz',NULL,3261,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2305,'b76c0a8a4cefc2db6c15fb73f61a31f0168cda1c','a70c0378e8d0c5b9b1806febdde8e3bd558cd9c3',81,'mod_scorm','content',0,'/story_content/slides/','65cuZaTchh9.swf',NULL,3550,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2306,'a808a5c5d682a0472d678444e7e60dbe285cac6b','c13319a83ae7ac8d04b7120885f17e759b3ce1eb',81,'mod_scorm','content',0,'/mobile/slides/','65cuZaTchh9.gz',NULL,3259,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2307,'4be78200ce457ac91f67cbcc5dfdc1ad59ee0f8e','e855ef14bb7bf08aeb0e4c81e1e1d40397167579',81,'mod_scorm','content',0,'/mobile/slides/','6AgxbJNqHWM.js',NULL,15849,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2308,'2458dc72e6e866500a0bda6ec43cca5345bf2915','9cc2c37a6aa57762412201db0336558ef50e4598',81,'mod_scorm','content',0,'/mobile/slides/','6oRea9Rcnp5.js',NULL,15858,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2309,'77af4b829385d74cdee79f94bf29589dfe652b6c','ad18cc392bb98f5a89b12032882a2903d40052c6',81,'mod_scorm','content',0,'/story_content/slides/','6acjCzUDKdg.swf',NULL,3556,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2310,'126de1a86b98253e331c7bd397e1ea80aab24d81','34839704cc4bcb55b967d52e7645f025659c1d6c',81,'mod_scorm','content',0,'/mobile/slides/','6acjCzUDKdg.gz',NULL,3266,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2311,'d932968ef893b8a4da9bb5d709c86d940abdb1d0','4dbe4fe30d2c1de55704bd87ab57d02cc7d01206',81,'mod_scorm','content',0,'/story_content/slides/','6oL9QwEcls3.swf',NULL,3543,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2312,'a6957e2b11a8b6eefd007e14c19bf678f837d677','12ee675ad1603aa2426c29571e04005469f2ddc9',81,'mod_scorm','content',0,'/mobile/slides/','6oL9QwEcls3.gz',NULL,3257,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2313,'641917d9574dea16c32395af596eb64b27d03b0b','ca77d45eed1229e8e418c2abc625bd09005371da',81,'mod_scorm','content',0,'/mobile/slides/','65cuZaTchh9.js',NULL,15840,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2314,'472de9e9a236fb541cb7ba07c57b39a74dad4247','f05fd06879b6be4c45602b7868fd894bb967d2a9',81,'mod_scorm','content',0,'/mobile/slides/','5oqxGwezPH4.js',NULL,15845,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2315,'3a8764a25f135e159514f7c516c43f0db189fedc','9f0d1798028d72f769097f6d2cc553eff9a0c04c',81,'mod_scorm','content',0,'/story_content/slides/','5ZkXviwmG2U.swf',NULL,3556,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2316,'ad412418c5a1fb76d71bd746864c80d2a1f1a2aa','9d59336b9996c9dbf2fc607efd55847ade047be5',81,'mod_scorm','content',0,'/mobile/slides/','5ZkXviwmG2U.gz',NULL,3267,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2317,'e58032f70232aa8cc5eb895f5a400ba45d480177','ef9bf55dc2b4cf016dacedc0c27f70af62933b41',81,'mod_scorm','content',0,'/story_content/slides/','5k07lqKhPNc.swf',NULL,3546,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2318,'7b52528e7d713f080d3875fb93579f11ed8202ce','17a14f7d1e0f7399a27c0b5c039f1abbd6386e3a',81,'mod_scorm','content',0,'/mobile/slides/','5k07lqKhPNc.gz',NULL,3257,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2319,'2e94347cd141a77e9950e779df858d8742f5b833','bdfdeffc2eddce76a95025266aed862e0be53052',81,'mod_scorm','content',0,'/mobile/slides/','6oL9QwEcls3.js',NULL,15840,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2320,'a6567b18a6bd1fb1720942beeb0b4ac948249ec9','37cd3d690569e94b9904c0d0a973c9dc277a3528',81,'mod_scorm','content',0,'/mobile/slides/','6acjCzUDKdg.js',NULL,15866,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2321,'e16fe5293e6bc06e8948d25181cae6652cbcbb6f','afa4459ad8f390d65b95ab9bb423535789fb882a',81,'mod_scorm','content',0,'/story_content/slides/','6TOW45Pxm1D.swf',NULL,3590,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2322,'070335d746f7a191414b58554f4b2337094d145a','32f882698740ff32e2f6a31280c984fa1d91e7b6',81,'mod_scorm','content',0,'/story_content/slides/','5YyNI7KLjg3.swf',NULL,3557,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2323,'6ad2ba6031405d9b4109df620774a4dbcceeaa6c','ff8bbba3e3068e459a2882b5c497d167f20e49a7',81,'mod_scorm','content',0,'/mobile/slides/','5YyNI7KLjg3.gz',NULL,3266,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2324,'6348a47a6e4da81c2192abab22ba9cab7320c0c2','4309393649a4c9cb64ed9ebf0a1708d847601659',81,'mod_scorm','content',0,'/mobile/slides/','5ZkXviwmG2U.js',NULL,15863,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2325,'38abd317ff9f7089a23e9436ee843540faf8cf79','b0ea97e6682b6a852f629addd50797a308777cf0',81,'mod_scorm','content',0,'/mobile/slides/','5k07lqKhPNc.js',NULL,15854,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2326,'1bfeeca2c09ca5d734f775b7b4101a127d7795d2','17ebfbc2ff752587fbd931e62414019ca480a215',81,'mod_scorm','content',0,'/mobile/slides/','6TOW45Pxm1D.gz',NULL,3300,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2327,'ac8b32a3b86bb8cfcc082ef976ec6637094fc5db','8f5485af6b37d0660bb74975c14f7bb451c811d1',81,'mod_scorm','content',0,'/mobile/slides/','5YyNI7KLjg3.js',NULL,15858,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2328,'aaf88a6f190f7fc78cf3747722708b7245b63d16','daf1b69cb8b538b8e7841e15662c338632bf1006',81,'mod_scorm','content',0,'/story_content/slides/','5nm1SLybByN.swf',NULL,3550,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2329,'a1f04f9af354e17f56db66966d9289d11f71e21d','745a2e85ff905f75089dab5d8327c3abd1f1da81',81,'mod_scorm','content',0,'/mobile/slides/','5nm1SLybByN.gz',NULL,3260,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2330,'60327db22d4d58e1213e069ec02e9be4897c5eda','226f41286522dfe658751de60c9790434068acb8',81,'mod_scorm','content',0,'/story_content/slides/','6KULooHo3Qv.swf',NULL,3549,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2331,'337eda141b5a128602d56d12b1fdd95240dbda9b','48d41983354cf4ef16c4ad76fc239218bd55d1e5',81,'mod_scorm','content',0,'/story_content/slides/','6axbUqNlCGc.swf',NULL,3541,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2332,'2d67b8756b998d66539f69857432898a48da7f61','0a8df61a6d10f310426e6645bdd6862c8b7630ac',81,'mod_scorm','content',0,'/mobile/slides/','6KULooHo3Qv.gz',NULL,3259,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2333,'f6af37f6f77ae562f5ddd3f132754a9b48cd447e','68992baf8b6c2693ccb013cf18f56176de84140d',81,'mod_scorm','content',0,'/mobile/slides/','6TOW45Pxm1D.js',NULL,15917,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2334,'583742436531a5df67178ca4655844e96b5556c6','caacc80e0cf7f847b16f8a10cf1761696583efbe',81,'mod_scorm','content',0,'/mobile/slides/','6axbUqNlCGc.gz',NULL,3255,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2335,'5f31bfb9383a9bc9e8f48601d7eaa4442ed1985a','0ea0167b0da8ff4b7c8438018a1c7f379bbc3f06',81,'mod_scorm','content',0,'/mobile/slides/','5nm1SLybByN.js',NULL,15856,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2336,'e33baaee45a2e1f45623a528d1813e36ec93c61f','4763875142dee00e0323c57836a34dddbc6416d5',81,'mod_scorm','content',0,'/story_content/slides/','6EveNBtNr9f.swf',NULL,3550,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2337,'d2d415d4c3957571ac2e10bc507a76a86bf6fb4f','d8ece750ab404ca8628536155a1bb80d4c6b5005',81,'mod_scorm','content',0,'/mobile/slides/','6EveNBtNr9f.gz',NULL,3260,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2338,'46008222d2a671c8d2bed48d7d0c95239d94242c','462aaba371b7787f0d89dfc8087d103221e58cc0',81,'mod_scorm','content',0,'/story_content/slides/','6QeVyvQNKg6.swf',NULL,3551,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2339,'b411f980bf8bea43a0191389e3777193ac579e78','36fa243ae68d1b6caada7ccf152bdf3960525ee8',81,'mod_scorm','content',0,'/mobile/slides/','6QeVyvQNKg6.gz',NULL,3261,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2340,'88cb74f61a21ff6b1b79e8f64cabc0d0a75aa2b9','bf2862adf6b350290b27acb235d273fbd9201b23',81,'mod_scorm','content',0,'/mobile/slides/','6KULooHo3Qv.js',NULL,15846,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2341,'de9822cb5b9a6e7ad55982c760f7a29abec99043','0a483a6eac9f63bd8f8a1f2c4dcf9180d8e2698c',81,'mod_scorm','content',0,'/story_content/slides/','5ae0VynFrEL.swf',NULL,3569,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2342,'b6072109817c60e43bb8125bb4956115153d562a','05433a8c7a55d3270776b2246d1200cc59d4c6c3',81,'mod_scorm','content',0,'/mobile/slides/','5ae0VynFrEL.gz',NULL,3277,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2343,'1cf2cff05848454cfaa5156985a24cab6d3612e5','01cb3e963659224969ab66bb4fdc68ae5cdbd928',81,'mod_scorm','content',0,'/mobile/slides/','6axbUqNlCGc.js',NULL,15841,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2344,'8f35e614e576695c97734ff2582de9f173039f3a','eaa94794a2aa2419c95171bf98ca8edae230c5fb',81,'mod_scorm','content',0,'/mobile/slides/','6EveNBtNr9f.js',NULL,15840,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2345,'ef1bf00e7c52bc9aa822833518d1a6920ba8d179','eb9bac9f937dfd8c8922e7dc29f0511a97422b12',81,'mod_scorm','content',0,'/story_content/slides/','5n7sOHCoMmE.swf',NULL,3555,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2346,'4ddfa0014a770b11d7df4b6e7e4030aee59c0c3b','9cbd1fd7906e0bf4a4de62415f1431bdd72d0ca8',81,'mod_scorm','content',0,'/mobile/slides/','5n7sOHCoMmE.gz',NULL,3265,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2347,'865a75d46b06f83bc3884d1f71efdf4f5a57a143','f93d9f146628dbe7f6108b84cf9b1e708061c75c',81,'mod_scorm','content',0,'/story_content/slides/','6kB9h36ZEsO.swf',NULL,3553,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2348,'ad05015589001dec67f326603a62bb72d7da7e16','900a825f98aaef96775847778f6ce3714bc38a97',81,'mod_scorm','content',0,'/mobile/slides/','6QeVyvQNKg6.js',NULL,15853,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2349,'c58131502edec427bb5333fcf1811eb909bccb1a','9022fc50fd6a5af8ab5f5ae62f120e2475127b23',81,'mod_scorm','content',0,'/mobile/slides/','6kB9h36ZEsO.gz',NULL,3264,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2350,'c2c2395562d8d7cf48b2ac563587cd60830e58a2','97408fb4e7d89ad0c930040efccd4cafd987f12d',81,'mod_scorm','content',0,'/story_content/slides/','68SUmN8n00T.swf',NULL,3549,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2351,'49ca7198b9eaea53777181f02625aab2458b519a','75c7d5a8cd23c51e8fa4ac27e5762123850cece5',81,'mod_scorm','content',0,'/mobile/slides/','68SUmN8n00T.gz',NULL,3261,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2352,'85935e48faab1b72f08430d3a3b5101bdfe8a0d2','27b208cf0ea8e7fa60cf4463db248d31f705743e',81,'mod_scorm','content',0,'/mobile/slides/','5ae0VynFrEL.js',NULL,15864,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2353,'3a48c974e451a5e18a53369ea5f8fa6e7f726f4d','855e0eacd9d09be99f5023cba85466367ff69374',81,'mod_scorm','content',0,'/mobile/slides/','5n7sOHCoMmE.js',NULL,15857,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2354,'8b50ce3422fa63aa54bf4a050b1b2534a19f812e','919b188848c1ad74e9da6b654ba17e0a5c635013',81,'mod_scorm','content',0,'/mobile/slides/','6kB9h36ZEsO.js',NULL,15856,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2355,'daa5babf0459b5c8d94afc050c8a86b1fbb7dad8','9ca5982dec251a387366200b4a237ca529f26a3b',81,'mod_scorm','content',0,'/story_content/slides/','6jFoOFyaExM.swf',NULL,3544,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2356,'a0e699e180c6363404f8d7be8f7520f317052bfb','31a73e23a2fbbc1a9a7785347bf93692926c8d7a',81,'mod_scorm','content',0,'/mobile/slides/','6jFoOFyaExM.gz',NULL,3255,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2357,'432d88f662f53ee1a2d96a486c7401a0a0804697','221001dd207e68d323e339b3efa7836ea282afdf',81,'mod_scorm','content',0,'/story_content/slides/','6oNQ2s7Y6hY.swf',NULL,3546,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2358,'e28a9dcc66f8f9cb2f6afa90391c72f28ba38723','082df32b24a7983bd5434829ef506ffbafefc448',81,'mod_scorm','content',0,'/mobile/slides/','6oNQ2s7Y6hY.gz',NULL,3257,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2359,'17ab46d60e96fd9f48eccf15f91f0ca9ca3adb2d','8730066f4642fe0eee3fe54995f252ae1d257eea',81,'mod_scorm','content',0,'/story_content/slides/','6D4j3kuUb0U.swf',NULL,3573,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2360,'d78839e9949367ea563752e30d35512bea024ea4','5c4c56d6f7d1ab1c0a0294cbfba043f25f9670cf',81,'mod_scorm','content',0,'/mobile/slides/','68SUmN8n00T.js',NULL,15864,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2361,'dfa637f2213d5e8f1c603b3dce0c8cb6f43623cf','82c81b84dee41846032520fde04af34eabddbe01',81,'mod_scorm','content',0,'/mobile/slides/','6D4j3kuUb0U.gz',NULL,3282,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2362,'2df213987bc222ce6cb924a9e91b4ffaa1198188','fc5a1d9b8eb5bdaacbc472f5c70ad6cee37fc24a',81,'mod_scorm','content',0,'/story_content/slides/','5ssdfYGwh8P.swf',NULL,3552,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2363,'d321bd29868fbe3539e77f556eb2d0b4e0a59691','8c54f5244ea84f37cb1310c5d43fa21a4ac113fe',81,'mod_scorm','content',0,'/mobile/slides/','5ssdfYGwh8P.gz',NULL,3263,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2364,'d813ee40dbba0d435ae7012be56f9e78593910c3','8e8a377deb3f998fda727fcf357011a9ac87254d',81,'mod_scorm','content',0,'/mobile/slides/','6jFoOFyaExM.js',NULL,15846,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2365,'f56801eedfdef4d58bf2f6c2202898a787a7aed2','a8625821fdf18823721ff089fb01bcb7575be1d4',81,'mod_scorm','content',0,'/story_content/slides/','5lCLntGZr7R.swf',NULL,3555,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2366,'912cbadb0b0f8fcde40f20ad4a2217c2c8bb85c1','1bb526287eb97507e28b39e3f315347dadeb6f00',81,'mod_scorm','content',0,'/mobile/slides/','5lCLntGZr7R.gz',NULL,3266,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2367,'73502296e2ace405554e6ab430e9e4978ca12122','08b86d4158d95698148738a2938135e4caf598f0',81,'mod_scorm','content',0,'/mobile/slides/','6oNQ2s7Y6hY.js',NULL,15843,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2368,'0fd5d88a140dd1bdbf7ec05de64cc58d4bcd6b5a','eebcf97659259d88a7eef8212ad8a2b6318c4b2d',81,'mod_scorm','content',0,'/mobile/slides/','6D4j3kuUb0U.js',NULL,15884,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2369,'8bdf8c8499e84aa93a3cf6acd959231d4b9452c9','40ac3f3b11a04de98559b12833b0a863482406cf',81,'mod_scorm','content',0,'/story_content/slides/','69NS6iS3xC2.swf',NULL,3554,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2370,'1350d34f9139b275c72211dd1e72af4ccdeaff8a','4d6196c3cdd284d4e99ae4a872f67bfdb57d9264',81,'mod_scorm','content',0,'/mobile/slides/','69NS6iS3xC2.gz',NULL,3265,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2371,'b8ec81246f766d19bf641a028600a15618bf3bbf','2d211ff58b334502d67de7c46b5bf1ebd3a556dd',81,'mod_scorm','content',0,'/mobile/slides/','5ssdfYGwh8P.js',NULL,15847,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2372,'c020bf3263a0932c3613325110a6d148e789dd11','4e0ff045ab415d3d82e269c0a420d57f60fa4087',81,'mod_scorm','content',0,'/story_content/slides/','6SCstq0pYPH.swf',NULL,3545,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2373,'e40c62cf8cf97c9768da161a614302d2288b5ac8','0979a911f3c813296f40055819e8a7886b3653d4',81,'mod_scorm','content',0,'/story_content/slides/','6n2uyBJDsza.swf',NULL,3547,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2374,'7d617dcfb329d2790e8148b6e65ea48d7dbc1cc6','8c804d3b5c7f0b8d1c35ea1525aaa430f9cd5695',81,'mod_scorm','content',0,'/mobile/slides/','6SCstq0pYPH.gz',NULL,3255,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2375,'2478e607e76d015cafb60425bbbcca299089ab41','33b997cae58083ae093e487bfe036b1da618404f',81,'mod_scorm','content',0,'/mobile/slides/','6n2uyBJDsza.gz',NULL,3259,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2376,'1faacfc292bdba53c33d0058e9d1174e8fa717c7','eee8fabccab1ca3382ffa31653a5f2860bcea22c',81,'mod_scorm','content',0,'/mobile/slides/','5lCLntGZr7R.js',NULL,15856,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2377,'4afc8b6b45ba63490608c59b3c1b4746862ae81e','e199e6b0887b1a12f34456674387189c20661e60',81,'mod_scorm','content',0,'/story_content/slides/','6pEHmZXE4nJ.swf',NULL,3558,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2378,'22a037de6eed852ca6a644731d13745f5bac7d9d','47485be9b2d41c562e27817af1d25f55689cb4bc',81,'mod_scorm','content',0,'/mobile/slides/','6pEHmZXE4nJ.gz',NULL,3266,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2379,'84f0ca0a4ff2b5a6ac3b8b6111774d60f5fbc375','cd48b55849acbe55047f5767f1b38de6b988d1db',81,'mod_scorm','content',0,'/mobile/slides/','69NS6iS3xC2.js',NULL,15858,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2380,'37127f5861657bf8af208f7af4d46dfe18df7cb9','6d8ce457508725f98ddc9efc25923dbaed2893c1',81,'mod_scorm','content',0,'/mobile/slides/','6SCstq0pYPH.js',NULL,15846,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2381,'0267fe1a320c10fafab0345869a1016123507118','ef0a9be0bc0a55625e4448a207e0d359d1d1bca8',81,'mod_scorm','content',0,'/mobile/slides/','6n2uyBJDsza.js',NULL,15847,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2382,'9471bc1bddf59d84fd9c8e1b4a9d18c1edf6ede5','559eb58fdd3212e4bba5c7b2b7376fcc9836507b',81,'mod_scorm','content',0,'/story_content/slides/','6r4kaSrGjes.swf',NULL,3554,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2383,'253899cfb8125ba2ec52e4643303682d03217115','56134dc2525de80997c6a59611f89b8e42e709a9',81,'mod_scorm','content',0,'/story_content/slides/','5z4XkW6QFep.swf',NULL,3557,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2384,'7de1d3a27ac8e0df0696adddb2966c3f06f8d744','d8f5b39415e6aebe39bf771f3428e9a068690b17',81,'mod_scorm','content',0,'/mobile/slides/','6r4kaSrGjes.gz',NULL,3263,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2385,'183efed5bce8771fb9b754bdec427b3ae8fe9fc5','c60daa20625e41c1ff67579767142e6516073d67',81,'mod_scorm','content',0,'/mobile/slides/','5z4XkW6QFep.gz',NULL,3266,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2386,'fd1fa2edec01a60efd2105ec2afc0a3e99147e6d','8f73a3b2625735ddb2e252e174d3ce704953f67d',81,'mod_scorm','content',0,'/story_content/slides/','6qcgYoWz6aQ.swf',NULL,3552,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2387,'4b74ba89a72ec09fc25acccfcbd01ca5704080e7','c4d8b12516db0e4d505b4820cab2ea59f1bb0f82',81,'mod_scorm','content',0,'/mobile/slides/','6qcgYoWz6aQ.gz',NULL,3261,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2388,'08fe39d65a1eb61f8f10ae0cbd47d3c3a9cd2c97','4b25ea8f08c3e7bc750d8ef3ce5db749c5a9ad0b',81,'mod_scorm','content',0,'/mobile/slides/','6pEHmZXE4nJ.js',NULL,15862,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2389,'a3dc831158e8c0233ea432fac320958b8029c687','f2579053acffe5727de1a856169673922d9002f5',81,'mod_scorm','content',0,'/story_content/slides/','6k24rN0rAnv.swf',NULL,3559,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2390,'47b3cd1b1af95626132058464b2ce684f12546ca','a95732ffbbe5c500aced7b4309d3c91dd7ad1f54',81,'mod_scorm','content',0,'/mobile/slides/','6k24rN0rAnv.gz',NULL,3269,'application/g-zip',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2391,'f651af1a9915ada2bc5c5dbc05dddc68ab6f5dbc','688ea94cddba412d5fba7f9da19d88b8b6fa648e',81,'mod_scorm','content',0,'/mobile/slides/','6r4kaSrGjes.js',NULL,15862,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2392,'64e73e38f14f2ebd6cb999f81e50bb26348a2d1a','a5fe20ceab6ff8245de9a9aedcb3ee6782eaa649',81,'mod_scorm','content',0,'/mobile/slides/','5z4XkW6QFep.js',NULL,15863,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2393,'20c9bd2c85b612a72a4d25065c25c2e0812b8579','97b96b82b288399615951f780a189be3243800d6',81,'mod_scorm','content',0,'/mobile/slides/','6qcgYoWz6aQ.js',NULL,15854,'application/x-javascript',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2394,'d5dc8da16918dc80010fbea15a8d04536c607fbf','041c0cd733da4bec488e9f0017599454b58977ce',81,'mod_scorm','content',0,'/story_content/slides/','6EMOirLJLu1.swf',NULL,3546,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716818,1462716818,0,NULL),(2395,'8f120467a7c7a370e24c6f5845fb78719133f402','2ef0d7c14fc6668bc81bdef43dbbf6be6604bed9',81,'mod_scorm','content',0,'/story_content/slides/','689QDSxwApj.swf',NULL,3554,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2396,'f279f1f9497212b01101e710a9db97afa0e5f7d5','6de6ec73332667783a3ddea8a6594b662e448d92',81,'mod_scorm','content',0,'/mobile/slides/','689QDSxwApj.gz',NULL,3263,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2397,'2219769698b8b5299792390e7c61c944a94c689a','3b6d1bc5ee47ed3b4bc85db1f58d944898b3796f',81,'mod_scorm','content',0,'/mobile/slides/','6EMOirLJLu1.gz',NULL,3257,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2398,'2312c4061ffe9c065f3e45260784469fa55785d2','ecc123e6bfa65b9392fa87d406d331cf238b4050',81,'mod_scorm','content',0,'/story_content/slides/','5ZL0HFarszg.swf',NULL,3549,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2399,'581a985ad60ca3df17826e9fd1e54ba54a9eb323','d349c0286506a78d2ace6012d972545a4c2a5925',81,'mod_scorm','content',0,'/mobile/slides/','5ZL0HFarszg.gz',NULL,3259,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2400,'0d4893d4b3aa6ad6dec02bbf7cbc0c3f43ebb7e5','b0a3e62b57fc683c2fdbcacd033be2c6ea722c54',81,'mod_scorm','content',0,'/mobile/slides/','6k24rN0rAnv.js',NULL,15872,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2401,'79ce95d8aafb675adbbe78de8fea3887f0fe7a32','96105f917905ff40f2327f31ab3f149b983b18fb',81,'mod_scorm','content',0,'/story_content/slides/','6kxKRyY3Fkq.swf',NULL,3546,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2402,'f59622564a8911dac818bf24867d8feb677b2f30','4aa967aa093ec2f688401d5abb0bfe1e6dfd1419',81,'mod_scorm','content',0,'/mobile/slides/','6kxKRyY3Fkq.gz',NULL,3256,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2403,'9b3f9ae4b0468fefae4a49b263428d886c96ef06','6a41ecb6b489d95da5136f48dfec774f09ba5e1d',81,'mod_scorm','content',0,'/mobile/slides/','689QDSxwApj.js',NULL,15856,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2404,'95f3c41866536d47c7974230be4773770f689a8a','005fcea9f21476b116bf90e594177de7c8f1d287',81,'mod_scorm','content',0,'/mobile/slides/','6EMOirLJLu1.js',NULL,15845,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2405,'306bf31a665bf1eb50fca842ed0cf2906f5b454d','b40e300ddb630605e1ee76c44ce56c9ccc385e4d',81,'mod_scorm','content',0,'/story_content/slides/','5pYEBNgoUk9.swf',NULL,3554,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2406,'3bf30ccb6c6e74c8c1fcfa76232a98dfb0c0b7d2','1a20a68921793ab191acac0c405453954c6c0719',81,'mod_scorm','content',0,'/mobile/slides/','5pYEBNgoUk9.gz',NULL,3266,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2407,'b8e0de6b466bdf5645489c4941a594ebfd9bf38d','f83c94a9a765329ea6260bae1b2c536311705662',81,'mod_scorm','content',0,'/story_content/slides/','6oP7zcLA71t.swf',NULL,3548,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2408,'369802a86ea2993669672f46d0c83c5880eb0551','26bafb1bf730ab0ea22c90ffb573b03124d2fd4d',81,'mod_scorm','content',0,'/mobile/slides/','5ZL0HFarszg.js',NULL,15846,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2409,'cbb0439bbdfda627a5cb15f3b5da9d45e5204398','dec682c7e6a437a7b4f6fab9dd0220a4481755e8',81,'mod_scorm','content',0,'/mobile/slides/','6oP7zcLA71t.gz',NULL,3256,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2410,'646ef3fa17ff58913abf7ebfb3ab28adf585324e','b78d19f77179b40a8699d36d1d93e78c7cecdb22',81,'mod_scorm','content',0,'/mobile/slides/','6kxKRyY3Fkq.js',NULL,15842,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2411,'2e2dc04c06554f900f915546328bacc50f75797f','e4084fdeda559779c8a75044ed3d9689a0504d41',81,'mod_scorm','content',0,'/story_content/slides/','5mQeCDXaVSV.swf',NULL,3550,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2412,'3fba68572183c09c1a24edde0905d87510964441','9cf00ac11fbb7a505b9bc4eb6c381f09e4c581d7',81,'mod_scorm','content',0,'/mobile/slides/','5mQeCDXaVSV.gz',NULL,3261,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2413,'ab24008c40c71fbb48f815122c04d0173108342f','f465112bc393c387abfe7f1dbfac08aef59bbb20',81,'mod_scorm','content',0,'/story_content/slides/','6AEAK0HmvrT.swf',NULL,3551,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2414,'b849d184594de0232159834c6723e750d1ffe3d1','5726f6ca2e30c9f60f409c58b0f0cf6d211eb4f2',81,'mod_scorm','content',0,'/mobile/slides/','6AEAK0HmvrT.gz',NULL,3260,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2415,'536c73280134df4557b7ac3896d81f2241b877ff','8ed3f2b607db1d859266abb98152059a14bb8017',81,'mod_scorm','content',0,'/mobile/slides/','6oP7zcLA71t.js',NULL,15841,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2416,'a50c694a93a68f91882758a1eab2837e1b16f54f','168ddb90bbab67df811b357d33ebe1359a7f5ea8',81,'mod_scorm','content',0,'/mobile/slides/','5pYEBNgoUk9.js',NULL,15859,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2417,'b6bc5049b9a1f6eb9daed3752f92fd54a306d097','9ffb2d657683cf96953d7d43d8e9372f8022ac94',81,'mod_scorm','content',0,'/mobile/slides/','5mQeCDXaVSV.js',NULL,15850,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2418,'8f54e91e5a88dfc96331f496112dbc3abeb2a932','4ccc0d016bc97d900554c5406b6e7ad2caeb7997',81,'mod_scorm','content',0,'/story_content/slides/','6RtYrIlNNgq.swf',NULL,3557,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2419,'6781ca5ae378ea70b7cdeb51a343b40b94071b70','552c0f94856955411cc9dbf2fe3f798336c0309c',81,'mod_scorm','content',0,'/story_content/slides/','6m0rkIjkrIf.swf',NULL,3568,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2420,'165586fc8305b58ba764f5aa9e9c72a64321bfde','c3386eafed00a6cc70dcb1720425e9953d497c1a',81,'mod_scorm','content',0,'/mobile/slides/','6RtYrIlNNgq.gz',NULL,3268,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2421,'912c9d8b36c00de8bc1aa6f9fa549dfc14953266','70b33aecc1a0649b941db085f50c676bb0dd4deb',81,'mod_scorm','content',0,'/mobile/slides/','6m0rkIjkrIf.gz',NULL,3277,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2422,'74abc3b64b3178598b23f43e23fc35f1c3345d14','699053962212bd877b85e6dd909e3a642436a649',81,'mod_scorm','content',0,'/story_content/slides/','6nRGdxXhAab.swf',NULL,3556,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2423,'087bc89fcd6a879d09b88b3298964481c6bc937f','96c6618e0712a390d94ae3b8cf2eaa64b5f40a8f',81,'mod_scorm','content',0,'/mobile/slides/','6nRGdxXhAab.gz',NULL,3265,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2424,'361405095daecfcd2ae20c8d7039c4fc24fe99ad','0906e25b510c88b5e78ec549957a9722b59ff919',81,'mod_scorm','content',0,'/mobile/slides/','6AEAK0HmvrT.js',NULL,15847,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2425,'f02e3b536cc5809b220ea35a151f12ca125acb2e','720300bd778ec8cd1478bc8aabd02cc1d6d1d6e1',81,'mod_scorm','content',0,'/story_content/slides/','5YNKLWNuoEf.swf',NULL,3544,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2426,'b239f7c22371faca955e6ae7534179f02eef8471','fa5e7cfc451af81a3864389a713aac2fab5eb3ae',81,'mod_scorm','content',0,'/mobile/slides/','5YNKLWNuoEf.gz',NULL,3255,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2427,'7d21e4c3f0f243e98b2d4f8f49ffa7e50aa54bd1','26ebc61315943fc48c3ffbee4ea77388845e68e4',81,'mod_scorm','content',0,'/mobile/slides/','6m0rkIjkrIf.js',NULL,15888,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2428,'f482bc4fdddcdf4103fb36a031f3598085eea3b6','e27233e0226f033f8d70388806f5de7d821b0fbe',81,'mod_scorm','content',0,'/mobile/slides/','6RtYrIlNNgq.js',NULL,15860,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2429,'765d4626046fcc6400a44344db4bf48c835ebfd3','710eac6a62548a1a3d71161d275ea970e699f688',81,'mod_scorm','content',0,'/story_content/slides/','665YGDsN0Eh.swf',NULL,3565,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2430,'5bacbafb84e76685d1610afac0ef91b9e2ec2356','3bd2fd84519d32fe48dda41bc0296dc18598c98c',81,'mod_scorm','content',0,'/mobile/slides/','665YGDsN0Eh.gz',NULL,3274,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2431,'85ebc6a6cddeb241dc5510da8a2892a6fec925b6','aa807337e2088281de59a06cd7caee6550c7514e',81,'mod_scorm','content',0,'/mobile/slides/','6nRGdxXhAab.js',NULL,15856,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2432,'d559c99faa4bc01c0d943dd70b8682c5e8e3d823','972abc32a8785691d4718763dfeada000e5a0ef9',81,'mod_scorm','content',0,'/story_content/slides/','5ZsXVWg96xg.swf',NULL,3556,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2433,'8516ee3f6d8b4f334617f9a1e131c92a81b7882f','5695d3a4dc3dd9e7ae1e74d90fd4584d9d92d327',81,'mod_scorm','content',0,'/mobile/slides/','5ZsXVWg96xg.gz',NULL,3265,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2434,'6e25029d0925b543ccbb0cf1a17ef50993f0c1d5','443e03ed2f2f360dda206b413466b69ef78bcbe7',81,'mod_scorm','content',0,'/story_content/slides/','6att82M7nc9.swf',NULL,3544,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2435,'10806f6d7990e64a412e92e0604c221332bd28bd','d9bb3b734e6a95c2d3b127c7e4f049ad41942477',81,'mod_scorm','content',0,'/mobile/slides/','6att82M7nc9.gz',NULL,3256,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2436,'2575b9f408e5c342e60c3b59b9bdb464724f8b2b','82c04a5e2125abf5f93c66e1fa01ddfacd242c2d',81,'mod_scorm','content',0,'/mobile/slides/','665YGDsN0Eh.js',NULL,15868,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2437,'7529976e4ea9695cc794c9ac3319e6382f8c15d6','4be14a15f2a7c2aad84472a5c14df68bf68a210f',81,'mod_scorm','content',0,'/mobile/slides/','5YNKLWNuoEf.js',NULL,15844,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2438,'8cbd98d2f013f591e0b235ff70ef8248e5ac2554','fa7033f1568f01c10adc742a1d8f2d0a7c2b136d',81,'mod_scorm','content',0,'/story_content/slides/','5xSQRfsp4mc.swf',NULL,3545,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2439,'43a1a4c4560f312504f8c924b7fad4a061d7bc6a','77a425feac23746edfc809ab7fba8dd93af14fc6',81,'mod_scorm','content',0,'/mobile/slides/','5ZsXVWg96xg.js',NULL,15859,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2440,'7c086f322d06f3f17304282404c63284afcad118','b1b15fbcda54c8aec3657aab2f66a51435df54e6',81,'mod_scorm','content',0,'/mobile/slides/','5xSQRfsp4mc.gz',NULL,3256,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2441,'c3915215d01bf023222f072a6f48846d1ddb736f','e34559d455290e094ff4ae369e76f6f86b2d0bb3',81,'mod_scorm','content',0,'/mobile/slides/','6att82M7nc9.js',NULL,15846,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2442,'ff7f15cdf1afb9f870d7064f387b64b4d6254c2a','ecc0658be895f836aaa21daea04a9403bb2521a4',81,'mod_scorm','content',0,'/story_content/slides/','5ZPprNPEJAK.swf',NULL,3554,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2443,'e4cfe961029487bfee83eae7cead4a1ad790f468','c1d0b43f6530f92b444c727dcecb56df1428de0b',81,'mod_scorm','content',0,'/mobile/slides/','5ZPprNPEJAK.gz',NULL,3263,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2444,'738d0eacd29694aab1dce9f724761bb7fa05b433','fffda8fbc426ef236ffc29e84690f88435232745',81,'mod_scorm','content',0,'/story_content/slides/','6kTH0D999rs.swf',NULL,3558,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2445,'8b928c1f5956a9d73f91ac5b292b18ba9e3776d6','fb39c648fbc3172134150048148f517798cb75e1',81,'mod_scorm','content',0,'/mobile/slides/','6kTH0D999rs.gz',NULL,3269,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2446,'d1ce345a2fb670ef16ed224422ae0afca6c94325','06889de4b3d362b9dc0405eca8d27856017cfe2e',81,'mod_scorm','content',0,'/story_content/slides/','5V6hOYrHljP.swf',NULL,3566,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2447,'c264b7e41f94966b25db3839994b03e27b8ed6ee','6f9f4cd69eaa71f3b95c561c31b10b10913a658b',81,'mod_scorm','content',0,'/mobile/slides/','5V6hOYrHljP.gz',NULL,3275,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2448,'a72e3e5cb14683ec509517c906cc474be5b89cf0','78dd0f7ba3a11382de9429c6c6e856553f3bf942',81,'mod_scorm','content',0,'/mobile/slides/','5xSQRfsp4mc.js',NULL,15849,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2449,'3e72747c1e2d7823c474d9c1b864a59b82195582','3e1b4deae710e668200a2498b55aef4c4e134912',81,'mod_scorm','content',0,'/story_content/slides/','6UJbGbHghl4.swf',NULL,3551,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2450,'9ff54875552304f4bb7bc83552c8802a9ebe717a','fb242b0eeb02155aed4cc6bbcc5fe588545d63f9',81,'mod_scorm','content',0,'/mobile/slides/','6kTH0D999rs.js',NULL,15871,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2451,'cffe30e786c09fa1ca7254e9f4ba50add716cc24','199bf8abbff6ac085f5c753c2b7bd66733f06cd3',81,'mod_scorm','content',0,'/mobile/slides/','5ZPprNPEJAK.js',NULL,15858,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2452,'59115daf5f6685eddfe46136b28a9fb0253ae7b2','5e37e8822f0e6c4b661e53393ea887f2857c1989',81,'mod_scorm','content',0,'/mobile/slides/','6UJbGbHghl4.gz',NULL,3261,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2453,'189b25ae0b7039302dbf0de732bc61eb6ce6469e','41163ba7317565143a27ea61cfa1ccbab33e0aea',81,'mod_scorm','content',0,'/story_content/slides/','5ftFfFRIWPv.swf',NULL,3560,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2454,'b4ebb9c37a0cca789f50edd6005396d95dacbbfe','5278515ae27e8ae3ca230c728f01c0c18bd4ce52',81,'mod_scorm','content',0,'/story_content/slides/','6HvJ5JE4fDL.swf',NULL,3560,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2455,'a9b30668b600025bd88912dae6295e3f1bd4dff4','5c10f3179c37cf60098ebc58c87299b720ba8571',81,'mod_scorm','content',0,'/mobile/slides/','5ftFfFRIWPv.gz',NULL,3269,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2456,'5760287944913f3a76bd2f0ff81c62613caec174','5a5946a510a868f2a399fbf032e2db2f6fecab48',81,'mod_scorm','content',0,'/mobile/slides/','6HvJ5JE4fDL.gz',NULL,3270,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2457,'b538b680c79f8f4b19f485d8adaa012d1db367f0','82d1b785c81f18f275628c15c3901ed5a9345a89',81,'mod_scorm','content',0,'/mobile/slides/','5V6hOYrHljP.js',NULL,15879,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2458,'38a4cc0bfae9936f957f53b473551c933c245621','d5c050b149ccef60101deeca3da66c8b64a15e52',81,'mod_scorm','content',0,'/story_content/slides/','5Z9aD1yOLre.swf',NULL,3539,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2459,'219514ea61ef31809f39ba3a1024ddd1f9e733b5','67b6127757b9822f86c6f793d772acc5c263baf7',81,'mod_scorm','content',0,'/mobile/slides/','5Z9aD1yOLre.gz',NULL,3251,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2460,'9b726792bf968fc1340b5630b7d713fa56ca640e','0f6cee3bce4ff8972fbedab0a283f98e51db5d3d',81,'mod_scorm','content',0,'/mobile/slides/','6UJbGbHghl4.js',NULL,15854,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2461,'b2a28215a21398c5dbbe11854e5168524a81cb5e','039ac900a11ba441591ccc1864b24f69f4b0f905',81,'mod_scorm','content',0,'/mobile/slides/','5ftFfFRIWPv.js',NULL,15862,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2462,'9ef0ddfcfe30da283204aa1501cfc623e3316d79','42153841cdeb47a5a060c63a5b8522a41c522a86',81,'mod_scorm','content',0,'/story_content/slides/','6Uzq1z51Z5u.swf',NULL,3553,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2463,'c63c01cb222cbab9f592db1af3bcccdd209cbae3','0aef6e1154be1829a5cd3a76f85dc4c738913636',81,'mod_scorm','content',0,'/mobile/slides/','6Uzq1z51Z5u.gz',NULL,3262,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2464,'63fb86ba4ba3dcea8edb76ccde34b1bbdd5d698e','efdfaa3c9fa176f4161818f940b4fb848c1b542a',81,'mod_scorm','content',0,'/story_content/slides/','6eqYDliwX6n.swf',NULL,3579,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2465,'2dad0e115b3283765ac7b7c925d6bf96df81122a','b2883128e1d76d594f42cbb9f960cc983f5ee137',81,'mod_scorm','content',0,'/mobile/slides/','6eqYDliwX6n.gz',NULL,3289,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2466,'ca33b090673d0009d5d3503d1af2347c368bdf3a','ad09a6aa6c9e9a435daed70575b6294d56549ad1',81,'mod_scorm','content',0,'/mobile/slides/','6HvJ5JE4fDL.js',NULL,15859,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2467,'d4069c505a6fe4ed4691e9c7b4cc4c05d87a7912','caf2944d8608db1e176b5f45ab2b62256d7a5536',81,'mod_scorm','content',0,'/mobile/slides/','5Z9aD1yOLre.js',NULL,15846,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2468,'fe7c2acb30e94ccd88e1ab3dca95253e395cf3de','7b7a974781f58464fadc72be20672cb8da2727f2',81,'mod_scorm','content',0,'/story_content/slides/','5nQ9gcvVSyw.swf',NULL,3561,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2469,'6778a57d6a3e09ec8ceac9fbc0a9fa8cfec4bffd','4073f2c44ee72bd7d379fae86ce759a82b39ffba',81,'mod_scorm','content',0,'/mobile/slides/','5nQ9gcvVSyw.gz',NULL,3271,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2470,'c85cbcb0627a7d7721084fd0bcec476722ab74f7','d2c9e29d95a19553e1bd05dd9c7307933eb301cc',81,'mod_scorm','content',0,'/story_content/slides/','6qstFhIX8gX.swf',NULL,3554,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2471,'a0659decae18e25c480af80bd33f6cb082147fdb','d67e9998599ab9c87ea81db2c8575f378e23a39d',81,'mod_scorm','content',0,'/mobile/slides/','6qstFhIX8gX.gz',NULL,3263,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2472,'95ee6d20cab58bccdcedfb7cf38c668558968895','b8e916a10d1e70fd15f5eb9d6688f6fe65b7d50a',81,'mod_scorm','content',0,'/mobile/slides/','6Uzq1z51Z5u.js',NULL,15858,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2473,'5bda5d87ed3c87f968050eb0ae0851371e60f092','35ec5c2d20b319e1f9eb14c68076f576a545a919',81,'mod_scorm','content',0,'/story_content/slides/','681VT8mAoGA.swf',NULL,3558,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2474,'4db72e3b1cecd053f2f9335a8c46002e4fbdba7a','0df8b787885800dec07644cb90c7896810474bf7',81,'mod_scorm','content',0,'/mobile/slides/','681VT8mAoGA.gz',NULL,3266,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2475,'11140c8861a0ce4607bdd23c14358e2c19c5418e','062996a402134b0a3187eaca2c5c2ec27d290cb8',81,'mod_scorm','content',0,'/mobile/slides/','6eqYDliwX6n.js',NULL,15890,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2476,'e3fc04be45d2dc1200479973cab27345d240e60c','94b9ec48f372830eede3bd4e76b8a8148c8915bd',81,'mod_scorm','content',0,'/mobile/slides/','5nQ9gcvVSyw.js',NULL,15866,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2477,'b4851fe7b9502ff52f6926ed414355c842bd7042','efe268ee3cffe09fe9c13dfcb64cc9ee8665e0a8',81,'mod_scorm','content',0,'/story_content/slides/','5aoO1JYsG4h.swf',NULL,3573,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2478,'fca880bd02a2ef16c2a5772fae64595bc70f641c','5c880f96a373d98b1c325a52fa3b764340a8f639',81,'mod_scorm','content',0,'/mobile/slides/','5aoO1JYsG4h.gz',NULL,3285,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2479,'b9ad18f35bec0e23463ad042e51d23b857062235','3c892177c58e60a6caf432718c9db12b2659f45a',81,'mod_scorm','content',0,'/mobile/slides/','6qstFhIX8gX.js',NULL,15845,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2480,'c040fc6996a836e20e669a0e05a48637424de594','4d7b79c7bb10da5094fa116c71b4ae358615b367',81,'mod_scorm','content',0,'/mobile/slides/','681VT8mAoGA.js',NULL,15860,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2481,'d8f19e97991d4b00798dd7904e50d023c0008b25','9c2cace4db589a7c0df88747f98a1d24f385f05c',81,'mod_scorm','content',0,'/story_content/slides/','6b7KGH3xWFB.swf',NULL,3546,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2482,'84942cbd6591096257bf0956ebed5462cf57c6ca','ad546f259015a47624ab84aa5705fb6e310c1273',81,'mod_scorm','content',0,'/story_content/slides/','6Gny6yfTm08.swf',NULL,3548,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2483,'36f8d2a3c290b690a42ce2e366a20a192c60fe27','dd7bff2c7848b4082bf922ac04b963da0747a0a5',81,'mod_scorm','content',0,'/mobile/slides/','6b7KGH3xWFB.gz',NULL,3256,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2484,'5415057f773d9da087f19ec9ceb3ee68ad414d58','ec3d6a93bf9a26934f284b897299724c2e41e016',81,'mod_scorm','content',0,'/mobile/slides/','6Gny6yfTm08.gz',NULL,3258,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2485,'d95b8e49803945dac2722b24c1b8763e4aa3c20f','0b8314d562f1e3e973d62b3b5291ce33da637c35',81,'mod_scorm','content',0,'/story_content/slides/','6H7BkIp2UOC.swf',NULL,3561,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2486,'39f3f681dd86fd6e9adb4804fbad3545467058e5','7deba82cf62ab1387736b1900d194417a3378ca3',81,'mod_scorm','content',0,'/mobile/slides/','6H7BkIp2UOC.gz',NULL,3270,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2487,'06c16e383784889b0462d1ae6030151717b9e0ac','3c5aa9fd0418886ae0b0ee382ca195bf27ed8eb7',81,'mod_scorm','content',0,'/mobile/slides/','5aoO1JYsG4h.js',NULL,15896,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2488,'fb3e182e8305cba2572d0e6d753df2c864b8dff3','c221c13f66a9e288be4df68707ab007b4ee8837c',81,'mod_scorm','content',0,'/mobile/slides/','6Gny6yfTm08.js',NULL,15846,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2489,'383665cdfad82c682626788114cc748dfabcdb3a','fa8fa9189aee4b93c915022752d96c5311f430f7',81,'mod_scorm','content',0,'/mobile/slides/','6b7KGH3xWFB.js',NULL,15842,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2490,'29aa3e4f2dd92de26fac9c122b7898346e7a9320','944b2b7b8fd0fdb2895de7b2f640cfab7eada149',81,'mod_scorm','content',0,'/story_content/slides/','6Nh9M2lHIJq.swf',NULL,3550,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2491,'e5a0a4647406aafb11c93fab50cb6dd9cd9552be','331293c9f813c944e951b31ff30365494b5ff9e6',81,'mod_scorm','content',0,'/mobile/slides/','6Nh9M2lHIJq.gz',NULL,3259,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2492,'ab4dc200656345fad4b36ecfe15669dec08831fd','cb19669ef2922000e46a3b41d532e0ccfc346f11',81,'mod_scorm','content',0,'/story_content/slides/','5pjbb4k1kdF.swf',NULL,3546,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2493,'0c8ce8665e95f750a5eb0cb8459e79e9e70d3d4e','c5ed76bd69707790b1fe5dce42681355471230dd',81,'mod_scorm','content',0,'/mobile/slides/','6H7BkIp2UOC.js',NULL,15868,'application/x-javascript',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2494,'9c17e8bea23ed41de3d7b91943583931140cf6cb','88de3057864bef258c8f7b634bb0926186da4729',81,'mod_scorm','content',0,'/mobile/slides/','5pjbb4k1kdF.gz',NULL,3257,'application/g-zip',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2495,'41f558142111d4d8e73d3b62adf87e5c8d162121','770d38a05d2a3e24917687be809791082088de23',81,'mod_scorm','content',0,'/story_content/slides/','61iVZJ4sPrw.swf',NULL,3559,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716819,1462716819,0,NULL),(2496,'29a9ee6ea30f7ba75df285b607858edca71763ed','1165e17ce372c8239b2771bd747264d1620d1a23',81,'mod_scorm','content',0,'/mobile/slides/','61iVZJ4sPrw.gz',NULL,3269,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2497,'977a61a54f9b119ba2f8d547cb851662e447abdf','ea73eedba3dad44f1bba5ac110b947ed582fd3c7',81,'mod_scorm','content',0,'/story_content/slides/','5ywdXPuHFho.swf',NULL,3556,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2498,'c3bff8333efb3bbc14628f7481ff9a16fad6e39b','3b5df674786f802ac11b55bfda68e86a24128517',81,'mod_scorm','content',0,'/mobile/slides/','5ywdXPuHFho.gz',NULL,3267,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2499,'138ba6d1f64d0e63ed0b6c794288cf63e512cbfb','90163b5850427099d5b2f582a528bd06f098869d',81,'mod_scorm','content',0,'/mobile/slides/','6Nh9M2lHIJq.js',NULL,15859,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2500,'e62a672c70b32db6461149f86a412b2f0b62ed37','540bd768f4e4514c2615f91affce6df547a07afb',81,'mod_scorm','content',0,'/mobile/slides/','61iVZJ4sPrw.js',NULL,15863,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2501,'f2d89351145ab52b1c528ebd9139d765ce79ebdb','c93a6d8fbc65968ef48dafdaf9d7d7db5b9affaa',81,'mod_scorm','content',0,'/mobile/slides/','5pjbb4k1kdF.js',NULL,15842,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2502,'99acb378470a14541344f4c6fb5efcd142bc55a5','1b29f2dec41b82149dcd67fef92d276b98a6c30b',81,'mod_scorm','content',0,'/story_content/slides/','6BVGYDsrJDe.swf',NULL,3551,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2503,'c493d31a1ae23cdd52c3adb952b7a81eb7b00618','b673d6b39ea60e99c29611c221859fdc8fba1e74',81,'mod_scorm','content',0,'/mobile/slides/','6BVGYDsrJDe.gz',NULL,3260,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2504,'5e4feb1882a733735aa0f9a6d35b90fd73d6635d','1b2bf9813a8fd286fd334d5bcbc5f793325b64cb',81,'mod_scorm','content',0,'/story_content/slides/','5ifXgUEZ00u.swf',NULL,3560,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2505,'86ea33ec695a24e88f36af475246cdeaef145f41','6190cf32faa4e05d0c9aeace71cd2ac7f84f8283',81,'mod_scorm','content',0,'/mobile/slides/','5ywdXPuHFho.js',NULL,15865,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2506,'8f7f049ef0b6fd4864fccf1b52fa0f17917d34ac','487bdbe570ba92a96bb6f88884fdb7bf709a2b01',81,'mod_scorm','content',0,'/mobile/slides/','5ifXgUEZ00u.gz',NULL,3271,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2507,'1059730eae89ae0a2617f95638a7737a3ee96fd8','d077ef62b55e6376ba009742c0008323d4b05dba',81,'mod_scorm','content',0,'/story_content/slides/','6reiRv6ylQW.swf',NULL,3557,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2508,'5f4710e7850fd67749ba0dc8b5b3aa06c55e0d28','2a1a30562ce47d2099b7e23c1c0d50bfcc63f420',81,'mod_scorm','content',0,'/story_content/slides/','5rYbaF7PJxS.swf',NULL,3567,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2509,'4f8c8991fffd59d2d8c6cd18d471da095ceeed29','8d0afa3705d173b719ae5dd2f17650fbe84d55d5',81,'mod_scorm','content',0,'/mobile/slides/','6reiRv6ylQW.gz',NULL,3266,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2510,'5d83845c155d72318fa87dcec3d88c871e0c8bc5','dc40b6d42e244816bebbdec57499cff9747a9bde',81,'mod_scorm','content',0,'/mobile/slides/','5rYbaF7PJxS.gz',NULL,3275,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2511,'08e7323b954f385db3b7cf9a86e14f946daaa8a7','6b253b42f53b531cc31fe4f6bb13b48e0cdff86b',81,'mod_scorm','content',0,'/mobile/slides/','5ifXgUEZ00u.js',NULL,15877,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2512,'2862e23ba6aa51ce66b64674780f15e36a2365cb','a12754271ddee518f4b6adb94e971209c744c023',81,'mod_scorm','content',0,'/mobile/slides/','6BVGYDsrJDe.js',NULL,15850,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2513,'e8351d895933556ffd7f7f1f1d60caf36c7e15bf','a3e7ac329f994976276494a27905c4dc07190fd3',81,'mod_scorm','content',0,'/mobile/slides/','6reiRv6ylQW.js',NULL,15850,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2514,'6128e2f93a4ff2388a00a7cfde1a9e512a32029b','87e9b939a586f0aafcca51d4434d1b2f7058d24a',81,'mod_scorm','content',0,'/story_content/slides/','6MquF4NBWTm.swf',NULL,3579,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2515,'667a49c6d238c6d0f4bd251c7a279d1e1a7e4505','2c3da9464920a79bb3d59189fc2ae0508b1c84e0',81,'mod_scorm','content',0,'/story_content/slides/','5unOuec0FtC.swf',NULL,3542,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2516,'0be12da06e8e69c12c3aabe62dff3db0eaad3333','678923210bcb6ec0790bbbba9bdcfa0ebd11c7ac',81,'mod_scorm','content',0,'/mobile/slides/','6MquF4NBWTm.gz',NULL,3289,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2517,'ca930964a65467e57838b47ada0e9dec710c996e','7ace3325448791545b0241adb8d8609aed0b65d9',81,'mod_scorm','content',0,'/mobile/slides/','5unOuec0FtC.gz',NULL,3254,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2518,'4046d5a2e91501917bc20aa0454ded1096426b31','ce2f6dd97b7fcd6abc7de6af9f98e3c16796ef75',81,'mod_scorm','content',0,'/mobile/slides/','5rYbaF7PJxS.js',NULL,15876,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2519,'3796b72aa58ba460a95cee4afab675dbc1d1f748','1e48561fdccb8a6696fc40d2be0a189b6efed876',81,'mod_scorm','content',0,'/story_content/slides/','6NkACzgG2dI.swf',NULL,3553,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2520,'fa4a0152834a52cb1f66b204feeceb49be20d046','159c0207e265c60313e01dde788ee3e1b8eb5ac5',81,'mod_scorm','content',0,'/mobile/slides/','6NkACzgG2dI.gz',NULL,3265,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2521,'7b15bda34af29ecaf16ef1e3a8b15379f35e7cd9','d43d7c248aa2c6c046875864bd769cbed71a825e',81,'mod_scorm','content',0,'/story_content/slides/','64KOYjVh8W5.swf',NULL,3560,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2522,'f37ec2b04a2194c31ddfdbbc717a59730e0f6ae1','39999bce78200c056bdc18c3b5a4a48696e95778',81,'mod_scorm','content',0,'/mobile/slides/','64KOYjVh8W5.gz',NULL,3269,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2523,'539e35c0ce25ddbd5247cf7d29eb7c585774d819','43e7cb796a469b808dba7d7ce9d047b541d1df51',81,'mod_scorm','content',0,'/mobile/slides/','6MquF4NBWTm.js',NULL,15902,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2524,'e11f861a25d4b8bc686cca13b2980bc5b64e0a47','a64c66958a32f7fdc0b98ccbd525d1e949026e80',81,'mod_scorm','content',0,'/mobile/slides/','5unOuec0FtC.js',NULL,15843,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2525,'44920cbcebde501a4b3789862bcd86963d62c9af','5fbc04844946568a2bcd9c20aebe539661d15b3c',81,'mod_scorm','content',0,'/story_content/slides/','6Y9vAm5lCC5.swf',NULL,3557,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2526,'bf9823f1289b54456c35a98c76b15a9271d1bafc','69d4d96844c2a7f391358131e092e10619a121bb',81,'mod_scorm','content',0,'/mobile/slides/','6Y9vAm5lCC5.gz',NULL,3268,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2527,'bf33e8b5f733eda70bc421a89ac7e16a3820ea99','912a427fe1605764c0f93753a9f164da476013fd',81,'mod_scorm','content',0,'/story_content/slides/','6hb3r7hGQWl.swf',NULL,3552,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2528,'b67015a5b683306f4965830dec2c20448a646967','23dd50c7a10696f68e1a9c5fd309401d082fc604',81,'mod_scorm','content',0,'/mobile/slides/','6hb3r7hGQWl.gz',NULL,3262,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2529,'05d220aac61e361ea008adc6919d5c497dac8e9c','65c02c2d32ee12d39dc50bc4675462251a384b2b',81,'mod_scorm','content',0,'/mobile/slides/','6NkACzgG2dI.js',NULL,15857,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2530,'cbb876e31dfb2fd267957d5f4f3c04a292ddab14','9b1f48fd22e5f425de48255fa8924d3cffa4ef12',81,'mod_scorm','content',0,'/mobile/slides/','64KOYjVh8W5.js',NULL,15863,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2531,'5f9864a5d982aace9e55d2ff4fb4ef9a1b31f93e','186936995598c224d613ee5cfb338b7af9154324',81,'mod_scorm','content',0,'/story_content/slides/','6LIBejYbBzZ.swf',NULL,3568,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2532,'de6f782181aef839dea8a4533b3292552c0a2a51','0429a0d88ccc3e26d9886b87a526e6480b28f531',81,'mod_scorm','content',0,'/mobile/slides/','6LIBejYbBzZ.gz',NULL,3276,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2533,'c81239127055105db92055d752691b90b152ed93','e45d8ee74f22d40adf08b122a5750af540393cbc',81,'mod_scorm','content',0,'/story_content/slides/','6qaWwhou4zK.swf',NULL,3559,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2534,'023afcf1f479bc43fe93ccd72d1b0679afafa2e6','b9382e2c0c1c2c5fba952ac65cf39f5bcfdf5fde',81,'mod_scorm','content',0,'/mobile/slides/','6qaWwhou4zK.gz',NULL,3267,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2535,'2851fd8444b335ec33c37f1364d013cb1be06fd1','50e0eb10994cd6e2a642e9a470754bf764b18145',81,'mod_scorm','content',0,'/mobile/slides/','6Y9vAm5lCC5.js',NULL,15860,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2536,'446a3e501885afe7197fc06efdbf6d261fdb1e9b','bec2879aef3ff4a2c5d1819c7c2f376e37e5b150',81,'mod_scorm','content',0,'/mobile/slides/','6hb3r7hGQWl.js',NULL,15866,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2537,'8e12d34a112b4e14edbf520d5a33be802260ea07','aaf3de15bdc47a29d2b94ec914320d12eef10ec5',81,'mod_scorm','content',0,'/story_content/slides/','5sezlVkXH3t.swf',NULL,3562,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2538,'cee0f339e868732d4906f2734204470b59852f1f','2b3e13ca6f37884142deb0185f42953565072c17',81,'mod_scorm','content',0,'/mobile/slides/','5sezlVkXH3t.gz',NULL,3273,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2539,'503759e610bbf37ae35e65bf10db1fb224616d1b','1870c224c39632fadde3d02106e9e9408403222d',81,'mod_scorm','content',0,'/story_content/slides/','6TXYub0BdMU.swf',NULL,3552,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2540,'41e8d559aca43e083b596fd5a250eb953362fd68','e021daf1c1a07228a89f83cfac49037f0be79a88',81,'mod_scorm','content',0,'/mobile/slides/','6TXYub0BdMU.gz',NULL,3261,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2541,'6e4db60297b8217a9642d6f96d10c3f6ecf210a6','e2f2100ff0125d4ab3d4f31b3ed1d643130df3dc',81,'mod_scorm','content',0,'/mobile/slides/','6qaWwhou4zK.js',NULL,15856,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2542,'c4358ca97f328e8c5c3769b684264a3404f5cbe5','af5e22c11ff1d53e1de1d6b64aa24b94fb2cb0b3',81,'mod_scorm','content',0,'/mobile/slides/','6LIBejYbBzZ.js',NULL,15882,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2543,'b8f94275f94abce3037eb3613abe5401464c436e','5a39d84765d8016af957ef2e9c9a9617a7c1241f',81,'mod_scorm','content',0,'/mobile/slides/','5sezlVkXH3t.js',NULL,15865,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2544,'f20d67aa676ce24992b4fb85f106cfadce39e9d7','bef05f2d1a6e63859b5e7ff7d4288608fd5fdabd',81,'mod_scorm','content',0,'/story_content/slides/','6V5TwYLMlA9.swf',NULL,3561,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2545,'008660b7aa3fb50dbbce558924552b1cf67abf86','84cb1b48e85078a2ce7b0372d207407d17b28e17',81,'mod_scorm','content',0,'/mobile/slides/','6V5TwYLMlA9.gz',NULL,3271,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2546,'4a1d74a80586f4264e1225b63e8b8b7030c1bffa','eda8270bd181f28b0d2a965b4f5245aaaceedefe',81,'mod_scorm','content',0,'/story_content/slides/','6ZTSqSBGOfT.swf',NULL,3571,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2547,'f2660ae2664084724f4158dabe618c5420484df8','c727a1e3ce07d51da58d5be9405cb155cd239fae',81,'mod_scorm','content',0,'/mobile/slides/','6ZTSqSBGOfT.gz',NULL,3280,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2548,'773c3c15c2a37852e3df0aa5f3c2dea95e4d917b','196f8364c8fc23cb1e0801829fc54e635c6b8fc1',81,'mod_scorm','content',0,'/story_content/slides/','5V12yrGqEvy.swf',NULL,3553,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2549,'27e1d1b182f892a3c5625fdcdff8b07765603e36','2c2fad8d50a892816e21cca508468253c4814520',81,'mod_scorm','content',0,'/mobile/slides/','5V12yrGqEvy.gz',NULL,3264,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2550,'dbce1fa17d85b031589342eb034e20d3dae7697c','7e8c63487ba859fb7258efc508f6f2ffb02643e0',81,'mod_scorm','content',0,'/mobile/slides/','6TXYub0BdMU.js',NULL,15844,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2551,'d0726f74b267c79762888df9ff8af3668a6bd481','f5e660a6be52e73f5b97091e187e05cfe7819118',81,'mod_scorm','content',0,'/mobile/slides/','6V5TwYLMlA9.js',NULL,15870,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2552,'27c2d2e123f33a0a8dcc15e3e29d1fcb2a119ce7','f2486d82cc60f2a574fea45cefab65b8663c6d8e',81,'mod_scorm','content',0,'/story_content/slides/','6DJLnVaZt31.swf',NULL,3552,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2553,'4a5ce1b9c49390629ea112946f77adfef85b6c0a','12e6974f26138f8cdc3b07d36f7dc0cf1193ff96',81,'mod_scorm','content',0,'/mobile/slides/','6ZTSqSBGOfT.js',NULL,15874,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2554,'c8f985f5178222efdf67c135182b8f1658bc05dc','5055d68e4268e7870ce4a74b6520dc370a67fe06',81,'mod_scorm','content',0,'/mobile/slides/','6DJLnVaZt31.gz',NULL,3262,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2555,'abb9bbffc4e5497ca309905f74a9e58a5d8743e3','59376df29c1cebf45a5739e5f2b0f795f0fe5ed0',81,'mod_scorm','content',0,'/story_content/slides/','61y1ApBpJ8V.swf',NULL,3555,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2556,'e2879e818f3956c2a301c23b52399f8e7272ed06','d99301d89495e09f2c10d2c3ab53e5fd12ade337',81,'mod_scorm','content',0,'/mobile/slides/','5V12yrGqEvy.js',NULL,15853,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2557,'e74ec97c59e9083af136ebfb4c4ec9027adefdb6','90951e2e8b7aeefaa83afcf86488cdd204aaf8b3',81,'mod_scorm','content',0,'/mobile/slides/','61y1ApBpJ8V.gz',NULL,3266,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2558,'affc0b783911a2deeb728f2c0ea3632b6dbd2dcd','4cb04d3cd5c3f741eb18347ec5353a4f73124337',81,'mod_scorm','content',0,'/story_content/slides/','5dpLXn2ITNw.swf',NULL,3557,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2559,'b6387b8f9a5f72b2311d7fee23425ba754ee5720','6aaf3c844338ed6c418332b73209799adedd3c77',81,'mod_scorm','content',0,'/story_content/slides/','6pp1g39RfL8.swf',NULL,3554,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2560,'edaa50593e61d51b92695a3c038b9b07b7d19a72','a9517da88180d156636ba2356743d1924a7c1946',81,'mod_scorm','content',0,'/mobile/slides/','5dpLXn2ITNw.gz',NULL,3265,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2561,'2574384397d9ca45c14b29ba8b09dbee84346e59','94732d2bdab1a78e5d090a86f4eb0817044bea22',81,'mod_scorm','content',0,'/mobile/slides/','6pp1g39RfL8.gz',NULL,3264,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2562,'96ac7b63cd129cb5fbb2e11062ec89be6f644463','5aeb65437435476bd5abd4f114e48daa62b732fc',81,'mod_scorm','content',0,'/mobile/slides/','61y1ApBpJ8V.js',NULL,15864,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2563,'c54ff6e22d46d437e79609653c56b47981497da5','3aa8f08c3b009bcc82510567c9a10a3e4b9e854f',81,'mod_scorm','content',0,'/mobile/slides/','6pp1g39RfL8.js',NULL,15862,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2564,'bdc6a62fc64d1ef2fe7fff260bd17dcb41f7a465','c3a0b72060a5d7f55aabf0b8ab58e612235bc658',81,'mod_scorm','content',0,'/mobile/slides/','6DJLnVaZt31.js',NULL,15861,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2565,'bfcabe4b76debb1d0144149a229bbd7af098cbba','f234ec9c8ac3bd713043c475518652640f590468',81,'mod_scorm','content',0,'/story_content/slides/','5nnxutBFEKz.swf',NULL,3561,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2566,'c7bd15c5445d93b1d27673f8334562eb31332041','674476567cc45c47fee58fc455d9797c892760ce',81,'mod_scorm','content',0,'/mobile/slides/','5nnxutBFEKz.gz',NULL,3271,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2567,'037760d89a1caf345b38a8a9d359e007b5d10eaf','b563121f4741bc1ee3bd71d105cf126cbd0de66a',81,'mod_scorm','content',0,'/story_content/slides/','6h3VRNOWZcv.swf',NULL,3557,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2568,'10bc5e5fd86e55a189ffe61bd75338602827614c','0d012f83918837cf3e4cbb518365a7ced4d95090',81,'mod_scorm','content',0,'/mobile/slides/','6h3VRNOWZcv.gz',NULL,3267,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2569,'e7c9854e715eccfbdaad06b5226216a7965cedf4','d1dac2c2b7e7a752f38640f78931aa0874caf1a6',81,'mod_scorm','content',0,'/story_content/slides/','5VBJP4fCcfC.swf',NULL,3552,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2570,'f460f7cc3fc419361f3781f30862331a09c9b142','733c83e61e16529ebf52ff721597146bfa0040ed',81,'mod_scorm','content',0,'/mobile/slides/','5VBJP4fCcfC.gz',NULL,3262,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2571,'ffa52081687744355ef17f1bceee2f255b6c00ff','0ddd000191881cc412c5bd2106a3d14759c53b74',81,'mod_scorm','content',0,'/mobile/slides/','5dpLXn2ITNw.js',NULL,15861,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2572,'64d015446a93f6d360e127d554f68843969bc3a0','e0af95858010208c43d282d6640ece222dec9bbf',81,'mod_scorm','content',0,'/mobile/slides/','5nnxutBFEKz.js',NULL,15863,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2573,'a258f0cd6113269f5153f0c47f7b30e1cc3b4c4f','4b13c012a1ca072138bd3a0977682718b84757a6',81,'mod_scorm','content',0,'/story_content/slides/','69uC7YsnAfJ.swf',NULL,3550,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2574,'c00d6826a93b02e34fcffbc05d097e4c5916243a','610f3758e274d8c8dd228b938eab5e0d7257ccbd',81,'mod_scorm','content',0,'/mobile/slides/','6h3VRNOWZcv.js',NULL,15860,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2575,'8b32efedb2149e74f0e3da8cf4113bb41a654f34','981d13c1fefcedf0bba6a4c710873cad29ada389',81,'mod_scorm','content',0,'/mobile/slides/','69uC7YsnAfJ.gz',NULL,3262,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2576,'921aca1598620e14f358395f5774a81cfc684f73','6f5de525e547852847a5c664d9d2c57e9c02796b',81,'mod_scorm','content',0,'/mobile/slides/','5VBJP4fCcfC.js',NULL,15850,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2577,'0a2308d525c45c240322d1ffeb096c4f5fe92db7','10cb7c7b8fbe8015be34ebf5b7df10403d7fc6a1',81,'mod_scorm','content',0,'/story_content/slides/','60BtA1hxro4.swf',NULL,3558,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2578,'48141b55d17cf269c7863b4e7dd5e030e7f073d5','6c2795c0a9518414b70bf6bc2a4f8729928edf13',81,'mod_scorm','content',0,'/story_content/slides/','5bEWSVG1iDJ.swf',NULL,3553,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2579,'2ebac6024844eaee4eb94a45223f8636caece26a','65822a88207faf24a461e95122d8882e26cae508',81,'mod_scorm','content',0,'/story_content/slides/','6d0ohXpg4nn.swf',NULL,3560,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2580,'919b4749f00a0a267b73c13ed02ef391828e1cfa','4da30f38804f322772baeae433ba45422f17b7e8',81,'mod_scorm','content',0,'/mobile/slides/','60BtA1hxro4.gz',NULL,3269,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2581,'2986bf722e933699b4fc889b9b1f8b3062c4a279','f0cbc7e7d35a9e10b3b4784424dc63adae9ba471',81,'mod_scorm','content',0,'/mobile/slides/','5bEWSVG1iDJ.gz',NULL,3263,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2582,'919af0510a4b06b56ee5fcbc4ac625bac2754fb3','23bbfc8446d4faaebd35ed6c47ed1df923c91ec9',81,'mod_scorm','content',0,'/mobile/slides/','6d0ohXpg4nn.gz',NULL,3271,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2583,'35b569cffb00c13f2b3cb8dc34a0caef4019ce70','b737e59bc462fc3fe7b32f488675034de2e3e8b9',81,'mod_scorm','content',0,'/mobile/slides/','69uC7YsnAfJ.js',NULL,15851,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2584,'72ed0ac9d3adcc7b22bb1ea1c8a1677381fa8a86','c71a8604dab6778a6810eeb1090d8bf3d56c085a',81,'mod_scorm','content',0,'/story_content/slides/','6hOjV6zL1sJ.swf',NULL,3583,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2585,'d4639c66622a7b5c85d4f6cabebeb57c4aa6f233','959a88ef8beca4d31d73d09de214664d81e800a9',81,'mod_scorm','content',0,'/mobile/slides/','6hOjV6zL1sJ.gz',NULL,3293,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2586,'6151af67b058f0de9af2eec7b7882e063b025919','fc68fbac9be17292565e525678aff832f9261d37',81,'mod_scorm','content',0,'/mobile/slides/','60BtA1hxro4.js',NULL,15860,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2587,'ee957ffddad6c7acf793d5a04e037e88e05dbc9b','238decaea4efcaf9fa5b7efa48e8a6899ea68884',81,'mod_scorm','content',0,'/mobile/slides/','6d0ohXpg4nn.js',NULL,15865,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2588,'b6dcb679b2896fb45d6a2b58d4e10c68b987da09','f23dd916789efcc74653365a6b6c99faf0132889',81,'mod_scorm','content',0,'/mobile/slides/','5bEWSVG1iDJ.js',NULL,15856,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2589,'7eea1377813bd3a0ac1f5e4a10809fdc50635f59','8edb23b947a389425507b9e2bb57b11e179c0d18',81,'mod_scorm','content',0,'/story_content/slides/','6F6lMkEnRyo.swf',NULL,3547,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2590,'4c9e27c572ddf91f903075e6f6758d831d53ba32','ddb59befb3ab524ba406fffbe727df2851ca8949',81,'mod_scorm','content',0,'/story_content/slides/','5yhMqlX5ug3.swf',NULL,3561,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2591,'804f8f11ea1d6b88531a6f5f8c758e1599ca9a09','860cd2a4b7d7d758f9fbb69187a0c25059d8c7f5',81,'mod_scorm','content',0,'/mobile/slides/','6F6lMkEnRyo.gz',NULL,3257,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2592,'6bdd8aa719023d21657047d71c1da02e8608ac74','76395378a4bba6a9d0281f2c570e72010406e727',81,'mod_scorm','content',0,'/mobile/slides/','5yhMqlX5ug3.gz',NULL,3273,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2593,'6f643ac654396e2a125591eaf17c1f0abb98675e','d6c0d512a34ef8d5f5c2c2e0d7c0722354f7fc82',81,'mod_scorm','content',0,'/story_content/slides/','5iQRNaXMGR2.swf',NULL,3556,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2594,'b7e98d2a411420b0c1bcf3dab7a47393ec4fee14','a23e3cfd008bd4abb153e722094bc1bda7722569',81,'mod_scorm','content',0,'/mobile/slides/','5iQRNaXMGR2.gz',NULL,3265,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2595,'b2579cf2393f32ae05dbb628eb082a2e03495b26','33a5ec76aee9b9ca980d8fc2f3d2a127beccd759',81,'mod_scorm','content',0,'/mobile/slides/','6hOjV6zL1sJ.js',NULL,15896,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2596,'349ee719cda18e4798b02a09cf6237e836f4e3b4','97b42287d01313b3680425f12e51878b91d27d29',81,'mod_scorm','content',0,'/mobile/slides/','5yhMqlX5ug3.js',NULL,15868,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2597,'2d8bf96df69928c660f51743e5e54fafcb3c33e5','9341fc0ce4600c0bc6209f638fd103fb738454fc',81,'mod_scorm','content',0,'/mobile/slides/','6F6lMkEnRyo.js',NULL,15842,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2598,'99e387c8731d036280954a312175424626631ed5','d74ab71370f073b673ca0b0c957d88030d83d85d',81,'mod_scorm','content',0,'/story_content/slides/','5dNIu8Rdz2P.swf',NULL,3557,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2599,'1220bf204acf25bcbdfab96d0d2e2c85089a056c','68ff1a300e889d3cc12cc15b1cb9f084ffd73352',81,'mod_scorm','content',0,'/mobile/slides/','5dNIu8Rdz2P.gz',NULL,3266,'application/g-zip',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2600,'4c0781cf3a780ccd9e34f5acdd83bfa2b07008be','bb0881c4430305416fa3ac1779f4843398033f79',81,'mod_scorm','content',0,'/mobile/slides/','5iQRNaXMGR2.js',NULL,15858,'application/x-javascript',0,NULL,NULL,NULL,1462716820,1462716820,0,NULL),(2601,'22776eabe44f19b782101a31e0d506002973dde8','ea1d9a6ebf37cd7b36e98ed6e3adc66633004888',81,'mod_scorm','content',0,'/story_content/slides/','6qwUr3lECHZ.swf',NULL,3558,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2602,'e2ada35a039b719b0f1ff46c888d7e87879cd77a','a0c3389ff7ec3d44534b27a28627fc3c280ef28b',81,'mod_scorm','content',0,'/story_content/slides/','6IpLAKnRyrB.swf',NULL,3551,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2603,'6a9a144b829b680c090ed1ca7ad937921debb2bd','0ff8379d0aca62f47972fe2c80d0320c20918575',81,'mod_scorm','content',0,'/mobile/slides/','6qwUr3lECHZ.gz',NULL,3267,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2604,'826aa4b7f5f8d9bd7a6e5afdc542b6ddf5c58bc5','5b4cfbb11e8997c151270c95aacdf417610aa3e6',81,'mod_scorm','content',0,'/story_content/slides/','6clBK60ceTQ.swf',NULL,3557,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2605,'8c15a49634f25fa01ea13d0aa0c2c6058b390352','8f030f427f0d95e2992fed463044e3547e68a6aa',81,'mod_scorm','content',0,'/mobile/slides/','6IpLAKnRyrB.gz',NULL,3260,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2606,'92d7ed323fca2447aff27363cac284f2c9b9d3cd','828294de23f4970301e688f12cac6ea8d71fc974',81,'mod_scorm','content',0,'/mobile/slides/','6clBK60ceTQ.gz',NULL,3266,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2607,'547b6ff904873d003bb20c618c3326c6fd1877ea','aa99b7bf4a48d4bc350c059862d89a34e5c296ee',81,'mod_scorm','content',0,'/mobile/slides/','5dNIu8Rdz2P.js',NULL,15866,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2608,'279c365dd797144862f28a454d8cee4c176de66c','a0daeb96e2cce23c370115bec786bf0d67f88ae7',81,'mod_scorm','content',0,'/mobile/slides/','6qwUr3lECHZ.js',NULL,15866,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2609,'1f56d0229c0be5b31366ebc3df1030aea403a36b','734b91b188a15c1073ddf409f3686db5775d6f22',81,'mod_scorm','content',0,'/story_content/slides/','64DRgAgWJkr.swf',NULL,3567,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2610,'2aad2803e876c1292869fb8ed5b39e5f92e7a975','f5bb6a4643c0a144a2066e6e05f05fdbe010d9e8',81,'mod_scorm','content',0,'/story_content/slides/','5xoaVxsAIK3.swf',NULL,3556,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2611,'d497ac4869a3fbb255e88a7788b6379c746abefd','60265afae336cf1940e730dd1b579bb7c7b0426a',81,'mod_scorm','content',0,'/mobile/slides/','64DRgAgWJkr.gz',NULL,3276,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2612,'42434fbb570a2afd405ad16e55545ce1c140f0cd','95293ddc25ac3789aada513463c69d053ea425bf',81,'mod_scorm','content',0,'/mobile/slides/','5xoaVxsAIK3.gz',NULL,3267,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2613,'46464661c43d1c3c5125640db717de2143f0b2cf','ea9b53ff5e5eb4d399328741302e0bd4ea07f169',81,'mod_scorm','content',0,'/mobile/slides/','6clBK60ceTQ.js',NULL,15856,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2614,'7aaef1ce9f89d2a7b3048252966331962225d0a4','9d2294cab7e4cc8ecaaa76d21b89be7277be6230',81,'mod_scorm','content',0,'/mobile/slides/','6IpLAKnRyrB.js',NULL,15847,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2615,'5fa462812f824c61ccda06a376395747859f719c','7e870d9067d6cdc1d023fc44b1e351766ba4400e',81,'mod_scorm','content',0,'/story_content/slides/','6Q3RA2h8aWI.swf',NULL,3550,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2616,'831656d8d141ad00e7fe58f5d26c2174c2fbc6c1','4415b28382478ed1aa5768bda23c1e6c6795815b',81,'mod_scorm','content',0,'/mobile/slides/','6Q3RA2h8aWI.gz',NULL,3258,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2617,'e8917e3ec88ccf7bbe1e143aefe138e15074bf32','dd4cbb16abab6b92e385615b9d3ea1ecdb664f80',81,'mod_scorm','content',0,'/story_content/slides/','6fqUgJkjRTC.swf',NULL,3552,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2618,'270697ebf6a58011360d5bc359594d7b9e1dd375','72dc1cb013fa49d49326fd1b4750785964eaf394',81,'mod_scorm','content',0,'/mobile/slides/','6fqUgJkjRTC.gz',NULL,3261,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2619,'585b16a09e03db5907e0fbca45c919b1d655e61c','38b7857630f6397c9933ab304db59d7f65c2a4d3',81,'mod_scorm','content',0,'/mobile/slides/','64DRgAgWJkr.js',NULL,15891,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2620,'35695f7681053772d8a9674f79f91ef877fa040b','36a7ad253dd14cdc0aa9af655c48b22ff2783572',81,'mod_scorm','content',0,'/mobile/slides/','5xoaVxsAIK3.js',NULL,15866,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2621,'4407d12185ae918a011a543845b0ae47db9e95a7','9397043ebfdfcba744c1827d0c979570f0f2ac2f',81,'mod_scorm','content',0,'/story_content/slides/','61JrJCOWu6C.swf',NULL,3560,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2622,'762bc7ef58e1e3e4efa2ee8cf7483f489352851f','b91014afe2e353b5dc94f8dbb52bd677cd18f455',81,'mod_scorm','content',0,'/mobile/slides/','61JrJCOWu6C.gz',NULL,3271,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2623,'eead175732877186fd9bfca02e242cb077b21abd','74d5290175036dc9c871660c32a5e000436f1f51',81,'mod_scorm','content',0,'/mobile/slides/','6fqUgJkjRTC.js',NULL,15849,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2624,'c7308a3c25bbd87effbff25d31cde63b1c8e6bb9','438cf6e086fb51f54a24b64b872a2b29410f45c0',81,'mod_scorm','content',0,'/story_content/slides/','6GPxgnWkKV2.swf',NULL,3565,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2625,'fabb759ae0e1431d20331003ca074124e967a581','215903813be76f184583a002cae1b6ede935a2a7',81,'mod_scorm','content',0,'/mobile/slides/','6GPxgnWkKV2.gz',NULL,3273,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2626,'acf3949fffe8eb43b1fa6f7167b22b0f7d9eb49c','61e0e7a8a84e57695cb27a9ddab0ad3565349298',81,'mod_scorm','content',0,'/story_content/slides/','6WS9d99EVIm.swf',NULL,3560,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2627,'d33b969912bb11c988c5eb3b07c8ae85d0fe3144','d397111d6abb99be9af7fef432358bc2e319a06c',81,'mod_scorm','content',0,'/mobile/slides/','6WS9d99EVIm.gz',NULL,3268,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2628,'4fab2c8160980a39a433a4843a97c58260c84ca3','9a0030cdd9fef86626d00bd0302ff0c20cb1d297',81,'mod_scorm','content',0,'/mobile/slides/','6Q3RA2h8aWI.js',NULL,15848,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2629,'dff2fabfa416ecf8b7511c0af829dac2a21a75b6','b3bc347e539482d08c2e22892b4f99460a3c4b42',81,'mod_scorm','content',0,'/story_content/slides/','6knP3T93mmk.swf',NULL,3551,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2630,'10712b8ec1d6f9877d1a61bf697a63fa10db93eb','3a3d791688587bcd57be1577d805762c1ec00f57',81,'mod_scorm','content',0,'/mobile/slides/','61JrJCOWu6C.js',NULL,15872,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2631,'4e5eabfe7610be97493a3580df4a5e7935065d62','5a23c657319439f05269120d6c3443781c722847',81,'mod_scorm','content',0,'/mobile/slides/','6knP3T93mmk.gz',NULL,3259,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2632,'0d382d19cc546ea4afd411e15bd720fbbfd3fb33','b3ab727536012c67b1a23042154eeb64120bb7e4',81,'mod_scorm','content',0,'/story_content/slides/','6SxfbKRcnJK.swf',NULL,3558,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2633,'e9f251a5159bae21493d01d53bebb671c711fdda','178f639698658c0753c2dde85c4b1ff1407337a7',81,'mod_scorm','content',0,'/mobile/slides/','6SxfbKRcnJK.gz',NULL,3267,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2634,'7ad6f50bf38c6e0a35ec8790b19c2c7a08e7f961','04478e8905cbb3f17a0d398566c926a024daad0a',81,'mod_scorm','content',0,'/mobile/slides/','6GPxgnWkKV2.js',NULL,15883,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2635,'adcc17ea8a95b42bd8beea5da2982660f973be00','3e9ce72fe2b0723d243694a7cfb7f2e04413ae75',81,'mod_scorm','content',0,'/story_content/slides/','6R1RPTEEXv6.swf',NULL,3554,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2636,'e26fe00947d47bcf06bb3a459841f218835cb409','8f1622ba8c68e22994298db758e0e510873d1008',81,'mod_scorm','content',0,'/mobile/slides/','6WS9d99EVIm.js',NULL,15859,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2637,'9f36af9731b62c6c3a94d252349e09b917b1dac2','2acde8906ea1dcb8f59ef5312ad1365c22b61268',81,'mod_scorm','content',0,'/mobile/slides/','6R1RPTEEXv6.gz',NULL,3265,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2638,'313804286f1bef3dc9a06e024729611ead1aaa81','102ac8692254ad5320e25f54d4c89bff217c3f3f',81,'mod_scorm','content',0,'/mobile/slides/','6knP3T93mmk.js',NULL,15844,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2639,'b3d44eb4a8343d791fd932e596b3a0f95c84e4b5','63e0a89342e793a3f06c612c8f13206a7e6bf236',81,'mod_scorm','content',0,'/story_content/slides/','5agHwfmVnrE.swf',NULL,3544,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2640,'81c2ee5c22324283c86cd4054261c1400bde0642','100bf18c4b7cdf2bfcd066bfb78e0b831723bb10',81,'mod_scorm','content',0,'/mobile/slides/','5agHwfmVnrE.gz',NULL,3254,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2641,'08d0d22e64967fdac9328f38b8b170441984d546','cb7af948aaf38e7f275592eddf6c1c1a8c244a20',81,'mod_scorm','content',0,'/story_content/slides/','5wb8N7CqWxw.swf',NULL,3556,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2642,'e833d6321a0f87defc351ee9740924d1c6888f4d','d594aba617d869952323823e334cb6ba866d3898',81,'mod_scorm','content',0,'/mobile/slides/','6SxfbKRcnJK.js',NULL,15865,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2643,'ecd12e351d5b0e7bbc7ec715c59e5818dd4395d8','34a32b0812483c01d17675291468dcd4bf7111f8',81,'mod_scorm','content',0,'/mobile/slides/','5wb8N7CqWxw.gz',NULL,3265,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2644,'a6ac6ae7fea98ba30d1af56bcd126855e36b3ade','964bd9dd66fe638b369539dd95d7de0e71b2914e',81,'mod_scorm','content',0,'/mobile/slides/','6R1RPTEEXv6.js',NULL,15857,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2645,'c95df9cc2a2d32df91c9b6cd5be5d82380647e30','eabd704149f6d9f494c5609fecc23738219cfeef',81,'mod_scorm','content',0,'/story_content/slides/','5rO9KylCn5S.swf',NULL,3559,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2646,'e1a5625ef31176f63d1e3a6f9b71c6569d4c7928','2ea80920414ed1befb329d17ff38278c5b1e66d8',81,'mod_scorm','content',0,'/mobile/slides/','5rO9KylCn5S.gz',NULL,3268,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2647,'c2dd66da211f5864ab7a85ecf2663da1a0784bbc','f80655576d4e27c13747c8d5824d2e777229f076',81,'mod_scorm','content',0,'/mobile/slides/','5wb8N7CqWxw.js',NULL,15862,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2648,'fa53362ff82c8b44d9ae89a2503ddcd5de190a73','d6e078a2680c4bacac54eff7f03de87811384e27',81,'mod_scorm','content',0,'/story_content/slides/','5mSHWmQzmdI.swf',NULL,3552,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2649,'9bdca6f4fe1206ba3b05afaba6c476162a2d78b0','7ae448a7e6918fa45ba29c7a36a6fa51b0457b80',81,'mod_scorm','content',0,'/mobile/slides/','5agHwfmVnrE.js',NULL,15856,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2650,'e83f6aef3a1c36eb68b91cfee39c6374bb72aa51','f0c38c202d693288df6104a5fa60af7d282fac53',81,'mod_scorm','content',0,'/mobile/slides/','5mSHWmQzmdI.gz',NULL,3262,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2651,'3a2f2e831f8c54674a1b44c536d7b674fbf4e2fc','0fa6b09c4dd3bb4965a53f577c0b897e4d97ac71',81,'mod_scorm','content',0,'/story_content/slides/','5ZT0VPxPSIE.swf',NULL,3552,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2652,'85348cf264b86f0140c0c003e5d3796285045d5d','bc0a97a658229f503f0b499fb3e89b333ad73522',81,'mod_scorm','content',0,'/story_content/slides/','5al6TysgePI.swf',NULL,3550,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2653,'56433222b9fdbafcf3ea4dfaa7ed74ce554f1570','f8e564c7f57fd6883d73d046016cab9061d71dcf',81,'mod_scorm','content',0,'/mobile/slides/','5ZT0VPxPSIE.gz',NULL,3262,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2654,'8b524343f88c879cf63a2add8c43b4fca0f06ba8','09990248b65c308dbeba684e4aa73639ee87f808',81,'mod_scorm','content',0,'/mobile/slides/','5al6TysgePI.gz',NULL,3260,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2655,'99cb9e0a74b4a4d20922da56520550c8146fca13','40de11c0dd6727f7907e758cdb62f2b52513165a',81,'mod_scorm','content',0,'/mobile/slides/','5rO9KylCn5S.js',NULL,15863,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2656,'3b6f12a24e88638855308b16c3bbc3f50b700091','5e60ca40a9940d1c6afef30fd24cc251be8fecbe',81,'mod_scorm','content',0,'/story_content/slides/','6GVI3BgjLSP.swf',NULL,3558,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2657,'86671652bdf1d253861f4a18342797fe468ba628','d21e84075dc733bf402373ecb3f4fd51a6a459e8',81,'mod_scorm','content',0,'/mobile/slides/','6GVI3BgjLSP.gz',NULL,3270,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2658,'9015f733541ed9df4f14ebbf61b7a10e332dd289','c68a39fd94f7890fa73ebbf3f642d9604cb1978f',81,'mod_scorm','content',0,'/mobile/slides/','5mSHWmQzmdI.js',NULL,15858,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2659,'999b87cffb8dabe3b118fcf1088612b2c386a6b2','549794ef5a084cbc5cb89f4a85adaafa8a9ac124',81,'mod_scorm','content',0,'/mobile/slides/','5al6TysgePI.js',NULL,15858,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2660,'4aaf60deb13564be62b0566a25603b2e23d76d7a','b0bbbd6cc57286aa20b887f913fc042d9a961c4d',81,'mod_scorm','content',0,'/mobile/slides/','5ZT0VPxPSIE.js',NULL,15857,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2661,'e822ea79eaa8c91302b2c6729636b5c7037fb85b','fb19e896c93f8bc7d99431fd807cfa93a63f392e',81,'mod_scorm','content',0,'/story_content/slides/','5oYmgae5RZ0.swf',NULL,3558,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2662,'079d2c9e878a9f42abf293cecc5981ee78c60b3e','b44f9778b0740985ee3dc606c3ab6d4a177f082d',81,'mod_scorm','content',0,'/story_content/slides/','6NKy8ywddTc.swf',NULL,3555,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2663,'8ac6a5320f6c703d7c9e2f7425453794412fb160','ec3cf085a7c26ecf918a1aac37a10a7e2c58267f',81,'mod_scorm','content',0,'/mobile/slides/','6NKy8ywddTc.gz',NULL,3266,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2664,'b774f57e93b6d15ad798617dc387a8efef576bdc','9a4ca779c9335c31775800deafae2d56b065c436',81,'mod_scorm','content',0,'/story_content/slides/','5XTzQ9284sk.swf',NULL,3552,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2665,'b95e8411ae5e99db17da35462c69d7e769e91d26','e43c42b2f152394a10b410f94c8f7cb8115e6809',81,'mod_scorm','content',0,'/mobile/slides/','5XTzQ9284sk.gz',NULL,3262,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2666,'dcba88dc3a0ae9c3b928d38aec6893d4dba68a97','d7d05c4a5377cb70c25160988f8bc9235784a4bb',81,'mod_scorm','content',0,'/mobile/slides/','5oYmgae5RZ0.gz',NULL,3267,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2667,'be74984532b93c14cc53e0a48e56a4423937b1a2','9cbc62ceb16ca59967f56f5e16ee42e44a9bcaa9',81,'mod_scorm','content',0,'/mobile/slides/','6GVI3BgjLSP.js',NULL,15865,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2668,'a867f20837ec1157497c025dace9765ba512dc99','5bc9f8a37685eca17728d3da16e94529b94ca3a5',81,'mod_scorm','content',0,'/story_content/slides/','6o2YA120Clf.swf',NULL,3555,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2669,'3da2c128e7e9ab825af4fc73c874a9c7a1ce1dbf','0fdd9d341b057ffc1b561788c53e6784b8c7555f',81,'mod_scorm','content',0,'/mobile/slides/','6o2YA120Clf.gz',NULL,3266,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2670,'361209be74ca123716edba499bb669bb1486520e','fd994dc38906e62641f08dc28138cad9bf1b0a1e',81,'mod_scorm','content',0,'/mobile/slides/','6NKy8ywddTc.js',NULL,15860,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2671,'5ef0117d9b52bc8d53f6d9663d8eb4538288a08e','7caa56615598a7f237fa0ffdfc851cc69e418087',81,'mod_scorm','content',0,'/mobile/slides/','5XTzQ9284sk.js',NULL,15858,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2672,'9ff819d4f1b281035973fe19b592cc268219dfb0','767e61d507125228b3aec00a8f8d102f67fe2d64',81,'mod_scorm','content',0,'/story_content/slides/','6fknBPrd8aE.swf',NULL,3547,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2673,'34fe6e4377e39a5465e588571ba8a06a9db44008','fdb2bdf1d375298d5dc67ac53a3c2868ff4308d7',81,'mod_scorm','content',0,'/mobile/slides/','5oYmgae5RZ0.js',NULL,15865,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2674,'0b6012ffc28e6d9002c700c529b9a640e863c2ce','f105539cff59fa58bac214c9c00813784558dc34',81,'mod_scorm','content',0,'/mobile/slides/','6fknBPrd8aE.gz',NULL,3256,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2675,'b85093c4a32fcdb6d72a96f4a5e0fbc54bb7dcfd','dad619edfddab51684a70fcd5735e5ec7d0efce5',81,'mod_scorm','content',0,'/story_content/slides/','6hFSINzM5pL.swf',NULL,3547,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2676,'bd7d2f4308ed42ab2155efbc9a71c9d2b0451e04','96d0d557cc3797fa41cce74c4f817a49757fdac1',81,'mod_scorm','content',0,'/mobile/slides/','6hFSINzM5pL.gz',NULL,3256,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2677,'0930d8a2d03e7e9b9ecbe140e071190d21329724','c30c13520e6b026ff2bd88f177b054d3a0ae734f',81,'mod_scorm','content',0,'/mobile/slides/','6o2YA120Clf.js',NULL,15861,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2678,'960ddf2a0db8ecf988f6a62ec04015df62af7e30','3b4c510981ef949c798953b953135bc0afd5fbb9',81,'mod_scorm','content',0,'/story_content/slides/','5X0tmoHtaoJ.swf',NULL,3550,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2679,'6835b98a74dbcb1809d13b444e8fe459807a7967','ad3399cdcc5908d99e339eb94d086a717cca849b',81,'mod_scorm','content',0,'/mobile/slides/','5X0tmoHtaoJ.gz',NULL,3262,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2680,'675acb7b2bdc114262c047af94ef9e6e6741385d','dd8071f2a6721be23a6c13b70163fe879ba4d7b6',81,'mod_scorm','content',0,'/story_content/slides/','6Qm0gQy7aNO.swf',NULL,3544,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2681,'b7eda239e8fb9eda52c566539441906ab6194f97','bcd7d1b2be0ab4994a8cfd0bf7fbcc0c3ec908de',81,'mod_scorm','content',0,'/mobile/slides/','6Qm0gQy7aNO.gz',NULL,3255,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2682,'cedae5bfcd00eefd5ce60cc4b9daea5835fe787f','5183eb56726b8e88342d8f0d56bdca1e24a7ef84',81,'mod_scorm','content',0,'/mobile/slides/','6fknBPrd8aE.js',NULL,15847,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2683,'98338e230e12b06a9b8e895b89d93d5090bc92e1','13511bd9a3957c5a48cf24fd8f7dc22bf60d412b',81,'mod_scorm','content',0,'/story_content/slides/','5YZD21yKoTr.swf',NULL,3552,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2684,'d6f0e6bc9e0d5b5295481de5745653188371f981','89ba83143af554eb0af0c32be6f92b9efb47cec3',81,'mod_scorm','content',0,'/mobile/slides/','5YZD21yKoTr.gz',NULL,3260,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2685,'35659bdd70cd7b843c38e9a00c84b24c00b832ed','f5e77dd8d047a794b06ba06a7d506ff0208667a2',81,'mod_scorm','content',0,'/mobile/slides/','6hFSINzM5pL.js',NULL,15845,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2686,'9ee681b02581c80529963e806c91bcc09af50439','4259fb190eb36ac0420a2b0097ff24c99d3b595b',81,'mod_scorm','content',0,'/story_content/slides/','5VrFdGUm779.swf',NULL,3549,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2687,'7526c72b160c1b1ddd5ad3af74b28ead4181388c','69431ae96f60a642d77a531e3dd7bbb9bf4d7ca9',81,'mod_scorm','content',0,'/mobile/slides/','5VrFdGUm779.gz',NULL,3260,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2688,'8b03e9c4427eb1cce272f615d90ecd060daaea3f','2fa27171c458cb54f61696f5341aac9119ce3fff',81,'mod_scorm','content',0,'/mobile/slides/','6Qm0gQy7aNO.js',NULL,15842,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2689,'762b26ef59e8b22fc310812e5e9778cbe38a4bd7','1a751665628fb8b6adb074900f8ad5832cdb192e',81,'mod_scorm','content',0,'/story_content/slides/','5WvCHldRdYW.swf',NULL,3557,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2690,'b16fb292947ae63ceb65870fbed3c44906e63366','4ebdaa61962d1415c930aa96649b5c9ebcd29ece',81,'mod_scorm','content',0,'/mobile/slides/','5X0tmoHtaoJ.js',NULL,15855,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2691,'cc541dc142f5e08ccab392591754b1365e866e9b','3ff857a2d99c5cc9e91343b4b10135015eeb46a8',81,'mod_scorm','content',0,'/mobile/slides/','5YZD21yKoTr.js',NULL,15849,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2692,'61c6a32cbe97c16f2853cda652e13f4a9865704d','85799930c4a9165e02607c17ddf1cb653992203b',81,'mod_scorm','content',0,'/mobile/slides/','5WvCHldRdYW.gz',NULL,3268,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2693,'91c9fbe65aca99223015cdee83425edca4e72428','4d3cc0990c0469c3b93086f56d206717eee6c48a',81,'mod_scorm','content',0,'/story_content/slides/','61Q6QTC37py.swf',NULL,3573,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2694,'2eba50e48856a61c42776a9f15a60ad2a5187835','c6798e0f3f504ceb4493cf2b0579d00924192dc3',81,'mod_scorm','content',0,'/mobile/slides/','61Q6QTC37py.gz',NULL,3281,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2695,'50ad2712ad6037f8bf44aa569e4452fe3ad23493','53d946156ee2166f6ca02974c5de72c319355d15',81,'mod_scorm','content',0,'/story_content/slides/','69nHYGH7d2L.swf',NULL,3552,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2696,'68f29e1030a38f03cfca8b586a746bdb98a474fc','e20e48f958383aafb85d8b6a0ba5b4f8eebe82c7',81,'mod_scorm','content',0,'/mobile/slides/','69nHYGH7d2L.gz',NULL,3262,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2697,'7c42b236f644adbf5f213ce1a0bdbd8130ce78c3','09572ab05072d42b501379a606af4bda12c9693c',81,'mod_scorm','content',0,'/mobile/slides/','5WvCHldRdYW.js',NULL,15851,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2698,'a3a8323c62914b1de1eb1053d536fa72970a3357','0f6513fc3efefad9fd5b5be8bbec9fccfe1fd2d7',81,'mod_scorm','content',0,'/mobile/slides/','5VrFdGUm779.js',NULL,15860,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2699,'6f7d2d3de215c3609d877e2d0553fc2db09dff4c','f462563551158727f1a8b127ed7824bbf13127ab',81,'mod_scorm','content',0,'/story_content/slides/','6fFEFWZqx6h.swf',NULL,3558,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2700,'7a3ac1b0e66c46e49f397c219f8ab8aef48e3108','3cf55bd8abb31a2797bc011c7cb0313c801fb9d5',81,'mod_scorm','content',0,'/mobile/slides/','6fFEFWZqx6h.gz',NULL,3269,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2701,'8dfd53c0476663bd5286397fc597e52ad9f77e69','fe755e83b11643d60cfe53a89fa199621bfdbff9',81,'mod_scorm','content',0,'/story_content/slides/','5dWzjbb03ie.swf',NULL,3564,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2702,'4230e25884337f8e429845f3d96de684691a7059','0b63dcb23875042c6aac96ed3408cee5569656c7',81,'mod_scorm','content',0,'/mobile/slides/','5dWzjbb03ie.gz',NULL,3273,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2703,'55b8260045e50a039ab706e39a0b6109bffc0afb','d2dfabe08fc5f0cb41cdcfff1d9ba3e3dccb2108',81,'mod_scorm','content',0,'/mobile/slides/','61Q6QTC37py.js',NULL,15890,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2704,'a5b374a66d40c2b28cea39a33ab6d542f1364b75','42d7f2209fe9c699f37de80976cb7601a06cf8ca',81,'mod_scorm','content',0,'/mobile/slides/','69nHYGH7d2L.js',NULL,15850,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2705,'e3aea88d62af6f6d2dce96c97b46fbfd5be32014','2a05c88658fdf3cd27c84f1bcc87a127d441f12e',81,'mod_scorm','content',0,'/story_content/slides/','6KImkTVqToW.swf',NULL,3554,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2706,'357d4ec44741925ae7ba233e3455084a8aff9671','56b051d7cce9190363b023f03535d05d7c15831a',81,'mod_scorm','content',0,'/mobile/slides/','6KImkTVqToW.gz',NULL,3264,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2707,'280e25f3ca05cd2993336c88b4bf47f58268e209','416f32015cbb769ce2845c7bf90b46a95370ff28',81,'mod_scorm','content',0,'/story_content/slides/','5kKYigf4BGL.swf',NULL,3552,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2708,'861b9a13846ee8a04b8495788b70e22f0f582b5a','6e843bf2644d149ce17aea1d95d59a2bb332c5ee',81,'mod_scorm','content',0,'/mobile/slides/','5kKYigf4BGL.gz',NULL,3264,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2709,'65c5f960ea720f80fbb71d3c3b68dc5901c67246','af5a17c575b4565b446957b8773047490b66f673',81,'mod_scorm','content',0,'/mobile/slides/','6fFEFWZqx6h.js',NULL,15862,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2710,'306e7aeb2eecb375775f165d5fdff774c12f8df6','6410ef59d2b485081c35eb294161f4687dbe404f',81,'mod_scorm','content',0,'/mobile/slides/','5dWzjbb03ie.js',NULL,15875,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2711,'f91733cdbb0e7add9d5bf37e171caa2e6b06c72d','bd35aff1bb05d9bdf03b57dae2a290a6d7e13390',81,'mod_scorm','content',0,'/story_content/slides/','6jU6L8SIZwM.swf',NULL,3547,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2712,'8850352f56bc3429d58c8bc5ea81280596c9b019','17a8c9db1c96dc1053d1c543f7b10ffa8e4c3671',81,'mod_scorm','content',0,'/story_content/slides/','6qZYvflrISP.swf',NULL,3562,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2713,'9a1f6643d8c7c9f957466bee4b2b3f83d69e8eb1','b5d8cfdf251e5ba761daa3da3016b4a947e01fbb',81,'mod_scorm','content',0,'/mobile/slides/','6jU6L8SIZwM.gz',NULL,3256,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2714,'bfb21b3d31a9ca2d37aa4752396b54ac6ec24679','47d65aa193d74865d1652b2969357e29b61b9f1d',81,'mod_scorm','content',0,'/mobile/slides/','6qZYvflrISP.gz',NULL,3272,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2715,'0f85151948b3ac43560136f017795b042ff653d1','475b44844a65e394d700631fb659b59501313dc0',81,'mod_scorm','content',0,'/mobile/slides/','6KImkTVqToW.js',NULL,15851,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2716,'8aa7ee15d123a12fcee6630451c63dc2b636c469','51ec8a3dc48797750f0923761109f2b5521074ad',81,'mod_scorm','content',0,'/mobile/slides/','5kKYigf4BGL.js',NULL,15851,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2717,'9a9e66ec5839bb158da5ce2752d6a045e1e4ea93','d5ac9c532f8ba3189319664ed0aba033d648b7b5',81,'mod_scorm','content',0,'/story_content/slides/','69fDmvC1mCh.swf',NULL,3560,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2718,'baf10f42e92cc3663efe8d821be2b151eb083286','5529de38bba5faf4a066d01dcc16ea8e224cb675',81,'mod_scorm','content',0,'/mobile/slides/','69fDmvC1mCh.gz',NULL,3269,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2719,'cbfd1dc694747e58a47e80b35b427a5262324877','1b9cad7a4b9ae204c02da94bb669a8a1874f5f8a',81,'mod_scorm','content',0,'/story_content/slides/','6bWWIqrHr68.swf',NULL,3566,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2720,'aa6be316733ed596fabce7301002a39bff5695d3','3e78320748a31a2c40bd2539fa6259be7975ca53',81,'mod_scorm','content',0,'/mobile/slides/','6bWWIqrHr68.gz',NULL,3274,'application/g-zip',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2721,'411e75b293f2ab9bd217fe8ec7f4fc0597221def','e02fde729fbc417d1be7ff8a3727e65dbaaee128',81,'mod_scorm','content',0,'/mobile/slides/','6jU6L8SIZwM.js',NULL,15840,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2722,'bfbaa28820c63bf4e48ecb351c0707a55f1b4e26','3b5a7d2f90811a8237a5e1479d9decc1e599d97d',81,'mod_scorm','content',0,'/mobile/slides/','6qZYvflrISP.js',NULL,15866,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2723,'5910c6fa77b5889c6580f03bcfe18ec223cf816e','3b6a7e9167ea6e7244de6b012a129ff99b50d9a7',81,'mod_scorm','content',0,'/mobile/slides/','69fDmvC1mCh.js',NULL,15887,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2724,'bf24b47d5b4b45d2a419a7bc0875d0b98100646d','6f569f80e9966ba7f121ac60b3e772c788d98da5',81,'mod_scorm','content',0,'/mobile/slides/','6bWWIqrHr68.js',NULL,15868,'application/x-javascript',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2725,'d6c8f16866f96eef47c07b129f1f4a12ae4e8164','58d798b963d4fbe38fd68282efce4799e0cff6ea',81,'mod_scorm','content',0,'/story_content/slides/','5qsShBSBYDh.swf',NULL,3544,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2726,'18ab11c3d03ecd81534cb3d35fb08673a13e4a87','8579dba25105311018f57f03cc48a3493288a0f5',81,'mod_scorm','content',0,'/story_content/slides/','6VtH3SHbawa.swf',NULL,3548,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2727,'ee6650f96286695ccecd4020f13b89a16836a2af','8c5b064fd1b1aff241909bf22286f62b4e3d70b7',81,'mod_scorm','content',0,'/story_content/slides/','5tg6DaoRnAa.swf',NULL,3549,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716821,1462716821,0,NULL),(2728,'b56f64cfb386e0780e51c99142b2d2f60f2ae6b3','d3bde66c48ca7706a847b1b795d7a1c01c7c70f0',81,'mod_scorm','content',0,'/mobile/slides/','5qsShBSBYDh.gz',NULL,3254,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2729,'5071c0bf35d241a7a1e81f6a9f49d1bd8f350204','cb88efce8fb54589f2e2823eb243a3e981e33131',81,'mod_scorm','content',0,'/mobile/slides/','6VtH3SHbawa.gz',NULL,3256,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2730,'e930e041e61626d484d8565c237db9ec58362e4f','e45543c97df1c4e4905c8151cc3fd2147df10805',81,'mod_scorm','content',0,'/mobile/slides/','5tg6DaoRnAa.gz',NULL,3259,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2731,'9c3dec6c2458d04d29134b0b448f25622218fb12','212231ab9c969745440b8c5549971138e73f28b5',81,'mod_scorm','content',0,'/story_content/slides/','66FLuscUQre.swf',NULL,3550,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2732,'91c1fb11c97243ebcef57172fe32f1aa931143a8','7563a832ae49d1a28b0c5072e801e2202b0418f2',81,'mod_scorm','content',0,'/mobile/slides/','66FLuscUQre.gz',NULL,3258,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2733,'f16aff2a057d4636f816b9e4fee2b39b528b3113','b1a317563ad9989e8d30f6befa11fb402c0f5a05',81,'mod_scorm','content',0,'/mobile/slides/','6VtH3SHbawa.js',NULL,15861,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2734,'be897dd456c0deb80373f38e8c3c50ae8b13ac3a','64636a78bae60775e16eadf727f090cfb8fe8d01',81,'mod_scorm','content',0,'/story_content/slides/','5teDaFVt067.swf',NULL,3551,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2735,'dcbd840ebde48e9d8dd8374771bc3e64a54ba311','bd40becb1360083c3384ad7205e3ecd650f10c8e',81,'mod_scorm','content',0,'/mobile/slides/','66FLuscUQre.js',NULL,15853,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2736,'660de9ca5442474b340cabaacdcc0722864313cd','177fc41ca1ee04307f4b1ddb31b3ed7f57a76260',81,'mod_scorm','content',0,'/mobile/slides/','5teDaFVt067.gz',NULL,3260,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2737,'4826c2d80db5c767c38465b32d88aabe8e9f4ee4','9e43523d5ffd0f25963aca97ce506b9d05aa14eb',81,'mod_scorm','content',0,'/mobile/slides/','5tg6DaoRnAa.js',NULL,15851,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2738,'2998be42b827bcf8328e6d1cd7c0c19961d27a31','94b65700448a2a443200b0a0c17d4376756c0747',81,'mod_scorm','content',0,'/mobile/slides/','5qsShBSBYDh.js',NULL,15846,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2739,'e03f426f64921e7f2a18cdf7cd500f6e38e24d6d','3a1033bbd69a8401b14f76c77bdbcb4f0bf8884e',81,'mod_scorm','content',0,'/story_content/slides/','6T6XOsyYc7V.swf',NULL,3561,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2740,'f53223bf0cd0e47f8c227eca2047550a1c8eab42','8e5b1f9b2288a0617047e82a485997e879c6a307',81,'mod_scorm','content',0,'/story_content/slides/','5dZCC8lUiNQ.swf',NULL,3583,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2741,'6761e3544f994bab9669108fe35345a20de416fb','bec22e29e170ab1b32bb00b7fd355b3da209a537',81,'mod_scorm','content',0,'/story_content/slides/','5gLjcvIb4Aa.swf',NULL,3543,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2742,'5107e45847dca283120ae811bef32e60fca87070','8d30b9dc7e6ea8075466caa19e756e5bcf620ecf',81,'mod_scorm','content',0,'/mobile/slides/','5dZCC8lUiNQ.gz',NULL,3296,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2743,'d0af535fbe24d9d7a2750a560e0e57efedf643e2','cf58c1962496cc82c90d7a71abfaf3828b40226c',81,'mod_scorm','content',0,'/mobile/slides/','6T6XOsyYc7V.gz',NULL,3270,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2744,'bee402f2fe68bd1326cb2907bad27fcefaa2300f','d073f4adc06499b78dbe0f19efe29af42a388a4d',81,'mod_scorm','content',0,'/mobile/slides/','5gLjcvIb4Aa.gz',NULL,3253,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2745,'94240e1d38a4ebda1582a9742edc90b2c6b48108','1bb3ec0e52075700d9efd54247a2e23e9aa68111',81,'mod_scorm','content',0,'/story_content/slides/','6FJrE9EG2A0.swf',NULL,3567,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2746,'36e274caff24126f26da003915132e3c2e7de320','baf9138edc81717500e15a75fd4aee3d53eca4b9',81,'mod_scorm','content',0,'/mobile/slides/','6FJrE9EG2A0.gz',NULL,3274,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2747,'339ca85cced5f5cb2afb2e6f1665169a5d2738bf','3b588a4f4d9ecb94a832d41a53f49b8c3d355e4c',81,'mod_scorm','content',0,'/mobile/slides/','6T6XOsyYc7V.js',NULL,15874,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2748,'21f654f5fdc58d2e0512a9caa47c52948c3d8aba','476e7a7539e215e10ee070a4d9bdaa1a8651bb8f',81,'mod_scorm','content',0,'/mobile/slides/','5teDaFVt067.js',NULL,15848,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2749,'99e5f1223acd1e9e64160c35fe57048c13c456f5','1390439e1af15c4f1d0972f195fc2062659e1d24',81,'mod_scorm','content',0,'/mobile/slides/','5dZCC8lUiNQ.js',NULL,15910,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2750,'3134b6078195ce064953a2444dadfb22d703ce6a','d4a3c6db918060f9c6ceb19a49808565b5cde7f8',81,'mod_scorm','content',0,'/mobile/slides/','5gLjcvIb4Aa.js',NULL,15843,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2751,'441d5ecaf14b16cdf353f7842baa19a1499167dc','61bfd46526fa95c5282c46c3d4239f64078e6f52',81,'mod_scorm','content',0,'/story_content/slides/','5unuLmrCuyh.swf',NULL,3563,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2752,'010e1ed9fe79fd893aabb5807fbdf6fa8436b93d','6eff5373a09a58b44853d9696b68c05f9688f070',81,'mod_scorm','content',0,'/story_content/slides/','6a0RUR9JzOo.swf',NULL,3561,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2753,'90bfdb2eeb640d02796e5de1aeb7630adf36c543','78cd5583266d40f2af84efeaaba02095e6bad26e',81,'mod_scorm','content',0,'/mobile/slides/','5unuLmrCuyh.gz',NULL,3272,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2754,'bbf8e75c7f78042fb04d1f5a9a2c6ed8d4da7e62','df1b4310c56729cead45ef3ab8a9b27e2c911069',81,'mod_scorm','content',0,'/mobile/slides/','6a0RUR9JzOo.gz',NULL,3270,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2755,'4c48446315bc6a02022a352f7660d368da534131','4f431867676bce3bc86696d94d69e9c56bbd4adc',81,'mod_scorm','content',0,'/story_content/slides/','6L9nlBbXzi7.swf',NULL,3551,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2756,'ba643d7d2b15672b54bbc87c097a94054a9ac468','2318bf1b017382953bd59af4f9f2ae25152e1857',81,'mod_scorm','content',0,'/mobile/slides/','6FJrE9EG2A0.js',NULL,15879,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2757,'ee1b367928fec4d6aa81ecd432ee1fe947c0744c','916aedb51988a6a5b2a2859b6947bc7abcf0e550',81,'mod_scorm','content',0,'/mobile/slides/','6L9nlBbXzi7.gz',NULL,3261,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2758,'7d6f0a8c76b70553ab840eb0928162b6823366db','1a03b849c9e3e90081545d2a819ffdc97fce8f75',81,'mod_scorm','content',0,'/story_content/slides/','68myag3aRhO.swf',NULL,3555,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2759,'bf235dccda37cd9bdaede280a343dddc2101884c','2050083338d0fbe596817c955e0e1633322925dc',81,'mod_scorm','content',0,'/mobile/slides/','68myag3aRhO.gz',NULL,3264,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2760,'a85949fa894371dedf19605fc83426b8b1c41f00','5d128ef685d5d71424b082301176dc3eb7ce1f7a',81,'mod_scorm','content',0,'/story_content/slides/','5dscOsqSQXN.swf',NULL,3553,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2761,'c6b83ed061f2e5d1602f2d982db7db03783c5e75','19532fb7e1b17121914ff4cfe126c4c3c1ce3bac',81,'mod_scorm','content',0,'/mobile/slides/','5dscOsqSQXN.gz',NULL,3262,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2762,'483edd3893a240ea27186589d1d48d7bb5edae58','009b980d2b17ea70d5a15808fd36154e24951fe0',81,'mod_scorm','content',0,'/mobile/slides/','6a0RUR9JzOo.js',NULL,15867,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2763,'2a2940cacd3bc2181f61eded0e35ab5a514a228e','e2ac3e48372d6d04669d9b69354720842509f616',81,'mod_scorm','content',0,'/mobile/slides/','6L9nlBbXzi7.js',NULL,15848,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2764,'5d184a379d7cf7c9ea07411c97bc509de862eadf','9df8bcb763eae458fa03ffeb3aed02e960d10453',81,'mod_scorm','content',0,'/story_content/slides/','6PxThLDIory.swf',NULL,3563,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2765,'7e8e823d8bdcca58a933541b5e046e932a5ba076','d4423c21cf75e46d0c40b0529a96c516c4face9f',81,'mod_scorm','content',0,'/story_content/slides/','5bj6EqMwe3o.swf',NULL,3568,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2766,'9e56ea4b3969bb3ab67ee749ef727df39b4842d0','057ecf02cb0e811348fd41e56981c84afd21dff6',81,'mod_scorm','content',0,'/mobile/slides/','6PxThLDIory.gz',NULL,3272,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2767,'e35de7554ddff805e6c63fed23741b839b2a74e7','f75470dd335a9f58586f389329a654e2d9572446',81,'mod_scorm','content',0,'/mobile/slides/','68myag3aRhO.js',NULL,15855,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2768,'af94cd24746a5478adc6b517d71695b7ed9bc610','d3a13c30ec3b7507c42df64f575c310a9a03a281',81,'mod_scorm','content',0,'/mobile/slides/','5bj6EqMwe3o.gz',NULL,3277,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2769,'a30715bd9167bced7515c923b186b26279186599','cda79ace3f3cc0904936eaeb336bdac42ee92834',81,'mod_scorm','content',0,'/mobile/slides/','5unuLmrCuyh.js',NULL,15868,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2770,'36eb5b2f16404cb23110701a013dd92333ef93f1','f14851ae2b74e3fa11a06c838b5bf16627d853e0',81,'mod_scorm','content',0,'/mobile/slides/','5dscOsqSQXN.js',NULL,15848,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2771,'1c84982461f3b61fbc314ee3dd0e0e36f4371dd4','d2153028b64f2955e3e8b049cc0a0ad285017c6b',81,'mod_scorm','content',0,'/story_content/slides/','6T93kgBUB4q.swf',NULL,3565,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2772,'0ead33f3d1850b9b0cc3e885332d288633cfb431','51396ae303bb91749d46c99f9d1713d4fcb6d8a8',81,'mod_scorm','content',0,'/mobile/slides/','6T93kgBUB4q.gz',NULL,3274,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2773,'643706ec8f6f5f2cc737fb5376bdb9bc0f154a82','a9a51f7cddcae3baa92d7ad98f14d249fe2a404b',81,'mod_scorm','content',0,'/story_content/slides/','5aH5XEIVdqr.swf',NULL,3574,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2774,'4732267e41e8acfe078d3973faa130b64b49d9cc','b43102c8df5407a7fc5526a01d6e822929703181',81,'mod_scorm','content',0,'/mobile/slides/','5aH5XEIVdqr.gz',NULL,3286,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2775,'543aeda49c798878a11f3e833bf0460996f38fbc','81b056b395e63236429052b7d74687fa77be739e',81,'mod_scorm','content',0,'/story_content/slides/','5ivjt1hGMau.swf',NULL,3571,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2776,'d28324bc06efb72390e64ca3b93250e9391bcaaf','6da77c60a82fb99670a3a3b669f72890b761720e',81,'mod_scorm','content',0,'/mobile/slides/','5ivjt1hGMau.gz',NULL,3279,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2777,'94c8f35d685a1ccd38723a4beed2362aff6b4014','b51b768f353946cce1c1b5ec140691058e765da8',81,'mod_scorm','content',0,'/mobile/slides/','5bj6EqMwe3o.js',NULL,15884,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2778,'53cba00f39fef74767ceb734ad4cb5f2a0f97fca','80247843c8f70c65ba66edb71d0dad8be4262c63',81,'mod_scorm','content',0,'/story_content/slides/','6BkBvLLvMLX.swf',NULL,3571,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2779,'a48e9b8dc1cb1e06e7d08d5148fc025591eeaa9c','4074f234c8c3ba1931822e31653a71bbd6292c7b',81,'mod_scorm','content',0,'/mobile/slides/','6BkBvLLvMLX.gz',NULL,3281,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2780,'c223628f1ab8c441e5aace8463822da00c8b7686','d6ad5540c254af09e20f9057d8b027a8b849a557',81,'mod_scorm','content',0,'/mobile/slides/','5aH5XEIVdqr.js',NULL,15926,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2781,'4f0ebc527ae6a7c53ceeeebbc4030ce807af7c7d','46e9d256c3b6c84015bd788cc6f07f075be400f4',81,'mod_scorm','content',0,'/mobile/slides/','6T93kgBUB4q.js',NULL,15870,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2782,'fbd369ee0f60a92ca6594a710ae5def003484f49','a4fde1124ccbf9022dc33d995b82999ed6a9e2b9',81,'mod_scorm','content',0,'/story_content/slides/','6nf82IqHqoe.swf',NULL,3556,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2783,'c01138c8027e5423d3a2ee1aa54bff795fff767b','1befd20284222d8d80c08f2a6dd64eae257897af',81,'mod_scorm','content',0,'/mobile/slides/','5ivjt1hGMau.js',NULL,15889,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2784,'84c85b4bb26d493ac1b03652ba080b0fe555d78b','f86017ad36e6bd5e7ab87afa6ca08392bceb781b',81,'mod_scorm','content',0,'/mobile/slides/','6nf82IqHqoe.gz',NULL,3268,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2785,'6fc25ae6bba6e3c25f591c3c479536fc1e8608bc','8c57455292331034dd8ed44c9b748db63c09b762',81,'mod_scorm','content',0,'/mobile/slides/','6PxThLDIory.js',NULL,15870,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2786,'49539068a0df0f16ac4e57fbb5d46256c693d4ce','09f75229efbf74972ead9d0a52e65a0e2eb8f771',81,'mod_scorm','content',0,'/story_content/slides/','615buIDmbFy.swf',NULL,3553,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2787,'a75c695243e3f60a6d76d3c0ffe83aef1f71983a','a1d6bc0d968ccd394d59474ff64a5ddea0af270f',81,'mod_scorm','content',0,'/story_content/slides/','6NdJsnL5pQF.swf',NULL,3557,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2788,'9e57430147d74b48efbdb79f7e2819dd23247a50','1bdc310c503aa48000450ea36b23de3501122085',81,'mod_scorm','content',0,'/mobile/slides/','6NdJsnL5pQF.gz',NULL,3267,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2789,'2868ddeae0864a7cfd315e865d1d1ddd9ac0ae89','6a998616be920eb85332a878bc1844c1e8701fb9',81,'mod_scorm','content',0,'/mobile/slides/','615buIDmbFy.gz',NULL,3264,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2790,'9a0effa225a55a8bc4f90c2a254b64bf17d3b323','9f7bdeca1bf22242b23b400c0fb4184cedd8b01c',81,'mod_scorm','content',0,'/mobile/slides/','6BkBvLLvMLX.js',NULL,15894,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2791,'597c51e424a5aca57554a32ab7d87f3a43688fb4','fed4c629492e9e923ab14ef87938f0230a362e56',81,'mod_scorm','content',0,'/story_content/slides/','6VX4F9HVRkI.swf',NULL,3552,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2792,'06c928b3e2269df04ea93c619ec902de01ae121b','7038f4663bfc9caba2751c1dcbd1194d510b1b51',81,'mod_scorm','content',0,'/mobile/slides/','6VX4F9HVRkI.gz',NULL,3262,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2793,'713bb45d789366c2007cd082609b36ba3b6114ee','a11ae7215340d28f6536f279b01177818357b636',81,'mod_scorm','content',0,'/story_content/slides/','5XlCs4Wf0di.swf',NULL,3549,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2794,'c52e189de8d8b0fd8c98cf02ea30dfb8858edf69','185f0487e64c511325a8bb22d4444d25d0136413',81,'mod_scorm','content',0,'/mobile/slides/','5XlCs4Wf0di.gz',NULL,3259,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2795,'f177a0e211e45d2cfcb87485ac8f9342b6f12ce2','c470470853b6dd533bf076bacb87275afb007777',81,'mod_scorm','content',0,'/mobile/slides/','6nf82IqHqoe.js',NULL,15851,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2796,'b964933b18d8fdda8a40937b9bc9894900fdc193','97a7c9acaf9102744b90be54f57d7a9bb84fca13',81,'mod_scorm','content',0,'/mobile/slides/','6NdJsnL5pQF.js',NULL,15862,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2797,'aeb25982c16584f7bf3eb396c56a5c38f8b1518b','6437c9269a1e9e06df375b0f36bd6fbd0fa4d969',81,'mod_scorm','content',0,'/story_content/slides/','69YfsP8ZGEr.swf',NULL,3569,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2798,'5d13d3acb9ccbbbd52b5a34748155a9f97696871','3b702f6c8b17cf9fd65d45fb7a4b6fc189947488',81,'mod_scorm','content',0,'/mobile/slides/','615buIDmbFy.js',NULL,15861,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2799,'867a50cd861b620fb03fb5d8d3a622d20f3a9b86','ca6bcdec6cc5e03daf3b48cf30b685390c047e3a',81,'mod_scorm','content',0,'/story_content/slides/','69srRswO6AO.swf',NULL,3558,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2800,'114d1fbd2567f30d4a5e5ca4f6525df356489a8b','11e38429d3dd36ac80ebcae2f209974a9442b7af',81,'mod_scorm','content',0,'/mobile/slides/','69srRswO6AO.gz',NULL,3267,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2801,'38f887f59e9fd8d94716404d0e48c43361e492f3','ce53088f092f54eae1b925b1891fed827d3cecbd',81,'mod_scorm','content',0,'/mobile/slides/','69YfsP8ZGEr.gz',NULL,3282,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2802,'f3888ef615d28d342a86485b832d802b2716a33b','f193f015e992dabe30451ba14736343f866e16ee',81,'mod_scorm','content',0,'/story_content/slides/','6d1tnObv6wC.swf',NULL,3565,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2803,'662216d6637a1d9adbd4926d1755bb939b057d53','9dd59477965cb9ea00d300dab8092ae80aaae6a0',81,'mod_scorm','content',0,'/mobile/slides/','6d1tnObv6wC.gz',NULL,3273,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2804,'09723fb6fbc7fa36a8eb020e73f758874fc06f5d','dde346923b6a2b3fcea72239508aad6ef361e0e8',81,'mod_scorm','content',0,'/mobile/slides/','5XlCs4Wf0di.js',NULL,15848,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2805,'0435b8e07001ea8063bb3ecc18f9285379913549','27fa84244b0c6bc936a72a488b6b3c7936cb98a5',81,'mod_scorm','content',0,'/mobile/slides/','6VX4F9HVRkI.js',NULL,15857,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2806,'4b75697bdaa8fe4a0d1269766832114fe2204daa','afb501f9eea8b5c7be2595b3cc84f678ba1038cd',81,'mod_scorm','content',0,'/story_content/slides/','6FunTNXMcba.swf',NULL,3565,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2807,'5b26e909f0d02c5320ce0edb44145c2ae8541cea','c4f2bc04e6cab91ecf7cb6563f2e0459e3cb5928',81,'mod_scorm','content',0,'/mobile/slides/','6FunTNXMcba.gz',NULL,3275,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2808,'23ce55a7b3a2183cb90ab1d2ca779292910a9b83','b324f8074c58b4c9dfc72bbd670038169c1b69db',81,'mod_scorm','content',0,'/mobile/slides/','6d1tnObv6wC.js',NULL,15883,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2809,'a3439d33acf5342558537e1abb8c6fdc7610d81f','4a665a9c16b1fd0effdb66908da11cb02ef244b4',81,'mod_scorm','content',0,'/story_content/slides/','63TEr7PIrCz.swf',NULL,3550,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2810,'c6a68fb2624ee3021b31584c3c34909e1f3cb6a8','30489350a3b4f380be9beeb9f044433889e234a5',81,'mod_scorm','content',0,'/mobile/slides/','63TEr7PIrCz.gz',NULL,3259,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2811,'056a373952f34aff400f25b0c91b32b639987328','e5df1a85677b03f6a026cf45927ece7378385edd',81,'mod_scorm','content',0,'/mobile/slides/','69srRswO6AO.js',NULL,15861,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2812,'c28632bda74d4a7f6022314bfedfff2b4c76eb5c','84c98cf02877cc7cd06885ee6452110ea9b96feb',81,'mod_scorm','content',0,'/story_content/slides/','6XdTudUshiV.swf',NULL,3565,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2813,'ca19a771eea618e285f220140d9d0af706c35363','d0e37c9886ad241aaa9f9ea3b3eff2b08fa12e26',81,'mod_scorm','content',0,'/mobile/slides/','69YfsP8ZGEr.js',NULL,15895,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2814,'d2584aa1d5a7a58985d0cdbd2a872144d365c897','e5cd6b7d0fa0d61ee1a409e0d516b7a738c8db8a',81,'mod_scorm','content',0,'/mobile/slides/','6XdTudUshiV.gz',NULL,3274,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2815,'1b23745e1194bf8061861459f53c9154da573cfe','2be651e8d07c26ec3fe05a157e404acd2913dcf7',81,'mod_scorm','content',0,'/story_content/slides/','5h6RDXkmNAL.swf',NULL,3555,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2816,'5509803980773a573a1da545cd39569966b66df1','0c71b372942f63b4f28798642206a6cf62d4ad8a',81,'mod_scorm','content',0,'/mobile/slides/','5h6RDXkmNAL.gz',NULL,3264,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2817,'9c8d631bee3068eb669c7e89f1f8559e6f73d071','3aae0ba351eaccc0e99f4a8aa566a6e4bb247dc5',81,'mod_scorm','content',0,'/mobile/slides/','6FunTNXMcba.js',NULL,15872,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2818,'079cf51ed75271b3bf9df28e761c27a4e2d2f3a8','0836ae68b69938f38c342a4d07abe755434dba3a',81,'mod_scorm','content',0,'/story_content/slides/','68Z2pl5Htei.swf',NULL,3563,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2819,'d363313517d8ce61380893ebdc4c125ed0d203c3','2d13caa8b1df114f77344f7be10d783577b9ce50',81,'mod_scorm','content',0,'/story_content/slides/','6Wntv2MiHYt.swf',NULL,3560,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2820,'0b224713ceb4879bfab252694cd5429c5a30f7d8','c2ca56ebd364ca71aa81f1fb23aa5d7e911c32f8',81,'mod_scorm','content',0,'/mobile/slides/','68Z2pl5Htei.gz',NULL,3271,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2821,'0dc717346d8df4e4419699207047ea8d915e32bf','fb4855e4adaeafcd95b1af59d08e482e5de5625f',81,'mod_scorm','content',0,'/mobile/slides/','6Wntv2MiHYt.gz',NULL,3269,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2822,'26e9b6906394cc48f1a7a0ef485876c9430cbffd','4a73a849f769d25368ba484e7136c60f480c2650',81,'mod_scorm','content',0,'/mobile/slides/','63TEr7PIrCz.js',NULL,15847,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2823,'d9ab7ea0a85cafa1fb8496bb0f6a053c225bbfe7','20945c8bc8e71e33ca6e563e34bac0ac5a8a9580',81,'mod_scorm','content',0,'/mobile/slides/','5h6RDXkmNAL.js',NULL,15856,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2824,'1284895899f849e54cad60e75fe5cc8c90ec6a77','ce5c2af38ae95e4c86167978cd4f5653f70cdb50',81,'mod_scorm','content',0,'/story_content/slides/','5ixTg9SCdpK.swf',NULL,3545,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2825,'7d2c6dc0dec0b5feef8e74839fda9d2f7ad81c56','e68b61f0d0de7278d379142387dacf38e2345baf',81,'mod_scorm','content',0,'/mobile/slides/','5ixTg9SCdpK.gz',NULL,3256,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2826,'fc4c83c2d6290220c90e956abc6c890af9b21758','bc2cf2377999d16a355ef834d8ea6c0a63e8f84f',81,'mod_scorm','content',0,'/mobile/slides/','6XdTudUshiV.js',NULL,15876,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2827,'0fb45b3a6a0dbdc563aa9920cebe296cf3d56dfd','cd31ccaa8c5715cc2f5a59ff9a4c4d5e592b7390',81,'mod_scorm','content',0,'/story_content/slides/','61lRQMWVA11.swf',NULL,3548,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2828,'252d989a7b62774ba13d12c39f3e72148b7b97d5','7c75a019bcd251e72202672a41832e7a7321161f',81,'mod_scorm','content',0,'/mobile/slides/','6Wntv2MiHYt.js',NULL,15877,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2829,'fe174e55182f8501433df34c72e7bdfe0e61f688','066ab82889e0061d5a1c39bbd3e880e77f679391',81,'mod_scorm','content',0,'/mobile/slides/','61lRQMWVA11.gz',NULL,3257,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2830,'f35d2795a79716f9ea9382612e7af50d6c26d058','4b6f777040c026af15a18d767c7ac0336b6b1e49',81,'mod_scorm','content',0,'/story_content/slides/','5aF3DnkEo5Y.swf',NULL,3569,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2831,'f09320b5f1ac6f4980ec29c02d11d38a96e89801','74b5f7d5bf155cd68ed286b8be999bf9928e017e',81,'mod_scorm','content',0,'/mobile/slides/','5aF3DnkEo5Y.gz',NULL,3278,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2832,'e3ea50cd80a67b2f383f0d4944727767c0b2b315','71d9c87eef9f8525996eb6cfa3d4fc9f84fc311f',81,'mod_scorm','content',0,'/story_content/slides/','6q4lDrrFn5s.swf',NULL,3545,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2833,'16eaa6c17640c33337bb06c5349b861b713e1a44','bcf0c80ffb2336732d27fe06b1ad9cce1a1fac86',81,'mod_scorm','content',0,'/mobile/slides/','68Z2pl5Htei.js',NULL,15862,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2834,'0b4ef63f63799f5bb1b187ae8dd43c7b1460d22a','5dc9a5d37e9e5034a96b1271a91d9db112c5361d',81,'mod_scorm','content',0,'/mobile/slides/','6q4lDrrFn5s.gz',NULL,3257,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2835,'c577907a0dae64e247d1ef50a863639aba58900b','881f9f130197b2016f8005ff280f177bb653039b',81,'mod_scorm','content',0,'/story_content/slides/','6qegiChjZRS.swf',NULL,3559,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2836,'2eae590c59e0204e4c0efc984c2840667187885e','3ccc6f4c61f8da28b299487e9cdb422cb4ab62a9',81,'mod_scorm','content',0,'/mobile/slides/','5ixTg9SCdpK.js',NULL,15844,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2837,'96cc0b20bd1d38df8b5f3c2766ab1ca32bb95df6','0cb8c5dfe02be749ac8c98baa83c0ef38ce6bfb2',81,'mod_scorm','content',0,'/mobile/slides/','6qegiChjZRS.gz',NULL,3269,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2838,'d899c57da02ce4976a92bd009985960a87d4bebb','3e32bcf81bd5ac8f684fc85c48f451700a3cf835',81,'mod_scorm','content',0,'/mobile/slides/','61lRQMWVA11.js',NULL,15847,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2839,'4c9fc722941213d5c83b94496ff8abc7fd7bcf90','589ce9c0c1aff108123bbb85fbc28dcdd26a37f9',81,'mod_scorm','content',0,'/story_content/slides/','5jIShucvAIt.swf',NULL,3558,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2840,'a9d1e6110640ac06e72843bdc0fdd74e60fe91f5','9741c887b59a8687a7f9d87db7dcb660c9f27373',81,'mod_scorm','content',0,'/mobile/slides/','5jIShucvAIt.gz',NULL,3266,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2841,'34cbd5b6573d721caead3837fd98843080bec8b2','94372df8016244a22c898c6734eec10ed4b339e6',81,'mod_scorm','content',0,'/story_content/slides/','6pwu0AMR85c.swf',NULL,3562,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2842,'0eabbdcae69cdd8eeb01cc7d807c7be69747f52c','ab1303bb1ab47724fd547cda737127247fb025dc',81,'mod_scorm','content',0,'/mobile/slides/','6pwu0AMR85c.gz',NULL,3272,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2843,'951928bc89caf8cfd6bf904bf91a37dc5dda29db','1e4e8e68275a61bdacc22f2209d1f15f9a4b5260',81,'mod_scorm','content',0,'/mobile/slides/','5aF3DnkEo5Y.js',NULL,15895,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2844,'9f15a877b4bb8f2d7ae023383081830e8c92c7ad','1362207a4274f207ea4c975976db799798b88031',81,'mod_scorm','content',0,'/mobile/slides/','6q4lDrrFn5s.js',NULL,15846,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2845,'2f9a5bccb01e7a791d938aa93b0991c489553cf2','bca637b28f5080e5c91b1f84a6e0c9f5f76a93f0',81,'mod_scorm','content',0,'/mobile/slides/','6qegiChjZRS.js',NULL,15860,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2846,'33ddd1840c33ddac31a3374d1ea7dca0f54797cb','e3e4aeae767bee06a0189574d1039ab3a2b2261d',81,'mod_scorm','content',0,'/mobile/slides/','5jIShucvAIt.js',NULL,15864,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2847,'58672e5a9ee1394fac8614934e74f92700e59dd0','ac998b30839ab815080cf0d757e6a6aedf585f8d',81,'mod_scorm','content',0,'/story_content/slides/','61W78liAdqI.swf',NULL,3544,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2848,'9171fa0e61e7c384b846228249dc8bd0227509f0','586ee8cf610b14c9848e934d2ac22293106bd45e',81,'mod_scorm','content',0,'/mobile/slides/','6pwu0AMR85c.js',NULL,15865,'application/x-javascript',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2849,'26dda3696470d6acfcaa6d533b42c60a2771757a','87c818e79272febfe833beecfc8d150460edc994',81,'mod_scorm','content',0,'/mobile/slides/','61W78liAdqI.gz',NULL,3254,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2850,'765a9b1567baf6ac81bb572b21eb939418aca4c3','40c79a96f9aed310cd3265df7936e306309ed399',81,'mod_scorm','content',0,'/story_content/slides/','6Xty7BlUqOt.swf',NULL,3558,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2851,'4cb0c3af24bf4c9b55c1aeba4ae2e8186c34c46c','713aa19038920c66f121e1d178ee90b98746f434',81,'mod_scorm','content',0,'/mobile/slides/','6Xty7BlUqOt.gz',NULL,3266,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2852,'f59cdd37fc16a8975d04836053d4874cc2585856','26bebb95db6a6748b0a74821d3ce3e426224f0d5',81,'mod_scorm','content',0,'/story_content/slides/','6oX0ixdhAlp.swf',NULL,3547,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2853,'6bbf2e3d3618d72499ec1adc1e5bd766062df546','70f379f81d6d1eeb2712f7b95373631d4c3ccc21',81,'mod_scorm','content',0,'/mobile/slides/','6oX0ixdhAlp.gz',NULL,3258,'application/g-zip',0,NULL,NULL,NULL,1462716822,1462716822,0,NULL),(2854,'bbfe7335f6c16b9b972364ad70635d76052b138b','de256d93b2df996020b4b1bdc4ea4a0f73e26998',81,'mod_scorm','content',0,'/story_content/slides/','61W5Rj3eDkY.swf',NULL,3562,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2855,'390dc7a698138a5932f419b60c2f6bffb8b96628','ad56b41c61ed06344a7a02823f854260ff6e33c9',81,'mod_scorm','content',0,'/mobile/slides/','61W5Rj3eDkY.gz',NULL,3271,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2856,'4789c04b4c701c2f9c7a9e322be0644e7e3bd4bb','b3d8488573c67ec0b105f5b4c488bcefa99b1408',81,'mod_scorm','content',0,'/story_content/slides/','675YVtFBnrb.swf',NULL,3562,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2857,'346e912174511d258135854d44270e71c1021cdc','4cd473ad5de7cecde90606cdd624e59fa0b94caa',81,'mod_scorm','content',0,'/mobile/slides/','675YVtFBnrb.gz',NULL,3270,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2858,'3a0337f6d3c77b2d82bed697b55bbdb3057b3fc4','c932694f1385a9ef134ce1f35f1a2e94d7c596e1',81,'mod_scorm','content',0,'/mobile/slides/','61W78liAdqI.js',NULL,15848,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2859,'9c639012fe858944cad5b60971a167a5fe1d13a0','019d9e8b63e08b4c11a51e2a216f7ec000bdf175',81,'mod_scorm','content',0,'/story_content/slides/','5vW4CxSOolL.swf',NULL,3559,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2860,'13de2be742da720601e1c964f10f9aa398f355e7','05630632d43e067973eacb433ccef99a567cabef',81,'mod_scorm','content',0,'/mobile/slides/','5vW4CxSOolL.gz',NULL,3269,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2861,'388b5e1a1ae1f4f0a82cebcdebc7deb4c6040bdd','08a3a532be0ca81a9d5174df61c0a19d2f2377b6',81,'mod_scorm','content',0,'/mobile/slides/','6oX0ixdhAlp.js',NULL,15848,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2862,'59d8b9f446d218f263de2004b0c13b3be5824a75','ae474a9c43c3f9424843ce215ea5381ea60cec36',81,'mod_scorm','content',0,'/story_content/slides/','66qlaLq8XQD.swf',NULL,3551,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2863,'bd539a1b532aa86a10d45a4c500f236be04c3ccd','4f4c0d0cac63b58342b8a65025206fcd32e8cba3',81,'mod_scorm','content',0,'/mobile/slides/','66qlaLq8XQD.gz',NULL,3260,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2864,'1b9e24745b3446436cf68343b0a6d2e5327753e9','0b3851af5b95e42c900731af525b42f59bc26c36',81,'mod_scorm','content',0,'/mobile/slides/','675YVtFBnrb.js',NULL,15876,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2865,'2f48d1dce3a9d4f37b60b5adcf7c4a5fe535f4fb','9e505e94a5be4a22cf1ddfac51f9ae5231648dfa',81,'mod_scorm','content',0,'/mobile/slides/','5vW4CxSOolL.js',NULL,15865,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2866,'4c74d7c99d21699e411f0eef3238b3f02fa77666','8b8efcf83c6b6f8b0ba0641b405407bbfb065b21',81,'mod_scorm','content',0,'/mobile/slides/','61W5Rj3eDkY.js',NULL,15872,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2867,'92158318256553a61e1f530702c0f8daefc3546a','f78bf397e5cc521f5c5e71687a789fa766a22645',81,'mod_scorm','content',0,'/mobile/slides/','6Xty7BlUqOt.js',NULL,15858,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2868,'a86f80609ad13331460757c585b2b85a66c5bc0e','365c41425375ebc09b0e3085eee79550cda9ee17',81,'mod_scorm','content',0,'/story_content/slides/','63NeBt87C9D.swf',NULL,3559,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2869,'f97b48ce89dfec0adc26c51204d31d5de1b681d4','50e89538b3fb96b104f8f7b84266d7a8673bc87a',81,'mod_scorm','content',0,'/story_content/slides/','69MWbVVxZdD.swf',NULL,3559,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2870,'d9fb64e52ad094bf10727c26a6d38f3c63bcacbd','f49ef7e6e66bfc76b6a82f91b1adfae56b69a96b',81,'mod_scorm','content',0,'/mobile/slides/','63NeBt87C9D.gz',NULL,3268,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2871,'ca55da22ed594d3cd942a7158456af58c219aeaf','8e38825478c84d234b751f87ab364bae7436bee4',81,'mod_scorm','content',0,'/story_content/slides/','5npRh4cXoe4.swf',NULL,3557,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2872,'b12d046a52f8729d66fa11d3d57606ab9d1754e6','51367350c21032a5c4778797533b0c4e57ad1bcb',81,'mod_scorm','content',0,'/mobile/slides/','69MWbVVxZdD.gz',NULL,3267,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2873,'3263ee2835ef4d8316302ea17e6628c2ea160cef','dc25952b6de6417510bd380d580facbabe18ea3c',81,'mod_scorm','content',0,'/mobile/slides/','5npRh4cXoe4.gz',NULL,3269,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2874,'fc05797d07c868708091d59ecd001510f6f2aad0','702643e5afd1f58e829a370618c83478906e7481',81,'mod_scorm','content',0,'/story_content/slides/','6LZMmpdVUr8.swf',NULL,3566,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2875,'ef7cfb9bafa4e41ac78b43caf9c120a0ab3ff497','c3860bf3767d5855a796aee88ae08f37d0f6a7b0',81,'mod_scorm','content',0,'/mobile/slides/','6LZMmpdVUr8.gz',NULL,3275,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2876,'89d1f16d9f47c4da1b10210c072d474ad1196b14','ecd44c16cf71e1bbf31512de93373c9a8ebb62b9',81,'mod_scorm','content',0,'/mobile/slides/','66qlaLq8XQD.js',NULL,15849,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2877,'7f95acd0594addecd45a0c806a2b9a71d2efa20a','cf5f26478bc63017dc83eccac489629edb3cac7d',81,'mod_scorm','content',0,'/story_content/slides/','6iDuTIr0Pht.swf',NULL,3547,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2878,'2f737dc5221145de436db93745bf8a1d1b7c4f5f','42aae9f1fac0bce936aef7a2e41a686b30f6b998',81,'mod_scorm','content',0,'/mobile/slides/','6iDuTIr0Pht.gz',NULL,3256,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2879,'f511897952dcb3c3f9b308ebb656c78c0b9b3a75','612956f61fbeeb5ca719891a78fa941723f22e11',81,'mod_scorm','content',0,'/mobile/slides/','63NeBt87C9D.js',NULL,15861,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2880,'46e429d1970793ff82a3fa7146b3ef3b60f83067','977c81841836b6bf0a12a0f16704fbf210b71bc3',81,'mod_scorm','content',0,'/mobile/slides/','5npRh4cXoe4.js',NULL,15877,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2881,'46d04969928b65591a1718b2876b801b7b8dc531','2db24ceda19e25fce114c95e683f2be5c6eb404a',81,'mod_scorm','content',0,'/story_content/slides/','5ZMUIA9Ds2W.swf',NULL,3570,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2882,'74c6f8012a7ccbaf8600535c75cf52e8e0e514b3','f45ffe2884247e65f810d2fb64f0789e02b8ffee',81,'mod_scorm','content',0,'/mobile/slides/','5ZMUIA9Ds2W.gz',NULL,3277,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2883,'e26213288e00864830f68858fb16434f5e5e53fe','0e6dd0770bdb992c2a009d2ce83baa67daa1aa7a',81,'mod_scorm','content',0,'/mobile/slides/','6LZMmpdVUr8.js',NULL,15875,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2884,'69f4fea25bf05792634c5ea21081d14f696e20cb','cc9ac72f6173d2bb2bf47ce50b8638c5957445d7',81,'mod_scorm','content',0,'/story_content/slides/','6PHHfbypZTj.swf',NULL,3555,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2885,'377323be2f11e5e38d56d3cddf73523916598704','1b3b754a248b6712b55a760e5c72d4457eab2108',81,'mod_scorm','content',0,'/mobile/slides/','6PHHfbypZTj.gz',NULL,3265,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2886,'81711b0fb496d32d591f480e5a7f88e51f79d833','b28281c130a49a27d9e90b8dc7952925b3a20efb',81,'mod_scorm','content',0,'/story_content/slides/','5vMKOrA5AAN.swf',NULL,3558,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2887,'2bb82ac2e30c51a32e8af0567c7dde04c0b6dfe2','da76d47f0196fe43d53f4d4f18d37fc5f019b289',81,'mod_scorm','content',0,'/mobile/slides/','5vMKOrA5AAN.gz',NULL,3266,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2888,'5ac01f0ff522504aea615fcd791e19767e37d04b','4da597eed8006e187e14227184d8cfe430b2ba9d',81,'mod_scorm','content',0,'/mobile/slides/','69MWbVVxZdD.js',NULL,15868,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2889,'1249a645a91dfd18dbd9e9f51b487c9b018bf766','e84e0249f838757dfddc0287f139b90993f0810d',81,'mod_scorm','content',0,'/story_content/slides/','6Xhb88IoCPE.swf',NULL,3543,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2890,'7e4e50ba6cea48ce1954dde6a3f2d3f0b2447a13','54b262f7d9b4f12ed92ea343c86499add16ed46d',81,'mod_scorm','content',0,'/mobile/slides/','6Xhb88IoCPE.gz',NULL,3253,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2891,'b4d6a6139041bf7e499430a831b076df388c87f0','3d1e8d198ab93d0c303e3dd1a16b1d65af5a8ddf',81,'mod_scorm','content',0,'/mobile/slides/','6PHHfbypZTj.js',NULL,15862,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2892,'b7a0be8631ff0aceb9c64c5aa7f1dd311641dfd1','834e25c2028e29096bacd60dcae985ad19f3997c',81,'mod_scorm','content',0,'/mobile/slides/','6iDuTIr0Pht.js',NULL,15849,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2893,'57804ee55ee3bdfb5f0c977834003f198fbdc69c','924052511daf99e8dd9419be59ba8c3a4a6f5233',81,'mod_scorm','content',0,'/mobile/slides/','5ZMUIA9Ds2W.js',NULL,15892,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2894,'6d59a20ec0bd00aec7564beb15c3439d1ec01134','e8088b467f384c66bd8d80dbc9c3a8f4e9917401',81,'mod_scorm','content',0,'/mobile/slides/','5vMKOrA5AAN.js',NULL,15868,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2895,'0d43019e5bbfe3e2fcfa292ffd08b856a53c0af3','9dc9369873ceab6789fe7560e26938af3fe00170',81,'mod_scorm','content',0,'/story_content/slides/','69Z1kHTfUQN.swf',NULL,3577,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2896,'7e9f1dcec4200246ad8b6012ab0928c6ac619be3','70a479cffb28e3295ab056ae70dc6f6330356e6a',81,'mod_scorm','content',0,'/story_content/slides/','6TlX4r1uaUU.swf',NULL,3554,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2897,'6ec71dab06afb8a72f586155882ff994d133bc77','bbac5109f6f20a97928bf7d73b0d5dd3df7fcfb9',81,'mod_scorm','content',0,'/mobile/slides/','6TlX4r1uaUU.gz',NULL,3263,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2898,'402e6b551645d28c0163263dc0272d21b20beacc','2063194f764a2b48f83f8c16ca7e11f90bb79418',81,'mod_scorm','content',0,'/story_content/slides/','6lZrj6BXasx.swf',NULL,3564,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2899,'79d5069eb45f17279a9162d96ea6b97cd5d87f61','135e314fca431908a821176f45773ac816545698',81,'mod_scorm','content',0,'/mobile/slides/','69Z1kHTfUQN.gz',NULL,3286,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2900,'89f440eededc1403380545cb6e876ff6cd4286de','9e01b44a0da712d1c36e52866201444fac0a38bd',81,'mod_scorm','content',0,'/story_content/slides/','5iPmwhMqDcd.swf',NULL,3547,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2901,'c5f88587b331c11796a4130ab03e8686ed02943a','f667c3122f734f034eb209a05723150a3133be0a',81,'mod_scorm','content',0,'/mobile/slides/','6lZrj6BXasx.gz',NULL,3274,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2902,'1d32f9bb03ce37361228f0128ceeb15bb63938ff','ae08b86144bc0ba81ef0c3e02c4b52a50961d955',81,'mod_scorm','content',0,'/mobile/slides/','5iPmwhMqDcd.gz',NULL,3258,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2903,'d82cca509c7ffb19b33c3beef2def81f8d648447','da4f3035aac61484a41daadfbedcca2cd0feadf3',81,'mod_scorm','content',0,'/mobile/slides/','69Z1kHTfUQN.js',NULL,15888,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2904,'44e62cb9a9a5619dbac2acec93f3b4a1787e0ba6','3e665552da0cd2d4f39983de84d3388df97e7bcf',81,'mod_scorm','content',0,'/mobile/slides/','6lZrj6BXasx.js',NULL,15867,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2905,'371cf634e945cae4920fb1a74b7b3454e17a5c79','d4e6260e4f26cabda7bbcd45603916e50bb20a4c',81,'mod_scorm','content',0,'/mobile/slides/','6Xhb88IoCPE.js',NULL,15846,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2906,'87064f484a1e1d7724f92718bcd25b3d3a14b763','48151627385150c9a03e0e2c17181c813210d037',81,'mod_scorm','content',0,'/story_content/slides/','6EDRuVAuysb.swf',NULL,3544,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2907,'c9be73ea54fa03450847b30748c903a3b20de551','60de29dc5e658eca4ccae2441d5a072a60c0d686',81,'mod_scorm','content',0,'/mobile/slides/','6TlX4r1uaUU.js',NULL,15859,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2908,'34c6bf971fd1fc8f06540b8964bf1cf62cca0337','114b0070e6eed6d818f3a9f584247f54c1dba870',81,'mod_scorm','content',0,'/mobile/slides/','6EDRuVAuysb.gz',NULL,3256,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2909,'fce970ca772388ea27194136f7162509d11a4dcf','c71e7bba91f7379c6f9758e554f929ac4ec286df',81,'mod_scorm','content',0,'/mobile/slides/','5iPmwhMqDcd.js',NULL,15846,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2910,'5344ca6d0e712a2fd699889b2c54cdd95761d686','5e5a862a7766d92d9eb9d061820da071d6f1585a',81,'mod_scorm','content',0,'/story_content/slides/','6i51Ooi4vPm.swf',NULL,3542,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2911,'0d02cc74fdef0870a4e8d8d748a8fe8d1f00e5a8','5815b3213ed98f6479b6674447ea7ab09bde3d16',81,'mod_scorm','content',0,'/mobile/slides/','6i51Ooi4vPm.gz',NULL,3254,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2912,'e66b0713f095f9d5ce54181a2f9fef563a69bcd3','55a07d0857c70ea807953d26c91a7deb03f047aa',81,'mod_scorm','content',0,'/story_content/slides/','5ss3E33NfGu.swf',NULL,3564,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2913,'e12a8407755d31e7a527e413a7e5a9a7c1f8f0ce','683e6770c01644577ef0b5f614c56413bb76c044',81,'mod_scorm','content',0,'/mobile/slides/','5ss3E33NfGu.gz',NULL,3274,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2914,'44c74f441efea7fd4677a208d5020db0520ea99e','7346ba42c3694643dab927d99e87d9b31eab72e0',81,'mod_scorm','content',0,'/story_content/slides/','642AVGnx1dn.swf',NULL,3553,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2915,'7a8576216b30f33f07d7cdd4ee68b3f02ef01933','0a6c3e4f18edde36b760a12747a8dc1088e17e7f',81,'mod_scorm','content',0,'/mobile/slides/','642AVGnx1dn.gz',NULL,3263,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2916,'95d6d9169f4c36b1642cb2d158ff9197cff7bc84','632888469dabb72bf93253e03a5caab05bdd0d70',81,'mod_scorm','content',0,'/mobile/slides/','6EDRuVAuysb.js',NULL,15842,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2917,'9995b1edd454bb21195beee7dbac5279a7aab542','c9515d90b3df49df9c35a1fd9efad1abeabc22c8',81,'mod_scorm','content',0,'/mobile/slides/','5ss3E33NfGu.js',NULL,15867,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2918,'dc4a3209708dcf53e5f387b49433b3379eb1b6cc','3c807eb68581d0f206a658a21d52b74263237c89',81,'mod_scorm','content',0,'/story_content/slides/','6r88eGdYbQ2.swf',NULL,3570,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2919,'e370e78ec84f655c5ff90b3189895443e1ff2d42','4205d6de839f86bd7548820d03a7aaef05f9ca54',81,'mod_scorm','content',0,'/mobile/slides/','6i51Ooi4vPm.js',NULL,15840,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2920,'ce7bcfc6b582c6ef6cb6fc9341513b531910f916','48a32ccbfc6d98d88889ad40bdeb989345bde71e',81,'mod_scorm','content',0,'/mobile/slides/','642AVGnx1dn.js',NULL,15851,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2921,'52553063387a1244ac5e905326c016db4ce8f203','90c389ffdacc3258a738760f0615c171a447a051',81,'mod_scorm','content',0,'/mobile/slides/','6r88eGdYbQ2.gz',NULL,3279,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2922,'db441015c94e5ff39f4dce302081ebe4110270bb','bf43454dd25c81a810c6e8c18d9a86ce0c8d5cdc',81,'mod_scorm','content',0,'/story_content/slides/','6nbt2a8bPH1.swf',NULL,3543,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2923,'55403a8180ee703a32a3719d329b4cb729b393cd','c8a32add27c14e33eff48aa99637b9429285923d',81,'mod_scorm','content',0,'/story_content/slides/','6bs3sc2LBe2.swf',NULL,3549,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2924,'272cb9d0c4f294e7e6c7702ec1a3fa5bba570210','13ff0358a8d604621ccc3a088e6a880fef9baa69',81,'mod_scorm','content',0,'/mobile/slides/','6nbt2a8bPH1.gz',NULL,3254,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2925,'803d88a44e2a50c9feb8045f52e227dbcb026fd5','5cdd50ebbe4ea24e944c43bc69f10461c7a2527f',81,'mod_scorm','content',0,'/story_content/slides/','6aN0rx3P6b2.swf',NULL,3549,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2926,'f66ff92afe06dc8ba44efe97d89a5e3f34d7650f','480d1156eb42d6ad2b11aa856dfcc54562165290',81,'mod_scorm','content',0,'/mobile/slides/','6aN0rx3P6b2.gz',NULL,3260,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2927,'3a0ac85e963f0b619fd6c28c06345d2ae4540b3a','c82b876ffc75473f1aa0dc8c4aa4cac1a4614927',81,'mod_scorm','content',0,'/mobile/slides/','6bs3sc2LBe2.gz',NULL,3259,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2928,'6614e1a217690e1e6231443cc2974d35c3836ab6','24cc3dfecfae65f338bdbc7ebbe51af70c8f561a',81,'mod_scorm','content',0,'/story_content/slides/','5ZVFQo6ges3.swf',NULL,3550,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2929,'4ce111284b42e771cae2f7d8691a9842aa8940c3','8166ddb38f6c118c96ba292149698891c8a18814',81,'mod_scorm','content',0,'/mobile/slides/','5ZVFQo6ges3.gz',NULL,3258,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2930,'40a6f07b9f5553dbb6bc82ac471af33683e3f267','978155efd184c0395aba1f32e6dca405edebe590',81,'mod_scorm','content',0,'/mobile/slides/','6r88eGdYbQ2.js',NULL,15881,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2931,'5c6afe0b7f41da180f81f3104a0f18f419e9bc37','6bc202f315f8fcabd7da26736bf0f6b5dbe5a620',81,'mod_scorm','content',0,'/story_content/slides/','6IfPrCyngh1.swf',NULL,3561,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2932,'2c9dfd6f3bfa648712ef4afb457bdb12195000b4','9c90ccbc7a001ab3ecc1979184e78dbacd24fd2e',81,'mod_scorm','content',0,'/mobile/slides/','6IfPrCyngh1.gz',NULL,3270,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2933,'d6f3a538c545b73cf64048b0c6ab772c0997f750','70d51bd3f35595f06a87885a6f24b7987eb85e82',81,'mod_scorm','content',0,'/mobile/slides/','5ZVFQo6ges3.js',NULL,15856,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2934,'1c6bd475c8b7dd511ba108b83f29761397deef8e','84408660e76079e1af7337361f45b370824f6166',81,'mod_scorm','content',0,'/story_content/slides/','6dZoxe5Q542.swf',NULL,3553,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2935,'a1fe0c99a554e0016b02bd82d940ac624f2f1d72','9ac39a684cdfcc7f7859a1a4e97e1787c0040489',81,'mod_scorm','content',0,'/mobile/slides/','6dZoxe5Q542.gz',NULL,3263,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2936,'9956af40283d13e7c970530cf98803367eb52ef8','8a18688ccc80a5a5ec550f38651e17f964e4b62f',81,'mod_scorm','content',0,'/mobile/slides/','6IfPrCyngh1.js',NULL,15868,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2937,'bae54691b532bea633b7ddd6fc1290a8108ad871','4166171a8e749760a54419c072baf17ec61bab32',81,'mod_scorm','content',0,'/mobile/slides/','6bs3sc2LBe2.js',NULL,15845,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2938,'18b7cbe8f240ec97af2fefcda62fffcb3818a513','71a30eccea86113d1779bfadc58b6e009df9e669',81,'mod_scorm','content',0,'/mobile/slides/','6nbt2a8bPH1.js',NULL,15844,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2939,'d3e52d0c81d40c1ba37e5c7f3906e10da21fb713','4eccbd9306ffd7ee5e8713d1540c6e7f1b91a766',81,'mod_scorm','content',0,'/mobile/slides/','6aN0rx3P6b2.js',NULL,15846,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2940,'bd4569e7d1097b62c818e0fca41ac0f916584ea7','3b88abb4b005163ee29727d0e152f1e0f0c631ba',81,'mod_scorm','content',0,'/story_content/slides/','6MTOTX6ii0p.swf',NULL,3562,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2941,'9d8f728d267466f63407ef04ba070b9902115ee5','779c93bda120574e7b321cff9c2bafbf742f1253',81,'mod_scorm','content',0,'/story_content/slides/','695xzodBE0P.swf',NULL,3565,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2942,'84e3290655bdfa0a92a831ceb2915024bade5640','9d75158190b88fe8959441310ad22b1bd1bbc613',81,'mod_scorm','content',0,'/story_content/slides/','6feN75zhEQ1.swf',NULL,3551,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2943,'2d35ef748fd583545688fa0f2f4ee38327e5e099','6a314746de1b24d111a1530721839145ce271c46',81,'mod_scorm','content',0,'/mobile/slides/','6MTOTX6ii0p.gz',NULL,3271,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2944,'2aeeacb7a7f42bcd66f2d1614186e7520a6992f0','fe7df64c5ec1bb8f0aef1aa1c032be118e124e00',81,'mod_scorm','content',0,'/mobile/slides/','6feN75zhEQ1.gz',NULL,3261,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2945,'0b3c3e0b50ea31df656cf0f55cf65e47a5b2f5a1','df899c32b240e075ade7807abafe1bc573b06c6f',81,'mod_scorm','content',0,'/story_content/slides/','5stP9FyCx05.swf',NULL,3540,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2946,'a6e4aeaf2c763932d7bc48ef79d970e5a4ec2dc5','8c2805ee4a4d06777a27df57b0a59e0284bb8384',81,'mod_scorm','content',0,'/mobile/slides/','695xzodBE0P.gz',NULL,3274,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2947,'9b62afc031f059629716cdeeed7fa6d18decd1d1','b4645d7eb596e5318655271487ea52cf8fe67827',81,'mod_scorm','content',0,'/mobile/slides/','5stP9FyCx05.gz',NULL,3252,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2948,'e38e97b44fa6ebd7cdda6227f16d89e09c671db0','6194a2a578157e6a806376451606e2f9891e7c6f',81,'mod_scorm','content',0,'/mobile/slides/','6feN75zhEQ1.js',NULL,15848,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2949,'34d9e435b8fe1eec9c70254a080009f0a96e7011','00b8fa0f5669783f6d62de94cbe5a70647fbcbf8',81,'mod_scorm','content',0,'/mobile/slides/','6MTOTX6ii0p.js',NULL,15868,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2950,'5cb1aefc602e11b1361ae125722ef436330e5c17','fc9e3faa505530a02d46739af17b567aa079a80e',81,'mod_scorm','content',0,'/mobile/slides/','695xzodBE0P.js',NULL,15884,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2951,'e6dcb510440b943a41067c5d665e866c373d549e','0735fed4a70ad9e08b70f0a43e4b984f17f33edb',81,'mod_scorm','content',0,'/mobile/slides/','6dZoxe5Q542.js',NULL,15857,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2952,'24bad2a808a9c1d9a5ad5f62867dc0330d021702','d850923b0a8cc8cb54c30c762bcc55e1b03bfdd5',81,'mod_scorm','content',0,'/mobile/slides/','5stP9FyCx05.js',NULL,15846,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2953,'e98bfb14fd8bbbb4824f45b5bb273195c67f4e72','fa400e8eec254be91e97213938521deeb06b84c2',81,'mod_scorm','content',0,'/story_content/slides/','6QhgRxqk7s9.swf',NULL,3539,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2954,'f6e959f29fe91f9fe7ba5a7cd22efa30577f5486','668d9d58201b1ee7b931116e6fb8911588cd61e3',81,'mod_scorm','content',0,'/story_content/slides/','5tZwgMpTj05.swf',NULL,3555,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2955,'90148a09eeb021587934488ce87308fd275e2901','a8e230a2146a325665f3c56c1f0655ec67432252',81,'mod_scorm','content',0,'/mobile/slides/','5tZwgMpTj05.gz',NULL,3266,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2956,'194deea447e79605d5affc7a83b3283bb54dd38c','b308c4f30b045c2cf58454a1a15a50d195266be5',81,'mod_scorm','content',0,'/story_content/slides/','5yPhwBZK6Ol.swf',NULL,3550,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2957,'6ba5392ebdf77c2c69fe8d1a0514122784327419','ca92f9f4adeded49a0b7cbc326c298a651b4a4eb',81,'mod_scorm','content',0,'/mobile/slides/','5yPhwBZK6Ol.gz',NULL,3259,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2958,'125467bba4cdda3afa46634e3cda57d5d486587f','ef35f44741459f97787d616accea9040fa863bd7',81,'mod_scorm','content',0,'/story_content/slides/','5YZUwtwAZj3.swf',NULL,3556,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2959,'2e2f1169ed7216692d6ee18d7eeb7f348fd3e6bb','0124e82d36615c452be8c9bc8d46117bb047a8f5',81,'mod_scorm','content',0,'/mobile/slides/','6QhgRxqk7s9.gz',NULL,3253,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2960,'eff012cdbf77aedc98170786d01f2ad1aa5361f6','f15d3bb8b379bd592f996811d10d4ed5a9f4b45a',81,'mod_scorm','content',0,'/mobile/slides/','5YZUwtwAZj3.gz',NULL,3266,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2961,'967bf5456a43115bc9a40bb548be1864422f045e','fac6252668806fd090b973a7d708ea1a258d91e9',81,'mod_scorm','content',0,'/story_content/slides/','66TIcJHmb0j.swf',NULL,3559,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2962,'091f050e5d0b4d46283cb6d9ea655e5ac567b2ef','a0740d8114cf3f40fedbf38b4f3558dced5c437d',81,'mod_scorm','content',0,'/mobile/slides/','66TIcJHmb0j.gz',NULL,3268,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2963,'03f2253d015b209b28e00842972cdd5ce16d8794','a63c323154465a4081a062a0533c45cf7f6c32c7',81,'mod_scorm','content',0,'/story_content/slides/','6NKL3JW7555.swf',NULL,3557,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2964,'5f84ebd5590e0829877916f90c83831863e9369a','e1e935fe1e15f283ba785bcaee10662b878a9b41',81,'mod_scorm','content',0,'/mobile/slides/','6NKL3JW7555.gz',NULL,3266,'application/g-zip',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2965,'bc52fd197e9c11a83e4bc24d2f232b51b110ef0b','4666d322663c9c19b0bbb64e8c25bd1f8ee9852a',81,'mod_scorm','content',0,'/mobile/slides/','6QhgRxqk7s9.js',NULL,15842,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2966,'3f0ac2e7d7f3ddcebba99cbba8728a96448d15d8','4b9e98b56f13253c12779f6078e8250573d5a7e6',81,'mod_scorm','content',0,'/mobile/slides/','5tZwgMpTj05.js',NULL,15866,'application/x-javascript',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2967,'6576a7146db6d7b716ecce9d4ef652e282ef2cfc','6b995ccea39adf02365363452fae9de0742c9175',81,'mod_scorm','content',0,'/story_content/slides/','5VdTjYgsSX5.swf',NULL,3560,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716823,1462716823,0,NULL),(2968,'7490582ae0c2855bc725617b410a22d9eeee86eb','2cf931f94a2d93c1e77a82536cbdb490ce8216e4',81,'mod_scorm','content',0,'/mobile/slides/','5VdTjYgsSX5.gz',NULL,3270,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2969,'13127af8d9b8afc960bf660753293ac5e0baca43','dd0f917c8d2df1aed99f7ad426e3b8442f8c22b1',81,'mod_scorm','content',0,'/story_content/slides/','5ZYyRptmEul.swf',NULL,3552,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2970,'f09c0b3f6e30b975486794c342bf7dbff259df0b','e0b39d5934c999686411d895595911c493dffaf6',81,'mod_scorm','content',0,'/mobile/slides/','5ZYyRptmEul.gz',NULL,3262,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2971,'793335d67566e7e3ab655d380ff64e336e0030cd','2f084844e0ba0d197118a710513916333050f2b3',81,'mod_scorm','content',0,'/mobile/slides/','5yPhwBZK6Ol.js',NULL,15858,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2972,'b04fe28374969a6b2d404884916cf85d726b6556','d299296a7cc135e11673716a1231aa4282b3cfb7',81,'mod_scorm','content',0,'/mobile/slides/','5YZUwtwAZj3.js',NULL,15863,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2973,'ab90df9c52510f2fac860596539449ed568025f4','ec67c02b635e58d639ff2b516851d0a6cf65d2b0',81,'mod_scorm','content',0,'/mobile/slides/','6NKL3JW7555.js',NULL,15864,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2974,'827f6d1742bb2083c74bb5571d0bf8229617f8af','ec272e2bcced11c8e8073aa86bc3d1bca950aded',81,'mod_scorm','content',0,'/mobile/slides/','66TIcJHmb0j.js',NULL,15865,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2975,'a4f3e91b9d847445f300f0839266e8015292415f','80d012afd12a606957c07e02cb837910aae3a326',81,'mod_scorm','content',0,'/story_content/slides/','6HrGMpPlu9B.swf',NULL,3541,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2976,'2669bccd788ea36aaecd65369998d3ae70ee4be4','823fdd886fcfedd7e9e67e1021867e94d821ad26',81,'mod_scorm','content',0,'/story_content/slides/','5btn2iyq0YV.swf',NULL,3550,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2977,'1d9e332d8211f963b64d4c66072ced114730692e','9c73e55b9093f5cdda9fac56aaf4cd990e62a8c2',81,'mod_scorm','content',0,'/mobile/slides/','6HrGMpPlu9B.gz',NULL,3253,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2978,'e2fa27dbe1be2cf3d305d4f30e14464184681ce3','9a908f3a102e37cee5aef85dc1c6a0f16a97410e',81,'mod_scorm','content',0,'/mobile/slides/','5btn2iyq0YV.gz',NULL,3261,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2979,'f4ba20fd200f1572cad7a74ef2935e2a68a2d2d7','393a9859b0b424c9980b768d3f5d12c05a9c308a',81,'mod_scorm','content',0,'/mobile/slides/','5ZYyRptmEul.js',NULL,15861,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2980,'bd768a22a65e286e8a09b2e73f01b79ddd54740d','77bf41f869d28deca79d752e9c9d5260b38826ed',81,'mod_scorm','content',0,'/story_content/slides/','62NjyxYnwL1.swf',NULL,3557,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2981,'ae01382c6985b50f58baf911825829adacffb3a3','84deaa33039ed0762435fc476a9ea4247898f374',81,'mod_scorm','content',0,'/mobile/slides/','62NjyxYnwL1.gz',NULL,3268,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2982,'fc28d91aa177544dbc68ffe37f460a40b8714ffe','f35ac5c84ebba370e2b880a9ba8f78fb74cf0d90',81,'mod_scorm','content',0,'/story_content/slides/','6pUjCeWeFt1.swf',NULL,3558,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2983,'8abedc0d35455e3ae516671e84e511a6b337e346','fdc549f33682e1d98269abbac903eebea50cc27a',81,'mod_scorm','content',0,'/story_content/slides/','6qKIschu85c.swf',NULL,3544,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2984,'2a7b794d5a5b2c671840e0910a9eef698a3f54db','8d367adf461cfa078b835aefe5bdcc1d8c75fb02',81,'mod_scorm','content',0,'/mobile/slides/','6qKIschu85c.gz',NULL,3254,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2985,'5401dbb26b859c54027e666d94e761be0ab6e340','188e6b41398633d60f18a8fe79f593bd1c316729',81,'mod_scorm','content',0,'/mobile/slides/','6pUjCeWeFt1.gz',NULL,3268,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2986,'b12a764c04c5554f3e8a52106c3a66c07c7eeb6e','d80c2f4f7e9d20f55615693b1c9424bd767fb9d5',81,'mod_scorm','content',0,'/mobile/slides/','5VdTjYgsSX5.js',NULL,15864,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2987,'f08f617e3def0ffdaa32348593948c42c7fb8090','f66b9435a437b4c44b401f2b296305e6125072a2',81,'mod_scorm','content',0,'/mobile/slides/','6HrGMpPlu9B.js',NULL,15846,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2988,'3cbada52101b4c3e8e041e00b4b8c23093e846c0','b3beb5e62ab57ad568dae8521d3b0304ed394464',81,'mod_scorm','content',0,'/mobile/slides/','5btn2iyq0YV.js',NULL,15853,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2989,'b8623c3e8700677e45ff4e2bcb1fa48c845c0367','9256b546e038ef88b4364ed0093d5620adb5d345',81,'mod_scorm','content',0,'/mobile/slides/','62NjyxYnwL1.js',NULL,15866,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2990,'e87632b40772c1a04b795ac80aa6e181584e5f74','2b02676fd2f16d07a9a4f93ae6380e7933ca9407',81,'mod_scorm','content',0,'/story_content/slides/','5hZ7LSkF6ZM.swf',NULL,3552,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2991,'a8a5d219ca50adf898b101a7407ff7240c20e036','eeb23c5151f4b05f769757d628e62dde0259f3f5',81,'mod_scorm','content',0,'/story_content/slides/','5XvO8LCcSWC.swf',NULL,3545,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2992,'6f3345075e5f0edcb15569d0ec872b7f85cdf33b','a7484f270fbf8cef5d555928c4fe24ab439a31e9',81,'mod_scorm','content',0,'/mobile/slides/','5hZ7LSkF6ZM.gz',NULL,3262,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2993,'c39eec680226a3a8f0a2ebd0414fded2c2123bd9','5b0201ff3248c6ccc907d0b72d3c5f1be6ef4be8',81,'mod_scorm','content',0,'/mobile/slides/','5XvO8LCcSWC.gz',NULL,3255,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2994,'c9ac3ce72fbe7b6547b3176c9087634abe66c21a','a5f809e9c4d6c64488ca9af82cdecf474a73dca1',81,'mod_scorm','content',0,'/story_content/slides/','6mMjhBSa79c.swf',NULL,3557,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2995,'5e3e7c099b98af4ed5ed0934a3d0e30565a0a7de','57b69fadc8641fe6440661f10ee61a6747b70322',81,'mod_scorm','content',0,'/mobile/slides/','6qKIschu85c.js',NULL,15843,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2996,'589b78a329c9e9810bcc8a41dfc0b1344729646e','d19848fe1a95dd3e2e17c40b0848a787738cb7fc',81,'mod_scorm','content',0,'/mobile/slides/','6mMjhBSa79c.gz',NULL,3268,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2997,'6a2aa82c31f3be88c1c01a29e22559a4bee018fe','6c0ec20df09b37524e8cfb5aceefd99cde0b5fda',81,'mod_scorm','content',0,'/story_content/slides/','6hRGQvmyIUx.swf',NULL,3552,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2998,'019e54545d427874da5f609bf8aa6e0579f55e55','dab9a30620b5e2a2e23b47f5c8200455c23ba00a',81,'mod_scorm','content',0,'/mobile/slides/','6hRGQvmyIUx.gz',NULL,3265,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(2999,'4d0cede920905c3294075b3df5f5f55e1dd2043e','0f6d518e38b4fa6293004e98704760ec13044bd7',81,'mod_scorm','content',0,'/story_content/slides/','66dplibcvcw.swf',NULL,3557,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3000,'23d35d205273563449380f4a585ee20a633b16e2','2e3f655df98c73918ac4ef84a2fc52ca9bfec876',81,'mod_scorm','content',0,'/mobile/slides/','6pUjCeWeFt1.js',NULL,15872,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3001,'92c7bc18b9bfbbfa715acb60fd0711ad85e91076','0e0970fce20bb6e51cdd47b7749f39ed41f0c115',81,'mod_scorm','content',0,'/mobile/slides/','66dplibcvcw.gz',NULL,3267,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3002,'5cdab3b4758a3da834420df2234b26744f813831','bfdeef641a39eab01b95fe4df7089f327b97ea9e',81,'mod_scorm','content',0,'/story_content/slides/','6JsYOHSZLJQ.swf',NULL,3561,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3003,'c1b7d385035bc7074a398b3a21debda1e5456afb','28fa8234a27af199087fc2c3d13af0306792a0f8',81,'mod_scorm','content',0,'/story_content/slides/','6GRKxOUZHnp.swf',NULL,3567,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3004,'797cf58f438aeca0695ea3a89c5457dde5e4cc9f','3bbc2a88de815afaffb5a5e93c4f75c73842b107',81,'mod_scorm','content',0,'/mobile/slides/','6GRKxOUZHnp.gz',NULL,3275,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3005,'1602d5e4ac461ceb1cbb44d5c8e6ca4e238a4166','64673f8f79d19a985f3b95aa074be0020bc528cd',81,'mod_scorm','content',0,'/mobile/slides/','6JsYOHSZLJQ.gz',NULL,3271,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3006,'6c41d0bc0d0b46af1d0fa872893366913637b404','d94521369aae23a4f1c971bd0db88ce5f6bde937',81,'mod_scorm','content',0,'/mobile/slides/','5hZ7LSkF6ZM.js',NULL,15848,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3007,'a3a11a8fc8caf7d07a6d1e3056dc2ee55c7be895','1a2849e7b0c4b6fb744ff09595e96e81f16cdd61',81,'mod_scorm','content',0,'/mobile/slides/','5XvO8LCcSWC.js',NULL,15845,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3008,'e0a54bff232b7ef0182ee5207c0bdbd41883cf63','1a9ea9eba55d650765d4151478468ee0b191715b',81,'mod_scorm','content',0,'/story_content/slides/','6fyTDQxZ0oC.swf',NULL,3561,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3009,'44ddb2a63381426c0bea65e631cf696e994c6b99','125ba1fd855c40dcf37f2ae2280d4eea68eeca02',81,'mod_scorm','content',0,'/mobile/slides/','6fyTDQxZ0oC.gz',NULL,3269,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3010,'fc24efb470897f965ecf3caea08610f038507880','f38114d052108174939a0b4e43b88ffe8d91aca6',81,'mod_scorm','content',0,'/story_content/slides/','5yHPWhKts1S.swf',NULL,3543,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3011,'11e0df571c26f95d37b52e5fc4e43ce20942709c','3d32d9a598f1a5fae5fab96c6c412a888c780fb4',81,'mod_scorm','content',0,'/mobile/slides/','5yHPWhKts1S.gz',NULL,3256,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3012,'9c5b87621232c0bde639d663c8a0d3363f1067f4','381d8202a23e4f90d4591ece11ac24c7dc21c3ab',81,'mod_scorm','content',0,'/mobile/slides/','6hRGQvmyIUx.js',NULL,15861,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3013,'b9272c96a2bde39819ba14b652bc7962151df29b','679e96e4a7ef18160929665478781a706710f8cb',81,'mod_scorm','content',0,'/mobile/slides/','6GRKxOUZHnp.js',NULL,15868,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3014,'1ec5b1f20c8ab6803ac57ac938d719acee225c8d','26ad2ddc050f55a606043ea884f57a23336384a4',81,'mod_scorm','content',0,'/story_content/slides/','68HpRTfxW4m.swf',NULL,3553,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3015,'6feb5fff583963a34184b7137b87cc309250af30','d2d1ee32f798ead2a1c1ea2dcf28ed86c4b69724',81,'mod_scorm','content',0,'/mobile/slides/','6mMjhBSa79c.js',NULL,15870,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3016,'71d66cee557ab830e4fe66bfeb81bcf3f081fc17','96d0b81fd7559792289418acf915460b9c5fd042',81,'mod_scorm','content',0,'/story_content/slides/','6mXbRGfIV7q.swf',NULL,3554,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3017,'b0d3d4ce6d35c46b4685499e2b8ed56e5ba17a47','a892c64299da2312345f8c44f69e4923e621e07b',81,'mod_scorm','content',0,'/mobile/slides/','6mXbRGfIV7q.gz',NULL,3263,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3018,'077c5a5644be8a4242e89b33d2d44f9b22dccd54','54d7b2c0d4e034dd2865f133eff79c44699c6b53',81,'mod_scorm','content',0,'/mobile/slides/','68HpRTfxW4m.gz',NULL,3262,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3019,'cf2f6cd6aa08b78c34721ad360e063e5c5e11cb7','350c3e17fea35a10a9eb7dec05fd2bd7cbcf2b42',81,'mod_scorm','content',0,'/mobile/slides/','6JsYOHSZLJQ.js',NULL,15862,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3020,'3595231c5efa34c5791fe9f1ec97606450771e6e','416619bed7b596ae2b2e7c9240bde32c8af3b48e',81,'mod_scorm','content',0,'/mobile/slides/','66dplibcvcw.js',NULL,15868,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3021,'7f438dfe353375dd7fc1d57febaa22d8ae06a0ac','7679cf6c3d6677de845533db77e6a5f60ba8adf7',81,'mod_scorm','content',0,'/story_content/slides/','6b8sPOLFyKm.swf',NULL,3567,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3022,'34de122ba82c3bc500964a936d3cd3fe5c0bbc7f','c5f8675e0b665e1e1025acedfb523764b25dd579',81,'mod_scorm','content',0,'/mobile/slides/','6b8sPOLFyKm.gz',NULL,3275,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3023,'8fd1bf14c9b589d8a60d99fa535fb768072d019b','966d3a7a7097b3d58b3e8afb4b898845e1f5a90c',81,'mod_scorm','content',0,'/story_content/slides/','5n9egdmyR2t.swf',NULL,3556,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3024,'3fbdceb8782100f21dcd3109c6d847395780d11a','893b644f6f4b72a1d7c1bac82ec76c5580e3fbb0',81,'mod_scorm','content',0,'/story_content/slides/','5YZsobjqpXR.swf',NULL,3558,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3025,'798af4a6e18029bda48ae60bc8b340b5eacf77c9','c18545f5a3e93f364db4bee376e9ecb9164eb36b',81,'mod_scorm','content',0,'/mobile/slides/','5YZsobjqpXR.gz',NULL,3267,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3026,'a2b4dde22a1158f4f1ffadeb0aa679d8bb439ce2','69c2fc4d9b0400403fa657d95619f6ead1a759f4',81,'mod_scorm','content',0,'/mobile/slides/','5n9egdmyR2t.gz',NULL,3267,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3027,'a3c6514c7c9cdfba6799841770c57f43ad8127c2','d69125e06f053f0769ea7e2b8c9fed098d05de4b',81,'mod_scorm','content',0,'/story_content/slides/','655PcIIcLg6.swf',NULL,3543,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3028,'166581268efd5cf5c36ef0e30b58e9a32334409d','3227def40b4e9860e97d693698da33e6e467b4b9',81,'mod_scorm','content',0,'/mobile/slides/','655PcIIcLg6.gz',NULL,3253,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3029,'5749ed18edb0a315ab71c8dcd155d8eb62da6125','d239e90dca10aae4e867ed38410b9605a85fbfd8',81,'mod_scorm','content',0,'/mobile/slides/','6fyTDQxZ0oC.js',NULL,15863,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3030,'2fffa0a532b15597024a9815ac93b8d9f803fda7','ec7a6c8ce287cfde19120e7b93583d685b4d9e28',81,'mod_scorm','content',0,'/story_content/slides/','6GpjfbrhYk5.swf',NULL,3553,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3031,'f4f769d6024b602546d763d4a9eeac7c87d8509c','59596d046d0eb492c432fba2b2edac079844457b',81,'mod_scorm','content',0,'/mobile/slides/','5yHPWhKts1S.js',NULL,15845,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3032,'a1705c67699e4fc5129de9e6ceee343266f6a4f1','f277b525844ff9d72fb249642d82c74beb588748',81,'mod_scorm','content',0,'/mobile/slides/','6GpjfbrhYk5.gz',NULL,3264,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3033,'43ee31046a2156e7f6283841de01f8939632c8ad','3e73c40eb1a7f09ae39809145e403209c54ec5d2',81,'mod_scorm','content',0,'/story_content/slides/','5lr93X9P9rp.swf',NULL,3554,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3034,'baca11b055fde1e06f480e08c810e32466b5052a','c035a69e29d568684a9625e7139b02bc51566975',81,'mod_scorm','content',0,'/mobile/slides/','5lr93X9P9rp.gz',NULL,3264,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3035,'eca754f213d8452af6d9ba577cd70918391fe3c3','b767777910d67fa2fcc96b87fec95f1cc1f79fa8',81,'mod_scorm','content',0,'/story_content/slides/','5s3LmxTiS8w.swf',NULL,3555,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3036,'37400213ec5310b2db91228a9748b963bd08dd13','08642dc9182123e4929da40e579552de88507828',81,'mod_scorm','content',0,'/mobile/slides/','5s3LmxTiS8w.gz',NULL,3264,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3037,'51d64ec3ff77331e9d2beab395c5c3fab24c508f','ab74bf4e541cbad5cb86c279f3fafd35b2e53a5f',81,'mod_scorm','content',0,'/mobile/slides/','6mXbRGfIV7q.js',NULL,15858,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3038,'b0a5eca3491c78e11a377b8d385fd1dc9296f164','620ea24abcc091c402e9d0afb396c03c7f0e7162',81,'mod_scorm','content',0,'/mobile/slides/','68HpRTfxW4m.js',NULL,15858,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3039,'7fbb12f78a8f35cd63e1ae8c19ae22a0dc87229f','2795180d6dc8c29c895cd1840c3a4aa8f829d470',81,'mod_scorm','content',0,'/mobile/slides/','5n9egdmyR2t.js',NULL,15870,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3040,'1e372bf226674b475664f04b72ad21c3467291af','d5e57ac4e2ddf347690292dc67eb5bfe1506fa98',81,'mod_scorm','content',0,'/mobile/slides/','5YZsobjqpXR.js',NULL,15862,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3041,'179922bb6392f07c05718f95e8a556cb94319665','90a1e96693451f8787e74f9f39e2a47596425057',81,'mod_scorm','content',0,'/story_content/slides/','5zssph6B6a2.swf',NULL,3555,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3042,'308db29dd6844988cbd6e38168c8744ab16f8db0','9d43a1a90fe6b474f63bb797f3452e374adddf1f',81,'mod_scorm','content',0,'/mobile/slides/','5zssph6B6a2.gz',NULL,3265,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3043,'fc00b0842a8bd7a77a19f39255c3d618e15e2876','0705cd346e63770594058f41faa69186cf390291',81,'mod_scorm','content',0,'/mobile/slides/','655PcIIcLg6.js',NULL,15845,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3044,'69a1b671bc0a2d11356b7d4132d0ed0611698b8c','dc03dd5a0f555c3c53134ec83e8f5c7acf025356',81,'mod_scorm','content',0,'/story_content/slides/','6GYlx3w8EXx.swf',NULL,3546,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3045,'931ae16679439f9f0308dacd1c42611ba683d21a','e3179724d0495f812d6c548a15c1a63df035e61a',81,'mod_scorm','content',0,'/mobile/slides/','6GYlx3w8EXx.gz',NULL,3256,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3046,'fa9185ad7cd5d16b82b70ce5a7a5af51f97422a7','8858f54c8efba01be50023349290e8bdbbe71afa',81,'mod_scorm','content',0,'/mobile/slides/','6b8sPOLFyKm.js',NULL,15870,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3047,'1c912d83508a25770de4d7293c122cb90e1a71f7','ceef0b77a1654641e56f89f7507440bc12605c98',81,'mod_scorm','content',0,'/story_content/slides/','6HBcy2ngGWe.swf',NULL,3562,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3048,'4138ecae9e7f31cc1fb162505b23c3020b48d9cc','83d32cd708e00ef794a2b815fe03cd9522d02b81',81,'mod_scorm','content',0,'/mobile/slides/','6HBcy2ngGWe.gz',NULL,3272,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3049,'2e2e98de41e8818481be2cf919f2b9a1c542f723','7968d4c9f96e1cbbd9f4e826c7fece5166ee53a2',81,'mod_scorm','content',0,'/story_content/slides/','5tsTwIn6DGH.swf',NULL,3548,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3050,'6c52b2d482344fd8b6910116e9097b544a1b2b4e','c56f562f6c3f7de00483e6756cd332f3115072dd',81,'mod_scorm','content',0,'/story_content/slides/','6XJMgPqgs3C.swf',NULL,3554,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3051,'04d9542be4539298615e5054f87a5f3a31ccb70a','d6a0654655322df98fcc239d8ab46fbcd232bb1a',81,'mod_scorm','content',0,'/mobile/slides/','5tsTwIn6DGH.gz',NULL,3257,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3052,'c60814454ba16cf302ef3f315dc59e52c0bb392f','466c5fa0a08d7a36eea5711e9817d448c4bd3716',81,'mod_scorm','content',0,'/mobile/slides/','6XJMgPqgs3C.gz',NULL,3264,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3053,'a32d83207217d1dbfcc72f368e054549bbf293c0','ef9820f0f1da0e8f123d8fc0ff8910b3a3e41aa7',81,'mod_scorm','content',0,'/mobile/slides/','5s3LmxTiS8w.js',NULL,15860,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3054,'67802fa941f5843501d6e96f345ea3a419c4d713','c79a8e55ba4c50ffe8c861a27183cebaab768a4e',81,'mod_scorm','content',0,'/mobile/slides/','5lr93X9P9rp.js',NULL,15862,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3055,'6ca222e79834a2b759723938b27cc91cc233017f','215097c75eba2cf1905515562381f6f220d08ebd',81,'mod_scorm','content',0,'/story_content/slides/','68aqWzgBnIh.swf',NULL,3556,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3056,'2cd3ae9257757cfb27c292dacdf8c422cb03a23c','a80f016038ab5e2b6d97da523713136f45c158d8',81,'mod_scorm','content',0,'/story_content/slides/','6C91mG2XNPZ.swf',NULL,3551,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3057,'d9b34730d091d7a68449ae28edc619d338619608','63aa02b4759de474180b84784f8651cb8decc6cb',81,'mod_scorm','content',0,'/mobile/slides/','68aqWzgBnIh.gz',NULL,3265,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3058,'43e495ad67cb74126d5dafec5203969e23ccb345','741d9399e5373ac6526dff0b6ca9558740acacfc',81,'mod_scorm','content',0,'/mobile/slides/','6C91mG2XNPZ.gz',NULL,3263,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3059,'c8ea72fbd9f68768367bf110e413631213af4ee8','4f999d81f766d88a7689e0f9d2bf00a28f8db4b5',81,'mod_scorm','content',0,'/story_content/slides/','6c75xe5U2LH.swf',NULL,3567,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3060,'f563bce125866a62ce23cc3cd260ca3490144979','edd021588695fcb9643ca9e32c7f155b2ab5d21a',81,'mod_scorm','content',0,'/mobile/slides/','6c75xe5U2LH.gz',NULL,3276,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3061,'ce5887b33e7762e9c9c69acf18f41bc740607fcc','2e4d505a8e498e0401104210193ddcdeaa005a7f',81,'mod_scorm','content',0,'/mobile/slides/','5zssph6B6a2.js',NULL,15862,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3062,'ce0021567ab85be3945b1d83afdcba080b1f4589','98b19e28b28d87e5c68d7824838ff5232597abde',81,'mod_scorm','content',0,'/mobile/slides/','6GYlx3w8EXx.js',NULL,15847,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3063,'097d1f61069ea628231be901540ae34022ae573d','626df9fc92afc357b27fa0bd37d018d0ce2b22b1',81,'mod_scorm','content',0,'/story_content/slides/','5yN5xQ0scfb.swf',NULL,3565,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3064,'8b5d399dc2147b487903a0253ee268efbcdf5625','74a107b0bd782d0184e1d95d355c82d558e61f09',81,'mod_scorm','content',0,'/mobile/slides/','5yN5xQ0scfb.gz',NULL,3273,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3065,'c3242dace57750ce9da889542b7157a9fd4e5a0e','922a5ad99a8d2bbe191e2384d255e1452cbf87ac',81,'mod_scorm','content',0,'/mobile/slides/','6GpjfbrhYk5.js',NULL,15858,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3066,'ade8ee41e5ee8cf07057a26c9137e88a4123062f','72d629dcca511c1640df33eae8e7dbfb0049abce',81,'mod_scorm','content',0,'/story_content/slides/','5WHnzXuixp1.swf',NULL,3543,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3067,'b2789ae47f5fb7651af14c137a42192a1e27a510','05a794c0c2afcb65b7eefd9e273af9577eb9cb7c',81,'mod_scorm','content',0,'/mobile/slides/','5WHnzXuixp1.gz',NULL,3254,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3068,'06e110976bc171d61c677f6bb27b73c8c669395f','d00c355b8e81da98afd7723b646749d76289c849',81,'mod_scorm','content',0,'/mobile/slides/','6HBcy2ngGWe.js',NULL,15874,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3069,'d0381f1b94c7551902fb213f1b69ec6ea6a96a11','5f8b40afce5d64e53ebd589d3a608f6f4f4e0c18',81,'mod_scorm','content',0,'/story_content/slides/','6jT4RfFO1rp.swf',NULL,3558,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3070,'5dba103f70c0ecd3f72ef36c85abd7ffdfd335ac','3d56f178f1a8f0da23b0ea2ad94192f079ccece0',81,'mod_scorm','content',0,'/story_content/slides/','5bSAOPulYzK.swf',NULL,3578,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3071,'c92df43769bb5ee5028189702a4dc714c0e47243','cac3b75874e9692e6e17aae8654b88480ba5b1e3',81,'mod_scorm','content',0,'/mobile/slides/','5tsTwIn6DGH.js',NULL,15848,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3072,'93be1b8d9a321c96c8fc276e354595e2aac68867','6e90115b0592e0309c4253c87a5351efb1f9a722',81,'mod_scorm','content',0,'/mobile/slides/','6jT4RfFO1rp.gz',NULL,3269,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3073,'589fa9740c17cb6f624f9e539e21fa308a804700','9a57ca52ca1b3f7c1f02300ca62b3026249f9d03',81,'mod_scorm','content',0,'/mobile/slides/','5bSAOPulYzK.gz',NULL,3288,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3074,'ebb0ca116485d2e52b50cdd14562586ed6990793','ab9bd8e0a24e6ba15c94bf3eb2aa230a26e1a327',81,'mod_scorm','content',0,'/story_content/slides/','5eGOjqvAnm3.swf',NULL,3562,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3075,'2f3129a5dc3a4df79ddb32b82c551f3f8b24ea8b','64080151053d20cdcc178636e67dca3c9fe32073',81,'mod_scorm','content',0,'/mobile/slides/','5yN5xQ0scfb.js',NULL,15876,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3076,'6ca081be58d889e31e9facf6ef020363f8ebfec8','c28603ae13ec6dab9728247b68be3df5215b6a24',81,'mod_scorm','content',0,'/mobile/slides/','5eGOjqvAnm3.gz',NULL,3271,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3077,'cbea613131a68626a49adbe875f076d05587b2d9','9676f3f8b0337753b2671817e9ea7f40b764a39e',81,'mod_scorm','content',0,'/mobile/slides/','6XJMgPqgs3C.js',NULL,15859,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3078,'babbf8a77fb2faaa1df49aad884fb7eec22538aa','b0d3621a427c69f9e2b7db89cfa58b40df456821',81,'mod_scorm','content',0,'/mobile/slides/','6c75xe5U2LH.js',NULL,15883,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3079,'3cb6bc7ef54720c3683be1349f2deccee69c7fed','d74f2568d67098d53175c70fb31ec0ecca4c3c45',81,'mod_scorm','content',0,'/story_content/slides/','6aActkXx13a.swf',NULL,3553,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3080,'16d9376a166b0679d909271de84775c36739f7f2','203bf85aee9614ee5c4479b28054c8c004585904',81,'mod_scorm','content',0,'/mobile/slides/','68aqWzgBnIh.js',NULL,15863,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3081,'36fdddf5f68b2ed4ab00fcb2f773195fbf11df90','6b9d716bc308242a6bb2e08ac26f876380a19275',81,'mod_scorm','content',0,'/mobile/slides/','6aActkXx13a.gz',NULL,3265,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3082,'2285aef716fbc4e6c7966c7673fadb992ed1f683','adb089385e9ec837c30ceae28eb0ca307d487098',81,'mod_scorm','content',0,'/mobile/slides/','6C91mG2XNPZ.js',NULL,15857,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3083,'b1fe833842ad323371c6165c9ce32e61a8afe2fa','0dcaafca02bed1f5a7d613b1847ebbd0d046c8f4',81,'mod_scorm','content',0,'/story_content/slides/','65SsvF5I3My.swf',NULL,3558,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3084,'4156564518da06f8ce79d3b4ba81a4cc185f17a5','29fb68589be85818375d899b6403965c731499d1',81,'mod_scorm','content',0,'/mobile/slides/','65SsvF5I3My.gz',NULL,3269,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3085,'9dc5eb973e802aae1a0ab5168936e98b86af84fd','49a14708960f9971334f113982344134a4f8116d',81,'mod_scorm','content',0,'/story_content/slides/','6TGSGm7vHzA.swf',NULL,3550,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3086,'bdecbea10ac6fe3875b06f1a877e7c350f634758','36e7814f06346bf7e28f50450b864d76730b1953',81,'mod_scorm','content',0,'/story_content/slides/','5ccQuy3vlLA.swf',NULL,3550,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3087,'c4badeed518c9652b0516a57da73cbcbbcf80428','c4e3a58822a0708f0b71cb0dc9f6f8de42ea9aa3',81,'mod_scorm','content',0,'/mobile/slides/','5ccQuy3vlLA.gz',NULL,3262,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3088,'06a60895e65fc7f9e83a6d4044b487aa7f6d937f','fab57d8692e771c08fbedb91aee4f6bdb186e20e',81,'mod_scorm','content',0,'/mobile/slides/','6TGSGm7vHzA.gz',NULL,3260,'application/g-zip',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3089,'a0c99b568a6b70b973be8e0e3dacf6e5295638cc','1f50368450b2a30edeb709096f556e8c454f28b7',81,'mod_scorm','content',0,'/mobile/slides/','6jT4RfFO1rp.js',NULL,15865,'application/x-javascript',0,NULL,NULL,NULL,1462716824,1462716824,0,NULL),(3090,'550309fb5845143be2334aee8cdd26a715c2883e','dfbd4016a76373d0fcbacb0f4a2cc2b02e93c77c',81,'mod_scorm','content',0,'/story_content/slides/','5zmgzuz0epz.swf',NULL,3568,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3091,'469226082e973fb13bfe371d2784f3aa477b51ff','99bfdf96ec0b08be38d6bd20688085fb8074a997',81,'mod_scorm','content',0,'/mobile/slides/','5zmgzuz0epz.gz',NULL,3278,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3092,'6b432cf422fc96dd18cf039a209ff247d959c07a','3791b586fab2c969d5d2da1807c942c696aa00ed',81,'mod_scorm','content',0,'/mobile/slides/','5bSAOPulYzK.js',NULL,15928,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3093,'105db518f2ff9337ec3b61d9494ba7d7a15f1851','855ef3ebf8f968693e823cd6893658a697643921',81,'mod_scorm','content',0,'/mobile/slides/','5WHnzXuixp1.js',NULL,15843,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3094,'f0eafe5c33304fd5c7e87408d984f3d1f9b21039','1b61bef69041f5816b2643f02812c2e81cbfd08c',81,'mod_scorm','content',0,'/story_content/slides/','6J6OKpsuRY4.swf',NULL,3563,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3095,'29ec201ecff898db8a679bf70bf81cd1e4cbfe41','a4b2cc253f1049de9292e8ce040e153ca37495cc',81,'mod_scorm','content',0,'/mobile/slides/','6J6OKpsuRY4.gz',NULL,3271,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3096,'c46872b26b7e48f86e3e756dd40537e589104648','0d000f52f7e045b654312bd29c10e1a6ed69c5d5',81,'mod_scorm','content',0,'/story_content/slides/','5agGUIxRv7A.swf',NULL,3558,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3097,'924131069932126401106675394ce933529b98c8','0230f35d324d41b935381d38045b97f2a49260b0',81,'mod_scorm','content',0,'/mobile/slides/','5agGUIxRv7A.gz',NULL,3268,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3098,'2b19378ec6754a81a0b4bea3c026e7dac5d26110','177b2fef6329dae1936bdf138f9ef187eb3ebd0d',81,'mod_scorm','content',0,'/story_content/slides/','5ZjukHZkEVl.swf',NULL,3558,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3099,'bf0bef3a63e1a78fe8aff71a12d42ad9a6bfcc43','b2fe69ea5e867badbb7563af26b12ef902cdaa17',81,'mod_scorm','content',0,'/mobile/slides/','5ZjukHZkEVl.gz',NULL,3265,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3100,'0505c11e9d6fdd6115c8b837b49662e76f5a3622','57c4a11da75eb87fa716a8d140eb65c036b4ab3d',81,'mod_scorm','content',0,'/mobile/slides/','5zmgzuz0epz.js',NULL,15900,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3101,'c228e3f2ac9ea3f111de119e46d3988ffc6d432d','85bc51f5fdddab5c0fed3cc70e7f4054f17a7e54',81,'mod_scorm','content',0,'/mobile/slides/','5eGOjqvAnm3.js',NULL,15880,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3102,'b280411a386f4a5ab1b30186b956c4f29a3e8177','9ddc55adbb04f7b3178243dfb46047202bb0d824',81,'mod_scorm','content',0,'/story_content/slides/','6VFuz3D9qRW.swf',NULL,3550,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3103,'487fbafa842fa4bded894aed2963bda47558463c','e9401c7a7698ed3290fa572cda347dd6bf309863',81,'mod_scorm','content',0,'/mobile/slides/','6VFuz3D9qRW.gz',NULL,3262,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3104,'74361bc4012ecc9af23b2c0754f5f8942743dc40','d6aab48beec9abd4194bd37288a102af01fbc8a0',81,'mod_scorm','content',0,'/mobile/slides/','65SsvF5I3My.js',NULL,15862,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3105,'2488435915e9c0d534719d4a47c7a5e943f076f0','367ab743f7677a40fe3d985d1e15cdb464f6ae54',81,'mod_scorm','content',0,'/mobile/slides/','6TGSGm7vHzA.js',NULL,15856,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3106,'b7a9e3e4cddce1f18cfca0c3d49bf1ea71340259','17f3cc07eaaa6bc396a190edb02030ccffa4f7d1',81,'mod_scorm','content',0,'/mobile/slides/','6aActkXx13a.js',NULL,15860,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3107,'8d0f02a13e2f42fa775cb2aa3f5b9980533984de','73d062d9178efbcfaee83490ad86585b83f0dba5',81,'mod_scorm','content',0,'/story_content/slides/','6f1gn6UjulC.swf',NULL,3559,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3108,'66c1142fa5f194ef3970eff4500669f4cf8a8a07','ebca09f714db58627ea99785e2e1982c0122491c',81,'mod_scorm','content',0,'/mobile/slides/','6f1gn6UjulC.gz',NULL,3267,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3109,'86de13c120c02b8264838d55be0ec373f779566c','56f7c6225ccf68c7c95761e917fc87513f734961',81,'mod_scorm','content',0,'/mobile/slides/','5ccQuy3vlLA.js',NULL,15850,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3110,'b33481baf567aef1e1188fde951bd8ff79e7b9ee','e0eff96a749e4d9ba07fd9f29815c34af566538b',81,'mod_scorm','content',0,'/story_content/slides/','66VXiVSn1x3.swf',NULL,3557,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3111,'2ca4ae6a2fe8b62c992046f0f86264246c96b16c','f829a0a3393d54e47566f3d9704548165e85c6da',81,'mod_scorm','content',0,'/mobile/slides/','66VXiVSn1x3.gz',NULL,3266,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3112,'6574ef6435cc1894c14c91a9f9cc2529fc6f5b76','3a76864757dff0214f877393b777fb25114af3df',81,'mod_scorm','content',0,'/story_content/slides/','6UTizv8glEP.swf',NULL,3561,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3113,'4db144b9b18efd31c2ff49bd6bbe951cd8d0d21e','b9f0115a1861b38d3133e833a984806ae2a1c326',81,'mod_scorm','content',0,'/mobile/slides/','6UTizv8glEP.gz',NULL,3270,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3114,'7d78bf67d8017716ba1f6ee1d4e1a24a7235009e','d2529677941fd058e8d33599da8306c9d0e8e178',81,'mod_scorm','content',0,'/story_content/slides/','6aMeTGP8wfN.swf',NULL,3560,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3115,'8d0b5e12113082bb42ccb1699a5b30f939248477','d6d584079c01b6215671faf74c50fbe4ddd256f4',81,'mod_scorm','content',0,'/mobile/slides/','6aMeTGP8wfN.gz',NULL,3268,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3116,'33b660880baab3c7a425a7952d4a0f1f1321251f','2a0b31fe06e9f8dfc65d565e5753d7cb442e6c41',81,'mod_scorm','content',0,'/mobile/slides/','6f1gn6UjulC.js',NULL,15861,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3117,'f6c5b6c87033ec32cf9def0519c91d63c92cc505','b50d12523877a1bc18f29187a64f6c07872cbfd6',81,'mod_scorm','content',0,'/mobile/slides/','5agGUIxRv7A.js',NULL,15860,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3118,'45f53630eda5d6147156535108109643c09cdaab','c20a9197cb946e8838f18254f2a7ad4606e67967',81,'mod_scorm','content',0,'/mobile/slides/','5ZjukHZkEVl.js',NULL,15858,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3119,'07051148eac9652b4d5b6cea3eb7b3b77f1491fa','8f51a2a1d072c886a5bea1745026811783d51026',81,'mod_scorm','content',0,'/story_content/slides/','5cVOtInKSP4.swf',NULL,3558,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3120,'fe8d0c3e7b69342b58fa26ddd4ab9f912a7cc5c1','a1c098ee182df9bade630c82c9d2fa2c7d86cb29',81,'mod_scorm','content',0,'/mobile/slides/','5cVOtInKSP4.gz',NULL,3268,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3121,'4766fd6a43532e7be1c445c7fbcf34770038787d','90240bafa5820cc17cfe0d1adabf33cee3d5c219',81,'mod_scorm','content',0,'/story_content/slides/','6anubLpMtzh.swf',NULL,3551,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3122,'20637ec5dfadc32f9ca91ea234f14a2f72285db3','686f7a8616abae0ea4ada2db816e9c71f2a717b2',81,'mod_scorm','content',0,'/mobile/slides/','6anubLpMtzh.gz',NULL,3261,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3123,'addeb2ff6f5ea026ea62610b2e3b8a750b5ce7bc','36f46a9aa40cb91a4955e42ba4ed2e7fff981d69',81,'mod_scorm','content',0,'/mobile/slides/','6J6OKpsuRY4.js',NULL,15860,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3124,'233cbfc28d4fe24a2e6465773e0c2c159c063703','86843a478099ab8416309843927cfa3aad6d540f',81,'mod_scorm','content',0,'/mobile/slides/','6VFuz3D9qRW.js',NULL,15853,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3125,'f9456fa426127940cdb14a725ee282f8a42c3f2e','174e9c0a4f9b529c024b77fed7f888782e0ccb1a',81,'mod_scorm','content',0,'/story_content/slides/','5hxn4ygXw90.swf',NULL,3546,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3126,'3255831fd2a1f25bd8dc658874018ba0c519fce9','051dda987331753ddcb2be45e4a10a2924f01d9e',81,'mod_scorm','content',0,'/mobile/slides/','5hxn4ygXw90.gz',NULL,3255,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3127,'206d0ba249e187ba27bb07234e51305ccbe01f43','09490d758d9079910417224feb4b09d91951aca1',81,'mod_scorm','content',0,'/story_content/slides/','6ebtvCQ7xaP.swf',NULL,3556,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3128,'89bd2f4678a69680cc22e34b16c809189f614f36','a205dff01dace819af8f74e79a0a85ba73b32b35',81,'mod_scorm','content',0,'/mobile/slides/','6ebtvCQ7xaP.gz',NULL,3266,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3129,'57fdeb8edfd2ab6aef562f1b3a7b39e239320220','56f0c2c0187922eb93dc112f0d7bcc73a176110a',81,'mod_scorm','content',0,'/mobile/slides/','6UTizv8glEP.js',NULL,15863,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3130,'cc72054e8a3fb946bd455c3c74d3db3da226de0b','325b98e7bf9ee2c54fa5e6ad08c45c97a0bb42e5',81,'mod_scorm','content',0,'/story_content/slides/','6OeUyLb74uf.swf',NULL,3551,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3131,'c55b9403ce7f3b30583edfae898e133fc6e356c1','0066407fcb7f9692d376f195f4495993e08934df',81,'mod_scorm','content',0,'/story_content/slides/','6HMb59rxer3.swf',NULL,3556,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3132,'d6317337fa45018f061dee86b1f1b7e90b4a75d2','c5be7879a1422800339cbf64062e7bdb5c643e1b',81,'mod_scorm','content',0,'/mobile/slides/','5cVOtInKSP4.js',NULL,15865,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3133,'5a9e4885848f618f0529fea122360edf6f5fafbe','5a0dd6ba781f3304764c7638b56ceda613cbc2fd',81,'mod_scorm','content',0,'/mobile/slides/','6HMb59rxer3.gz',NULL,3266,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3134,'385fc38932c41ef336182880f4be535daaef122c','aff995bb80f07f429c86ee00fd9516c785ed92ee',81,'mod_scorm','content',0,'/story_content/slides/','6PDONhNfh5v.swf',NULL,3562,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3135,'a97700ad85ecc49e1990763b300cc6267e2e6fc5','eb2cbc401f95fdda6be9a842cbd7d1744e8d3a1b',81,'mod_scorm','content',0,'/mobile/slides/','6PDONhNfh5v.gz',NULL,3270,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3136,'310ef89248663a8d3dc7c06d96e57949fbb25a0b','8d6b7abd3c06ca60f449f2b710618f7e15675efd',81,'mod_scorm','content',0,'/mobile/slides/','6OeUyLb74uf.gz',NULL,3259,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3137,'9df2ab318241d62c88aa832ac0986e53b316cf97','28923c28c04b35b6818e15401bba29d30a74173f',81,'mod_scorm','content',0,'/mobile/slides/','6aMeTGP8wfN.js',NULL,15864,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3138,'45a397755f75d5da0476282065ec02ff19c5ddc4','dd22e283ff07ee015b6a9f407ee7ca93da327767',81,'mod_scorm','content',0,'/story_content/slides/','5ppVFIZwGOQ.swf',NULL,3579,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3139,'9d44e089b153e97a252c977419f28c0b6bc22a13','a83a1fa9252355f5a55ba4660b3cd696046b5f79',81,'mod_scorm','content',0,'/mobile/slides/','5ppVFIZwGOQ.gz',NULL,3292,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3140,'b804cc66730f11a5b8c31d705d7cdf64cd832205','d83f4250e56093ccd9a130cc6edbddee7751e263',81,'mod_scorm','content',0,'/mobile/slides/','66VXiVSn1x3.js',NULL,15859,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3141,'bcb03849cce5710577c14fe899f4914267989594','0067e7ccfd82ca38fa3ff75013f14bf576db4967',81,'mod_scorm','content',0,'/story_content/slides/','5ieHtmwQPDB.swf',NULL,3567,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3142,'8ba27d2b100cd36738b8ee89f0ebde4cab7ddcc2','6472c20638d7c18b62aa45057902d34a9b1f7d6f',81,'mod_scorm','content',0,'/mobile/slides/','5ieHtmwQPDB.gz',NULL,3275,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3143,'72a6583ec98c4f041afda32b0f36df54072e0794','64739944043612f2f8ef67e5ab1b2ff8c488b8bf',81,'mod_scorm','content',0,'/mobile/slides/','6anubLpMtzh.js',NULL,15850,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3144,'0ae85233c231a5cf2cfd2ee813eb7929ec2b0887','e1bf31a392adf23ea01886fa90956bd82b0e1503',81,'mod_scorm','content',0,'/story_content/slides/','64CrsTessXo.swf',NULL,3550,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3145,'dbf73c9e8815313d4dc113f13d5c75a3a674823c','6ce90546079119334ccb9f586b88c39b38597894',81,'mod_scorm','content',0,'/mobile/slides/','5hxn4ygXw90.js',NULL,15847,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3146,'f644f5941a85013b4e4b384a2e1b915a47d644c3','22e64cfaaa4827d79fa8b959cc50b167cd61164c',81,'mod_scorm','content',0,'/story_content/slides/','5VHtE3c1vHr.swf',NULL,3548,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3147,'cb7890c77d39bed6cbab672afc1637b624f0145c','32a89bc39ccdff57683dd1d33f29cfffd35b2deb',81,'mod_scorm','content',0,'/mobile/slides/','5VHtE3c1vHr.gz',NULL,3259,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3148,'3567156a4b8e7e2a6983fd83d2fa28d7a81fc99c','2228417222ed6e570846e36bd98d1eff402395b3',81,'mod_scorm','content',0,'/mobile/slides/','64CrsTessXo.gz',NULL,3262,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3149,'e78dc5b4b34fbb34f74902c0394e5a8f1125a8b7','e79f76984ef796c82aa3b722f0632968d2d11af6',81,'mod_scorm','content',0,'/story_content/slides/','64ZZIgROd3t.swf',NULL,3580,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3150,'334577057955151c088af1fbf9d05538b177e8a8','07b9eb5eb68d1414dc7d5d396c42fe634e3089bc',81,'mod_scorm','content',0,'/mobile/slides/','6ebtvCQ7xaP.js',NULL,15859,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3151,'2e80a5d33b5788962e694602ac72abc239761b22','40b49b47630a3a91d478f61969093456892f70d6',81,'mod_scorm','content',0,'/mobile/slides/','64ZZIgROd3t.gz',NULL,3286,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3152,'c9eb325bbd183ee3e66d624adeb0eea8553e32e8','75ac708113ebf82dbb4780c777b490cee62b64db',81,'mod_scorm','content',0,'/mobile/slides/','6PDONhNfh5v.js',NULL,15863,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3153,'821699515abfb12857177300387e7a73f8bba5c4','8be54ae9737e1a3872f687af0ed713c62d89d9c2',81,'mod_scorm','content',0,'/story_content/slides/','6jYr9LKXVig.swf',NULL,3569,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3154,'ba97b0a33f911ecb0c4b54a8ea296fe402948e40','f012c011d91647908046e98d6a160cb10f6662cb',81,'mod_scorm','content',0,'/mobile/slides/','6jYr9LKXVig.gz',NULL,3277,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3155,'c22610702d73f4f6b748eaf3dd08c4a4f936bc60','61003a64de1f11fcd5efa9db1e63425be88d5be8',81,'mod_scorm','content',0,'/mobile/slides/','5ieHtmwQPDB.js',NULL,15874,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3156,'3d541d0fba859b1809d5284b7712a9e5f2e03b6d','cee3998f1b611edccf359fbc09b5be5146b92d29',81,'mod_scorm','content',0,'/mobile/slides/','6HMb59rxer3.js',NULL,15859,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3157,'1fb39d6d006068b0d0fe0015501b9d2696fac1ad','4d14f5f96ff9717a3007c35c581e862164420b48',81,'mod_scorm','content',0,'/story_content/slides/','6CCrpNgRnTl.swf',NULL,3557,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3158,'1a282046a8d467307f9d47dba3e912c49f3e9b19','f1e8c02eaf03d317c4e5d3540897b68aaca52956',81,'mod_scorm','content',0,'/mobile/slides/','6CCrpNgRnTl.gz',NULL,3265,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3159,'c75733de2632f58279c1c83c76b2e35c62b4311f','665f54995391c882463d765bd339c4f60cc7d985',81,'mod_scorm','content',0,'/story_content/slides/','6ngDXtJpex7.swf',NULL,3551,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3160,'92704397c23eefb82c0f9312aac8dacc443278a0','eaf8ae7af6598b7606d149a5862f034a90dffa70',81,'mod_scorm','content',0,'/mobile/slides/','6ngDXtJpex7.gz',NULL,3262,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3161,'83f5a0816db64ae812ada227bfdbd05e184d9f86','8716f7abcc1f4777c0d871eb7a7b9d9c4802346b',81,'mod_scorm','content',0,'/story_content/slides/','5xYx4VYQYdb.swf',NULL,3573,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3162,'f8c60fb7b66e6d7e41ca79c2087d4420a507e647','10fc3edfcbf2792a15fc946caf695230cec030a1',81,'mod_scorm','content',0,'/mobile/slides/','5xYx4VYQYdb.gz',NULL,3284,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3163,'01d7cfe0d72b33465754478bf6ce26defbed82be','d2b7b0c560148691c2cfe1446a874c387e87378b',81,'mod_scorm','content',0,'/mobile/slides/','5ppVFIZwGOQ.js',NULL,15891,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3164,'4958c3e463774fe6e7fa4830cc4ceaec1e7e25d9','50a36f29f8d5ee2d01d8a0ab2c2e74f8e6060931',81,'mod_scorm','content',0,'/mobile/slides/','64CrsTessXo.js',NULL,15856,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3165,'ffc9003584198d39057212f6d0955d1770f6f517','df07b53277fb7ef97698722b3b0a69a8c35fc9bb',81,'mod_scorm','content',0,'/mobile/slides/','64ZZIgROd3t.js',NULL,15891,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3166,'e9474ed00c4a71a6cd4edbed44f3a119eaac44f5','8f24908d430072e525b0c3512f06305ac2aa28fa',81,'mod_scorm','content',0,'/story_content/slides/','5c9YzDir9qq.swf',NULL,3548,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3167,'dcdfe6b01382f982c1b75a4d3fb59b263e92e911','d3bfce121a4567e72cc84bf118ee20d7d580bdd8',81,'mod_scorm','content',0,'/mobile/slides/','5c9YzDir9qq.gz',NULL,3259,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3168,'bcac0ae7dae85fa5ccffcc9bf0906192a1d42079','11862e7e39740969e10abc3931ebf71b1e1d4f61',81,'mod_scorm','content',0,'/mobile/slides/','6OeUyLb74uf.js',NULL,15848,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3169,'fe233b44cc176801bc195e5bb971c89f335bdc9a','2ef94ba09c38250f64c7502e465a8cb9cde17e38',81,'mod_scorm','content',0,'/story_content/slides/','6XXUwHGnv1j.swf',NULL,3562,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3170,'0ffdb4d4ab3956b7882218c2305171bc27d496db','4afbb28dd347215b710e778af60df9018fbb7dc4',81,'mod_scorm','content',0,'/mobile/slides/','6XXUwHGnv1j.gz',NULL,3271,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3171,'ec5a5355154440c2c3ae16211ca70d5d356977b1','655b33238682b44c98b09bb767243609559440d1',81,'mod_scorm','content',0,'/mobile/slides/','5VHtE3c1vHr.js',NULL,15850,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3172,'3e44716e6c440e1f0eef04dbc15a1336029fc495','9a6dc8fba3ab6ce7e6cfb141c028970f9c0f48b1',81,'mod_scorm','content',0,'/story_content/slides/','5t9DWxbRMV1.swf',NULL,3543,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3173,'b6fae131d96c3811e1958b9b29c443c8c4ab5ca3','42308a22800a459baac537c9165671f3c2bdc65d',81,'mod_scorm','content',0,'/mobile/slides/','5t9DWxbRMV1.gz',NULL,3255,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3174,'149754d3f067deabe06fe4705a380f91b707384c','e81f075e3b839c04f108490c9e049bf038406ad0',81,'mod_scorm','content',0,'/story_content/slides/','60jMVAv2kmQ.swf',NULL,3572,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3175,'297bb0de85a3feb6cc33518bdae1dc2978f209bc','4a883ed5d7611ab4e6cb7cb0d73e8680260634fc',81,'mod_scorm','content',0,'/mobile/slides/','5xYx4VYQYdb.js',NULL,15896,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3176,'5c6c6f2bcd65313a69d61c81648fb6e82c33a6a6','18121ca51fca75cea7b832363db9c8061d187b34',81,'mod_scorm','content',0,'/mobile/slides/','60jMVAv2kmQ.gz',NULL,3283,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3177,'99ae4768adc2a230d39ef1d3e61ddbf32ab29215','fc06d6ae0e8722fa02b0458a6ac3faea31e5efc0',81,'mod_scorm','content',0,'/story_content/slides/','6AaNYpN80KZ.swf',NULL,3563,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3178,'5cf480e20240140771b7d650114320259ea8e8d8','ed7551b74ca1262d0d5b6630665a410cacdabc12',81,'mod_scorm','content',0,'/mobile/slides/','6CCrpNgRnTl.js',NULL,15865,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3179,'8e4c82e3d385e0100ea34815911c687206fc180d','afba8e18fc257e33ff67bccf49f87e9771dded8c',81,'mod_scorm','content',0,'/mobile/slides/','6AaNYpN80KZ.gz',NULL,3272,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3180,'724db08c333d0d601573e1f17a012e08c0e9875b','73e3d31fc4ae65e3b7722e3a14d94a050a324101',81,'mod_scorm','content',0,'/story_content/slides/','6em6NfJG1ki.swf',NULL,3551,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3181,'db20157c305e43e3f448d1e8d95533cc5c9f1fc3','1eb391348a83f1d88611bf945fa68d3f5f41f7b6',81,'mod_scorm','content',0,'/mobile/slides/','6ngDXtJpex7.js',NULL,15849,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3182,'1a33c74b9636b86b1dc7d5aebd7876f77f632864','b3f9cc39bfaec76f2e0682238b2fe592f9e87fd8',81,'mod_scorm','content',0,'/mobile/slides/','6em6NfJG1ki.gz',NULL,3261,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3183,'8e382a35e7b2b414f80497d70bebe416da949c8e','ca7b40247bee8908d01cae6c224b2f7e7db223a4',81,'mod_scorm','content',0,'/mobile/slides/','5c9YzDir9qq.js',NULL,15848,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3184,'a235a654d49c040c6da627bdd6dcf4c3ae30d07e','20d8f3ee21cdf09282eba4627c2a1ff7efb28f0c',81,'mod_scorm','content',0,'/mobile/slides/','6jYr9LKXVig.js',NULL,15876,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3185,'4f7823b9000df0fc8a0bbaa9979282240b5d5e9a','a0cf14f40a79105dcb8b23d40ba61f49a5faf338',81,'mod_scorm','content',0,'/story_content/slides/','5Wzrvzh8rcX.swf',NULL,3559,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3186,'e0c3992bb6043fc41cdbb9cf3b3fd56f3f3c266e','b535b20c6787deccb0ab9970782b5daccff10ee8',81,'mod_scorm','content',0,'/mobile/slides/','5Wzrvzh8rcX.gz',NULL,3267,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3187,'21167b3abec9d8cbfc4dfccce0276c81ffec7cf0','ad6d180fef32bbd7fe09e1c8ad05b9773c3e28db',81,'mod_scorm','content',0,'/story_content/slides/','5X2ikUjdx3Y.swf',NULL,3543,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3188,'3581dc019542d1324aa829b24b10c55c757fbffb','03efba8b8cb3db3dfd22e0c6d642a4e5b68e33f0',81,'mod_scorm','content',0,'/story_content/slides/','5phlmMoHiyr.swf',NULL,3553,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3189,'f97d591cf09354fc502ec38e28bfcce4da2d5899','0a9952d1095757e5b9cd8b1f96022032e67fcce8',81,'mod_scorm','content',0,'/mobile/slides/','5X2ikUjdx3Y.gz',NULL,3256,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3190,'7dff91b914233ebae062722254da85e62f9f94b1','5a1e2f3fd7d8834a547b8c53f39fbbdcdba6bee2',81,'mod_scorm','content',0,'/mobile/slides/','6XXUwHGnv1j.js',NULL,15863,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3191,'819127c9c55cfbcbd66062c3b19b27cd082da00c','7972b052a1982193420d3874db723310aeaf2da5',81,'mod_scorm','content',0,'/story_content/slides/','5cKszIVMWML.swf',NULL,3560,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3192,'c25f764a00d78ece641279e47731f8abc130c9f1','0a660cfa56bd1ae38399afeab8a7cee62c0b9475',81,'mod_scorm','content',0,'/story_content/slides/','5WONfLzjK0C.swf',NULL,3561,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3193,'63dcacddb2d5c4887a1503b439da163e3f159b2f','983f0f38aef65d6bcf5115b88ebb3810cd33a580',81,'mod_scorm','content',0,'/mobile/slides/','5phlmMoHiyr.gz',NULL,3263,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3194,'76ce93d7eb412c4abc582905a4bdde25e23ed06c','a478db0ef1b53e9aece0f4b590eec0abea91c3fc',81,'mod_scorm','content',0,'/mobile/slides/','5cKszIVMWML.gz',NULL,3269,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3195,'8ddecf70449150edddd437ccf982cde16fad9a1c','22c62dd889fd9d0b0097fcc2ed46ac7c75553d9a',81,'mod_scorm','content',0,'/mobile/slides/','5WONfLzjK0C.gz',NULL,3271,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3196,'bcda8cc405ef0f7ae7354e30f2fb35265d5ff1be','1f27bda776c558746eb5850f880339ab1aa856bd',81,'mod_scorm','content',0,'/mobile/slides/','60jMVAv2kmQ.js',NULL,15899,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3197,'da08818615f9cca41d6be6369501977448af9b0c','decce89cecb97f8124ee4c2942f3c22b7cf73e63',81,'mod_scorm','content',0,'/mobile/slides/','6em6NfJG1ki.js',NULL,15850,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3198,'f9d63abe02312c5a3fa9820fdaa8eaa21da95ff5','6a952f1ae783496dc1522a7dcf50e7c498bd91aa',81,'mod_scorm','content',0,'/story_content/slides/','5x0jma2XdxG.swf',NULL,3560,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3199,'8c5e23d2b5e796f9ab8280db72fe2b4c7c1c9e11','574ee910faae00ca34c3b69f2e0102564ad8f0a9',81,'mod_scorm','content',0,'/mobile/slides/','5x0jma2XdxG.gz',NULL,3269,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3200,'8842332e645fa8577c674d5b58b08067362fce12','32963fd48a55fff9f721e67ea181de9c14ddc0a9',81,'mod_scorm','content',0,'/story_content/slides/','5VI1O7nsffB.swf',NULL,3564,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3201,'a02a0bb6d1ee19af7f1e21e3f74a5e2e7fec6290','51e483f3aaa71b7729e3e7f6dcc7b8823c42e86f',81,'mod_scorm','content',0,'/mobile/slides/','5VI1O7nsffB.gz',NULL,3270,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3202,'b3efbc20cd9b3f09ddf979c623d18e62c42058b4','032ec742dc3363f5cdefd185c0e90ff8eb6c34bb',81,'mod_scorm','content',0,'/mobile/slides/','5Wzrvzh8rcX.js',NULL,15863,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3203,'26c24e97b8504690403498e15bb921b49302b2d9','05323287d566d63485c74391a02c4400dcaa9ea4',81,'mod_scorm','content',0,'/mobile/slides/','5t9DWxbRMV1.js',NULL,15849,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3204,'e498f82f73bc9d5656def7093b6ea9315fb3ed5b','db282a8e895535c9b3939c4ceb6f2cbeda86e986',81,'mod_scorm','content',0,'/story_content/slides/','6GCOr2Gcg0u.swf',NULL,3575,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3205,'0a56704c82dce92198eddf9455d212c46808784c','f28be80bb59c5cab4bb8c2d5bf045b6840668eea',81,'mod_scorm','content',0,'/mobile/slides/','6GCOr2Gcg0u.gz',NULL,3283,'application/g-zip',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3206,'4a20083b4b40de26e1f61463d524d87fb1bb8d5e','f3f434e047b3a6939adaf78dffb8afdd590be8ea',81,'mod_scorm','content',0,'/mobile/slides/','6AaNYpN80KZ.js',NULL,15863,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3207,'728aa741500d5de3bb242cb9e17ceef9161f5f8d','010127b421f722b10b17aca17a452d8b42bd3302',81,'mod_scorm','content',0,'/mobile/slides/','5X2ikUjdx3Y.js',NULL,15846,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3208,'b2947b9e818abd2a41edf656107be88d0ba4ba02','6e416a6f1f529b86a47f9d960cbd642befbc9129',81,'mod_scorm','content',0,'/mobile/slides/','5x0jma2XdxG.js',NULL,15864,'application/x-javascript',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3209,'8842f19842a03f0f8d7290a9ca24913b07b78dcf','db63790bd11e7af0234fcecf7b51f25e70d9cfaa',81,'mod_scorm','content',0,'/story_content/slides/','5ede4y4QOvr.swf',NULL,3543,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3210,'fdfc47a27e88b268f5bcdaec386717f7b14ba3d4','17f06dd4d813d44982f9cc519d1b87c3f1764bd5',81,'mod_scorm','content',0,'/story_content/slides/','5ftC9JS9TBd.swf',NULL,3556,'application/x-shockwave-flash',0,NULL,NULL,NULL,1462716825,1462716825,0,NULL),(3211,'f5f9c