<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    coursemerchant
 * @copyright  2013 Connected Shopping Ltd.
 * @license http://www.gnu.org/copyleft/gpl.html GNU Public License
 */

if (!defined('MOODLE_INTERNAL')) {
    die('Direct access to this script is forbidden.');    ///  It must be included from a Moodle page
}

require_once($CFG->libdir.'/authlib.php');
require_once($CFG->dirroot.'/auth/coursemerchant/lib.php');

/**
 * facebook authentication plugin.
 */
class auth_plugin_coursemerchant extends auth_plugin_base {

    /**
     * Constructor.
     */
    function auth_plugin_coursemerchant() {
        $this->authtype = 'coursemerchant';
    }

    /**
     * Returns false, this plugin does not do any authentication.
     *
     * @param string $username The username (with system magic quotes)
     * @param string $password The password (with system magic quotes)
     * @return bool Authentication success or failure.
     */
    function user_login ($username, $password) {
        return false;
    }

    /**
     * Returns true if this authentication plugin is 'internal'.
     *
     * @return bool
     */
    function is_internal() {
        return true;
    }

    function prelogout_hook() {
        global $CFG;

        if (!is_enabled_auth('coursemerchant')) {
            return;
        }
        cm_sso_helper::logout_notify();
    }

}